/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.io.FileNotFoundException;
import java.util.Formatter;
import java.util.Hashtable;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.point.standard.StandardTrajectoryCollectionImpl;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.sounding.CdmTrackInfo;
import ucar.unidata.data.sounding.TrackAdapter;
import ucar.unidata.data.sounding.TrackDataSource;

public class CdmTrackAdapter
extends TrackAdapter {
    public CdmTrackAdapter() throws Exception {
    }

    public CdmTrackAdapter(TrackDataSource dataSource, String filename, Hashtable pointDataFilter, int stride, int lastNMinutes) throws Exception {
        super(dataSource, filename, pointDataFilter, stride, lastNMinutes);
        FeatureDatasetPoint tod = null;
        Formatter buf = new Formatter();
        try {
            tod = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.TRAJECTORY, filename, null, buf);
        }
        catch (FileNotFoundException fnfe) {
            throw new BadDataException("Could not open data source:" + filename);
        }
        if (tod.getFeatureType() == null) {
            throw new BadDataException("Could not open trajectory file:" + filename);
        }
        List<DsgFeatureCollection> trajectories = tod.getPointFeatureCollectionList();
        for (StandardTrajectoryCollectionImpl standardTrajectoryCollectionImpl : trajectories) {
            for (TrajectoryFeature trajectoryFeature : standardTrajectoryCollectionImpl) {
                this.addTrackInfo(new CdmTrackInfo(this, tod, trajectoryFeature));
            }
        }
    }
}

