/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.sounding.RAOB;
import ucar.unidata.data.sounding.SoundingAdapter;
import ucar.unidata.data.sounding.SoundingAdapterImpl;
import ucar.unidata.data.sounding.SoundingLevelData;
import ucar.unidata.data.sounding.SoundingOb;
import ucar.unidata.data.sounding.SoundingStation;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.GeopotentialAltitude;
import ucar.visad.quantities.Gravity;
import visad.CommonUnit;
import visad.DateTime;
import visad.Unit;
import visad.VisADException;

public class CMASoundingAdapter
extends SoundingAdapterImpl
implements SoundingAdapter {
    String filename = null;
    List<List<SoundingLevelData>> soundingLevels;
    Unit heightUnit;
    private static final Unit GEOPOTENTIAL_UNIT;
    private List<SimpleDateFormat> formats;
    private static final String[] DATE_FORMATS;

    public CMASoundingAdapter() {
        super("CMASoundingAdapter");
    }

    public CMASoundingAdapter(String filename) throws Exception {
        super("CMASoundingAdapter");
        this.filename = filename;
        this.formats = new ArrayList<SimpleDateFormat>();
        for (String fmt : DATE_FORMATS) {
            SimpleDateFormat sdf = new SimpleDateFormat(fmt);
            sdf.setTimeZone(DateUtil.TIMEZONE_GMT);
            this.formats.add(sdf);
        }
        this.init();
    }

    public CMASoundingAdapter(File file) throws Exception {
        this(file.getAbsolutePath());
    }

    @Override
    public void update() {
        try {
            this.haveInitialized = false;
            this.init();
        }
        catch (Exception exc) {
            LogUtil.logException("Doing update", exc);
        }
    }

    private DateTime parseDate(String dttm) {
        dttm = dttm.trim();
        for (SimpleDateFormat sdf : this.formats) {
            try {
                Date date = sdf.parse(dttm);
                if (date == null) continue;
                return new DateTime(date);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Override
    protected void init() throws Exception {
        if (this.haveInitialized) {
            return;
        }
        super.init();
        this.times = new ArrayList();
        this.stations = new ArrayList();
        this.soundings = new ArrayList();
        this.soundingLevels = new ArrayList<List<SoundingLevelData>>();
        String s = IOUtil.readContents(this.filename);
        List<String> lines = StringUtil.split(s, "\n", true, true);
        int currentIndex = 0;
        String headerLine = lines.get(currentIndex++);
        String delim = headerLine.indexOf(",") >= 0 ? "," : " ";
        List<String> toks = StringUtil.split(headerLine, delim, true, true);
        while (currentIndex < lines.size()) {
            String dataLine;
            int tokNum;
            StringBuffer buf = new StringBuffer();
            for (tokNum = 0; tokNum < 3; ++tokNum) {
                buf.append(toks.get(tokNum));
                buf.append("-");
            }
            buf.append(toks.get(tokNum++));
            DateTime dt = this.parseDate(buf.toString());
            this.times.add(dt);
            int numStations = Integer.parseInt(toks.get(tokNum));
            int endPtsIndex = currentIndex + numStations;
            SoundingStation currentStation = null;
            ArrayList levels = null;
            int numFound = 0;
            while (numFound < numStations && currentIndex < lines.size() && (dataLine = lines.get(currentIndex++)) != null) {
                SoundingOb so;
                List<String> dtoks = StringUtil.split(dataLine, delim, true, true);
                int numToks = dtoks.size();
                if (numToks == 4) {
                    if (levels != null && levels.size() > 0) {
                        so = new SoundingOb(currentStation, dt);
                        this.soundings.add(so);
                        this.soundingLevels.add(levels);
                        ++numFound;
                    }
                    currentStation = this.makeSoundingStationList(dtoks);
                    levels = new ArrayList();
                    continue;
                }
                if (numToks == 6) {
                    this.appendLevelList(levels, dtoks);
                    continue;
                }
                if (numToks != 5) continue;
                if (levels != null && levels.size() > 0) {
                    so = new SoundingOb(currentStation, dt);
                    this.soundings.add(so);
                    this.soundingLevels.add(levels);
                    ++numFound;
                }
                toks = StringUtil.split(dataLine, delim, true, true);
                break;
            }
            if (currentIndex != lines.size()) continue;
            SoundingOb so = new SoundingOb(currentStation, dt);
            this.soundings.add(so);
            this.soundingLevels.add(levels);
            ++numFound;
        }
    }

    protected void initold() throws Exception {
        String data;
        if (this.haveInitialized) {
            return;
        }
        super.init();
        FileInputStream is = new FileInputStream(this.filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String info = br.readLine();
        String delim = info.indexOf(",") >= 0 ? "," : " ";
        StringTokenizer tok = new StringTokenizer(info, delim);
        int numToks = tok.countTokens();
        if (numToks != 5) {
            throw new Exception("Can't find date and number of stations");
        }
        StringBuffer buf = new StringBuffer();
        for (int tokNum = 0; tokNum < 3; ++tokNum) {
            buf.append(tok.nextToken());
            buf.append("-");
        }
        buf.append(tok.nextToken());
        DateTime dt = this.parseDate(buf.toString());
        this.times = new ArrayList(1);
        this.times.add(dt);
        int numStations = Integer.parseInt(tok.nextToken());
        this.stations = new ArrayList(numStations);
        this.soundings = new ArrayList(numStations);
        this.soundingLevels = new ArrayList<List<SoundingLevelData>>(numStations);
        SoundingStation currentStation = null;
        ArrayList levels = null;
        int numFound = 0;
        while ((data = br.readLine()) != null) {
            if (data.trim().equals("")) continue;
            tok = new StringTokenizer(data, delim);
            numToks = tok.countTokens();
            if (numToks == 4) {
                if (levels != null) {
                    SoundingOb so = new SoundingOb(currentStation, dt);
                    this.soundings.add(so);
                    this.soundingLevels.add(levels);
                    ++numFound;
                }
                currentStation = this.makeSoundingStation(tok);
                levels = new ArrayList();
                continue;
            }
            this.appendLevels(levels, tok);
        }
    }

    private void appendLevels(List<SoundingLevelData> levels, StringTokenizer tok) {
        if (levels == null) {
            return;
        }
        SoundingLevelData sld = new SoundingLevelData();
        float pressure = this.getValue(tok.nextToken());
        if (Double.isNaN(pressure)) {
            return;
        }
        sld.pressure = pressure;
        sld.height = this.getValue(tok.nextToken());
        sld.temperature = this.getValue(tok.nextToken());
        sld.dewpoint = this.getValue(tok.nextToken());
        sld.direction = this.getValue(tok.nextToken());
        sld.speed = this.getValue(tok.nextToken());
        try {
            if (this.heightUnit == null && !Double.isNaN(sld.height)) {
                float expected = AirPressure.getStandardAtmosphereCS().toReference(new float[][]{{sld.pressure}})[0][0];
                this.heightUnit = Math.abs(sld.height) > expected + 50.0f ? GEOPOTENTIAL_UNIT : GeopotentialAltitude.getGeopotentialMeter();
            }
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        levels.add(sld);
    }

    private void appendLevelList(List<SoundingLevelData> levels, List<String> toks) {
        if (levels == null) {
            return;
        }
        SoundingLevelData sld = new SoundingLevelData();
        float pressure = this.getValue(toks.get(0));
        if (Double.isNaN(pressure)) {
            return;
        }
        sld.pressure = pressure;
        sld.height = this.getValue(toks.get(1));
        sld.temperature = this.getValue(toks.get(2));
        sld.dewpoint = this.getValue(toks.get(3));
        sld.direction = this.getValue(toks.get(4));
        sld.speed = this.getValue(toks.get(5));
        try {
            if (this.heightUnit == null && !Double.isNaN(sld.height)) {
                float expected = AirPressure.getStandardAtmosphereCS().toReference(new float[][]{{sld.pressure}})[0][0];
                this.heightUnit = Math.abs(sld.height) > expected + 50.0f ? GEOPOTENTIAL_UNIT : GeopotentialAltitude.getGeopotentialMeter();
            }
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        levels.add(sld);
    }

    private float getValue(String s) {
        double val;
        try {
            val = Misc.parseDouble(s);
            if (val == 99999.9 || val == 999999.0) {
                val = Double.NaN;
            }
        }
        catch (NumberFormatException nfe) {
            val = Double.NaN;
        }
        return (float)val;
    }

    private SoundingStation makeSoundingStation(StringTokenizer tok) throws Exception {
        double elevvalue;
        double lonvalue;
        double latvalue;
        String wmoID;
        try {
            wmoID = new Integer((int)this.getValue(tok.nextToken())).toString();
            latvalue = this.getValue(tok.nextToken());
            lonvalue = this.getValue(tok.nextToken());
            elevvalue = this.getValue(tok.nextToken());
        }
        catch (Exception ne) {
            throw new Exception(ne.toString());
        }
        SoundingStation s = new SoundingStation(wmoID, latvalue, lonvalue, elevvalue);
        this.stations.add(s);
        return s;
    }

    private SoundingStation makeSoundingStationList(List<String> toks) throws Exception {
        double elevvalue;
        double lonvalue;
        double latvalue;
        String wmoID;
        try {
            wmoID = toks.get(0);
            latvalue = this.getValue(toks.get(1));
            lonvalue = this.getValue(toks.get(2));
            elevvalue = this.getValue(toks.get(3));
        }
        catch (Exception ne) {
            throw new Exception(ne.toString());
        }
        SoundingStation s = new SoundingStation(wmoID, latvalue, lonvalue, elevvalue);
        this.stations.add(s);
        return s;
    }

    protected void setRAOBData(SoundingOb so, List<SoundingLevelData> levels) {
        if (levels == null) {
            return;
        }
        int numLevels = levels.size();
        float[] pressures = new float[numLevels];
        float[] heights = new float[numLevels];
        float[] temps = new float[numLevels];
        float[] dewpts = new float[numLevels];
        float[] dirs = new float[numLevels];
        float[] speeds = new float[numLevels];
        for (int i = 0; i < numLevels; ++i) {
            SoundingLevelData sld = levels.get(i);
            pressures[i] = sld.pressure;
            heights[i] = sld.height;
            temps[i] = sld.temperature;
            dewpts[i] = sld.dewpoint;
            dirs[i] = sld.direction;
            speeds[i] = sld.speed;
        }
        try {
            if (this.heightUnit.equals(GEOPOTENTIAL_UNIT)) {
                float[] newHeights = GeopotentialAltitude.toAltitude(heights, GeopotentialAltitude.getGeopotentialUnit(CommonUnit.meter), Gravity.newReal(), new float[heights.length], CommonUnit.meter, true);
                heights = newHeights;
            }
            RAOB r = so.getRAOB();
            r.setMandatoryPressureProfile(CommonUnits.MILLIBAR, pressures, CommonUnits.CELSIUS, temps, CommonUnits.CELSIUS, dewpts, CommonUnit.meterPerSecond, speeds, CommonUnit.degree, dirs, GeopotentialAltitude.getGeopotentialUnit(CommonUnit.meter), heights);
        }
        catch (Exception excp) {
            System.err.println("Error:");
            excp.printStackTrace();
        }
    }

    @Override
    public SoundingOb initSoundingOb(SoundingOb sound) {
        this.checkInit();
        if (!sound.hasData()) {
            int idx = this.soundings.indexOf(sound);
            if (idx < 0) {
                throw new IllegalArgumentException("SoundingAdapter does not contain sounding:" + sound);
            }
            this.setRAOBData(sound, this.soundingLevels.get(idx));
        }
        return sound;
    }

    @Override
    public String getSource() {
        return this.filename;
    }

    @Override
    public void setSource(String s) {
        this.filename = s;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("must supply a filename");
            System.exit(1);
        }
        CMASoundingAdapter csa = new CMASoundingAdapter(args[0]);
    }

    static {
        DATE_FORMATS = new String[]{"yyyy-MM-dd-HH-mm", "yyyy-MM-dd-HH"};
        try {
            GEOPOTENTIAL_UNIT = DataUtil.parseUnit("m2/s2");
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

