/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ucar.ma2.Array;
import ucar.ma2.Index0D;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.NCdumpW;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.TrajectoryFeatureCollection;
import ucar.nc2.ft.point.StationFeature;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.VarInfo;
import ucar.unidata.data.point.PointObTuple;
import ucar.unidata.data.sounding.TrackInfo;
import ucar.unidata.data.sounding.TrajectoryFeatureTypeAdapter;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Station;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.Trace;
import ucar.visad.Util;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.Direction;
import visad.CommonUnit;
import visad.Data;
import visad.DateTime;
import visad.DerivedUnit;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.Text;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;

public abstract class CDMTrajectoryFeatureTypeInfo
extends TrackInfo {
    private static final String DATA_CHOOSER_TREE_NODE_BASIC = "Basic";
    private FeatureDatasetPoint fdp;
    List<PointFeature> obsList1 = null;
    double[] times;
    int positive = 1;
    private DsgFeatureCollection fc;
    private static String[] categoryAttributes = new String[]{"category", "group"};
    private Map<String, Unit> unitsCache = new ConcurrentHashMap<String, Unit>();
    TrajectoryFeatureBean trajBean = null;
    private Map<String, TrajectoryFeatureBean> beanCache = new ConcurrentHashMap<String, TrajectoryFeatureBean>();

    public CDMTrajectoryFeatureTypeInfo(TrajectoryFeatureTypeAdapter adapter, FeatureDatasetPoint dataset, DsgFeatureCollection fc) throws Exception {
        super(adapter, fc.getName());
        this.fdp = this.fdp;
        this.fc = fc;
    }

    @Override
    protected Unit getTimeUnit() throws Exception {
        return DataUtil.parseUnit(this.fc.getTimeUnit().toString());
    }

    private List<TrajectoryFeatureBean> getTrajectoryCollectionBeans(TrajectoryFeatureCollection trajCollection) throws IOException {
        ArrayList<TrajectoryFeatureBean> beans = new ArrayList<TrajectoryFeatureBean>();
        PointFeatureCollectionIterator iter = trajCollection.getPointFeatureCollectionIterator();
        while (iter.hasNext()) {
            PointFeatureCollection pob = iter.next();
            TrajectoryFeatureBean trajBean = new TrajectoryFeatureBean((TrajectoryFeature)pob);
            if (trajBean.pf == null) continue;
            beans.add(trajBean);
        }
        return beans;
    }

    protected TrajectoryFeatureBean initHelper(DsgFeatureCollection fc) throws IOException {
        TrajectoryFeatureBean trajBean = new TrajectoryFeatureBean((TrajectoryFeature)fc);
        this.beanCache.put(fc.getName(), trajBean);
        return trajBean;
    }

    protected void init(TrajectoryFeatureBean trajBean) throws Exception {
        StructureData pfsd = trajBean.pf.getFeatureData();
        this.trajBean = trajBean;
        List<StructureMembers.Member> members = pfsd.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            StructureMembers.Member mb = members.get(i);
            String ustr = mb.getUnitsString();
            Unit unit = null;
            if (ustr != null && !ustr.equalsIgnoreCase("none")) {
                if (this.unitsCache.get(ustr) != null) {
                    unit = this.unitsCache.get(ustr);
                } else {
                    try {
                        unit = Util.parseUnit(ustr);
                    }
                    catch (VisADException e) {
                        unit = null;
                    }
                    if (unit != null) {
                        this.unitsCache.put(ustr, unit);
                    }
                }
            }
            if (unit != null && unit.isConvertible(CommonUnit.secondsSinceTheEpoch) && !(unit instanceof DerivedUnit)) {
                this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), DATA_CHOOSER_TREE_NODE_BASIC, unit));
                this.varTime = mb.getName();
                continue;
            }
            if (unit != null && unit.isConvertible(CommonUnits.KILOMETER)) {
                if (mb.getName().equalsIgnoreCase("ALTITUDE") || mb.getName().equalsIgnoreCase("ALT")) {
                    this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), DATA_CHOOSER_TREE_NODE_BASIC, unit));
                    this.varAltitude = mb.getName();
                    continue;
                }
                if (mb.getName().equalsIgnoreCase("DEPTH")) {
                    this.positive = -1;
                    this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), DATA_CHOOSER_TREE_NODE_BASIC, unit));
                    this.varAltitude = mb.getName();
                    continue;
                }
                this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), unit));
                this.addVariableData(mb.getName(), mb.getDataArray().copy());
                continue;
            }
            if (unit != null && unit.isConvertible(CommonUnits.DEGREE)) {
                if (mb.getName().equalsIgnoreCase("LATITUDE") || mb.getName().equalsIgnoreCase("LAT")) {
                    this.varLatitude = mb.getName();
                    this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), DATA_CHOOSER_TREE_NODE_BASIC, unit));
                    continue;
                }
                if (mb.getName().equalsIgnoreCase("LONGITUDE") || mb.getName().equalsIgnoreCase("LON")) {
                    this.varLongitude = mb.getName();
                    this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), DATA_CHOOSER_TREE_NODE_BASIC, unit));
                    continue;
                }
                this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), unit));
                this.addVariableData(mb.getName(), mb.getDataArray().copy());
                continue;
            }
            this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), unit));
            this.addVariableData(mb.getName(), mb.getDataArray().copy());
        }
        Range rg = this.getDataRange();
        this.times = this.getTime(rg);
        this.startTime = this.getStartTime();
        this.endTime = this.getEndTime();
    }

    @Override
    protected Range getDataRange() throws Exception {
        Range range = new Range(0, this.trajBean.pfs.size() - 1);
        return range;
    }

    @Override
    public int getNumberPoints() {
        return this.trajBean.pfs.size();
    }

    @Override
    protected double[] getTime(Range range) throws Exception {
        if (this.times == null) {
            this.times = this.getDoubleData(range, this.varTime);
        }
        return this.times;
    }

    @Override
    public double[] getTimeVals(Range range) throws Exception {
        return this.getTime(range);
    }

    @Override
    public DateTime getStartTime() {
        if (this.startTime == null) {
            try {
                this.startTime = new DateTime(this.times[0], this.getTimeUnit());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.startTime;
    }

    @Override
    public DateTime getEndTime() {
        if (this.endTime == null) {
            try {
                this.endTime = new DateTime(this.times[this.times.length - 1], this.getTimeUnit());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.endTime;
    }

    private void testit() {
        try {
            Trace.call1("TrackInfo.rowRead-new");
            Trace.call2("TrackInfo.rowRead-new");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void test1() throws Exception {
        Range range = this.getFullRange();
        int numVars = this.variables.size();
        int varCnt = 0;
        for (int varIdx = 0; varIdx < numVars; ++varIdx) {
            VarInfo var = (VarInfo)this.variables.get(varIdx);
            this.getFloatData(range, var.getShortName());
            ++varCnt;
        }
        Trace.msg("Column read #vars:" + varCnt);
    }

    @Override
    protected float[] getAltitude(Range range) throws Exception {
        float[] fdata = new float[range.length()];
        return this.trajBean.getAltitudes(range);
    }

    @Override
    protected float[] getLatitude(Range range) throws Exception {
        float[] fdata = new float[range.length()];
        return this.trajBean.getLatitudes(range);
    }

    @Override
    protected float[] getLongitude(Range range) throws Exception {
        float[] fdata = new float[range.length()];
        return this.trajBean.getLongitudes(range);
    }

    @Override
    public float[] getFloatData(Range range, String var) throws Exception {
        this.trajBean = this.beanCache.get(this.fc.getName());
        this.trajBean.setPfs();
        Range range1 = new Range(0, this.trajBean.npts - 1);
        return this.trajBean.getFloatData(range1, var);
    }

    @Override
    public double[] getDoubleData(Range range, String var) throws Exception {
        this.trajBean = this.beanCache.get(this.fc.getName());
        this.trajBean.setPfs();
        return this.trajBean.getDoubleData(range, var);
    }

    @Override
    public String[] getStringData(Range range, String var) throws Exception {
        return this.trajBean.getStringData(range, var);
    }

    @Override
    public synchronized FieldImpl getPointObTrack(Range range) throws Exception {
        double[] realArray;
        Data[] tupleArray;
        Trace.call1("TrackAdapter.getPointObTrack");
        Object loadId = JobManager.getManager().startLoad("TrackAdapter");
        if (range == null) {
            range = this.getFullRange();
        }
        float[] lats = this.getLatitude(range);
        float[] lons = this.getLongitude(range);
        float[] alts = this.getAltitude(range);
        double[] timeVals = this.getTimeVals(range);
        int numObs = lats.length;
        timeVals = CommonUnit.secondsSinceTheEpoch.toThis(timeVals, this.getTimeUnit());
        List<VarInfo> varsToUse = this.getVarsToUse();
        int numReals = this.countReals(varsToUse);
        int numStrings = varsToUse.size() - numReals;
        boolean allReals = numStrings == 0;
        int numVars = varsToUse.size();
        Unit[] units = new Unit[numVars];
        for (int varIdx = 0; varIdx < numVars; ++varIdx) {
            VarInfo var = varsToUse.get(varIdx);
            units[varIdx] = var.getUnit();
        }
        Trace.msg("TrackAdapter #obs: " + this.getNumberPoints() + " vars:" + numVars);
        RealType dirType = Direction.getRealType();
        EarthLocationTuple lastEL = null;
        ArrayList<EarthLocationTuple> locations = new ArrayList<EarthLocationTuple>();
        ArrayList<DateTime> times = new ArrayList<DateTime>();
        ArrayList<Data[]> tuples = new ArrayList<Data[]>();
        ArrayList<double[]> reals = new ArrayList<double[]>();
        ArrayList<String[]> strings = new ArrayList<String[]>();
        ArrayList<Real> bearings = new ArrayList<Real>();
        ArrayList stringTypeList = new ArrayList();
        for (int obIdx = 0; obIdx < numObs; ++obIdx) {
            EarthLocationTuple location = new EarthLocationTuple(new Real(RealType.Latitude, (double)lats[obIdx]), new Real(RealType.Longitude, (double)lons[obIdx]), new Real(RealType.Altitude, (double)alts[obIdx]));
            if (obIdx == 0) {
                lastEL = location;
            }
            locations.add(location);
            double dirVal = Util.calculateBearing(lastEL, location).getAngle();
            lastEL = location;
            Real bearing = new Real(dirType, dirVal);
            bearings.add(bearing);
            times.add(new DateTime(timeVals[obIdx]));
            tupleArray = allReals ? new Real[numVars + 1] : new Data[numVars + 1];
            tuples.add(tupleArray);
            realArray = new double[numReals + 1];
            reals.add(realArray);
            realArray[realArray.length - 1] = dirVal;
            strings.add(new String[numStrings]);
        }
        Trace.call1("TrackAdapter.reading data");
        boolean doColumnOriented = true;
        if (doColumnOriented) {
            int realCnt = 0;
            int stringCnt = 0;
            for (int varIdx = 0; varIdx < numVars; ++varIdx) {
                if (!JobManager.getManager().canContinue(loadId)) {
                    return null;
                }
                VarInfo var = varsToUse.get(varIdx);
                if (var.getIsNumeric()) {
                    double[] dvalues = this.getDoubleData(range, var.getShortName());
                    if (var.getRealType() == null) {
                        // empty if block
                    }
                    Data[] firstTuple = null;
                    for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                        Data[] tupleArray2 = (Data[])tuples.get(obIdx);
                        ((double[])reals.get((int)obIdx))[realCnt] = dvalues[obIdx];
                        if (firstTuple != null) {
                            tupleArray2[varIdx] = ((Real)firstTuple[varIdx]).cloneButValue(dvalues[obIdx]);
                            continue;
                        }
                        firstTuple = tupleArray2;
                        tupleArray2[varIdx] = var.getUnit() == null ? new Real(var.getRealType(), dvalues[obIdx]) : new Real(var.getRealType(), dvalues[obIdx], var.getUnit());
                    }
                    ++realCnt;
                    continue;
                }
                String[] svalues = this.getStringData(range, var.getShortName());
                for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                    Data[] tupleArray3 = (Data[])tuples.get(obIdx);
                    tupleArray3[varIdx] = new Text(svalues[obIdx]);
                    ((String[])strings.get((int)obIdx))[stringCnt] = svalues[obIdx];
                }
                ++stringCnt;
            }
        } else {
            Index0D scalarIndex = new Index0D(new int[0]);
            for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                if (!JobManager.getManager().canContinue(loadId)) {
                    return null;
                }
                StructureData structure = null;
                List<StructureMembers.Member> members = structure.getMembers();
                tupleArray = (Data[])tuples.get(obIdx);
                realArray = (double[])reals.get(obIdx);
                String[] stringArray = (String[])strings.get(obIdx);
                int numMembers = members.size();
                int varCnt = 0;
                int realCnt = 0;
                int stringCnt = 0;
                for (int varIdx = 0; varIdx < numVars; ++varIdx) {
                    VarInfo var = varsToUse.get(varIdx);
                    StructureMembers.Member member = structure.findMember(var.getShortName());
                    if (!var.getIsNumeric()) {
                        String value = new String(DataUtil.toCharArray(structure.getArray(member)));
                        stringArray[stringCnt++] = value;
                        tupleArray[varCnt] = new Text(value);
                    } else {
                        float value = structure.convertScalarFloat(member);
                        realArray[realCnt++] = value;
                        tupleArray[varCnt] = var.getUnit() == null ? new Real(var.getRealType(), (double)value) : new Real(var.getRealType(), value, var.getUnit());
                    }
                    ++varCnt;
                }
            }
        }
        Trace.call2("TrackAdapter.reading data");
        Trace.call1("TrackAdapter.processing data", " all reals?" + allReals);
        Data[] obs = new PointObTuple[locations.size()];
        TupleType tt = null;
        RealTupleType rtt = null;
        TupleType finalTT = null;
        for (int obIdx = 0; obIdx < obs.length; ++obIdx) {
            Data[] tupleArray4 = (Data[])tuples.get(obIdx);
            double[] realArray2 = (double[])reals.get(obIdx);
            String[] stringArray = (String[])strings.get(obIdx);
            tupleArray4[tupleArray4.length - 1] = (Data)bearings.get(obIdx);
            if (tt == null) {
                tt = Tuple.buildTupleType(tupleArray4);
                if (allReals) {
                    rtt = (RealTupleType)tt;
                }
            }
            Tuple rest = allReals ? new RealTuple(rtt, (Real[])tupleArray4, null, units, false) : new Tuple(tt, tupleArray4, false, false);
            PointObTuple pot = null;
            if (finalTT == null) {
                pot = new PointObTuple((EarthLocation)locations.get(obIdx), (DateTime)times.get(obIdx), rest);
                finalTT = Tuple.buildTupleType(pot.getComponents());
            } else {
                pot = new PointObTuple((EarthLocation)locations.get(obIdx), (DateTime)times.get(obIdx), rest, finalTT, false);
            }
            obs[obIdx] = pot;
        }
        Trace.call2("TrackAdapter.processing data");
        Integer1DSet indexSet = new Integer1DSet((MathType)RealType.getRealType("index"), numObs);
        FieldImpl retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), obs[0].getType()), indexSet);
        retField.setSamples(obs, false, false);
        Trace.call2("TrackAdapter.getPointObTrack");
        return retField;
    }

    public static class TrajectoryFeatureTypeInfo
    extends CDMTrajectoryFeatureTypeInfo {
        private TrajectoryFeatureCollection tfc;

        public TrajectoryFeatureTypeInfo(TrajectoryFeatureTypeAdapter adapter, FeatureDatasetPoint dataset, TrajectoryFeatureCollection tfc) throws Exception {
            super(adapter, dataset, tfc);
            this.tfc = tfc;
            TrajectoryFeatureBean trajBean = null;
            PointFeatureCollectionIterator iter = tfc.getPointFeatureCollectionIterator();
            while (iter.hasNext()) {
                trajBean = this.initHelper(iter.next());
            }
            this.init(trajBean);
        }

        @Override
        protected Unit getTimeUnit() throws Exception {
            return DataUtil.parseUnit("days since 1950-01-01T00:00:00Z");
        }
    }

    public static class PointFeatureTypeInfo
    extends CDMTrajectoryFeatureTypeInfo {
        private PointFeatureCollection pfc;

        public PointFeatureTypeInfo(TrajectoryFeatureTypeAdapter adapter, FeatureDatasetPoint dataset, PointFeatureCollection pfc) throws Exception {
            super(adapter, dataset, pfc);
            this.pfc = pfc;
            this.init(this.initHelper(pfc));
        }

        @Override
        protected Unit getTimeUnit() throws Exception {
            String timeUnitString = super.getTimeUnit().toString();
            return DataUtil.parseUnit(timeUnitString);
        }
    }

    public static class TrajectoryFeatureBean
    extends StationBean {
        int npts;
        TrajectoryFeature pfc;
        PointFeature pf;
        List<PointFeature> pfs;
        StructureData sdata;

        public TrajectoryFeatureBean(TrajectoryFeature pfc) throws IOException {
            this.pfc = pfc;
            this.sdata = pfc.getFeatureData();
            this.pfs = new ArrayList<PointFeature>();
            try {
                while (pfc.hasNext()) {
                    this.pfs.add(pfc.next());
                }
                this.pf = this.pfs.get(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.npts = pfc.size();
        }

        public void setPfs() {
            try {
                this.pfc.resetIteration();
                this.pfs = new ArrayList<PointFeature>();
                while (this.pfc.hasNext()) {
                    this.pfs.add(this.pfc.next());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public static String hiddenProperties() {
            return "latLon";
        }

        @Override
        public void setNobs(int npts) {
            this.npts = npts;
        }

        @Override
        public int getNobs() {
            return this.npts;
        }

        @Override
        public String getName() {
            return this.pfc.getName();
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getWmoId() {
            return null;
        }

        @Override
        public double getLatitude() {
            return this.pf.getLocation().getLatitude();
        }

        @Override
        public double getLongitude() {
            return this.pf.getLocation().getLongitude();
        }

        @Override
        public double getAltitude() {
            return this.pf.getLocation().getAltitude();
        }

        @Override
        public LatLonPoint getLatLon() {
            return this.pf.getLocation().getLatLon();
        }

        @Override
        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }

        @Override
        public boolean isMissing() {
            return Double.isNaN(this.getLatitude());
        }

        public double[] getTimes(Range range) {
            double[] fdata = new double[range.length()];
            int first = range.first();
            int stride = range.stride();
            int last = range.last();
            int j = 0;
            for (int i = first; i <= last; i += stride) {
                PointFeature pf0 = this.pfs.get(i);
                fdata[j++] = pf0.getObservationTime();
            }
            return fdata;
        }

        public float[] getLatitudes(Range range) {
            float[] fdata = new float[range.length()];
            int first = range.first();
            int stride = range.stride();
            int last = range.last();
            int j = 0;
            for (int i = first; i <= last; i += stride) {
                PointFeature pf0 = this.pfs.get(i);
                fdata[j++] = (float)pf0.getLocation().getLatitude();
            }
            return fdata;
        }

        public float[] getLongitudes(Range range) {
            float[] fdata = new float[range.length()];
            int first = range.first();
            int stride = range.stride();
            int last = range.last();
            int j = 0;
            for (int i = first; i <= last; i += stride) {
                PointFeature pf0 = this.pfs.get(i);
                fdata[j++] = (float)pf0.getLocation().getLongitude();
            }
            return fdata;
        }

        public float[] getAltitudes(Range range) {
            float[] fdata = new float[range.length()];
            int first = range.first();
            int stride = range.stride();
            int last = range.last();
            int j = 0;
            for (int i = first; i <= last; i += stride) {
                PointFeature pf0 = this.pfs.get(i);
                fdata[j++] = Double.isNaN(pf0.getLocation().getAltitude()) ? 0.0f : (float)pf0.getLocation().getAltitude();
            }
            return fdata;
        }

        public float[] getFloatData(Range range, String varStr) throws Exception {
            float[] fdata = new float[range.length()];
            int first = range.first();
            int stride = range.stride();
            int last = range.last();
            int j = 0;
            for (int i = first; i <= last; i += stride) {
                PointFeature pf0 = this.pfs.get(i);
                StructureData std = pf0.getFeatureData();
                Array a = std.getArray(varStr);
                fdata[j++] = a.getFloat(0);
            }
            return fdata;
        }

        public double[] getDoubleData(Range range, String varStr) throws Exception {
            double[] fdata = new double[range.length()];
            int first = range.first();
            int stride = range.stride();
            int last = range.last();
            int j = 0;
            for (int i = first; i <= last; i += stride) {
                PointFeature pf0 = this.pfs.get(i);
                StructureData std = pf0.getFeatureData();
                Array a = std.getArray(varStr);
                fdata[j++] = a.getDouble(0);
            }
            return fdata;
        }

        public String[] getStringData(Range range, String varStr) throws Exception {
            String[] fdata = new String[range.length()];
            return fdata;
        }
    }

    public static class StationBean
    extends FeatureBean
    implements Station {
        private StationFeature stnFeat;
        private int npts = -1;

        public StationBean() {
        }

        public StationBean(StructureData sdata) throws IOException {
            super(sdata);
        }

        public StationBean(Station s) throws IOException {
            super(((StationFeature)s).getFeatureData());
            this.stnFeat = (StationFeature)s;
            this.npts = s.getNobs();
        }

        public static String hiddenProperties() {
            return "latLon";
        }

        @Override
        public int getNobs() {
            return this.npts;
        }

        public void setNobs(int npts) {
            this.npts = npts;
        }

        @Override
        public String getWmoId() {
            return this.stnFeat.getWmoId();
        }

        @Override
        public String getName() {
            return this.stnFeat.getName();
        }

        @Override
        public String getDescription() {
            return this.stnFeat.getDescription();
        }

        @Override
        public double getLatitude() {
            return this.stnFeat.getLatitude();
        }

        @Override
        public double getLongitude() {
            return this.stnFeat.getLongitude();
        }

        @Override
        public double getAltitude() {
            return this.stnFeat.getAltitude();
        }

        @Override
        public LatLonPoint getLatLon() {
            return this.stnFeat.getLatLon();
        }

        @Override
        public boolean isMissing() {
            return this.stnFeat.isMissing();
        }

        @Override
        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }
    }

    public static class FeatureBean {
        StructureData sdata;
        String fields;

        public FeatureBean() {
        }

        FeatureBean(StructureData sdata) throws IOException {
            this.sdata = sdata;
            this.fields = NCdumpW.toString(sdata);
        }

        public String getFields() {
            return this.fields;
        }

        public String showFields() {
            StringWriter sw = new StringWriter(10000);
            NCdumpW.printStructureData(new PrintWriter(sw), this.sdata);
            return sw.toString();
        }
    }
}

