/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.StationProfileFeatureCollection;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.sounding.RAOB;
import ucar.unidata.data.sounding.SoundingAdapter;
import ucar.unidata.data.sounding.SoundingAdapterImpl;
import ucar.unidata.data.sounding.SoundingLevelData;
import ucar.unidata.data.sounding.SoundingOb;
import ucar.unidata.data.sounding.SoundingStation;
import ucar.unidata.util.LogUtil;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.GeopotentialAltitude;
import visad.CommonUnit;
import visad.DateTime;
import visad.SI;
import visad.VisADException;

public class CDMStationProfileAdapter
extends SoundingAdapterImpl
implements SoundingAdapter {
    private static final String MXWC = "MXWC";
    private static final String TTCC = "TTCC";
    private static final String PPBB = "PPBB";
    private static final String TTBB = "TTBB";
    private static final String HGHT = "HGHT";
    private static final String DRCT = "DRCT";
    private static final String SPED = "SPED";
    private static final String DWPT = "DWPT";
    private static final String TEMP = "TEMP";
    private static final String PRES = "PRES";
    private List<List<SoundingLevelData>> soundingLevels;
    private String filename;

    public CDMStationProfileAdapter() {
        super("CDMStationProfileAdapter");
    }

    public CDMStationProfileAdapter(String filename) {
        super(filename);
        this.filename = filename;
    }

    public CDMStationProfileAdapter(File file) {
        this(file.getAbsolutePath());
    }

    @Override
    protected void init() throws Exception {
        if (this.haveInitialized) {
            return;
        }
        super.init();
        this.times = new ArrayList();
        this.stations = new ArrayList();
        this.soundings = new ArrayList();
        this.soundingLevels = new ArrayList<List<SoundingLevelData>>();
        LinkedHashSet<DateTime> timeSet = new LinkedHashSet<DateTime>();
        FeatureDatasetPoint fdp = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION_PROFILE, this.filename, null, new Formatter());
        StationProfileFeatureCollection pfc = (StationProfileFeatureCollection)fdp.getPointFeatureCollectionList().get(0);
        while (pfc.hasNext()) {
            StationProfileFeature profile = pfc.next();
            while (profile.hasNext()) {
                ProfileFeature pf = profile.next();
                ArrayList<SoundingLevelData> sld = new ArrayList<SoundingLevelData>();
                boolean first = true;
                while (pf.hasNext()) {
                    PointFeature p = pf.next();
                    StructureData data = p.getFeatureData();
                    sld.add(this.mandatoryLevels(data));
                    if (!first) continue;
                    sld.addAll(this.ttbb(data));
                    sld.addAll(this.ppbb(data));
                    sld.addAll(this.ttcc(data));
                    sld.addAll(this.mxwc(data));
                    first = false;
                }
                SoundingStation soundingStation = new SoundingStation(profile.getName(), profile.getLatLon().getLatitude(), profile.getLatLon().getLongitude(), 0.0);
                this.stations.add(soundingStation);
                SoundingOb so = new SoundingOb(soundingStation, new DateTime(pf.getTime().toDate()));
                timeSet.add(new DateTime(pf.getTime().toDate()));
                this.soundings.add(so);
                this.soundingLevels.add(sld);
            }
        }
        this.times.addAll(timeSet);
    }

    private SoundingLevelData mandatoryLevels(StructureData data) {
        SoundingLevelData sl = new SoundingLevelData();
        if (data.findMember(PRES) != null) {
            sl.pressure = (data.findMember(PRES) == null ? null : Float.valueOf(data.getScalarFloat(data.findMember(PRES)))).floatValue();
            sl.temperature = (data.findMember(TEMP) == null ? null : Float.valueOf(data.getScalarFloat(data.findMember(TEMP)))).floatValue();
            sl.dewpoint = (data.findMember(DWPT) == null ? null : Float.valueOf(data.getScalarFloat(data.findMember(DWPT)))).floatValue();
            sl.speed = (data.findMember(SPED) == null ? null : Float.valueOf(data.getScalarFloat(data.findMember(SPED)))).floatValue();
            sl.direction = (data.findMember(DRCT) == null ? null : Float.valueOf(data.getScalarFloat(data.findMember(DRCT)))).floatValue();
            sl.height = (data.findMember(HGHT) == null ? null : Float.valueOf(data.getScalarFloat(data.findMember(HGHT)))).floatValue();
        } else {
            List<StructureMembers.Member> smembers = data.getMembers();
            int size = smembers.size();
            for (int i = 0; i < size; ++i) {
                StructureMembers.Member member = smembers.get(i);
                String name = member.getName();
                String canonical = DataAlias.aliasToCanonical(name);
                if (canonical == null) continue;
                if (canonical.equals("PRESSURE")) {
                    sl.pressure = data.getScalarFloat(member);
                    continue;
                }
                if (canonical.equals(TEMP)) {
                    sl.temperature = data.getScalarFloat(member);
                    continue;
                }
                if (canonical.equals("DEWPOINT")) {
                    sl.dewpoint = data.getScalarFloat(member);
                    continue;
                }
                if (canonical.equals("SPEED")) {
                    sl.speed = data.getScalarFloat(member);
                    continue;
                }
                if (!canonical.equals("DIR")) continue;
                sl.direction = data.getScalarFloat(member);
            }
        }
        return sl;
    }

    private Collection<? extends SoundingLevelData> ttbb(StructureData data) throws IOException {
        LinkedList<SoundingLevelData> sld = new LinkedList<SoundingLevelData>();
        StructureMembers.Member d = data.findMember(TTBB);
        if (d != null) {
            Array dwpt;
            ArraySequence ttbb = data.getArraySequence(d);
            Array pres = ttbb.findMember(PRES) == null ? null : ttbb.extractMemberArray(ttbb.findMember(PRES));
            Array temp = ttbb.findMember(TEMP) == null ? null : ttbb.extractMemberArray(ttbb.findMember(TEMP));
            Array array = dwpt = ttbb.findMember(DWPT) == null ? null : ttbb.extractMemberArray(ttbb.findMember(DWPT));
            if (pres != null) {
                int i = 0;
                while ((long)i < pres.getSize()) {
                    SoundingLevelData sl = new SoundingLevelData();
                    sl.pressure = pres.getFloat(i);
                    sl.temperature = temp == null ? Float.NaN : temp.getFloat(i);
                    sl.dewpoint = dwpt == null ? Float.NaN : dwpt.getFloat(i);
                    sl.speed = Float.NaN;
                    sl.direction = Float.NaN;
                    sl.height = Float.NaN;
                    sld.add(sl);
                    ++i;
                }
            }
        }
        return sld;
    }

    private Collection<? extends SoundingLevelData> ppbb(StructureData data) throws IOException {
        LinkedList<SoundingLevelData> sld = new LinkedList<SoundingLevelData>();
        StructureMembers.Member d = data.findMember(PPBB);
        if (d != null) {
            Array hght;
            ArraySequence ppbb = data.getArraySequence(d);
            Array sped = ppbb.findMember(SPED) == null ? null : ppbb.extractMemberArray(ppbb.findMember(SPED));
            Array drct = ppbb.findMember(DRCT) == null ? null : ppbb.extractMemberArray(ppbb.findMember(DRCT));
            Array array = hght = ppbb.findMember(HGHT) == null ? null : ppbb.extractMemberArray(ppbb.findMember(HGHT));
            if (hght != null) {
                int i = 0;
                while ((long)i < hght.getSize()) {
                    SoundingLevelData sl = new SoundingLevelData();
                    sl.pressure = hght.getFloat(i);
                    sl.temperature = Float.NaN;
                    sl.dewpoint = Float.NaN;
                    sl.speed = sped == null ? Float.NaN : sped.getFloat(i);
                    sl.direction = drct == null ? Float.NaN : drct.getFloat(i);
                    sl.height = Float.NaN;
                    sld.add(sl);
                    ++i;
                }
            }
        }
        return sld;
    }

    private Collection<? extends SoundingLevelData> ttcc(StructureData data) throws IOException {
        LinkedList<SoundingLevelData> sld = new LinkedList<SoundingLevelData>();
        StructureMembers.Member d = data.findMember(TTCC);
        if (d != null) {
            Array hght;
            ArraySequence ttcc = data.getArraySequence(d);
            Array pres = ttcc.findMember(PRES) == null ? null : ttcc.extractMemberArray(ttcc.findMember(PRES));
            Array temp = ttcc.findMember(TEMP) == null ? null : ttcc.extractMemberArray(ttcc.findMember(TEMP));
            Array dwpt = ttcc.findMember(DWPT) == null ? null : ttcc.extractMemberArray(ttcc.findMember(DWPT));
            Array sped = ttcc.findMember(SPED) == null ? null : ttcc.extractMemberArray(ttcc.findMember(SPED));
            Array drct = ttcc.findMember(DRCT) == null ? null : ttcc.extractMemberArray(ttcc.findMember(DRCT));
            Array array = hght = ttcc.findMember(HGHT) == null ? null : ttcc.extractMemberArray(ttcc.findMember(HGHT));
            if (hght != null) {
                int i = 0;
                while ((long)i < hght.getSize()) {
                    SoundingLevelData sl = new SoundingLevelData();
                    sl.pressure = pres == null ? Float.NaN : pres.getFloat(i);
                    sl.temperature = temp == null ? Float.NaN : temp.getFloat(i);
                    sl.dewpoint = dwpt == null ? Float.NaN : dwpt.getFloat(i);
                    sl.speed = sped == null ? Float.NaN : sped.getFloat(i);
                    sl.direction = drct == null ? Float.NaN : drct.getFloat(i);
                    sl.height = hght.getFloat(i);
                    sld.add(sl);
                    ++i;
                }
            }
        }
        return sld;
    }

    private Collection<? extends SoundingLevelData> mxwc(StructureData data) throws IOException {
        LinkedList<SoundingLevelData> sld = new LinkedList<SoundingLevelData>();
        StructureMembers.Member d = data.findMember(MXWC);
        if (d != null) {
            Array pres;
            ArraySequence mxwc = data.getArraySequence(d);
            Array sped = mxwc.findMember(SPED) == null ? null : mxwc.extractMemberArray(mxwc.findMember(SPED));
            Array drct = mxwc.findMember(DRCT) == null ? null : mxwc.extractMemberArray(mxwc.findMember(DRCT));
            Array array = pres = mxwc.findMember(PRES) == null ? null : mxwc.extractMemberArray(mxwc.findMember(PRES));
            if (pres != null) {
                int i = 0;
                while ((long)i < pres.getSize()) {
                    SoundingLevelData sl = new SoundingLevelData();
                    sl.pressure = pres.getFloat(i);
                    sl.temperature = Float.NaN;
                    sl.dewpoint = Float.NaN;
                    sl.speed = sped == null ? Float.NaN : sped.getFloat(i);
                    sl.direction = drct == null ? Float.NaN : drct.getFloat(i);
                    sl.height = Float.NaN;
                    sld.add(sl);
                    ++i;
                }
            }
        }
        return sld;
    }

    @Override
    public void update() {
        try {
            this.haveInitialized = false;
            this.init();
        }
        catch (Exception exc) {
            LogUtil.logException("Doing update", exc);
        }
    }

    @Override
    public String getSource() {
        return this.filename;
    }

    @Override
    public void setSource(String s) {
        this.filename = s;
    }

    @Override
    public SoundingOb initSoundingOb(SoundingOb sound) {
        this.checkInit();
        if (!sound.hasData()) {
            int idx = this.soundings.indexOf(sound);
            if (idx < 0) {
                throw new IllegalArgumentException("SoundingAdapter does not contain sounding:" + sound);
            }
            this.setRAOBData(sound, this.soundingLevels.get(idx));
        }
        return sound;
    }

    private void setRAOBData(SoundingOb sound, List<? extends SoundingLevelData> levels) {
        float[] pressures = new float[levels.size()];
        float[] temps = new float[levels.size()];
        float[] dewpts = new float[levels.size()];
        float[] speeds = new float[levels.size()];
        float[] dirs = new float[levels.size()];
        float[] heights = new float[levels.size()];
        for (int i = 0; i < levels.size(); ++i) {
            pressures[i] = levels.get((int)i).pressure;
            temps[i] = levels.get((int)i).temperature;
            dewpts[i] = levels.get((int)i).dewpoint;
            speeds[i] = levels.get((int)i).speed;
            dirs[i] = levels.get((int)i).direction;
            heights[i] = levels.get((int)i).height;
        }
        RAOB r = sound.getRAOB();
        try {
            if (temps[0] > 200.0f && dewpts[0] > 200.0f) {
                r.setMandatoryPressureProfile(CommonUnits.MILLIBAR, pressures, SI.kelvin, temps, SI.kelvin, dewpts, CommonUnit.meterPerSecond, speeds, CommonUnit.degree, dirs, GeopotentialAltitude.getGeopotentialUnit(CommonUnit.meter), heights);
            } else {
                r.setMandatoryPressureProfile(CommonUnits.MILLIBAR, pressures, CommonUnits.CELSIUS, temps, CommonUnits.CELSIUS, dewpts, CommonUnit.meterPerSecond, speeds, CommonUnit.degree, dirs, GeopotentialAltitude.getGeopotentialUnit(CommonUnit.meter), heights);
            }
        }
        catch (PropertyVetoException | RemoteException | VisADException e) {
            System.err.println("Error:");
            e.printStackTrace();
        }
    }
}

