/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ucar.ma2.Array;
import ucar.ma2.Index0D;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.NCdumpW;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.ProfileFeatureCollection;
import ucar.nc2.ft.point.StationFeature;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.VarInfo;
import ucar.unidata.data.point.PointObTuple;
import ucar.unidata.data.sounding.TrackAdapter;
import ucar.unidata.data.sounding.TrackInfo;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Station;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.Trace;
import ucar.visad.Util;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.Direction;
import visad.CommonUnit;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.Text;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;

public class CDMProfileFeatureTypeInfo
extends TrackInfo {
    private FeatureDatasetPoint fdp;
    ProfileFeatureCollection pfc;
    ProfileFeature pf;
    List<PointFeature> obsList;
    double[] times;
    int positive = 1;
    private int maxCount = Integer.MAX_VALUE;
    private int nptsTotal = 0;
    private Map<String, ProfileFeatureBean> beanCache = new ConcurrentHashMap<String, ProfileFeatureBean>();
    Unit[] units = new Unit[3];
    private static String[] categoryAttributes = new String[]{"category", "group"};

    public CDMProfileFeatureTypeInfo(TrackAdapter adapter, FeatureDatasetPoint fdp, ProfileFeatureCollection pfc) throws Exception {
        super(adapter, pfc.getName());
        this.fdp = fdp;
        this.pfc = pfc;
        this.init();
    }

    public CDMProfileFeatureTypeInfo(TrackAdapter adapter, FeatureDatasetPoint fdp, ProfileFeature pf) throws Exception {
        super(adapter, pf.getName());
        this.fdp = fdp;
        this.pfc = null;
        this.pf = pf;
        this.initPF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws Exception {
        PointFeatureCollectionIterator iter = this.pfc.getPointFeatureCollectionIterator();
        this.obsList = new ArrayList<PointFeature>();
        ProfileFeatureBean profBean = null;
        boolean iii = false;
        int count = 0;
        while (iter.hasNext()) {
            PointFeatureCollection pob = iter.next();
            profBean = new ProfileFeatureBean((ProfileFeature)pob);
            this.nptsTotal += pob.size();
            try (PointFeatureIterator iter1 = pob.getPointFeatureIterator();){
                while (iter1.hasNext() && count < this.maxCount) {
                    PointFeature pf = iter1.next();
                    this.obsList.add(pf);
                    ++count;
                }
            }
            this.obsList.add(null);
            ++this.nptsTotal;
        }
        StructureData pfsd = this.obsList.get(0).getFeatureData();
        List<StructureMembers.Member> members = pfsd.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            StructureMembers.Member mb = members.get(i);
            String ustr = mb.getUnitsString();
            Unit unit = null;
            if (ustr != null && !ustr.equalsIgnoreCase("none")) {
                try {
                    unit = Util.parseUnit(ustr);
                }
                catch (VisADException e) {
                    unit = null;
                }
            }
            if (unit != null && unit.isConvertible(CommonUnit.secondsSinceTheEpoch)) {
                this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), "Basic", unit));
                this.varTime = mb.getName();
                continue;
            }
            if (mb.getName().equalsIgnoreCase("wv_level")) {
                if (mb.getName().equalsIgnoreCase("ALTITUDE") || mb.getName().equalsIgnoreCase("ALT")) {
                    this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), "Basic", unit));
                    this.varAltitude = mb.getName();
                    this.units[2] = unit;
                    continue;
                }
                if (mb.getName().equalsIgnoreCase("DEPTH")) {
                    this.positive = -1;
                    this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), "Basic", unit));
                    this.varAltitude = mb.getName();
                    continue;
                }
                if (mb.getName().equalsIgnoreCase("wv_level")) {
                    this.positive = 1;
                    this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), "Basic", CommonUnits.KILOMETER));
                    this.varAltitude = mb.getName();
                    continue;
                }
                this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), unit));
                continue;
            }
            if (unit != null && unit.isConvertible(CommonUnits.DEGREE)) {
                if (mb.getName().equalsIgnoreCase("LATITUDE") || mb.getName().equalsIgnoreCase("LAT")) {
                    this.varLatitude = mb.getName();
                    this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), "Basic", unit));
                    this.units[0] = unit;
                    continue;
                }
                if (mb.getName().equalsIgnoreCase("LONGITUDE") || mb.getName().equalsIgnoreCase("LON")) {
                    this.varLongitude = mb.getName();
                    this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), "Basic", unit));
                    this.units[1] = unit;
                    continue;
                }
                this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), unit));
                continue;
            }
            this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), unit));
        }
        Range rg = this.getDataRange();
        this.times = this.getTime(rg);
        this.startTime = this.getStartTime();
        this.endTime = this.getEndTime();
    }

    private void initPF() throws Exception {
        this.obsList = new ArrayList<PointFeature>();
        ProfileFeatureBean profBean = new ProfileFeatureBean(this.pf);
        this.beanCache.put(this.pf.getName(), profBean);
        this.nptsTotal += this.pf.size();
        Iterator iter1 = this.pf.iterator();
        for (int count = 0; iter1.hasNext() && count < this.maxCount; ++count) {
            PointFeature pf = (PointFeature)iter1.next();
            this.obsList.add(pf);
        }
        this.obsList.add(null);
        ++this.nptsTotal;
        StructureData pfsd = this.obsList.get(0).getDataAll();
        List<StructureMembers.Member> members = pfsd.getMembers();
        for (int i = 0; i < members.size(); ++i) {
            StructureMembers.Member mb = members.get(i);
            String ustr = mb.getUnitsString();
            Unit unit = null;
            if (ustr != null && !ustr.equalsIgnoreCase("none")) {
                try {
                    unit = Util.parseUnit(ustr);
                }
                catch (VisADException e) {
                    unit = null;
                }
            }
            if (unit != null && unit.isConvertible(CommonUnit.secondsSinceTheEpoch)) {
                this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), "Basic", unit));
                this.varTime = mb.getName();
                continue;
            }
            if (mb.getName().equalsIgnoreCase("ALTITUDE") || mb.getName().equalsIgnoreCase("ALT")) {
                if (mb.getName().equalsIgnoreCase("ALTITUDE") || mb.getName().equalsIgnoreCase("ALT")) {
                    this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), "Basic", unit));
                    this.varAltitude = mb.getName();
                    this.units[2] = unit;
                    continue;
                }
                if (mb.getName().equalsIgnoreCase("DEPTH")) {
                    this.positive = -1;
                    this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), "Basic", unit));
                    this.varAltitude = mb.getName();
                    continue;
                }
                if (mb.getName().equalsIgnoreCase("wv_level")) {
                    this.positive = 1;
                    this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), "Basic", CommonUnits.KILOMETER));
                    this.varAltitude = mb.getName();
                    continue;
                }
                this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), unit));
                continue;
            }
            if (unit != null && unit.isConvertible(CommonUnits.DEGREE)) {
                if (mb.getName().equalsIgnoreCase("LATITUDE") || mb.getName().equalsIgnoreCase("LAT")) {
                    this.varLatitude = mb.getName();
                    this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), "Basic", unit));
                    this.units[0] = unit;
                    continue;
                }
                if (mb.getName().equalsIgnoreCase("LONGITUDE") || mb.getName().equalsIgnoreCase("LON")) {
                    this.varLongitude = mb.getName();
                    this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), "Basic", unit));
                    this.units[1] = unit;
                    continue;
                }
                this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), unit));
                continue;
            }
            this.addVariable(new VarInfo(mb.getName(), mb.getDescription(), unit));
        }
        Range rg = this.getDataRange();
        this.times = this.getTime(rg);
        this.startTime = this.getStartTime();
        this.endTime = this.getEndTime();
    }

    @Override
    protected Unit getTimeUnit() throws Exception {
        return DataUtil.parseUnit("days since 1950-01-01T00:00:00Z");
    }

    public ProfileFeatureCollection getFt() {
        return this.pfc;
    }

    @Override
    protected Range getDataRange() throws Exception {
        ProfileFeatureBean pfb = this.beanCache.get(this.pf.getName());
        this.nptsTotal = pfb.pfc.size();
        Range range = new Range(0, this.nptsTotal - 1);
        return range;
    }

    @Override
    protected GriddedSet makeEarthDomainSet(Range range) throws Exception {
        return Util.makeEarthDomainSet(this.getLatitude(range), this.getLongitude(range), this.getAltitude(range), this.getUnits());
    }

    public Unit[] getUnits() {
        return this.units;
    }

    @Override
    public int getNumberPoints() {
        return this.pfc.size();
    }

    @Override
    protected double[] getTime(Range range) throws Exception {
        if (this.times == null) {
            float[] t = this.getFloatData(range, this.varTime);
            this.times = new double[t.length];
            for (int i = 0; i < t.length; ++i) {
                this.times[i] = t[i];
            }
        }
        return this.times;
    }

    @Override
    public double[] getTimeVals(Range range) throws Exception {
        return this.getTime(range);
    }

    @Override
    public DateTime getStartTime() {
        if (this.startTime == null) {
            try {
                this.startTime = new DateTime(this.times[0], this.getTimeUnit());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.startTime;
    }

    @Override
    public DateTime getEndTime() {
        if (this.endTime == null) {
            try {
                this.endTime = new DateTime(this.times[this.times.length - 1], this.getTimeUnit());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.endTime;
    }

    public static float[] qcLatLon(float[] v) {
        int i;
        if (v == null || v.length == 0) {
            return v;
        }
        float lastValue = v[0];
        for (i = 0; i < v.length; ++i) {
            if (v[i] != v[i] || v[i] == 0.0f) continue;
            lastValue = v[i];
            break;
        }
        for (i = 0; i < v.length; ++i) {
            if (v[i] != v[i]) continue;
            if (Math.abs(v[i] - lastValue) > 10.0f) {
                v[i] = lastValue;
            }
            lastValue = v[i];
        }
        return v;
    }

    @Override
    protected float[] getAltitude(Range range) throws Exception {
        float[] fdata = new float[range.length()];
        int size = this.obsList.size();
        int first = range.first();
        int stride = range.stride();
        int last = range.last();
        int j = 0;
        for (int i = first; i <= last; i += stride) {
            PointFeature pf = this.obsList.get(i);
            fdata[j++] = (float)pf.getLocation().getAltitude() * (float)this.positive;
        }
        return fdata;
    }

    @Override
    protected float[] getLatitude(Range range) throws Exception {
        float[] fdata = new float[range.length()];
        int size = this.obsList.size();
        int first = range.first();
        int stride = range.stride();
        int last = range.last();
        PointFeature pf_Old = null;
        int j = 0;
        for (int i = first; i <= last; i += stride) {
            PointFeature pf = this.obsList.get(i);
            if (pf == null) {
                pf = pf_Old;
            }
            fdata[j++] = (float)pf.getLocation().getLatitude();
            pf_Old = pf;
        }
        return fdata;
    }

    @Override
    protected float[] getLongitude(Range range) throws Exception {
        float[] fdata = new float[range.length()];
        int size = this.obsList.size();
        int first = range.first();
        int stride = range.stride();
        int last = range.last();
        PointFeature pf_Old = null;
        int j = 0;
        for (int i = first; i <= last; i += stride) {
            PointFeature pf = this.obsList.get(i);
            if (pf == null) {
                pf = pf_Old;
            }
            fdata[j++] = (float)pf.getLocation().getLongitude();
            pf_Old = pf;
        }
        return fdata;
    }

    @Override
    public float[] getFloatData(Range range, String var) throws Exception {
        float[] fdata = new float[range.length()];
        int size = this.obsList.size();
        int first = range.first();
        int stride = range.stride();
        int last = range.last();
        PointFeature pf_Old = null;
        int j = 0;
        for (int i = first; i <= last; i += stride) {
            PointFeature pf = this.obsList.get(i);
            if (pf == null) {
                pf = pf_Old;
            }
            StructureData pfsd = pf.getDataAll();
            Array a = pfsd.getArray(var);
            fdata[j++] = a.getFloat(0);
            pf_Old = pf;
        }
        return fdata;
    }

    @Override
    public double[] getDoubleData(Range range, String var) throws Exception {
        double[] fdata = new double[range.length()];
        int first = range.first();
        int stride = range.stride();
        int last = range.last();
        int j = 0;
        for (int i = first; i <= last; i += stride) {
            PointFeature pf = this.obsList.get(i);
            if (pf != null) {
                StructureData pfsd = pf.getDataAll();
                fdata[j++] = pfsd.getScalarDouble(var);
                continue;
            }
            fdata[j++] = Double.NaN;
        }
        return fdata;
    }

    @Override
    public String[] getStringData(Range range, String var) throws Exception {
        String[] sdata = new String[range.length()];
        int first = range.first();
        int stride = range.stride();
        int last = range.last();
        int j = 0;
        for (int i = first; i <= last; i += stride) {
            PointFeature pf = this.obsList.get(i);
            if (pf != null) {
                StructureData pfsd = pf.getFeatureData();
                sdata[j++] = pfsd.getScalarString(var);
                continue;
            }
            sdata[j++] = null;
        }
        return sdata;
    }

    @Override
    public synchronized FieldImpl getPointObTrack(Range range) throws Exception {
        double[] realArray;
        Data[] tupleArray;
        Trace.call1("TrackAdapter.getPointObTrack");
        Object loadId = JobManager.getManager().startLoad("TrackAdapter");
        if (range == null) {
            range = this.getFullRange();
        }
        float[] lats = this.getLatitude(range);
        float[] lons = this.getLongitude(range);
        float[] alts = this.getAltitude(range);
        double[] timeVals = this.getTimeVals(range);
        int numObs = lats.length;
        timeVals = CommonUnit.secondsSinceTheEpoch.toThis(timeVals, this.getTimeUnit());
        List<VarInfo> varsToUse = this.getVarsToUse();
        int numReals = this.countReals(varsToUse);
        int numStrings = varsToUse.size() - numReals;
        boolean allReals = numStrings == 0;
        int numVars = varsToUse.size();
        Unit[] units = new Unit[numVars];
        for (int varIdx = 0; varIdx < numVars; ++varIdx) {
            VarInfo var = varsToUse.get(varIdx);
            units[varIdx] = var.getUnit();
        }
        Trace.msg("TrackAdapter #obs: " + this.getNumberPoints() + " vars:" + numVars);
        RealType dirType = Direction.getRealType();
        EarthLocationTuple lastEL = null;
        ArrayList<EarthLocationTuple> locations = new ArrayList<EarthLocationTuple>();
        ArrayList<DateTime> times = new ArrayList<DateTime>();
        ArrayList<Data[]> tuples = new ArrayList<Data[]>();
        ArrayList<double[]> reals = new ArrayList<double[]>();
        ArrayList<String[]> strings = new ArrayList<String[]>();
        ArrayList<Real> bearings = new ArrayList<Real>();
        ArrayList stringTypeList = new ArrayList();
        for (int obIdx = 0; obIdx < numObs; ++obIdx) {
            EarthLocationTuple location = new EarthLocationTuple(new Real(RealType.Latitude, (double)lats[obIdx]), new Real(RealType.Longitude, (double)lons[obIdx]), new Real(RealType.Altitude, (double)alts[obIdx]));
            if (obIdx == 0) {
                lastEL = location;
            }
            locations.add(location);
            double dirVal = Util.calculateBearing(lastEL, location).getAngle();
            lastEL = location;
            Real bearing = new Real(dirType, dirVal);
            bearings.add(bearing);
            times.add(new DateTime(timeVals[obIdx]));
            tupleArray = allReals ? new Real[numVars + 1] : new Data[numVars + 1];
            tuples.add(tupleArray);
            realArray = new double[numReals + 1];
            reals.add(realArray);
            realArray[realArray.length - 1] = dirVal;
            strings.add(new String[numStrings]);
        }
        Trace.call1("TrackAdapter.reading data");
        boolean doColumnOriented = true;
        if (doColumnOriented) {
            int realCnt = 0;
            int stringCnt = 0;
            for (int varIdx = 0; varIdx < numVars; ++varIdx) {
                if (!JobManager.getManager().canContinue(loadId)) {
                    return null;
                }
                VarInfo var = varsToUse.get(varIdx);
                if (var.getIsNumeric()) {
                    float[] fvalues = this.getFloatData(range, var.getShortName());
                    if (var.getRealType() == null) {
                        // empty if block
                    }
                    Data[] firstTuple = null;
                    for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                        Data[] tupleArray2 = (Data[])tuples.get(obIdx);
                        ((double[])reals.get((int)obIdx))[realCnt] = fvalues[obIdx];
                        if (firstTuple != null) {
                            tupleArray2[varIdx] = ((Real)firstTuple[varIdx]).cloneButValue(fvalues[obIdx]);
                            continue;
                        }
                        firstTuple = tupleArray2;
                        tupleArray2[varIdx] = var.getUnit() == null ? new Real(var.getRealType(), (double)fvalues[obIdx]) : new Real(var.getRealType(), fvalues[obIdx], var.getUnit());
                    }
                    ++realCnt;
                    continue;
                }
                String[] svalues = this.getStringData(range, var.getShortName());
                for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                    Data[] tupleArray3 = (Data[])tuples.get(obIdx);
                    tupleArray3[varIdx] = new Text(svalues[obIdx]);
                    ((String[])strings.get((int)obIdx))[stringCnt] = svalues[obIdx];
                }
                ++stringCnt;
            }
        } else {
            Index0D scalarIndex = new Index0D(new int[0]);
            for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                if (!JobManager.getManager().canContinue(loadId)) {
                    return null;
                }
                StructureData structure = null;
                List<StructureMembers.Member> members = structure.getMembers();
                tupleArray = (Data[])tuples.get(obIdx);
                realArray = (double[])reals.get(obIdx);
                String[] stringArray = (String[])strings.get(obIdx);
                int numMembers = members.size();
                int varCnt = 0;
                int realCnt = 0;
                int stringCnt = 0;
                for (int varIdx = 0; varIdx < numVars; ++varIdx) {
                    VarInfo var = varsToUse.get(varIdx);
                    StructureMembers.Member member = structure.findMember(var.getShortName());
                    if (!var.getIsNumeric()) {
                        String value = new String(DataUtil.toCharArray(structure.getArray(member)));
                        stringArray[stringCnt++] = value;
                        tupleArray[varCnt] = new Text(value);
                    } else {
                        float value = structure.convertScalarFloat(member);
                        realArray[realCnt++] = value;
                        tupleArray[varCnt] = var.getUnit() == null ? new Real(var.getRealType(), (double)value) : new Real(var.getRealType(), value, var.getUnit());
                    }
                    ++varCnt;
                }
            }
        }
        Trace.call2("TrackAdapter.reading data");
        Trace.call1("TrackAdapter.processing data", " all reals?" + allReals);
        Data[] obs = new PointObTuple[locations.size()];
        TupleType tt = null;
        RealTupleType rtt = null;
        TupleType finalTT = null;
        for (int obIdx = 0; obIdx < obs.length; ++obIdx) {
            Data[] tupleArray4 = (Data[])tuples.get(obIdx);
            double[] realArray2 = (double[])reals.get(obIdx);
            String[] stringArray = (String[])strings.get(obIdx);
            tupleArray4[tupleArray4.length - 1] = (Data)bearings.get(obIdx);
            if (tt == null) {
                tt = Tuple.buildTupleType(tupleArray4);
                if (allReals) {
                    rtt = (RealTupleType)tt;
                }
            }
            Tuple rest = allReals ? new RealTuple(rtt, (Real[])tupleArray4, null, units, false) : new Tuple(tt, tupleArray4, false, false);
            PointObTuple pot = null;
            if (finalTT == null) {
                pot = new PointObTuple((EarthLocation)locations.get(obIdx), (DateTime)times.get(obIdx), rest);
                finalTT = Tuple.buildTupleType(pot.getComponents());
            } else {
                pot = new PointObTuple((EarthLocation)locations.get(obIdx), (DateTime)times.get(obIdx), rest, finalTT, false);
            }
            obs[obIdx] = pot;
        }
        Trace.call2("TrackAdapter.processing data");
        Integer1DSet indexSet = new Integer1DSet((MathType)RealType.getRealType("index"), numObs);
        FieldImpl retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), obs[0].getType()), indexSet);
        retField.setSamples(obs, false, false);
        Trace.call2("TrackAdapter.getPointObTrack");
        return retField;
    }

    public static class ProfileFeatureBean
    extends StationBean {
        int npts;
        public ProfileFeature pfc;
        public PointFeature pf;

        public ProfileFeatureBean(ProfileFeature pfc) throws IOException {
            super(pfc.getFeatureData());
            this.pfc = pfc;
            Iterator iterator = pfc.iterator();
            while (iterator.hasNext()) {
                PointFeature pf2;
                this.pf = pf2 = (PointFeature)iterator.next();
            }
            this.npts = pfc.size();
        }

        @Override
        public void setNobs(int npts) {
            this.npts = npts;
        }

        @Override
        public int getNobs() {
            return this.npts;
        }

        @Override
        public String getName() {
            return this.pfc.getName();
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getWmoId() {
            return null;
        }

        @Override
        public double getLatitude() {
            return this.pf.getLocation().getLatitude();
        }

        @Override
        public double getLongitude() {
            return this.pf.getLocation().getLongitude();
        }

        @Override
        public double getAltitude() {
            return this.pf.getLocation().getAltitude();
        }

        @Override
        public LatLonPoint getLatLon() {
            return this.pf.getLocation().getLatLon();
        }

        @Override
        public boolean isMissing() {
            return Double.isNaN(this.getLatitude());
        }

        @Override
        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }
    }

    public static class StationBean
    extends FeatureBean
    implements Station {
        private StationFeature s;
        private int npts = -1;

        public StationBean() {
        }

        public StationBean(StructureData sdata) throws IOException {
            super(sdata);
        }

        public StationBean(Station s) throws IOException {
            super(((StationFeature)s).getFeatureData());
            this.s = (StationFeature)s;
            this.npts = s.getNobs();
        }

        public static String hiddenProperties() {
            return "latLon";
        }

        @Override
        public int getNobs() {
            return this.npts;
        }

        public void setNobs(int npts) {
            this.npts = npts;
        }

        @Override
        public String getWmoId() {
            return this.s.getWmoId();
        }

        @Override
        public String getName() {
            return this.s.getName();
        }

        @Override
        public String getDescription() {
            return this.s.getDescription();
        }

        @Override
        public double getLatitude() {
            return this.s.getLatitude();
        }

        @Override
        public double getLongitude() {
            return this.s.getLongitude();
        }

        @Override
        public double getAltitude() {
            return this.s.getAltitude();
        }

        @Override
        public LatLonPoint getLatLon() {
            return this.s.getLatLon();
        }

        @Override
        public boolean isMissing() {
            return this.s.isMissing();
        }

        @Override
        public int compareTo(Station so) {
            return this.getName().compareTo(so.getName());
        }
    }

    public static class FeatureBean {
        StructureData sdata;
        String fields;

        public FeatureBean() {
        }

        FeatureBean(StructureData sdata) throws IOException {
            this.sdata = sdata;
            this.fields = NCdumpW.toString(sdata);
        }

        public String getFields() {
            return this.fields;
        }

        public String showFields() {
            StringWriter sw = new StringWriter(10000);
            NCdumpW.printStructureData(new PrintWriter(sw), this.sdata);
            return sw.toString();
        }
    }
}

