/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.sounding;

import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.AddeException;
import edu.wisc.ssec.mcidas.adde.AddePointDataReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import ucar.unidata.beans.NonVetoableProperty;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.sounding.SoundingAdapter;
import ucar.unidata.data.sounding.SoundingAdapterImpl;
import ucar.unidata.data.sounding.SoundingOb;
import ucar.unidata.data.sounding.SoundingStation;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.visad.UtcDate;
import ucar.visad.quantities.GeopotentialAltitude;
import visad.DateTime;
import visad.Unit;

public class AddeSoundingAdapter
extends SoundingAdapterImpl
implements SoundingAdapter {
    private static final String P_PARAM = "param";
    private static final String P_NUM = "num";
    private static final String P_ALL = "all";
    private static final String P_POS = "pos";
    private static final String P_GROUP = "group";
    private static final String P_DESCR = "descr";
    private static final String P_SELECT = "select";
    private static final String URL_ROOT = "/point";
    private static final String URL_PROTOCOL = "adde";
    private NonVetoableProperty serverProperty;
    private NonVetoableProperty mandatoryDatasetProperty;
    private NonVetoableProperty significantDatasetProperty;
    private NonVetoableProperty stationsProperty;
    private NonVetoableProperty soundingTimesProperty;
    private String manGroup;
    private String manDescriptor;
    private String sigGroup = null;
    private String sigDescriptor = null;
    private boolean mainHours = false;
    private String prMandPVar = "p";
    private String htMandPVar = "z";
    private String tpMandPVar = "t";
    private String tdMandPVar = "td";
    private String spdMandPVar = "spd";
    private String dirMandPVar = "dir";
    private String dayVar = "day";
    private String timeVar = "time";
    private String idVar = "idn";
    private String latVar = "lat";
    private String lonVar = "lon";
    private String eleVar = "zs";
    private String server;
    private String mandDataset;
    private String sigDataset;
    private String defaultServer = "adde.unidata.ucar.edu";
    private String defaultMandDataset = "rtptsrc/uppermand";
    private String defaultSigDataset = "rtptsrc/uppersig";

    public AddeSoundingAdapter() {
        super("AddeSoundingAdapter");
    }

    public AddeSoundingAdapter(String server) throws Exception {
        this(server, null);
    }

    public AddeSoundingAdapter(String server, String dataset) throws Exception {
        this(server, dataset, null);
    }

    public AddeSoundingAdapter(String server, String mandDataset, String sigDataset) throws Exception {
        this(server, mandDataset, sigDataset, false);
    }

    public AddeSoundingAdapter(String server, String mandDataset, String sigDataset, boolean mainHours) throws Exception {
        super("AddeSoundingAdapter");
        this.server = server;
        this.mandDataset = mandDataset;
        this.sigDataset = sigDataset;
        this.mainHours = mainHours;
        this.init();
    }

    @Override
    protected void init() throws Exception {
        if (this.haveInitialized) {
            return;
        }
        super.init();
        this.getVariables();
        if (this.server == null) {
            this.server = this.defaultServer;
        }
        if (this.mandDataset == null) {
            this.mandDataset = this.defaultMandDataset;
        }
        if (this.sigDataset == null) {
            this.sigDataset = this.defaultSigDataset;
        }
        this.serverProperty = new NonVetoableProperty(this, "server");
        this.addProperty(this.serverProperty);
        this.serverProperty.setValue(this.server);
        this.mandatoryDatasetProperty = new NonVetoableProperty(this, "mandatoryDataset");
        this.addProperty(this.mandatoryDatasetProperty);
        this.mandatoryDatasetProperty.setValue(this.mandDataset);
        this.significantDatasetProperty = new NonVetoableProperty(this, "significantDataset");
        this.addProperty(this.significantDatasetProperty);
        this.significantDatasetProperty.setValue(this.sigDataset);
        this.stationsProperty = new NonVetoableProperty(this, "stations");
        this.addProperty(this.stationsProperty);
        this.soundingTimesProperty = new NonVetoableProperty(this, "soundingTimes");
        this.addProperty(this.soundingTimesProperty);
        this.loadStations();
    }

    private boolean intEqual(int v, String s) {
        return McIDASUtil.intBitsToString(v).equals(s);
    }

    private String sQuote(String s) {
        return "'" + s + "'";
    }

    private String makeUrl(String[] args) {
        return this.makeUrl(URL_ROOT, args);
    }

    private String makeUrl(String urlRoot, String[] args) {
        return Misc.makeUrl(URL_PROTOCOL, this.server, urlRoot, args);
    }

    @Override
    public void update() {
        this.checkInit();
        try {
            this.loadStations();
        }
        catch (Exception exc) {
            LogUtil.logException("Error updating AddeSoundingAdapter", exc);
        }
    }

    private void loadStations() throws AddeException {
        this.times = new ArrayList(8);
        this.stations = new ArrayList(100);
        this.soundings = new ArrayList(100);
        if (this.server != null && this.mandDataset != null) {
            this.loadStationsInner();
        }
        this.stationsProperty.setValueAndNotifyListeners(this.stations);
        this.soundingTimesProperty.setValueAndNotifyListeners(this.times);
    }

    private void initGroupAndDescriptors() {
        StringTokenizer tok;
        if (this.manGroup == null) {
            tok = new StringTokenizer(this.mandDataset, "/");
            if (tok.countTokens() != 2) {
                throw new IllegalStateException("Illegal mandatory dataset name " + this.mandDataset);
            }
            this.manGroup = tok.nextToken();
            this.manDescriptor = tok.nextToken();
        }
        if (this.sigDataset != null && this.sigGroup == null) {
            tok = new StringTokenizer(this.sigDataset, "/");
            if (tok.countTokens() != 2) {
                throw new IllegalStateException("Illegal significant dataset name " + this.mandDataset);
            }
            this.sigGroup = tok.nextToken();
            this.sigDescriptor = tok.nextToken();
        }
    }

    private void loadStationsInner() throws AddeException {
        this.initGroupAndDescriptors();
        String request = this.makeUrl(new String[]{P_GROUP, this.manGroup, P_DESCR, this.manDescriptor, P_PARAM, StringUtil.join(new String[]{this.dayVar, this.timeVar, this.idVar, this.latVar, this.lonVar, this.eleVar}), P_NUM, P_ALL, P_POS, P_ALL}) + this.getManUserProj() + this.getStationsSelectString();
        this.dbPrint(request);
        AddePointDataReader dataReader = new AddePointDataReader(request);
        String[] units = dataReader.getUnits();
        int[] scales = dataReader.getScales();
        int[][] data = dataReader.getData();
        for (int i = 0; i < data[0].length; ++i) {
            int day = data[0][i];
            int time = data[1][i];
            String wmoID = Integer.toString(data[2][i]);
            double lat = this.scaleValue(data[3][i], scales[3]);
            double lon = this.scaleValue(data[4][i], scales[4]);
            lon = -lon;
            double elev = this.scaleValue(data[5][i], scales[5]);
            try {
                SoundingStation s = new SoundingStation(wmoID, lat, lon, elev);
                if (!this.stations.contains(s)) {
                    this.stations.add(s);
                }
                DateTime dt = new DateTime(McIDASUtil.mcDayTimeToSecs(day, time));
                this.soundings.add(new SoundingOb(s, dt));
                if (this.times.contains(dt)) continue;
                this.times.add(dt);
                continue;
            }
            catch (Exception vexcp) {
                LogUtil.logException("Creating sounding", vexcp);
            }
        }
        Collections.sort(this.times);
        if (this.debug) {
            System.err.println("Times:" + this.times);
        }
    }

    @Override
    public void setSource(String server) {
        this.server = server;
        if (this.serverProperty != null) {
            this.serverProperty.setValue(server);
        }
    }

    @Override
    public String getSource() {
        return this.server;
    }

    public void setMandDataset(String value) {
        this.mandDataset = value;
    }

    public String getMandDataset() {
        return this.mandDataset;
    }

    public void setSigDataset(String value) {
        this.sigDataset = value;
    }

    public String getSigDataset() {
        return this.sigDataset;
    }

    @Override
    public SoundingOb initSoundingOb(SoundingOb sound) {
        if (!sound.hasData()) {
            this.setRAOBData(sound);
        }
        return sound;
    }

    private String makeSelectString(SoundingOb sound) {
        return this.makeSelectString(sound.getStation().getIdentifier(), sound.getTimestamp());
    }

    private String makeSelectString(String wmoId, DateTime date) {
        String day = UtcDate.getYMD(date);
        String time = UtcDate.getHH(date);
        return new String(this.idVar + " " + wmoId + ";" + this.dayVar + " " + day + ";" + this.timeVar + " " + time);
    }

    private void setRAOBData(SoundingOb sound) {
        block25: {
            float[] dir;
            float[] spd;
            float[] td;
            float[] t;
            float[] z;
            float[] p;
            int numLevels;
            int[][] data;
            String[] units;
            int[] scales;
            String[] params;
            AddePointDataReader apdr;
            this.initGroupAndDescriptors();
            Unit pUnit = null;
            Unit tUnit = null;
            Unit tdUnit = null;
            Unit spdUnit = null;
            Unit dirUnit = null;
            Unit zUnit = null;
            String request = this.getMandatoryURL(sound);
            this.dbPrint(request);
            try {
                if (sound.getMandatoryFile() != null) {
                    request = "file:" + sound.getMandatoryFile();
                }
                apdr = new AddePointDataReader(request);
                params = apdr.getParams();
                scales = apdr.getScales();
                units = apdr.getUnits();
                data = apdr.getData();
                numLevels = data[0].length;
                if (numLevels > 0) {
                    int i;
                    this.dbPrint("Num mand pressure levels = " + numLevels);
                    pUnit = this.getUnit(units[0]);
                    zUnit = GeopotentialAltitude.getGeopotentialUnit(this.getUnit(units[1]));
                    tUnit = this.getUnit(units[2]);
                    tdUnit = this.getUnit(units[3]);
                    spdUnit = this.getUnit(units[4]);
                    dirUnit = this.getUnit(units[5]);
                    p = new float[numLevels];
                    z = new float[numLevels];
                    t = new float[numLevels];
                    td = new float[numLevels];
                    spd = new float[numLevels];
                    dir = new float[numLevels];
                    for (i = 0; i < numLevels; ++i) {
                        p[i] = (float)this.scaleValue(data[0][i], scales[0]);
                        z[i] = (float)this.scaleValue(data[1][i], scales[1]);
                        t[i] = (float)this.scaleValue(data[2][i], scales[2]);
                        td[i] = (float)this.scaleValue(data[3][i], scales[3]);
                        spd[i] = (float)this.scaleValue(data[4][i], scales[4]);
                        dir[i] = (float)this.scaleValue(data[5][i], scales[5]);
                    }
                    if (this.debug) {
                        System.err.println("P[" + pUnit + "]\t" + "Z[" + zUnit + "]\t" + "T[" + tUnit + "]\t" + "TD[" + tdUnit + "]\t" + "SPD[" + spdUnit + "]\t" + "DIR[" + dirUnit + "]");
                        for (i = 0; i < numLevels; ++i) {
                            System.err.println(p[i] + "\t" + z[i] + "\t" + t[i] + "\t" + td[i] + "\t" + spd[i] + "\t" + dir[i]);
                        }
                    }
                    sound.getRAOB().setMandatoryPressureProfile(pUnit, p, tUnit, t, tdUnit, td, spdUnit, spd, dirUnit, dir, zUnit, z);
                }
            }
            catch (Exception e) {
                LogUtil.logException("Unable to set mandatory pressure data for station " + sound.getStation(), e);
            }
            if (this.sigGroup == null || this.sigDescriptor == null) {
                return;
            }
            request = this.getSigURL(sound);
            this.dbPrint(request);
            try {
                int i;
                if (sound.getSigFile() != null) {
                    request = "file:" + sound.getSigFile();
                }
                apdr = new AddePointDataReader(request);
                params = apdr.getParams();
                scales = apdr.getScales();
                units = apdr.getUnits();
                data = apdr.getData();
                numLevels = data[0].length;
                if (numLevels <= 0) break block25;
                int numSigW = 0;
                int numSigT = 0;
                for (int i2 = 0; i2 < data[0].length; ++i2) {
                    if (this.intEqual(data[0][i2], "SIGT")) {
                        ++numSigT;
                    }
                    if (!this.intEqual(data[0][i2], "SIGW")) continue;
                    ++numSigW;
                }
                this.dbPrint("Num sig temperature levels = " + numSigT);
                this.dbPrint("Num sig wind levels = " + numSigW);
                pUnit = this.getUnit("mb");
                tUnit = this.getUnit("k");
                tdUnit = this.getUnit("k");
                zUnit = GeopotentialAltitude.getGeopotentialUnit(this.getUnit("m"));
                spdUnit = this.getUnit("mps");
                dirUnit = this.getUnit("deg");
                p = new float[numSigT];
                t = new float[numSigT];
                td = new float[numSigT];
                z = new float[numSigW];
                spd = new float[numSigW];
                dir = new float[numSigW];
                int j = 0;
                int l = 0;
                for (i = 0; i < numLevels; ++i) {
                    if (this.intEqual(data[0][i], "SIGT")) {
                        p[j] = (float)this.scaleValue(data[3][i], 1);
                        t[j] = (float)this.scaleValue(data[1][i], 2);
                        td[j] = (float)this.scaleValue(data[2][i], 2);
                        ++j;
                        continue;
                    }
                    if (!this.intEqual(data[0][i], "SIGW")) continue;
                    z[l] = data[3][i] == 0 ? (float)sound.getStation().getAltitudeAsDouble() : (float)this.scaleValue(data[3][i], 0);
                    spd[l] = (float)this.scaleValue(data[2][i], 1);
                    dir[l] = (float)this.scaleValue(data[1][i], 0);
                    ++l;
                }
                if (numSigT > 0) {
                    try {
                        if (this.debug) {
                            System.err.println("P[" + pUnit + "]\tT[" + tUnit + "]\tTD[" + tdUnit + "]");
                            for (i = 0; i < numSigT; ++i) {
                                System.err.println(p[i] + "\t" + t[i] + "\t" + td[i]);
                            }
                        }
                        sound.getRAOB().setSignificantTemperatureProfile(pUnit, p, tUnit, t, tdUnit, td);
                    }
                    catch (Exception e) {
                        LogUtil.logException("Unable to set significant temperature data for station " + sound.getStation(), e);
                    }
                }
                if (numSigW > 0) {
                    try {
                        if (this.debug) {
                            System.err.println("Z[" + zUnit + "]\tSPD[" + spdUnit + "]\tDIR[" + dirUnit + "]");
                            for (int i3 = 0; i3 < numSigW; ++i3) {
                                System.err.println(z[i3] + "\t" + spd[i3] + "\t" + dir[i3]);
                            }
                        }
                        sound.getRAOB().setSignificantWindProfile(zUnit, z, spdUnit, spd, dirUnit, dir);
                    }
                    catch (Exception e) {
                        LogUtil.logException("Unable to set significant wind data for station " + sound.getStation(), e);
                    }
                }
            }
            catch (Exception e) {
                LogUtil.logException("Unable to retrieve significant level data for station " + sound.getStation(), e);
            }
        }
    }

    private double scaleValue(int value, int scale) {
        return value == -2139062144 ? Double.NaN : (double)value / Math.pow(10.0, scale);
    }

    private Unit getUnit(String unitName) {
        return DataUtil.parseUnit(unitName);
    }

    private String getDflt(String name, String dflt) {
        return this.getDflt("AddeSoundingAdapter.", name, dflt);
    }

    private void getVariables() {
        try {
            this.defaultServer = this.getDflt("serverName", this.defaultServer);
            this.defaultMandDataset = this.getDflt("mandDataset", this.defaultMandDataset);
            this.defaultSigDataset = this.getDflt("sigDataset", this.defaultSigDataset);
            this.idVar = this.getDflt("stationIDVariable", this.idVar);
            this.latVar = this.getDflt("latitudeVariable", this.latVar);
            this.lonVar = this.getDflt("longitudeVariable", this.lonVar);
            this.eleVar = this.getDflt("stationElevVariable", this.eleVar);
            this.timeVar = this.getDflt("soundingTimeVariable", this.timeVar);
            this.dayVar = this.getDflt("soundingDayVariable", this.dayVar);
            this.prMandPVar = this.getDflt("mandPPressureVariable", this.prMandPVar);
            this.htMandPVar = this.getDflt("mandPHeightVariable", this.htMandPVar);
            this.tpMandPVar = this.getDflt("mandPTempVariable", this.tpMandPVar);
            this.tdMandPVar = this.getDflt("mandPDewptVariable", this.tdMandPVar);
            this.spdMandPVar = this.getDflt("mandPWindSpeedVariable", this.spdMandPVar);
            this.dirMandPVar = this.getDflt("mandPWindDirVariable", this.dirMandPVar);
        }
        catch (Exception e) {
            System.err.println("Unable to initialize defaults file");
        }
    }

    private String getSigUserProj() {
        return this.getUserProj(new String(this.sigGroup + "/" + this.sigDescriptor).toUpperCase());
    }

    public String getMandatoryURL(SoundingOb sound) {
        String select = this.makeSelectString(sound);
        String paramString = StringUtil.join(new String[]{this.prMandPVar, this.htMandPVar, this.tpMandPVar, this.tdMandPVar, this.spdMandPVar, this.dirMandPVar});
        String request = this.makeUrl(new String[]{P_GROUP, this.manGroup, P_DESCR, this.manDescriptor, P_SELECT, this.sQuote(select), P_PARAM, paramString, P_NUM, P_ALL, P_POS, P_ALL}) + this.getManUserProj();
        return request;
    }

    public String getSigURL(SoundingOb sound) {
        String select = this.makeSelectString(sound);
        String paramString = StringUtil.join(new String[]{this.prMandPVar, this.htMandPVar, this.tpMandPVar, this.tdMandPVar, this.spdMandPVar, this.dirMandPVar});
        String request = this.makeUrl(new String[]{P_GROUP, this.sigGroup, P_DESCR, this.sigDescriptor, P_SELECT, this.sQuote(select), P_PARAM, "type p1 p2 p3", P_NUM, P_ALL, P_POS, P_ALL}) + this.getSigUserProj();
        return request;
    }

    private String getManUserProj() {
        return this.getUserProj(new String(this.manGroup + "/" + this.manDescriptor).toUpperCase());
    }

    private String getUserProj(String key) {
        StringBuffer buf = new StringBuffer();
        buf.append("&proj=");
        buf.append(this.getDflt("", key.toUpperCase().trim() + ".proj", "0"));
        buf.append("&user=");
        buf.append(this.getDflt("", key.toUpperCase().trim() + ".user", "user"));
        buf.append("&compress=gzip");
        return buf.toString();
    }

    private String getStationsSelectString() {
        if (!this.mainHours) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("&SELECT='");
        buf.append(this.timeVar);
        buf.append(" 00,12'");
        return buf.toString();
    }

    public static void main(String[] args) {
        String server = "adde.unidata.ucar.edu";
        String manset = "rtptsrc/uppermand";
        String sigset = "rtptsrc/uppersig";
        if (args.length > 0) {
            String string = server = !args[0].equalsIgnoreCase("x") ? args[0] : server;
            if (args.length > 1) {
                String string2 = manset = !args[1].equalsIgnoreCase("x") ? args[1] : manset;
            }
            if (args.length > 2) {
                sigset = !args[2].equalsIgnoreCase("x") ? args[2] : sigset;
            }
        }
    }

    public String toString() {
        return "SoundingAdapter:" + this.server;
    }
}

