/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

public class VCP {
    private static final double[] vcp_11_angles = new double[]{0.5, 1.5, 2.4, 3.4, 4.3, 5.3, 6.2, 7.5, 8.7, 10.0, 12.0, 14.0, 16.7, 19.5};
    private static final double[] vcp_12_angles = new double[]{0.5, 0.9, 1.3, 1.8, 2.4, 3.1, 4.0, 5.1, 6.4, 8.0, 10.0, 12.5, 15.6, 19.5};
    private static final double[] vcp_21_angles = new double[]{0.5, 1.5, 2.4, 3.4, 4.3, 6.0, 9.9, 14.6, 19.5};
    private static final double[] vcp_31_angles = new double[]{0.5, 1.5, 2.5, 3.5, 4.5};
    private static final double[] vcp_32_angles = new double[]{0.5, 1.5, 2.5, 3.5, 4.5};
    private static final double[] vcp_121_angles = new double[]{0.5, 1.5, 2.4, 3.4, 4.3, 6.0, 9.9, 14.6, 19.5};
    private static final double[] vcp_300_angles = new double[]{0.5, 2.4, 9.9};

    public static int getNumCuts(int vcp) {
        switch (vcp) {
            case 11: {
                return vcp_11_angles.length;
            }
            case 12: {
                return vcp_12_angles.length;
            }
            case 21: {
                return vcp_21_angles.length;
            }
            case 31: {
                return vcp_31_angles.length;
            }
            case 32: {
                return vcp_32_angles.length;
            }
            case 121: {
                return vcp_121_angles.length;
            }
            case 300: {
                return vcp_300_angles.length;
            }
        }
        return 0;
    }

    public static float getCutAngle(int vcp, int cut) {
        switch (vcp) {
            case 11: {
                return (float)vcp_11_angles[cut];
            }
            case 12: {
                return (float)vcp_12_angles[cut];
            }
            case 21: {
                return (float)vcp_21_angles[cut];
            }
            case 31: {
                return (float)vcp_31_angles[cut];
            }
            case 32: {
                return (float)vcp_32_angles[cut];
            }
            case 121: {
                return (float)vcp_121_angles[cut];
            }
            case 300: {
                return (float)vcp_300_angles[cut];
            }
        }
        return -99.9f;
    }

    public static double[] getAngles(int vcp) {
        switch (vcp) {
            case 11: {
                return (double[])vcp_11_angles.clone();
            }
            case 12: {
                return (double[])vcp_12_angles.clone();
            }
            case 21: {
                return (double[])vcp_21_angles.clone();
            }
            case 31: {
                return (double[])vcp_31_angles.clone();
            }
            case 32: {
                return (double[])vcp_32_angles.clone();
            }
            case 121: {
                return (double[])vcp_121_angles.clone();
            }
            case 300: {
                return (double[])vcp_300_angles.clone();
            }
        }
        return null;
    }
}

