/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ucar.nc2.dt.TypedDatasetImpl;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.data.radar.StationRadarCollection;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.util.Product;

public abstract class StationRadarCollectionImpl
extends TypedDatasetImpl
implements StationRadarCollection {
    private StationRadarCollection radarCollection;
    protected HashMap stations;
    protected HashMap relTimesList;
    protected HashMap absTimesList;
    protected DateUnit timeUnit;
    private LatLonRect rect;

    public StationRadarCollectionImpl() {
    }

    public StationRadarCollectionImpl(StationRadarCollection radarDataset) {
        this.radarCollection = radarDataset;
    }

    @Override
    public LatLonRect getBoundingBox() {
        if (this.rect == null) {
            List<Station> stations = null;
            try {
                stations = this.radarCollection.getStations();
            }
            catch (IOException e) {
                return null;
            }
            if (stations.size() == 0) {
                return null;
            }
            thredds.catalog.query.Station s = (thredds.catalog.query.Station)((Object)stations.get(0));
            LatLonPointImpl llpt = new LatLonPointImpl();
            llpt.set(s.getLocation().getLatitude(), s.getLocation().getLongitude());
            this.rect = new LatLonRect(llpt, 0.001, 0.001);
            for (int i = 1; i < stations.size(); ++i) {
                s = (thredds.catalog.query.Station)((Object)stations.get(i));
                llpt.set(s.getLocation().getLatitude(), s.getLocation().getLongitude());
                this.rect.extend(llpt);
            }
        }
        return this.rect;
    }

    public List getStations(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        LatLonPointImpl latlonPt = new LatLonPointImpl();
        ArrayList<thredds.catalog.query.Station> result = new ArrayList<thredds.catalog.query.Station>();
        List<Station> stationC = this.radarCollection.getStations();
        for (int i = 0; i < stationC.size(); ++i) {
            thredds.catalog.query.Station s = (thredds.catalog.query.Station)((Object)stationC.get(i));
            latlonPt.set(s.getLocation().getLatitude(), s.getLocation().getLongitude());
            if (boundingBox.contains(latlonPt)) {
                result.add(s);
            }
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return result;
    }

    @Override
    public boolean checkStationProduct(String stationName, Product product) {
        return false;
    }

    public thredds.catalog.query.Station getStation(String name) throws IOException {
        if (this.stations == null) {
            List<Station> stationC = null;
            try {
                stationC = this.radarCollection.getStations();
            }
            catch (IOException e) {
                return null;
            }
            this.stations = new HashMap(2 * this.stations.size());
            for (int i = 0; i < stationC.size(); ++i) {
                thredds.catalog.query.Station s = (thredds.catalog.query.Station)((Object)stationC.get(i));
                this.stations.put(s.getName(), s);
            }
        }
        return (thredds.catalog.query.Station)this.stations.get(name);
    }

    public List getStations() throws IOException {
        return this.radarCollection.getStations();
    }

    public List getStations(CancelTask cancel) throws IOException {
        if (cancel != null && cancel.isCancel()) {
            return null;
        }
        return this.getStations();
    }

    public List getStations(LatLonRect boundingBox) throws IOException {
        LatLonPointImpl latlonPt = new LatLonPointImpl();
        ArrayList<thredds.catalog.query.Station> result = new ArrayList<thredds.catalog.query.Station>();
        List<Station> stationC = this.radarCollection.getStations();
        for (int i = 0; i < stationC.size(); ++i) {
            thredds.catalog.query.Station s = (thredds.catalog.query.Station)((Object)stationC.get(i));
            latlonPt.set(s.getLocation().getLatitude(), s.getLocation().getLongitude());
            if (!boundingBox.contains(latlonPt)) continue;
            result.add(s);
        }
        return result;
    }
}

