/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.data.radar.RadarAdapter;
import ucar.unidata.data.radar.RadarConstants;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.util.WrapperException;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import visad.Data;
import visad.DataImpl;
import visad.DateTime;
import visad.FieldImpl;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.SampledSet;
import visad.SingletonSet;
import visad.VisADException;
import visad.util.ThreadManager;

public abstract class RadarDataSource
extends FilesDataSource
implements RadarConstants {
    public boolean useDriverTime = false;
    public Object TimeDriver = null;
    public static final DataCategory CATEGORY_RHI = DataCategory.parseCategory("RHI", false);
    public static final DataCategory CATEGORY_RHISWEEP = DataCategory.parseCategory("RHISWEEP", false);
    public static final DataCategory CATEGORY_CAPPI = DataCategory.parseCategory("CAPPI", false);
    public static final DataCategory CATEGORY_VOLUME = DataCategory.parseCategory("RADAR_VOLUME", false);
    public static final DataCategory CATEGORY_VCS = DataCategory.parseCategory("RADAR_CROSS_SECTION", false);
    public static final DataCategory CATEGORY_ISOSURFACE = DataCategory.parseCategory("RADAR_ISOSURFACE", false);
    public static final DataCategory CATEGORY_ISOSURFACE_TIME = DataCategory.parseCategory("RADAR_ISOSURFACE-TIME", false);
    public static final DataCategory CATEGORY_SWEEP_3D = DataCategory.parseCategory("SWEEP-3D", false);
    public static final DataCategory CATEGORY_SWEEP_3D_TIME = DataCategory.parseCategory("SWEEP-3D-TIME", false);
    public static final DataCategory CATEGORY_SWEEP_2D = DataCategory.parseCategory("SWEEP-2D", false);
    public static final DataCategory CATEGORY_SWEEP_2D_TIME = DataCategory.parseCategory("SWEEP-2D-TIME", false);
    public static final DataCategory CATEGORY_TH = DataCategory.parseCategory("RADAR_TIMEHEIGHT", false);
    public static final DataCategory CATEGORY_VWP = DataCategory.parseCategory("RADAR_VWP", false);
    private Hashtable fileToAdapter = new Hashtable();
    public static final DataCategory CATEGORY_RASTER_2D = DataCategory.parseCategory("IMAGE-RASTER", false);
    public static final DataCategory CATEGORY_RASTER_2D_TIME = DataCategory.parseCategory("IMAGE-RASTER-TIME", false);

    public RadarDataSource() {
    }

    public RadarDataSource(DataSourceDescriptor descriptor, List sources, String description, Hashtable properties) throws VisADException {
        super(descriptor, sources, sources.size() == 1 ? (String)sources.get(0) : description, description, properties);
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        return !this.isFileBased() && this.getProperty("prop.service.http") != null;
    }

    @Override
    protected String processDataFilename(String filename, int index) {
        Hashtable properties = (Hashtable)this.getProperty("prop.subproperties" + index);
        if (properties == null) {
            return filename;
        }
        String httpServer = (String)properties.get("prop.service.http");
        if (httpServer != null) {
            return httpServer;
        }
        return filename;
    }

    @Override
    public void initAfterUnpersistence() {
        super.initAfterUnpersistence();
        Integer mostRecent = null;
        if (this.getProperties() != null && (mostRecent = (Integer)this.getProperties().get("datasource.mostrecent")) == null) {
            mostRecent = (Integer)this.getProperties().get("radar.mostrecent");
        }
        if (mostRecent != null && mostRecent > 0) {
            this.getPollingInfo().setFileCount(mostRecent);
        }
    }

    protected abstract RadarAdapter makeRadarAdapter(String var1) throws Exception;

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        List<RadarAdapter> adapters = this.getAdapters();
        for (RadarAdapter adapter : adapters) {
            adapter.clearCachedData();
        }
    }

    protected List<RadarAdapter> getAdapters() {
        if (this.adapters == null || this.adapters.size() == 0) {
            try {
                this.makeAdapters(this.sources);
            }
            catch (Exception exc) {
                this.setInError(true);
                throw new WrapperException(exc);
            }
        }
        if (this.adapters.size() == 0) {
            this.adapters = null;
        }
        return this.adapters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void makeAdapters(List files) throws Exception {
        this.adapters = new ArrayList();
        Hashtable oldAdapterMap = this.fileToAdapter;
        this.fileToAdapter = new Hashtable();
        int cnt = 0;
        final ArrayList badFiles = new ArrayList();
        final ArrayList badExceptions = new ArrayList();
        final ArrayList<RadarAdapter> goodAdapters = new ArrayList<RadarAdapter>();
        final ArrayList<String> goodFiles = new ArrayList<String>();
        ThreadManager threadManager = new ThreadManager("radar data initialization");
        LogUtil.message("Initializing radar files");
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            final String filename = iter.next().toString();
            RadarAdapter adapter = (RadarAdapter)oldAdapterMap.get(filename);
            ++cnt;
            if (adapter == null) {
                threadManager.addRunnable(new ThreadManager.MyRunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() throws Exception {
                        try {
                            RadarAdapter myAdapter = RadarDataSource.this.makeRadarAdapter(filename);
                            List list = goodAdapters;
                            synchronized (list) {
                                goodAdapters.add(myAdapter);
                                goodFiles.add(filename);
                            }
                        }
                        catch (Exception e) {
                            List list = badExceptions;
                            synchronized (list) {
                                badExceptions.add(e);
                                badFiles.add(filename);
                            }
                        }
                    }
                });
                continue;
            }
            goodAdapters.add(adapter);
            goodFiles.add(filename);
        }
        threadManager.runInParallel(this.getDataContext().getIdv().getMaxDataThreadCount());
        LogUtil.message("");
        for (int i = 0; i < goodAdapters.size(); ++i) {
            this.adapters.add(goodAdapters.get(i));
            this.fileToAdapter.put(goodFiles.get(i), goodAdapters.get(i));
        }
        if (!badFiles.isEmpty()) {
            StringBuffer buf = new StringBuffer();
            if (badFiles.size() >= files.size()) throw (Exception)badExceptions.get(0);
            buf.append("<html>");
            buf.append("There were problems reading these files:");
            buf.append("<ul>");
            Iterator iterator = badFiles.iterator();
            while (iterator.hasNext()) {
                buf.append("<li>");
                buf.append((String)iterator.next());
                buf.append("</li>");
            }
            buf.append("</ul>");
            buf.append("<p>Continue loading good data?<p></html>");
            boolean ok = GuiUtils.askYesNo("Error reading data", buf.toString());
            ((Exception)badExceptions.get(0)).printStackTrace();
            if (!ok) throw new VisADException("error reading files");
            files.removeAll(badFiles);
        }
        for (String source : oldAdapterMap.keySet()) {
            if (this.fileToAdapter.get(source) != null) continue;
            ((RadarAdapter)oldAdapterMap.get(source)).doRemove();
        }
    }

    @Override
    protected List doMakeDateTimes() {
        ArrayList<Comparable> times = new ArrayList<Comparable>();
        boolean isRealTime = this.isRealTime();
        List<RadarAdapter> adapters = this.getAdapters();
        for (int i = 0; i < adapters.size(); ++i) {
            if (!isRealTime) {
                times.add(adapters.get(i).getBaseTime());
                continue;
            }
            String name = i + "th most recent";
            if (i == 0) {
                name = "Most recent";
            }
            if (i > 0 && i < DataSource.ordinalNames.length) {
                name = DataSource.ordinalNames[i] + " most recent";
            }
            times.add(new TwoFacedObject((Object)name, i));
        }
        Collections.sort(times);
        return times;
    }

    protected boolean isRealTime() {
        return this.getPollingInfo().getFileCount() > 0;
    }

    @Override
    protected Data getDataInner(final DataChoice dataChoice, DataCategory category, final DataSelection subset, final Hashtable requestProperties) throws VisADException, RemoteException {
        try {
            int i;
            List<DateTime> dtimes;
            List times = null;
            Object cu = subset.getProperty("Use_Display_Driver_Times");
            if (cu != null) {
                this.useDriverTime = (Boolean)cu;
            }
            if (subset != null) {
                times = this.getTimesFromDataSelection(subset, dataChoice);
            }
            if (times == null) {
                times = dataChoice.getSelectedDateTimes();
            }
            if ((dtimes = subset.getTimeDriverTimes()) != null && !this.useDriverTime) {
                this.useDriverTime = true;
            }
            List<RadarAdapter> adapters = this.getAdapters();
            Object[] realDateTimes = new DateTime[adapters.size()];
            for (int i2 = 0; i2 < adapters.size(); ++i2) {
                realDateTimes[i2] = adapters.get(i2).getBaseTime();
            }
            Arrays.sort(realDateTimes);
            boolean isRealTime = this.isRealTime();
            if (isRealTime) {
                realDateTimes = (DateTime[])Misc.reverseArray(realDateTimes, new DateTime[realDateTimes.length]);
            }
            if (this.useDriverTime) {
                List tests = this.resetTimesList((DateTime[])realDateTimes, times);
                if (!this.compareTimeLists(times, tests)) {
                    this.reloadData();
                    adapters = this.getAdapters();
                    realDateTimes = new DateTime[adapters.size()];
                    for (i = 0; i < adapters.size(); ++i) {
                        realDateTimes[i] = adapters.get(i).getBaseTime();
                    }
                    Arrays.sort(realDateTimes);
                    isRealTime = this.isRealTime();
                    if (isRealTime) {
                        realDateTimes = (DateTime[])Misc.reverseArray(realDateTimes, new DateTime[realDateTimes.length]);
                    }
                    tests = this.resetTimesList((DateTime[])realDateTimes, times);
                }
                times = tests;
            }
            Object[] dateTimes = null;
            if (times == null || times.size() == 0) {
                dateTimes = realDateTimes;
            } else {
                dateTimes = new DateTime[times.size()];
                for (i = 0; i < times.size(); ++i) {
                    Object time = times.get(i);
                    if (time instanceof TwoFacedObject) {
                        int index = (Integer)((TwoFacedObject)time).getId();
                        dateTimes[i] = realDateTimes[index];
                        continue;
                    }
                    if (!(time instanceof DateTime)) continue;
                    dateTimes[i] = (DateTime)time;
                }
            }
            Arrays.sort(dateTimes);
            final Data[] datas = new Data[dateTimes.length];
            int timeIndex = 0;
            final MathType[] mt = new MathType[]{null};
            int cnt = 0;
            ThreadManager threadManager = new ThreadManager("radar data reading");
            for (final RadarAdapter adapter : adapters) {
                timeIndex = Arrays.binarySearch(dateTimes, adapter.getBaseTime());
                if (timeIndex < 0) continue;
                LogUtil.message("Time: " + ++cnt + "/" + dateTimes.length + " From:" + this.toString());
                final int theTimeIndex = timeIndex;
                threadManager.addRunnable(new ThreadManager.MyRunnable(){

                    @Override
                    public void run() throws Exception {
                        Trace.call1("RDS.getData");
                        DataImpl d = adapter.getData(dataChoice, subset, requestProperties);
                        Trace.call2("RDS.getData");
                        datas[theTimeIndex] = d;
                        if (d != null) {
                            mt[0] = d.getType();
                        }
                    }
                });
            }
            try {
                threadManager.runInParallel(this.getDataContext().getIdv().getMaxDataThreadCount());
            }
            catch (VisADException ve) {
                LogUtil.printMessage(ve.toString());
            }
            if (mt[0] == null) {
                return null;
            }
            FunctionType ft = new FunctionType(RealType.Time, mt[0]);
            SampledSet domainSet = dateTimes.length == 1 ? new SingletonSet(new RealTuple((Real[])dateTimes)) : CalendarDateTime.makeTimeSet((DateTime[])dateTimes);
            FieldImpl fi = new FieldImpl(ft, domainSet);
            fi.setSamples(datas, false);
            return fi;
        }
        catch (Exception exc) {
            this.logException("Creating obs", exc);
            return null;
        }
    }

    private boolean compareTimeLists(List<DateTime> timesA, List<DateTime> timesB) {
        if (timesA.size() != timesB.size()) {
            return false;
        }
        Collections.sort(timesA);
        Collections.sort(timesB);
        for (int i = 0; i < timesA.size(); ++i) {
            DateTime a = timesA.get(i);
            DateTime b = timesB.get(i);
            double test = Math.abs(a.getValue() - b.getValue());
            if (!(test > 65.0)) continue;
            return false;
        }
        return true;
    }

    private List resetTimesList(DateTime[] realDateTimes, List<DateTime> times) {
        ArrayList<DateTime> results = new ArrayList<DateTime>();
        int len = realDateTimes.length;
        HashSet<Date> seenTimes = new HashSet<Date>();
        try {
            for (DateTime dateTime : times) {
                Date dttm = Util.makeDate(dateTime);
                long minTimeDiff = -1L;
                Date minDate = null;
                for (int i = 0; i < len; ++i) {
                    Date sourceDate = Util.makeDate(realDateTimes[i]);
                    long timeDiff = Math.abs(sourceDate.getTime() - dttm.getTime());
                    if (minTimeDiff >= 0L && timeDiff >= minTimeDiff) continue;
                    minTimeDiff = timeDiff;
                    minDate = sourceDate;
                }
                if (minDate == null || seenTimes.contains(minDate)) continue;
                results.add(new DateTime(minDate));
                seenTimes.add(minDate);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }

    protected List<RadarAdapter> getRadarAdapters() {
        return this.getAdapters();
    }

    @Override
    public void doRemove() {
        if (this.getAdapters() != null) {
            for (RadarAdapter ra : this.getAdapters()) {
                ra.doRemove();
            }
        }
        super.doRemove();
    }
}

