/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.radar.RadarAdapter;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.ObjectPair;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.DataImpl;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.bom.Radar2DCoordinateSystem;
import visad.bom.Radar3DCoordinateSystem;
import visad.georef.EarthLocationTuple;

public class NetcdfSweepfileAdapter
implements RadarAdapter {
    private DataImpl myData = null;
    private DateTime baseTime = null;
    private NetcdfDataset ncFile;
    private String location;
    private DataSourceImpl dataSource;
    private RealType[] paramTypes;
    private GriddedSet radarDomain2d;
    private GriddedSet radarDomain3d;
    private Unit[] units;
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(NetcdfSweepfileAdapter.class.getName());

    public NetcdfSweepfileAdapter() {
    }

    public NetcdfSweepfileAdapter(String location) throws VisADException {
        this(null, location);
    }

    public NetcdfSweepfileAdapter(DataSourceImpl source, String location) throws VisADException {
        this.dataSource = source;
        this.location = location;
        try {
            this.init();
        }
        catch (Exception ex) {
            LogUtil.logException("Netcdf sweep error:init", ex);
            throw new VisADException(ex.toString());
        }
    }

    protected void init() throws Exception {
        this.ncFile = NetcdfDataset.openDataset(this.location);
        this.loadData(this.ncFile);
    }

    @Override
    public void clearCachedData() {
    }

    public DataImpl getData() {
        if (this.myData == null) {
            this.myData = this.getField(this.paramTypes[0]);
        }
        return this.myData;
    }

    @Override
    public DateTime getBaseTime() {
        return this.baseTime;
    }

    public DataImpl getField(RealType type) {
        FlatField imp = null;
        try {
            imp = this.makeField(type, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imp;
    }

    @Override
    public DataImpl getData(DataChoice dataChoice, DataSelection subset, Hashtable requestProperties) throws VisADException, RemoteException {
        String prop2dOr3d;
        if (requestProperties == null) {
            requestProperties = dataChoice.getProperties() != null ? dataChoice.getProperties() : new Hashtable();
        }
        boolean use3d = (prop2dOr3d = (String)requestProperties.get("Level2RadarDataSource.2Dor3D")) != null && prop2dOr3d.equals("Level2RadarDataSource.3D");
        ObjectPair cacheKey = new ObjectPair(this.location, new ObjectPair(dataChoice, new Boolean(use3d)));
        FlatField singleSweep = null;
        if (this.dataSource != null) {
            singleSweep = (FlatField)this.dataSource.getCache(cacheKey);
        }
        if (singleSweep != null) {
            return singleSweep;
        }
        RealType pType = (RealType)dataChoice.getId();
        singleSweep = this.makeField(pType, use3d);
        if (this.dataSource != null) {
            this.dataSource.putCache(cacheKey, singleSweep);
        }
        return singleSweep;
    }

    private FlatField makeField(RealType pType, boolean use3d) throws VisADException, RemoteException {
        GriddedSet radarDomain = use3d ? this.radarDomain3d : this.radarDomain2d;
        log_.debug(radarDomain.toString());
        RealTupleType domainType = ((SetType)radarDomain.getType()).getDomain();
        int unitIndex = -1;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (!this.paramTypes[i].equals(pType)) continue;
            unitIndex = i;
            break;
        }
        Unit u = this.units[unitIndex];
        FunctionType ftype = new FunctionType(domainType, pType);
        FlatField singleSweep = new FlatField(ftype, (Set)radarDomain, (CoordinateSystem[])null, (Set[])null, new Unit[]{u});
        float[][] rangeValues = new float[0][radarDomain.getLength()];
        Array arr = null;
        try {
            Variable v = this.ncFile.findVariable(pType.getName());
            arr = v.read();
        }
        catch (IOException ioe) {
            LogUtil.logException("Netcdf sweep error", ioe);
        }
        singleSweep.setSamples(new float[][]{(float[])arr.get1DJavaArray(Float.TYPE)}, false);
        return singleSweep;
    }

    private void loadData(NetcdfDataset ncFile) throws VisADException, RemoteException, IOException {
        Real lat = new Real(RealType.Latitude, this.getValue("Latitude"));
        Real lon = new Real(RealType.Longitude, this.getValue("Longitude"));
        Real alt = new Real(RealType.Altitude, this.getValue("Altitude"));
        EarthLocationTuple location = new EarthLocationTuple(lat, lon, alt);
        log_.debug("Station at :" + location);
        this.baseTime = new DateTime(this.getValue("base_time"));
        log_.debug("Base Time:" + this.baseTime);
        Variable azimuth = ncFile.findVariable("Azimuth");
        int numRays = azimuth.getShape()[0];
        log_.debug("number of rays = " + numRays);
        Variable elevation = ncFile.findVariable("Elevation");
        float range = (float)this.getValue("Range_to_First_Cell");
        if (Float.isNaN(range)) {
            range = 0.0f;
        }
        float cellSpacing = (float)this.getValue("Cell_Spacing");
        log_.debug("range = " + range);
        Dimension maxCells = ncFile.getRootGroup().findDimension("maxCells");
        int numGates = maxCells.getLength();
        log_.debug("numGates = " + numGates);
        ImmutableList<Variable> vi = ncFile.getVariables();
        Vector<String> vars2D = new Vector<String>();
        for (Variable v : vi) {
            int[] lengths;
            if (v.getRank() != 2 || (lengths = v.getShape())[0] != numRays || lengths[1] != numGates) continue;
            vars2D.add(v.getName());
        }
        if (vars2D.isEmpty()) {
            throw new VisADException("No variables to display");
        }
        this.paramTypes = new RealType[vars2D.size()];
        this.units = new Unit[vars2D.size()];
        for (int i = 0; i < vars2D.size(); ++i) {
            Variable v2d = ncFile.findVariable((String)vars2D.get(i));
            this.units[i] = this.getUnit(v2d);
            this.paramTypes[i] = RealType.getRealType(v2d.getName(), this.units[i], null);
            log_.debug("found param " + this.paramTypes[i]);
        }
        float centerOfFirstCell = range + 0.5f * cellSpacing;
        Radar3DCoordinateSystem rcs3d = new Radar3DCoordinateSystem((float)lat.getValue(), (float)lon.getValue(), (float)alt.getValue(), centerOfFirstCell, cellSpacing, 0.0f, 1.0f, 0.0f, 1.0f);
        log_.debug(((Object)rcs3d).toString());
        Radar2DCoordinateSystem rcs2d = new Radar2DCoordinateSystem((float)lat.getValue(), (float)lon.getValue(), centerOfFirstCell, cellSpacing, 0.0f, 1.0f);
        log_.debug(((Object)rcs2d).toString());
        Unit[] domUnits3d = new Unit[]{CommonUnit.meter, CommonUnit.degree, CommonUnit.degree};
        Unit[] domUnits2d = new Unit[]{CommonUnit.meter, CommonUnit.degree};
        float[][] domainVals3d = new float[3][numRays * numGates];
        float[][] domainVals2d = new float[2][];
        Array azs = azimuth.read();
        float[] azimuths = (float[])azs.get1DJavaArray(Float.TYPE);
        Array els = elevation.read();
        float[] elevations = (float[])els.get1DJavaArray(Float.TYPE);
        for (int ray = 0; ray < numRays; ++ray) {
            for (int cell = 0; cell < numGates; ++cell) {
                int elem = ray * numGates + cell;
                domainVals3d[0][elem] = cell;
                domainVals3d[1][elem] = azimuths[ray];
                domainVals3d[2][elem] = elevations[ray];
            }
        }
        domainVals2d[0] = domainVals3d[0];
        domainVals2d[1] = domainVals3d[1];
        RealTupleType radar3dType = new RealTupleType(RANGE_TYPE, AZIMUTH_TYPE, ELEVATION_ANGLE_TYPE, rcs3d, null);
        RealTupleType radar2dType = new RealTupleType(RANGE_TYPE, AZIMUTH_TYPE, rcs2d, (Set)null);
        try {
            this.radarDomain3d = new Gridded3DSet((MathType)radar3dType, domainVals3d, numGates, numRays, null, domUnits3d, (ErrorEstimate[])null, false);
            this.radarDomain2d = new Gridded2DSet(radar2dType, domainVals2d, numGates, numRays, null, domUnits2d, null, false, false);
        }
        catch (VisADException vae) {
            System.err.println("radarDomain2d: " + this.radarDomain2d + "\n" + "radarDomain3d: " + this.radarDomain3d + "\n" + "numGates: " + numGates + "\n" + "numRays: " + numRays + "\n" + "domainVals.length " + domainVals3d.length + "\n" + "domainVals[0].length " + domainVals3d[0].length + "\n");
            throw vae;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof NetcdfSweepfileAdapter)) {
            return false;
        }
        NetcdfSweepfileAdapter nsa = (NetcdfSweepfileAdapter)o;
        return this.location.equals(nsa.location);
    }

    public int hashCode() {
        int hashCode = this.location.hashCode();
        return hashCode;
    }

    protected RealType[] getParams() {
        return this.paramTypes;
    }

    private double getValue(String name) {
        Variable v = this.ncFile.findVariable(name);
        double val = Double.NaN;
        if (v != null) {
            try {
                Array data = v.read();
                val = data.getDouble(data.getIndex());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return val;
    }

    @Override
    public String getName() {
        return this.location;
    }

    private Unit getUnit(Variable v) {
        Attribute a = v.findAttribute("units");
        String unitName = "";
        if (a != null) {
            unitName = a.getStringValue();
        } else {
            System.out.println("no unit for variable " + v);
        }
        Unit u = DataUtil.parseUnit(unitName);
        return u;
    }

    @Override
    public void doRemove() {
    }
}

