/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.radar.NetcdfSweepfileAdapter;
import ucar.unidata.data.radar.RadarAdapter;
import ucar.unidata.data.radar.RadarDataSource;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlEncoder;
import visad.RealType;
import visad.VisADException;

public class NetcdfRadarDataSource
extends RadarDataSource {
    DataSourceDescriptor descriptor = null;
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(NetcdfRadarDataSource.class.getName());
    private static final String DATA_DESCRIPTION = "Netcdf Sweep Data";

    public NetcdfRadarDataSource() {
    }

    public NetcdfRadarDataSource(DataSourceDescriptor descriptor, String fileName, Hashtable properties) throws VisADException {
        this(descriptor, Misc.newList(fileName), properties);
    }

    public NetcdfRadarDataSource(DataSourceDescriptor descriptor, List sources, Hashtable properties) throws VisADException {
        super(descriptor, sources, DATA_DESCRIPTION, properties);
        this.descriptor = descriptor;
    }

    @Override
    public void doMakeDataChoices() {
        List categories = Misc.newList(CATEGORY_SWEEP_2D);
        NetcdfSweepfileAdapter nsa = (NetcdfSweepfileAdapter)this.getRadarAdapters().get(0);
        RealType[] paramTypes = nsa.getParams();
        for (int i = 0; i < paramTypes.length; ++i) {
            String paramName = paramTypes[i].getName();
            this.addDataChoice(new DirectDataChoice((DataSource)this, (Object)paramTypes[i], paramName, paramName, categories, DataChoice.NULL_PROPERTIES));
        }
    }

    @Override
    protected RadarAdapter makeRadarAdapter(String source) throws Exception {
        source = this.convertSourceFile(source);
        NetcdfSweepfileAdapter adapter = new NetcdfSweepfileAdapter(this, source);
        return adapter;
    }

    @Override
    public String convertSourceFile(String source) throws Exception {
        if (this.descriptor != null && this.descriptor.getNcmlTemplate() != null) {
            String ncml = IOUtil.readContents(this.descriptor.getNcmlTemplate(), this.getClass());
            String file = this.getDataContext().getObjectStore().getUniqueTmpFile("ncmltemplate", ".ncml");
            ncml = ncml.replace("%location%", "" + IOUtil.getURL(source, this.getClass()));
            IOUtil.writeFile(file, ncml);
            return file;
        }
        source = source.replace(":-1/", "/");
        return source;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof NetcdfRadarDataSource)) {
            return false;
        }
        return this == (NetcdfRadarDataSource)o;
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        return hashCode;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: NetcdfRadarDataSource <dorade_sweepfile>");
            System.exit(1);
        }
        try {
            DataSourceDescriptor dsDesc = new DataSourceDescriptor("NetCDF.SWEEP", "test label", null, NetcdfRadarDataSource.class, "ncswp\\.*$", true, false, null);
            NetcdfRadarDataSource dds = new NetcdfRadarDataSource(dsDesc, args[0], null);
            System.out.println("created " + dds.getName() + " (" + dds.getDescription() + ")");
            XmlEncoder encoder = new XmlEncoder();
            String xmlString = encoder.toXml(dds);
            System.out.println("saved to XML");
            dds = (NetcdfRadarDataSource)encoder.toObject(xmlString);
            dds.initAfterUnpersistence();
            System.out.println("restored " + dds.getName() + " (" + dds.getDescription() + ")");
            System.out.println("sweep time is " + dds.doMakeDateTimes().get(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

