/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

import java.io.EOFException;
import java.io.IOException;
import ucar.netcdf.RandomAccessFile;

public class Level2Record {
    public static final int RECORD_HEADER_SIZE = 12;
    public static final int FILE_HEADER_SIZE = 24;
    public static final int RADAR_DATA_SIZE = 2432;
    public static final int REFLECTIVITY = 0;
    public static final int VELOCITY = 1;
    public static final int SPECTRUM_WIDTH = 2;
    public static final int SIGNAL_BELOW_THRESHOLD = 999;
    public static final int SIGNAL_OVERLAID = 998;
    public static final int DATA_NOT_FOUND = 997;
    public static final int DOPPLER_RESOLUTION_LOW_CODE = 4;
    public static final int DOPPLER_RESOLUTION_HIGH_CODE = 2;
    public static final float DOPPLER_RESOLUTION_LOW = 1.0f;
    public static final float DOPPLER_RESOLUTION_HIGH = 0.5f;
    public static final int MAX_RADIALS_IN_CUT = 500;
    public static final float HORIZONTAL_BEAM_WIDTH = 1.5f;
    public static final float KM_PER_NM = 1.94f;
    public static int data_lut_init_flag = 0;
    public static float[] Reflectivity_LUT = new float[256];
    public static float[] Velocity_1km_LUT = new float[256];
    public static float[] Velocity_hkm_LUT = new float[256];
    int eof_flag = 0;
    short message_size = 0;
    byte channel = 0;
    byte message_type = 0;
    short id_sequence = 0;
    short julian_date = 0;
    int milliseconds = 0;
    short number_segs = 0;
    short seg_number = 0;
    int time = 0;
    short julian = 0;
    short unamb_range = 0;
    int azimuth_ang = 0;
    short azimuth_num = 0;
    short radial_status = 0;
    short elevation_ang = 0;
    short elevation_num = 0;
    short first_bin = 0;
    short doppler_range = 0;
    short surv_size = 0;
    short dopl_size = 0;
    short surv_bins = 0;
    short dopl_bins = 0;
    short cut = 0;
    float calibration = 0.0f;
    short surv_pointer = 0;
    short vel_pointer = 0;
    short spw_pointer = 0;
    short resolution = 0;
    short vcp = 0;
    byte[][] bins = new byte[500][2400];

    public void readAngles(RandomAccessFile din, int record) {
        try {
            boolean count = false;
            long offset = 0L;
            offset = record * 2432 + 24;
            din.seek(offset);
            din.skipBytes(12);
            this.message_size = din.readShort();
            this.channel = din.readByte();
            this.message_type = din.readByte();
            din.skipBytes(20);
            this.azimuth_ang = din.readUnsignedShort();
            din.skipBytes(4);
            this.elevation_ang = din.readShort();
            this.elevation_num = din.readShort();
        }
        catch (EOFException e) {
            this.eof_flag = 1;
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void readHeader(RandomAccessFile din, int record) {
        try {
            boolean count = false;
            long offset = 0L;
            offset = record * 2432 + 24;
            din.seek(offset);
            din.skipBytes(12);
            this.message_size = din.readShort();
            this.channel = din.readByte();
            this.message_type = din.readByte();
            this.id_sequence = din.readShort();
            this.julian_date = din.readShort();
            this.milliseconds = din.readInt();
            this.number_segs = din.readShort();
            this.seg_number = din.readShort();
            this.time = din.readInt();
            this.julian = din.readShort();
            this.unamb_range = din.readShort();
            this.azimuth_ang = din.readUnsignedShort();
            this.azimuth_num = din.readShort();
            this.radial_status = din.readShort();
            this.elevation_ang = din.readShort();
            this.elevation_num = din.readShort();
            this.first_bin = din.readShort();
            this.doppler_range = din.readShort();
            this.surv_size = din.readShort();
            this.dopl_size = din.readShort();
            this.surv_bins = din.readShort();
            this.dopl_bins = din.readShort();
            this.cut = din.readShort();
            this.calibration = din.readFloat();
            this.surv_pointer = din.readShort();
            this.vel_pointer = din.readShort();
            this.spw_pointer = din.readShort();
            this.resolution = din.readShort();
            this.vcp = din.readShort();
            din.skipBytes(14);
            short nyquist_vel = din.readShort();
            short attenuation = din.readShort();
            short tover = din.readShort();
            short spot_blanking = din.readShort();
            din.skipBytes(2332);
        }
        catch (EOFException e) {
            this.eof_flag = 1;
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void readRecord(RandomAccessFile din, int record) {
        try {
            boolean count = false;
            long offset = 0L;
            offset = record * 2432 + 24;
            din.seek(offset);
            din.skipBytes(12);
            this.message_size = din.readShort();
            this.channel = din.readByte();
            this.message_type = din.readByte();
            this.id_sequence = din.readShort();
            this.julian_date = din.readShort();
            this.milliseconds = din.readInt();
            this.number_segs = din.readShort();
            this.seg_number = din.readShort();
            this.time = din.readInt();
            this.julian = din.readShort();
            this.unamb_range = din.readShort();
            this.azimuth_ang = din.readUnsignedShort();
            this.azimuth_num = din.readShort();
            this.radial_status = din.readShort();
            this.elevation_ang = din.readShort();
            this.elevation_num = din.readShort();
            this.first_bin = din.readShort();
            this.doppler_range = din.readShort();
            this.surv_size = din.readShort();
            this.dopl_size = din.readShort();
            this.surv_bins = din.readShort();
            this.dopl_bins = din.readShort();
            this.cut = din.readShort();
            this.calibration = din.readFloat();
            this.surv_pointer = din.readShort();
            this.vel_pointer = din.readShort();
            this.spw_pointer = din.readShort();
            this.resolution = din.readShort();
            this.vcp = din.readShort();
            din.skipBytes(14);
            short nyquist_vel = din.readShort();
            short attenuation = din.readShort();
            short tover = din.readShort();
            short spot_blanking = din.readShort();
            din.skipBytes(32);
            din.readFully(this.bins[0], 0, 2304);
        }
        catch (EOFException e) {
            this.eof_flag = 1;
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public int readCut(RandomAccessFile din, int record) {
        int i = 0;
        boolean j = false;
        try {
            boolean count = false;
            long offset = 0L;
            short old_elevation_num = 99;
            this.readRecord(din, record);
            old_elevation_num = 999;
            for (i = 0; i < 500; ++i) {
                offset = (record + i) * 2432 + 24;
                din.seek(offset);
                din.skipBytes(15);
                this.message_type = din.readByte();
                if (this.message_type != 1) continue;
                din.skipBytes(28);
                this.elevation_num = din.readShort();
                if (this.elevation_num > old_elevation_num) break;
                old_elevation_num = this.elevation_num;
                din.skipBytes(82);
                din.readFully(this.bins[i], 0, 2304);
            }
            return i;
        }
        catch (EOFException e) {
            this.eof_flag = 1;
            return i;
        }
        catch (IOException e) {
            System.err.println(e);
            return i;
        }
    }

    public float getAzimuth() {
        if (this.message_type != 1) {
            return -1.0f;
        }
        return 180.0f * (float)this.azimuth_ang / 32768.0f;
    }

    public float getElevation() {
        return 180.0f * (float)this.elevation_ang / 32768.0f;
    }

    public short getElevationNum() {
        return this.elevation_num;
    }

    public short getMessageType() {
        return this.message_type;
    }

    public short getVCP() {
        return this.vcp;
    }

    public int eof() {
        return this.eof_flag;
    }

    public int getBinSize(int moment) {
        switch (moment) {
            case 0: {
                return this.surv_size;
            }
            case 1: 
            case 2: {
                return this.dopl_size;
            }
        }
        return 0;
    }

    public int getBinNum(int moment) {
        switch (moment) {
            case 0: {
                return this.surv_bins;
            }
            case 1: 
            case 2: {
                return this.dopl_bins;
            }
        }
        return 0;
    }

    public int getBinData(int moment, int radial, int bin) {
        int value = 997;
        switch (moment) {
            case 0: {
                value = this.bins[radial][this.surv_pointer - 100 + bin] >= 0 ? this.bins[radial][this.surv_pointer - 100 + bin] : 256 + this.bins[radial][this.surv_pointer - 100 + bin];
                break;
            }
            case 1: {
                value = this.bins[radial][this.vel_pointer - 100 + bin] >= 0 ? this.bins[radial][this.vel_pointer - 100 + bin] : 256 + this.bins[radial][this.vel_pointer - 100 + bin];
                break;
            }
            case 2: {
                value = this.bins[radial][this.spw_pointer - 100 + bin] >= 0 ? this.bins[radial][this.spw_pointer - 100 + bin] : 256 + this.bins[radial][this.spw_pointer - 100 + bin];
            }
        }
        return value;
    }

    public float getBinValue(int moment, int radial, int bin) {
        switch (moment) {
            case 0: {
                int value = this.bins[radial][this.surv_pointer - 100 + bin] >= 0 ? this.bins[radial][this.surv_pointer - 100 + bin] : 256 + this.bins[radial][this.surv_pointer - 100 + bin];
                return Reflectivity_LUT[value];
            }
            case 1: {
                int value;
                int n = value = this.bins[radial][this.vel_pointer - 100 + bin] >= 0 ? this.bins[radial][this.vel_pointer - 100 + bin] : 256 + this.bins[radial][this.vel_pointer - 100 + bin];
                if ((float)this.resolution == 1.0f) {
                    return Velocity_1km_LUT[value];
                }
                return Velocity_hkm_LUT[value];
            }
            case 2: {
                int value = this.bins[radial][this.spw_pointer - 100 + bin] >= 0 ? this.bins[radial][this.spw_pointer - 100 + bin] : 256 + this.bins[radial][this.spw_pointer - 100 + bin];
                return Velocity_hkm_LUT[value];
            }
        }
        return Float.NaN;
    }

    static {
        Level2Record.Reflectivity_LUT[0] = Float.NaN;
        Level2Record.Reflectivity_LUT[1] = Float.NaN;
        Level2Record.Velocity_1km_LUT[0] = Float.NaN;
        Level2Record.Velocity_1km_LUT[1] = Float.NaN;
        Level2Record.Velocity_hkm_LUT[0] = Float.NaN;
        Level2Record.Velocity_hkm_LUT[1] = Float.NaN;
        for (int i = 2; i < 256; ++i) {
            Level2Record.Reflectivity_LUT[i] = (float)((double)i / 2.0 - 33.0);
            Level2Record.Velocity_1km_LUT[i] = (float)((double)i - 129.0);
            Level2Record.Velocity_hkm_LUT[i] = (float)((double)i / 2.0 - 64.5);
        }
    }
}

