/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.radar.Level2Adapter;
import ucar.unidata.data.radar.RadarAdapter;
import ucar.unidata.data.radar.RadarDataSource;
import ucar.unidata.metdata.NamedStation;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectArray;
import visad.Real;
import visad.VisADException;

public class Level2RadarDataSource
extends RadarDataSource {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(Level2RadarDataSource.class.getName());
    private static final String DATA_DESCRIPTION = "Level II Radar Data";
    private String stationName = "";
    private static NamedStationTable nexradStations = null;
    private JComboBox stationBox;

    public Level2RadarDataSource() {
    }

    public Level2RadarDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        this(descriptor, new String[]{source}, properties);
    }

    public Level2RadarDataSource(DataSourceDescriptor descriptor, String[] sources, Hashtable properties) throws VisADException {
        this(descriptor, Misc.toList(sources), properties);
    }

    public Level2RadarDataSource(DataSourceDescriptor descriptor, List sources, Hashtable properties) throws VisADException {
        super(descriptor, sources, DATA_DESCRIPTION, properties);
        NamedStation ns = this.getProperties() != null ? (NamedStation)this.getProperties().get("station location") : null;
        String name = DATA_DESCRIPTION;
        if (sources.size() > 0) {
            name = sources.get(0).toString();
        }
        name = ns == null ? name : "Level II Radar Data (" + ns.getIdentifier() + ")";
        this.setName(name);
    }

    @Override
    public void doMakeDataChoices() {
        NamedStation namedStation;
        List<RadarAdapter> l2as = this.getRadarAdapters();
        if (l2as == null || l2as.isEmpty()) {
            return;
        }
        NamedStation namedStation2 = namedStation = this.getProperties() != null ? (NamedStation)this.getProperties().get("station location") : null;
        if (namedStation != null) {
            this.stationName = namedStation.getIdentifier() + " ";
        }
        double[] angles = ((Level2Adapter)l2as.get(0)).getAngles();
        String[] moments = new String[]{"Reflectivity", "Radial Velocity", "Spectrum Width"};
        boolean haveTimes = l2as.size() > 1;
        List volumeCategories = Misc.toList(new DataCategory[]{CATEGORY_RHI, CATEGORY_CAPPI, CATEGORY_VOLUME, CATEGORY_ISOSURFACE});
        List sweepCategories = haveTimes ? Misc.newList(CATEGORY_SWEEP_2D_TIME, CATEGORY_SWEEP_3D_TIME) : Misc.newList(CATEGORY_SWEEP_2D, CATEGORY_SWEEP_3D);
        volumeCategories.addAll(sweepCategories);
        try {
            for (int moment = 0; moment < moments.length; ++moment) {
                Integer momentObj = new Integer(moment);
                String momentName = moments[moment];
                Hashtable compositeProperties = Misc.newHashtable("Level2RadarDataSource.angles", angles, "station location", namedStation, "Level2RadarDataSource.volumeorsweep", "Level2RadarDataSource.volume");
                compositeProperties.put("prop.icon", "/auxdata/ui/icons/Radar.gif");
                CompositeDataChoice momentChoice = new CompositeDataChoice((DataSource)this, (Object)new ObjectArray(momentName, momentObj, "Level2RadarDataSource.3D"), this.stationName + " " + momentName, momentName, volumeCategories, compositeProperties);
                for (int i = 0; i < angles.length; ++i) {
                    String name = "Elevation Angle " + angles[i];
                    Hashtable dataChoiceProperties = Misc.newHashtable(new Object[]{"Level2RadarDataSource.angles", new double[]{angles[i]}, "Level2RadarDataSource.angle", new Double(angles[i]), "Level2RadarDataSource.volumeorsweep", "Level2RadarDataSource.sweep"});
                    dataChoiceProperties.put("prop.icon", "/auxdata/ui/icons/RadarAngle.gif");
                    if (namedStation != null) {
                        dataChoiceProperties.put("station location", namedStation);
                    }
                    momentChoice.addDataChoice(new DirectDataChoice((DataSource)this, (Object)new ObjectArray(new Double(angles[i]), momentObj, "Level2RadarDataSource.2D"), this.stationName + " " + momentName, momentName + " " + name, sweepCategories, dataChoiceProperties));
                }
                this.addDataChoice(momentChoice);
            }
        }
        catch (Exception excp) {
            this.logException("Creating data choices", excp);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Level2RadarDataSource)) {
            return false;
        }
        Level2RadarDataSource that = (Level2RadarDataSource)o;
        return this == that;
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        return hashCode;
    }

    @Override
    public void getPropertiesComponents(List comps) {
        NamedStation namedStation;
        super.getPropertiesComponents(comps);
        Vector items = new Vector();
        items.addAll(this.getStations().values());
        this.stationBox = new JComboBox(items);
        NamedStation namedStation2 = namedStation = this.getProperties() != null ? (NamedStation)this.getProperties().get("station location") : null;
        if (namedStation != null) {
            this.stationBox.setSelectedItem(namedStation);
        }
        comps.add(GuiUtils.rLabel("Station Location: "));
        comps.add(this.stationBox);
    }

    @Override
    public boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        Object o = this.stationBox.getSelectedItem();
        if (o instanceof NamedStation) {
            this.setStationInfo((NamedStation)o);
        }
        return true;
    }

    private void setStationInfo(NamedStation station) {
        if (station == null) {
            return;
        }
        Hashtable props = this.getProperties();
        if (props != null) {
            props.put("station location", station);
        } else {
            this.setProperties(Misc.newHashtable("station location", station));
        }
        this.setName(this.getName());
        this.setDescription(this.getName());
        List<RadarAdapter> l2as = this.getRadarAdapters();
        if (l2as != null) {
            for (int i = 0; i < l2as.size(); ++i) {
                try {
                    ((Level2Adapter)l2as.get(i)).setRadarLocation(station.getNamedLocation());
                    continue;
                }
                catch (Exception excp) {
                    this.logException("Couldn't set station on adapter", excp);
                }
            }
        }
        List l = this.getDataChoices();
        for (int i = 0; i < l.size(); ++i) {
            DataChoice dc = (DataChoice)l.get(i);
            Hashtable ht = dc.getProperties();
            if (ht != null) {
                ht.put("station location", station);
                continue;
            }
            dc.setProperties(Misc.newHashtable("station location", station));
        }
        this.reloadData();
    }

    @Override
    protected RadarAdapter makeRadarAdapter(String source) throws Exception {
        NamedStation ns = (NamedStation)this.getProperty("station location");
        return new Level2Adapter(this, source, ns != null ? ns.getNamedLocation() : null);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Must supply a file name");
            System.exit(1);
        }
        Level2RadarDataSource l2rds = new Level2RadarDataSource(null, args, null);
        Iterator iter = l2rds.getDataChoices().iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
        System.out.println("DateTimes:");
        iter = l2rds.getAllDateTimes().iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }

    public NamedStationTable getStations() {
        if (nexradStations == null) {
            nexradStations = this.getDataContext().getResourceManager().findLocations("NEXRAD Sites");
        }
        return nexradStations;
    }

    @Override
    public List getAllLevels(DataChoice dataChoice, DataSelection dataSelection) {
        dataSelection = DataSelection.merge(dataSelection, this.getDataSelection());
        ArrayList<Real> levels = new ArrayList<Real>();
        Hashtable props = dataChoice.getProperties();
        if (props == null || props.get("Level2RadarDataSource.angles") == null) {
            return levels;
        }
        double[] angles = (double[])props.get("Level2RadarDataSource.angles");
        for (int i = 0; i < angles.length; ++i) {
            levels.add(new Real(RadarAdapter.ELEVATION_ANGLE_TYPE, angles[i]));
        }
        return levels;
    }
}

