/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import ucar.netcdf.RandomAccessFile;
import ucar.unidata.data.DataContext;
import ucar.unidata.data.radar.Level2Record;
import ucar.unidata.io.bzip2.BZip2ReadException;
import ucar.unidata.io.bzip2.CBZip2InputStream;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;

public class Level2Data {
    private int skip_file_header = 24;
    private int skip_record_header = 12;
    private int RADAR_DATA_MSG_SIZE = 2432;
    private static final int FILE_HEADER_SIZE = 24;
    private int vcp = 0;
    private int old_cut = -1;
    private int end_of_volume = 0;
    private float[] azimuth = new float[10000];
    private float[] elevation = new float[10000];
    private float[] trueElevation = new float[100];
    private int[] cut_start = new int[100];
    private int numberOfCuts = 0;
    private int numberOfTrueCuts = 0;
    private float[] cutElevation = new float[100];
    private int[] cutIndex = new int[100];
    private float oldElevation = 0.0f;
    private float deltaElevation = 0.0f;
    private int number_of_records = 0;
    private int record = 0;
    private int timeSinceEpoch;
    private int millis;
    private boolean readAll = false;
    private RandomAccessFile din;
    private String filename = null;
    private DataContext context = null;
    private static final int DEFAULT_FILE_BUFFER = 204800;
    private static final int DEFAULT_HTTP_BUFFER = 204800;
    public static final String ARCHIVE2 = "ARCHIVE2";
    public static final String AR2V0001 = "AR2V0001";
    private String dataType = null;
    private int volumeNumber = 0;
    private String stationId = null;
    private byte[] fileHeader = new byte[24];
    private static LogUtil.LogCategory log_ = LogUtil.getLogInstance(Level2Data.class.getName());

    public Level2Data(File file, DataContext context) throws IOException {
        this(file.getAbsolutePath(), context);
    }

    public Level2Data(String filename, DataContext context) throws IOException {
        this.filename = filename;
        this.context = context;
        this.makeInputStream();
    }

    private void makeInputStream() throws IOException {
        this.din = new RandomAccessFile(this.filename, "r", 204800);
        log_.debug("reading from " + this.din);
        log_.debug("-----" + this.filename + "-----");
        log_.debug("\nLoading Data starting with record " + this.number_of_records + " Be patient!");
        this.din.seek(0L);
        this.din.readFully(this.fileHeader);
        this.readHeaderInfo();
        byte[] testArray = new byte[6];
        this.din.readFully(testArray);
        String bz = new String(testArray, 4, 2);
        if (bz.equals("BZ")) {
            File tmpfile;
            String fileTail = IOUtil.getFileTail(this.filename) + "_tmp";
            if (this.context == null) {
                String directory = "level2";
                IOUtil.makeDir(directory);
                tmpfile = new File(IOUtil.joinDir(directory, fileTail));
            } else {
                tmpfile = new File(this.context.getObjectStore().getTmpFile(fileTail));
            }
            RandomAccessFile dout = null;
            log_.debug("tmpfile = " + tmpfile);
            if (!tmpfile.exists()) {
                byte[] ubuff = new byte[40000];
                byte[] obuff = new byte[40000];
                CBZip2InputStream cbzip2 = new CBZip2InputStream();
                dout = new RandomAccessFile(tmpfile.toString(), "rw", 204800);
                log_.debug("writing to " + tmpfile + " " + dout);
                long start = System.currentTimeMillis();
                dout.write(this.fileHeader);
                this.din.seek(24L);
                int numCompBytes = 0;
                try {
                    while ((numCompBytes = this.din.readInt()) != -1) {
                        log_.debug("reading compressed bytes " + numCompBytes);
                        if (numCompBytes < 0) {
                            numCompBytes = -numCompBytes;
                        }
                        byte[] buf = new byte[numCompBytes];
                        this.din.readFully(buf);
                        ByteArrayInputStream bais = new ByteArrayInputStream(buf, 2, numCompBytes - 2);
                        cbzip2.setStream(bais);
                        int nread = 0;
                        int total = 0;
                        try {
                            while ((nread = cbzip2.read(ubuff)) != -1) {
                                if (total + nread > obuff.length) {
                                    byte[] temp = obuff;
                                    obuff = new byte[temp.length * 2];
                                    System.arraycopy(temp, 0, obuff, 0, temp.length);
                                }
                                System.arraycopy(ubuff, 0, obuff, total, nread);
                                total += nread;
                            }
                            dout.write(obuff, 0, total);
                        }
                        catch (BZip2ReadException bz2e) {
                            log_.debug("Exception reading data " + bz2e.getMessage());
                        }
                        log_.debug("reading num bytes at " + dout.getFilePointer());
                    }
                }
                catch (EOFException eOFException) {}
            } else {
                dout = new RandomAccessFile(tmpfile.toString(), "r", 204800);
            }
            this.filename = tmpfile.toString();
            this.din.close();
            this.din = dout;
        }
        this.readHeaderInfo();
        this.vcp = 0;
        this.number_of_records = 0;
    }

    private void readHeaderInfo() throws IOException {
        try {
            this.dataType = new String(this.fileHeader, 0, 8);
            this.volumeNumber = (int)Misc.parseDouble(new String(this.fileHeader, 9, 3));
            this.timeSinceEpoch = new DataInputStream(new ByteArrayInputStream(this.fileHeader, 12, 4)).readInt();
            this.millis = new DataInputStream(new ByteArrayInputStream(this.fileHeader, 16, 4)).readInt();
            this.stationId = new String(this.fileHeader, 20, 4).trim();
            if (this.stationId.equals("")) {
                this.stationId = null;
            }
            log_.debug("dataType = " + this.dataType);
            log_.debug("volume number = " + this.volumeNumber);
            log_.debug("stationId = >" + this.stationId + "<");
            log_.debug("timeSinceEpoch = " + this.timeSinceEpoch);
            log_.debug("millis = " + this.millis);
        }
        catch (Exception e) {
            throw new IOException("unable to read header information");
        }
    }

    public void read(int startFlag) {
        this.read(startFlag, false);
    }

    public void read(int startFlag, boolean onlyVCP) {
        byte[] bins = new byte[2332];
        Level2Record level2record = new Level2Record();
        this.record = this.number_of_records;
        while (this.record < 10000) {
            if (onlyVCP && this.vcp != 0) {
                log_.debug("vcp = " + this.vcp);
                return;
            }
            level2record.readHeader(this.din, this.record);
            if (level2record.eof() != 0) {
                this.cut_start[this.old_cut + 1] = this.record;
                log_.debug(" did read all");
                this.readAll = true;
                return;
            }
            if (level2record.radial_status != 1) {
                log_.debug("Radial status [" + level2record.radial_status + "] for record " + this.record);
            }
            this.end_of_volume = level2record.radial_status == 4 ? 1 : 0;
            if (level2record.getMessageType() == 1) {
                if (this.vcp == 0) {
                    this.vcp = level2record.vcp;
                }
                this.azimuth[this.record] = level2record.getAzimuth();
                this.elevation[this.record] = level2record.getElevation();
                if (this.old_cut != level2record.getElevationNum()) {
                    log_.debug("message_size [" + level2record.message_size + "]");
                    if (level2record.getElevationNum() > 0) {
                        log_.debug("New cut --> " + level2record.getElevationNum() + " angle[" + level2record.getElevation() + "] at record " + this.record);
                        this.old_cut = level2record.getElevationNum();
                        this.cut_start[level2record.getElevationNum() - 1] = this.record;
                        this.cutElevation[this.numberOfCuts] = this.elevation[this.record];
                        this.deltaElevation = Math.abs(this.elevation[this.record] - this.oldElevation);
                        if ((double)this.deltaElevation > 0.1) {
                            this.trueElevation[this.numberOfTrueCuts] = this.elevation[this.record];
                        }
                        this.oldElevation = this.elevation[this.record];
                        this.cutIndex[this.numberOfCuts] = ++this.numberOfTrueCuts;
                        ++this.numberOfCuts;
                        log_.debug("dBZ bins [" + level2record.getBinNum(0) + "]");
                        log_.debug("Vel bins [" + level2record.getBinNum(1) + "]");
                    } else {
                        return;
                    }
                }
                ++this.number_of_records;
            } else {
                log_.debug("Message type " + level2record.getMessageType() + " detected");
                this.azimuth[this.record] = -1.0f;
                this.elevation[this.record] = -1.0f;
            }
            ++this.record;
        }
        this.readAll = true;
    }

    public int getNumberOfTrueCuts() {
        return this.numberOfTrueCuts;
    }

    public int getCutIndex(int i) {
        if (i <= this.numberOfCuts) {
            return 0;
        }
        return this.cutIndex[i];
    }

    public int getNumberOfCuts() {
        return this.numberOfCuts;
    }

    public float getCutElevation(int i) {
        if (i >= this.numberOfCuts) {
            return -99.9f;
        }
        return this.cutElevation[i];
    }

    public float getTrueElevation(int i) {
        return this.trueElevation[i];
    }

    public int getCutStart(int cut_num) {
        if (!this.readAll) {
            this.read(0);
        }
        return this.cut_start[cut_num];
    }

    public float getAzimuth(int record) {
        if (!this.readAll) {
            this.read(0);
        }
        return this.azimuth[record];
    }

    public float getElevation(int record) {
        if (!this.readAll) {
            this.read(0);
        }
        return this.elevation[record];
    }

    public int numberOfRecords() {
        if (!this.readAll) {
            this.read(0);
        }
        return this.number_of_records;
    }

    public int getVCP() {
        return this.vcp;
    }

    public int getJulianDate() {
        return this.timeSinceEpoch;
    }

    public int getSecsSinceMidnight() {
        return this.millis;
    }

    public RandomAccessFile getDataInput() {
        return this.din;
    }

    public String getStationId() {
        return this.stationId;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getFilename() {
        return this.filename;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Must supply a filename");
            System.exit(1);
        }
        Level2Data data = new Level2Data(args[0], null);
        data.read(0, true);
        System.out.println("Reading from file " + data.getFilename());
        System.out.println("\tVCP = " + data.getVCP());
        System.out.println("\trecords = " + data.numberOfRecords());
        System.out.println("\tdate = " + data.getJulianDate());
        System.out.println("\ttime = " + data.getSecsSinceMidnight());
        System.out.println("\tnumber of cuts = " + data.getNumberOfCuts());
        System.out.println("\tnumber of true cuts = " + data.getNumberOfTrueCuts());
        Level2Record level2Record = new Level2Record();
        int k = 0;
        for (int i = 0; i < data.getNumberOfCuts(); ++i) {
            int l = data.getCutStart(i);
            level2Record.readHeader(data.getDataInput(), l);
            if (level2Record.surv_bins <= 0) continue;
            int j = (int)(data.getTrueElevation(++k - 1) * 100.0f);
            float f = (float)j / 100.0f;
            System.out.println(" angle for cut[" + i + "] = " + f);
        }
    }
}

