/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.radar.Level2Data;
import ucar.unidata.data.radar.Level2Record;
import ucar.unidata.data.radar.RadarAdapter;
import ucar.unidata.data.radar.VCP;
import ucar.unidata.metdata.NamedStation;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectArray;
import ucar.unidata.util.ObjectPair;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.xml.XmlResourceCollection;
import ucar.visad.RadarMapProjection;
import ucar.visad.quantities.CommonUnits;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DateTime;
import visad.Display;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.QuickSort;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SingletonSet;
import visad.Unit;
import visad.VisADException;
import visad.bom.Radar2DCoordinateSystem;
import visad.bom.Radar3DCoordinateSystem;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;

public class Level2Adapter
implements RadarAdapter {
    private Level2Data data = null;
    private EarthLocation radarLocation = null;
    private DataSourceImpl dataSource;
    private DateTime baseTime = null;
    private double[] tilts;
    private RealTupleType domainType2D;
    private RealTupleType domainType3D;
    private static RealType refType = RealType.getRealType("Reflectivity");
    private static RealType velType = RealType.getRealType("Radial_Velocity", CommonUnit.meterPerSecond);
    private static RealType swType = RealType.getRealType("Spectrum_Width", CommonUnit.meterPerSecond);
    private double R = 6371.01;
    private static NamedStationTable nexradStations;
    private double D = 5.8869E-5;

    public Level2Adapter(DataSourceImpl source, String filename) throws VisADException, RemoteException, IOException {
        this(source, filename, null);
    }

    public Level2Adapter(DataSourceImpl source, String filename, EarthLocation radarLocation) throws VisADException, RemoteException, IOException {
        this.dataSource = source;
        this.radarLocation = radarLocation;
        File file = new File(filename);
        if (!file.exists()) {
            throw new IOException("File " + filename + " does not exist");
        }
        this.loadData(filename);
        this.makeDomainTypes();
    }

    @Override
    public void clearCachedData() {
    }

    @Override
    public DateTime getBaseTime() {
        return this.baseTime;
    }

    public double[] getAngles() {
        return this.tilts;
    }

    public void setRadarLocation(EarthLocation el) throws VisADException, RemoteException {
        this.radarLocation = el;
        this.makeDomainTypes();
    }

    @Override
    public DataImpl getData(DataChoice choice, DataSelection ds, Hashtable requestProperties) throws VisADException, RemoteException {
        ObjectArray choiceAttrs;
        Object choiceId = choice.getId();
        if (choiceId instanceof ObjectArray) {
            choiceAttrs = (ObjectArray)choiceId;
        } else if (choiceId instanceof ObjectPair) {
            ObjectPair pair = (ObjectPair)choiceId;
            choiceAttrs = new ObjectArray(pair.getObject1(), pair.getObject2(), "Level2RadarDataSource.3D");
        } else {
            throw new IllegalStateException("Unknown choice data:" + choiceId.getClass().getName());
        }
        if (requestProperties == null) {
            requestProperties = choice.getProperties() != null ? choice.getProperties() : new Hashtable();
        }
        int moment = (Integer)choiceAttrs.getObject2();
        boolean volume = "Level2RadarDataSource.volume".equals(Misc.getProperty(requestProperties, "Level2RadarDataSource.volumeorsweep", "Level2RadarDataSource.volume"));
        boolean getAll3DData = "Level2RadarDataSource.3D".equals((String)choiceAttrs.getObject3());
        boolean in2D = "Level2RadarDataSource.2D".equals(Misc.getProperty(requestProperties, "Level2RadarDataSource.2Dor3D", "Level2RadarDataSource.2D"));
        FieldImpl fi = null;
        if (volume && getAll3DData) {
            if (requestProperties.containsKey("Level2RadarDataSource.azimuth")) {
                float rhiAzimuth = ((Float)requestProperties.get("Level2RadarDataSource.azimuth")).floatValue();
                fi = this.getRHI(moment, rhiAzimuth);
            } else if (requestProperties.containsKey("Level2RadarDataSource.timeheight") || requestProperties.containsKey("Level2RadarDataSource.verticalcrosssection")) {
                fi = this.getVolume(moment);
                fi = (FlatField)this.resampleToLatLonAltGrid((FlatField)fi, moment);
            } else if (requestProperties.containsKey("Level2RadarDataSource.cappilevel")) {
                Object o;
                Real level = null;
                if (ds != null && (o = ds.getFromLevel()) != null && o instanceof Real) {
                    level = (Real)o;
                }
                if (level == null) {
                    level = (Real)requestProperties.get("Level2RadarDataSource.cappilevel");
                }
                fi = this.getCAPPI(moment, level);
            } else {
                fi = this.getVolume(moment);
            }
        } else if (requestProperties.containsKey("Level2RadarDataSource.VWP")) {
            fi = this.getVWP(15.0);
        } else {
            Object o;
            double value = Double.NaN;
            if (ds != null && (o = ds.getFromLevel()) != null) {
                Object newO = o;
                if (o instanceof TwoFacedObject) {
                    newO = ((TwoFacedObject)o).getId();
                }
                if (newO instanceof Real) {
                    value = ((Real)newO).getValue();
                }
            }
            if (Double.isNaN(value)) {
                Double fromProperties = (Double)requestProperties.get("Level2RadarDataSource.angle");
                if (fromProperties != null) {
                    value = fromProperties;
                } else if (choiceAttrs.getObject1() instanceof Double) {
                    value = (Double)choiceAttrs.getObject1();
                }
            }
            if (Double.isNaN(value)) {
                throw new IllegalArgumentException("No angle specified");
            }
            fi = this.getCut(moment, value, !in2D);
        }
        return fi;
    }

    private void loadData(String radarFile) throws VisADException, RemoteException, IOException {
        this.data = new Level2Data(radarFile, this.dataSource.getDataContext());
        this.data.read(0, true);
        this.tilts = VCP.getAngles(this.data.getVCP());
        this.baseTime = new DateTime((this.data.getJulianDate() - 1) * 24 * 3600 + this.data.getSecsSinceMidnight() / 1000);
        String stationId = this.data.getStationId();
        NamedStation station = null;
        if (this.radarLocation == null && stationId != null) {
            NamedStationTable stations = Level2Adapter.getStations();
            station = (NamedStation)stations.get(stationId.substring(1));
            if (station == null) {
                station = (NamedStation)stations.get(stationId);
            }
            this.radarLocation = station != null ? station.getNamedLocation() : new EarthLocationTuple(0.0, 0.0, 0.0);
        }
    }

    public FlatField getCut(int moment, double elevation) throws VisADException, RemoteException {
        return this.getCut(moment, elevation, false);
    }

    public FlatField getCut(int moment, double elevation, boolean want3D) throws VisADException, RemoteException {
        Unit[] unitArray;
        double range_to_first_gate;
        double range_step;
        FlatField retField;
        Trace.call1(" getCut");
        ObjectPair cacheKey = new ObjectPair(new ObjectPair(new ObjectPair(this.radarLocation, this.baseTime), new ObjectPair(new Integer(moment), new Double(elevation))), new Boolean(want3D));
        FlatField flatField = retField = this.dataSource == null ? null : (FlatField)this.dataSource.getCache(cacheKey);
        if (retField != null) {
            return retField;
        }
        int cut = Arrays.binarySearch(this.tilts, elevation);
        if (cut == -1) {
            return null;
        }
        int local_cut = cut;
        if (moment == 0) {
            if (cut == 1) {
                local_cut = 2;
            } else if (local_cut >= 2) {
                local_cut += 2;
            }
        } else if (local_cut == 0) {
            local_cut = 1;
        } else if (local_cut == 1) {
            local_cut = 3;
        } else if (local_cut >= 2) {
            local_cut += 3;
        }
        Level2Record record = new Level2Record();
        int record_number = this.data.getCutStart(local_cut);
        record.readHeader(this.data.getDataInput(), record_number);
        int bins = record.getBinNum(moment);
        if (bins == 0) {
            return null;
        }
        int num_radials = record.readCut(this.data.getDataInput(), record_number);
        double[] range = new double[bins];
        if (moment == 0) {
            range_step = (double)record.surv_size / 1000.0;
            range_to_first_gate = (double)record.first_bin / 1000.0;
        } else {
            range_step = (double)record.dopl_size / 1000.0;
            range_to_first_gate = (double)record.doppler_range / 1000.0;
        }
        range[0] = range_to_first_gate + range_step / 2.0;
        for (int i = 1; i < bins; ++i) {
            range[i] = range[i - 1] + range_step;
        }
        float[] azimuths = new float[num_radials];
        float[] values = new float[num_radials * bins];
        int vc = 0;
        int azimuth_num = 0;
        int value_counter = 0;
        for (int azi = 0; azi < num_radials; ++azi) {
            float azimuth = this.data.getAzimuth(record_number);
            while ((double)azimuth < 0.0) {
                azimuth = this.data.getAzimuth(++record_number);
            }
            azimuths[azimuth_num++] = azimuth;
            for (int j = 0; j < bins; ++j) {
                vc = value_counter++;
                values[vc] = record.getBinValue(moment, azi, j);
            }
            ++record_number;
        }
        int[] sortToOld = QuickSort.sort(azimuths);
        float[][] domainVals = new float[want3D ? 3 : 2][value_counter + bins];
        float[][] signalVals = new float[1][value_counter + bins];
        int i2 = 0;
        float workingAz = 0.0f;
        for (int j = 0; j < azimuth_num; ++j) {
            for (int i = 0; i < bins; ++i) {
                domainVals[0][i2] = (float)range[i];
                domainVals[1][i2] = azimuths[j];
                if (want3D) {
                    domainVals[2][i2] = (float)elevation;
                }
                signalVals[0][i2] = values[i + sortToOld[j] * bins];
                ++i2;
            }
        }
        for (int i = 0; i < bins; ++i) {
            domainVals[0][i2] = (float)range[i];
            domainVals[1][i2] = domainVals[1][0];
            if (want3D) {
                domainVals[2][i2] = (float)elevation;
            }
            signalVals[0][i2] = values[i + sortToOld[0] * bins];
            ++i2;
        }
        RealTupleType tt = want3D ? this.domainType3D : this.domainType2D;
        GriddedSet set = want3D ? new Gridded3DSet((MathType)tt, domainVals, bins, azimuth_num + 1, null, new Unit[]{CommonUnit.meter.scale(1000.0), CommonUnit.degree, CommonUnit.degree}, (ErrorEstimate[])null, true) : new Gridded2DSet(tt, domainVals, bins, azimuth_num + 1, tt.getCoordinateSystem(), new Unit[]{CommonUnit.meter.scale(1000.0), CommonUnit.degree}, null, true, false);
        FunctionType sweepType = new FunctionType(tt, this.getMomentType(moment));
        CoordinateSystem coordinateSystem = null;
        Set[] setArray = null;
        if (moment != 0) {
            Unit[] unitArray2 = new Unit[1];
            unitArray = unitArray2;
            unitArray2[0] = CommonUnit.meterPerSecond;
        } else {
            unitArray = null;
        }
        retField = new FlatField(sweepType, (Set)set, coordinateSystem, setArray, unitArray);
        retField.setSamples(signalVals, false);
        if (this.dataSource != null) {
            this.dataSource.putCache(cacheKey, retField);
        }
        Trace.call2(" getCut");
        return retField;
    }

    public FlatField getVWP(double altitudeLimit) throws VisADException, RemoteException {
        FlatField retField;
        ObjectPair cacheKey = new ObjectPair(new ObjectPair(this.radarLocation, this.baseTime), new ObjectPair(new String("VAD"), new String("VAD Wind Profile")));
        FlatField flatField = retField = this.dataSource == null ? null : (FlatField)this.dataSource.getCache(cacheKey);
        if (retField != null) {
            return retField;
        }
        int moment = 1;
        int numbTilts = VCP.getNumCuts(this.data.getVCP());
        int bins = 0;
        int dec = 1;
        int record_number = 0;
        double elevation = 19.5;
        Level2Record record = null;
        while (bins == 0) {
            int ii = numbTilts - dec;
            if (ii < 0) {
                return null;
            }
            elevation = this.tilts[ii];
            int cut = Arrays.binarySearch(this.tilts, elevation);
            if (cut == -1) {
                return null;
            }
            int local_cut = cut;
            if (moment == 0) {
                if (cut == 1) {
                    local_cut = 2;
                } else if (local_cut >= 2) {
                    local_cut += 2;
                }
            } else if (local_cut == 0) {
                local_cut = 1;
            } else if (local_cut == 1) {
                local_cut = 3;
            } else if (local_cut >= 2) {
                local_cut += 3;
            }
            record = new Level2Record();
            record_number = this.data.getCutStart(local_cut);
            record.readHeader(this.data.getDataInput(), record_number);
            bins = record.getBinNum(moment);
            ++dec;
        }
        int numbVel = bins / 4;
        int num_radials = record.readCut(this.data.getDataInput(), record_number);
        double[] range = new double[bins];
        double[] altitude = new double[bins];
        double range_step = (double)record.dopl_size / 1000.0;
        double range_to_first_gate = (double)record.doppler_range / 1000.0;
        range[0] = range_to_first_gate + range_step / 2.0;
        boolean gotlimit = false;
        int limitIndex = bins;
        double radians = elevation * Math.PI / 180.0;
        double stationAltitude = this.radarLocation.getAltitude().getValue(CommonUnit.meter) / 1000.0;
        for (int bi = 1; bi < bins; ++bi) {
            range[bi] = range[bi - 1] + range_step;
            double dx = range[bi] * Math.cos(radians);
            double dip = dx * dx / 12742.0;
            altitude[bi] = dx * Math.sin(radians) + stationAltitude + dip;
            if (!(altitude[bi] > altitudeLimit) || gotlimit) continue;
            limitIndex = bi;
            gotlimit = true;
        }
        float[] azimuths = new float[num_radials];
        float[] windspeed = new float[num_radials * bins];
        int azimuth_num = 0;
        int value_counter = 0;
        for (int ac = 0; ac < num_radials; ++ac) {
            float azimuth = this.data.getAzimuth(record_number);
            while ((double)azimuth < 0.0) {
                azimuth = this.data.getAzimuth(++record_number);
            }
            azimuths[azimuth_num++] = azimuth;
            for (int bin = 0; bin < limitIndex; ++bin) {
                windspeed[value_counter++] = record.getBinValue(moment, ac, bin);
            }
            ++record_number;
        }
        int[] shiftedIndices = QuickSort.sort(azimuths);
        float[] wndspd = new float[limitIndex];
        float[] wnddir = new float[limitIndex];
        float[] wndalt = new float[limitIndex];
        int i2sum = 0;
        for (int bi = 0; bi < limitIndex; ++bi) {
            int i2 = 0;
            float sum3Vels = 0.0f;
            float maxVel = 0.0f;
            float minVel = 0.0f;
            float minAZ = 0.0f;
            float maxAZ = 0.0f;
            wndalt[bi] = (float)altitude[bi];
            for (int j = 2; j < azimuth_num - 2; ++j) {
                float v1 = windspeed[bi + shiftedIndices[j - 2] * limitIndex] * 0.25f;
                float v2 = windspeed[bi + shiftedIndices[j - 1] * limitIndex] * 0.625f;
                float v3 = windspeed[bi + shiftedIndices[j] * limitIndex];
                float v4 = windspeed[bi + shiftedIndices[j + 1] * limitIndex] * 0.625f;
                float v5 = windspeed[bi + shiftedIndices[j + 2] * limitIndex] * 0.25f;
                if (Float.isNaN(v1) || Float.isNaN(v2) || Float.isNaN(v3) || Float.isNaN(v4) || Float.isNaN(v5)) continue;
                float avspd = (v1 + v2 + v3 + v4 + v5) / 2.75f;
                if (avspd > maxVel) {
                    maxVel = avspd;
                    maxAZ = azimuths[j];
                }
                if (avspd < minVel) {
                    minVel = avspd;
                    minAZ = azimuths[j];
                }
                ++i2;
            }
            if (i2 <= 225 || !((double)maxVel > 0.0) || !((double)minVel < 0.0)) continue;
            wndspd[bi] = (maxVel - minVel) / 2.0f;
            if ((double)wndspd[bi] < 1.0) {
                wndspd[bi] = 0.0f;
            }
            if ((double)(maxAZ += 180.0f) > 360.0) {
                maxAZ -= 360.0f;
            }
            wnddir[bi] = (maxAZ + minAZ) / 2.0f;
            i2sum += i2;
        }
        if (i2sum < 225) {
            System.out.println("  VAD wind profile is unable to find significant winds at any height with data from this station and time.");
            return null;
        }
        float[][] zsetfloats = new float[1][wndalt.length];
        for (int j = 0; j < wndalt.length; ++j) {
            zsetfloats[0][j] = 1000.0f * (float)altitude[j];
        }
        Data[] ds = new RealTuple[wnddir.length];
        for (int j = 0; j < wnddir.length; ++j) {
            ds[j] = new RealTuple(new Real[]{new Real(Display.Flow1Azimuth, (double)wnddir[j]), new Real(Display.Flow1Radial, (double)wndspd[j])});
        }
        FunctionType onetimeFT = new FunctionType(RealType.Altitude, ds[0].getType());
        Gridded1DSet zset = new Gridded1DSet((MathType)RealType.Altitude, zsetfloats, zsetfloats[0].length);
        FlatField onetimeFF = new FlatField(onetimeFT, zset);
        onetimeFF.setSamples(ds, false);
        return onetimeFF;
    }

    public FieldImpl getRHI(int moment, double rhiAz) throws VisADException, RemoteException {
        Trace.call1("   getRHI");
        FlatField retField = null;
        double range_step = 1.0;
        double range_to_first_gate = 0.0;
        int value_counter = 0;
        double halfBeamWidth = 0.475;
        int numbTilts = VCP.getNumCuts(this.data.getVCP());
        int number_of_bins = 0;
        float[] elevations = new float[numbTilts];
        int[] bincount = new int[numbTilts];
        int[] tiltindices = new int[numbTilts];
        int bincounter = 1000;
        if (moment == 0) {
            bincounter = 500;
        }
        float[][] values = new float[numbTilts][bincounter];
        double[][] ranges = new double[numbTilts][bincounter];
        DateTime beamtime = new DateTime();
        int tiltcounter = 0;
        block0: for (int ti = 0; ti < numbTilts; ++ti) {
            boolean found = false;
            int cut = Arrays.binarySearch(this.tilts, this.tilts[ti]);
            if (cut == -1) continue;
            int local_cut = cut;
            if (moment == 0) {
                if (cut == 1) {
                    local_cut = 2;
                } else if (local_cut >= 2) {
                    local_cut += 2;
                }
            } else if (local_cut == 0) {
                local_cut = 1;
            } else if (local_cut == 1) {
                local_cut = 3;
            } else if (local_cut >= 2) {
                local_cut += 3;
            }
            int record_number = this.data.getCutStart(local_cut);
            int nextcut = this.data.getCutStart(local_cut + 1);
            for (int j = record_number; j < nextcut; ++j) {
                int bi;
                float azi = this.data.getAzimuth(j);
                if (!(Math.abs((double)azi - rhiAz) <= halfBeamWidth)) continue;
                found = true;
                Level2Record record = new Level2Record();
                record.readRecord(this.data.getDataInput(), j);
                range_to_first_gate = (float)((double)record.first_bin / 1000.0);
                range_step = moment == 0 ? 1.0 : 0.25;
                bincount[ti] = number_of_bins = record.getBinNum(moment);
                if (number_of_bins == 0) continue;
                float el = record.getElevation();
                if (el == 0.0f) continue block0;
                elevations[ti] = el;
                for (int z = 0; z < ti && elevations[z] != el; ++z) {
                }
                ranges[ti][0] = range_to_first_gate + range_step / 2.0;
                values[ti][0] = record.getBinValue(moment, 0, 0);
                ++value_counter;
                for (bi = 1; bi < number_of_bins; ++bi) {
                    values[ti][bi] = record.getBinValue(moment, 0, bi);
                    ranges[ti][bi] = ranges[ti][bi - 1] + range_step;
                    ++value_counter;
                }
                if (number_of_bins < bincounter) {
                    for (bi = number_of_bins; bi < bincounter; ++bi) {
                        values[ti][bi] = Float.NaN;
                        ranges[ti][bi] = ranges[ti][bi - 1] + range_step;
                        ++value_counter;
                    }
                }
                tiltindices[tiltcounter] = ti;
                ++tiltcounter;
                continue block0;
            }
        }
        if (value_counter < 1) {
            return null;
        }
        FieldImpl fi = null;
        for (int tc = 0; tc < tiltcounter; ++tc) {
            Unit[] unitArray;
            float[][] domainVals = new float[3][bincounter * 2];
            float[][] signalVals = new float[1][bincounter * 2];
            int ti = tiltindices[tc];
            float lowerElev = elevations[ti] - (float)halfBeamWidth;
            for (int bi = 0; bi < bincounter; ++bi) {
                domainVals[0][bi] = (float)ranges[ti][bi];
                domainVals[1][bi] = (float)rhiAz;
                domainVals[2][bi] = lowerElev;
                signalVals[0][bi] = values[ti][bi];
            }
            float upperElev = elevations[ti] + (float)halfBeamWidth;
            for (int bi = 0; bi < bincounter; ++bi) {
                domainVals[0][bi + bincounter] = (float)ranges[ti][bi];
                domainVals[1][bi + bincounter] = (float)rhiAz;
                domainVals[2][bi + bincounter] = upperElev;
                signalVals[0][bi + bincounter] = values[ti][bi];
            }
            RealTupleType radarDomainType = this.domainType3D;
            Gridded3DSet domainSet = new Gridded3DSet((MathType)radarDomainType, domainVals, bincounter, 2, radarDomainType.getCoordinateSystem(), new Unit[]{CommonUnit.meter.scale(1000.0), CommonUnit.degree, CommonUnit.degree}, (ErrorEstimate[])null, true);
            FunctionType functionType = new FunctionType(radarDomainType, this.getMomentType(moment));
            CoordinateSystem coordinateSystem = null;
            Set[] setArray = null;
            if (moment != 0) {
                Unit[] unitArray2 = new Unit[1];
                unitArray = unitArray2;
                unitArray2[0] = CommonUnit.meterPerSecond;
            } else {
                unitArray = null;
            }
            retField = new FlatField(functionType, (Set)domainSet, coordinateSystem, setArray, unitArray);
            retField.setSamples(signalVals, true);
            if (tc == 0) {
                RealType indexType = RealType.getRealType("integer_index");
                FunctionType fiFunction = new FunctionType(indexType, retField.getType());
                Integer1DSet intSet = new Integer1DSet(tiltcounter);
                fi = new FieldImpl(fiFunction, intSet);
                fi.setSample(0, (Data)retField, false);
                continue;
            }
            fi.setSample(tc, (Data)retField, false);
        }
        return fi;
    }

    public FieldImpl getCAPPI(int moment, Real level) throws VisADException, RemoteException {
        Unit[] unitArray;
        int local_cut;
        int cut;
        int ti;
        int record_number;
        FieldImpl retField;
        ObjectPair cacheKey = new ObjectPair(new ObjectPair(new ObjectPair(this.radarLocation, this.baseTime), new ObjectPair(new Integer(moment), level)), new String("CAPPI"));
        FieldImpl fieldImpl = retField = this.dataSource == null ? null : (FieldImpl)this.dataSource.getCache(cacheKey);
        if (retField != null) {
            return retField;
        }
        double range_step = 1.0;
        double range_to_first_gate = 0.0;
        int dataVCP = this.data.getVCP();
        int numbTilts = VCP.getNumCuts(dataVCP);
        boolean totalbins = false;
        int binCount = 1000;
        double levelInMeters = level.getValue(CommonUnit.meter);
        if (moment == 0) {
            binCount = 500;
            record_number = this.data.getCutStart(0);
        } else {
            record_number = this.data.getCutStart(1);
        }
        Level2Record record = new Level2Record();
        record.readHeader(this.data.getDataInput(), record_number);
        int low_bins = record.getBinNum(moment);
        range_to_first_gate = (float)((double)record.first_bin / 1000.0);
        binCount = low_bins;
        range_step = moment == 0 ? 1.0 : 0.25;
        double[] ranges = new double[binCount];
        ranges[0] = range_to_first_gate + range_step / 2.0;
        for (int i = 1; i < binCount; ++i) {
            ranges[i] = ranges[i - 1] + range_step;
        }
        int numAz = 370;
        double[] cappiRadius = new double[binCount];
        float[][] cappiAz = new float[binCount][numAz];
        float[][] cappiValue = new float[binCount][numAz];
        boolean bins = false;
        int numberOfBins = 0;
        int ringcounter = 0;
        int[][] shiftedIndex = new int[binCount][numAz];
        double stationAltitude = this.radarLocation.getAltitude().getValue(CommonUnit.meter) / 1000.0;
        int[] bin_LUT = new int[20];
        bin_LUT[0] = 0;
        for (ti = 1; ti < numbTilts; ++ti) {
            cut = Arrays.binarySearch(this.tilts, this.tilts[ti]);
            if (cut == -1) continue;
            local_cut = cut;
            local_cut = moment == 0 ? (cut == 0 ? 0 : (cut == 1 ? 2 : cut + 2)) : (cut == 0 ? 1 : (cut == 1 ? 3 : cut + 2));
            record_number = this.data.getCutStart(local_cut);
            record.readHeader(this.data.getDataInput(), record_number);
            numberOfBins = record.getBinNum(moment);
            float vcpelev = (VCP.getCutAngle(dataVCP, VCP.getNumCuts(dataVCP) - ti) + VCP.getCutAngle(dataVCP, VCP.getNumCuts(dataVCP) - ti - 1)) / 2.0f;
            int vcpbin = this.calcRangeBin(vcpelev, levelInMeters, range_step);
            bin_LUT[ti] = vcpbin > low_bins ? low_bins : vcpbin;
        }
        bin_LUT[numbTilts] = this.calcRangeBin(0.0, levelInMeters, range_step);
        if (bin_LUT[numbTilts] > low_bins) {
            bin_LUT[numbTilts] = low_bins;
        }
        for (ti = 0; ti < numbTilts; ++ti) {
            cut = Arrays.binarySearch(this.tilts, this.tilts[ti]);
            if (cut == -1) continue;
            local_cut = cut;
            local_cut = moment == 0 ? (cut == 0 ? 0 : (cut == 1 ? 2 : (local_cut += 2))) : (cut == 0 ? 1 : (cut == 1 ? 3 : (local_cut += 2)));
            record_number = this.data.getCutStart(local_cut);
            record.readHeader(this.data.getDataInput(), record_number);
            numberOfBins = record.getBinNum(moment);
            if (numberOfBins == 0) continue;
            int bininner = bin_LUT[numbTilts - ti - 1];
            int binouter = bin_LUT[numbTilts - ti];
            int num_radials = record.readCut(this.data.getDataInput(), record_number);
            int bc = 0;
            for (int ac = 0; ac < numAz; ++ac) {
                float azimuth = this.data.getAzimuth(record_number);
                while ((double)azimuth < 0.0) {
                    azimuth = this.data.getAzimuth(++record_number);
                }
                bc = 0;
                for (int binIndex = binouter - 1; binIndex >= bininner; --binIndex) {
                    int rc = ringcounter + bc;
                    if (ac == 0) {
                        cappiRadius[rc] = ranges[binIndex];
                    }
                    if (ac < num_radials) {
                        cappiAz[rc][ac] = azimuth;
                        cappiValue[rc][ac] = record.getBinValue(moment, ac, binIndex);
                    } else {
                        cappiAz[rc][ac] = 360.0f;
                        cappiValue[rc][ac] = Float.NaN;
                    }
                    ++bc;
                }
                ++record_number;
            }
            for (int bd = 0; bd < bc; ++bd) {
                shiftedIndex[ringcounter + bd] = QuickSort.sort(cappiAz[ringcounter + bd]);
            }
            ringcounter += bc;
        }
        float[][] domainVals = new float[2][ringcounter * numAz];
        float[][] signalVals = new float[1][ringcounter * numAz];
        int k = 0;
        for (int azi = 0; azi < numAz; ++azi) {
            for (int ri = ringcounter - 1; ri >= 0; --ri) {
                domainVals[0][k] = (float)cappiRadius[ri];
                domainVals[1][k] = cappiAz[ri][azi];
                signalVals[0][k] = cappiValue[ri][shiftedIndex[ri][azi]];
                ++k;
            }
        }
        RealTupleType tt = this.domainType2D;
        Gridded2DSet set = new Gridded2DSet(tt, domainVals, ringcounter, numAz, tt.getCoordinateSystem(), new Unit[]{CommonUnit.meter.scale(1000.0), CommonUnit.degree}, null, true, false);
        FunctionType sweepType = new FunctionType(tt, this.getMomentType(moment));
        CoordinateSystem coordinateSystem = null;
        Set[] setArray = null;
        if (moment != 0) {
            Unit[] unitArray2 = new Unit[1];
            unitArray = unitArray2;
            unitArray2[0] = CommonUnit.meterPerSecond;
        } else {
            unitArray = null;
        }
        FlatField ff = new FlatField(sweepType, (Set)set, coordinateSystem, setArray, unitArray);
        ff.setSamples(signalVals, false);
        FunctionType fiFunction = new FunctionType(RealType.Altitude, ff.getType());
        RealTuple altRT = new RealTuple(new Real[]{level});
        SingletonSet altSet = new SingletonSet(altRT);
        retField = new FieldImpl(fiFunction, altSet);
        retField.setSample(0, (Data)ff, false);
        if (this.dataSource != null) {
            this.dataSource.putCache(cacheKey, retField);
        }
        return retField;
    }

    private int calcRangeBin(double elevation, double level, double rangeStep) {
        double a = Math.cos(elevation * Math.PI / 180.0);
        a = this.D * a * a;
        double b = Math.sin(elevation * Math.PI / 180.0);
        double c = b * b + 4.0 * a * (level / 1000.0);
        return (int)((-b + Math.sqrt(c)) / (2.0 * a) / rangeStep);
    }

    private RealType getMomentType(int moment) {
        return moment == 0 ? refType : (moment == 1 ? velType : swType);
    }

    private void makeDomainTypes() throws VisADException {
        this.domainType2D = this.makeDomainType2D();
        this.domainType3D = this.makeDomainType3D();
    }

    private RealTupleType makeDomainType2D() throws VisADException {
        Radar2DCoordinateSystem cs = this.radarLocation == null ? null : new Radar2DCoordinateSystem((float)this.radarLocation.getLatitude().getValue(CommonUnit.degree), (float)this.radarLocation.getLongitude().getValue(CommonUnit.degree));
        return new RealTupleType(RANGE_TYPE, AZIMUTH_TYPE, cs, null);
    }

    private RealTupleType makeDomainType3D() throws VisADException {
        Radar3DCoordinateSystem cs = this.radarLocation == null ? null : new Radar3DCoordinateSystem((float)this.radarLocation.getLatitude().getValue(CommonUnit.degree), (float)this.radarLocation.getLongitude().getValue(CommonUnit.degree), (float)this.radarLocation.getAltitude().getValue(CommonUnit.meter));
        return new RealTupleType(RANGE_TYPE, AZIMUTH_TYPE, ELEVATION_ANGLE_TYPE, cs, null);
    }

    public String toString() {
        return "Adapter for " + this.radarLocation + " at " + this.baseTime;
    }

    @Override
    public String getName() {
        if (this.data != null) {
            return this.data.getFilename();
        }
        return "";
    }

    public FlatField getVolume(int moment) throws VisADException, RemoteException {
        Unit[] unitArray;
        FlatField retField;
        ObjectPair cacheKey = new ObjectPair(new ObjectPair(this.radarLocation, this.baseTime), new ObjectPair(new Integer(moment), new String("range-az vol")));
        FlatField flatField = retField = this.dataSource == null ? null : (FlatField)this.dataSource.getCache(cacheKey);
        if (retField != null) {
            return retField;
        }
        int numberOfSweeps = this.tilts.length;
        float[][] azimuths = new float[numberOfSweeps][370];
        float[][] elevations = new float[numberOfSweeps][370];
        int bincounter = 1000;
        if (moment == 0) {
            bincounter = 500;
        }
        float[][][] values = new float[numberOfSweeps][370][bincounter];
        for (int a = 0; a < numberOfSweeps; ++a) {
            for (int b = 0; b < 370; ++b) {
                for (int c = 0; c < bincounter; ++c) {
                    values[a][b][c] = Float.NaN;
                }
            }
        }
        double[][] ranges = new double[numberOfSweeps][bincounter];
        int value_counter = 0;
        Level2Record record = new Level2Record();
        int tiltcounter = 0;
        for (int ti = 0; ti < numberOfSweeps; ++ti) {
            double range_to_first_gate;
            double range_step;
            double tilt = this.tilts[ti];
            int cut = Arrays.binarySearch(this.tilts, tilt);
            if (cut == -1) continue;
            int local_cut = cut;
            if (moment == 0) {
                if (cut == 1) {
                    local_cut = 2;
                } else if (local_cut >= 2) {
                    local_cut += 2;
                }
            } else if (local_cut == 0) {
                local_cut = 1;
            } else if (local_cut == 1) {
                local_cut = 3;
            } else if (local_cut >= 2) {
                local_cut += 3;
            }
            int record_number = this.data.getCutStart(local_cut);
            record.readHeader(this.data.getDataInput(), record_number);
            int numberOfBins = record.getBinNum(moment);
            if (numberOfBins <= 0) continue;
            if (moment == 0) {
                range_step = (double)record.surv_size / 1000.0;
                range_to_first_gate = (double)record.first_bin / 1000.0;
            } else {
                range_step = (double)record.dopl_size / 1000.0;
                range_to_first_gate = (double)record.doppler_range / 1000.0;
            }
            ranges[ti][0] = range_to_first_gate + range_step / 2.0;
            for (int i = 1; i < bincounter; ++i) {
                ranges[ti][i] = ranges[ti][i - 1] + range_step;
            }
            int num_radials = record.readCut(this.data.getDataInput(), record_number);
            int nbi = 370;
            if (num_radials < 370) {
                nbi = num_radials;
            }
            for (int bi = 0; bi < nbi; ++bi) {
                float azimuth = this.data.getAzimuth(record_number);
                while ((double)azimuth < 0.0) {
                    azimuth = this.data.getAzimuth(++record_number);
                }
                int si = (int)((double)azimuth + 0.5);
                azimuths[ti][si] = azimuth;
                elevations[ti][si] = record.getElevation();
                for (int binj = 0; binj < numberOfBins; ++binj) {
                    values[ti][si][binj] = record.getBinValue(moment, bi, binj);
                    ++value_counter;
                }
                ++record_number;
            }
            ++tiltcounter;
        }
        float[][] domainVals = new float[3][bincounter * 370 * tiltcounter];
        float[][] signalVals = new float[1][bincounter * 370 * tiltcounter];
        int k = 0;
        for (int ti = 0; ti < tiltcounter; ++ti) {
            for (int bi = 0; bi < 370; ++bi) {
                for (int ri = 0; ri < bincounter; ++ri) {
                    domainVals[0][k] = (float)ranges[ti][ri];
                    domainVals[1][k] = azimuths[ti][bi];
                    domainVals[2][k] = elevations[ti][bi];
                    signalVals[0][k] = values[ti][bi][ri];
                    ++k;
                }
            }
        }
        RealTupleType tt = this.domainType3D;
        Gridded3DSet set = new Gridded3DSet(tt, domainVals, bincounter, 370, tiltcounter, null, new Unit[]{CommonUnit.meter.scale(1000.0), CommonUnit.degree, CommonUnit.degree}, null, true, false);
        FunctionType sweepType = new FunctionType(tt, this.getMomentType(moment));
        CoordinateSystem coordinateSystem = null;
        Set[] setArray = null;
        if (moment != 0) {
            Unit[] unitArray2 = new Unit[1];
            unitArray = unitArray2;
            unitArray2[0] = CommonUnit.meterPerSecond;
        } else {
            unitArray = null;
        }
        retField = new FlatField(sweepType, (Set)set, coordinateSystem, setArray, unitArray);
        retField.setSamples(signalVals, false);
        if (this.dataSource != null) {
            this.dataSource.putCache(cacheKey, retField);
        }
        return retField;
    }

    private Field resampleToLatLonAltGrid(FlatField retField, int moment) throws VisADException, RemoteException {
        Field cacheField;
        ObjectPair cacheKey = new ObjectPair(new ObjectPair(this.radarLocation, this.baseTime), new ObjectPair(new Integer(moment), new String("latlonalt grid")));
        Field field = cacheField = this.dataSource == null ? null : (Field)this.dataSource.getCache(cacheKey);
        if (cacheField != null) {
            return cacheField;
        }
        int xyDim = 100;
        int zDim = 21;
        RadarMapProjection radarCS = new RadarMapProjection(this.radarLocation.getLatLonPoint(), xyDim, xyDim);
        Linear2DSet l2dset = new Linear2DSet(-180.0, 280.0, xyDim, -180.0, 280.0, xyDim);
        float[][] gridlocs = l2dset.getSamples();
        float[][] latLonLocs = radarCS.toReference(gridlocs, new Unit[]{CommonUnits.KILOMETER, CommonUnits.KILOMETER});
        float[][] domainVals = new float[3][xyDim * xyDim * zDim];
        int kk = 0;
        for (int zi = 0; zi < zDim; ++zi) {
            int jj = 0;
            for (int yi = 0; yi < xyDim; ++yi) {
                for (int xi = 0; xi < xyDim; ++xi) {
                    domainVals[0][kk] = latLonLocs[0][jj];
                    domainVals[1][kk] = latLonLocs[1][jj];
                    domainVals[2][kk] = 1000.0f * (float)zi;
                    ++jj;
                    ++kk;
                }
            }
        }
        RealTupleType tt = new RealTupleType(RealType.Latitude, RealType.Longitude, RealType.Altitude);
        Gridded3DSet g3Dset = new Gridded3DSet((MathType)tt, domainVals, xyDim, xyDim, zDim);
        Field rsfield = retField.resample(g3Dset, 100, 202);
        if (this.dataSource != null) {
            this.dataSource.putCache(cacheKey, rsfield);
        }
        return (FlatField)rsfield;
    }

    public static NamedStationTable getStations() {
        if (nexradStations == null) {
            List resources = Misc.newList("/ucar/unidata/idv/resources/nexradstns.xml");
            XmlResourceCollection stationResources = new XmlResourceCollection("", resources);
            List listOfTables = NamedStationTable.createStationTables(stationResources);
            nexradStations = listOfTables.size() > 0 ? (NamedStationTable)listOfTables.get(0) : new NamedStationTable();
        }
        return nexradStations;
    }

    public static String getMomentName(int moment) {
        switch (moment) {
            case 0: {
                return "Reflectivity";
            }
            case 1: {
                return "Radial Velocity";
            }
            case 2: {
                return "Spectrum Width";
            }
        }
        return "Unknown moment";
    }

    @Override
    public void doRemove() {
        nexradStations = null;
        this.clearCachedData();
    }
}

