/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.query.Choice;
import thredds.catalog.query.DqcFactory;
import thredds.catalog.query.QueryCapability;
import thredds.catalog.query.SelectGeoRegion;
import thredds.catalog.query.SelectList;
import thredds.catalog.query.SelectService;
import thredds.catalog.query.SelectStation;
import thredds.catalog.query.Selector;
import thredds.catalog.query.Station;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.units.DateType;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.data.radar.StationRadarCollectionImpl;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.DatedThing;
import ucar.unidata.util.Product;

public class DqcRadarDatasetCollection
extends StationRadarCollectionImpl {
    private QueryCapability dqc;
    private SelectService selService;
    private SelectStation selStation;
    private SelectList selTime;
    private SelectGeoRegion selRegion;
    private SelectService.ServiceChoice service;
    private HashMap dqcStations;
    private boolean debugQuery = false;

    public static DqcRadarDatasetCollection factory(InvDataset ds, String dqc_location, StringBuffer errlog) throws IOException {
        return DqcRadarDatasetCollection.factory(ds.getDocumentation("summary"), dqc_location, errlog);
    }

    public static DqcRadarDatasetCollection factory(String desc, String dqc_location, StringBuffer errlog) throws IOException {
        DqcFactory dqcFactory = new DqcFactory(true);
        QueryCapability dqc = dqcFactory.readXML(dqc_location + "?returns=dqc");
        if (dqc.hasFatalError()) {
            errlog.append(dqc.getErrorMessages());
            return null;
        }
        SelectStation selStation = null;
        SelectList selTime = null;
        SelectService selService = null;
        ArrayList selectors = dqc.getSelectors();
        for (int i = 0; i < selectors.size(); ++i) {
            Selector s = (Selector)selectors.get(i);
            if (s instanceof SelectStation) {
                selStation = (SelectStation)s;
            }
            if (s instanceof SelectList) {
                selTime = (SelectList)s;
            }
            if (!(s instanceof SelectService)) continue;
            selService = (SelectService)s;
        }
        if (selService == null) {
            errlog.append("DqcStationaryRadarDataset must have Service selector");
            return null;
        }
        if (selStation == null) {
            errlog.append("DqcStationaryRadarDataset must have Station selector");
            return null;
        }
        if (selTime == null) {
            errlog.append("DqcStationaryRadarDataset must have Date selector");
            return null;
        }
        SelectService.ServiceChoice wantServiceChoice = null;
        ArrayList services = selService.getChoices();
        for (int i = 0; i < services.size(); ++i) {
            SelectService.ServiceChoice serviceChoice = (SelectService.ServiceChoice)services.get(i);
            if (!serviceChoice.getService().equals("HTTPServer") || !serviceChoice.getDataFormat().equals("text/xml")) continue;
            wantServiceChoice = serviceChoice;
        }
        if (wantServiceChoice == null) {
            errlog.append("DqcStationObsDataset must have HTTPServer Service with DataFormat=text/plain, and returns=data");
            return null;
        }
        return new DqcRadarDatasetCollection(desc, dqc, selService, wantServiceChoice, selStation, null, selTime);
    }

    private DqcRadarDatasetCollection(String desc, QueryCapability dqc, SelectService selService, SelectService.ServiceChoice service, SelectStation selStation, SelectGeoRegion selRegion, SelectList selTime) {
        this.desc = desc;
        this.dqc = dqc;
        this.selService = selService;
        this.selStation = selStation;
        this.selRegion = selRegion;
        this.selTime = selTime;
        this.service = service;
        ArrayList stationList = selStation.getStations();
        this.stations = new HashMap(stationList.size());
        for (int i = 0; i < stationList.size(); ++i) {
            Station station = (Station)stationList.get(i);
            this.stations.put(station.getValue(), station);
        }
        ArrayList timeList = selTime.getChoices();
        this.relTimesList = new HashMap(timeList.size());
        for (int i = 0; i < timeList.size(); ++i) {
            Choice tt = (Choice)timeList.get(i);
            this.relTimesList.put(tt.getValue(), tt);
        }
        String ql = dqc.getQuery().getUriResolved().toString();
        this.startDate = new Date();
        this.endDate = new Date();
        try {
            this.timeUnit = new DateUnit("hours since 1991-01-01T00:00");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setTimeUnits() {
    }

    @Override
    protected void setStartDate() {
    }

    @Override
    protected void setEndDate() {
    }

    @Override
    protected void setBoundingBox() {
    }

    @Override
    public String getTitle() {
        return this.dqc.getName();
    }

    @Override
    public String getLocation() {
        return this.dqc.getCreateFrom();
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public boolean checkStationProduct(String sName, Product product) {
        return this.dqc.getName().contains("Level2") && (product.getID().equals("Reflectivity") || product.getID().equals("RadialVelocity") || product.getID().equals("SpectrumWidth"));
    }

    @Override
    public boolean checkStationProduct(Product product) {
        return this.checkStationProduct(null, product);
    }

    @Override
    public int getStationProductCount(String sName) {
        if (this.dqc.getName().contains("Level2")) {
            return 3;
        }
        return 0;
    }

    @Override
    public List getStations() throws IOException {
        return this.getRadarStations();
    }

    public List getRadarStations() {
        ArrayList sl = this.selStation.getStations();
        ArrayList<Station> dsl = new ArrayList<Station>();
        for (Station s : sl) {
            dsl.add(s);
        }
        return dsl;
    }

    @Override
    public List getStations(CancelTask cancel) throws IOException {
        return this.getStations(null, cancel);
    }

    @Override
    public List getStations(LatLonRect boundingBox) throws IOException {
        return this.getStations(boundingBox, null);
    }

    @Override
    public List getStations(LatLonRect boundingBox, CancelTask cancel) throws IOException {
        ArrayList sl = this.selStation.getStations();
        ArrayList<Station> dsl = new ArrayList<Station>();
        for (Station s : sl) {
            LatLonPointImpl latlonPt = new LatLonPointImpl();
            latlonPt.set(s.getLocation().getLatitude(), s.getLocation().getLongitude());
            if (boundingBox.contains(latlonPt)) {
                dsl.add(s);
            }
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return dsl;
    }

    public RadialDatasetSweep getRadarDataset(String stnName, Date absTime) throws IOException {
        InvDataset invdata = this.queryRadarStation(stnName, absTime);
        if (invdata == null) {
            throw new IOException("Invalid time selected: " + absTime.toString() + "\n");
        }
        ThreddsDataFactory tdFactory = new ThreddsDataFactory();
        ThreddsDataFactory.Result result = tdFactory.openFeatureDataset(invdata, null);
        return (RadialDatasetSweep)result.featureDataset;
    }

    public URI getRadarDatasetURI(String stnName, Date absTime) throws IOException {
        InvDataset invdata = this.queryRadarStation(stnName, absTime);
        List<InvAccess> acess = invdata.getAccess();
        InvAccess ia = acess.get(0);
        URI ui = ia.getStandardUri();
        if (ui == null) {
            throw new IOException("Invalid time selected: " + absTime.toString() + "\n");
        }
        return ui;
    }

    private InvDataset queryRadarStation(String stnName, Date absTime) throws IOException {
        URI catalogURI;
        String stime = DateUtil.getTimeAsISO8601(absTime);
        StringBuffer queryb = new StringBuffer();
        queryb.append(this.dqc.getQuery().getUriResolved().toString());
        queryb.append("serviceType=OPENDAP");
        queryb.append("&stn=" + stnName);
        queryb.append("&dtime=" + stime);
        try {
            catalogURI = new URI(queryb.toString());
        }
        catch (URISyntaxException e) {
            throw new IOException("** MalformedURLException on URL <>\n" + e.getMessage() + "\n");
        }
        InvCatalogFactory factory = new InvCatalogFactory("default", false);
        InvCatalogImpl catalog = factory.readXML(catalogURI);
        StringBuilder buff = new StringBuilder();
        if (!catalog.check(buff)) {
            throw new IOException("Invalid catalog <" + catalogURI + ">\n" + buff.toString());
        }
        List<InvDataset> datasets = catalog.getDatasets();
        InvDataset idata = datasets.get(0);
        ArrayList dsets = (ArrayList)idata.getDatasets();
        InvDataset tdata = (InvDataset)dsets.get(0);
        return tdata;
    }

    private DqcRadarDatasetInfo queryRadarStation(String stnName, Date start, Date end) throws IOException {
        URI catalogURI;
        StringBuffer queryb = new StringBuffer();
        queryb.append(this.dqc.getQuery().getUriResolved().toString());
        queryb.append("serviceType=OPENDAP");
        queryb.append("&stn=" + stnName);
        if (start == null && end == null) {
            queryb.append("&dtime=all");
        } else {
            String stime = DateUtil.getTimeAsISO8601(start);
            String etime = DateUtil.getTimeAsISO8601(end);
            queryb.append("&dateStart=" + stime);
            queryb.append("&dateEnd=" + etime);
        }
        try {
            catalogURI = new URI(queryb.toString());
        }
        catch (URISyntaxException e) {
            throw new IOException("** MalformedURLException on URL <>\n" + e.getMessage() + "\n");
        }
        InvCatalogFactory factory = new InvCatalogFactory("default", false);
        InvCatalogImpl catalog = factory.readXML(catalogURI);
        StringBuilder buff = new StringBuilder();
        if (!catalog.check(buff)) {
            throw new IOException("Invalid catalog <" + catalogURI + ">\n" + buff.toString());
        }
        List<InvDataset> datasets = catalog.getDatasets();
        InvDataset idata = datasets.get(0);
        ArrayList dsets = (ArrayList)idata.getDatasets();
        ArrayList<Date> absTimeList = new ArrayList<Date>();
        ArrayList<DatasetURIInfo> dURIList = new ArrayList<DatasetURIInfo>();
        ArrayList<InvDatasetInfo> dInvList = new ArrayList<InvDatasetInfo>();
        for (int i = 0; i < dsets.size(); ++i) {
            InvDataset tdata = (InvDataset)dsets.get(i);
            List<InvAccess> acess = tdata.getAccess();
            List<DateType> dates = tdata.getDates();
            InvAccess ia = acess.get(0);
            URI d = ia.getStandardUri();
            Date date = DateUnit.getStandardOrISO(((Object)dates.get(0)).toString());
            absTimeList.add(date);
            dURIList.add(new DatasetURIInfo(d, date));
            dInvList.add(new InvDatasetInfo(tdata, date));
        }
        DqcRadarDatasetInfo dri = new DqcRadarDatasetInfo(absTimeList, dURIList, dInvList);
        return dri;
    }

    public ArrayList getRadarStationURIs(String stnName, Date start, Date end) throws IOException {
        DqcRadarDatasetInfo dri = this.queryRadarStation(stnName, start, end);
        ArrayList uList = dri.getURIList();
        int size = uList.size();
        ArrayList<URI> datasetsURI = new ArrayList<URI>();
        for (int i = 0; i < size; ++i) {
            DatasetURIInfo du = (DatasetURIInfo)uList.get(i);
            datasetsURI.add(du.uri);
        }
        return datasetsURI;
    }

    public ArrayList getRadarStationDatasets(String stnName, Date start, Date end) throws IOException {
        ArrayList<FeatureDataset> datasetList = new ArrayList<FeatureDataset>();
        DqcRadarDatasetInfo dri = this.queryRadarStation(stnName, start, end);
        ArrayList iList = dri.getInvList();
        int size = iList.size();
        for (int i = 0; i < size; ++i) {
            InvDatasetInfo iv = (InvDatasetInfo)iList.get(i);
            InvDataset tdata = iv.inv;
            ThreddsDataFactory tdFactory = new ThreddsDataFactory();
            ThreddsDataFactory.Result result = tdFactory.openFeatureDataset(tdata, null);
            datasetList.add(result.featureDataset);
        }
        return datasetList;
    }

    public ArrayList getRadarStationTimes(String stnName, Date start, Date end) throws IOException {
        DqcRadarDatasetInfo dri = this.queryRadarStation(stnName, start, end);
        return dri.absTimeList;
    }

    public DataIterator getDataIterator(int bufferSize) throws IOException {
        return null;
    }

    private List queryRadarStationRTimes(String stn) throws IOException {
        return this.selTime.getChoices();
    }

    public ArrayList getDataURIs(String sName, DateSelection dateInfo) throws IOException {
        return this.getDataURIs(sName, dateInfo, null);
    }

    public ArrayList getData(String sName, DateSelection dateInfo) throws IOException {
        return this.getData(sName, dateInfo, null);
    }

    public ArrayList getData(String sName, DateSelection dateSelect, CancelTask cancel) throws IOException {
        if (cancel != null && cancel.isCancel()) {
            return null;
        }
        DqcRadarDatasetInfo dri = this.queryRadarStation(sName, dateSelect.getStartFixedDate(), dateSelect.getEndFixedDate());
        ArrayList<FeatureDataset> datasetList = new ArrayList<FeatureDataset>();
        List datasetINVs = dateSelect.apply(dri.getInvList());
        for (InvDatasetInfo ifo : datasetINVs) {
            InvDataset tdata = ifo.inv;
            ThreddsDataFactory tdFactory = new ThreddsDataFactory();
            ThreddsDataFactory.Result result = tdFactory.openFeatureDataset(tdata, null);
            datasetList.add(result.featureDataset);
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return datasetList;
    }

    public ArrayList getDataURIs(String sName, DateSelection dateSelect, CancelTask cancel) throws IOException {
        if (cancel != null && cancel.isCancel()) {
            return null;
        }
        DqcRadarDatasetInfo dri = this.queryRadarStation(sName, dateSelect.getStartFixedDate(), dateSelect.getEndFixedDate());
        List datasetsURIs = dateSelect.apply(dri.getURIList());
        ArrayList<URI> uriList = new ArrayList<URI>();
        for (DatasetURIInfo ufo : datasetsURIs) {
            URI u = ufo.uri;
            uriList.add(u);
            if (cancel == null || !cancel.isCancel()) continue;
            return null;
        }
        return uriList;
    }

    public static long roundTo(long roundTo, long seconds) {
        int roundToSeconds = (int)roundTo;
        if (roundToSeconds == 0) {
            return seconds;
        }
        return seconds - (long)((int)seconds % roundToSeconds);
    }

    public static void main(String[] args) throws IOException {
        StringBuffer errlog = new StringBuffer();
        String dqc_location = "http://thredds.ucar.edu/thredds/idd/radarLevel2";
        DqcRadarDatasetCollection ds = DqcRadarDatasetCollection.factory("test", dqc_location, errlog);
        System.out.println(" errs= " + errlog);
        List stns = ds.getStations();
        System.out.println(" nstns= " + stns.size());
        Station stn = (Station)stns.get(2);
        Date ts1 = DateUnit.getStandardOrISO("2007-06-9T12:12:00");
        Date ts2 = DateUnit.getStandardOrISO("2007-06-9T23:12:00");
        ArrayList tlist = ds.getRadarStationTimes(stn.getValue(), ts1, ts2);
        int sz = tlist.size();
        Date ts0 = DateUnit.getStandardOrISO((String)tlist.get(1));
        RadialDatasetSweep rds = ds.getRadarDataset(stn.getValue(), ts0);
        URI stURL = ds.getRadarDatasetURI(stn.getValue(), ts0);
        assert (null != stURL);
        assert (0 != sz);
        DateSelection dateS = new DateSelection(ts1, ts2);
        dateS.setInterval(3600000.0);
        dateS.setRoundTo(3600000.0);
        dateS.setPreRange(500000.0);
        dateS.setPostRange(500000.0);
        for (int i = 0; i < stns.size(); ++i) {
            stn = (Station)stns.get(i);
            ArrayList times = ds.getRadarStationTimes(stn.getValue(), new Date(System.currentTimeMillis() - 50065408L), new Date(System.currentTimeMillis()));
            if (times.size() > 0) {
                System.err.println(stn + " times:" + times.size() + " " + times.get(0) + " - " + times.get(times.size() - 1));
                continue;
            }
            System.err.println(stn + " no times");
        }
        System.exit(0);
        ArrayList jList = ds.getDataURIs("KABX", dateS);
        assert (null != jList);
        ArrayList mList = ds.getData("KABX", dateS, null);
        assert (null != mList);
        Date ts = DateUnit.getStandardOrISO((String)tlist.get(1));
        SimpleDateFormat isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        isoDateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String st = isoDateTimeFormat.format(ts);
    }

    public class DqcRadarDatasetInfo {
        private ArrayList absTimeList;
        private ArrayList datasetInfoList;
        private ArrayList invDatasetList;

        public DqcRadarDatasetInfo() {
        }

        public DqcRadarDatasetInfo(ArrayList absTimeList, ArrayList datasetInfoList, ArrayList invDatasetList) {
            this.absTimeList = absTimeList;
            this.datasetInfoList = datasetInfoList;
            this.invDatasetList = invDatasetList;
        }

        public ArrayList getTimeList() {
            return this.absTimeList;
        }

        public ArrayList getURIList() {
            return this.datasetInfoList;
        }

        public ArrayList getInvList() {
            return this.invDatasetList;
        }
    }

    public class InvDatasetInfo
    implements DatedThing {
        private InvDataset inv = null;
        private Date date = null;

        public InvDatasetInfo(InvDataset u, Date date) {
            this.inv = u;
            this.date = date;
        }

        @Override
        public Date getDate() {
            return this.date;
        }
    }

    public class DatasetURIInfo
    implements DatedThing {
        private URI uri = null;
        private Date date = null;

        public DatasetURIInfo(URI u, Date date) {
            this.uri = u;
            this.date = date;
        }

        @Override
        public Date getDate() {
            return this.date;
        }
    }
}

