/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.radar.DoradeAdapter;
import ucar.unidata.data.radar.RadarAdapter;
import ucar.unidata.data.radar.RadarDataSource;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlEncoder;
import visad.RealType;
import visad.VisADException;

public class DoradeDataSource
extends RadarDataSource {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(DoradeDataSource.class.getName());
    private static final String DATA_DESCRIPTION = "Dorade Sweep Data";

    public DoradeDataSource() {
    }

    public DoradeDataSource(DataSourceDescriptor descriptor, String fileName, Hashtable properties) throws VisADException {
        this(descriptor, Misc.newList(fileName), properties);
    }

    public DoradeDataSource(DataSourceDescriptor descriptor, List sources, Hashtable properties) throws VisADException {
        super(descriptor, sources, DATA_DESCRIPTION, properties);
    }

    @Override
    public void doMakeDataChoices() {
        List categories = Misc.newList(CATEGORY_SWEEP_2D);
        DoradeAdapter da = (DoradeAdapter)this.getRadarAdapters().get(0);
        RealType[] paramTypes = da.getParams();
        for (int i = 0; i < paramTypes.length; ++i) {
            String paramName = paramTypes[i].getName();
            this.addDataChoice(new DirectDataChoice((DataSource)this, (Object)paramTypes[i], paramName, paramName, categories, DataChoice.NULL_PROPERTIES));
        }
    }

    @Override
    protected RadarAdapter makeRadarAdapter(String source) throws Exception {
        DoradeAdapter adapter = new DoradeAdapter(this, source);
        return adapter;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DoradeDataSource)) {
            return false;
        }
        return this == (DoradeDataSource)o;
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        return hashCode;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: DoradeDataSource <dorade_sweepfile>");
            System.exit(1);
        }
        try {
            DataSourceDescriptor dsDesc = new DataSourceDescriptor("FILE.DORADERADAR", "test label", null, DoradeDataSource.class, "swp\\.*$", true, false, null);
            DoradeDataSource dds = new DoradeDataSource(dsDesc, args[0], null);
            System.out.println("created " + dds.getName() + " (" + dds.getDescription() + ")");
            XmlEncoder encoder = new XmlEncoder();
            String xmlString = encoder.toXml(dds);
            System.out.println("saved to XML");
            dds = (DoradeDataSource)encoder.toObject(xmlString);
            dds.initAfterUnpersistence();
            System.out.println("restored " + dds.getName() + " (" + dds.getDescription() + ")");
            System.out.println("sweep time is " + dds.doMakeDateTimes().get(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

