/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import ucar.atd.dorade.DoradePARM;
import ucar.atd.dorade.DoradeSweep;
import ucar.atd.dorade.ScanMode;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.radar.RadarAdapter;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectPair;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.DataImpl;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.bom.Radar2DCoordinateSystem;
import visad.bom.Radar3DCoordinateSystem;
import visad.data.units.ParseException;
import visad.data.units.Parser;

public class DoradeAdapter
implements RadarAdapter {
    private String swpFileName = null;
    private DoradeSweep mySweep = null;
    private DataSourceImpl dataSource;
    private int sensor = 0;
    private int nRays;
    private int nCells;
    private DateTime swpTime;
    private HashMap paramMap;
    private RealType[] paramTypes;
    private Unit[] units;
    private RealTupleType radarDomain2d;
    private RealTupleType radarDomain3d;
    private GriddedSet productDomain2d;
    private GriddedSet productDomain3d;
    private Hashtable cache = new Hashtable();
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(DoradeAdapter.class.getName());

    public DoradeAdapter() {
    }

    public DoradeAdapter(DataSourceImpl source, String fileName) throws VisADException {
        this.swpFileName = fileName;
        this.dataSource = source;
        this.init();
    }

    private void init() throws VisADException {
        String sensorName = null;
        try {
            this.mySweep = new DoradeSweep(this.swpFileName);
            this.swpTime = new DateTime(this.mySweep.getTime());
            this.nRays = this.mySweep.getNRays();
            this.nCells = this.mySweep.getNCells(0);
            DoradePARM[] parms = this.mySweep.getParamList();
            if (this.mySweep.getNSensors() > 1) {
                throw new VisADException("cannot handle multiple-sensor DORADE sweep files");
            }
            sensorName = this.mySweep.getSensorName(this.sensor);
            this.paramMap = new HashMap();
            for (int p = 0; p < parms.length; ++p) {
                this.paramMap.put(parms[p].getName(), parms[p]);
            }
            this.initVisADMembers();
        }
        catch (VisADException vex) {
            throw vex;
        }
        catch (DoradeSweep.DoradeSweepException ex) {
            LogUtil.logException("DORADE sweep error", ex);
        }
    }

    @Override
    public void clearCachedData() {
    }

    private void initVisADMembers() throws VisADException {
        boolean use3d = true;
        int nParams = this.paramMap.size();
        this.paramTypes = new RealType[nParams];
        this.units = new Unit[nParams];
        Iterator iter = this.paramMap.values().iterator();
        int p = 0;
        while (iter.hasNext()) {
            DoradePARM parm = (DoradePARM)iter.next();
            Unit u = null;
            try {
                u = Parser.parse(parm.getUnits());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.units[p] = u;
            this.paramTypes[p] = RealType.getRealType(parm.getName(), u, null);
            ++p;
        }
        Radar3DCoordinateSystem rcs3d = null;
        Radar2DCoordinateSystem rcs2d = null;
        try {
            float cellSpacing = this.mySweep.getCellSpacing(this.sensor);
            float centerOfFirstCell = this.mySweep.getRangeToFirstCell(this.sensor) + 0.5f * cellSpacing;
            rcs3d = new Radar3DCoordinateSystem(this.mySweep.getLatitude(this.sensor), this.mySweep.getLongitude(this.sensor), this.mySweep.getAltitude(this.sensor) / 1000.0f, centerOfFirstCell, cellSpacing, 0.0f, 1.0f, 0.0f, 1.0f);
            rcs2d = new Radar2DCoordinateSystem(this.mySweep.getLatitude(this.sensor), this.mySweep.getLongitude(this.sensor), centerOfFirstCell, cellSpacing, 0.0f, 1.0f);
        }
        catch (DoradeSweep.MovingSensorException ex) {
            LogUtil.logException("can't handle moving sensor", ex);
            return;
        }
        Unit[] domUnits3d = new Unit[]{CommonUnit.meter, CommonUnit.degree, CommonUnit.degree};
        Unit[] domUnits2d = new Unit[]{CommonUnit.meter, CommonUnit.degree};
        float[][] domainVals3d = new float[3][this.nCells * this.nRays];
        float[][] domainVals2d = new float[2][];
        float[] azimuths = this.mySweep.getAzimuths();
        float[] elevations = this.mySweep.getElevations();
        for (int ray = 0; ray < this.nRays; ++ray) {
            for (int cell = 0; cell < this.nCells; ++cell) {
                int elem = ray * this.nCells + cell;
                domainVals3d[0][elem] = cell;
                domainVals3d[1][elem] = azimuths[ray];
                domainVals3d[2][elem] = elevations[ray];
            }
        }
        domainVals2d[0] = domainVals3d[0];
        domainVals2d[1] = domainVals3d[1];
        this.radarDomain3d = new RealTupleType(RANGE_TYPE, AZIMUTH_TYPE, ELEVATION_ANGLE_TYPE, rcs3d, null);
        this.radarDomain2d = new RealTupleType(RANGE_TYPE, AZIMUTH_TYPE, rcs2d, (Set)null);
        try {
            this.productDomain3d = new Gridded3DSet((MathType)this.radarDomain3d, domainVals3d, this.nCells, this.nRays, null, domUnits3d, (ErrorEstimate[])null, false);
            this.productDomain2d = new Gridded2DSet(this.radarDomain2d, domainVals2d, this.nCells, this.nRays, null, domUnits2d, null, false, false);
        }
        catch (VisADException vae) {
            System.err.println("radarDomain2d: " + this.radarDomain2d + "\n" + "radarDomain3d: " + this.radarDomain3d + "\n" + "nCells: " + this.nCells + "\n" + "nRays: " + this.nRays + "\n" + "domainVals.length " + domainVals3d.length + "\n" + "domainVals[0].length " + domainVals3d[0].length + "\n");
            throw vae;
        }
    }

    @Override
    public DataImpl getData(DataChoice dataChoice, DataSelection subset, Hashtable requestProperties) throws VisADException, RemoteException {
        String prop2dOr3d;
        if (requestProperties != null) {
            Hashtable<DateTime, String> timeLabels = (Hashtable<DateTime, String>)requestProperties.get("prop.timelabels");
            if (timeLabels == null) {
                timeLabels = new Hashtable<DateTime, String>();
                requestProperties.put("prop.timelabels", timeLabels);
            }
            if (this.isRHI()) {
                timeLabels.put(this.getBaseTime(), "RHI: " + this.mySweep.getFixedAngle());
            } else {
                timeLabels.put(this.getBaseTime(), "Elevation: " + Misc.format(this.mySweep.getFixedAngle()));
            }
        }
        if (requestProperties == null) {
            requestProperties = dataChoice.getProperties() != null ? dataChoice.getProperties() : new Hashtable();
        }
        boolean use3d = (prop2dOr3d = (String)requestProperties.get("Level2RadarDataSource.2Dor3D")) != null && prop2dOr3d.equals("Level2RadarDataSource.3D");
        ObjectPair cacheKey = new ObjectPair(this.swpFileName, new ObjectPair(dataChoice, new Boolean(use3d)));
        FieldImpl singleSweep = null;
        singleSweep = (FieldImpl)this.cache.get(cacheKey);
        if (singleSweep != null) {
            return singleSweep;
        }
        RealTupleType radarDomain = use3d ? this.radarDomain3d : this.radarDomain2d;
        GriddedSet productDomain = use3d ? this.productDomain3d : this.productDomain2d;
        RealType pType = (RealType)dataChoice.getId();
        int unitIndex = -1;
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (!this.paramTypes[i].equals(pType)) continue;
            unitIndex = i;
            break;
        }
        Unit u = this.units[unitIndex];
        String paramName = pType.getName();
        DoradePARM parm = (DoradePARM)this.paramMap.get(paramName);
        RealTupleType rangeType = new RealTupleType(pType);
        FunctionType ftype = new FunctionType(radarDomain, pType);
        singleSweep = new FlatField(ftype, (Set)productDomain, (CoordinateSystem[])null, (Set[])null, new Unit[]{u});
        float[][] allValues = new float[1][this.nCells * this.nRays];
        long start = System.currentTimeMillis();
        float[] rayValues = null;
        for (int r = 0; r < this.nRays; ++r) {
            try {
                rayValues = this.mySweep.getRayData(parm, r, rayValues);
            }
            catch (DoradeSweep.DoradeSweepException ex) {
                LogUtil.logException("getting ray data", ex);
            }
            System.arraycopy(rayValues, 0, allValues[0], r * this.nCells, this.nCells);
        }
        for (int samp = 0; samp < this.nRays * this.nCells; ++samp) {
            if (allValues[0][samp] != Float.MAX_VALUE) continue;
            allValues[0][samp] = Float.NaN;
        }
        try {
            ((FlatField)singleSweep).setSamples(allValues, (ErrorEstimate[])null, false);
        }
        catch (Exception exc) {
            LogUtil.logException("putting sample data", exc);
        }
        this.cache.put(cacheKey, singleSweep);
        return singleSweep;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DoradeAdapter)) {
            return false;
        }
        DoradeAdapter da = (DoradeAdapter)o;
        return this.swpFileName.equals(da.swpFileName);
    }

    public int hashCode() {
        int hashCode = this.swpFileName.hashCode();
        return hashCode;
    }

    @Override
    public DateTime getBaseTime() {
        return this.swpTime;
    }

    protected RealType[] getParams() {
        return this.paramTypes;
    }

    public boolean isPPI() {
        return this.mySweep.getScanMode() == ScanMode.MODE_PPI;
    }

    public boolean isRHI() {
        return this.mySweep.getScanMode() == ScanMode.MODE_RHI;
    }

    public boolean isSurvey() {
        return this.mySweep.getScanMode() == ScanMode.MODE_SUR;
    }

    public ScanMode getScanMode() {
        return this.mySweep.getScanMode();
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public String toString() {
        return this.swpFileName;
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            DoradeSweep sweep = new DoradeSweep(args[i]);
            int nRays = sweep.getNRays();
            int nCells = sweep.getNCells(0);
            DoradePARM param = sweep.lookupParamIgnoreCase("VR");
            float[] azimuths = sweep.getAzimuths();
            float[] elevations = sweep.getElevations();
            for (int rayIdx = 0; rayIdx < nRays; ++rayIdx) {
                System.out.println("ray:" + rayIdx + " " + elevations[rayIdx] + " " + azimuths[rayIdx]);
                float[] rayValues = sweep.getRayData(param, rayIdx);
                for (int cellIdx = 0; cellIdx < nRays; ++cellIdx) {
                    if (cellIdx > 0) {
                        System.out.print(",");
                    }
                    System.out.print("" + rayValues[cellIdx]);
                }
                System.out.println("");
            }
        }
    }

    @Override
    public void doRemove() {
    }
}

