/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CDMRadarSweepDB {
    private Map<Integer, Ray> sweepTableHash = null;

    public CDMRadarSweepDB(float[] s, int[] sIdx, float b) throws IOException {
        if (this.sweepTableHash == null) {
            this.readSweepTable(s, sIdx, b);
        }
    }

    public Ray get(int idx) {
        return this.sweepTableHash.get(idx);
    }

    private void readSweepTable(float[] s, int[] sIdx, float beamWidth) throws IOException {
        this.sweepTableHash = new HashMap<Integer, Ray>();
        int numberOfRay = s.length;
        if (s == null) {
            return;
        }
        float res = 360.0f / (float)numberOfRay;
        if (beamWidth != 0.0f) {
            res = beamWidth;
        }
        float[] _azimuths = s;
        for (int i = 0; i < numberOfRay; ++i) {
            float azi = 0.0f;
            azi = _azimuths[i];
            if (Float.isNaN(azi)) continue;
            int iazim = Math.round(azi + res / 2.0f);
            if (iazim >= numberOfRay) {
                iazim -= numberOfRay;
            }
            Ray r = new Ray();
            r.index = iazim;
            r.rayIndex = sIdx[i];
            r.azimuth = azi;
            if (r.index >= 360) continue;
            this.sweepTableHash.put(r.index, r);
        }
    }

    public class Ray {
        public int index;
        public int rayIndex;
        public float azimuth;

        public String toString() {
            return Integer.toString(this.rayIndex);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + Float.floatToIntBits(this.azimuth);
            result = 31 * result + this.index;
            result = 31 * result + this.rayIndex;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Ray other = (Ray)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (Float.floatToIntBits(this.azimuth) != Float.floatToIntBits(other.azimuth)) {
                return false;
            }
            if (this.index != other.index) {
                return false;
            }
            return this.rayIndex == other.rayIndex;
        }

        private CDMRadarSweepDB getOuterType() {
            return CDMRadarSweepDB.this;
        }
    }
}

