/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import ucar.nc2.units.DateUnit;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.radar.CDMRadarAdapter;
import ucar.unidata.data.radar.DoradeDataSource;
import ucar.unidata.data.radar.RadarAdapter;
import ucar.unidata.data.radar.RadarDataSource;
import ucar.unidata.data.radar.RadarQuery;
import ucar.unidata.data.radar.TDSRadarDatasetCollection;
import ucar.unidata.metdata.NamedStation;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.metdata.NamedStationTable;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.DatedObject;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectArray;
import ucar.unidata.xml.XmlEncoder;
import ucar.visad.Util;
import visad.CommonUnit;
import visad.Data;
import visad.DateTime;
import visad.Real;
import visad.RealType;
import visad.VisADException;
import visad.georef.EarthLocation;

public class CDMRadarDataSource
extends RadarDataSource {
    public static final String PROP_RADARQUERY = "prop.radarquery";
    public static final String LevelII = "Level II";
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(DoradeDataSource.class.getName());
    private static final String DATA_DESCRIPTION = "Common Data Model Radial type Data";
    private static NamedStationTable nexradStations = null;
    private JComboBox stationBox;
    private NamedStation namedStation = null;
    private boolean isRHI = false;
    List<DateTime> initTimes;
    private boolean isRelativeTime = false;

    public CDMRadarDataSource() {
    }

    public CDMRadarDataSource(DataSourceDescriptor descriptor, List sources, Hashtable properties) throws VisADException {
        super(descriptor, sources, DATA_DESCRIPTION, properties);
    }

    public CDMRadarDataSource(DataSourceDescriptor descriptor, String[] sources, Hashtable properties) throws VisADException {
        this(descriptor, Misc.toList(sources), properties);
    }

    public CDMRadarDataSource(DataSourceDescriptor descriptor, String fileName, Hashtable properties) throws VisADException {
        this(descriptor, Misc.newList(fileName), properties);
    }

    public CDMRadarDataSource(DataSourceDescriptor descriptor, RadarQuery radarQuery, Hashtable properties) throws VisADException {
        super(descriptor, new ArrayList(), DATA_DESCRIPTION, properties);
        this.setProperty(PROP_RADARQUERY, radarQuery);
        this.makeSources();
    }

    @Override
    protected boolean shouldCache(Data data) {
        return false;
    }

    @Override
    public void reloadData(Object object, Hashtable properties) {
        super.reloadData();
        if (object instanceof RadarQuery) {
            this.reloadProperties(properties);
            this.setProperty(PROP_RADARQUERY, object);
            this.sourcesChanged();
        } else {
            super.reloadData(object, properties);
        }
    }

    @Override
    public void initAfterUnpersistence() {
        this.makeSources();
        super.initAfterUnpersistence();
    }

    @Override
    public void reloadData() {
        this.makeSources();
        super.reloadData();
    }

    private void makeSources() {
        try {
            RadarQuery query = (RadarQuery)this.getProperty(PROP_RADARQUERY);
            if (query == null) {
                return;
            }
            if (this.getProperties() != null) {
                Object d;
                Object t = this.getProperties().get("UseTimeDriver");
                if (t instanceof Boolean && !this.useDriverTime) {
                    this.useDriverTime = (Boolean)t;
                }
                if ((d = this.getProperties().get("TimeDriver")) != null) {
                    this.TimeDriver = d;
                }
            }
            DateSelection dateSelection = query.getDateSelection();
            List times = dateSelection.getTimes();
            ArrayList<String> urls = new ArrayList<String>();
            StringBuffer errlog = new StringBuffer();
            TDSRadarDatasetCollection collection = TDSRadarDatasetCollection.factory("test", query.getCollectionUrl(), errlog);
            if (times == null || times.size() == 0 || this.useDriverTime) {
                ArrayList<DatedObject> allTimes = new ArrayList<DatedObject>();
                List<Cloneable> collectionTimes = null;
                if (this.useDriverTime && this.initTimes != null) {
                    collectionTimes = this.initTimes;
                    for (int timeIdx = 0; timeIdx < collectionTimes.size(); ++timeIdx) {
                        DateTime timeObj = collectionTimes.get(timeIdx);
                        Date date = timeObj instanceof Date ? (Date)((Object)timeObj) : DateUnit.getStandardOrISO(((Object)timeObj).toString());
                        allTimes.add(new DatedObject(date));
                    }
                    times = DatedObject.unwrap(allTimes);
                } else {
                    List<String> timeSpan = collection.getRadarTimeSpan();
                    Date fromDate = DateUnit.getStandardOrISO(timeSpan.get(0));
                    Date toDate = DateUnit.getStandardOrISO(timeSpan.get(1));
                    if (dateSelection.getStartMode() == 3 && dateSelection.getEndMode() == 3 && !dateSelection.hasInterval()) {
                        long maxIntervalMinutes = 10L;
                        long minutesOffset = (long)dateSelection.getCount() * maxIntervalMinutes * 20L;
                        fromDate = new Date(toDate.getTime() - 1000L * minutesOffset * 60L);
                    }
                    collectionTimes = collection.getRadarStationTimes(query.getStation(), query.getProduct(), fromDate, toDate);
                    for (int timeIdx = 0; timeIdx < collectionTimes.size(); ++timeIdx) {
                        Cloneable timeObj = collectionTimes.get(timeIdx);
                        Date date = timeObj instanceof Date ? (Date)timeObj : DateUnit.getStandardOrISO(timeObj.toString());
                        allTimes.add(new DatedObject(date));
                    }
                    times = DatedObject.unwrap(query.getDateSelection().apply(allTimes));
                    this.isRelativeTime = true;
                }
            }
            if (times == null || times.size() == 0) {
                return;
            }
            for (int i = 0; i < times.size(); ++i) {
                Date date = (Date)times.get(i);
                URI uri = collection.getRadarDatasetURI(query.getStation(), query.getProduct(), date);
                urls.add(uri.toString());
            }
            this.setSources(urls);
        }
        catch (Exception excp) {
            this.logException("Creating urls to radar data", excp);
        }
    }

    @Override
    protected boolean isRealTime() {
        boolean isRealTime = super.isRealTime();
        return isRealTime || this.isRelativeTime;
    }

    @Override
    public List<DateTime> getAllTimesForTimeDriver(DataChoice dataChoice, DataSelection selection, List<DateTime> timeDriverTimes) {
        int num = timeDriverTimes.size();
        Collections.sort(timeDriverTimes);
        List<Date> collectionTimes = null;
        RadarQuery query = (RadarQuery)this.getProperty(PROP_RADARQUERY);
        if (query != null) {
            StringBuffer errlog = new StringBuffer();
            Date fromDate = DateUnit.getStandardOrISO(timeDriverTimes.get(0).dateString() + "T" + timeDriverTimes.get(0).timeString());
            Date toDate = DateUnit.getStandardOrISO(timeDriverTimes.get(num - 1).dateString() + "T" + timeDriverTimes.get(num - 1).timeString());
            try {
                TDSRadarDatasetCollection collection = TDSRadarDatasetCollection.factory("test", query.getCollectionUrl(), errlog);
                List<String> timeSpan = collection.getRadarTimeSpan();
                collectionTimes = collection.getRadarStationTimes(query.getStation(), query.getProduct(), fromDate, toDate);
            }
            catch (Exception exception) {}
        } else {
            collectionTimes = dataChoice.getAllDateTimes();
        }
        List<Date> results = null;
        try {
            results = DataUtil.selectDatesFromList(collectionTimes, timeDriverTimes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initTimes = results;
        return results;
    }

    @Override
    public void doMakeDataChoices() {
        String ids;
        List<RadarAdapter> adapters = this.getRadarAdapters();
        if (adapters == null || adapters.isEmpty()) {
            return;
        }
        CDMRadarAdapter da = (CDMRadarAdapter)adapters.get(0);
        boolean haveTimes = adapters.size() > 1;
        RealType[] paramTypes = da.getParams();
        String stationID = da.getStationID();
        String stationName = da.getStationName();
        String dataFormat = da.getDataFormatName();
        this.isRHI = da.isRHI();
        if (this.getProperties() != null) {
            Object t;
            Object o = this.getProperties().get("station location");
            if (o instanceof NamedStation) {
                this.namedStation = (NamedStation)o;
            }
            if ((t = this.getProperties().get("TimeDriverEnable")) instanceof Boolean) {
                this.useDriverTime = (Boolean)t;
            }
        }
        EarthLocation rdLocation = da.getStationLocation();
        this.setName(this.makeName(da));
        String string = ids = stationID.length() > 3 ? stationID.substring(1) : stationID.toString();
        if (this.namedStation == null || this.namedStation.getID().equalsIgnoreCase(ids)) {
            try {
                this.namedStation = new NamedStationImpl(ids, stationName, rdLocation.getLatitude().getValue(), rdLocation.getLongitude().getValue(), rdLocation.getAltitude().getValue(), CommonUnit.meter);
            }
            catch (Exception excp) {
                this.logException("Creating data choices", excp);
            }
        }
        try {
            for (int i = 0; i < paramTypes.length; ++i) {
                Hashtable dataChoiceProperties;
                String name;
                int j;
                CompositeDataChoice momentChoice;
                Hashtable compositeProperties;
                List categories2D;
                List categories;
                String rtName = paramTypes[i].getName();
                String paramName = Util.cleanTypeName(rtName);
                Integer momentObj = new Integer(i);
                if (da.isVolume()) {
                    if (da.isRHI()) {
                        categories = Misc.newList(CATEGORY_RHISWEEP, CATEGORY_ISOSURFACE, CATEGORY_VOLUME);
                    } else {
                        categories = Misc.newList(CATEGORY_RHI, CATEGORY_CAPPI, CATEGORY_ISOSURFACE, CATEGORY_VOLUME, CATEGORY_VCS);
                        if (haveTimes) {
                            categories.add(CATEGORY_SWEEP_3D_TIME);
                        } else {
                            categories.add(CATEGORY_SWEEP_3D);
                        }
                    }
                } else if (da.isRaster()) {
                    List list = categories2D = haveTimes ? Misc.newList(CATEGORY_RASTER_2D_TIME) : Misc.newList(CATEGORY_RASTER_2D);
                    categories = haveTimes ? Misc.newList(CATEGORY_RASTER_2D) : Misc.newList(CATEGORY_RASTER_2D_TIME);
                } else {
                    categories = da.isRHI() ? Misc.newList(CATEGORY_RHISWEEP) : (haveTimes ? Misc.newList(CATEGORY_SWEEP_2D_TIME, CATEGORY_SWEEP_3D_TIME) : Misc.newList(CATEGORY_SWEEP_2D, CATEGORY_SWEEP_3D));
                }
                double[] angles = da.getAngles(paramName);
                if (da.isRHI()) {
                    compositeProperties = Misc.newHashtable("Level2RadarDataSource.azimuths", angles, "station location", this.namedStation);
                    compositeProperties.put("prop.icon", "/auxdata/ui/icons/Radar.gif");
                    momentChoice = new CompositeDataChoice((DataSource)this, (Object)new ObjectArray(momentObj, paramName, rtName, "Level2RadarDataSource.3D"), stationID + " " + paramName, paramName, categories, compositeProperties);
                } else {
                    compositeProperties = Misc.newHashtable("Level2RadarDataSource.angles", angles, "station location", this.namedStation, "Level2RadarDataSource.volumeorsweep", "Level2RadarDataSource.volume");
                    compositeProperties.put("prop.icon", "/auxdata/ui/icons/Radar.gif");
                    momentChoice = new CompositeDataChoice((DataSource)this, (Object)new ObjectArray(momentObj, paramName, rtName, "Level2RadarDataSource.3D"), stationID + " " + paramName, paramName, categories, compositeProperties);
                }
                categories2D = da.isRHI() ? Misc.newList(CATEGORY_RHISWEEP) : (da.isRaster() ? (haveTimes ? Misc.newList(CATEGORY_RASTER_2D_TIME) : Misc.newList(CATEGORY_RASTER_2D)) : (haveTimes ? Misc.newList(CATEGORY_SWEEP_2D_TIME, CATEGORY_SWEEP_3D_TIME) : Misc.newList(CATEGORY_SWEEP_2D, CATEGORY_SWEEP_3D)));
                if (da.isRHI()) {
                    for (j = 0; j < angles.length; ++j) {
                        name = "Azimuth Angle " + Misc.format(angles[j]);
                        dataChoiceProperties = Misc.newHashtable(new Object[]{"Level2RadarDataSource.azimuths", new double[]{angles[j]}, "Level2RadarDataSource.azimuth", new Double(j), "Level2RadarDataSource.volumeorsweep", "Level2RadarDataSource.3D"});
                        dataChoiceProperties.put("station location", this.namedStation);
                        dataChoiceProperties.put("prop.icon", "/auxdata/ui/icons/RadarAngle.gif");
                        momentChoice.addDataChoice(new DirectDataChoice((DataSource)this, (Object)new ObjectArray(momentObj, new Double(angles[j]), rtName, "Level2RadarDataSource.2D"), stationID + " " + paramName, paramName + " " + name, categories2D, dataChoiceProperties));
                    }
                } else {
                    for (j = 0; j < angles.length; ++j) {
                        name = "Elevation Angle " + Misc.format(angles[j]);
                        dataChoiceProperties = Misc.newHashtable(new Object[]{"Level2RadarDataSource.angles", new double[]{angles[j]}, "Level2RadarDataSource.angle", new Double(j), "Level2RadarDataSource.volumeorsweep", "Level2RadarDataSource.sweep"});
                        dataChoiceProperties.put("station location", this.namedStation);
                        dataChoiceProperties.put("prop.icon", "/auxdata/ui/icons/RadarAngle.gif");
                        momentChoice.addDataChoice(new DirectDataChoice((DataSource)this, (Object)new ObjectArray(momentObj, new Double(angles[j]), rtName, "Level2RadarDataSource.2D"), stationID + " " + paramName, paramName + " " + name, categories2D, dataChoiceProperties));
                    }
                }
                this.addDataChoice(momentChoice);
            }
        }
        catch (Exception excp) {
            this.logException("Creating data choices", excp);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CDMRadarDataSource)) {
            return false;
        }
        return this == (CDMRadarDataSource)o;
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        return hashCode;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: DoradeDataSource <dorade_sweepfile>");
            System.exit(1);
        }
        try {
            DataSourceDescriptor dsDesc = new DataSourceDescriptor("FILE.DORADERADAR", "test label", null, CDMRadarDataSource.class, "swp\\.*$", true, false, null);
            CDMRadarDataSource dds = new CDMRadarDataSource(dsDesc, args[0], null);
            System.out.println("created " + dds.getName() + " (" + dds.getDescription() + ")");
            XmlEncoder encoder = new XmlEncoder();
            String xmlString = encoder.toXml(dds);
            System.out.println("saved to XML");
            dds = (CDMRadarDataSource)encoder.toObject(xmlString);
            dds.initAfterUnpersistence();
            System.out.println("restored " + dds.getName() + " (" + dds.getDescription() + ")");
            System.out.println("sweep time is " + dds.doMakeDateTimes().get(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    protected RadarAdapter makeRadarAdapter(String source) throws Exception {
        String sid;
        CDMRadarAdapter adapter = new CDMRadarAdapter(this, source);
        EarthLocation elf = adapter.getRadarStationInFile();
        if (elf == null && (sid = adapter.getStationID()) != null) {
            NamedStation rstation = null;
            if (sid.length() == 4) {
                rstation = (NamedStation)this.getStations().get(sid.substring(1));
            } else if (sid.length() == 3) {
                rstation = (NamedStation)this.getStations().get(sid);
            }
            if (rstation != null) {
                adapter.setStationLocation(rstation.getNamedLocation());
            }
        }
        return adapter;
    }

    @Override
    public void getPropertiesComponents(List comps) {
        super.getPropertiesComponents(comps);
        List<RadarAdapter> adapters = this.getRadarAdapters();
        if (adapters == null || adapters.isEmpty()) {
            return;
        }
        if (((CDMRadarAdapter)adapters.get(0)).getDataFormatName().equals(LevelII)) {
            Vector items = new Vector();
            items.addAll(this.getStations().values());
            Collections.sort(items);
            this.stationBox = new JComboBox(items);
            if (this.namedStation == null) {
                Object o;
                Object v0 = o = this.getProperties() != null ? this.getProperties().get("station location") : null;
                if (o != null && o instanceof NamedStation) {
                    this.namedStation = o;
                }
            }
            if (this.namedStation != null) {
                int selected = 0;
                for (int i = 0; i < items.size(); ++i) {
                    if (!Misc.equals(this.namedStation.getID(), ((NamedStation)items.get(i)).getID())) continue;
                    selected = i;
                    break;
                }
                this.stationBox.setSelectedIndex(selected);
            }
            comps.add(GuiUtils.rLabel("Station Location: "));
            comps.add(this.stationBox);
        }
    }

    @Override
    public boolean applyProperties() {
        Object o;
        if (!super.applyProperties()) {
            return false;
        }
        if (this.stationBox != null && (o = this.stationBox.getSelectedItem()) instanceof NamedStation) {
            this.setStationInfo((NamedStation)o);
        }
        return true;
    }

    private void setStationInfo(NamedStation station) {
        if (station == null) {
            return;
        }
        Hashtable props = this.getProperties();
        if (props != null) {
            props.put("station location", station);
        } else {
            this.setProperties(Misc.newHashtable("station location", station));
        }
        List<RadarAdapter> l2as = this.getRadarAdapters();
        if (l2as != null) {
            for (int i = 0; i < l2as.size(); ++i) {
                try {
                    ((CDMRadarAdapter)l2as.get(i)).setStationLocation(station.getNamedLocation());
                    continue;
                }
                catch (Exception excp) {
                    this.logException("Couldn't set station on adapter", excp);
                }
            }
        }
        this.flushCache();
        CDMRadarAdapter da = (CDMRadarAdapter)l2as.get(0);
        this.dataChoices = null;
        this.doMakeDataChoices();
        this.setDescription(this.getName());
        this.getDataContext().dataSourceChanged(this);
    }

    @Override
    public boolean canCacheDataToDisk() {
        return true;
    }

    public NamedStationTable getStations() {
        if (nexradStations == null) {
            nexradStations = this.getDataContext().getResourceManager().findLocations("NEXRAD Sites");
        }
        return nexradStations;
    }

    @Override
    public List getAllLevels(DataChoice dataChoice, DataSelection dataSelection) {
        dataSelection = DataSelection.merge(dataSelection, this.getDataSelection());
        ArrayList<Real> levels = new ArrayList<Real>();
        Hashtable props = dataChoice.getProperties();
        if (this.isRHI) {
            if (props == null || props.get("Level2RadarDataSource.azimuths") == null) {
                return levels;
            }
            double[] angles = (double[])props.get("Level2RadarDataSource.azimuths");
            for (int i = 0; i < angles.length; ++i) {
                levels.add(new Real(RadarAdapter.AZIMUTH_ANGLE_TYPE, angles[i]));
            }
        } else {
            if (props == null || props.get("Level2RadarDataSource.angles") == null) {
                return levels;
            }
            double[] angles = (double[])props.get("Level2RadarDataSource.angles");
            for (int i = 0; i < angles.length; ++i) {
                levels.add(new Real(RadarAdapter.ELEVATION_ANGLE_TYPE, angles[i]));
            }
        }
        return levels;
    }

    private String makeName(CDMRadarAdapter da) {
        String stationID = da.getStationID();
        String dataFormat = da.getDataFormatName();
        return dataFormat + " Radar Data (" + stationID + ")";
    }
}

