/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.radar;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import ucar.atd.dorade.DoradePARM;
import ucar.atd.dorade.DoradeSweep;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.units.DateUnit;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.radar.CDMRadarSweepDB;
import ucar.unidata.data.radar.RadarAdapter;
import ucar.unidata.data.radar.VCP;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ObjectArray;
import ucar.unidata.util.ObjectPair;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.RadarMapProjection;
import ucar.visad.Util;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.QuickSort;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.SingletonSet;
import visad.Unit;
import visad.VisADException;
import visad.bom.Radar2DCoordinateSystem;
import visad.bom.Radar3DCoordinateSystem;
import visad.data.CachedFlatField;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationLite;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;
import visad.georef.NamedLocation;

public class CDMRadarAdapter
implements RadarAdapter {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(CDMRadarAdapter.class.getName());
    private String swpFileName = null;
    private String stationName = null;
    private String stationID = null;
    private String dataFormatName = null;
    private Attribute format = null;
    private EarthLocation radarLocation = null;
    private DateTime baseTime = null;
    private double D = 5.8869E-5;
    private HashMap anglesMap;
    private DataSourceImpl dataSource;
    private boolean isVolume;
    private HashMap paramMap;
    private RealType[] paramTypes;
    private RealTupleType radarDomain2d;
    private RealTupleType radarDomain3d;
    private RadialDatasetSweep rds;
    private String vcp;
    private GridDataset gcd;
    private boolean isRaster;
    private double Re = 8498.666666666666;
    private double M_PI = Math.PI;
    private boolean isRHI;
    private CDMRadarSweepDB[] RSL_sweep_list = null;
    private float[][][] rayData = null;
    private int[][] rayIndex = null;
    private HashMap rhiData = null;
    private float[] meanEle = null;
    private HashMap cutmap = null;
    private double range_step;
    private double range_to_first_gate;
    int number_of_bins;
    static boolean newWay = true;

    public CDMRadarAdapter() {
    }

    public CDMRadarAdapter(DataSourceImpl source, String fileName) throws VisADException {
        Object o;
        this.swpFileName = fileName;
        this.dataSource = source;
        if (this.dataSource != null && (o = this.dataSource.getProperty("station location", (Object)null)) != null) {
            if (o instanceof EarthLocation) {
                this.radarLocation = (EarthLocation)o;
            } else if (o instanceof NamedStationImpl) {
                this.radarLocation = ((NamedStationImpl)o).getNamedLocation();
            }
        }
        this.init();
    }

    private int calcRangeBin(double elevation, double level, double rangeStep) {
        double a = Math.cos(elevation * Math.PI / 180.0);
        a = this.D * a * a;
        double b = Math.sin(elevation * Math.PI / 180.0);
        double c = b * b + 4.0 * a * (level / 1000.0);
        return (int)((-b + Math.sqrt(c)) / (2.0 * a) / rangeStep);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CDMRadarAdapter)) {
            return false;
        }
        CDMRadarAdapter da = (CDMRadarAdapter)o;
        return this.swpFileName.equals(da.swpFileName);
    }

    public int hashCode() {
        int hashCode = this.swpFileName.hashCode();
        return hashCode;
    }

    public EarthLocation getRadarStationInFile() {
        Attribute altAttr;
        Attribute lonAttr;
        Attribute latAttr = this.rds.findGlobalAttributeIgnoreCase("RadarLatitude");
        if (latAttr == null) {
            latAttr = this.rds.findGlobalAttributeIgnoreCase("StationLatitude");
        }
        if ((lonAttr = this.rds.findGlobalAttributeIgnoreCase("RadarLongitude")) == null) {
            lonAttr = this.rds.findGlobalAttributeIgnoreCase("StationLongitude");
        }
        if ((altAttr = this.rds.findGlobalAttributeIgnoreCase("RadarAltitude")) == null) {
            altAttr = this.rds.findGlobalAttributeIgnoreCase("StationElevationInMeters");
        }
        if (latAttr != null && lonAttr != null && altAttr != null) {
            double latitude = latAttr.getNumericValue().doubleValue();
            double longitude = lonAttr.getNumericValue().doubleValue();
            double altitude = altAttr.getNumericValue().doubleValue();
            if (latitude == 0.0 && longitude == 0.0) {
                return null;
            }
            EarthLocationLite elt = new EarthLocationLite(new Real(RealType.Latitude, latitude), new Real(RealType.Longitude, longitude), new Real(RealType.Altitude, altitude));
            return elt;
        }
        return null;
    }

    private void init() throws VisADException {
        Trace.call1("CDMRadarAdapter:init");
        this.paramMap = new HashMap();
        this.anglesMap = new HashMap();
        try {
            String sID;
            Trace.call1("CDMRadarAdapter:open dataset");
            this.rds = this.swpFileName.endsWith("entry.das") ? (RadialDatasetSweep)FeatureDatasetFactoryManager.open(FeatureType.RADIAL, DODSNetcdfFile.canonicalURL(this.swpFileName), null, new Formatter()) : (RadialDatasetSweep)FeatureDatasetFactoryManager.open(FeatureType.RADIAL, this.swpFileName, null, new Formatter());
            Trace.call2("CDMRadarAdapter:open dataset");
            if (this.rds.getRadarName() != "XXX") {
                this.stationID = this.rds.getRadarID();
                this.stationName = this.rds.getRadarName();
            } else {
                this.stationID = "XXX";
                this.stationName = "XXX";
            }
            this.isVolume = this.rds.isVolume();
            this.dataFormatName = this.rds.getDataFormat();
            Attribute sweepMode = this.rds.findGlobalAttributeIgnoreCase("SweepMode");
            Attribute vcpAttr = this.rds.findGlobalAttributeIgnoreCase("VolumeCoveragePatternName");
            EarthLocation elf = this.getRadarStationInFile();
            if (elf != null && this.radarLocation instanceof NamedLocation && this.stationID.equalsIgnoreCase(sID = ((NamedLocation)this.radarLocation).getIdentifier().getValue())) {
                this.radarLocation = elf;
            }
            if (vcpAttr != null) {
                this.vcp = vcpAttr.getStringValue();
            }
            if (this.vcp == null) {
                this.vcp = "unknown";
            }
            Attribute attr = this.rds.findGlobalAttributeIgnoreCase("isRadial");
            if (sweepMode != null) {
                Number nmode = sweepMode.getNumericValue();
                String smode = sweepMode.getStringValue();
                if (nmode != null) {
                    int mode = sweepMode.getNumericValue().intValue();
                    if (mode == 3) {
                        this.isRHI = true;
                    }
                } else if (smode != null && smode.equals("3")) {
                    this.isRHI = true;
                }
            } else if (this.vcp.equalsIgnoreCase("RHI")) {
                this.isRHI = true;
            }
            if (attr != null) {
                int isR = attr.getNumericValue().intValue();
                if (isR == 3) {
                    this.isRaster = true;
                    this.gcd = GridDataset.open(this.swpFileName);
                    NetcdfDataset nds = this.gcd.getNetcdfDataset();
                    attr = nds.findGlobalAttributeIgnoreCase("ProductStation");
                    this.stationID = attr.getStringValue();
                    attr = this.gcd.getNetcdfDataset().findGlobalAttributeIgnoreCase("ProductStationName");
                    this.stationName = attr.getStringValue();
                    Attribute attLat = nds.findGlobalAttribute("RadarLatitude");
                    Attribute attLon = nds.findGlobalAttribute("RadarLongitude");
                    Attribute attElev = nds.findGlobalAttribute("RadarAltitude");
                    this.radarLocation = new EarthLocationTuple(attLat.getNumericValue().doubleValue(), attLon.getNumericValue().doubleValue(), attElev.getNumericValue().intValue());
                    List<GridDatatype> glist = this.gcd.getGrids();
                    String attTime = nds.findAttValueIgnoreCase(null, "time_coverage_start", null);
                    this.baseTime = new DateTime(DateUnit.getStandardOrISO(attTime));
                    Iterator<GridDatatype> iter = glist.iterator();
                    this.paramTypes = new RealType[1];
                    while (iter.hasNext()) {
                        GeoGrid gedVar = (GeoGrid)iter.next();
                        if (gedVar.getName().endsWith("RAW")) continue;
                        this.paramMap.put(gedVar.getName(), gedVar);
                        Unit u = this.getUnit(gedVar.findAttributeIgnoreCase("units"));
                        this.paramTypes[0] = DataUtil.makeRealType(gedVar.getName(), u);
                        double[] angles = new double[]{0.0};
                        this.anglesMap.put(gedVar.getName(), angles);
                    }
                    return;
                }
                if (isR == 0) {
                    throw new IOException("Unable to handle this radar product!\n");
                }
            }
            short id = this.getVCPid(this.vcp);
            List<VariableSimpleIF> rvars = this.rds.getDataVariables();
            this.format = this.rds.findGlobalAttributeIgnoreCase("format");
            if (this.radarLocation == null) {
                this.radarLocation = this.rds.isStationary() ? new EarthLocationTuple(this.rds.getCommonOrigin().getLatitude(), this.rds.getCommonOrigin().getLongitude(), this.rds.getCommonOrigin().getAltitude()) : new EarthLocationTuple(0.0, 0.0, 0.0);
            } else if (this.radarLocation instanceof NamedLocation) {
                this.stationID = ((NamedLocation)this.radarLocation).getIdentifier().getValue();
            }
            this.baseTime = new DateTime(this.rds.getCalendarDateStart().toDate());
            Iterator<VariableSimpleIF> iter = rvars.iterator();
            int p = 0;
            this.paramTypes = new RealType[rvars.size()];
            Trace.call1("CDMRadarAdapter:var iterator");
            while (iter.hasNext()) {
                RadialDatasetSweep.RadialVariable radVar = (RadialDatasetSweep.RadialVariable)iter.next();
                if (!radVar.getName().endsWith("RAW")) {
                    int i;
                    int nsweep = radVar.getNumSweeps();
                    this.paramMap.put(radVar.getName(), radVar);
                    Unit u = this.getUnit(radVar);
                    this.paramTypes[p] = DataUtil.makeRealType(radVar.getName(), u);
                    double[] angles = new double[nsweep];
                    if (this.isRHI) {
                        for (i = 0; i < nsweep; ++i) {
                            angles[i] = Misc.getAverage(radVar.getSweep(i).getAzimuth());
                        }
                    } else {
                        for (i = 0; i < nsweep; ++i) {
                            angles[i] = radVar.getSweep(i).getMeanElevation();
                        }
                    }
                    if (id != 0) {
                        double[] vcpAngles = this.getVCPAngles(id, angles);
                        this.anglesMap.put(radVar.getName(), vcpAngles);
                    } else {
                        this.anglesMap.put(radVar.getName(), angles);
                    }
                    ++p;
                    continue;
                }
                this.paramTypes = new RealType[rvars.size() - 1];
            }
            Trace.call2("CDMRadarAdapter:var iterator");
        }
        catch (IOException ex) {
            throw new VisADException(ex.getMessage());
        }
        Trace.call2("CDMRadarAdapter:init");
    }

    private RealTupleType makeDomainType2D() throws VisADException {
        Radar2DCoordinateSystem cs = this.radarLocation == null ? null : new Radar2DCoordinateSystem((float)this.radarLocation.getLatitude().getValue(CommonUnit.degree), (float)this.radarLocation.getLongitude().getValue(CommonUnit.degree));
        return new RealTupleType(RANGE_TYPE, AZIMUTH_TYPE, cs, null);
    }

    private RealTupleType makeDomainType2D(float cellSpacing, float centerOfFirstCell) throws VisADException {
        Radar2DCoordinateSystem cs = this.radarLocation == null ? null : new Radar2DCoordinateSystem((float)this.radarLocation.getLatitude().getValue(CommonUnit.degree), (float)this.radarLocation.getLongitude().getValue(CommonUnit.degree), centerOfFirstCell, cellSpacing, 0.0f, 1.0f);
        return new RealTupleType(RANGE_TYPE, AZIMUTH_TYPE, cs, null);
    }

    private RealTupleType makeDomainType3D() throws VisADException {
        Radar3DCoordinateSystem cs = this.radarLocation == null ? null : new Radar3DCoordinateSystem((float)this.radarLocation.getLatitude().getValue(CommonUnit.degree), (float)this.radarLocation.getLongitude().getValue(CommonUnit.degree), (float)this.radarLocation.getAltitude().getValue(CommonUnit.meter));
        return new RealTupleType(RANGE_TYPE, AZIMUTH_TYPE, ELEVATION_ANGLE_TYPE, cs, null);
    }

    private RealTupleType makeDomainType3D(float cellSpacing, float centerOfFirstCell) throws VisADException {
        Radar3DCoordinateSystem cs = this.radarLocation == null ? null : new Radar3DCoordinateSystem((float)this.radarLocation.getLatitude().getValue(CommonUnit.degree), (float)this.radarLocation.getLongitude().getValue(CommonUnit.degree), (float)this.radarLocation.getAltitude().getValue(CommonUnit.meter), centerOfFirstCell, cellSpacing, 0.0f, 1.0f, 0.0f, 1.0f);
        return new RealTupleType(RANGE_TYPE, AZIMUTH_TYPE, ELEVATION_ANGLE_TYPE, cs, null);
    }

    private void makeDomainTypes(float cellSpacing, float centerOfFirstCell) throws VisADException {
        this.radarDomain2d = this.makeDomainType2D(cellSpacing, centerOfFirstCell);
        this.radarDomain3d = this.makeDomainType3D(cellSpacing, centerOfFirstCell);
    }

    public String toString() {
        return this.swpFileName;
    }

    protected double[] getAngles(String vname) {
        return (double[])this.anglesMap.get(vname);
    }

    @Override
    public DateTime getBaseTime() {
        return this.baseTime;
    }

    protected short getVCPid(String vname) {
        if (vname == null) {
            return 0;
        }
        if (vname.startsWith("9 elevation")) {
            return 121;
        }
        if (vname.startsWith("7 elevation")) {
            return 32;
        }
        if (vname.startsWith("8 elevation")) {
            return 31;
        }
        if (vname.startsWith("11 elevation")) {
            return 21;
        }
        if (vname.startsWith("14 elevation")) {
            return 12;
        }
        if (vname.startsWith("16 elevation")) {
            return 11;
        }
        return 0;
    }

    protected double[] getVCPAngles(short id, double[] origAngles) {
        int len = origAngles.length;
        double[] dd = new double[len];
        for (int i = 0; i < len; ++i) {
            double ang = origAngles[i];
            dd[i] = this.getVCPAngle(ang, id);
        }
        return dd;
    }

    protected double getVCPAngle(double angle, short id) {
        double minD = Double.MAX_VALUE;
        double[] vcpAngles = VCP.getAngles(id);
        double ang = 0.0;
        for (int i = 0; i < vcpAngles.length; ++i) {
            double diff = Math.abs(angle - vcpAngles[i]);
            if (!(diff < minD)) continue;
            ang = vcpAngles[i];
            minD = diff;
        }
        return ang;
    }

    private FieldImpl getCAPPIOld(int moment, String varName, Real level) throws VisADException, RemoteException, IOException {
        Trace.call1("   getCAPPI", level.longString());
        ObjectPair cacheKey = new ObjectPair(new ObjectPair(new ObjectPair(this.radarLocation, this.baseTime), new ObjectPair(new Integer(moment), level)), "CAPPI");
        FieldImpl retField = (FieldImpl)this.getCache(cacheKey);
        if (retField != null) {
            return retField;
        }
        RadialDatasetSweep.RadialVariable sweepVar = this.getRadialVariable(varName);
        int numberOfSweeps = sweepVar.getNumSweeps();
        int numberOfRay = this.getRayNumber(sweepVar);
        double levelInMeters = level.getValue(CommonUnit.meter);
        double range_step = 1.0;
        double range_to_first_gate = 0.0;
        int low_bins = 0;
        int low_rays = numberOfRay;
        int[] bin_LUT = new int[20];
        if (numberOfRay > 360) {
            low_rays = 360;
        }
        for (int t = 1; t < numberOfSweeps; ++t) {
            float vcpelev;
            int vcpbin;
            int bins = sweepVar.getSweep(t).getGateNumber();
            if (bins > low_bins) {
                low_bins = bins;
            }
            bin_LUT[t] = (vcpbin = this.calcRangeBin(vcpelev = (sweepVar.getSweep(numberOfSweeps - t).getMeanElevation() + sweepVar.getSweep(numberOfSweeps - t - 1).getMeanElevation()) / 2.0f, levelInMeters, range_step)) > low_bins ? low_bins : vcpbin;
        }
        bin_LUT[numberOfSweeps] = this.calcRangeBin(0.0, levelInMeters, range_step);
        if (bin_LUT[numberOfSweeps] > low_bins) {
            bin_LUT[numberOfSweeps] = low_bins;
        }
        int low_binss = 1000;
        int ringcounter = 0;
        int[][] shiftedIndex = new int[low_binss][low_rays];
        double[] cappiRadius = new double[low_binss];
        float[][] cappiAz = new float[low_binss][low_rays];
        float[][] cappiValue = new float[low_binss][low_rays];
        double[] ranges = new double[low_binss];
        ranges[0] = range_to_first_gate + range_step / 2.0;
        for (int i = 1; i < low_binss; ++i) {
            ranges[i] = ranges[i - 1] + range_step;
        }
        for (int ti = 0; ti < numberOfSweeps; ++ti) {
            RadialDatasetSweep.Sweep rds = sweepVar.getSweep(ti);
            int numberOfBins = rds.getGateNumber();
            if (numberOfBins == 0) continue;
            int bininner = bin_LUT[numberOfSweeps - ti - 1];
            int binouter = bin_LUT[numberOfSweeps - ti];
            int num_radials = rds.getRadialNumber();
            int bc = 0;
            float lastAzi = 0.0f;
            for (int ac = 0; ac < low_rays; ++ac) {
                float azimuth;
                float[] rayData = null;
                if (ac < num_radials) {
                    azimuth = rds.getAzimuth(ac);
                    rayData = rds.readData(ac);
                    lastAzi = azimuth;
                } else {
                    lastAzi = azimuth = lastAzi + 0.01f;
                }
                bc = 0;
                for (int binIndex = binouter - 1; binIndex >= bininner; --binIndex) {
                    int rc = ringcounter + bc;
                    if (ac == 0) {
                        cappiRadius[rc] = ranges[binIndex];
                    }
                    cappiAz[rc][ac] = azimuth;
                    cappiValue[rc][ac] = ac < num_radials ? rayData[binIndex] : Float.NaN;
                    ++bc;
                }
            }
            for (int bd = 0; bd < bc; ++bd) {
                shiftedIndex[ringcounter + bd] = QuickSort.sort(cappiAz[ringcounter + bd]);
            }
            ringcounter += bc;
        }
        float[][] domainVals = new float[2][ringcounter * low_rays];
        float[][] signalVals = new float[1][ringcounter * low_rays];
        int k = 0;
        for (int azi = 0; azi < low_rays; ++azi) {
            for (int ri = ringcounter - 1; ri >= 0; --ri) {
                domainVals[0][k] = (float)cappiRadius[ri];
                domainVals[1][k] = cappiAz[ri][azi];
                signalVals[0][k] = cappiValue[ri][shiftedIndex[ri][azi]];
                ++k;
            }
        }
        RealTupleType tt = this.radarDomain2d = this.makeDomainType2D();
        Gridded2DSet set = new Gridded2DSet(tt, domainVals, ringcounter, low_rays, tt.getCoordinateSystem(), new Unit[]{CommonUnit.meter.scale(1000.0), CommonUnit.degree}, null, false, true);
        Unit u = this.getUnit(sweepVar);
        FunctionType sweepType = new FunctionType(tt, this.getMomentType(varName, u));
        FlatField ff = new FlatField(sweepType, (Set)set, (CoordinateSystem)null, (Set[])null, new Unit[]{u});
        ff.setSamples(signalVals, false);
        FunctionType fiFunction = new FunctionType(RealType.Altitude, ff.getType());
        RealTuple altRT = new RealTuple(new Real[]{level});
        SingletonSet altSet = new SingletonSet(altRT);
        retField = new FieldImpl(fiFunction, altSet);
        retField.setSample(0, (Data)ff, false);
        this.putCache(cacheKey, retField);
        Trace.call2("   getCAPPI");
        return retField;
    }

    public FieldImpl getCAPPI(int moment, String varName, Real level) throws VisADException, RemoteException, IOException {
        int b;
        Trace.call1("   rsl_getCAPPI", level.longString());
        ObjectPair cacheKey = new ObjectPair(new ObjectPair(new ObjectPair(this.radarLocation, this.baseTime), new ObjectPair(new Integer(moment), level)), "CAPPI");
        FieldImpl retField = (FieldImpl)this.getCache(cacheKey);
        if (retField != null) {
            return retField;
        }
        RadialDatasetSweep.RadialVariable sweepVar = this.getRadialVariable(varName);
        Object[] cut = this.getCutIdx(sweepVar);
        int numSweep = cut.length;
        int swIdx = numSweep - 1;
        RadialDatasetSweep.Sweep sw0 = sweepVar.getSweep(swIdx);
        int numRay = 360;
        int numBin = this.getGateNumber(sweepVar);
        int numberOfRay = this.getRayNumber(sweepVar);
        float beamWidth = sw0.getBeamWidth();
        float gateSize = sw0.getGateSize();
        float range_step = sw0.getGateSize();
        float range_to_first_gate = sw0.getRangeToFirstGate();
        Trace.call1("   sweep list");
        if (this.RSL_sweep_list == null) {
            int b2;
            this.RSL_sweep_list = new CDMRadarSweepDB[numSweep];
            float[][] myAziArray = new float[numSweep][];
            int[][] aziArrayIdx = new int[numSweep][];
            for (b2 = 0; b2 < numSweep; ++b2) {
                int sb = Integer.parseInt(cut[b2].toString());
                RadialDatasetSweep.Sweep s1 = sweepVar.getSweep(sb);
                float[] tmpAz = this.format != null && this.format.toString().contains("AR2V") ? this.getAzimuth(s1) : s1.getAzimuth();
                myAziArray[b2] = (float[])tmpAz.clone();
                aziArrayIdx[b2] = QuickSort.sort(myAziArray[b2]);
                if (s1.getRadialNumber() >= numberOfRay) continue;
                numberOfRay = s1.getRadialNumber();
            }
            for (b2 = 0; b2 < numSweep; ++b2) {
                this.RSL_sweep_list[b2] = this.constructSweepHashTable(myAziArray[b2], aziArrayIdx[b2], beamWidth);
            }
        }
        Trace.call2("   sweep list");
        float[] az = new float[numRay];
        for (int i = 0; i < numRay; ++i) {
            az[i] = i;
        }
        int rayNum = this.getRayNumber(sweepVar);
        if (this.rayIndex == null) {
            this.rayIndex = this.getRayIndex(sweepVar, az, numRay);
        }
        if (this.rayData == null) {
            this.rayData = this.getRayData(sweepVar, numberOfRay, numBin);
            if (this.rayData == null) {
                return null;
            }
        }
        float[][] slantrElev = new float[numBin][2];
        float ht = (float)level.getValue() / 1000.0f;
        for (int a = 0; a < numBin; ++a) {
            float grange = (range_to_first_gate + (float)a * range_step) / 1000.0f;
            slantrElev[a] = this.getSlantrAndElev(grange, ht);
        }
        float[] cappiAz = new float[numRay];
        float[][] cappiValue = new float[numBin][numRay];
        double[] ranges = new double[numBin];
        int[] sweepI = new int[numBin];
        for (b = 0; b < numBin; ++b) {
            sweepI[b] = this.getClosestSweepIndex(slantrElev[b][1], beamWidth / 2.0f);
        }
        ranges[0] = range_to_first_gate + range_step / 2.0f;
        for (int i = 1; i < numBin; ++i) {
            ranges[i] = ranges[i - 1] + (double)range_step;
        }
        Trace.call1("   get cappi value");
        this.cutmap = new HashMap();
        for (b = 0; b < numSweep; ++b) {
            int sb = Integer.parseInt(cut[b].toString());
            this.cutmap.put(sb, b);
        }
        for (int a = 0; a < numRay; ++a) {
            float azi;
            cappiAz[a] = azi = az[a];
            for (int b3 = 0; b3 < numBin; ++b3) {
                int swIndex = sweepI[b3];
                if (swIndex == 999 || !this.cutmap.containsKey(swIndex)) {
                    cappiValue[b3][a] = Float.NaN;
                    continue;
                }
                int cutIdx = Integer.parseInt(this.cutmap.get(swIndex).toString());
                int rayIndx = this.rayIndex[cutIdx][a];
                if (rayIndx == 999 || rayIndx >= numberOfRay) {
                    cappiValue[b3][a] = Float.NaN;
                    continue;
                }
                float[] rdata = this.rayData[cutIdx][rayIndx];
                cappiValue[b3][a] = this.getValueFromRay(rdata, slantrElev[b3][0], gateSize, range_to_first_gate);
            }
        }
        Trace.call2("   get cappi value");
        float[][] domainVals = new float[2][numBin * numRay];
        float[][] signalVals = new float[1][numBin * numRay];
        int k = 0;
        for (int azi = 0; azi < numRay; ++azi) {
            for (int ri = 0; ri < numBin; ++ri) {
                domainVals[0][k] = (float)ranges[ri];
                domainVals[1][k] = cappiAz[azi];
                signalVals[0][k] = cappiValue[ri][azi];
                ++k;
            }
        }
        Trace.call1("   make field");
        RealTupleType tt = this.radarDomain2d = this.makeDomainType2D();
        Gridded2DSet set = new Gridded2DSet(tt, domainVals, numBin, numRay, tt.getCoordinateSystem(), new Unit[]{CommonUnit.meter.scale(1.0), CommonUnit.degree}, null, false, true);
        Unit u = this.getUnit(sweepVar);
        FunctionType sweepType = new FunctionType(tt, this.getMomentType(varName, u));
        FlatField ff = new FlatField(sweepType, (Set)set, (CoordinateSystem)null, (Set[])null, new Unit[]{u});
        ff.setSamples(signalVals, false);
        FunctionType fiFunction = new FunctionType(RealType.Altitude, ff.getType());
        double stationElev = this.radarLocation.getAltitude().getValue(level.getUnit());
        Real levelAboveStation = level.cloneButValue(stationElev + level.getValue());
        RealTuple altRT = new RealTuple(new Real[]{levelAboveStation});
        SingletonSet altSet = new SingletonSet(altRT);
        retField = new FieldImpl(fiFunction, altSet);
        retField.setSample(0, (Data)ff, false);
        this.putCache(cacheKey, retField);
        Trace.call2("   make field");
        Trace.call2("   rsl_getCAPPI");
        return retField;
    }

    float[][][] getRayData(RadialDatasetSweep.RadialVariable sweepVar, int numberOfRay, int numBin) throws IOException {
        Object[] cut = this.getCutIdx(sweepVar);
        int numberOfSweeps = cut.length;
        int[] rNum = new int[numberOfSweeps];
        float[] allData = null;
        try {
            allData = sweepVar.readAllData();
        }
        catch (Exception np) {
            LogUtil.consoleMessage("Radar read volume data error in file:\n" + this.swpFileName);
            return null;
        }
        float[][][] data2 = new float[numberOfSweeps][numberOfRay][numBin];
        for (int sweepIdx = 0; sweepIdx < numberOfSweeps; ++sweepIdx) {
            float[][] _data2 = data2[sweepIdx];
            int sb = Integer.parseInt(cut[sweepIdx].toString());
            RadialDatasetSweep.Sweep s1 = sweepVar.getSweep(sb);
            int rnumber = s1.getRadialNumber();
            for (int rayIdx = 0; rayIdx < numberOfRay; ++rayIdx) {
                float[] __data2 = _data2[rayIdx];
                if (rayIdx < rnumber) {
                    for (int gateIdx = 0; gateIdx < numBin; ++gateIdx) {
                        __data2[gateIdx] = allData[numBin * numberOfRay * sb + numBin * rayIdx + gateIdx];
                    }
                    continue;
                }
                _data2[rayIdx] = this.getFloatNaN(numBin);
            }
        }
        return data2;
    }

    int[][] getRayIndex(RadialDatasetSweep.RadialVariable sweepVar, float[] az, int numRay) {
        Object[] cut = this.getCutIdx(sweepVar);
        int numSweep = cut.length;
        int[][] rIndex = new int[numSweep][360];
        this.meanEle = new float[numSweep];
        for (int sIndex = 0; sIndex < numSweep; ++sIndex) {
            int swIndex = Integer.parseInt(cut[sIndex].toString());
            RadialDatasetSweep.Sweep s1 = sweepVar.getSweep(swIndex);
            this.meanEle[sIndex] = s1.getMeanElevation();
            CDMRadarSweepDB sweepTable = this.RSL_sweep_list[sIndex];
            float beamWidth = s1.getBeamWidth();
            for (int i = 0; i < 360; ++i) {
                int ii;
                float azi = az[i];
                CDMRadarSweepDB.Ray r = this.hashBin(sweepTable, azi, az.length, beamWidth);
                rIndex[sIndex][i] = ii = r.rayIndex;
            }
        }
        return rIndex;
    }

    int[][] getRayIndexOld(RadialDatasetSweep.RadialVariable sweepVar, float[] az, int numRay) {
        Object[] cut = this.getCutIdx(sweepVar);
        int numSweep = cut.length;
        int[][] rIndex = new int[numSweep][360];
        this.meanEle = new float[numSweep];
        for (int sIndex = 0; sIndex < numSweep; ++sIndex) {
            int swIndex = Integer.parseInt(cut[sIndex].toString());
            RadialDatasetSweep.Sweep s1 = sweepVar.getSweep(swIndex);
            this.meanEle[sIndex] = s1.getMeanElevation();
            float r = s1.getBeamWidth() / 2.0f;
            float[] azs = null;
            try {
                azs = this.format != null && this.format.toString().contains("AR2V") ? this.getAzimuth(s1) : s1.getAzimuth();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (int i = 0; i < 360; ++i) {
                int ii;
                float azi = az[i];
                rIndex[sIndex][i] = ii = this.getClosestRayFromSweep(azi, r, sIndex, azs);
            }
        }
        return rIndex;
    }

    float[] getSlantrAndElev(float gr, float h) {
        float[] sne = new float[2];
        if (gr == 0.0f) {
            sne[0] = h;
            sne[1] = 90.0f;
            return sne;
        }
        h = (float)((double)h + this.Re);
        double slant_r_2 = Math.pow(this.Re, 2.0) + Math.pow(h, 2.0) - 2.0 * this.Re * (double)h * Math.cos((double)gr / this.Re);
        double slantr = Math.sqrt(slant_r_2);
        double elev = Math.acos((Math.pow(this.Re, 2.0) + slant_r_2 - Math.pow(h, 2.0)) / (2.0 * this.Re * slantr));
        elev *= 180.0 / this.M_PI;
        sne[0] = (float)slantr;
        sne[1] = (float)(elev -= 90.0);
        return sne;
    }

    CDMRadarSweepDB.Ray hashBin(CDMRadarSweepDB table, float angle, int rayNum, float beamWidth) {
        int hashIndex;
        float res = 360.0f / (float)rayNum;
        if (beamWidth != 0.0f) {
            res = beamWidth;
        }
        if ((hashIndex = (int)((double)angle + (double)res / 2.0)) >= rayNum) {
            hashIndex -= rayNum;
        }
        CDMRadarSweepDB.Ray r = table.get(hashIndex);
        while (r == null) {
            if (++hashIndex >= rayNum) {
                hashIndex = 0;
            }
            r = table.get(hashIndex);
        }
        return r;
    }

    CDMRadarSweepDB constructSweepHashTable(float[] azi, int[] aziIdx, float b) {
        CDMRadarSweepDB sd = null;
        if (azi == null) {
            return null;
        }
        try {
            sd = new CDMRadarSweepDB(azi, aziIdx, b);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sd;
    }

    int getClosestSweepIndex(float sweep_angle, float limit) {
        float delta_angle = 91.0f;
        if (this.meanEle == null) {
            return -1;
        }
        int ci = 0;
        int numberOfSweeps = this.meanEle.length;
        for (int i = 0; i < numberOfSweeps; ++i) {
            float check_angle = (float)Math.abs((double)(this.meanEle[i] - sweep_angle));
            if (!(check_angle <= delta_angle)) continue;
            delta_angle = check_angle;
            ci = i;
        }
        float me = this.meanEle[ci];
        delta_angle = Math.abs(me - sweep_angle);
        if (delta_angle <= limit) {
            return ci;
        }
        return 999;
    }

    int getClosestRayFromSweep(float ray_angle, float limit, int tableIdx, float[] azimuths) {
        CDMRadarSweepDB sweepTable = this.RSL_sweep_list[tableIdx];
        float beamwidth = limit * 2.0f;
        CDMRadarSweepDB.Ray r = this.hashBin(sweepTable, ray_angle, azimuths.length, beamwidth);
        if (r == null) {
            return 999;
        }
        int rd = r.rayIndex;
        int closestRay = this.theClosestHash(azimuths, ray_angle, rd, limit);
        if (closestRay == 999) {
            return 999;
        }
        double close_diff = this.angleDiff(ray_angle, azimuths[closestRay]);
        if (close_diff <= (double)beamwidth) {
            return closestRay;
        }
        return 999;
    }

    double angleDiff(float x, float y) {
        double d = Math.abs((double)(x - y));
        if (d > 180.0) {
            d = 360.0 - d;
        }
        return d;
    }

    int theClosestHash(float[] azimuths, float ray_angle, int hindex, float limit) {
        int rNum = azimuths.length - 1;
        if (hindex >= rNum) {
            hindex -= rNum;
        }
        float low = azimuths[hindex];
        float high = azimuths[hindex + 1];
        float clow = this.cwiseAngleDiff(ray_angle, low);
        float chigh = this.cwiseAngleDiff(ray_angle, high);
        float cclow = this.ccwiseAngleDiff(ray_angle, low);
        if (clow == 0.0f) {
            return hindex;
        }
        if (Math.abs(clow) < limit) {
            return hindex;
        }
        if (Math.abs(chigh) < limit) {
            return hindex + 1;
        }
        int t = 999;
        while (chigh >= clow && clow != 0.0f) {
            t = hindex--;
            if (!(clow < cclow)) {
                ++hindex;
            }
            if (hindex >= rNum) {
                hindex -= rNum;
            }
            try {
                if (hindex < 0) {
                    hindex = rNum;
                    low = azimuths[hindex];
                    high = azimuths[0];
                } else {
                    low = azimuths[hindex];
                    high = azimuths[hindex + 1];
                }
            }
            catch (ArrayIndexOutOfBoundsException ee) {
                int a = hindex;
                ee.printStackTrace();
            }
            clow = this.cwiseAngleDiff(ray_angle, low);
            chigh = this.cwiseAngleDiff(ray_angle, high);
            cclow = this.ccwiseAngleDiff(ray_angle, low);
        }
        if (clow == 0.0f) {
            return hindex;
        }
        if (chigh <= cclow) {
            if (t == 0) {
                return 0;
            }
            return hindex + 1;
        }
        return hindex;
    }

    float cwiseAngleDiff(float x, float y) {
        float d = y - x;
        if (d < 0.0f) {
            d += 360.0f;
        }
        return d;
    }

    float ccwiseAngleDiff(float x, float y) {
        float d = x - y;
        if (d < 0.0f) {
            d += 360.0f;
        }
        return d;
    }

    float getValueFromRay(float[] rData, float r, float gate_size, float rangeToFirstGate) {
        float rm = r * 1000.0f;
        int nbins = rData.length;
        int bin_index = (int)((double)((rm - rangeToFirstGate) / gate_size) + 0.5);
        float[] data = new float[nbins];
        if (bin_index >= nbins || bin_index < 0) {
            return Float.NaN;
        }
        return rData[bin_index];
    }

    @Override
    public DataImpl getData(DataChoice dataChoice, DataSelection subset, Hashtable requestProperties) throws VisADException, RemoteException {
        Object choiceId = dataChoice.getId();
        Trace.call1("CDMRA:getData");
        if (!(choiceId instanceof ObjectArray)) {
            throw new IllegalStateException("Unknown choice data:" + choiceId.getClass().getName());
        }
        ObjectArray choiceAttrs = (ObjectArray)choiceId;
        String rn = choiceAttrs.getObject3().toString();
        String vn = Util.cleanTypeName(rn);
        if (requestProperties == null) {
            requestProperties = dataChoice.getProperties() != null ? dataChoice.getProperties() : new Hashtable();
        }
        Object momentObj = choiceAttrs.getObject1();
        int moment = Integer.parseInt(momentObj.toString());
        boolean volume = this.isRaster() ? false : (this.isRHI ? "Level2RadarDataSource.volume".equals(Misc.getProperty(requestProperties, "Level2RadarDataSource.azimuth", "Level2RadarDataSource.sweep")) : "Level2RadarDataSource.volume".equals(Misc.getProperty(requestProperties, "Level2RadarDataSource.volumeorsweep", "Level2RadarDataSource.volume")));
        boolean getAll3DData = "Level2RadarDataSource.3D".equals((String)choiceAttrs.getObject4());
        boolean in2D = "Level2RadarDataSource.2D".equals(Misc.getProperty(requestProperties, "Level2RadarDataSource.2Dor3D", "Level2RadarDataSource.2D"));
        FieldImpl fi = null;
        if (volume && getAll3DData) {
            if (requestProperties.containsKey("Level2RadarDataSource.cappilevel")) {
                Object o;
                Real level = null;
                if (subset != null && (o = subset.getFromLevel()) != null) {
                    Object newO = o;
                    if (o instanceof TwoFacedObject) {
                        newO = ((TwoFacedObject)o).getId();
                    }
                    if (newO instanceof Real) {
                        level = (Real)newO;
                    }
                }
                if (level == null) {
                    level = (Real)requestProperties.get("Level2RadarDataSource.cappilevel");
                }
                try {
                    fi = this.getCAPPI(moment, rn, level);
                }
                catch (IOException ex) {
                    LogUtil.logException("getCAPPI", ex);
                }
            } else if (requestProperties.containsKey("Level2RadarDataSource.verticalcrosssection")) {
                LatLonPoint latlonStart = (LatLonPoint)requestProperties.get("Level2RadarDataSource.verticalcrosssectionstart");
                LatLonPoint latlonEnd = (LatLonPoint)requestProperties.get("Level2RadarDataSource.verticalcrosssectionend");
                try {
                    fi = this.getRadarCrossSection(moment, rn, latlonStart, latlonEnd);
                }
                catch (IOException ex) {
                    LogUtil.logException("getRHI", ex);
                }
            } else if (requestProperties.containsKey("Level2RadarDataSource.azimuth")) {
                float rhiAzimuth = ((Float)requestProperties.get("Level2RadarDataSource.azimuth")).floatValue();
                try {
                    fi = this.getRHI(moment, rn, rhiAzimuth);
                }
                catch (IOException ex) {
                    LogUtil.logException("getRHI", ex);
                }
            } else {
                try {
                    fi = this.getVolume(moment, rn);
                }
                catch (IOException ex) {
                    LogUtil.logException("getVolume", ex);
                }
            }
        } else if (this.isRHI()) {
            try {
                Object o;
                double value = Double.NaN;
                Double fromProperties = (Double)requestProperties.get("Level2RadarDataSource.azimuth");
                if (fromProperties != null) {
                    value = fromProperties;
                }
                if (Double.isNaN(value) && subset != null && (o = subset.getFromLevel()) != null) {
                    Object newO = o;
                    if (o instanceof TwoFacedObject) {
                        newO = ((TwoFacedObject)o).getId();
                    }
                    if (newO instanceof Real) {
                        value = ((Real)newO).getValue();
                    }
                }
                if (Double.isNaN(value)) {
                    fromProperties = (Double)requestProperties.get("Level2RadarDataSource.azimuth");
                    if (choiceAttrs.getObject2() instanceof Double) {
                        value = (Double)choiceAttrs.getObject2();
                    }
                    if (value == -1.0) {
                        value = (Double)choiceAttrs.getObject2();
                    }
                }
                if (Double.isNaN(value)) {
                    List levelsList1 = dataChoice.getAllLevels();
                    String azim = levelsList1.get(0).toString();
                    value = Float.parseFloat(azim);
                }
                if (Double.isNaN(value)) {
                    throw new IllegalArgumentException("No angle specified");
                }
                Object s = dataChoice.getProperty("Level2RadarDataSource.azimuth");
                int sIndex = 0;
                if (s == null) {
                    if (this.anglesMap.get(vn) == null) {
                        return null;
                    }
                    sIndex = this.getAngleIdx((double[])this.anglesMap.get(vn), value);
                } else {
                    sIndex = (int)new Double(s.toString()).doubleValue();
                }
                fi = this.getRHISweep(moment, value, rn, sIndex, true);
            }
            catch (IOException ex) {
                LogUtil.logException("getRhiSweep", ex);
            }
        } else if (this.isRaster()) {
            try {
                fi = this.getRaster(moment, vn);
            }
            catch (IOException ex) {
                LogUtil.logException("getRaster", ex);
            }
            catch (InvalidRangeException ed) {
                LogUtil.logException("getRaster", ed);
            }
        } else {
            try {
                Object o;
                double value = Double.NaN;
                if (subset != null && (o = subset.getFromLevel()) != null) {
                    Object newO = o;
                    if (o instanceof TwoFacedObject) {
                        newO = ((TwoFacedObject)o).getId();
                    }
                    if (newO instanceof Real) {
                        value = ((Real)newO).getValue();
                    }
                }
                if (Double.isNaN(value)) {
                    Double fromProperties = (Double)requestProperties.get("Level2RadarDataSource.angle");
                    if (fromProperties != null) {
                        value = fromProperties;
                    } else if (choiceAttrs.getObject2() instanceof Double) {
                        value = (Double)choiceAttrs.getObject2();
                    }
                }
                if (Double.isNaN(value)) {
                    throw new IllegalArgumentException("No angle specified");
                }
                Object s = dataChoice.getProperty("Level2RadarDataSource.angle");
                int sIndex = 0;
                if (s == null) {
                    if (this.anglesMap.get(vn) == null) {
                        return null;
                    }
                    sIndex = this.getAngleIdx((double[])this.anglesMap.get(vn), value);
                } else {
                    sIndex = (int)new Double(s.toString()).doubleValue();
                }
                fi = this.getSweep(moment, value, rn, sIndex, !in2D);
            }
            catch (IOException ex) {
                LogUtil.logException("getSweep", ex);
            }
        }
        Trace.call2("CDMRA:getData");
        return fi;
    }

    int getAngleIdx(double[] angles, double angle) {
        int size = angles.length;
        for (int i = 0; i < size; ++i) {
            if (angle != angles[i]) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void clearCachedData() {
        if (this.rds != null) {
            this.rds.clearDatasetMemory();
        }
    }

    private RealTupleType getMomentType(String vname, Unit u) throws VisADException {
        return new RealTupleType(DataUtil.makeRealType(vname, u));
    }

    @Override
    public String getName() {
        return this.toString();
    }

    protected RealType[] getParams() {
        return this.paramTypes;
    }

    public FieldImpl getRHIOld(int moment, String varName, double rhiAz) throws VisADException, RemoteException, IOException {
        Trace.call1("   getRHI");
        Trace.call1("   getRHI.setup");
        RadialDatasetSweep.RadialVariable sweepVar = this.getRadialVariable(varName);
        int numberOfSweeps = sweepVar.getNumSweeps();
        int numberOfRay = this.getRayNumber(sweepVar);
        int value_counter = 0;
        double halfBeamWidth = 0.475;
        float[] elevations = new float[numberOfSweeps];
        int[] tiltindices = new int[numberOfSweeps];
        int bincounter = 1000;
        if (moment == 0) {
            bincounter = 500;
        }
        Trace.call2("   getRHI.setup");
        float[][] values = new float[numberOfSweeps][bincounter];
        double[][] ranges = new double[numberOfSweeps][bincounter];
        int tiltcounter = 0;
        Trace.call1("   getRHI.getdata");
        float[] azimuths = new float[numberOfRay];
        for (int ti = 0; ti < numberOfSweeps; ++ti) {
            int bi;
            int j;
            RadialDatasetSweep.Sweep sp = sweepVar.getSweep(ti);
            int num_radials = sp.getRadialNumber();
            float lastAzi = 0.0f;
            Trace.call1("getting array of azimuths");
            float[] _azimuths = sp.getAzimuth();
            float[] _elevations = sp.getElevation();
            float meanElevation = sp.getMeanElevation();
            for (j = 0; j < numberOfRay; ++j) {
                if (j < num_radials) {
                    azimuths[j] = _azimuths[j];
                    lastAzi = azimuths[j];
                    continue;
                }
                azimuths[j] = lastAzi + 0.01f;
                lastAzi = azimuths[j];
            }
            Trace.call2("getting array of azimuths");
            Trace.call1("findClosestRay");
            j = this.findClosestRay((float)rhiAz, azimuths);
            Trace.call2("findClosestRay");
            if (j == -1) continue;
            double range_to_first_gate = (double)sp.getRangeToFirstGate() / 1000.0;
            double range_step = (double)sp.getGateSize() / 1000.0;
            int number_of_bins = sp.getGateNumber();
            if (number_of_bins == 0) continue;
            float el = j < num_radials ? _elevations[j] : meanElevation;
            if (el == 0.0f) break;
            elevations[ti] = el;
            for (int z = 0; z < ti && elevations[z] != el; ++z) {
            }
            ranges[ti][0] = range_to_first_gate + range_step / 2.0;
            float[] data = new float[number_of_bins];
            if (j < num_radials) {
                data = sp.readData(j);
            } else {
                for (int i = 1; i < number_of_bins; ++i) {
                    data[i] = Float.NaN;
                }
            }
            System.arraycopy(data, 0, values[ti], 0, number_of_bins);
            ++value_counter;
            for (bi = 1; bi < number_of_bins; ++bi) {
                ranges[ti][bi] = ranges[ti][bi - 1] + range_step;
                ++value_counter;
            }
            if (number_of_bins < bincounter) {
                for (bi = number_of_bins; bi < bincounter; ++bi) {
                    values[ti][bi] = Float.NaN;
                    ranges[ti][bi] = ranges[ti][bi - 1] + range_step;
                    ++value_counter;
                }
            }
            tiltindices[tiltcounter] = ti;
            ++tiltcounter;
        }
        Trace.call2("   getRHI.getdata");
        if (value_counter < 1) {
            return null;
        }
        Trace.call1("   getRHI.makeField");
        FieldImpl fi = null;
        for (int tc = 0; tc < tiltcounter; ++tc) {
            float[][] domainVals = new float[3][bincounter * 2];
            float[][] signalVals = new float[1][bincounter * 2];
            int ti = tiltindices[tc];
            float lowerElev = elevations[ti] - (float)halfBeamWidth;
            for (int bi = 0; bi < bincounter; ++bi) {
                domainVals[0][bi] = (float)ranges[ti][bi];
                domainVals[1][bi] = (float)rhiAz;
                domainVals[2][bi] = lowerElev;
                signalVals[0][bi] = values[ti][bi];
            }
            float upperElev = elevations[ti] + (float)halfBeamWidth;
            for (int bi = 0; bi < bincounter; ++bi) {
                domainVals[0][bi + bincounter] = (float)ranges[ti][bi];
                domainVals[1][bi + bincounter] = (float)rhiAz;
                domainVals[2][bi + bincounter] = upperElev;
                signalVals[0][bi + bincounter] = values[ti][bi];
            }
            Unit u = this.getUnit(sweepVar);
            RealTupleType radarDomainType = this.makeDomainType3D();
            Gridded3DSet domainSet = new Gridded3DSet((MathType)radarDomainType, domainVals, bincounter, 2, radarDomainType.getCoordinateSystem(), new Unit[]{CommonUnit.meter.scale(1000.0), CommonUnit.degree, CommonUnit.degree}, null, false);
            FunctionType functionType = new FunctionType(radarDomainType, this.getMomentType(varName, u));
            FlatField retField = new FlatField(functionType, (Set)domainSet, (CoordinateSystem)null, (Set[])null, new Unit[]{u});
            retField.setSamples(signalVals, false);
            if (tc == 0) {
                RealType indexType = RealType.getRealType("integer_index");
                FunctionType fiFunction = new FunctionType(indexType, retField.getType());
                Integer1DSet intSet = new Integer1DSet(tiltcounter);
                fi = new FieldImpl(fiFunction, intSet);
                fi.setSample(0, retField, false, true);
                continue;
            }
            fi.setSample(tc, retField, false, false);
        }
        Trace.call2("   getRHI.makeField");
        Trace.call2("   getRHI");
        return fi;
    }

    public FieldImpl getRadarCrossSection(int moment, String varName, LatLonPoint p1, LatLonPoint p2) throws VisADException, IOException {
        int bincounter;
        int b;
        Trace.call1("   getRadarCrossSection");
        Trace.call1("   getRadarCrossSection.setup");
        RadialDatasetSweep.RadialVariable sweepVar = this.getRadialVariable(varName);
        Object[] cut = this.getCutIdx(sweepVar);
        int numberOfSweeps = cut.length;
        int numberOfRay = this.getRayNumber(sweepVar);
        int numberOfBin = this.getGateNumber(sweepVar);
        float beamWidth = sweepVar.getSweep(0).getBeamWidth();
        float[][] myAziArray = new float[numberOfSweeps][];
        int[][] aziArrayIdx = new int[numberOfSweeps][];
        for (b = 0; b < numberOfSweeps; ++b) {
            int sb = Integer.parseInt(cut[b].toString());
            RadialDatasetSweep.Sweep s1 = sweepVar.getSweep(sb);
            float[] tmpA = this.format != null && this.format.toString().contains("AR2V") ? this.getAzimuth(s1) : s1.getAzimuth();
            myAziArray[b] = (float[])tmpA.clone();
            aziArrayIdx[b] = QuickSort.sort(myAziArray[b]);
            if (s1.getRadialNumber() >= numberOfRay) continue;
            numberOfRay = s1.getRadialNumber();
        }
        if (p1 == null || p2 == null) {
            p1 = this.setCrossSectionLinePosition(180.0f);
            p2 = this.setCrossSectionLinePosition(0.0f);
        }
        if (this.RSL_sweep_list == null) {
            this.RSL_sweep_list = new CDMRadarSweepDB[numberOfSweeps];
            for (b = 0; b < numberOfSweeps; ++b) {
                this.RSL_sweep_list[b] = this.constructSweepHashTable(myAziArray[b], aziArrayIdx[b], beamWidth);
            }
        }
        RadialDatasetSweep.Sweep s0 = sweepVar.getSweep(numberOfSweeps - 1);
        this.range_to_first_gate = (double)s0.getRangeToFirstGate() / 1000.0;
        this.range_step = (double)s0.getGateSize() / 1000.0;
        beamWidth = s0.getBeamWidth();
        double halfBeamWidth = beamWidth / 2.0f;
        float[] elevations = new float[numberOfSweeps];
        int[] tiltindices = new int[numberOfSweeps];
        float lat3 = (float)p1.getLatitude().getValue();
        float lon3 = (float)p1.getLongitude().getValue();
        float lat4 = (float)p2.getLatitude().getValue();
        float lon4 = (float)p2.getLongitude().getValue();
        Bearing b1 = this.getBearing(lat3, lon3);
        Bearing b2 = this.getBearing(lat4, lon4);
        double azimuth1 = b1.getAngle();
        double azimuth2 = b2.getAngle();
        double deltaAzi = Math.abs(azimuth1 - azimuth2);
        boolean cs = false;
        if (deltaAzi <= 181.0 && deltaAzi >= 179.0) {
            float dis = (float)(b1.getDistance() + b2.getDistance());
            bincounter = (int)Math.round((double)dis / this.range_step) + 1;
        } else if (deltaAzi >= 0.0 && deltaAzi <= 5.0) {
            bincounter = (int)((double)Math.round(Math.abs(b1.getDistance() - b2.getDistance())) / this.range_step);
        } else {
            bincounter = (int)Math.round(deltaAzi);
            if (bincounter > 180) {
                bincounter = 360 - bincounter;
                cs = true;
            }
            if (numberOfRay > 361) {
                bincounter = (int)((float)bincounter * ((float)numberOfRay / 360.0f));
            }
        }
        Trace.call2("   getRadarCrossSection.setup");
        double[][] ranges = new double[numberOfSweeps][bincounter];
        int tiltcounter = 0;
        int[] ray0Idx = new int[numberOfSweeps];
        int[] ray1Idx = new int[numberOfSweeps];
        float[] gateSize = new float[numberOfSweeps];
        this.meanEle = new float[numberOfSweeps];
        for (int b3 = 0; b3 < numberOfSweeps; ++b3) {
            int sb = Integer.parseInt(cut[b3].toString());
            RadialDatasetSweep.Sweep s1 = sweepVar.getSweep(sb);
            this.meanEle[b3] = s1.getMeanElevation();
            gateSize[b3] = s1.getGateSize() / 1000.0f;
            ray0Idx[b3] = this.getClosestRayFromSweep((float)azimuth1, (float)halfBeamWidth, b3, myAziArray[b3]);
            ray1Idx[b3] = this.getClosestRayFromSweep((float)azimuth2, (float)halfBeamWidth, b3, myAziArray[b3]);
        }
        Trace.call1("   getRadarCrossSection.getdata");
        if (this.rayData == null) {
            this.rayData = this.getRayData(sweepVar, numberOfRay, numberOfBin);
            if (this.rayData == null) {
                return null;
            }
        }
        float[][] rdata = new float[numberOfSweeps][bincounter];
        float[][] rAzimuth = new float[numberOfSweeps][bincounter];
        for (int ti = 0; ti < numberOfSweeps; ++ti) {
            float rd;
            int ray0;
            float meanElevation;
            elevations[ti] = meanElevation = this.meanEle[ti];
            if (deltaAzi <= 181.0 && deltaAzi >= 179.0) {
                int ri;
                if (ray0Idx[ti] == 999 || ray1Idx[ti] == 999) continue;
                ray0 = aziArrayIdx[ti][ray0Idx[ti]];
                int ray1 = aziArrayIdx[ti][ray1Idx[ti]];
                int bincounter2 = (int)((b2.getDistance() / Math.cos(Math.PI * (double)meanElevation / 180.0) - this.range_to_first_gate) / this.range_step + 1.0);
                int gateIdx = (int)((b2.getDistance() / Math.cos(Math.PI * (double)meanElevation / 180.0) - this.range_to_first_gate) / this.range_step);
                for (ri = 0; ri < bincounter2; ++ri) {
                    rAzimuth[ti][ri] = (float)azimuth1;
                    ranges[ti][ri] = this.range_to_first_gate + (double)gateIdx * this.range_step;
                    rdata[ti][ri] = gateIdx >= numberOfBin || gateIdx < 0 ? Float.NaN : this.rayData[ti][ray0][gateIdx];
                    --gateIdx;
                }
                gateIdx = 0;
                for (ri = bincounter2; ri < bincounter; ++ri) {
                    rAzimuth[ti][ri] = (float)azimuth2;
                    ranges[ti][ri] = this.range_to_first_gate + (double)gateIdx * this.range_step;
                    rdata[ti][ri] = gateIdx >= numberOfBin ? Float.NaN : this.rayData[ti][ray1][gateIdx];
                    ++gateIdx;
                }
            } else if (deltaAzi >= 0.0 && deltaAzi <= 5.0) {
                ray0 = aziArrayIdx[ti][ray0Idx[ti]];
                int rn = (int)deltaAzi;
                int ray = ray0;
                float dist = (float)b1.getDistance();
                float azi = (float)azimuth1;
                boolean incsign = true;
                if (b1.getDistance() > b2.getDistance()) {
                    incsign = false;
                }
                if (ray == 999) continue;
                int gateIdx = (int)(((double)dist / Math.cos(Math.PI * (double)meanElevation / 180.0) - this.range_to_first_gate) / this.range_step);
                for (int ri = 0; ri < bincounter; ++ri) {
                    rd = 0.0f;
                    int cnt = 0;
                    for (int rj = 0; rj < rn; ++rj) {
                        if (gateIdx >= numberOfBin || gateIdx <= 0) continue;
                        int rk = ray + rj;
                        if (rk >= 360) {
                            rk -= 360;
                        }
                        rd += this.rayData[ti][rk][gateIdx];
                        ++cnt;
                    }
                    rAzimuth[ti][ri] = azi;
                    ranges[ti][ri] = this.range_to_first_gate + (double)gateIdx * this.range_step;
                    rdata[ti][ri] = Float.isNaN(rd) ? Float.NaN : rd / (float)cnt;
                    if (incsign) {
                        ++gateIdx;
                        continue;
                    }
                    --gateIdx;
                }
            } else {
                boolean incsign = true;
                ray0 = ray0Idx[ti];
                if (ray0 == 999) continue;
                if (azimuth1 > azimuth2) {
                    incsign = false;
                }
                for (int ri = 0; ri < bincounter; ++ri) {
                    float azi;
                    float[] inst;
                    Bearing b4;
                    int gateIdx;
                    int rr;
                    if (cs && incsign) {
                        rr = ray0 - ri;
                        if (rr < 0) {
                            rr = numberOfRay + rr;
                        }
                    } else if (cs) {
                        rr = ray0 + ri;
                        if (rr >= numberOfRay) {
                            rr -= numberOfRay;
                        }
                    } else if (!incsign) {
                        rr = ray0 - ri;
                        if (rr < 0) {
                            rr = numberOfRay + rr;
                        }
                    } else {
                        rr = ray0 + ri;
                        if (rr >= numberOfRay) {
                            rr -= numberOfRay;
                        }
                    }
                    if ((gateIdx = (int)(((b4 = this.getBearing((inst = this.getIntersectionOfRayAndLine(this.radarLocation, azi = myAziArray[ti][rr], lat3, lon3, lat4, lon4))[0], inst[1])).getDistance() / Math.cos(Math.PI * (double)meanElevation / 180.0) - this.range_to_first_gate) / this.range_step)) < 0) {
                        gateIdx = 0;
                    }
                    rAzimuth[ti][ri] = azi;
                    ranges[ti][ri] = b4.getDistance();
                    rdata[ti][ri] = gateIdx >= numberOfBin ? Float.NaN : (aziArrayIdx[ti][rr] >= this.rayData[ti].length ? Float.NaN : (rd = this.rayData[ti][aziArrayIdx[ti][rr]][gateIdx]));
                }
            }
            tiltindices[tiltcounter] = ti;
            ++tiltcounter;
        }
        Trace.call2("   getRadarCrossSection.getdata");
        Trace.call1("   getRadarCrossSection.makeField");
        float[][] domainVals = new float[3][bincounter * numberOfSweeps];
        float[][] signalVals = new float[1][bincounter * numberOfSweeps];
        int l = 0;
        for (int tc = 0; tc < numberOfSweeps; ++tc) {
            int ti = tiltindices[tc];
            for (int bi = 0; bi < bincounter; ++bi) {
                domainVals[0][l] = (float)ranges[ti][bi];
                domainVals[1][l] = rAzimuth[ti][bi];
                domainVals[2][l] = elevations[ti];
                signalVals[0][l++] = rdata[ti][bi];
            }
        }
        Unit u = this.getUnit(sweepVar);
        RealTupleType radarDomainType = this.makeDomainType3D();
        Gridded3DSet domainSet = new Gridded3DSet((MathType)radarDomainType, domainVals, bincounter, numberOfSweeps, radarDomainType.getCoordinateSystem(), new Unit[]{CommonUnit.meter.scale(1000.0), CommonUnit.degree, CommonUnit.degree}, null, false);
        FunctionType functionType = new FunctionType(radarDomainType, this.getMomentType(varName, u));
        FlatField retField = new FlatField(functionType, (Set)domainSet, (CoordinateSystem)null, (Set[])null, new Unit[]{u});
        retField.setSamples(signalVals, false);
        return retField;
    }

    public Bearing getBearing(double lat, double lon) {
        Bearing b1 = Bearing.calculateBearing(this.radarLocation.getLatitude().getValue(), this.radarLocation.getLongitude().getValue(), lat, lon, null);
        return b1;
    }

    public LatLonPoint setCrossSectionLinePosition(float azi) throws VisADException, RemoteException {
        float stationLat = (float)this.radarLocation.getLatitude().getValue();
        float stationLon = (float)this.radarLocation.getLongitude().getValue();
        LatLonPointImpl lp1 = Bearing.findPoint(stationLat, (double)stationLon, (double)azi, 150.0, null);
        return new EarthLocationTuple(lp1.getLatitude(), lp1.getLongitude(), 0.0);
    }

    public float[] getIntersectionOfRayAndLine(EarthLocation radarCenter, float azi, float lat3, float lon3, float lat4, float lon4) {
        float lat1 = (float)radarCenter.getLatitude().getValue();
        float lon1 = (float)radarCenter.getLongitude().getValue();
        LatLonPointImpl lp = Bearing.findPoint(lat1, (double)lon1, (double)azi, 1000.0, null);
        float lat2 = (float)lp.getLatitude();
        float lon2 = (float)lp.getLongitude();
        return this.getIntersectionOfTwoLines(lat1, lon1, lat2, lon2, lat3, lon3, lat4, lon4);
    }

    public float[] getIntersectionOfTwoLines(float lat1, float lon1, float lat2, float lon2, float lat3, float lon3, float lat4, float lon4) {
        float a = (lat2 - lat1) / (lon2 - lon1);
        float b = -1.0f * a * lon1 + lat1;
        float c = (lat4 - lat3) / (lon4 - lon3);
        float d = -1.0f * c * lon3 + lat3;
        float lon0 = (d - b) / (a - c);
        float lat0 = a * lon0 + b;
        float[] out = new float[]{lat0, lon0};
        return out;
    }

    public FieldImpl getRHI(int moment, String varName, double rhiAz) throws VisADException, RemoteException, IOException {
        int iazim;
        float beamWidth;
        float res;
        if (rhiAz > 359.5) {
            rhiAz = 0.0;
        }
        Trace.call1("   getRHI");
        Trace.call1("   getRHI.setup");
        RadialDatasetSweep.RadialVariable sweepVar = this.getRadialVariable(varName);
        Object[] cut = this.getCutIdx(sweepVar);
        int numberOfSweeps = cut.length;
        int numberOfRay = 360;
        int value_counter = 0;
        double halfBeamWidth = 0.475;
        float[] elevations = new float[numberOfSweeps];
        int[] tiltindices = new int[numberOfSweeps];
        int bincounter = 1200;
        int gateNumber0 = this.getGateNumber(sweepVar);
        Unit u0 = this.getUnit(sweepVar);
        if (moment == 0 || u0.isConvertible(DataUtil.parseUnit("dBZ"))) {
            bincounter = gateNumber0 > 500 ? gateNumber0 : 500;
        }
        Trace.call2("   getRHI.setup");
        float[][] values = new float[numberOfSweeps][bincounter];
        double[][] ranges = new double[numberOfSweeps][bincounter];
        int tiltcounter = 0;
        if (this.RSL_sweep_list == null) {
            int b;
            this.RSL_sweep_list = new CDMRadarSweepDB[numberOfSweeps];
            float[][] myAziArray = new float[numberOfSweeps][];
            int[][] aziArrayIdx = new int[numberOfSweeps][];
            for (b = 0; b < numberOfSweeps; ++b) {
                int sb = Integer.parseInt(cut[b].toString());
                RadialDatasetSweep.Sweep s1 = sweepVar.getSweep(sb);
                float[] tmpA = this.format != null && this.format.toString().contains("AR2V") ? this.getAzimuth(s1) : s1.getAzimuth();
                myAziArray[b] = (float[])tmpA.clone();
                aziArrayIdx[b] = QuickSort.sort(myAziArray[b]);
            }
            for (b = 0; b < numberOfSweeps; ++b) {
                this.RSL_sweep_list[b] = this.constructSweepHashTable(myAziArray[b], aziArrayIdx[b], 0.95f);
            }
        }
        Trace.call1("   getRHI.getdata");
        float[] az = new float[numberOfRay];
        for (int i = 0; i < numberOfRay; ++i) {
            az[i] = i;
        }
        if (this.rayIndex == null) {
            this.rayIndex = this.getRayIndex(sweepVar, az, numberOfRay);
        }
        if (this.rhiData == null) {
            this.getRHIData(sweepVar);
            if (this.rhiData == null) {
                return null;
            }
        } else if (this.rhiData.get(sweepVar.getName()) == null) {
            this.getRHIData(sweepVar);
        }
        if ((res = 360.0f / (float)numberOfRay) > 2.0f * (beamWidth = 0.95f) && beamWidth != 0.0f) {
            res = beamWidth;
        }
        if ((iazim = (int)(rhiAz + (double)res / 2.0)) > 359) {
            iazim = 0;
        }
        float[][] rdata = (float[][])this.rhiData.get(Integer.toString(iazim));
        for (int ti = 0; ti < numberOfSweeps; ++ti) {
            int bi;
            float meanElevation = this.meanEle[ti];
            if (this.number_of_bins == 0) continue;
            float el = meanElevation;
            if (el == 0.0f) break;
            elevations[ti] = el;
            ranges[ti][0] = this.range_to_first_gate + this.range_step / 2.0;
            if (this.number_of_bins < bincounter) {
                System.arraycopy(rdata[ti], 0, values[ti], 0, this.number_of_bins);
            } else {
                System.arraycopy(rdata[ti], 0, values[ti], 0, bincounter);
            }
            ++value_counter;
            for (bi = 1; bi < this.number_of_bins; ++bi) {
                ranges[ti][bi] = ranges[ti][bi - 1] + this.range_step;
                ++value_counter;
            }
            if (this.number_of_bins < bincounter) {
                for (bi = this.number_of_bins; bi < bincounter; ++bi) {
                    values[ti][bi] = Float.NaN;
                    ranges[ti][bi] = ranges[ti][bi - 1] + this.range_step;
                    ++value_counter;
                }
            }
            tiltindices[tiltcounter] = ti;
            ++tiltcounter;
        }
        Trace.call2("   getRHI.getdata");
        if (value_counter < 1) {
            return null;
        }
        Trace.call1("   getRHI.makeField");
        FieldImpl fi = null;
        for (int tc = 0; tc < tiltcounter; ++tc) {
            float[][] domainVals = new float[3][bincounter * 2];
            float[][] signalVals = new float[1][bincounter * 2];
            int ti = tiltindices[tc];
            float lowerElev = elevations[ti] - (float)halfBeamWidth;
            for (int bi = 0; bi < bincounter; ++bi) {
                domainVals[0][bi] = (float)ranges[ti][bi];
                domainVals[1][bi] = (float)rhiAz;
                domainVals[2][bi] = lowerElev;
                signalVals[0][bi] = values[ti][bi];
            }
            float upperElev = elevations[ti] + (float)halfBeamWidth;
            for (int bi = 0; bi < bincounter; ++bi) {
                domainVals[0][bi + bincounter] = (float)ranges[ti][bi];
                domainVals[1][bi + bincounter] = (float)rhiAz;
                domainVals[2][bi + bincounter] = upperElev;
                signalVals[0][bi + bincounter] = values[ti][bi];
            }
            Unit u = this.getUnit(sweepVar);
            RealTupleType radarDomainType = this.makeDomainType3D();
            Gridded3DSet domainSet = new Gridded3DSet((MathType)radarDomainType, domainVals, bincounter, 2, radarDomainType.getCoordinateSystem(), new Unit[]{CommonUnit.meter.scale(1000.0), CommonUnit.degree, CommonUnit.degree}, null, false);
            FunctionType functionType = new FunctionType(radarDomainType, this.getMomentType(varName, u));
            FlatField retField = new FlatField(functionType, (Set)domainSet, (CoordinateSystem)null, (Set[])null, new Unit[]{u});
            retField.setSamples(signalVals, false);
            if (tc == 0) {
                RealType indexType = RealType.getRealType("integer_index");
                FunctionType fiFunction = new FunctionType(indexType, retField.getType());
                Integer1DSet intSet = new Integer1DSet(tiltcounter);
                fi = new FieldImpl(fiFunction, intSet);
                fi.setSample(0, retField, false, true);
                continue;
            }
            fi.setSample(tc, retField, false, false);
        }
        Trace.call2("   getRHI.makeField");
        Trace.call2("   getRHI");
        return fi;
    }

    private void getRHIData(RadialDatasetSweep.RadialVariable sweepVar) throws IOException {
        Object[] cut = this.getCutIdx(sweepVar);
        int numberOfSweeps = cut.length;
        int numberOfRay = this.getRayNumber(sweepVar);
        float[] azimuths = new float[numberOfRay];
        int numberOfBin = this.getGateNumber(sweepVar);
        this.rhiData = new HashMap();
        this.rhiData.put(sweepVar.getName(), sweepVar);
        RadialDatasetSweep.Sweep[] sweep = new RadialDatasetSweep.Sweep[numberOfSweeps];
        float[][] aziAll = new float[numberOfSweeps][numberOfRay];
        int[] radialNumber = new int[numberOfSweeps];
        int[] gateNumber = new int[numberOfSweeps];
        float[] beamWidth = new float[numberOfSweeps];
        RadialDatasetSweep.Sweep s0 = sweepVar.getSweep(numberOfSweeps - 1);
        this.range_to_first_gate = (double)s0.getRangeToFirstGate() / 1000.0;
        this.range_step = (double)s0.getGateSize() / 1000.0;
        this.number_of_bins = this.getGateNumber(sweepVar);
        for (int i = 0; i < numberOfSweeps; ++i) {
            RadialDatasetSweep.Sweep sp;
            int sb = Integer.parseInt(cut[i].toString());
            sweep[i] = sp = sweepVar.getSweep(sb);
            aziAll[i] = sp.getAzimuth();
            if (sp.getRadialNumber() < numberOfRay) {
                numberOfRay = sp.getRadialNumber();
            }
            radialNumber[i] = numberOfRay;
            gateNumber[i] = numberOfBin;
            beamWidth[i] = sp.getBeamWidth();
        }
        this.rayData = this.getRayData(sweepVar, numberOfRay, numberOfBin);
        if (this.rayData == null) {
            this.rhiData = null;
            return;
        }
        for (int r = 0; r < 360; ++r) {
            float rhiAz = r;
            float[][] gdata = new float[numberOfSweeps][];
            for (int ti = 0; ti < numberOfSweeps; ++ti) {
                int number_of_bins = gateNumber[ti];
                gdata[ti] = new float[number_of_bins];
                int j = this.rayIndex[ti][r];
                if (j == -1) continue;
                if (j < numberOfRay) {
                    gdata[ti] = this.rayData[ti][j];
                    continue;
                }
                for (int i = 1; i < number_of_bins; ++i) {
                    gdata[ti][i] = Float.NaN;
                }
            }
            this.rhiData.put(Integer.toString(r), gdata);
        }
    }

    private int findClosestRay(float azi, float[] azimuths) {
        float minDist = Float.MAX_VALUE;
        int ray = -1;
        for (int i = 0; i < azimuths.length; ++i) {
            float dist = Math.abs(azi - azimuths[i]);
            if (azi == 0.0f) {
                dist = Math.min(dist, Math.abs(360.0f - azimuths[i]));
            }
            if (!(dist < minDist)) continue;
            minDist = dist;
            ray = i;
        }
        return ray;
    }

    private int getRayNumber(RadialDatasetSweep.RadialVariable sweepVar) {
        int numSweep = sweepVar.getNumSweeps();
        int numRay = sweepVar.getSweep(0).getRadialNumber();
        if (numSweep == 1) {
            return numRay;
        }
        for (int i = 0; i < numSweep; ++i) {
            int num = sweepVar.getSweep(i).getRadialNumber();
            if (num >= numRay) continue;
            numRay = num;
        }
        if (numRay == 720) {
            numRay /= 2;
        }
        return numRay;
    }

    private int getGateNumber(RadialDatasetSweep.RadialVariable sweepVar) {
        int numSweep = sweepVar.getNumSweeps();
        int numGate = sweepVar.getSweep(0).getGateNumber();
        for (int i = 0; i < numSweep; ++i) {
            int num = sweepVar.getSweep(i).getGateNumber();
            if (num >= numGate) continue;
            numGate = num;
        }
        return numGate;
    }

    public String getStationID() {
        return this.stationID;
    }

    public EarthLocation getStationLocation() {
        return this.radarLocation;
    }

    public void setStationLocation(EarthLocation el) throws VisADException, RemoteException {
        this.radarLocation = el;
        if (el instanceof NamedLocation) {
            this.stationID = ((NamedLocation)this.radarLocation).getIdentifier().getValue();
        }
    }

    public String getStationName() {
        return this.stationName;
    }

    public String getDataFormatName() {
        return this.dataFormatName;
    }

    public FlatField getRaster(int moment, String varName) throws VisADException, RemoteException, IOException, InvalidRangeException {
        ObjectPair cacheKey = new ObjectPair(new ObjectPair(this.radarLocation, this.baseTime), new ObjectPair(new Integer(moment), varName));
        FlatField retField = (FlatField)this.getCache(cacheKey);
        if (retField != null) {
            return retField;
        }
        GeoGrid geod = this.gcd.findGridByName(varName);
        if (geod == null) {
            throw new VisADException("unable to find variable " + varName);
        }
        CoordinateAxis xAxis = ((GridCoordSys)geod.getCoordinateSystem()).getXaxis();
        CoordinateAxis yAxis = ((GridCoordSys)geod.getCoordinateSystem()).getYaxis();
        int sizeX = (int)xAxis.getSize();
        int sizeY = (int)yAxis.getSize();
        GridCoordSystem gcs = geod.getCoordinateSystem();
        CoordinateAxis1D yaxis = (CoordinateAxis1D)gcs.getYHorizAxis();
        Unit xUnit = DataUtil.parseUnit(xAxis.getUnitsString());
        Unit yUnit = DataUtil.parseUnit(yAxis.getUnitsString());
        ProjectionImpl project = geod.getProjection();
        int xRes = (int)(xAxis.getMaxValue() - xAxis.getMinValue()) / (sizeX - 1);
        RadarMapProjection pCS = new RadarMapProjection(this.radarLocation.getLatitude().getValue(CommonUnit.degree), this.radarLocation.getLongitude().getValue(CommonUnit.degree), sizeX, sizeY, xRes);
        RealType xType = DataUtil.makeRealType(xAxis.getName(), null);
        RealType yType = DataUtil.makeRealType(yAxis.getName(), null);
        RealTupleType domainTemplate = new RealTupleType(xType, yType, pCS, null);
        ObjectPair domainTemplateKey = new ObjectPair(geod, "DomainType");
        RealTupleType cachedDomainTemplate = (RealTupleType)this.dataSource.getCache(domainTemplateKey);
        if (cachedDomainTemplate != null) {
            Trace.msg("GeoGridAdapter:using cached domain template:" + cachedDomainTemplate);
            domainTemplate = cachedDomainTemplate;
        } else {
            Trace.msg("GeoGridAdapter:using new domain template:" + domainTemplate);
            this.dataSource.putCache(domainTemplateKey, domainTemplate);
        }
        Array arr = geod.readYXData(0, 0);
        if (yaxis.getCoordValue(0) < yaxis.getCoordValue(1)) {
            arr = arr.flip(0);
        }
        float[][] fieldarray = new float[][]{DataUtil.toFloatArray(arr)};
        Unit u = this.getUnit(geod.getVariable().findAttributeIgnoreCase("units"));
        RealType paramType = DataUtil.makeRealType(varName, u);
        Linear1DSet xSet = new Linear1DSet((MathType)xType, 0.0, sizeX - 1, sizeX);
        Linear1DSet ySet = new Linear1DSet((MathType)yType, 0.0, sizeY - 1, sizeY);
        Linear2DSet domainSet = new Linear2DSet((MathType)domainTemplate, new Linear1DSet[]{xSet, ySet}, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null, true);
        FunctionType ffType = new FunctionType(((SetType)domainSet.getType()).getDomain(), paramType);
        retField = new FlatField(ffType, domainSet);
        try {
            retField.setSamples(fieldarray, false);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.putCache(cacheKey, retField);
        return retField;
    }

    private Linear1DSet makeLinear1DSet(CoordinateAxis1D axis, RealType type, Unit u) throws VisADException {
        Trace.call1("GeoGridAdapter.makeLinear1DSet");
        Linear1DSet result = new Linear1DSet(type, axis.getCoordValue(0), axis.getCoordValue((int)axis.getSize() - 1), (int)axis.getSize(), null, new Unit[]{u}, null, true);
        Trace.call2("GeoGridAdapter.makeLinear1DSet");
        return result;
    }

    public FieldImpl getRHISweep(int moment, double azimus, String varName, int idx, boolean want3D) throws VisADException, RemoteException, IOException {
        Trace.call1(" getRHiSweep " + azimus);
        int sweepNum = idx;
        if (sweepNum < 0) {
            Trace.call2(" getSweep " + azimus);
            return null;
        }
        RadialDatasetSweep.RadialVariable sweepVar = this.getRadialVariable(varName);
        RadialDatasetSweep.Sweep varSweep = sweepVar.getSweep(sweepNum);
        int numRadials = varSweep.getRadialNumber();
        int numGates = varSweep.getGateNumber();
        double range_step = varSweep.getGateSize();
        double range_to_first_gate = (double)varSweep.getRangeToFirstGate() + 0.5 * range_step;
        float[][] values = new float[numRadials][numGates];
        float[] tmpElevs = varSweep.getElevation();
        float[] myElevations = (float[])tmpElevs.clone();
        if (Float.isNaN(myElevations[0])) {
            myElevations[0] = 0.0f;
        }
        for (int rayIdx = 1; rayIdx < numRadials; ++rayIdx) {
            if (!Float.isNaN(myElevations[rayIdx])) continue;
            myElevations[rayIdx] = myElevations[rayIdx - 1] + 0.2f;
        }
        int[] sortedEle = QuickSort.sort(myElevations);
        for (int eli = 0; eli < numRadials; ++eli) {
            values[eli] = varSweep.readData(eli);
        }
        FieldImpl fi = null;
        int bincounter = numGates;
        int tiltcounter = numRadials - 1;
        float rhiAz = (float)azimus;
        int[] tiltindices = new int[numRadials];
        double halfBeamWidth = 0.475;
        double[][] ranges = new double[numRadials][bincounter];
        for (int ti = 0; ti < numRadials; ++ti) {
            ranges[ti][0] = range_to_first_gate + range_step / 2.0;
            for (int bi = 1; bi < bincounter; ++bi) {
                ranges[ti][bi] = ranges[ti][bi - 1] + range_step;
            }
            tiltindices[ti] = ti;
        }
        for (int tc = 0; tc < tiltcounter; ++tc) {
            int ti = sortedEle[tc];
            float[][] domainVals = new float[3][bincounter * 2];
            float[][] signalVals = new float[1][bincounter * 2];
            float lowerElev = myElevations[tc] - (float)halfBeamWidth;
            for (int bi = 0; bi < bincounter; ++bi) {
                domainVals[0][bi] = (float)ranges[ti][bi];
                domainVals[1][bi] = rhiAz;
                domainVals[2][bi] = lowerElev;
                signalVals[0][bi] = values[ti][bi];
            }
            float upperElev = myElevations[tc] + (float)halfBeamWidth;
            for (int bi = 0; bi < bincounter; ++bi) {
                domainVals[0][bi + bincounter] = (float)ranges[ti][bi];
                domainVals[1][bi + bincounter] = rhiAz;
                domainVals[2][bi + bincounter] = upperElev;
                signalVals[0][bi + bincounter] = values[ti][bi];
            }
            Unit u = this.getUnit(sweepVar);
            RealTupleType radarDomainType = this.makeDomainType3D();
            Gridded3DSet domainSet = new Gridded3DSet((MathType)radarDomainType, domainVals, bincounter, 2, radarDomainType.getCoordinateSystem(), new Unit[]{CommonUnit.meter, CommonUnit.degree, CommonUnit.degree}, null, false);
            FunctionType functionType = new FunctionType(radarDomainType, this.getMomentType(varName, u));
            FlatField retField = new FlatField(functionType, (Set)domainSet, (CoordinateSystem)null, (Set[])null, new Unit[]{u});
            retField.setSamples(signalVals, false);
            if (tc == 0) {
                RealType indexType = RealType.getRealType("integer_index");
                FunctionType fiFunction = new FunctionType(indexType, retField.getType());
                Integer1DSet intSet = new Integer1DSet(tiltcounter);
                fi = new FieldImpl(fiFunction, intSet);
                fi.setSample(0, retField, false, true);
                continue;
            }
            fi.setSample(tc, retField, false, false);
        }
        return fi;
    }

    public FlatField getSweep(int moment, double elevation, String varName, int idx, boolean want3D) throws VisADException, RemoteException, IOException {
        int elem;
        int cell;
        int[] sortedAzs;
        float[] myAzimuths;
        Trace.call1(" getSweep " + elevation);
        ObjectPair cacheKey = new ObjectPair(new ObjectPair(new ObjectPair(this.radarLocation, this.baseTime), new ObjectPair(new Integer(moment), new ObjectPair(new Double(elevation), new Integer(idx)))), new Boolean(want3D));
        FlatField retField = (FlatField)this.getCache(cacheKey);
        if (retField != null) {
            Trace.call2(" getSweep " + elevation);
            return retField;
        }
        int sweepNum = idx;
        if (sweepNum < 0) {
            Trace.call2(" getSweep " + elevation);
            return null;
        }
        RadialDatasetSweep.RadialVariable sweepVar = this.getRadialVariable(varName);
        if (sweepVar == null) {
            return null;
        }
        RadialDatasetSweep.Sweep varSweep = sweepVar.getSweep(sweepNum);
        int numRadials = varSweep.getRadialNumber();
        int numGates = varSweep.getGateNumber();
        double range_step = varSweep.getGateSize();
        double range_to_first_gate = (double)varSweep.getRangeToFirstGate() + 0.5 * range_step;
        float[] azimuths = varSweep.getAzimuth();
        float[] _azimuths = myAzimuths = (float[])azimuths.clone();
        for (int rayIdx = 0; rayIdx < numRadials; ++rayIdx) {
            float azimuth = myAzimuths[rayIdx];
            if (Float.isNaN(azimuth)) {
                azimuth = 361.0f;
            }
            _azimuths[rayIdx] = azimuth;
        }
        float azis = 0.0f;
        float preAzi = myAzimuths[0];
        for (int rayIdx = 0; rayIdx < numRadials; ++rayIdx) {
            float dif = Math.abs(myAzimuths[rayIdx] - preAzi);
            if ((double)dif < 1.5) {
                azis += dif;
            }
            preAzi = myAzimuths[rayIdx];
        }
        boolean isSorted = false;
        if (azis >= 300.0f) {
            sortedAzs = QuickSort.sort(myAzimuths);
            isSorted = true;
        } else {
            sortedAzs = new int[myAzimuths.length];
            for (int i = 0; i < myAzimuths.length; ++i) {
                sortedAzs[i] = i;
            }
        }
        float[] elevations = varSweep.getElevation();
        float[] rawValues = varSweep.readData();
        int l = 0;
        int ray0 = 0;
        float az0 = myAzimuths[ray0];
        int rayN = this.getRayNumber(myAzimuths);
        float azN = myAzimuths[rayN - 1];
        float[][] domainVals3d = new float[3][rayN * numGates];
        float[][] domainVals2d = new float[2][];
        int npix = rayN * numGates;
        float[][] values = new float[1][npix];
        if (isSorted) {
            domainVals3d = new float[3][(rayN + 2) * numGates];
            npix = (rayN + 2) * numGates;
            values = new float[1][npix];
        }
        if (isSorted) {
            if (az0 >= 0.0f && (double)az0 <= 1.0) {
                for (cell = 0; cell < numGates; ++cell) {
                    elem = sortedAzs[ray0] * numGates + cell;
                    domainVals3d[0][l] = cell;
                    domainVals3d[1][l] = 0.0f;
                    domainVals3d[2][l] = elevations[sortedAzs[ray0]];
                    values[0][l++] = rawValues[elem];
                }
            } else if ((double)az0 > 1.0) {
                if ((double)azN >= 360.0 && (double)azN <= 361.0) {
                    for (cell = 0; cell < numGates; ++cell) {
                        elem = sortedAzs[rayN - 1] * numGates + cell;
                        domainVals3d[0][l] = cell;
                        domainVals3d[1][l] = azN - 360.0f - 0.5f < 0.0f ? 0.0f : azN - 360.0f - 0.5f;
                        domainVals3d[2][l] = elevations[sortedAzs[rayN - 1]];
                        values[0][l++] = rawValues[elem];
                    }
                } else {
                    for (cell = 0; cell < numGates; ++cell) {
                        elem = sortedAzs[ray0] * numGates + cell;
                        domainVals3d[0][l] = cell;
                        domainVals3d[1][l] = az0 - 0.5f;
                        domainVals3d[2][l] = elevations[sortedAzs[ray0]];
                        values[0][l++] = rawValues[elem];
                    }
                }
            }
        }
        for (int ray = 0; ray < rayN; ++ray) {
            for (int cell2 = 0; cell2 < numGates; ++cell2) {
                int elem2 = sortedAzs[ray] * numGates + cell2;
                domainVals3d[0][l] = cell2;
                domainVals3d[1][l] = myAzimuths[ray];
                domainVals3d[2][l] = elevations[sortedAzs[ray]];
                values[0][l++] = rawValues[elem2];
            }
        }
        if (isSorted) {
            if (azN >= 359.0f && azN <= 360.0f) {
                for (cell = 0; cell < numGates; ++cell) {
                    elem = sortedAzs[rayN - 1] * numGates + cell;
                    domainVals3d[0][l] = cell;
                    domainVals3d[1][l] = 360.0f;
                    domainVals3d[2][l] = elevations[sortedAzs[rayN - 1]];
                    values[0][l++] = rawValues[elem];
                }
            } else if (azN < 359.0f) {
                for (cell = 0; cell < numGates; ++cell) {
                    elem = sortedAzs[rayN - 1] * numGates + cell;
                    domainVals3d[0][l] = cell;
                    domainVals3d[1][l] = azN + 0.5f;
                    domainVals3d[2][l] = elevations[sortedAzs[rayN - 1]];
                    values[0][l++] = rawValues[elem];
                }
            } else if (azN > 360.0f && azN <= 361.0f) {
                for (cell = 0; cell < numGates; ++cell) {
                    elem = sortedAzs[rayN - 1] * numGates + cell;
                    domainVals3d[0][l] = cell;
                    domainVals3d[1][l] = 360.0f;
                    domainVals3d[2][l] = elevations[sortedAzs[rayN - 1]];
                    values[0][l++] = rawValues[elem];
                }
            }
        }
        for (int samp = 0; samp < npix; ++samp) {
            if (values[0][samp] != Float.MAX_VALUE) continue;
            values[0][samp] = Float.NaN;
        }
        int rayN2 = rayN;
        if (isSorted) {
            rayN2 = rayN + 2;
        }
        domainVals2d[0] = domainVals3d[0];
        domainVals2d[1] = domainVals3d[1];
        Unit[] domUnits3d = new Unit[]{CommonUnit.meter, CommonUnit.degree, CommonUnit.degree};
        Unit[] domUnits2d = new Unit[]{CommonUnit.meter, CommonUnit.degree};
        Unit u = this.getUnit(sweepVar);
        this.makeDomainTypes((float)range_step, (float)range_to_first_gate);
        RealTupleType tt = want3D ? this.radarDomain3d : this.radarDomain2d;
        GriddedSet set = want3D ? new Gridded3DSet((MathType)tt, domainVals3d, numGates, rayN2, null, domUnits3d, (ErrorEstimate[])null, false) : new Gridded2DSet(tt, domainVals2d, numGates, rayN2, tt.getCoordinateSystem(), domUnits2d, null, false, false);
        FunctionType sweepType = new FunctionType(tt, this.getMomentType(varName, u));
        retField = new CachedFlatField(sweepType, (Set)set, (CoordinateSystem)null, (Set[])null, new Unit[]{u}, values);
        this.initCachedFlatField((CachedFlatField)retField);
        this.putCache(cacheKey, retField);
        Trace.call2(" getSweep " + elevation);
        return retField;
    }

    private void initCachedFlatField(CachedFlatField cff) {
    }

    int getRayNumber(float[] azimuths) {
        int azn = azimuths.length;
        while (azimuths[azn - 1] >= 361.0f) {
            --azn;
        }
        return azn;
    }

    public int getSweepNumber(String vname, double angle) {
        double[] angles = (double[])this.anglesMap.get(vname);
        for (int i = 0; i < angles.length; ++i) {
            if (!(Math.abs(angles[i] - angle) < 0.05)) continue;
            return i;
        }
        return -1;
    }

    private Unit getUnit(RadialDatasetSweep.RadialVariable v) {
        Attribute a = v.findAttributeIgnoreCase("units");
        String unitName = "";
        if (a != null) {
            unitName = a.getStringValue();
        } else {
            System.out.println("no unit for variable " + v);
        }
        Unit u = DataUtil.parseUnit(unitName);
        return u;
    }

    private Unit getUnit(Attribute a) {
        String unitName = "";
        if (a != null) {
            unitName = a.getStringValue();
        } else {
            System.out.println("no unit for variable ");
        }
        if (unitName.equalsIgnoreCase("MetersPerSecond")) {
            unitName = "m/s";
        }
        Unit u = DataUtil.parseUnit(unitName);
        return u;
    }

    public Object[] getCutIdx(RadialDatasetSweep.RadialVariable sweepVar) {
        int spNum = sweepVar.getNumSweeps();
        ArrayList<Integer> eleArray = new ArrayList<Integer>();
        float eleLast = 0.0f;
        if (!this.isRHI) {
            for (int i = 0; i < spNum; ++i) {
                RadialDatasetSweep.Sweep sp = sweepVar.getSweep(i);
                float ele = sp.getMeanElevation();
                if (ele == eleLast || !((double)(ele - eleLast) > 0.2)) continue;
                eleArray.add(i);
                eleLast = ele;
            }
        } else {
            for (int i = 0; i < spNum; ++i) {
                RadialDatasetSweep.Sweep sp = sweepVar.getSweep(i);
                float azi = 0.0f;
                try {
                    azi = Misc.getAverage(sp.getAzimuth());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (azi == eleLast || !((double)Math.abs(azi - eleLast) > 0.2)) continue;
                eleArray.add(i);
                eleLast = azi;
            }
        }
        return eleArray.toArray();
    }

    float[] getAzimuth(RadialDatasetSweep.Sweep s1) throws IOException {
        float[] az = s1.getAzimuth();
        int aSize = az.length;
        float[] az1 = new float[aSize / 2];
        if (az.length <= 400) {
            return az;
        }
        for (int i = 0; i < aSize / 2; ++i) {
            az1[i] = az[i * 2];
        }
        return az1;
    }

    public FlatField getVolume(int moment, String varName) throws VisADException, RemoteException, IOException {
        float[] allData;
        int b;
        if (this.isRHI) {
            return this.getRHIVolume(moment, varName);
        }
        ObjectPair cacheKey = new ObjectPair(new ObjectPair(this.radarLocation, this.baseTime), new ObjectPair(new Integer(moment), "range-az vol"));
        FlatField retField = (FlatField)this.getCache(cacheKey);
        if (retField != null) {
            return retField;
        }
        RadialDatasetSweep.RadialVariable sweepVar = this.getRadialVariable(varName);
        int numberOfRay = this.getRayNumber(sweepVar);
        int gates = this.getGateNumber(sweepVar);
        int rayNumber = 360;
        Object[] cut = this.getCutIdx(sweepVar);
        int numberOfSweeps = cut.length;
        float beamWidth = sweepVar.getSweep(0).getBeamWidth();
        if (moment == 0) {
            // empty if block
        }
        float[][] myAziArray = new float[numberOfSweeps][];
        int[][] aziArrayIdx = new int[numberOfSweeps][];
        float[] meanEle = new float[numberOfSweeps];
        for (b = 0; b < numberOfSweeps; ++b) {
            int sb = Integer.parseInt(cut[b].toString());
            RadialDatasetSweep.Sweep s1 = sweepVar.getSweep(sb);
            float[] tmpAzi = this.format != null && this.format.toString().contains("AR2V") ? this.getAzimuth(s1) : s1.getAzimuth();
            myAziArray[b] = (float[])tmpAzi.clone();
            aziArrayIdx[b] = QuickSort.sort(myAziArray[b]);
            meanEle[b] = s1.getMeanElevation();
        }
        if (this.RSL_sweep_list == null) {
            this.RSL_sweep_list = new CDMRadarSweepDB[numberOfSweeps];
            for (b = 0; b < numberOfSweeps; ++b) {
                this.RSL_sweep_list[b] = this.constructSweepHashTable(myAziArray[b], aziArrayIdx[b], beamWidth);
            }
        }
        double[][] ranges = new double[numberOfSweeps][gates];
        double range_step = sweepVar.getSweep(numberOfSweeps - 1).getGateSize();
        double range_to_first_gate = sweepVar.getSweep(numberOfSweeps - 1).getRangeToFirstGate();
        for (int sweepIdx = 0; sweepIdx < numberOfSweeps; ++sweepIdx) {
            double[] _ranges = ranges[sweepIdx];
            _ranges[0] = range_to_first_gate + range_step / 2.0;
            for (int gateIdx = 1; gateIdx < gates; ++gateIdx) {
                _ranges[gateIdx] = _ranges[gateIdx - 1] + range_step;
            }
        }
        Trace.call1("making arrays", " size=" + gates * numberOfRay * numberOfSweeps);
        float[][] domainVals = new float[3][gates * rayNumber * numberOfSweeps];
        float[][] signalVals = new float[1][gates * rayNumber * numberOfSweeps];
        Trace.call2("making arrays");
        float[] domainVals0 = domainVals[0];
        float[] domainVals1 = domainVals[1];
        float[] domainVals2 = domainVals[2];
        int[][] rayIndex = new int[numberOfSweeps][numberOfRay];
        int[] rNum = new int[numberOfSweeps];
        for (int sweepIdx = 0; sweepIdx < numberOfSweeps; ++sweepIdx) {
            int sb = Integer.parseInt(cut[sweepIdx].toString());
            RadialDatasetSweep.Sweep sweep = sweepVar.getSweep(sb);
            float f = sweep.getBeamWidth() / 2.0f;
            rNum[sweepIdx] = sweep.getRadialNumber();
            CDMRadarSweepDB sweepTable = this.RSL_sweep_list[sweepIdx];
            for (int rayIdx = 0; rayIdx < rayNumber; ++rayIdx) {
                float rhiAz = rayIdx;
                CDMRadarSweepDB.Ray r = this.hashBin(sweepTable, rhiAz, rayNumber, sweep.getBeamWidth());
                rayIndex[sweepIdx][rayIdx] = r.rayIndex;
            }
        }
        try {
            allData = sweepVar.readAllData();
        }
        catch (Exception np) {
            LogUtil.consoleMessage("Radar read volume data error in file:\n" + this.swpFileName);
            return null;
        }
        float[][][] data2 = new float[numberOfSweeps][rayNumber][gates];
        for (int sweepIdx = 0; sweepIdx < numberOfSweeps; ++sweepIdx) {
            float[][] _data2 = data2[sweepIdx];
            int sb = Integer.parseInt(cut[sweepIdx].toString());
            int rnumber = rNum[sweepIdx];
            for (int rayIdx = 0; rayIdx < rayNumber; ++rayIdx) {
                int si = rayIndex[sweepIdx][rayIdx];
                float[] __data2 = _data2[rayIdx];
                if (si < rnumber && si < numberOfRay) {
                    for (int gateIdx = 0; gateIdx < gates; ++gateIdx) {
                        __data2[gateIdx] = allData[gates * numberOfRay * sb + gates * si + gateIdx];
                    }
                    continue;
                }
                _data2[rayIdx] = this.getFloatNaN(gates);
            }
        }
        int k = 0;
        for (int sweepIdx = 0; sweepIdx < numberOfSweeps; ++sweepIdx) {
            float _elevation2 = meanEle[sweepIdx];
            double[] _ranges = ranges[sweepIdx];
            float[][] _data2 = data2[sweepIdx];
            for (int rayIdx = 0; rayIdx < rayNumber; ++rayIdx) {
                float __azimuth = rayIdx;
                float[] __data2 = _data2[rayIdx];
                for (int gateIdx = 0; gateIdx < gates; ++gateIdx) {
                    domainVals2[k] = _elevation2;
                    domainVals1[k] = __azimuth;
                    domainVals0[k] = (float)_ranges[gateIdx];
                    signalVals[0][k] = __data2[gateIdx];
                    ++k;
                }
            }
        }
        Unit u = this.getUnit(sweepVar);
        RealTupleType tt = this.radarDomain3d = this.makeDomainType3D();
        Unit[] domUnits3d = new Unit[]{CommonUnit.meter, CommonUnit.degree, CommonUnit.degree};
        Gridded3DSet set = new Gridded3DSet(tt, domainVals, gates, rayNumber, numberOfSweeps, null, domUnits3d, null, false, false);
        FunctionType sweepType = new FunctionType(tt, this.getMomentType(varName, u));
        retField = new CachedFlatField(sweepType, (Set)set, (CoordinateSystem)null, (Set[])null, new Unit[]{u}, signalVals);
        this.initCachedFlatField((CachedFlatField)retField);
        this.putCache(cacheKey, retField);
        return retField;
    }

    public FlatField getRHIVolume(int moment, String varName) throws VisADException, RemoteException, IOException {
        float[] allData;
        int b;
        ObjectPair cacheKey = new ObjectPair(new ObjectPair(this.radarLocation, this.baseTime), new ObjectPair(new Integer(moment), "range-az vol"));
        FlatField retField = (FlatField)this.getCache(cacheKey);
        if (retField != null) {
            return retField;
        }
        RadialDatasetSweep.RadialVariable sweepVar = this.getRadialVariable(varName);
        int numberOfRay = this.getRayNumber(sweepVar);
        int gates = this.getGateNumber(sweepVar);
        Object[] cut = this.getCutIdx(sweepVar);
        int numberOfSweeps = cut.length;
        float[][] eleArray = new float[numberOfSweeps][];
        int[][] eleArrayIdx = new int[numberOfSweeps][];
        float[] meanEle = new float[numberOfSweeps];
        float[] meanAzi = new float[numberOfSweeps];
        int[] cutIdx = new int[numberOfSweeps];
        for (b = 0; b < numberOfSweeps; ++b) {
            int sb = Integer.parseInt(cut[b].toString());
            RadialDatasetSweep.Sweep s1 = sweepVar.getSweep(sb);
            meanEle[b] = s1.getMeanElevation();
            eleArray[b] = s1.getElevation();
            eleArrayIdx[b] = QuickSort.sort(eleArray[b]);
            meanAzi[b] = Misc.getAverage(s1.getAzimuth());
        }
        cutIdx = QuickSort.sort(meanAzi);
        if (this.RSL_sweep_list == null) {
            this.RSL_sweep_list = new CDMRadarSweepDB[numberOfSweeps];
            for (b = 0; b < numberOfSweeps; ++b) {
                int a = cutIdx[b];
                this.RSL_sweep_list[b] = this.constructSweepHashTable(eleArray[a], eleArrayIdx[a], 0.95f);
            }
        }
        double[][] ranges = new double[numberOfSweeps][gates];
        double range_step = sweepVar.getSweep(numberOfSweeps - 1).getGateSize();
        double range_to_first_gate = sweepVar.getSweep(numberOfSweeps - 1).getRangeToFirstGate();
        for (int sweepIdx = 0; sweepIdx < numberOfSweeps; ++sweepIdx) {
            double[] _ranges = ranges[sweepIdx];
            _ranges[0] = range_to_first_gate + range_step / 2.0;
            for (int gateIdx = 1; gateIdx < gates; ++gateIdx) {
                _ranges[gateIdx] = _ranges[gateIdx - 1] + range_step;
            }
        }
        Trace.call1("making arrays", " size=" + gates * numberOfRay * numberOfSweeps);
        float[][] domainVals = new float[3][gates * numberOfRay * numberOfSweeps];
        float[][] signalVals = new float[1][gates * numberOfRay * numberOfSweeps];
        Trace.call2("making arrays");
        float[] domainVals0 = domainVals[0];
        float[] domainVals1 = domainVals[1];
        float[] domainVals2 = domainVals[2];
        int[][] rayIndex = new int[numberOfSweeps][numberOfRay];
        int[] rNum = new int[numberOfSweeps];
        for (int sweepIdx = 0; sweepIdx < numberOfSweeps; ++sweepIdx) {
            int sb = cutIdx[sweepIdx];
            RadialDatasetSweep.Sweep sweep = sweepVar.getSweep(sb);
            float f = sweep.getBeamWidth() / 2.0f;
            rNum[sweepIdx] = sweep.getRadialNumber();
            float[] els = sweep.getElevation();
            for (int rayIdx = 0; rayIdx < numberOfRay; ++rayIdx) {
                float rhiAz = rayIdx;
                rayIndex[sweepIdx][rayIdx] = this.getClosestRayFromSweep(rhiAz, f, sweepIdx, els);
            }
        }
        try {
            allData = sweepVar.readAllData();
        }
        catch (Exception np) {
            LogUtil.consoleMessage("Radar read volume data error in file:\n" + this.swpFileName);
            return null;
        }
        float[][][] data2 = new float[numberOfSweeps][numberOfRay][gates];
        for (int sweepIdx = 0; sweepIdx < numberOfSweeps; ++sweepIdx) {
            float[][] _data2 = data2[sweepIdx];
            int sb = cutIdx[sweepIdx];
            int rnumber = rNum[sweepIdx];
            for (int rayIdx = 0; rayIdx < numberOfRay; ++rayIdx) {
                int si = rayIndex[sweepIdx][rayIdx];
                float[] __data2 = _data2[rayIdx];
                if (si < rnumber) {
                    for (int gateIdx = 0; gateIdx < gates; ++gateIdx) {
                        __data2[gateIdx] = allData[gates * numberOfRay * sb + gates * si + gateIdx];
                    }
                    continue;
                }
                _data2[rayIdx] = this.getFloatNaN(gates);
            }
        }
        int k = 0;
        for (int sweepIdx = 0; sweepIdx < numberOfSweeps; ++sweepIdx) {
            int sb = cutIdx[sweepIdx];
            float[] _elevation2 = eleArray[sb];
            float _azimuth2 = meanAzi[sb];
            double[] _ranges = ranges[sb];
            float[][] _data2 = data2[sb];
            for (int rayIdx = 0; rayIdx < numberOfRay; ++rayIdx) {
                float __azimuth = rayIdx;
                float[] __data2 = _data2[rayIdx];
                float __elevation = _elevation2[rayIdx];
                for (int gateIdx = 0; gateIdx < gates; ++gateIdx) {
                    domainVals2[k] = __elevation;
                    domainVals1[k] = _azimuth2;
                    domainVals0[k] = (float)_ranges[gateIdx];
                    signalVals[0][k] = __data2[gateIdx];
                    ++k;
                }
            }
        }
        Unit u = this.getUnit(sweepVar);
        RealTupleType tt = this.radarDomain3d = this.makeDomainType3D();
        Unit[] domUnits3d = new Unit[]{CommonUnit.meter, CommonUnit.degree, CommonUnit.degree};
        Gridded3DSet set = new Gridded3DSet(tt, domainVals, gates, numberOfRay, numberOfSweeps, null, domUnits3d, null, false, false);
        FunctionType sweepType = new FunctionType(tt, this.getMomentType(varName, u));
        retField = new CachedFlatField(sweepType, (Set)set, (CoordinateSystem)null, (Set[])null, new Unit[]{u}, signalVals);
        this.initCachedFlatField((CachedFlatField)retField);
        this.putCache(cacheKey, retField);
        return retField;
    }

    public float[] getFloatNaN(int n) {
        float[] data = new float[n];
        for (int gIdx = 0; gIdx < n; ++gIdx) {
            data[gIdx] = Float.NaN;
        }
        return data;
    }

    public boolean isRaster() {
        return this.isRaster;
    }

    public boolean isVolume() {
        return this.isVolume;
    }

    public boolean isRHI() {
        return this.isRHI;
    }

    private void putCache(Object key, Object object) {
        if (this.dataSource != null) {
            this.dataSource.putCache(key, object);
        }
    }

    private Object getCache(Object key) {
        return this.dataSource == null ? null : this.dataSource.getCache(key);
    }

    public static void mainDorade(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            DoradeSweep sweep = new DoradeSweep(args[i]);
            int nRays = sweep.getNRays();
            int nCells = sweep.getNCells(0);
            DoradePARM param = sweep.lookupParamIgnoreCase("VR");
            float[] azimuths = sweep.getAzimuths();
            float[] elevations = sweep.getElevations();
            for (int rayIdx = 0; rayIdx < nRays; ++rayIdx) {
                System.out.println("ray:" + rayIdx + " " + elevations[rayIdx] + " " + azimuths[rayIdx]);
                float[] rayValues = sweep.getRayData(param, rayIdx);
                for (int cellIdx = 0; cellIdx < nRays; ++cellIdx) {
                    if (cellIdx > 0) {
                        System.out.print(",");
                    }
                    System.out.print("" + rayValues[cellIdx]);
                }
                System.out.println("");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            long total = 0L;
            for (int j = 0; j < 20; ++j) {
                long t1 = System.currentTimeMillis();
                CDMRadarAdapter cra = new CDMRadarAdapter(null, args[i]);
                cra.getVolume(0, "Reflectivity");
                long t2 = System.currentTimeMillis();
                if (j == 0) continue;
                System.err.println("avg:" + (total += t2 - t1) / (long)j);
            }
        }
    }

    private RadialDatasetSweep.RadialVariable getRadialVariable(String varName) {
        return (RadialDatasetSweep.RadialVariable)this.rds.getDataVariable(Util.cleanTypeName(varName));
    }

    @Override
    public void doRemove() {
        this.clearCachedData();
        try {
            if (this.rds != null) {
                this.rds.close();
            }
            if (this.gcd != null) {
                this.gcd.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

