/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.profiler;

import java.awt.Component;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JPanel;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.ui.LatLonWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import ucar.unidata.util.WrapperException;
import ucar.visad.quantities.PolarHorizontalWind;
import ucar.visad.quantities.VerticalWindComponent;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded3DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.Plain;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;

public class EOLProfilerDataSource
extends DataSourceImpl {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(EOLProfilerDataSource.class.getName());
    private String fileNameOrUrl;
    EarthLocation location = null;
    FieldImpl data = null;
    private LatLonWidget locWidget;
    private boolean locationSetByUser = false;

    public EOLProfilerDataSource() throws VisADException {
    }

    public EOLProfilerDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        super(descriptor, "EOL/NCAR Profiler (" + IOUtil.getFileTail(source) + ")", source, properties);
        this.setFileNameOrUrl(source);
        this.initProfiler();
    }

    @Override
    public void initAfterUnpersistence() {
        super.initAfterUnpersistence();
        this.initProfiler();
    }

    @Override
    public void newFileFromPolling(File f) {
        String newFilename = f.getPath();
        System.out.println("new file: " + newFilename);
        if (!newFilename.equals(this.getFileNameOrUrl())) {
            this.locationSetByUser = false;
        }
        try {
            this.initProfiler();
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Creating new file", exc);
            return;
        }
        this.setFileNameOrUrl(f.getPath());
        this.setName(this.getFileNameOrUrl());
        this.flushCache();
        this.notifyDataChange();
    }

    @Override
    protected List getLocationsForPolling() {
        return Misc.newList(this.getFileNameOrUrl());
    }

    private void initProfiler() {
        try {
            Trace.call1("initProfiler");
            Plain p = new Plain();
            Tuple t = (Tuple)p.open(this.getFileNameOrUrl());
            Real lat = null;
            Real lon = null;
            Real alt = null;
            DataImpl rawData = null;
            for (int i = 0; i < t.getDimension(); ++i) {
                FieldImpl f;
                Data d = t.getComponent(i);
                if (d instanceof Real) {
                    Real r = (Real)t.getComponent(i);
                    if (r.getType().equals(RealType.Latitude)) {
                        lat = r;
                        continue;
                    }
                    if (r.getType().equals(RealType.Longitude)) {
                        lon = r;
                        continue;
                    }
                    if (!r.getType().equals(RealType.Altitude)) continue;
                    double value = r.getValue();
                    if (r.getUnit().equals(CommonUnit.meter.scale(1000.0)) && value > 8.0) {
                        value /= 1000.0;
                    }
                    alt = r.cloneButValue(value);
                    continue;
                }
                if (!(d instanceof FieldImpl) || !GridUtil.isTimeSequence(f = (FieldImpl)d)) continue;
                rawData = f;
            }
            if (lat == null || lon == null || alt == null) {
                throw new VisADException("couldn't find location");
            }
            if (rawData == null) {
                throw new VisADException("couldn't find data");
            }
            if (!this.locationSetByUser) {
                this.location = new EarthLocationTuple(lat, lon, alt);
            }
            boolean timeIndex = false;
            String type = rawData.getType().toString();
            int offsetIndex = type.indexOf("time_offset");
            Gridded1DSet timeSet = null;
            if (offsetIndex > 0) {
                FlatField offsetFI = (FlatField)((FieldImpl)rawData).extract(0);
                timeSet = new Gridded1DDoubleSet((MathType)RealType.Time, offsetFI.getValues(false), offsetFI.getDomainSet().getLength(), (CoordinateSystem)null, offsetFI.getDefaultRangeUnits(), (ErrorEstimate[])null);
                rawData = (FieldImpl)((FieldImpl)rawData).extract(1);
            } else {
                timeSet = (Gridded1DSet)((FieldImpl)rawData).getDomainSet();
            }
            TupleType rangeType = null;
            Unit[] units = null;
            int altIndex = -1;
            int spdIndex = -1;
            int dirIndex = -1;
            int wIndex = -1;
            FunctionType newType = null;
            boolean has3Comps = false;
            Unit[] origUnits = null;
            Unit altUnit = CommonUnit.meter;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                float[][] fArrayArray;
                float[][] vals;
                FlatField f = (FlatField)((FieldImpl)rawData).getSample(i, false);
                RealTupleType tt = ((FunctionType)f.getType()).getFlatRange();
                if (i == 0) {
                    Unit[] unitArray;
                    Unit wUnit;
                    altIndex = tt.getIndex("height");
                    spdIndex = tt.getIndex("wspd");
                    dirIndex = tt.getIndex("wdir");
                    wIndex = tt.getIndex("wvert");
                    if (altIndex == -1 || spdIndex == -1 || dirIndex == -1) {
                        throw new VisADException("can't find components");
                    }
                    rangeType = has3Comps ? new TupleType(new MathType[]{PolarHorizontalWind.getRealTupleType(), VerticalWindComponent.getRealType()}) : PolarHorizontalWind.getRealTupleType();
                    origUnits = f.getDefaultRangeUnits();
                    if (origUnits[altIndex] != null && !origUnits[altIndex].isDimensionless()) {
                        altUnit = origUnits[altIndex];
                    }
                    Unit spdUnit = origUnits[spdIndex] == null || origUnits[spdIndex].isDimensionless() ? CommonUnit.meterPerSecond : origUnits[spdIndex];
                    Unit dirUnit = origUnits[dirIndex] == null || origUnits[spdIndex].isDimensionless() ? CommonUnit.degree : origUnits[dirIndex];
                    Unit unit = wUnit = origUnits[wIndex] == null || origUnits[spdIndex].isDimensionless() ? CommonUnit.meterPerSecond : origUnits[wIndex];
                    if (has3Comps) {
                        Unit[] unitArray2 = new Unit[3];
                        unitArray2[0] = spdUnit;
                        unitArray2[1] = dirUnit;
                        unitArray = unitArray2;
                        unitArray2[2] = wUnit;
                    } else {
                        Unit[] unitArray3 = new Unit[2];
                        unitArray3[0] = spdUnit;
                        unitArray = unitArray3;
                        unitArray3[1] = dirUnit;
                    }
                    units = unitArray;
                    newType = new FunctionType(RealType.Altitude, rangeType);
                    FunctionType fiType = new FunctionType(((SetType)timeSet.getType()).getDomain(), newType);
                    this.data = new FieldImpl(fiType, timeSet);
                }
                if ((vals = this.removeMissingHeights(f.getFloats(false), altIndex)) == null) continue;
                float stationAlt = (float)alt.getValue(altUnit);
                float[] alts = vals[altIndex];
                int l = 0;
                while (l < alts.length) {
                    int n = l++;
                    alts[n] = alts[n] + stationAlt;
                }
                Gridded1DSet altSet = new Gridded1DSet((MathType)RealType.Altitude, (float[][])new float[][]{vals[altIndex]}, vals[altIndex].length, null, new Unit[]{altUnit}, null);
                FlatField ff = new FlatField(newType, (Set)altSet, (CoordinateSystem)null, (Set[])null, units);
                if (has3Comps) {
                    float[][] fArrayArray2 = new float[3][];
                    fArrayArray2[0] = vals[spdIndex];
                    fArrayArray2[1] = vals[dirIndex];
                    fArrayArray = fArrayArray2;
                    fArrayArray2[2] = vals[wIndex];
                } else {
                    float[][] fArrayArray3 = new float[2][];
                    fArrayArray3[0] = vals[spdIndex];
                    fArrayArray = fArrayArray3;
                    fArrayArray3[1] = vals[dirIndex];
                }
                float[][] newSamples = fArrayArray;
                ff.setSamples(newSamples, false);
                this.data.setSample(i, (Data)ff, false);
            }
        }
        catch (Exception exc) {
            this.setInError(true);
            throw new WrapperException(exc);
        }
        Trace.call2("initProfiler");
    }

    private float[][] removeMissingHeights(float[][] samples, int altIndex) {
        int i;
        float[][] newSamples = null;
        int[] indices = new int[samples[0].length];
        int counter = 0;
        for (i = 0; i < samples[altIndex].length; ++i) {
            if (Float.isNaN(samples[altIndex][i])) continue;
            indices[counter++] = i;
        }
        if (counter == 0) {
            return newSamples;
        }
        newSamples = new float[samples.length][counter];
        for (i = 0; i < counter; ++i) {
            for (int j = 0; j < samples.length; ++j) {
                newSamples[j][i] = samples[j][indices[i]];
            }
        }
        return newSamples;
    }

    @Override
    public void doMakeDataChoices() {
        Object choice = null;
        List singleDC = DataCategory.parseCategories("PROFILER_ONESTA", false);
        List compositeDC = DataCategory.parseCategories("PROFILER_3D", false);
        compositeDC.addAll(singleDC);
        CompositeDataChoice composite = new CompositeDataChoice(this, (Object)"", "Winds", "Profiler winds", compositeDC);
        this.addDataChoice(composite);
        composite.addDataChoice(new DirectDataChoice(this, this.location, "winds", this.location.toString(), singleDC));
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        boolean singleStation;
        boolean bl = singleStation = !(dataChoice instanceof CompositeDataChoice);
        if (singleStation) {
            return this.data;
        }
        return this.recastProfilerMultiStationData();
    }

    private FieldImpl recastProfilerMultiStationData() throws VisADException, RemoteException {
        FieldImpl retField = null;
        Gridded1DSet timeSet = (Gridded1DSet)this.data.getDomainSet();
        FunctionType rangeType = null;
        for (int i = 0; i < timeSet.getLength(); ++i) {
            FlatField f = (FlatField)this.data.getSample(i);
            if (i == 0) {
                FunctionType ft = (FunctionType)f.getType();
                rangeType = new FunctionType(RealTupleType.LatitudeLongitudeAltitude, ft.getRange());
                FunctionType newType = new FunctionType(((SetType)timeSet.getType()).getDomain(), rangeType);
                retField = new FieldImpl(newType, timeSet);
            }
            Gridded1DSet alts = (Gridded1DSet)f.getDomainSet();
            Unit degree = CommonUnit.degree;
            float[][] lla = new float[3][alts.getLength()];
            Arrays.fill(lla[0], (float)this.location.getLatitude().getValue(degree));
            Arrays.fill(lla[1], (float)this.location.getLongitude().getValue(degree));
            lla[2] = alts.getSamples(false)[0];
            Gridded3DSet newDomain = new Gridded3DSet((MathType)RealTupleType.LatitudeLongitudeAltitude, lla, alts.getLength(), (CoordinateSystem)null, new Unit[]{degree, degree, alts.getSetUnits()[0]}, (ErrorEstimate[])null, false);
            FlatField newField = new FlatField(rangeType, newDomain);
            newField.setSamples(f.getFloats(false), false);
            retField.setSample(i, (Data)newField, false);
        }
        return retField;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EOLProfilerDataSource)) {
            return false;
        }
        EOLProfilerDataSource that = (EOLProfilerDataSource)o;
        if (!super.equals(o)) {
            return false;
        }
        return Misc.equals(this.data, that.data);
    }

    public int hashCode() {
        return Misc.hashcode(this.location) ^ super.hashCode();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Must supply a file name");
            System.exit(1);
        }
        try {
            EOLProfilerDataSource eOLProfilerDataSource = new EOLProfilerDataSource(null, args[0], null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFileNameOrUrl(String value) {
        this.fileNameOrUrl = value;
    }

    public String getFileNameOrUrl() {
        return this.fileNameOrUrl;
    }

    @Override
    public void getPropertiesComponents(List comps) {
        super.getPropertiesComponents(comps);
        this.locWidget = new LatLonWidget("Lat: ", " Lon: ", " Alt:", null);
        JPanel locPanel = GuiUtils.hbox(new Component[]{GuiUtils.leftCenter(GuiUtils.rLabel("Lat: "), this.locWidget.getLatField()), GuiUtils.leftCenter(GuiUtils.rLabel(" Lon: "), this.locWidget.getLonField()), GuiUtils.leftCenter(GuiUtils.rLabel(" Alt: "), GuiUtils.centerRight(this.locWidget.getAltField(), GuiUtils.cLabel("m")))});
        if (this.location != null) {
            this.locWidget.setLat(this.location.getLatitude().getValue());
            this.locWidget.setLon(this.location.getLongitude().getValue());
            try {
                this.locWidget.setAlt(this.location.getAltitude().getValue(CommonUnit.meter));
            }
            catch (VisADException ve) {
                this.locWidget.setAlt(this.location.getAltitude().getValue());
            }
        }
        comps.add(GuiUtils.filler());
        comps.add(this.getPropertiesHeader("Profiler Location"));
        comps.add(GuiUtils.filler());
        comps.add(GuiUtils.left(locPanel));
    }

    @Override
    public boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        return this.setLocationFromWidgets();
    }

    private boolean setLocationFromWidgets() {
        try {
            double lat = this.locWidget.getLat();
            double lon = this.locWidget.getLon();
            double alt = this.locWidget.getAlt();
            EarthLocationTuple elt = new EarthLocationTuple(lat, lon, alt);
            if (elt.equals(this.location)) {
                return true;
            }
            this.locationSetByUser = true;
            this.location = elt;
        }
        catch (Exception e) {
            return false;
        }
        List l = this.getDataChoices();
        for (int i = 0; i < l.size(); ++i) {
            DataChoice dc = (DataChoice)l.get(i);
            CompositeDataChoice cdc = (CompositeDataChoice)dc;
            List children = cdc.getDataChoices();
            for (int j = 0; j < children.size(); ++j) {
                DataChoice child = (DataChoice)children.get(j);
                child.setId(this.location);
                child.setDescription(this.location.toString());
            }
        }
        this.reloadData();
        return true;
    }
}

