/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.profiler;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JPanel;
import ucar.ma2.StructureData;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.StationProfileFeatureCollection;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.standard.StandardProfileCollectionImpl;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.data.sounding.CDMProfileFeatureTypeInfo;
import ucar.unidata.geoloc.Station;
import ucar.unidata.metdata.NamedStation;
import ucar.unidata.metdata.NamedStationImpl;
import ucar.unidata.ui.LatLonWidget;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import visad.CommonUnit;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded3DSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.QuickSort;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.jmet.MetUnits;

public class CDMProfilerDataSource
extends FilesDataSource {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(CDMProfilerDataSource.class.getName());
    private List<String> fileNameOrUrls;
    EarthLocation location = null;
    private LatLonWidget locWidget;
    private boolean locationSetByUser = false;
    private float CAPMissing = 2.1474836E9f;
    private float WPDNissing = 1.0E38f;
    String source;
    private Hashtable<String, List> stationsToProfiles;
    private List<NamedStation> selectedStations;
    private List allProfiles;
    private List<StationFeature> stations;
    private List profileIds;
    private List<Double> times;
    RealType[] rTypes = new RealType[]{RealType.Latitude, RealType.Longitude, RealType.Altitude, RealType.Time, DataUtil.makeRealType("SPD", CommonUnit.meterPerSecond), DataUtil.makeRealType("DIR", CommonUnit.degree)};
    String[] params = new String[]{"LAT", "LON", "Z", "TIME", "SPD", "DIR"};
    private Map<String, CDMProfileFeatureTypeInfo.ProfileFeatureBean> beanCache = new ConcurrentHashMap<String, CDMProfileFeatureTypeInfo.ProfileFeatureBean>();
    private boolean debug = false;

    public CDMProfilerDataSource() throws VisADException {
    }

    public CDMProfilerDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException, IOException {
        this(descriptor, Misc.newList(source), properties);
    }

    public CDMProfilerDataSource(DataSourceDescriptor descriptor, List files, Hashtable properties) throws VisADException, IOException {
        super(descriptor, files, (String)files.get(0), "CDM Profiler data source", properties);
        this.fileNameOrUrls = files;
        this.setFileNameOrUrls(files);
        String nam = "CDM Profiler Data Source";
        this.initProfilerAll(files, nam);
    }

    @Override
    public void initAfterUnpersistence() {
        super.initAfterUnpersistence();
        ArrayList<String> files = new ArrayList<String>();
        String nam = "CDM Profiler Data Source";
        for (String fn : this.sources) {
            files.add(fn);
        }
        try {
            this.initProfilerAll(files, nam);
        }
        catch (VisADException visADException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void newFileFromPolling(File f) {
        String newFilename = f.getPath();
        System.out.println("new file: " + newFilename);
        if (!this.getFileNameOrUrls().contains(newFilename)) {
            this.locationSetByUser = false;
        }
        try {
            this.initProfiler(newFilename, "CDM Profiler");
        }
        catch (Exception exc) {
            LogUtil.printException(log_, "Creating new file", exc);
            return;
        }
        this.setFileNameOrUrls(Misc.newList(f.getPath()));
        this.setName(newFilename);
        this.flushCache();
        this.notifyDataChange();
    }

    @Override
    protected List getLocationsForPolling() {
        return Misc.newList(this.getFileNameOrUrls());
    }

    private List<NamedStation> getNamedStations(List<StationFeature> stations) {
        int size = stations.size();
        Unit unit = DataUtil.parseUnit("meter");
        ArrayList<NamedStation> nstations = new ArrayList<NamedStation>();
        for (int i = 0; i < size; ++i) {
            Station st = stations.get(i);
            NamedStationImpl nstation = null;
            try {
                nstation = new NamedStationImpl(st.getName(), st.getName(), st.getLatitude(), st.getLongitude(), st.getAltitude(), unit);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            nstations.add(nstation);
        }
        return nstations;
    }

    private List<NamedStation> getNamedStations1(List<String> stations) {
        int size = stations.size();
        Unit unit = DataUtil.parseUnit("meter");
        ArrayList<NamedStation> nstations = new ArrayList<NamedStation>();
        for (int i = 0; i < size; ++i) {
            String st = stations.get(i);
            CDMProfileFeatureTypeInfo.ProfileFeatureBean pBean = this.beanCache.get(st);
            NamedStationImpl nstation = null;
            try {
                nstation = new NamedStationImpl(st, st, pBean.getLatitude(), pBean.getLongitude(), pBean.getAltitude(), unit);
            }
            catch (VisADException visADException) {
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            nstations.add(nstation);
        }
        return nstations;
    }

    private NamedStation getNamedStation(Station st) {
        Unit unit = DataUtil.parseUnit("meter");
        NamedStationImpl nstation = null;
        try {
            nstation = new NamedStationImpl(st.getName(), st.getName(), st.getLatitude(), st.getLongitude(), st.getAltitude(), unit);
        }
        catch (VisADException visADException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return nstation;
    }

    public boolean isMadis(FeatureType wantFeatureType, NetcdfFile ds) {
        if (wantFeatureType != FeatureType.ANY_POINT && wantFeatureType != FeatureType.STATION && wantFeatureType != FeatureType.POINT && wantFeatureType != FeatureType.STATION_PROFILE) {
            return false;
        }
        if (!ds.hasUnlimitedDimension()) {
            return false;
        }
        if (ds.findDimension("recNum") == null) {
            return false;
        }
        if (ds.findVariable("staticIds") == null) {
            return false;
        }
        if (ds.findVariable("nStaticIds") == null) {
            return false;
        }
        if (ds.findVariable("lastRecord") == null) {
            return false;
        }
        if (ds.findVariable("prevRecord") == null) {
            return false;
        }
        if (ds.findVariable("latitude") == null) {
            return false;
        }
        if (ds.findVariable("longitude") == null) {
            return false;
        }
        return ds.findVariable("observationTime") != null;
    }

    public boolean isWPDN(FeatureType wantFeatureType, NetcdfFile ds) {
        String title = ds.findAttValueIgnoreCase(null, "title", null);
        return title != null && (title.startsWith("WPDN data") || title.startsWith("RASS data"));
    }

    private void initProfilerAll(List<String> sources, String sname) throws IOException, VisADException {
        this.stationsToProfiles = new Hashtable();
        this.times = new ArrayList<Double>();
        this.allProfiles = new ArrayList();
        int size = sources.size();
        for (int i = 0; i < size; ++i) {
            this.initProfiler(sources.get(i), sname);
        }
    }

    private void initProfiler(String fileNameOrUrl, String sname) throws IOException, VisADException {
        Formatter log = new Formatter();
        FeatureDatasetPoint dataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION_PROFILE, fileNameOrUrl, null, log);
        if (dataset == null && (dataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.PROFILE, fileNameOrUrl, null, log)) == null) {
            throw new BadDataException("Could not open trajectory file:" + fileNameOrUrl);
        }
        List<DsgFeatureCollection> fcList = dataset.getPointFeatureCollectionList();
        DsgFeatureCollection fc = fcList.get(0);
        if (fc instanceof StandardProfileCollectionImpl) {
            StandardProfileCollectionImpl spc = (StandardProfileCollectionImpl)fc;
            FeatureType ftype = spc.getCollectionFeatureType();
            this.initWPDNOld(spc, sname);
        } else {
            StationProfileFeatureCollection spc = (StationProfileFeatureCollection)fc;
            FeatureType ftype = spc.getCollectionFeatureType();
            boolean ismadis = this.isMadis(ftype, dataset.getNetcdfFile());
            boolean iswpdn = this.isWPDN(ftype, dataset.getNetcdfFile());
            if (ismadis) {
                this.initMadis(spc, sname);
            } else if (iswpdn) {
                this.initWPDN(spc, sname);
            } else {
                StandardProfileCollectionImpl spc1 = (StandardProfileCollectionImpl)fc;
                this.initWPDNOld(spc1, sname);
            }
        }
    }

    private void addStations(List<StationFeature> sts) {
        if (this.stations == null) {
            this.stations = sts;
            this.selectedStations = this.getNamedStations(sts);
        } else {
            int size = sts.size();
            for (int i = 0; i < size; ++i) {
                StationFeature s = sts.get(i);
                if (this.selectedStations.contains(this.getNamedStation(s))) continue;
                this.stations.add(s);
                this.selectedStations.contains(this.getNamedStation(s));
            }
        }
    }

    private void initWPDN(StationProfileFeatureCollection spc, String sname) throws IOException, VisADException {
        List<StationFeature> lstations = spc.getStationFeatures();
        List<NamedStation> lnstations = this.getNamedStations(lstations);
        this.addStations(lstations);
        int size = lstations.size();
        sname = size < 3 ? sname + StringUtil.join(", ", lnstations) : sname + size + " stations";
        this.setName(sname);
        this.setDescription(sname);
        String[] units = new String[6];
        spc.resetIteration();
        boolean j0 = false;
        for (int ii = 0; ii < size; ++ii) {
            StationFeature st = lstations.get(ii);
            StationProfileFeature spf = spc.getStationProfileFeature(st);
            PointFeatureCollectionIterator iter = spf.getPointFeatureCollectionIterator();
            List<CalendarDate> tList = spf.getTimes();
            int tsize = tList.size();
            Vector latVector = new Vector();
            Vector lonVector = new Vector();
            Vector altVector = new Vector();
            Vector timeVector = new Vector();
            Vector<Double> windSpdVector = new Vector<Double>();
            Vector<Double> windDirVector = new Vector<Double>();
            for (int jj = 0; jj < tsize; ++jj) {
                ArrayList<Double> latList = new ArrayList<Double>();
                ArrayList<Double> lonList = new ArrayList<Double>();
                ArrayList<Double> altList = new ArrayList<Double>();
                ArrayList<Double> timeList = new ArrayList<Double>();
                ArrayList<Double> uSpdList = new ArrayList<Double>();
                ArrayList<Double> vSpdList = new ArrayList<Double>();
                CalendarDate cdt = tList.get(jj);
                Date dt = tList.get(jj).toDate();
                DateTime dateTime = new DateTime(dt);
                ProfileFeature pf0 = spf.getProfileByDate(cdt);
                while (pf0.hasNext()) {
                    PointFeature p0 = pf0.next();
                    StructureData sd = p0.getFeatureData();
                    float uspd = sd.convertScalarFloat("uComponent");
                    float vspd = sd.convertScalarFloat("vComponent");
                    if (uspd != -2.1390621E9f && uspd != this.WPDNissing && vspd != -2.1390621E9f && vspd != this.WPDNissing) {
                        latList.add(sd.convertScalarDouble("staLat"));
                        lonList.add(sd.convertScalarDouble("staLon"));
                        altList.add(sd.convertScalarDouble("levels") + sd.convertScalarDouble("staElev"));
                        timeList.add(dateTime.getValue());
                        uSpdList.add(Double.valueOf(uspd));
                        vSpdList.add(Double.valueOf(vspd));
                    }
                    if (ii != 0) continue;
                    units[0] = sd.findMember("staLat").getUnitsString();
                    units[1] = sd.findMember("staLon").getUnitsString();
                    units[2] = "meter";
                    units[3] = dateTime.getUnit().toString();
                    units[4] = sd.findMember("uComponent").getUnitsString();
                    units[5] = "degree";
                }
                FieldImpl dataFieldImpl = null;
                int dsize = latList.size();
                double[][] data = new double[dsize][6];
                for (int i = 0; i < dsize; ++i) {
                    data[i][0] = (Double)latList.get(i);
                    data[i][1] = (Double)lonList.get(i);
                    data[i][2] = (Double)altList.get(i);
                    data[i][3] = (Double)timeList.get(i);
                    data[i][4] = this.getWindSpd((Double)uSpdList.get(i), (Double)vSpdList.get(i));
                    data[i][5] = this.getWindDir((Double)uSpdList.get(i), (Double)vSpdList.get(i));
                    latVector.add(latList.get(i));
                    lonVector.add(lonList.get(i));
                    altVector.add(altList.get(i));
                    timeVector.add(timeList.get(i));
                    windSpdVector.add(data[i][4]);
                    windDirVector.add(data[i][5]);
                }
                Object p0 = null;
                Object pf = null;
                int[] scalingFactors = new int[]{1, 1, 1, 1, 1, 1};
                if (data.length > 0) {
                    dataFieldImpl = this.makeField(data, units, scalingFactors);
                }
                if (dataFieldImpl == null) continue;
                this.times.add(data[0][3]);
                this.allProfiles.add(dataFieldImpl);
            }
            FieldImpl dataFieldImpl = null;
            int dsize = latVector.size();
            double[][] data1 = new double[dsize][6];
            for (int i = 0; i < dsize; ++i) {
                data1[i][0] = (Double)latVector.get(i);
                data1[i][1] = (Double)lonVector.get(i);
                data1[i][2] = (Double)altVector.get(i);
                data1[i][3] = (Double)timeVector.get(i);
                data1[i][4] = (Double)windSpdVector.get(i);
                data1[i][5] = (Double)windDirVector.get(i);
            }
            int[] scalingFactors = new int[]{1, 1, 1, 1, 1, 1};
            if (data1.length > 0) {
                dataFieldImpl = this.makeField(data1, units, scalingFactors);
            }
            if (dataFieldImpl == null) continue;
            if (this.stationsToProfiles.get(st.getName()) == null) {
                ArrayList alist = new ArrayList();
                this.stationsToProfiles.put(st.getName(), alist);
            }
            this.stationsToProfiles.get(st.getName()).add(dataFieldImpl);
        }
    }

    private List getProfileIds(StandardProfileCollectionImpl spc) throws IOException {
        ArrayList<String> pIds = new ArrayList<String>();
        ArrayList beans = new ArrayList();
        for (ProfileFeature profile : spc) {
            CDMProfileFeatureTypeInfo.ProfileFeatureBean bean = new CDMProfileFeatureTypeInfo.ProfileFeatureBean(profile);
            pIds.add(bean.getName());
            this.beanCache.put(bean.getName(), bean);
        }
        return pIds;
    }

    private void initWPDNOld(StandardProfileCollectionImpl spc, String name) throws IOException, VisADException {
        this.profileIds = this.getProfileIds(spc);
        this.selectedStations = this.getNamedStations1(this.profileIds);
        int size = this.profileIds.size();
        name = size < 3 ? name + StringUtil.join(", ", this.selectedStations) : name + size + " stations";
        this.setName(name);
        this.setDescription(name);
        String[] units = new String[6];
        spc.resetIteration();
        for (int ii = 0; ii < size; ++ii) {
            String st = (String)this.profileIds.get(ii);
            CDMProfileFeatureTypeInfo.ProfileFeatureBean bean = this.beanCache.get(st);
            ProfileFeature profileFeature = bean.pfc;
            ArrayList<Double> latList = new ArrayList<Double>();
            ArrayList<Double> lonList = new ArrayList<Double>();
            ArrayList<Double> altList = new ArrayList<Double>();
            ArrayList<Double> timeList = new ArrayList<Double>();
            ArrayList<Double> uSpdList = new ArrayList<Double>();
            ArrayList<Double> vSpdList = new ArrayList<Double>();
            for (PointFeature pf : profileFeature) {
                CalendarDate dt = pf.getObservationTimeAsCalendarDate();
                StructureData sd = pf.getFeatureData();
                float uspd = sd.convertScalarFloat("uComponent");
                float vspd = sd.convertScalarFloat("vComponent");
                if (uspd != -2.1390621E9f && uspd != this.WPDNissing && vspd != -2.1390621E9f && vspd != this.WPDNissing) {
                    latList.add(pf.getLocation().getLatitude());
                    lonList.add(pf.getLocation().getLongitude());
                    altList.add(pf.getLocation().getAltitude());
                    timeList.add(pf.getObservationTime());
                    uSpdList.add(Double.valueOf(uspd));
                    vSpdList.add(Double.valueOf(vspd));
                }
                if (ii != 0) continue;
                units[0] = "degrees_north";
                units[1] = "degrees_east";
                units[2] = "km";
                units[3] = dt.getTimeUnits();
                units[4] = "knots";
                units[5] = "degree_N";
            }
            FieldImpl dataFieldImpl = null;
            int dsize = latList.size();
            double[][] data = new double[dsize][6];
            for (int i = 0; i < dsize; ++i) {
                data[i][0] = (Double)latList.get(i);
                data[i][1] = (Double)lonList.get(i);
                data[i][2] = (Double)altList.get(i);
                data[i][3] = (Double)timeList.get(i);
                data[i][4] = this.getWindSpd((Double)uSpdList.get(i), (Double)vSpdList.get(i));
                data[i][5] = this.getWindDir((Double)uSpdList.get(i), (Double)vSpdList.get(i));
            }
            Object p0 = null;
            Object pf = null;
            int[] scalingFactors = new int[]{1, 1, 1, 1, 1, 1};
            dataFieldImpl = this.makeField(data, units, scalingFactors);
            if (dataFieldImpl == null) continue;
            if (this.stationsToProfiles.get(st) == null) {
                ArrayList alist = new ArrayList();
                this.stationsToProfiles.put(st, alist);
            }
            this.stationsToProfiles.get(st).add(dataFieldImpl);
        }
    }

    private double getWindSpd(double u, double v) {
        return Math.sqrt(u * u + v * v);
    }

    private double getWindDir(double windU, double windV) {
        double a = windU / windV;
        double per = 57.29577951308232;
        int tita = 0;
        if (windV >= 0.0) {
            tita = 180;
        } else if (windV < 0.0 && windU < 0.0) {
            tita = 0;
        } else if (windU >= 0.0 && windV < 0.0) {
            tita = 360;
        }
        return Math.atan(a) * per + (double)tita;
    }

    private void initMadis(StationProfileFeatureCollection spc, String name) throws IOException, VisADException {
        this.stations = spc.getStationFeatures();
        this.selectedStations = this.getNamedStations(this.stations);
        int size = this.stations.size();
        name = size < 3 ? name + StringUtil.join(", ", this.selectedStations) : name + " " + size + " stations";
        this.setName(name);
        this.setDescription(name);
        String[] units = new String[6];
        spc.resetIteration();
        boolean j0 = false;
        for (int ii = 0; ii < size; ++ii) {
            StationFeature st = this.stations.get(ii);
            StationProfileFeature spf = spc.getStationProfileFeature(st);
            PointFeatureCollectionIterator iter = spf.getPointFeatureCollectionIterator();
            List<CalendarDate> tList = spf.getTimes();
            int tsize = tList.size();
            Vector latVector = new Vector();
            Vector lonVector = new Vector();
            Vector altVector = new Vector();
            Vector timeVector = new Vector();
            Vector windSpdVector = new Vector();
            Vector windDirVector = new Vector();
            for (int jj = 0; jj < tsize; ++jj) {
                ArrayList<Double> latList = new ArrayList<Double>();
                ArrayList<Double> lonList = new ArrayList<Double>();
                ArrayList<Double> altList = new ArrayList<Double>();
                ArrayList<Double> timeList = new ArrayList<Double>();
                ArrayList<Double> windSpdList = new ArrayList<Double>();
                ArrayList<Double> windDirList = new ArrayList<Double>();
                CalendarDate dt = tList.get(jj);
                DateTime dateTime = new DateTime(dt.toDate());
                ProfileFeature pf0 = spf.getProfileByDate(dt);
                while (pf0.hasNext()) {
                    PointFeature p0 = pf0.next();
                    StructureData sd = p0.getFeatureData();
                    float spd = sd.convertScalarFloat("windSpeed");
                    float dir = sd.convertScalarFloat("windDir");
                    if (spd != -2.1390621E9f && spd != this.CAPMissing && dir != -2.1390621E9f && dir != this.CAPMissing) {
                        latList.add(sd.convertScalarDouble("latitude"));
                        lonList.add(sd.convertScalarDouble("longitude"));
                        altList.add(sd.convertScalarDouble("levels") + st.getAltitude());
                        timeList.add(dateTime.getValue());
                        windSpdList.add(sd.convertScalarDouble("windSpeed"));
                        windDirList.add(sd.convertScalarDouble("windDir"));
                    }
                    if (ii != 0) continue;
                    units[0] = sd.findMember("latitude").getUnitsString();
                    units[1] = sd.findMember("longitude").getUnitsString();
                    units[2] = sd.findMember("levels").getUnitsString();
                    units[3] = dateTime.getUnit().toString();
                    units[4] = sd.findMember("windSpeed").getUnitsString();
                    units[5] = sd.findMember("windDir").getUnitsString();
                }
                FieldImpl dataFieldImpl = null;
                int dsize = latList.size();
                double[][] data = new double[dsize][6];
                for (int i = 0; i < dsize; ++i) {
                    data[i][0] = (Double)latList.get(i);
                    data[i][1] = (Double)lonList.get(i);
                    data[i][2] = (Double)altList.get(i);
                    data[i][3] = (Double)timeList.get(i);
                    data[i][4] = (Double)windSpdList.get(i);
                    data[i][5] = (Double)windDirList.get(i);
                    latVector.add(latList.get(i));
                    lonVector.add(lonList.get(i));
                    altVector.add(altList.get(i));
                    timeVector.add(timeList.get(i));
                    windSpdVector.add(windSpdList.get(i));
                    windDirVector.add(windDirList.get(i));
                }
                Object p0 = null;
                Object pf = null;
                int[] scalingFactors = new int[]{1, 1, 1, 1, 1, 1};
                if (data.length > 0) {
                    dataFieldImpl = this.makeField(data, units, scalingFactors);
                }
                if (dataFieldImpl == null) continue;
                this.times.add(data[0][3]);
                this.allProfiles.add(dataFieldImpl);
            }
            FieldImpl dataFieldImpl = null;
            int dsize = latVector.size();
            double[][] data1 = new double[dsize][6];
            for (int i = 0; i < dsize; ++i) {
                data1[i][0] = (Double)latVector.get(i);
                data1[i][1] = (Double)lonVector.get(i);
                data1[i][2] = (Double)altVector.get(i);
                data1[i][3] = (Double)timeVector.get(i);
                data1[i][4] = (Double)windSpdVector.get(i);
                data1[i][5] = (Double)windDirVector.get(i);
            }
            int[] scalingFactors = new int[]{1, 1, 1, 1, 1, 1};
            if (data1.length > 0) {
                dataFieldImpl = this.makeField(data1, units, scalingFactors);
            }
            if (dataFieldImpl == null) continue;
            if (this.stationsToProfiles.get(st.getName()) == null) {
                ArrayList alist = new ArrayList();
                this.stationsToProfiles.put(st.getName(), alist);
            }
            this.stationsToProfiles.get(st.getName()).add(dataFieldImpl);
        }
    }

    RealType[] getTypes(String[] units) {
        int numParams = this.params.length;
        RealType[] types = new RealType[numParams];
        for (int i = 0; i < numParams; ++i) {
            String name = this.params[i];
            Unit unit = DataUtil.parseUnit(units[i]);
            types[i] = DataUtil.makeRealType(name, unit);
        }
        return types;
    }

    private FieldImpl makeField(double[][] data, String[] units, int[] scalingFactors) throws VisADException {
        TupleType rangeType;
        FieldImpl field = null;
        boolean debug = false;
        int numObs = data.length;
        if (numObs == 0) {
            throw new VisADException("No data available");
        }
        if (debug) {
            System.out.println("Number of observations = " + numObs);
        }
        RealType domainType = RealType.getRealType("index");
        Integer1DSet domain = new Integer1DSet((MathType)domainType, numObs);
        MetUnits unitTranslator = new MetUnits();
        int numParams = this.params.length;
        if (debug) {
            System.out.println("Number of parameters = " + numParams);
        }
        Unit[] defaultUnits = new Unit[numParams];
        Vector<Unit> usedUnits = new Vector<Unit>();
        boolean noText = true;
        for (int i = 0; i < numParams; ++i) {
            Unit unit;
            String name = this.params[i];
            defaultUnits[i] = unit = DataUtil.parseUnit(units[i]);
        }
        if (noText) {
            RealType[] newTypes = new RealType[this.rTypes.length];
            for (int i = 0; i < this.rTypes.length; ++i) {
                newTypes[i] = this.rTypes[i];
            }
            rangeType = new RealTupleType(newTypes);
        } else {
            rangeType = new TupleType(this.rTypes);
        }
        FunctionType functionType = new FunctionType(domainType, rangeType);
        field = new FieldImpl(functionType, domain);
        if (debug) {
            System.out.println("filling in data");
        }
        long millis = System.currentTimeMillis();
        Data[] firstTuple = null;
        Unit[] actualUnits = null;
        for (int i = 0; i < numObs; ++i) {
            Data[] scalars = new Real[numParams];
            for (int j = 0; j < numParams; ++j) {
                double value;
                double d = value = data[i][j] == -2.139062144E9 || data[i][j] == (double)this.CAPMissing ? Double.NaN : data[i][j];
                if (firstTuple == null) {
                    try {
                        scalars[j] = new Real(this.rTypes[j], value, defaultUnits[j]);
                    }
                    catch (VisADException excp) {
                        scalars[j] = new Real(this.rTypes[j], value);
                    }
                    usedUnits.add(((Real)scalars[j]).getUnit());
                    continue;
                }
                scalars[j] = ((Real)firstTuple[j]).cloneButValue(value);
            }
            if (noText && actualUnits == null) {
                actualUnits = new Unit[usedUnits.size()];
                for (int k = 0; k < usedUnits.size(); ++k) {
                    actualUnits[k] = (Unit)usedUnits.get(k);
                }
            }
            try {
                Tuple sample = noText ? new RealTuple((RealTupleType)rangeType, (Real[])scalars, null, actualUnits, false) : new Tuple(rangeType, scalars, false, false);
                field.setSample(i, sample, false, i == 0);
            }
            catch (VisADException e) {
                e.printStackTrace();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (firstTuple != null) continue;
            firstTuple = scalars;
        }
        if (debug) {
            System.out.println("data fill took " + (System.currentTimeMillis() - millis) + " ms");
        }
        return field;
    }

    private float[][] removeMissingHeights(float[][] samples, int altIndex) {
        int i;
        float[][] newSamples = null;
        int[] indices = new int[samples[0].length];
        int counter = 0;
        for (i = 0; i < samples[altIndex].length; ++i) {
            if (Float.isNaN(samples[altIndex][i])) continue;
            indices[counter++] = i;
        }
        if (counter == 0) {
            return newSamples;
        }
        newSamples = new float[samples.length][counter];
        for (i = 0; i < counter; ++i) {
            for (int j = 0; j < samples.length; ++j) {
                newSamples[j][i] = samples[j][indices[i]];
            }
        }
        return newSamples;
    }

    @Override
    public void doMakeDataChoices() {
        Object choice = null;
        List singleDC = DataCategory.parseCategories("PROFILER_ONESTA", false);
        List compositeDC = DataCategory.parseCategories("PROFILER_PLANVIEW;PROFILER_3D", false);
        compositeDC.addAll(singleDC);
        CompositeDataChoice composite = new CompositeDataChoice(this, (Object)"", "Winds", "Profiler winds", compositeDC);
        this.addDataChoice(composite);
        for (int i = 0; i < this.selectedStations.size(); ++i) {
            NamedStation station = this.selectedStations.get(i);
            String stationName = station.getName();
            composite.addDataChoice(new DirectDataChoice(this, station, "winds", stationName, singleDC));
        }
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        boolean singleStation = !(dataChoice instanceof CompositeDataChoice);
        FieldImpl obs = null;
        FieldImpl dataFieldImpl = null;
        if (singleStation) {
            List dataFieldImplList = this.stationsToProfiles.get(dataChoice.toString());
            if (dataFieldImplList.size() > 0) {
                Vector datas = new Vector();
                for (int i = 0; i < dataFieldImplList.size(); ++i) {
                    datas.add(dataFieldImplList.get(i));
                }
                dataFieldImpl = PointObFactory.mergeData(datas);
            }
            obs = this.recastProfilerSingleStationData(dataFieldImpl, 1);
        } else {
            Vector<FieldImpl> datas = new Vector<FieldImpl>();
            Object pda = null;
            int ssize = this.times.size();
            FieldImpl data = null;
            double[] dt = new double[ssize];
            for (int i = 0; i < ssize; ++i) {
                dt[i] = this.times.get(i);
            }
            int[] sortedAzs = QuickSort.sort(dt);
            DateTime[] dts = new DateTime[ssize];
            for (int i = 0; i < ssize; ++i) {
                data = (FieldImpl)this.allProfiles.get(sortedAzs[i]);
                dts[i] = new DateTime(dt[i]);
                if (data == null) continue;
                datas.add(data);
            }
            dataFieldImpl = PointObFactory.mergeData(datas);
            if (data == null) {
                return null;
            }
            obs = this.recastProfilerMultiStationData(dataFieldImpl, 1);
        }
        return obs;
    }

    protected FieldImpl recastProfilerSingleStationData(FieldImpl input, int obInt) throws VisADException {
        FieldImpl retField = null;
        try {
            FlatField onetimeFF;
            FunctionType onetimeFT;
            TupleType rangetype = null;
            Integer1DSet indexSet = null;
            try {
                rangetype = (TupleType)((FunctionType)input.getType()).getRange();
                indexSet = (Integer1DSet)input.getDomainSet();
            }
            catch (ClassCastException ce) {
                throw new IllegalArgumentException("don't know how to convert input to a point ob");
            }
            int timeIndex = rangetype.getIndex(this.rTypes[3].toString());
            boolean hasDayTime = timeIndex != -1;
            boolean hasDateHMS = false;
            if (!hasDayTime && !hasDateHMS) {
                throw new IllegalArgumentException("can't find DateTime components");
            }
            int zIndex = rangetype.getIndex(this.rTypes[2].toString());
            int dirIndex = rangetype.getIndex(this.rTypes[5].toString());
            int spdIndex = rangetype.getIndex(this.rTypes[4].toString());
            int numtimes = 0;
            DateTime dateTime = null;
            Real ctime = new Real(-999.0);
            Real thisgrouptime = new Real(-999.0);
            ArrayList<DateTime> timesList = new ArrayList<DateTime>();
            ArrayList<Real> zsList = new ArrayList<Real>();
            ArrayList<RealTuple> dsList = new ArrayList<RealTuple>();
            ArrayList<FlatField> obFFsList = new ArrayList<FlatField>();
            RealTuple dirspd = null;
            int timecount = 0;
            for (int i = 0; i < indexSet.getLength(); ++i) {
                Real zvalue;
                Tuple ob = (Tuple)input.getSample(i);
                Real thisobstime = (Real)ob.getComponent(3);
                if (thisobstime.getValue() == ctime.getValue()) {
                    zvalue = (Real)ob.getComponent(zIndex);
                    dirspd = new RealTuple(new Real[]{(Real)ob.getComponent(dirIndex), (Real)ob.getComponent(spdIndex)});
                    zsList.add(zvalue);
                    dsList.add(dirspd);
                    continue;
                }
                if (timecount % obInt == 0 && dsList.size() > 0 && dirspd != null) {
                    float[][] zsetfloats = new float[1][zsList.size()];
                    for (int j = 0; j < zsList.size(); ++j) {
                        zsetfloats[0][j] = (float)((Real)zsList.get(j)).getValue();
                    }
                    RealTuple[] ds = new RealTuple[dsList.size()];
                    for (int j = 0; j < dsList.size(); ++j) {
                        ds[j] = (RealTuple)dsList.get(j);
                    }
                    if (zsList.size() != dsList.size()) {
                        System.out.println("  Size mismatch");
                    }
                    TreeMap<Float, RealTuple> sortedlist = new TreeMap<Float, RealTuple>();
                    for (int j = dsList.size() - 1; j >= 0; --j) {
                        sortedlist.put(new Float(zsetfloats[0][j]), ds[j]);
                    }
                    float[][] sortedZ = new float[1][sortedlist.size()];
                    Data[] sortedDS = new RealTuple[sortedlist.size()];
                    Object[] zobjarray = sortedlist.keySet().toArray();
                    for (int j = 0; j < sortedlist.size(); ++j) {
                        sortedZ[0][j] = ((Float)zobjarray[j]).floatValue();
                        sortedDS[j] = (Data)sortedlist.get((Float)zobjarray[j]);
                    }
                    onetimeFT = new FunctionType(RealType.Altitude, sortedDS[0].getType());
                    Gridded1DSet zset = new Gridded1DSet((MathType)RealType.Altitude, sortedZ, sortedZ[0].length);
                    onetimeFF = new FlatField(onetimeFT, zset);
                    onetimeFF.setSamples(sortedDS, false);
                    obFFsList.add(onetimeFF);
                }
                if (obInt != 1 && !thisobstime.toString().equals(thisgrouptime.toString())) {
                    ++timecount;
                    thisgrouptime = thisobstime;
                }
                if (timecount % obInt != 0) continue;
                zsList.clear();
                dsList.clear();
                ctime = thisobstime;
                ++numtimes;
                double time = ((Real)ob.getComponent(timeIndex)).getValue();
                dateTime = new DateTime(time);
                timesList.add(dateTime);
                zvalue = (Real)ob.getComponent(zIndex);
                if (ob.getComponent(dirIndex).isMissing() || ob.getComponent(spdIndex).isMissing()) continue;
                zsList.add(zvalue);
                dirspd = new RealTuple(new Real[]{(Real)ob.getComponent(dirIndex), (Real)ob.getComponent(spdIndex)});
                dsList.add(dirspd);
            }
            if (timecount % obInt == 0 && dirspd != null) {
                float[][] zsetfloats = new float[1][zsList.size()];
                for (int j = 0; j < zsList.size(); ++j) {
                    zsetfloats[0][j] = (float)((Real)zsList.get(j)).getValue();
                }
                RealTuple[] ds = new RealTuple[dsList.size()];
                for (int j = 0; j < dsList.size(); ++j) {
                    ds[j] = (RealTuple)dsList.get(j);
                }
                if (zsList.size() != dsList.size()) {
                    System.out.println("  Size mismatch");
                }
                TreeMap<Float, RealTuple> sortedlist = new TreeMap<Float, RealTuple>();
                for (int j = dsList.size() - 1; j >= 0; --j) {
                    sortedlist.put(new Float(zsetfloats[0][j]), ds[j]);
                }
                float[][] sortedZ = new float[1][sortedlist.size()];
                Data[] sortedDS = new RealTuple[sortedlist.size()];
                Object[] zobjarray = sortedlist.keySet().toArray();
                for (int j = 0; j < sortedlist.size(); ++j) {
                    sortedZ[0][j] = ((Float)zobjarray[j]).floatValue();
                    sortedDS[j] = (Data)sortedlist.get((Float)zobjarray[j]);
                }
                onetimeFT = new FunctionType(RealType.Altitude, sortedDS[0].getType());
                Gridded1DSet zset = new Gridded1DSet((MathType)RealType.Altitude, sortedZ, sortedZ[0].length);
                onetimeFF = new FlatField(onetimeFT, zset);
                onetimeFF.setSamples(sortedDS, false);
                obFFsList.add(onetimeFF);
            }
            double[][] timesetdoubles = new double[1][obFFsList.size()];
            for (int j = 0; j < obFFsList.size(); ++j) {
                timesetdoubles[0][j] = ((DateTime)timesList.get(j)).getReal().getValue();
            }
            QuickSort.sort(timesetdoubles[0]);
            Gridded1DDoubleSet timeset = new Gridded1DDoubleSet((MathType)RealType.Time, timesetdoubles, obFFsList.size());
            retField = new FieldImpl(new FunctionType(((SetType)timeset.getType()).getDomain(), ((FlatField)obFFsList.get(0)).getType()), timeset);
            Data[] obs = new FlatField[obFFsList.size()];
            for (int j = 0; j < obFFsList.size(); ++j) {
                obs[j] = (FlatField)obFFsList.get(j);
            }
            retField.setSamples(obs, false);
        }
        catch (Exception re) {
            throw new VisADException("got Exception " + re);
        }
        return retField;
    }

    protected FieldImpl recastProfilerMultiStationData(FieldImpl input, int obInt) throws VisADException, RemoteException {
        FlatField onetimeFF;
        FunctionType onetimeFT;
        FieldImpl retField = null;
        TupleType rangetype = null;
        Integer1DSet indexSet = null;
        try {
            rangetype = (TupleType)((FunctionType)input.getType()).getRange();
            indexSet = (Integer1DSet)input.getDomainSet();
        }
        catch (ClassCastException ce) {
            throw new IllegalArgumentException("don't know how to convert input to a point ob");
        }
        int timeIndex = rangetype.getIndex(this.rTypes[3].toString());
        boolean hasDayTime = timeIndex != -1;
        boolean hasDateHMS = false;
        if (!hasDayTime && !hasDateHMS) {
            throw new IllegalArgumentException("can't find DateTime components");
        }
        int latIndex = rangetype.getIndex(this.rTypes[0].toString());
        int lonIndex = rangetype.getIndex(this.rTypes[1].toString());
        int zIndex = rangetype.getIndex(this.rTypes[2].toString());
        int dirIndex = rangetype.getIndex(this.rTypes[4].toString());
        int spdIndex = rangetype.getIndex(this.rTypes[5].toString());
        if (zIndex == -1) {
            throw new IllegalArgumentException("can't find Z index");
        }
        int numtimes = 0;
        int timecount = 0;
        DateTime dateTime = null;
        Real cdatetime = null;
        DateTime thisobsdatetime = null;
        DateTime thisgroupdatetime = null;
        ArrayList<DateTime> timesList = new ArrayList<DateTime>();
        ArrayList<Real> zsList = new ArrayList<Real>();
        ArrayList<RealTuple> locList = new ArrayList<RealTuple>();
        ArrayList latList = new ArrayList();
        ArrayList lonList = new ArrayList();
        ArrayList<RealTuple> dsList = new ArrayList<RealTuple>();
        ArrayList<FlatField> obFFsList = new ArrayList<FlatField>();
        RealTuple dirspd = null;
        for (int i = 0; i < indexSet.getLength(); ++i) {
            RealTuple location;
            Real zvalue;
            Tuple ob = (Tuple)input.getSample(i);
            Real thisobstime = (Real)ob.getComponent(timeIndex);
            Real ti = (Real)ob.getComponent(timeIndex);
            thisobsdatetime = new DateTime(ti);
            if (cdatetime != null && thisobsdatetime.getValue() == cdatetime.getValue()) {
                zvalue = (Real)ob.getComponent(zIndex);
                location = new RealTuple(new Real[]{(Real)ob.getComponent(latIndex), (Real)ob.getComponent(lonIndex), (Real)ob.getComponent(zIndex)});
                if (ob.getComponent(dirIndex).isMissing() || ob.getComponent(spdIndex).isMissing()) continue;
                locList.add(location);
                zsList.add(zvalue);
                dirspd = new RealTuple(new Real[]{(Real)ob.getComponent(dirIndex), (Real)ob.getComponent(spdIndex)});
                dsList.add(dirspd);
                continue;
            }
            if (timecount % obInt == 0 && dirspd != null && dsList.size() > 0) {
                float[][] zsetfloats = new float[1][zsList.size()];
                for (int j = 0; j < zsList.size(); ++j) {
                    zsetfloats[0][j] = (float)((Real)zsList.get(j)).getValue();
                }
                Data[] ds = new RealTuple[dsList.size()];
                for (int j = 0; j < dsList.size(); ++j) {
                    ds[j] = (RealTuple)dsList.get(j);
                }
                if (zsList.size() != dsList.size()) {
                    System.out.println("  SIZE mismatch");
                }
                onetimeFT = new FunctionType(RealTupleType.LatitudeLongitudeAltitude, ds[0].getType());
                int numPoints = locList.size();
                float[][] points = new float[3][numPoints];
                for (int curPoint = 0; curPoint < numPoints; ++curPoint) {
                    points[0][curPoint] = (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(0)).getValue();
                    points[1][curPoint] = (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(1)).getValue();
                    points[2][curPoint] = (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(2)).getValue();
                }
                Gridded3DSet locset = new Gridded3DSet((MathType)RealTupleType.LatitudeLongitudeAltitude, points, numPoints);
                onetimeFF = new FlatField(onetimeFT, locset);
                onetimeFF.setSamples(ds, false);
                obFFsList.add(onetimeFF);
            }
            if (obInt != 1 && !thisobsdatetime.equals(thisgroupdatetime)) {
                ++timecount;
                thisgroupdatetime = thisobsdatetime;
            }
            if (timecount % obInt != 0) continue;
            zsList.clear();
            locList.clear();
            dsList.clear();
            cdatetime = thisobsdatetime;
            ++numtimes;
            dateTime = thisobsdatetime;
            timesList.add(dateTime);
            zvalue = (Real)ob.getComponent(zIndex);
            location = new RealTuple(new Real[]{(Real)ob.getComponent(latIndex), (Real)ob.getComponent(lonIndex), (Real)ob.getComponent(zIndex)});
            if (ob.getComponent(dirIndex).isMissing() || ob.getComponent(spdIndex).isMissing()) continue;
            locList.add(location);
            dirspd = new RealTuple(new Real[]{(Real)ob.getComponent(dirIndex), (Real)ob.getComponent(spdIndex)});
            zsList.add(zvalue);
            dsList.add(dirspd);
        }
        if (dirspd != null) {
            float[][] zsetfloats = new float[1][zsList.size()];
            for (int j = 0; j < zsList.size(); ++j) {
                zsetfloats[0][j] = (float)((Real)zsList.get(j)).getValue();
            }
            Data[] ds = new RealTuple[dsList.size()];
            for (int j = 0; j < dsList.size(); ++j) {
                ds[j] = (RealTuple)dsList.get(j);
            }
            if (zsList.size() != dsList.size()) {
                System.out.println("  SIZE mismatch");
            }
            onetimeFT = new FunctionType(RealTupleType.LatitudeLongitudeAltitude, ds[0].getType());
            int numPoints = locList.size();
            float[][] points = new float[3][numPoints];
            for (int curPoint = 0; curPoint < numPoints; ++curPoint) {
                points[0][curPoint] = (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(0)).getValue();
                points[1][curPoint] = (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(1)).getValue();
                points[2][curPoint] = (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(2)).getValue();
            }
            Gridded3DSet locset = new Gridded3DSet((MathType)RealTupleType.LatitudeLongitudeAltitude, points, numPoints);
            onetimeFF = new FlatField(onetimeFT, locset);
            onetimeFF.setSamples(ds, false);
            obFFsList.add(onetimeFF);
        }
        int numFields = obFFsList.size();
        double[][] timesetdoubles = new double[1][numFields];
        for (int j = 0; j < numFields; ++j) {
            timesetdoubles[0][j] = ((DateTime)timesList.get(j)).getReal().getValue();
        }
        if (numFields == 0) {
            throw new IllegalStateException("No fields were found");
        }
        QuickSort.sort(timesetdoubles[0]);
        Gridded1DDoubleSet timeset = new Gridded1DDoubleSet((MathType)RealType.Time, timesetdoubles, numFields);
        retField = new FieldImpl(new FunctionType(((SetType)timeset.getType()).getDomain(), ((FlatField)obFFsList.get(0)).getType()), timeset);
        Data[] obs = new FlatField[numFields];
        for (int j = 0; j < numFields; ++j) {
            obs[j] = (FlatField)obFFsList.get(j);
        }
        retField.setSamples(obs, false);
        return retField;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CDMProfilerDataSource)) {
            return false;
        }
        CDMProfilerDataSource that = (CDMProfilerDataSource)o;
        if (!super.equals(o)) {
            return false;
        }
        return Misc.equals(this.selectedStations, that.selectedStations);
    }

    public int hashCode() {
        return Misc.hashcode(this.location) ^ super.hashCode();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Must supply a file name");
            System.exit(1);
        }
        try {
            CDMProfilerDataSource cDMProfilerDataSource = new CDMProfilerDataSource(null, args[0], null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFileNameOrUrls(List<String> value) {
        this.fileNameOrUrls = value;
    }

    public List<String> getFileNameOrUrls() {
        return this.fileNameOrUrls;
    }

    @Override
    public void getPropertiesComponents(List comps) {
        super.getPropertiesComponents(comps);
        this.locWidget = new LatLonWidget("Lat: ", " Lon: ", " Alt:", null);
        JPanel locPanel = GuiUtils.hbox(new Component[]{GuiUtils.leftCenter(GuiUtils.rLabel("Lat: "), this.locWidget.getLatField()), GuiUtils.leftCenter(GuiUtils.rLabel(" Lon: "), this.locWidget.getLonField()), GuiUtils.leftCenter(GuiUtils.rLabel(" Alt: "), GuiUtils.centerRight(this.locWidget.getAltField(), GuiUtils.cLabel("m")))});
        if (this.location != null) {
            this.locWidget.setLat(this.location.getLatitude().getValue());
            this.locWidget.setLon(this.location.getLongitude().getValue());
            try {
                this.locWidget.setAlt(this.location.getAltitude().getValue(CommonUnit.meter));
            }
            catch (VisADException ve) {
                this.locWidget.setAlt(this.location.getAltitude().getValue());
            }
        }
        comps.add(GuiUtils.filler());
        comps.add(this.getPropertiesHeader("Profiler Location"));
        comps.add(GuiUtils.filler());
        comps.add(GuiUtils.left(locPanel));
    }

    @Override
    public boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        return this.setLocationFromWidgets();
    }

    private boolean setLocationFromWidgets() {
        try {
            double lat = this.locWidget.getLat();
            double lon = this.locWidget.getLon();
            double alt = this.locWidget.getAlt();
            EarthLocationTuple elt = new EarthLocationTuple(lat, lon, alt);
            if (elt.equals(this.location)) {
                return true;
            }
            this.locationSetByUser = true;
            this.location = elt;
        }
        catch (Exception e) {
            return false;
        }
        List l = this.getDataChoices();
        for (int i = 0; i < l.size(); ++i) {
            DataChoice dc = (DataChoice)l.get(i);
            CompositeDataChoice cdc = (CompositeDataChoice)dc;
            List children = cdc.getDataChoices();
            for (int j = 0; j < children.size(); ++j) {
                DataChoice child = (DataChoice)children.get(j);
                child.setId(this.location);
                child.setDescription(this.location.toString());
            }
        }
        this.reloadData();
        return true;
    }
}

