/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.profiler;

import edu.wisc.ssec.mcidas.McIDASUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import ucar.unidata.data.AddeUtil;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.metdata.NamedStation;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded3DSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.QuickSort;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.data.mcidas.PointDataAdapter;

public class AddeProfilerDataSource
extends DataSourceImpl {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(AddeProfilerDataSource.class.getName());
    public static final String PARAMS_ALL = "lat lon day time z dir spd";
    public static final String PARAMS_SINGLE = "time z dir spd day";
    private List selectedStations;
    private String group = "RTPTSRC";
    private String stationName = " ";
    private String stationID = "     ";
    private String selectedId = null;
    private String server = " ";
    private String latitude = " ";
    private String longitude = " ";
    private String elevation = " ";
    private String starttime = " ";
    private String endtime = " ";
    private String interval = " ";
    private int obInt;
    private int numRelativeTimes;
    private String dataSourceInterval;
    private String addeTimeRequest = "0";
    private float zlevel = 3000.0f;
    public static final String PROFILER_NAME = "name";
    public static final String PROFILER_TIMES = "profilertimes";
    public static final String PROFILER_INT = "data_interval";
    public static final String PROFILER_DATAINT = "datasourceinterval";
    public static final String PROFILER_STATIONS = "profilerstations";
    public static final String PROFILER_SERVER = "profilerserver";
    public static final String PROFILER_6MIN = "6 minute";
    public static final String PROFILER_12MIN = "12 minute";
    public static final String PROFILER_30MIN = "30 minute";
    public static final String PROFILER_1HR = "Hourly";
    public static final String PROFILER_SERVER_INT_6MIN = "PROF6MIN";
    public static final String PROFILER_SERVER_INT_HR = "PROFHOURLY";

    public AddeProfilerDataSource() throws VisADException {
    }

    public AddeProfilerDataSource(DataSourceDescriptor descriptor, ArrayList stations, Hashtable properties) throws VisADException {
        super(descriptor, "Profiler ", "", properties);
        String name = "Profiler " + properties.get(PROFILER_INT) + " - ";
        name = stations.size() < 3 ? name + StringUtil.join(", ", stations) : name + stations.size() + " stations";
        this.setName(name);
        this.setDescription(name);
        this.selectedStations = new ArrayList(stations);
        this.initProfiler();
    }

    @Override
    public void initAfterUnpersistence() {
        super.initAfterUnpersistence();
        this.initProfiler();
    }

    private void initProfiler() {
        this.interval = (String)this.getProperty(PROFILER_INT);
        this.dataSourceInterval = (String)this.getProperty(PROFILER_DATAINT);
        this.server = (String)this.getProperty(PROFILER_SERVER);
        this.addeTimeRequest = (String)this.getProperty(PROFILER_TIMES);
        if (this.addeTimeRequest == null) {
            this.addeTimeRequest = "";
        }
        this.obInt = 1;
        if (!this.addeTimeRequest.equals("%relative%")) {
            if (((String)this.getProperty(PROFILER_INT)).equals(PROFILER_30MIN)) {
                this.obInt = 5;
            } else if (((String)this.getProperty(PROFILER_INT)).equals(PROFILER_12MIN)) {
                this.obInt = 2;
            }
        }
    }

    @Override
    public void doMakeDataChoices() {
        Object choice = null;
        List singleDC = DataCategory.parseCategories("PROFILER_ONESTA", false);
        List compositeDC = DataCategory.parseCategories("PROFILER_PLANVIEW;PROFILER_3D", false);
        compositeDC.addAll(singleDC);
        CompositeDataChoice composite = new CompositeDataChoice(this, (Object)"", "Winds", "Profiler winds", compositeDC);
        this.addDataChoice(composite);
        for (int i = 0; i < this.selectedStations.size(); ++i) {
            NamedStation station = (NamedStation)this.selectedStations.get(i);
            this.stationName = station.getName();
            composite.addDataChoice(new DirectDataChoice(this, station, "winds", this.stationName, singleDC));
        }
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        Trace.call1("Profiler.getData");
        FieldImpl data = this.getObs(dataChoice, dataSelection);
        Trace.call2("Profiler.getData");
        return data;
    }

    private String buildUrl(List stations, String params) {
        StringBuffer request = new StringBuffer();
        request.append("adde://");
        request.append(this.server);
        request.append("/pointdata?");
        request.append("group=");
        request.append(this.group);
        request.append("&descr=");
        request.append(this.dataSourceInterval);
        request.append("&select='");
        if (this.addeTimeRequest.length() > 0) {
            request.append(this.addeTimeRequest);
            request.append("; ");
        }
        request.append("ida ");
        for (int i = 0; i < stations.size(); ++i) {
            NamedStation station = (NamedStation)stations.get(i);
            if (i > 0) {
                request.append(",");
            }
            request.append(station.getID().substring(0, 4));
        }
        request.append("'");
        request.append("&param=" + params);
        request.append("&num=all");
        request.append(this.getProperty("misckeywords", "&compress=gzip"));
        return request.toString();
    }

    private FieldImpl getObs(DataChoice dataChoice, DataSelection subset) throws VisADException, RemoteException {
        FieldImpl obs = null;
        boolean singleStation = !(dataChoice instanceof CompositeDataChoice);
        List stationsToUse = singleStation ? Misc.newList(dataChoice.getId()) : new ArrayList(this.selectedStations);
        String paramsToUse = singleStation ? PARAMS_SINGLE : PARAMS_ALL;
        String url = this.buildUrl(stationsToUse, paramsToUse);
        List<String> urls = AddeUtil.generateTimeUrls(this, url, subset);
        FieldImpl data = null;
        Vector<FieldImpl> datas = new Vector<FieldImpl>();
        PointDataAdapter pda = null;
        for (int i = urls.size() - 1; i >= 0; --i) {
            String newUrl = urls.get(i);
            try {
                Trace.call1("new PointDataAdapter", " url:" + newUrl);
                pda = new PointDataAdapter(newUrl, false);
                Trace.call2("new PointDataAdapter");
                Trace.call1("pda.getData");
                data = (FieldImpl)pda.getData();
                if (data != null) {
                    datas.add(data);
                }
                Trace.call2("pda.getData");
                continue;
            }
            catch (VisADException ve) {
                // empty catch block
            }
        }
        data = PointObFactory.mergeData(datas);
        if (data == null) {
            return data;
        }
        Trace.call1("recast");
        obs = singleStation ? AddeProfilerDataSource.recastProfilerSingleStationData(data, this.obInt) : AddeProfilerDataSource.recastProfilerMultiStationData(data, this.obInt);
        Trace.call2("recast");
        return obs;
    }

    protected static FieldImpl recastProfilerSingleStationData(FieldImpl input, int obInt) throws VisADException {
        FieldImpl retField = null;
        try {
            int numFields;
            FlatField onetimeFF;
            FunctionType onetimeFT;
            TupleType rangetype = null;
            Integer1DSet indexSet = null;
            try {
                rangetype = (TupleType)((FunctionType)input.getType()).getRange();
                indexSet = (Integer1DSet)input.getDomainSet();
            }
            catch (ClassCastException ce) {
                throw new IllegalArgumentException("don't know how to convert input to a point ob");
            }
            int dayIndex = rangetype.getIndex("DAY");
            int timeIndex = rangetype.getIndex("TIME");
            boolean hasDayTime = dayIndex != -1 && timeIndex != -1;
            boolean hasDateHMS = false;
            if (!hasDayTime && !hasDateHMS) {
                throw new IllegalArgumentException("can't find DateTime components");
            }
            int zIndex = rangetype.getIndex("Z");
            int dirIndex = rangetype.getIndex("DIR");
            int spdIndex = rangetype.getIndex("SPD");
            if (zIndex == -1) {
                throw new IllegalArgumentException("can't find Z index");
            }
            int numtimes = 0;
            DateTime dateTime = null;
            Real ctime = new Real(-999.0);
            Real thisgrouptime = new Real(-999.0);
            ArrayList<DateTime> timesList = new ArrayList<DateTime>();
            ArrayList<Real> zsList = new ArrayList<Real>();
            ArrayList<RealTuple> dsList = new ArrayList<RealTuple>();
            ArrayList<FlatField> obFFsList = new ArrayList<FlatField>();
            RealTuple dirspd = null;
            int timecount = 0;
            for (int i = 0; i < indexSet.getLength(); ++i) {
                Real zvalue;
                Tuple ob = (Tuple)input.getSample(i);
                Real thisobstime = (Real)ob.getComponent(0);
                if (thisobstime.getValue() == ctime.getValue()) {
                    zvalue = (Real)ob.getComponent(zIndex);
                    zsList.add(zvalue);
                    dirspd = new RealTuple(new Real[]{(Real)ob.getComponent(dirIndex), (Real)ob.getComponent(spdIndex)});
                    dsList.add(dirspd);
                    continue;
                }
                if (timecount % obInt == 0 && dirspd != null) {
                    float[][] zsetfloats = new float[1][zsList.size()];
                    for (int j = 0; j < zsList.size(); ++j) {
                        zsetfloats[0][j] = (float)((Real)zsList.get(j)).getValue();
                    }
                    RealTuple[] ds = new RealTuple[dsList.size()];
                    for (int j = 0; j < dsList.size(); ++j) {
                        ds[j] = (RealTuple)dsList.get(j);
                    }
                    if (zsList.size() != dsList.size()) {
                        System.out.println("  Size mismatch");
                    }
                    TreeMap<Float, RealTuple> sortedlist = new TreeMap<Float, RealTuple>();
                    for (int j = dsList.size() - 1; j >= 0; --j) {
                        sortedlist.put(new Float(zsetfloats[0][j]), ds[j]);
                    }
                    float[][] sortedZ = new float[1][sortedlist.size()];
                    Data[] sortedDS = new RealTuple[sortedlist.size()];
                    Object[] zobjarray = sortedlist.keySet().toArray();
                    for (int j = 0; j < sortedlist.size(); ++j) {
                        sortedZ[0][j] = ((Float)zobjarray[j]).floatValue();
                        sortedDS[j] = (Data)sortedlist.get((Float)zobjarray[j]);
                    }
                    onetimeFT = new FunctionType(RealType.Altitude, sortedDS[0].getType());
                    Gridded1DSet zset = new Gridded1DSet((MathType)RealType.Altitude, sortedZ, sortedZ[0].length);
                    onetimeFF = new FlatField(onetimeFT, zset);
                    onetimeFF.setSamples(sortedDS, false);
                    obFFsList.add(onetimeFF);
                }
                if (obInt != 1 && !thisobstime.toString().equals(thisgrouptime.toString())) {
                    ++timecount;
                    thisgrouptime = thisobstime;
                }
                if (timecount % obInt != 0) continue;
                zsList.clear();
                dsList.clear();
                ctime = thisobstime;
                ++numtimes;
                int day = (int)((Real)ob.getComponent(dayIndex)).getValue();
                int time = (int)((Real)ob.getComponent(timeIndex)).getValue();
                dateTime = new DateTime(McIDASUtil.mcDayTimeToSecs(day, time));
                timesList.add(dateTime);
                zvalue = (Real)ob.getComponent(zIndex);
                zsList.add(zvalue);
                dirspd = new RealTuple(new Real[]{(Real)ob.getComponent(dirIndex), (Real)ob.getComponent(spdIndex)});
                dsList.add(dirspd);
            }
            if (timecount % obInt == 0 && dirspd != null) {
                float[][] zsetfloats = new float[1][zsList.size()];
                for (int j = 0; j < zsList.size(); ++j) {
                    zsetfloats[0][j] = (float)((Real)zsList.get(j)).getValue();
                }
                RealTuple[] ds = new RealTuple[dsList.size()];
                for (int j = 0; j < dsList.size(); ++j) {
                    ds[j] = (RealTuple)dsList.get(j);
                }
                if (zsList.size() != dsList.size()) {
                    System.out.println("  Size mismatch");
                }
                TreeMap<Float, RealTuple> sortedlist = new TreeMap<Float, RealTuple>();
                for (int j = dsList.size() - 1; j >= 0; --j) {
                    sortedlist.put(new Float(zsetfloats[0][j]), ds[j]);
                }
                float[][] sortedZ = new float[1][sortedlist.size()];
                Data[] sortedDS = new RealTuple[sortedlist.size()];
                Object[] zobjarray = sortedlist.keySet().toArray();
                for (int j = 0; j < sortedlist.size(); ++j) {
                    sortedZ[0][j] = ((Float)zobjarray[j]).floatValue();
                    sortedDS[j] = (Data)sortedlist.get((Float)zobjarray[j]);
                }
                onetimeFT = new FunctionType(RealType.Altitude, sortedDS[0].getType());
                Gridded1DSet zset = new Gridded1DSet((MathType)RealType.Altitude, sortedZ, sortedZ[0].length);
                onetimeFF = new FlatField(onetimeFT, zset);
                onetimeFF.setSamples(sortedDS, false);
                obFFsList.add(onetimeFF);
            }
            if ((numFields = obFFsList.size()) == 0) {
                throw new IllegalStateException("No fields were found");
            }
            double[][] timesetdoubles = new double[1][];
            double[] timevals = new double[numFields];
            for (int j = 0; j < numFields; ++j) {
                timevals[j] = ((DateTime)timesList.get(j)).getReal().getValue();
            }
            int[] sortIdx = QuickSort.sort(timevals);
            timesetdoubles[0] = timevals;
            Gridded1DDoubleSet timeset = new Gridded1DDoubleSet((MathType)RealType.Time, timesetdoubles, numFields);
            retField = new FieldImpl(new FunctionType(((SetType)timeset.getType()).getDomain(), ((FlatField)obFFsList.get(0)).getType()), timeset);
            Data[] obs = new FlatField[numFields];
            for (int j = 0; j < numFields; ++j) {
                obs[j] = (FlatField)obFFsList.get(sortIdx[j]);
            }
            retField.setSamples(obs, false);
        }
        catch (Exception re) {
            throw new VisADException("got Exception " + re);
        }
        return retField;
    }

    protected static FieldImpl recastProfilerMultiStationData(FieldImpl input, int obInt) throws VisADException, RemoteException {
        int numFields;
        FlatField onetimeFF;
        FunctionType onetimeFT;
        FieldImpl retField = null;
        TupleType rangetype = null;
        Integer1DSet indexSet = null;
        try {
            rangetype = (TupleType)((FunctionType)input.getType()).getRange();
            indexSet = (Integer1DSet)input.getDomainSet();
        }
        catch (ClassCastException ce) {
            throw new IllegalArgumentException("don't know how to convert input to a point ob");
        }
        int dayIndex = rangetype.getIndex("DAY");
        int timeIndex = rangetype.getIndex("TIME");
        boolean hasDayTime = dayIndex != -1 && timeIndex != -1;
        boolean hasDateHMS = false;
        if (!hasDayTime && !hasDateHMS) {
            throw new IllegalArgumentException("can't find DateTime components");
        }
        int latIndex = rangetype.getIndex(RealType.Latitude);
        int lonIndex = rangetype.getIndex(RealType.Longitude);
        int zIndex = rangetype.getIndex("Z");
        int dirIndex = rangetype.getIndex("DIR");
        int spdIndex = rangetype.getIndex("SPD");
        if (zIndex == -1) {
            throw new IllegalArgumentException("can't find Z index");
        }
        int numtimes = 0;
        int timecount = 0;
        DateTime dateTime = null;
        DateTime cdatetime = null;
        DateTime thisobsdatetime = null;
        DateTime thisgroupdatetime = null;
        ArrayList<DateTime> timesList = new ArrayList<DateTime>();
        ArrayList<Real> zsList = new ArrayList<Real>();
        ArrayList<RealTuple> locList = new ArrayList<RealTuple>();
        ArrayList latList = new ArrayList();
        ArrayList lonList = new ArrayList();
        ArrayList<RealTuple> dsList = new ArrayList<RealTuple>();
        ArrayList<FlatField> obFFsList = new ArrayList<FlatField>();
        RealTuple dirspd = null;
        for (int i = 0; i < indexSet.getLength(); ++i) {
            RealTuple location;
            Real zvalue;
            int time;
            Tuple ob = (Tuple)input.getSample(i);
            Real thisobstime = (Real)ob.getComponent(0);
            int day = (int)((Real)ob.getComponent(dayIndex)).getValue();
            thisobsdatetime = new DateTime(McIDASUtil.mcDayTimeToSecs(day, time = (int)((Real)ob.getComponent(timeIndex)).getValue()));
            if (thisobsdatetime.equals(cdatetime)) {
                zvalue = (Real)ob.getComponent(zIndex);
                zsList.add(zvalue);
                location = new RealTuple(new Real[]{(Real)ob.getComponent(latIndex), (Real)ob.getComponent(lonIndex), (Real)ob.getComponent(zIndex)});
                locList.add(location);
                dirspd = new RealTuple(new Real[]{(Real)ob.getComponent(dirIndex), (Real)ob.getComponent(spdIndex)});
                dsList.add(dirspd);
                continue;
            }
            if (timecount % obInt == 0 && dirspd != null) {
                float[][] zsetfloats = new float[1][zsList.size()];
                for (int j = 0; j < zsList.size(); ++j) {
                    zsetfloats[0][j] = (float)((Real)zsList.get(j)).getValue();
                }
                Data[] ds = new RealTuple[dsList.size()];
                for (int j = 0; j < dsList.size(); ++j) {
                    ds[j] = (RealTuple)dsList.get(j);
                }
                if (zsList.size() != dsList.size()) {
                    System.out.println("  SIZE mismatch");
                }
                onetimeFT = new FunctionType(RealTupleType.LatitudeLongitudeAltitude, ds[0].getType());
                int numPoints = locList.size();
                float[][] points = new float[3][numPoints];
                for (int curPoint = 0; curPoint < numPoints; ++curPoint) {
                    points[0][curPoint] = (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(0)).getValue();
                    points[1][curPoint] = -1.0f * (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(1)).getValue();
                    points[2][curPoint] = (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(2)).getValue();
                }
                Gridded3DSet locset = new Gridded3DSet((MathType)RealTupleType.LatitudeLongitudeAltitude, points, numPoints);
                onetimeFF = new FlatField(onetimeFT, locset);
                onetimeFF.setSamples(ds, false);
                obFFsList.add(onetimeFF);
            }
            if (obInt != 1 && !thisobsdatetime.equals(thisgroupdatetime)) {
                ++timecount;
                thisgroupdatetime = thisobsdatetime;
            }
            if (timecount % obInt != 0) continue;
            zsList.clear();
            locList.clear();
            dsList.clear();
            cdatetime = thisobsdatetime;
            ++numtimes;
            dateTime = thisobsdatetime;
            timesList.add(dateTime);
            zvalue = (Real)ob.getComponent(zIndex);
            zsList.add(zvalue);
            location = new RealTuple(new Real[]{(Real)ob.getComponent(latIndex), (Real)ob.getComponent(lonIndex), (Real)ob.getComponent(zIndex)});
            locList.add(location);
            dirspd = new RealTuple(new Real[]{(Real)ob.getComponent(dirIndex), (Real)ob.getComponent(spdIndex)});
            dsList.add(dirspd);
        }
        if (dirspd != null) {
            float[][] zsetfloats = new float[1][zsList.size()];
            for (int j = 0; j < zsList.size(); ++j) {
                zsetfloats[0][j] = (float)((Real)zsList.get(j)).getValue();
            }
            Data[] ds = new RealTuple[dsList.size()];
            for (int j = 0; j < dsList.size(); ++j) {
                ds[j] = (RealTuple)dsList.get(j);
            }
            if (zsList.size() != dsList.size()) {
                System.out.println("  SIZE mismatch");
            }
            onetimeFT = new FunctionType(RealTupleType.LatitudeLongitudeAltitude, ds[0].getType());
            int numPoints = locList.size();
            float[][] points = new float[3][numPoints];
            for (int curPoint = 0; curPoint < numPoints; ++curPoint) {
                points[0][curPoint] = (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(0)).getValue();
                points[1][curPoint] = -1.0f * (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(1)).getValue();
                points[2][curPoint] = (float)((Real)((RealTuple)locList.get(curPoint)).getComponent(2)).getValue();
            }
            Gridded3DSet locset = new Gridded3DSet((MathType)RealTupleType.LatitudeLongitudeAltitude, points, numPoints);
            onetimeFF = new FlatField(onetimeFT, locset);
            onetimeFF.setSamples(ds, false);
            obFFsList.add(onetimeFF);
        }
        if ((numFields = obFFsList.size()) == 0) {
            throw new IllegalStateException("No fields were found");
        }
        double[][] timesetdoubles = new double[1][];
        double[] timevals = new double[numFields];
        for (int j = 0; j < numFields; ++j) {
            timevals[j] = ((DateTime)timesList.get(j)).getReal().getValue();
        }
        int[] sortIdx = QuickSort.sort(timevals);
        timesetdoubles[0] = timevals;
        Gridded1DDoubleSet timeset = new Gridded1DDoubleSet((MathType)RealType.Time, timesetdoubles, numFields);
        retField = new FieldImpl(new FunctionType(((SetType)timeset.getType()).getDomain(), ((FlatField)obFFsList.get(0)).getType()), timeset);
        Data[] obs = new FlatField[numFields];
        for (int j = 0; j < numFields; ++j) {
            obs[j] = (FlatField)obFFsList.get(sortIdx[j]);
        }
        retField.setSamples(obs, false);
        return retField;
    }

    public void setSelectedStations(List value) {
        this.selectedStations = value;
    }

    public List getSelectedStations() {
        return this.selectedStations;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AddeProfilerDataSource)) {
            return false;
        }
        AddeProfilerDataSource that = (AddeProfilerDataSource)o;
        if (!super.equals(o)) {
            return false;
        }
        return Misc.equals(this.selectedStations, that.selectedStations);
    }

    public int hashCode() {
        return Misc.hashcode(this.selectedStations) ^ super.hashCode();
    }

    @Override
    protected List doMakeDateTimes() {
        ArrayList<TwoFacedObject> timesList = new ArrayList<TwoFacedObject>();
        if (this.getProperty(AddeUtil.ABSOLUTE_TIMES, (Object)null) != null) {
            timesList.addAll((List)this.getProperty(AddeUtil.ABSOLUTE_TIMES));
        } else {
            int[] timeIndices;
            Object tmp = this.getProperty(AddeUtil.NUM_RELATIVE_TIMES, new Integer(0));
            if (tmp instanceof Integer) {
                int numTimes = (Integer)tmp;
                timeIndices = new int[numTimes];
                for (int i = 0; i < numTimes; ++i) {
                    timeIndices[i] = i;
                }
            } else {
                timeIndices = (int[])tmp;
            }
            for (int i = 0; i < timeIndices.length; ++i) {
                String name = timeIndices[i] + "th most recent";
                if (i == 0) {
                    name = "Most recent";
                }
                if (i > 0 && i < DataSource.ordinalNames.length) {
                    name = DataSource.ordinalNames[timeIndices[i]] + " most recent";
                }
                timesList.add(new TwoFacedObject((Object)name, i));
            }
        }
        return timesList;
    }
}

