/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.point.PointDataSource;
import ucar.unidata.data.point.PointObTuple;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.DateUtil;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import visad.Data;
import visad.DateTime;
import visad.DoubleStringTuple;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.SetType;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocationLite;

public class WaterMLDataSource
extends PointDataSource {
    public static final GregorianCalendar calendar = new GregorianCalendar(DateUtil.TIMEZONE_GMT);

    public WaterMLDataSource() throws VisADException {
    }

    public WaterMLDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws Exception {
        super(descriptor, source, "WaterML Point Data", properties);
    }

    @Override
    protected FieldImpl makeObs(DataChoice dataChoice, DataSelection subset, LatLonRect bbox) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyy-MM-dd'T'HH:mm:ss");
        sdf.setTimeZone(DateUtil.TIMEZONE_GMT);
        Element root = XmlUtil.getRoot(this.getFilePath(), this.getClass());
        ArrayList<PointObTuple> obs = new ArrayList<PointObTuple>();
        TupleType allTupleType = null;
        TupleType finalTT = null;
        List timeSeriesNodes = XmlUtil.findChildren(root, "timeSeries");
        for (Element timeSeriesNode : timeSeriesNodes) {
            double latitude = 0.0;
            double longitude = 0.0;
            double altitude = 0.0;
            Element sourceNode = XmlUtil.findChild(timeSeriesNode, "sourceInfo");
            Element geoNode = XmlUtil.findChild(sourceNode, "geoLocation");
            Element dataSetLocationNode = XmlUtil.findChild(sourceNode, "dataSetLocation");
            if (geoNode != null) {
                Element geogNode = XmlUtil.findChild(geoNode, "geogLocation");
                latitude = XmlUtil.getGrandChildValue(geogNode, "latitude", latitude);
                longitude = XmlUtil.getGrandChildValue(geogNode, "longitude", longitude);
            } else if (dataSetLocationNode != null) {
                double south = XmlUtil.getGrandChildValue(dataSetLocationNode, "south", 0.0);
                double north = XmlUtil.getGrandChildValue(dataSetLocationNode, "north", 0.0);
                double east = XmlUtil.getGrandChildValue(dataSetLocationNode, "east", 0.0);
                double west = XmlUtil.getGrandChildValue(dataSetLocationNode, "west", 0.0);
                latitude = south + (north - south) / 2.0;
                longitude = east + (west - east) / 2.0;
            }
            String station = "stn";
            Element variableNode = XmlUtil.findChild(timeSeriesNode, "variable");
            ArrayList<RealType> numericTypes = new ArrayList<RealType>();
            ArrayList<Unit> numericUnits = new ArrayList<Unit>();
            ArrayList<TextType> stringTypes = new ArrayList<TextType>();
            stringTypes.add(TextType.getTextType("Station"));
            String name = XmlUtil.getGrandChildText(variableNode, "variableName");
            String unitName = XmlUtil.getGrandChildText(variableNode, "units");
            Unit unit = DataUtil.parseUnit(unitName);
            numericTypes.add(DataUtil.makeRealType(Util.cleanName(name), unit));
            numericUnits.add(unit);
            Unit[] allUnits = numericUnits.toArray(new Unit[numericUnits.size()]);
            allTupleType = DoubleStringTuple.makeTupleType(numericTypes, stringTypes);
            Element valuesNode = XmlUtil.findChild(timeSeriesNode, "values");
            List valueNodes = XmlUtil.findChildren(valuesNode, "value");
            int cnt = 0;
            for (Element valueNode : valueNodes) {
                PointObTuple pot;
                ++cnt;
                Date date = sdf.parse(XmlUtil.getAttribute(valueNode, "dateTime"));
                EarthLocationLite elt = new EarthLocationLite(new Real(RealType.Latitude, latitude), new Real(RealType.Longitude, longitude), new Real(RealType.Altitude, altitude));
                DateTime dttm = new DateTime(date);
                double value = new Double(XmlUtil.getChildText(valueNode).trim());
                double[] realArray = new double[]{value};
                String[] stringArray = new String[]{station};
                DoubleStringTuple tuple = new DoubleStringTuple(allTupleType, realArray, stringArray, allUnits);
                if (finalTT == null) {
                    pot = new PointObTuple(elt, dttm, tuple);
                    finalTT = Tuple.buildTupleType(pot.getComponents());
                } else {
                    pot = new PointObTuple(elt, dttm, tuple, finalTT, false);
                }
                obs.add(pot);
            }
        }
        Integer1DSet indexSet = new Integer1DSet((MathType)RealType.getRealType("index"), obs.size());
        FieldImpl retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), ((PointObTuple)obs.get(0)).getType()), indexSet);
        Data[] obsArray = obs.toArray(new Data[obs.size()]);
        retField.setSamples(obsArray, false, false);
        return retField;
    }

    @Override
    public void getPropertiesComponents(List comps) {
        super.getPropertiesComponents(comps);
    }

    @Override
    public boolean applyProperties() {
        return super.applyProperties();
    }
}

