/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataManager;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.point.PointDataSource;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.data.point.PointObTuple;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.visad.Util;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DateTime;
import visad.DoubleSet;
import visad.DoubleStringTuple;
import visad.DoubleTuple;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.SingletonSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.text.TextAdapter;
import visad.georef.EarthLocationLite;

public class TextPointDataSource
extends PointDataSource {
    public static final String PROP_HEADER_MAP = "data.textpoint.map";
    public static final String PROP_DATAPROPERTIES = "data.textpoint.dataproperties";
    public static final String PROP_HEADER_EXTRA = "data.textpoint.extra";
    public static final String PROP_HEADER_PARAMS = "data.textpoint.params";
    public static final String PROP_HEADER_SKIP = "data.textpoint.skip";
    public static final String PROP_HEADER_SKIPPATTERN = "data.textpoint.skippattern";
    public static final String PROP_HEADER_BLOB = "data.textpoint.blob";
    public static final String PREF_METADATAMAP = "pref.textpointdatasource.metadatamap.xml";
    private String map;
    private int skipRows = 0;
    private String skipPattern;
    private boolean metaDataOk = false;
    private String params;
    private Real dfltReal;
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(TextPointDataSource.class.getName());
    private String[] timeVars = new String[]{"time_nominal", "time_Nominal", "timeNominal", "timeObs", "obtime", "reportTime", "time", "nominal_time", "Time", "observation_time", "Observation_Time", "datetime", "dttm"};
    private static String[] latVars = new String[]{"Latitude", "latitude", "lat"};
    private static String[] lonVars = new String[]{"Longitude", "longitude", "lon"};
    private static String[] altVars = new String[]{"altitude", "Altitude", "elevation", "Elevation", "Depth"};
    private String[] recNumVars = new String[]{"recNum", "recnum", "index", "Index"};
    List metaDataFields = new ArrayList();
    List paramRows = new ArrayList();
    List extraParamRows = new ArrayList();
    JComponent metaDataComp;
    JComponent metaDataPropertiesWrapper;
    JComponent widgetPanel;
    JRadioButton[] delimiterButtons;
    private JTextField skipPatternFld;
    private JTextField skipCntFld;
    private JButton applyNamesBtn;
    private String groupVarName = null;
    private String lastType = "";
    private String lastLabel = "";
    private Hashtable dataProperties;
    JLabel lineLbl;
    List lines;
    public static final String COMMA_DELIM = ",";
    public static final String SEMICOLON_DELIM = ";";
    public static final String TAB_DELIM = "\t";
    public static final String BLANK_DELIM = " ";
    private static final String COMMA_NAME = "Comma";
    private static final String SEMICOLON_NAME = "Semicolon";
    private static final String TAB_NAME = "Tab";
    private static final String BLANK_NAME = "Space";
    private final String[] delims = new String[]{",", ";", "\t", " "};
    private final String[] delimNames = new String[]{"Comma", "Semicolon", "Tab", "Space"};
    private TextAdapter.StreamProcessor streamProcessor;
    private String delimiter;
    public boolean useDriverTime = false;
    List<String> varNames = new ArrayList<String>();

    public TextPointDataSource() throws VisADException {
        this.init();
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        return !this.isFileBased();
    }

    public void setStreamProcessor(TextAdapter.StreamProcessor streamProcessor) {
        this.streamProcessor = streamProcessor;
    }

    @Override
    public boolean canDoGeoSelection() {
        return true;
    }

    @Override
    protected boolean canDoGeoSelectionStride() {
        return false;
    }

    public TextPointDataSource(String source) throws VisADException {
        this(new DataSourceDescriptor(), source, new Hashtable());
    }

    public TextPointDataSource(DataSourceDescriptor descriptor, List sources, Hashtable properties) throws VisADException {
        super(descriptor, sources, "Text Point Data", properties);
        if (properties != null) {
            this.dataProperties = (Hashtable)properties.get(PROP_DATAPROPERTIES);
        }
    }

    public TextPointDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        super(descriptor, source, "Text Point Data", properties);
        if (properties != null) {
            this.dataProperties = (Hashtable)properties.get(PROP_DATAPROPERTIES);
        }
    }

    public TextPointDataSource(DataSourceDescriptor descriptor, String source, String name, Hashtable properties) throws VisADException {
        super(descriptor, source, name, properties);
        if (properties != null) {
            this.dataProperties = (Hashtable)properties.get(PROP_DATAPROPERTIES);
        }
    }

    @Override
    public FieldImpl makeObs(DataChoice dataChoice, DataSelection subset, LatLonRect bbox) throws Exception {
        Object t = subset.getProperty("Use_Display_Driver_Times");
        if (t instanceof Boolean && !this.useDriverTime) {
            this.useDriverTime = (Boolean)t;
        }
        if (this.useDriverTime) {
            List<DateTime> dt = subset.getTimeDriverTimes();
            subset.setTimes(dt);
        }
        return this.makeObs(dataChoice, subset, bbox, null, false, true);
    }

    @Override
    protected String getSource(DataChoice dataChoice) {
        Object id = dataChoice.getId();
        if (id instanceof String && (id.toString().startsWith("track:") || id.toString().startsWith("pointcloud:"))) {
            return (String)this.sources.get(0);
        }
        return super.getSource(dataChoice);
    }

    private InputStream getInputStream(String contents) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(contents.getBytes());
        block0: for (int i = 0; i < this.skipRows; ++i) {
            int c;
            while (((InputStream)is).available() > 0 && (c = ((InputStream)is).read()) != 10) {
                if (c != 13) continue;
                if (((InputStream)is).available() <= 0) continue block0;
                ((InputStream)is).mark(10);
                c = ((InputStream)is).read();
                if (c == 10) continue block0;
                ((InputStream)is).reset();
                continue block0;
            }
        }
        String extra = this.getProperty(PROP_HEADER_EXTRA, null);
        if (extra != null) {
            // empty if block
        }
        return is;
    }

    public FieldImpl makeObs(DataChoice dataChoice, DataSelection subset, LatLonRect bbox, String trackParam, boolean sampleIt, boolean showAttributeGuiIfNeeded) throws Exception {
        String source = this.getSource(dataChoice);
        source = sampleIt ? source.replace("%maxcount%", "1") : source.replace("%maxcount%", "1000000");
        String contents = this.getContents(source, sampleIt);
        String delim = this.delimiter != null ? this.delimiter : this.getDelimiter(source);
        return this.makeObs(contents, delim, subset, bbox, trackParam, sampleIt, showAttributeGuiIfNeeded);
    }

    protected String getDelimiter(String source) {
        if (source.endsWith(".xls")) {
            return COMMA_DELIM;
        }
        String delim = TextAdapter.getDelimiter(source);
        return delim;
    }

    protected final String getContents(String sourceFile) throws Exception {
        return this.getContents(sourceFile, false);
    }

    protected String getContents(String sourceFile, boolean sampleIt) throws Exception {
        if (sourceFile.endsWith(".xls")) {
            return DataUtil.xlsToCsv(sourceFile);
        }
        return IOUtil.readContents(sourceFile, this.getClass());
    }

    public FieldImpl makeObs(String contents, String delimiter, DataSelection subset, LatLonRect bbox, String trackParam, boolean sampleIt, boolean showAttributeGuiIfNeeded) throws Exception {
        FieldImpl obs = null;
        final ArrayList<Data[]> pointValues = new ArrayList<Data[]>();
        TextAdapter.StreamProcessor streamProcessorToUse = this.streamProcessor;
        if (streamProcessorToUse == null) {
            streamProcessorToUse = new TextAdapter.StreamProcessor(){

                @Override
                public void processValues(Data[] values) {
                    pointValues.add(values);
                }
            };
        }
        if (obs == null) {
            TextAdapter ta = null;
            try {
                String blob;
                String extra = this.getProperty(PROP_HEADER_EXTRA, null);
                if (this.params == null || this.params.length() == 0) {
                    this.params = this.getProperty(PROP_HEADER_PARAMS, null);
                }
                if (this.map == null || this.map.length() == 0) {
                    this.map = this.getProperty(PROP_HEADER_MAP, null);
                }
                if (this.skipRows == 0) {
                    this.skipRows = this.getProperty(PROP_HEADER_SKIP, this.skipRows);
                }
                if (this.skipPattern == null) {
                    this.skipPattern = this.getProperty(PROP_HEADER_SKIPPATTERN, null);
                    if (this.skipPattern != null && this.skipPattern.length() == 0) {
                        this.skipPattern = null;
                    }
                }
                if ((blob = this.getProperty(PROP_HEADER_BLOB, null)) != null && this.metaDataFields.size() == 0) {
                    Object object = this.getDataContext().getIdv().decodeObject(blob);
                    if (object instanceof List) {
                        object = new Metadata(-1, delimiter, null, (List)object);
                    }
                    Metadata metadata = (Metadata)object;
                    this.metaDataFields = metadata.getItems();
                    this.applySavedMetaData(metadata);
                }
                InputStream inputStream = this.getInputStream(contents);
                long t1 = System.currentTimeMillis();
                ta = new TextAdapter(inputStream, delimiter, this.map, this.params, this.dataProperties, sampleIt, this.skipPattern, streamProcessorToUse);
                long l = System.currentTimeMillis();
            }
            catch (BadFormException bfe) {
                if (this.map != null && this.params != null) {
                    throw bfe;
                }
                if (!showAttributeGuiIfNeeded) {
                    return null;
                }
                if (!this.showAttributeGui(contents)) {
                    this.setInError(true, false, "");
                    return null;
                }
                String delim = this.delimiter != null ? this.delimiter : delimiter;
                ta = new TextAdapter(this.getInputStream(contents), delim, this.map, this.params, this.dataProperties, sampleIt, this.skipPattern, streamProcessorToUse);
            }
            try {
                Field d = ta.getData();
                if (d == null) {
                    if (this.streamProcessor != null) {
                        return null;
                    }
                    if (streamProcessorToUse == null) {
                        throw new IllegalArgumentException("Could not create point data");
                    }
                }
                long t1 = System.currentTimeMillis();
                List<DateTime> tlist = null;
                if (subset != null) {
                    tlist = subset.getTimeDriverTimes();
                }
                obs = streamProcessorToUse != null ? this.makePointObs(pointValues, trackParam, tlist) : this.makePointObs(d, trackParam);
                long t2 = System.currentTimeMillis();
                if (this.fieldsDescription == null && obs != null) {
                    this.makeFieldDescription(obs);
                }
                if (bbox != null) {
                    obs = PointObFactory.subSet(obs, bbox);
                }
                this.metaDataOk = true;
            }
            catch (Exception exc) {
                this.map = null;
                this.params = null;
                throw exc;
            }
        }
        return obs;
    }

    private Data test(String source) throws Exception {
        block2: {
            String contents = IOUtil.readContents(source, this.getClass());
            String delimiter = TextAdapter.getDelimiter(source);
            TextAdapter ta = null;
            long t1 = System.currentTimeMillis();
            ta = new TextAdapter(new ByteArrayInputStream(contents.getBytes()), delimiter, this.map, this.params, this.dataProperties, false);
            Field data = ta.getData();
            int i = 0;
            if (i >= 10) break block2;
            long t2 = System.currentTimeMillis();
            FieldImpl d = this.makePointObs(data, "magnitude");
            long t3 = System.currentTimeMillis();
            System.err.println("time:" + (t3 - t2));
        }
        return null;
    }

    public void changeMetadata() throws IOException {
        try {
            if (this.showAttributeGui(null)) {
                Misc.run(this, "reloadData");
            }
        }
        catch (Exception exc) {
            this.logException("Setting metadata", exc);
        }
    }

    public String getDelimiter() {
        if (this.delimiter != null) {
            return this.delimiter;
        }
        String delim = TextAdapter.getDelimiter(this.getFilePath());
        return delim == null ? COMMA_DELIM : delim;
    }

    public void setDelimiter(String delim) {
        this.delimiter = this.decodeDelimiter(delim);
        if (this.metaDataComp != null) {
            this.updateDelimiterButton(this.delimiter);
            this.setLineText(this.lineLbl, this.skipRows, this.lines);
            this.applySavedMetaData(new Metadata(this.skipRows, this.delimiter, this.skipPattern, this.metaDataFields));
        }
    }

    private void updateDelimiterButton(String delimiter) {
        if (this.delimiterButtons != null) {
            for (int i = 0; i < this.delimiterButtons.length; ++i) {
                JRadioButton btn = this.delimiterButtons[i];
                if (!btn.getText().equals(this.getDelimiterName(delimiter))) continue;
                btn.setSelected(true);
            }
        }
    }

    private String getDelimiterName(String delim) {
        if (delim.equals(COMMA_DELIM)) {
            return COMMA_NAME;
        }
        if (delim.equalsIgnoreCase(SEMICOLON_DELIM)) {
            return SEMICOLON_NAME;
        }
        if (delim.equalsIgnoreCase(TAB_DELIM)) {
            return TAB_NAME;
        }
        if (delim.equalsIgnoreCase(BLANK_DELIM)) {
            return BLANK_NAME;
        }
        return delim;
    }

    private String decodeDelimiter(String delim) {
        if (delim.equals(COMMA_NAME)) {
            return COMMA_DELIM;
        }
        if (delim.equalsIgnoreCase(SEMICOLON_NAME)) {
            return SEMICOLON_DELIM;
        }
        if (delim.equalsIgnoreCase(TAB_NAME)) {
            return TAB_DELIM;
        }
        if (delim.equalsIgnoreCase(BLANK_NAME)) {
            return BLANK_DELIM;
        }
        return delim;
    }

    private void setLineText(JLabel lbl, int index, List lines) {
        ParamRow paramRow;
        if (this.skipCntFld != null) {
            this.skipCntFld.setText("" + index);
        }
        StringBuffer sb = new StringBuffer("<html><body style=\"margin:0;\"><table width=\"100%\" border=\"0\">");
        int[] indices = index == 0 ? new int[]{index, index + 1, index + 2} : new int[]{index - 1, index, index + 1};
        for (int i = 0; i < indices.length; ++i) {
            String line = indices[i] < 0 || indices[i] >= lines.size() ? "&nbsp;" : (String)lines.get(indices[i]);
            sb.append("<tr valign=top><td width=5>");
            if (indices[i] == index) {
                sb.append("<b>&gt;</b></td><td><b><u>" + line + "</u></b></td></tr>");
                continue;
            }
            sb.append("</td><td>" + line + "</td></tr>");
        }
        sb.append("</table>");
        sb.append("</body></html>");
        lbl.setText(sb.toString());
        String line = (String)lines.get(index);
        line = this.cleanLine(line);
        List<String> toks = StringUtil.split(line, this.getDelimiter(), false, false);
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        comps.add(GuiUtils.leftRight(new JLabel("Value"), this.applyNamesBtn));
        comps.add(new JLabel("Name"));
        comps.add(new JLabel("Unit/Date Format"));
        comps.add(new JLabel("Missing Value"));
        comps.add(new JLabel("Extra (e.g., colspan)"));
        for (int i = 0; i < this.paramRows.size(); ++i) {
            paramRow = (ParamRow)this.paramRows.get(i);
            this.extraParamRows.add(0 + i, paramRow);
        }
        this.paramRows = new ArrayList();
        for (int tokIdx = 0; tokIdx < toks.size(); ++tokIdx) {
            paramRow = this.extraParamRows.size() > 0 ? (ParamRow)this.extraParamRows.remove(0) : new ParamRow();
            paramRow.init(tokIdx, toks, comps);
            this.paramRows.add(paramRow);
        }
        this.applySavedMetaData(new Metadata(this.skipRows, this.delimiter, this.skipPattern, this.metaDataFields));
        GuiUtils.tmpInsets = new Insets(5, 5, 0, 0);
        double[] stretch = new double[]{0.0, 1.0, 0.5, 0.0, 0.5};
        JPanel panel = GuiUtils.doLayout(comps, 5, stretch, GuiUtils.WT_N);
        this.widgetPanel.removeAll();
        JScrollPane widgetSP = GuiUtils.makeScrollPane(GuiUtils.top(GuiUtils.inset((Component)panel, 5)), 200, 200);
        widgetSP.setPreferredSize(new Dimension(200, 200));
        this.widgetPanel.add("Center", widgetSP);
    }

    private String cleanLine(String line) {
        if (this.getDelimiter().equals(BLANK_DELIM)) {
            line = line.replaceAll("\\s++", BLANK_DELIM).trim();
        }
        return line;
    }

    public void applyNames(String line) {
        List<String> toks = StringUtil.split(line, this.getDelimiter(), false, false);
        for (int i = 0; i < this.paramRows.size() && i < toks.size(); ++i) {
            ParamRow paramRow = (ParamRow)this.paramRows.get(i);
            paramRow.setName(toks.get(i));
        }
    }

    private JComponent getMetaDataComponent(String contents) throws IOException {
        if (this.metaDataComp == null) {
            String line;
            if (contents == null) {
                contents = IOUtil.readContents(this.getFilePath(), this.getClass());
            }
            BufferedReader bis = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(contents.getBytes())));
            this.lines = new ArrayList();
            for (int i = 0; i < 100 && (line = bis.readLine()) != null; ++i) {
                line = this.cleanLine(line);
                List<String> toks = StringUtil.split(line, this.getDelimiter(), false, false);
                this.lines.add(line);
            }
            this.lineLbl = new JLabel(BLANK_DELIM);
            this.lineLbl.setVerticalAlignment(1);
            this.lineLbl.setPreferredSize(new Dimension(700, 150));
            this.applyNamesBtn = GuiUtils.getImageButton("/auxdata/ui/icons/HorArrow16.gif", this.getClass());
            this.applyNamesBtn.setToolTipText("Use column values as the field names");
            this.applyNamesBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TextPointDataSource.this.applyNames(TextPointDataSource.this.cleanLine(TextPointDataSource.this.lines.get(TextPointDataSource.this.skipRows).toString()));
                }
            });
            JButton nextBtn = GuiUtils.getImageButton("/auxdata/ui/icons/Down.gif", this.getClass());
            JButton prevBtn = GuiUtils.getImageButton("/auxdata/ui/icons/Up.gif", this.getClass());
            nextBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TextPointDataSource.this.skipRows++;
                    if (TextPointDataSource.this.skipRows >= TextPointDataSource.this.lines.size()) {
                        TextPointDataSource.this.skipRows = TextPointDataSource.this.lines.size() - 1;
                    }
                    TextPointDataSource.this.setLineText(TextPointDataSource.this.lineLbl, TextPointDataSource.this.skipRows, TextPointDataSource.this.lines);
                }
            });
            prevBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TextPointDataSource.this.skipRows--;
                    if (TextPointDataSource.this.skipRows < 0) {
                        TextPointDataSource.this.skipRows = 0;
                    }
                    TextPointDataSource.this.setLineText(TextPointDataSource.this.lineLbl, TextPointDataSource.this.skipRows, TextPointDataSource.this.lines);
                }
            });
            JPanel buttons = GuiUtils.vbox(prevBtn, nextBtn);
            JPanel skipInner = GuiUtils.leftCenter(GuiUtils.top(buttons), this.lineLbl);
            this.delimiterButtons = this.makeDelimiterButtons();
            this.skipCntFld = new JTextField("", 4);
            this.skipPatternFld = new JTextField(this.skipPattern != null ? this.skipPattern : "", 20);
            this.skipPatternFld.setToolTipText("Pattern to use to skip lines");
            JPanel topComp = GuiUtils.vbox(GuiUtils.hbox(new JLabel("Delimiter: "), GuiUtils.flow(this.delimiterButtons)), GuiUtils.hbox(new JLabel("Skip Pattern: "), this.skipPatternFld), new JLabel("Start line:"));
            topComp = GuiUtils.leftRight(topComp, GuiUtils.filler());
            JPanel skipContents = GuiUtils.topCenter(topComp, skipInner);
            this.widgetPanel = new JPanel(new BorderLayout());
            JLabel lbl = new JLabel("Enter the field names and units. Leave name field blank to skip the field    ");
            JPanel wrapper = new JPanel(new BorderLayout());
            JButton saveBtn = GuiUtils.makeButton("Preferences", this, "popupMetaDataMenu", wrapper);
            wrapper.add("Center", saveBtn);
            this.metaDataComp = GuiUtils.topCenter(GuiUtils.vbox((Component)skipContents, GuiUtils.leftRight(lbl, GuiUtils.right(wrapper))), this.widgetPanel);
            this.metaDataComp = GuiUtils.inset((Component)this.metaDataComp, 5);
            this.setLineText(this.lineLbl, this.skipRows, this.lines);
        }
        return this.metaDataComp;
    }

    private JRadioButton[] makeDelimiterButtons() {
        ButtonGroup bg = new ButtonGroup();
        int numBtns = this.delimNames.length;
        JRadioButton[] btns = new JRadioButton[numBtns];
        for (int i = 0; i < numBtns; ++i) {
            JRadioButton btn = new JRadioButton(this.delimNames[i], this.getDelimiter().equals(this.delims[i]));
            bg.add(btn);
            final int myIndex = i;
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JRadioButton btn = (JRadioButton)ae.getSource();
                    if (btn.isSelected()) {
                        TextPointDataSource.this.setDelimiter(TextPointDataSource.this.delims[myIndex]);
                    }
                }
            });
            btns[i] = btn;
        }
        return btns;
    }

    private Hashtable<String, Metadata> getMetaDataMap() {
        Hashtable tmp = (Hashtable)this.getDataContext().getIdv().getStore().getEncodedFile(PREF_METADATAMAP);
        if (tmp == null) {
            tmp = new Hashtable();
        }
        Hashtable<String, Metadata> pointMetaDataMap = new Hashtable<String, Metadata>();
        Enumeration keys = tmp.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = tmp.get(key);
            if (value instanceof List) {
                value = new Metadata(-1, this.delimiter, null, (List)value);
            }
            pointMetaDataMap.put(key, (Metadata)value);
        }
        return pointMetaDataMap;
    }

    public void deleteMetaData(String key) {
        Hashtable<String, Metadata> pointMetaDataMap = this.getMetaDataMap();
        pointMetaDataMap.remove(key);
        this.getDataContext().getIdv().getStore().putEncodedFile(PREF_METADATAMAP, pointMetaDataMap);
    }

    public void writePlugin() {
        try {
            JTextField typeFld = new JTextField(this.lastType, 30);
            JTextField labelFld = new JTextField(this.lastLabel, 30);
            JCheckBox trajectoryCbx = new JCheckBox("Is trajectory data", false);
            JComponent contents = GuiUtils.formLayout(new Object[]{"Type:", typeFld, "Label:", labelFld, new JLabel(""), trajectoryCbx});
            if (!GuiUtils.showOkCancelDialog(null, "Data Source Type Plugin", contents, null)) {
                return;
            }
            this.lastType = typeFld.getText().trim();
            this.lastLabel = labelFld.getText().trim();
            String[] tmp = this.makeMetadataHeader();
            if (tmp == null) {
                return;
            }
            String trajectory = trajectoryCbx.isSelected() ? "true" : "false";
            String xml = DataManager.getDatasourceXml(this.lastType, this.lastLabel, this.getClass(), Misc.newHashtable(new Object[]{PROP_HEADER_MAP, tmp[0], PROP_HEADER_PARAMS, tmp[1], PROP_HEADER_SKIP, "" + this.skipRows, PROP_HEADER_SKIPPATTERN, this.skipPattern != null ? this.skipPattern : "", "dataistrajectory", trajectory, PROP_HEADER_BLOB, this.getDataContext().getIdv().encodeObject(new Metadata(this.skipRows, this.delimiter, this.skipPattern, this.metaDataFields), false)}), new String[]{"doesmultiples", "true"});
            this.getDataContext().getIdv().getPluginManager().addText(xml, this.lastType + "datasource.xml");
        }
        catch (Exception exc) {
            this.logException("Writing data source type", exc);
        }
    }

    public void writeHeader() {
        try {
            String filename = FileManager.getWriteFile(FileManager.FILTER_TXT, null);
            if (filename == null) {
                return;
            }
            String[] tmp = this.makeMetadataHeader();
            StringBuffer sb = new StringBuffer(tmp[0]);
            sb.append("\n");
            sb.append(tmp[1]);
            IOUtil.writeFile(filename, sb.toString());
        }
        catch (IOException exc) {
            this.logException("Writing header", exc);
        }
    }

    public void popupMetaDataMenu(JComponent near) {
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(GuiUtils.makeMenuItem("Save Currrent", this, "saveMetaDataMap"));
        items.add(GuiUtils.makeMenuItem("Write Header", this, "writeHeader"));
        items.add(GuiUtils.makeMenuItem("Write Data Source Plugin", this, "writePlugin"));
        Hashtable<String, Metadata> pointMetaDataMap = this.getMetaDataMap();
        if (pointMetaDataMap.size() > 0) {
            ArrayList<JMenuItem> delitems = new ArrayList<JMenuItem>();
            items.add("separator");
            Enumeration<String> keys = pointMetaDataMap.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                Metadata metadata = pointMetaDataMap.get(key);
                items.add(GuiUtils.makeMenuItem(key, this, "applySavedMetaDataFromUI", metadata));
                delitems.add(GuiUtils.makeMenuItem(key, this, "deleteMetaData", key));
            }
            items.add(GuiUtils.makeMenu("Delete", delitems));
        }
        GuiUtils.showPopupMenu(items, near);
    }

    public void saveMetaDataMap() {
        Hashtable<String, Metadata> pointMetaDataMap = this.getMetaDataMap();
        Vector<String> items = new Vector<String>();
        items.add("");
        Enumeration<String> keys = pointMetaDataMap.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            items.add(key);
        }
        JComboBox box = new JComboBox(items);
        box.setEditable(true);
        if (!GuiUtils.showOkCancelDialog(null, "Saved Meta Data", GuiUtils.inset((Component)GuiUtils.hbox(new JLabel("Name: "), box), 5), null)) {
            return;
        }
        String prefname = box.getSelectedItem().toString().trim();
        ArrayList metaDataFields = new ArrayList();
        String delimiter = this.getDelimiter();
        for (int i = 0; i < this.paramRows.size(); ++i) {
            ParamRow paramRow = (ParamRow)this.paramRows.get(i);
            paramRow.addToMetaData(metaDataFields);
        }
        String tmpSkipPattern = this.skipPatternFld.getText().trim();
        pointMetaDataMap.put(prefname, new Metadata(this.skipRows, delimiter, tmpSkipPattern, metaDataFields));
        this.getDataContext().getIdv().getStore().putEncodedFile(PREF_METADATAMAP, pointMetaDataMap);
    }

    private boolean showAttributeGui(String contents) throws IOException {
        JComponent metaDataComp = this.getMetaDataComponent(contents);
        boolean ok = GuiUtils.showOkCancelDialog(null, "Point Data", metaDataComp, null);
        if (this.metaDataPropertiesWrapper != null) {
            this.metaDataPropertiesWrapper.add("Center", metaDataComp);
        }
        if (!ok) {
            return false;
        }
        this.applyMetaDataFields();
        return true;
    }

    @Override
    public boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        if (this.map != null) {
            this.applyMetaDataFields();
            this.flushCache();
        }
        return true;
    }

    @Override
    public void addPropertiesTabs(JTabbedPane tabbedPane) {
        super.addPropertiesTabs(tabbedPane);
        if (!this.metaDataOk && this.map == null) {
            try {
                DataChoice dataChoice = (DataChoice)this.getDataChoices().get(0);
                if (!this.getMakeGridFields()) {
                    FieldImpl fieldImpl = this.makeObs(dataChoice, null, null, null, true, false);
                }
            }
            catch (Exception dataChoice) {
                // empty catch block
            }
        }
        if (!this.metaDataOk || this.map != null) {
            try {
                JComponent comp = this.getMetaDataComponent(null);
                this.metaDataPropertiesWrapper = GuiUtils.center(comp);
                tabbedPane.add("Point Meta-data", this.metaDataPropertiesWrapper);
            }
            catch (IOException exc) {
                this.logException("Creating metadata properties", exc);
            }
        }
    }

    private void applyMetaDataFields() {
        String[] tmp = this.makeMetadataHeader();
        this.map = tmp[0];
        this.params = tmp[1];
    }

    private String[] makeMetadataHeader() {
        if (this.skipPatternFld != null) {
            this.skipPattern = this.skipPatternFld.getText().trim();
        }
        String map = "(index)->(";
        String params = "";
        int cnt = 0;
        this.metaDataFields = new ArrayList();
        String delimiter = this.getDelimiter();
        int skip = 0;
        for (int i = 0; i < this.paramRows.size(); ++i) {
            ParamRow paramRow = (ParamRow)this.paramRows.get(i);
            String unit = paramRow.getUnit();
            String name = paramRow.getCleanName();
            String missing = paramRow.getMissing();
            String extra = paramRow.getExtra();
            ArrayList fields = new ArrayList();
            paramRow.addToMetaData(this.metaDataFields);
            if (skip > 0) {
                --skip;
                continue;
            }
            if (name.length() > 0) {
                if (unit.equals("Text")) {
                    name = name + "(Text)";
                    unit = "";
                }
                if (cnt > 0) {
                    map = map + COMMA_DELIM;
                }
                map = map + name;
                ++cnt;
            } else {
                name = "skip";
            }
            if (unit.equals("Text")) {
                unit = "";
            }
            if (params.length() > 0) {
                params = params + delimiter;
            }
            params = params + name + "[";
            String attrs = "";
            if (name.equals("Time")) {
                if (unit.trim().length() > 0) {
                    attrs = unit.contains("since") ? attrs + "unit=\"" + unit + "\" " : attrs + "fmt=\"" + unit + "\" ";
                }
            } else if (unit.trim().length() > 0) {
                attrs = attrs + "unit=\"" + unit + "\" ";
            }
            if (missing.length() > 0) {
                attrs = attrs + "missing=\"" + missing + "\" ";
            }
            if (extra.length() > 0) {
                attrs = attrs + extra;
                String colspan = StringUtil.findPattern(extra, "colspan *= *\"([^\"]+)\"");
                if (colspan != null) {
                    skip = new Integer(colspan) - 1;
                }
            }
            attrs = attrs.trim();
            params = params + attrs + "]";
        }
        map = map + ")";
        return new String[]{map, params};
    }

    public void applySavedMetaDataFromUI(Metadata metadata) {
        Misc.run(this, "applySavedMetaDataFromUIInner", metadata);
    }

    public void applySavedMetaDataFromUIInner(Metadata metadata) {
        if (metadata.getSkipRows() >= 0) {
            this.skipRows = metadata.getSkipRows();
        }
        if (this.skipPatternFld != null) {
            this.skipPattern = metadata.getSkipPattern();
            this.skipPatternFld.setText(this.skipPattern == null ? "" : this.skipPattern);
        }
        if (metadata.getDelimiter() != null) {
            this.delimiter = metadata.getDelimiter();
            this.updateDelimiterButton(this.delimiter);
        }
        this.setLineText(this.lineLbl, this.skipRows, this.lines);
        this.applySavedMetaData(metadata);
    }

    public void applySavedMetaData(Metadata metadata) {
        List fieldList = metadata.getItems();
        if (metadata.getSkipRows() >= 0) {
            this.skipRows = metadata.getSkipRows();
        }
        if (metadata.getDelimiter() != null) {
            this.delimiter = metadata.getDelimiter();
        }
        for (int tokIdx = 0; tokIdx < this.paramRows.size() && tokIdx < fieldList.size(); ++tokIdx) {
            ParamRow paramRow = (ParamRow)this.paramRows.get(tokIdx);
            paramRow.applyMetaData((List)fieldList.get(tokIdx));
        }
        if (this.metaDataComp != null) {
            this.metaDataComp.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TextPointDataSource)) {
            return false;
        }
        TextPointDataSource that = (TextPointDataSource)o;
        return this == that;
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        return hashCode;
    }

    private FieldImpl makeTrack(int trackParamIndex, int latIndex, int lonIndex, int altIndex, List times, List<Data[]> pointData) throws VisADException, RemoteException {
        float[] lats = new float[times.size()];
        float[] lons = new float[times.size()];
        float[] alts = new float[times.size()];
        Unit timeUnit = ((DateTime)times.get(0)).getUnit();
        Real paramSample = trackParamIndex >= 0 ? (Real)pointData.get(0)[trackParamIndex] : this.getDefaultValue();
        RealType timeType = RealType.getRealType(DataUtil.cleanName("track_time_" + timeUnit), timeUnit);
        RealTupleType rangeType = new RealTupleType(Util.getRealType(paramSample.getUnit()), timeType);
        double[][] newRangeVals = new double[2][times.size()];
        int numObs = times.size();
        for (int i = 0; i < numObs; ++i) {
            DateTime dateTime = (DateTime)times.get(i);
            Data[] tupleData = pointData.get(i);
            Real value = trackParamIndex >= 0 ? (Real)tupleData[trackParamIndex] : this.getDefaultValue();
            newRangeVals[0][i] = value.getValue();
            newRangeVals[1][i] = dateTime.getValue();
            lats[i] = (float)((Real)tupleData[latIndex]).getValue();
            lons[i] = (float)((Real)tupleData[lonIndex]).getValue();
            alts[i] = altIndex >= 0 ? (float)((Real)tupleData[altIndex]).getValue() : 0.0f;
        }
        GriddedSet llaSet = Util.makeEarthDomainSet(lats, lons, alts);
        Set[] rangeSets = new Set[]{new DoubleSet(new SetType(rangeType.getComponent(0))), new DoubleSet(new SetType(rangeType.getComponent(1)))};
        FunctionType newType = new FunctionType(((SetType)llaSet.getType()).getDomain(), rangeType);
        FlatField timeTrack = new FlatField(newType, (Set)llaSet, (CoordinateSystem)null, rangeSets, new Unit[]{paramSample.getUnit(), timeUnit});
        timeTrack.setSamples(newRangeVals, false);
        FunctionType fiType = new FunctionType(RealType.Time, timeTrack.getType());
        DateTime endTime = (DateTime)times.get(0);
        FieldImpl fi = new FieldImpl(fiType, new SingletonSet(new RealTuple(new Real[]{endTime})));
        fi.setSample(0, (Data)timeTrack, false);
        return fi;
    }

    private Real getDefaultValue() throws VisADException {
        if (this.dfltReal == null) {
            RealType dfltRealType = RealType.getRealType("Default");
            this.dfltReal = new Real(dfltRealType, 1.0, CommonUnit.promiscuous);
        }
        return this.dfltReal;
    }

    private FieldImpl makePointObs(Data input, String trackParam) throws VisADException {
        this.varNames = new ArrayList<String>();
        long millis = System.currentTimeMillis();
        FieldImpl retField = null;
        try {
            int i;
            TupleType type;
            DataImpl recNumObs = null;
            MathType inputType = input.getType();
            int recNumIndex = -1;
            RealType recNum = null;
            for (int i2 = 0; i2 < this.recNumVars.length && !MathType.findScalarType(inputType, recNum = RealType.getRealType(this.recNumVars[i2])); ++i2) {
            }
            if (recNum == null) {
                throw new IllegalArgumentException("unable to find index for observations");
            }
            if (input instanceof Tuple) {
                TupleType tt = (TupleType)input.getType();
                for (int i3 = 0; i3 < tt.getDimension(); ++i3) {
                    RealTupleType domType;
                    MathType compType = tt.getComponent(i3);
                    if (!(compType instanceof FunctionType) || (domType = ((FunctionType)compType).getDomain()).getDimension() != 1 || !recNum.equals(domType.getComponent(0))) continue;
                    recNumObs = (FieldImpl)((Tuple)input).getComponent(i3);
                    break;
                }
            } else if (inputType instanceof FunctionType && recNum.equals(((FunctionType)inputType).getDomain().getComponent(0))) {
                recNumObs = (FieldImpl)input;
            }
            if (recNumObs == null) {
                throw new IllegalArgumentException("don't know how to convert input to a point ob");
            }
            Gridded1DSet indexSet = null;
            try {
                type = (TupleType)((FunctionType)recNumObs.getType()).getRange();
                indexSet = (Gridded1DSet)((FieldImpl)recNumObs).getDomainSet();
            }
            catch (ClassCastException ce) {
                throw new IllegalArgumentException("don't know how to convert input to a point ob");
            }
            long mil2 = System.currentTimeMillis();
            DateTime dfltTime = new DateTime(new Date());
            int timeIndex = -1;
            for (int i4 = 0; i4 < this.timeVars.length && (timeIndex = type.getIndex(this.timeVars[i4])) <= -1; ++i4) {
            }
            if (timeIndex == -1) {
                // empty if block
            }
            Real dfltAlt = new Real(RealType.Altitude, 1.0);
            Real dfltReal = this.getDefaultValue();
            TupleType finalTT = null;
            Object dataTupleType = null;
            Object dataUnits = null;
            int[] latLonAltIndices = TextPointDataSource.findLatLonAltIndices(type);
            int latIndex = latLonAltIndices[0];
            int lonIndex = latLonAltIndices[1];
            int altIndex = latLonAltIndices[2];
            if (altIndex >= 0) {
                this.varNames.add("Altitude");
            }
            int trackParamIndex = -1;
            if (trackParam != null) {
                if (trackParam.equals("Altitude")) {
                    trackParamIndex = altIndex;
                } else if (!trackParam.equals("Default") && (trackParamIndex = type.getIndex(trackParam)) == -1) {
                    throw new IllegalArgumentException("Can't find track param");
                }
            }
            if (latIndex == -1 || lonIndex == -1) {
                throw new IllegalArgumentException("can't find lat/lon");
            }
            int numVars = type.getDimension();
            int numNotRequired = numVars - (altIndex != -1 ? 4 : 3);
            int[] notReqIndices = new int[numNotRequired];
            int l = 0;
            for (int i5 = 0; i5 < numVars; ++i5) {
                if (i5 == timeIndex || i5 == latIndex || i5 == lonIndex || i5 == altIndex) continue;
                notReqIndices[l++] = i5;
            }
            int numObs = indexSet.getLength();
            Data[] obs = new PointObTuple[numObs];
            List<DateTime> times = new ArrayList();
            ArrayList<EarthLocationLite> locations = new ArrayList<EarthLocationLite>();
            ArrayList<Data[]> tuples = new ArrayList<Data[]>();
            ArrayList reals = new ArrayList();
            ArrayList strings = new ArrayList();
            boolean[] isVarNumeric = null;
            boolean allReals = true;
            ArrayList<MathType> numericTypes = new ArrayList<MathType>();
            ArrayList<Unit> numericUnits = new ArrayList<Unit>();
            ArrayList<MathType> stringTypes = new ArrayList<MathType>();
            int numReals = 0;
            int numStrings = 0;
            TupleType allTupleType = null;
            Unit[] allUnits = null;
            Data[] prototype = null;
            for (i = 0; i < numObs; ++i) {
                Real alt;
                Tuple tuple;
                DateTime timeVal;
                Tuple ob = (Tuple)((FieldImpl)recNumObs).getSample(i);
                Data[] tupleData = ob.getComponents(false);
                Real real = timeVal = timeIndex == -1 ? dfltTime : (Real)tupleData[timeIndex];
                if (timeVal.getUnit() != null) {
                    times.add(new DateTime(timeVal));
                } else {
                    times.add(new DateTime(timeVal.getValue()));
                }
                if (trackParam != null) continue;
                if (isVarNumeric == null) {
                    Unit[] varUnits;
                    ScalarType[] types;
                    if (numNotRequired > 0) {
                        isVarNumeric = new boolean[numNotRequired];
                        types = new ScalarType[numNotRequired];
                        varUnits = new Unit[numNotRequired];
                        for (int varIdx = 0; varIdx < numNotRequired; ++varIdx) {
                            Data d = tupleData[notReqIndices[varIdx]];
                            types[varIdx] = (ScalarType)d.getType();
                            if (d instanceof Real) {
                                ++numReals;
                                isVarNumeric[varIdx] = true;
                                numericTypes.add(d.getType());
                                varUnits[varIdx] = ((Real)d).getUnit();
                                this.varNames.add(((RealType)d.getType()).getName());
                                numericUnits.add(varUnits[varIdx]);
                                continue;
                            }
                            ++numStrings;
                            isVarNumeric[varIdx] = false;
                            allReals = false;
                            stringTypes.add(d.getType());
                        }
                    } else {
                        isVarNumeric = new boolean[]{true};
                        types = new ScalarType[1];
                        varUnits = new Unit[1];
                        numReals = 1;
                        this.varNames.add(((RealType)dfltReal.getType()).getName());
                        numericTypes.add(dfltReal.getType());
                        varUnits[0] = dfltReal.getUnit();
                        numericUnits.add(varUnits[0]);
                    }
                    allTupleType = allReals ? new RealTupleType(numericTypes.toArray(new RealType[numericTypes.size()])) : DoubleStringTuple.makeTupleType(numericTypes, stringTypes);
                    allUnits = numericUnits.toArray(new Unit[numericUnits.size()]);
                }
                double[] realArray = new double[numReals];
                String[] stringArray = numStrings == 0 ? null : new String[numStrings];
                int stringCnt = 0;
                int realCnt = 0;
                if (numNotRequired > 0) {
                    for (int varIdx = 0; varIdx < numNotRequired; ++varIdx) {
                        Data d = tupleData[notReqIndices[varIdx]];
                        if (!isVarNumeric[varIdx]) {
                            stringArray[stringCnt++] = ((Text)d).getValue();
                            continue;
                        }
                        realArray[realCnt++] = ((Real)d).getValue();
                    }
                } else {
                    realArray[0] = 0.0;
                }
                Tuple tuple2 = tuple = allReals ? new DoubleTuple((RealTupleType)allTupleType, prototype, realArray, allUnits) : new DoubleStringTuple(allTupleType, prototype, realArray, stringArray, allUnits);
                if (prototype == null) {
                    prototype = tuple.getComponents();
                }
                tuples.add((Data[])tuple);
                Real lat = (Real)tupleData[latIndex];
                Real lon = (Real)tupleData[lonIndex];
                Real real2 = alt = altIndex != -1 ? (Real)tupleData[altIndex] : dfltAlt;
                if (!lat.getType().equals(RealType.Latitude) || !lat.getUnit().equals(RealType.Latitude.getDefaultUnit())) {
                    lat = new Real(RealType.Latitude, lat.getValue(RealType.Latitude.getDefaultUnit()));
                }
                if (!lon.getType().equals(RealType.Longitude) || !lon.getUnit().equals(RealType.Longitude.getDefaultUnit())) {
                    lon = new Real(RealType.Longitude, lon.getValue(RealType.Longitude.getDefaultUnit()));
                }
                if (!(altIndex < 0 || alt.getType().equals(RealType.Altitude) && alt.getUnit().equals(RealType.Altitude.getDefaultUnit()))) {
                    alt = new Real(RealType.Altitude, alt.getValue(RealType.Altitude.getDefaultUnit()));
                }
                locations.add(new EarthLocationLite(lat, lon, alt));
            }
            if (trackParam != null) {
                if (this.groupVarName != null && this.groupVarName.length() > 0) {
                    int groupParamIndex = -1;
                    for (int typeIdx = 0; typeIdx < type.getDimension(); ++typeIdx) {
                        String ts = type.getComponent(typeIdx).toString();
                        if (!ts.equals(this.groupVarName) && !ts.equals(this.groupVarName + "(Text)")) continue;
                        groupParamIndex = typeIdx;
                        break;
                    }
                    if (groupParamIndex == -1) {
                        throw new IllegalArgumentException("Can't find group param: " + this.groupVarName);
                    }
                    ArrayList<String> names = new ArrayList<String>();
                    Hashtable seen = new Hashtable();
                    for (int i6 = 0; i6 < numObs; ++i6) {
                        Data[] tupleData = (Data[])tuples.get(i6);
                        String v = tupleData[groupParamIndex].toString();
                        ArrayList<Data[]> dataList = (ArrayList<Data[]>)seen.get(v);
                        ArrayList timeList = (ArrayList)seen.get(v + "_timelist");
                        if (dataList == null) {
                            names.add(v);
                            dataList = new ArrayList<Data[]>();
                            timeList = new ArrayList();
                            seen.put(v, dataList);
                            seen.put(v + "_timelist", timeList);
                        }
                        timeList.add(times.get(i6));
                        dataList.add(tupleData);
                    }
                    ArrayList<FieldImpl> tracks = new ArrayList<FieldImpl>();
                    MathType trackType = null;
                    for (int nameIdx = 0; nameIdx < names.size(); ++nameIdx) {
                        String name = (String)names.get(nameIdx);
                        List dataList = (List)seen.get(name);
                        List timeList = (List)seen.get(name + "_timelist");
                        FieldImpl track = this.makeTrack(trackParamIndex, latIndex, lonIndex, altIndex, timeList, dataList);
                        if (trackType == null) {
                            trackType = track.getType();
                        }
                        tracks.add(track);
                    }
                    TextType textType = TextType.getTextType(this.groupVarName + "_type");
                    TupleType tt = new TupleType(new MathType[]{textType, trackType});
                    Data[] tracksData = new Data[tracks.size()];
                    for (int i7 = 0; i7 < tracks.size(); ++i7) {
                        String name = (String)names.get(i7);
                        Data d = (Data)tracks.get(i7);
                        tracksData[i7] = new Tuple(tt, new Data[]{new Text(textType, name), d});
                    }
                    RealType indexType = RealType.getRealType("index");
                    Linear1DSet domain = new Linear1DSet((MathType)indexType, 0.0, tracks.size() - 1, tracks.size());
                    FunctionType aggregateType = new FunctionType(indexType, tt);
                    FieldImpl aggregateField = new FieldImpl(aggregateType, domain);
                    aggregateField.setSamples(tracksData, false);
                    return aggregateField;
                }
                return this.makeTrack(trackParamIndex, latIndex, lonIndex, altIndex, times, tuples);
            }
            times = PointObFactory.binTimes(times, this.getBinRoundTo(), this.getBinWidth());
            for (i = 0; i < numObs; ++i) {
                DateTime dateTime = (DateTime)times.get(i);
                Data rest = (Data)tuples.get(i);
                EarthLocationLite location = (EarthLocationLite)locations.get(i);
                if (finalTT == null) {
                    PointObTuple pot = new PointObTuple(location, dateTime, rest);
                    obs[i] = pot;
                    finalTT = Tuple.buildTupleType(pot.getComponents());
                    continue;
                }
                obs[i] = new PointObTuple(location, dateTime, rest, finalTT, false);
            }
            retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), obs[0].getType()), indexSet);
            retField.setSamples(obs, false, false);
        }
        catch (RemoteException re) {
            throw new VisADException("got RemoteException " + re);
        }
        return retField;
    }

    private FieldImpl makePointObs(List<Data[]> pointData, String trackParam, List<DateTime> dTimes) throws VisADException {
        FieldImpl retField;
        block46: {
            if (pointData.size() == 0) {
                return null;
            }
            this.varNames = new ArrayList<String>();
            retField = null;
            try {
                int i;
                Data[] input = pointData.get(0);
                TupleType type = Tuple.buildTupleType(input);
                DateTime dfltTime = new DateTime(new Date());
                int timeIndex = -1;
                for (int i2 = 0; i2 < this.timeVars.length && (timeIndex = type.getIndex(this.timeVars[i2])) <= -1; ++i2) {
                }
                if (timeIndex == -1) {
                    // empty if block
                }
                Real dfltAlt = new Real(RealType.Altitude, 1.0);
                Real dfltReal = this.getDefaultValue();
                TupleType finalTT = null;
                Object dataTupleType = null;
                Object dataUnits = null;
                int[] latLonAltIndices = TextPointDataSource.findLatLonAltIndices(type);
                int latIndex = latLonAltIndices[0];
                int lonIndex = latLonAltIndices[1];
                int altIndex = latLonAltIndices[2];
                if (altIndex >= 0) {
                    this.varNames.add("Altitude");
                }
                int trackParamIndex = -1;
                if (trackParam != null) {
                    if (trackParam.equals("Altitude")) {
                        trackParamIndex = altIndex;
                    } else if (!trackParam.equals("Default") && (trackParamIndex = type.getIndex(trackParam)) == -1) {
                        throw new IllegalArgumentException("Can't find track param");
                    }
                }
                if (latIndex == -1 || lonIndex == -1) {
                    throw new IllegalArgumentException("can't find lat/lon");
                }
                int numVars = type.getDimension();
                int numNotRequired = numVars - (altIndex != -1 ? 4 : 3);
                if (timeIndex == -1) {
                    ++numNotRequired;
                }
                int[] notReqIndices = new int[numNotRequired];
                int l = 0;
                for (int i3 = 0; i3 < numVars; ++i3) {
                    if (i3 == timeIndex || i3 == latIndex || i3 == lonIndex || i3 == altIndex) continue;
                    notReqIndices[l++] = i3;
                }
                int numObs = pointData.size();
                Data[] obs = new PointObTuple[numObs];
                List<DateTime> times = new ArrayList();
                ArrayList<EarthLocationLite> locations = new ArrayList<EarthLocationLite>();
                ArrayList<Tuple> tuples = new ArrayList<Tuple>();
                ArrayList reals = new ArrayList();
                ArrayList strings = new ArrayList();
                boolean[] isVarNumeric = null;
                boolean allReals = true;
                ArrayList<MathType> numericTypes = new ArrayList<MathType>();
                ArrayList<Unit> numericUnits = new ArrayList<Unit>();
                ArrayList<MathType> stringTypes = new ArrayList<MathType>();
                int numReals = 0;
                int numStrings = 0;
                TupleType allTupleType = null;
                Unit[] allUnits = null;
                Data[] prototype = null;
                for (i = 0; i < pointData.size(); ++i) {
                    DateTime timeVal;
                    Real alt;
                    Tuple tuple;
                    Data[] tupleData = pointData.get(i);
                    if (isVarNumeric == null) {
                        Unit[] varUnits;
                        ScalarType[] types;
                        if (numNotRequired > 0) {
                            isVarNumeric = new boolean[numNotRequired];
                            types = new ScalarType[numNotRequired];
                            varUnits = new Unit[numNotRequired];
                            for (int varIdx = 0; varIdx < numNotRequired; ++varIdx) {
                                Data d = tupleData[notReqIndices[varIdx]];
                                types[varIdx] = (ScalarType)d.getType();
                                if (d instanceof Real) {
                                    ++numReals;
                                    isVarNumeric[varIdx] = true;
                                    numericTypes.add(d.getType());
                                    varUnits[varIdx] = ((Real)d).getUnit();
                                    this.varNames.add(((RealType)d.getType()).getName());
                                    numericUnits.add(varUnits[varIdx]);
                                    continue;
                                }
                                ++numStrings;
                                isVarNumeric[varIdx] = false;
                                allReals = false;
                                stringTypes.add(d.getType());
                            }
                        } else {
                            isVarNumeric = new boolean[]{true};
                            types = new ScalarType[1];
                            varUnits = new Unit[1];
                            numReals = 1;
                            this.varNames.add(((RealType)dfltReal.getType()).getName());
                            numericTypes.add(dfltReal.getType());
                            varUnits[0] = dfltReal.getUnit();
                            numericUnits.add(varUnits[0]);
                        }
                        allTupleType = allReals ? new RealTupleType(numericTypes.toArray(new RealType[numericTypes.size()])) : DoubleStringTuple.makeTupleType(numericTypes, stringTypes);
                        allUnits = numericUnits.toArray(new Unit[numericUnits.size()]);
                    }
                    double[] realArray = new double[numReals];
                    String[] stringArray = numStrings == 0 ? null : new String[numStrings];
                    int stringCnt = 0;
                    int realCnt = 0;
                    if (numNotRequired > 0) {
                        for (int varIdx = 0; varIdx < numNotRequired; ++varIdx) {
                            Data d = tupleData[notReqIndices[varIdx]];
                            if (!isVarNumeric[varIdx]) {
                                stringArray[stringCnt++] = ((Text)d).getValue();
                                continue;
                            }
                            realArray[realCnt++] = ((Real)d).getValue();
                        }
                    } else {
                        Real alt2 = altIndex != -1 ? (Real)tupleData[altIndex] : dfltAlt;
                        realArray[0] = alt2.getValue(CommonUnit.meter);
                    }
                    Tuple tuple2 = tuple = allReals ? new DoubleTuple((RealTupleType)allTupleType, prototype, realArray, allUnits) : new DoubleStringTuple(allTupleType, prototype, realArray, stringArray, allUnits);
                    if (prototype == null) {
                        prototype = tuple.getComponents();
                    }
                    tuples.add(tuple);
                    Real lat = (Real)tupleData[latIndex];
                    Real lon = (Real)tupleData[lonIndex];
                    Real real = alt = altIndex != -1 ? (Real)tupleData[altIndex] : dfltAlt;
                    if (!lat.getType().equals(RealType.Latitude) || !lat.getUnit().equals(RealType.Latitude.getDefaultUnit())) {
                        lat = new Real(RealType.Latitude, lat.getValue(RealType.Latitude.getDefaultUnit()));
                    }
                    if (!lon.getType().equals(RealType.Longitude) || !lon.getUnit().equals(RealType.Longitude.getDefaultUnit())) {
                        lon = new Real(RealType.Longitude, lon.getValue(RealType.Longitude.getDefaultUnit()));
                    }
                    if (!(altIndex < 0 || alt.getType().equals(RealType.Altitude) && alt.getUnit().equals(RealType.Altitude.getDefaultUnit()))) {
                        alt = new Real(RealType.Altitude, alt.getValue(RealType.Altitude.getDefaultUnit()));
                    }
                    locations.add(new EarthLocationLite(lat, lon, alt));
                    Real real2 = timeVal = timeIndex == -1 ? dfltTime : (Real)tupleData[timeIndex];
                    if (timeVal.getUnit() != null) {
                        times.add(new DateTime(timeVal));
                        continue;
                    }
                    times.add(new DateTime(timeVal.getValue()));
                }
                if (trackParam != null) {
                    if (this.groupVarName != null && this.groupVarName.length() > 0) {
                        int groupParamIndex = -1;
                        for (int typeIdx = 0; typeIdx < type.getDimension(); ++typeIdx) {
                            String ts = type.getComponent(typeIdx).toString();
                            if (!ts.equals(this.groupVarName) && !ts.equals(this.groupVarName + "(Text)")) continue;
                            groupParamIndex = typeIdx;
                            break;
                        }
                        if (groupParamIndex == -1) {
                            throw new IllegalArgumentException("Can't find group param: " + this.groupVarName);
                        }
                        ArrayList<String> names = new ArrayList<String>();
                        Hashtable seen = new Hashtable();
                        for (int i4 = 0; i4 < numObs; ++i4) {
                            Data[] tupleData = pointData.get(i4);
                            String v = tupleData[groupParamIndex].toString();
                            ArrayList<Data[]> dataList = (ArrayList<Data[]>)seen.get(v);
                            ArrayList timeList = (ArrayList)seen.get(v + "_timelist");
                            if (dataList == null) {
                                names.add(v);
                                dataList = new ArrayList<Data[]>();
                                timeList = new ArrayList();
                                seen.put(v, dataList);
                                seen.put(v + "_timelist", timeList);
                            }
                            timeList.add(times.get(i4));
                            dataList.add(tupleData);
                        }
                        ArrayList<FieldImpl> tracks = new ArrayList<FieldImpl>();
                        MathType trackType = null;
                        for (int nameIdx = 0; nameIdx < names.size(); ++nameIdx) {
                            String name = (String)names.get(nameIdx);
                            List dataList = (List)seen.get(name);
                            List timeList = (List)seen.get(name + "_timelist");
                            FieldImpl track = this.makeTrack(trackParamIndex, latIndex, lonIndex, altIndex, timeList, dataList);
                            if (trackType == null) {
                                trackType = track.getType();
                            }
                            tracks.add(track);
                        }
                        TextType textType = TextType.getTextType(this.groupVarName + "_type");
                        TupleType tt = new TupleType(new MathType[]{textType, trackType});
                        Data[] tracksData = new Data[tracks.size()];
                        for (int i5 = 0; i5 < tracks.size(); ++i5) {
                            String name = (String)names.get(i5);
                            Data d = (Data)tracks.get(i5);
                            tracksData[i5] = new Tuple(tt, new Data[]{new Text(textType, name), d});
                        }
                        RealType indexType = RealType.getRealType("index");
                        Linear1DSet domain = new Linear1DSet((MathType)indexType, 0.0, tracks.size() - 1, tracks.size());
                        FunctionType aggregateType = new FunctionType(indexType, tt);
                        FieldImpl aggregateField = new FieldImpl(aggregateType, domain);
                        aggregateField.setSamples(tracksData, false);
                        return aggregateField;
                    }
                    return this.makeTrack(trackParamIndex, latIndex, lonIndex, altIndex, times, pointData);
                }
                times = PointObFactory.binTimes(times, this.getBinRoundTo(), this.getBinWidth());
                if (dTimes != null) {
                    int jj = 0;
                    PointObTuple[] obs0 = new PointObTuple[numObs];
                    List<DateTime> matches = null;
                    try {
                        matches = DataUtil.selectTimesFromList(times, dTimes);
                    }
                    catch (Exception tracks) {
                        // empty catch block
                    }
                    if (matches == null || matches.size() == 0) {
                        throw new IllegalStateException("Could not match the driver times");
                    }
                    for (int i6 = 0; i6 < numObs; ++i6) {
                        DateTime sDate = (DateTime)times.get(i6);
                        if (!matches.contains(sDate)) continue;
                        Data rest = (Data)tuples.get(i6);
                        EarthLocationLite location = (EarthLocationLite)locations.get(i6);
                        if (finalTT == null) {
                            PointObTuple pot;
                            obs0[jj] = pot = new PointObTuple(location, sDate, rest);
                            finalTT = Tuple.buildTupleType(pot.getComponents());
                        } else {
                            obs0[jj] = new PointObTuple(location, sDate, rest, finalTT, false);
                        }
                        ++jj;
                    }
                    Data[] obs1 = new PointObTuple[jj];
                    System.arraycopy(obs0, 0, obs1, 0, jj);
                    Integer1DSet indexSet = new Integer1DSet((MathType)RealType.getRealType("index"), jj);
                    retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), obs1[0].getType()), indexSet);
                    retField.setSamples(obs1, false, false);
                    break block46;
                }
                for (i = 0; i < numObs; ++i) {
                    DateTime dateTime = (DateTime)times.get(i);
                    Data rest = (Data)tuples.get(i);
                    EarthLocationLite location = (EarthLocationLite)locations.get(i);
                    if (finalTT == null) {
                        PointObTuple pot;
                        obs[i] = pot = new PointObTuple(location, dateTime, rest);
                        finalTT = Tuple.buildTupleType(pot.getComponents());
                        continue;
                    }
                    obs[i] = new PointObTuple(location, dateTime, rest, finalTT, false);
                }
                Integer1DSet indexSet = new Integer1DSet((MathType)RealType.getRealType("index"), obs.length);
                retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), obs[0].getType()), indexSet);
                retField.setSamples(obs, false, false);
            }
            catch (RemoteException re) {
                throw new VisADException("got RemoteException " + re);
            }
        }
        return retField;
    }

    public static int[] findLatLonAltIndices(TupleType type) {
        int i;
        int latIndex = type.getIndex(RealType.Latitude);
        int lonIndex = type.getIndex(RealType.Longitude);
        int altIndex = type.getIndex(RealType.Altitude);
        if (latIndex < 0) {
            for (i = 0; i < latVars.length && (latIndex = type.getIndex(latVars[i])) <= -1; ++i) {
            }
        }
        if (lonIndex < 0) {
            for (i = 0; i < lonVars.length && (lonIndex = type.getIndex(lonVars[i])) <= -1; ++i) {
            }
        }
        if (altIndex < 0) {
            for (i = 0; i < altVars.length && (altIndex = type.getIndex(altVars[i])) <= -1; ++i) {
            }
        }
        return new int[]{latIndex, lonIndex, altIndex};
    }

    private boolean isTrajectoryEnabled() {
        return this.getProperty("dataistrajectory", false);
    }

    @Override
    protected FieldImpl getSample(DataChoice dataChoice) throws Exception {
        return this.makeObs(dataChoice, null, null, null, true, true);
    }

    @Override
    public void doMakeDataChoices() {
        super.doMakeDataChoices();
        try {
            if (this.getDataChoices().size() == 0) {
                return;
            }
            DataChoice dataChoice = (DataChoice)this.getDataChoices().get(0);
            FieldImpl sample = this.makeObs(dataChoice, null, null, null, true, true);
            List cloudCats = DataCategory.parseCategories("Point Cloud;pointcloud", true);
            for (String varname : this.varNames) {
                DirectDataChoice choice = new DirectDataChoice((DataSource)this, (Object)("pointcloud:" + varname), varname, varname, cloudCats, (Hashtable)null);
                this.addDataChoice(choice);
            }
            if (this.isTrajectoryEnabled()) {
                List cats = DataCategory.parseCategories("Track;trace", true);
                for (int i = 0; i < this.varNames.size(); ++i) {
                    String var = this.varNames.get(i);
                    DirectDataChoice choice = new DirectDataChoice((DataSource)this, (Object)("track:" + var), var, var, cats, (Hashtable)null);
                    this.addDataChoice(choice);
                }
            }
        }
        catch (Exception exc) {
            this.logException("Creating track choices", exc);
        }
    }

    @Override
    public void getPropertiesComponents(List comps) {
        super.getPropertiesComponents(comps);
        if (this.isTrajectoryEnabled()) {
            // empty if block
        }
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        Object id = dataChoice.getId();
        if (id instanceof String && id.toString().startsWith("track:")) {
            try {
                return this.makeObs(dataChoice, dataSelection, null, id.toString().substring(6), false, true);
            }
            catch (Exception exc) {
                this.logException("Creating obs", exc);
                return null;
            }
        }
        if (id instanceof String && id.toString().startsWith("pointcloud:")) {
            try {
                Hashtable properties = dataChoice.getProperties();
                if (properties == null) {
                    properties = new Hashtable();
                }
                FieldImpl pointObs = null;
                ArrayList<FieldImpl> datas = new ArrayList<FieldImpl>();
                for (int i = 0; i < this.sources.size(); ++i) {
                    DirectDataChoice choice = new DirectDataChoice((DataSource)this, (Object)new Integer(i), "", "", dataChoice.getCategories(), properties);
                    pointObs = (FieldImpl)this.getDataInner(choice, category, dataSelection, requestProperties);
                    if (pointObs == null) continue;
                    datas.add(pointObs);
                }
                if (datas.size() == 0) {
                    return null;
                }
                pointObs = PointObFactory.mergeData(datas);
                if (pointObs == null) {
                    return null;
                }
                FieldImpl cloud = PointObFactory.makePointCloud(pointObs, id.toString().substring(11));
                return cloud;
            }
            catch (Exception exc) {
                this.logException("Creating point cloud", exc);
                return null;
            }
        }
        return (FieldImpl)super.getDataInner(dataChoice, category, dataSelection, requestProperties);
    }

    public static void main2(String[] args) throws Exception {
        String contents = IOUtil.readContents(args[0], TextPointDataSource.class);
        final int[] obcnt = new int[]{0};
        TextAdapter.StreamProcessor streamProcessor = new TextAdapter.StreamProcessor(){

            @Override
            public void processValues(Data[] tuple) {
                obcnt[0] = obcnt[0] + 1;
            }
        };
        long total = 0L;
        int cnt = 5;
        for (int i = 0; i <= cnt; ++i) {
            long t1 = System.currentTimeMillis();
            obcnt[0] = 0;
            TextPointDataSource dataSource = new TextPointDataSource(new DataSourceDescriptor(), args[0], new Hashtable());
            FieldImpl fieldImpl = dataSource.makeObs(contents, COMMA_DELIM, null, null, null, false, false);
            long t2 = System.currentTimeMillis();
            if (i == 0) continue;
            total += t2 - t1;
        }
        System.err.println("avg:" + total / (long)cnt);
    }

    private static void usage() {
        System.err.println("Usage: java PointObFactory -header headerfile <-skip skiplines> <-skiptonumber> <-xlsdateformat dateformat> <-Dproperty=value> <.csv files>");
        System.err.println("e.g.: java PointObFactory test.hdr -skip 14 -DLatitude.value=41.5 -DLongitude.value=-101.2 -xlsdateformat MM/dd/yyyy foo.csv bar.xls");
    }

    public static void main(String[] args) throws Exception {
        TextPointDataSource.main2(args);
    }

    public void setMap(String value) {
        this.map = value;
    }

    public String getMap() {
        return this.map;
    }

    public void setParams(String value) {
        this.params = value;
    }

    public String getParams() {
        return this.params;
    }

    public void setMetaDataFields(List value) {
        this.metaDataFields = value;
    }

    public List getMetaDataFields() {
        return this.metaDataFields;
    }

    public void setGroupVarName(String value) {
        this.groupVarName = value;
    }

    public String getGroupVarName() {
        return this.groupVarName;
    }

    public void setSkipRows(int value) {
        this.skipRows = value;
    }

    public int getSkipRows() {
        return this.skipRows;
    }

    public static class Metadata {
        private int skipRows = -1;
        private String skipPattern;
        private String delimiter;
        private List items;

        public Metadata() {
        }

        public Metadata(int rows, String delimiter, String skipPattern, List items) {
            this.skipRows = rows;
            this.delimiter = delimiter;
            this.skipPattern = skipPattern;
            this.items = items;
        }

        public void setSkipRows(int value) {
            this.skipRows = value;
        }

        public int getSkipRows() {
            return this.skipRows;
        }

        public void setItems(List value) {
            this.items = value;
        }

        public List getItems() {
            return this.items;
        }

        public void setSkipPattern(String value) {
            this.skipPattern = value;
        }

        public String getSkipPattern() {
            return this.skipPattern;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }
    }

    private static class ParamRow {
        JComboBox nameBox;
        JTextField extraFld;
        JTextField missingFld;
        JTextField unitFld;
        JButton popupBtn;
        JLabel sample;
        static Vector boxNames;
        static Vector unitNames;

        public ParamRow() {
            if (boxNames == null) {
                boxNames = new Vector(Misc.toList(new Object[]{"", "Time", "Latitude", "Longitude", "Altitude", "IDN"}));
                String unitStr = ";celsius;kelvin;fahrenheit;deg;degrees west;feet;km;meters;m;miles;kts;yyyy-MM-dd HH:mm:ss";
                unitNames = new Vector<String>(StringUtil.split(unitStr, TextPointDataSource.SEMICOLON_DELIM, false, false));
            }
        }

        public String getCleanName() {
            return Util.cleanName(this.getName());
        }

        public void setName(String name) {
            this.nameBox.setSelectedItem(name);
        }

        public String getName() {
            return this.nameBox.getSelectedItem().toString().trim();
        }

        public String getExtra() {
            return this.extraFld.getText().trim();
        }

        public String getMissing() {
            return this.missingFld.getText().trim();
        }

        public String getUnit() {
            return this.unitFld.getText().trim();
        }

        public void init(int tokIdx, List toks, List comps) {
            if (this.nameBox == null) {
                this.nameBox = new JComboBox(boxNames);
                this.nameBox.setEditable(true);
                this.nameBox.setPreferredSize(new Dimension(40, 10));
                this.nameBox.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent event) {
                        String name = nameBox.getSelectedItem() + "";
                        if ((name.toLowerCase().equals("latitude") || name.toLowerCase().equals("longitude")) && unitFld.getText().trim().length() == 0) {
                            unitFld.setText("degrees");
                        }
                    }
                });
                this.extraFld = new JTextField("", 5);
                this.extraFld.setToolTipText("<html>Extra attributes, e.g.:<br>colspan=&quot;some column span&quot;<br>Note:Values must be quoted.</html>");
                this.missingFld = new JTextField("", 5);
                this.unitFld = new JTextField("", 10);
                this.popupBtn = GuiUtils.getImageButton("/auxdata/ui/icons/Down.gif", this.getClass());
                this.popupBtn.setToolTipText("Set unit");
                this.popupBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        GuiUtils.popupUnitMenu(unitFld, popupBtn);
                    }
                });
                this.sample = new JLabel("");
            }
            this.sample.setText(StringUtil.shorten(toks.get(tokIdx).toString(), 25));
            JButton applyNameBtn = GuiUtils.getImageButton("/auxdata/ui/icons/HorArrow16.gif", this.getClass());
            applyNameBtn.setToolTipText("Use column value as the field name");
            applyNameBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    nameBox.setSelectedItem(sample.getText());
                }
            });
            comps.add(GuiUtils.leftRight(this.sample, applyNameBtn));
            comps.add(this.nameBox);
            comps.add(GuiUtils.centerRight(this.unitFld, this.popupBtn));
            comps.add(this.missingFld);
            comps.add(this.extraFld);
        }

        public void applyMetaData(List fields) {
            this.nameBox.setSelectedItem((String)fields.get(0));
            this.unitFld.setText((String)fields.get(1));
            this.missingFld.setText((String)fields.get(2));
            if (fields.size() >= 4) {
                this.extraFld.setText((String)fields.get(3));
            } else {
                this.extraFld.setText("");
            }
        }

        public void addToMetaData(List metaDataFields) {
            metaDataFields.add(Misc.newList(this.getCleanName(), this.getUnit(), this.getMissing(), this.getExtra()));
        }
    }
}

