/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import java.rmi.RemoteException;
import ucar.unidata.data.point.PointOb;
import visad.Data;
import visad.DateTime;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.georef.EarthLocation;

public class PointObTuple
extends Tuple
implements PointOb {
    private EarthLocation location;
    private DateTime dateTime;
    private Data data;
    private Data[] components;

    public PointObTuple(EarthLocation location, DateTime dateTime, Data data) throws VisADException, RemoteException {
        super(new Data[]{location, dateTime, data}, false);
        this.location = location;
        this.dateTime = dateTime;
        this.data = data;
    }

    @Override
    public Data getComponent(int i) throws VisADException, RemoteException {
        if (i == 0) {
            return this.location;
        }
        if (i == 1) {
            return this.dateTime;
        }
        return this.data;
    }

    @Override
    public boolean isMissing() {
        return this.location == null || this.dateTime == null || this.data == null;
    }

    @Override
    public Data[] getComponents(boolean copy) {
        if (this.components == null) {
            this.components = new Data[3];
            this.components[0] = this.location;
            this.components[1] = this.dateTime;
            this.components[2] = this.data;
        }
        return this.components;
    }

    public PointObTuple(EarthLocation location, DateTime dateTime, Data data, TupleType tupleType) throws VisADException, RemoteException {
        this(location, dateTime, data, tupleType, true);
    }

    public PointObTuple(EarthLocation location, DateTime dateTime, Data data, TupleType tupleType, boolean checkType) throws VisADException, RemoteException {
        super(tupleType);
        this.location = location;
        this.dateTime = dateTime;
        this.data = data;
    }

    @Override
    public EarthLocation getEarthLocation() {
        return this.location;
    }

    @Override
    public DateTime getDateTime() {
        return this.dateTime;
    }

    @Override
    public Data getData() {
        return this.data;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PointObTuple)) {
            return false;
        }
        PointObTuple that = (PointObTuple)o;
        return this.location.equals(that.location) && this.dateTime.equals(that.dateTime) && this.data.equals(that.data);
    }

    @Override
    public int hashCode() {
        return this.location.hashCode() ^ this.dateTime.hashCode() ^ this.data.hashCode();
    }

    @Override
    public final Object clone() {
        PointObTuple clone;
        try {
            clone = (PointObTuple)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Assertion failure");
        }
        clone.location = this.location;
        clone.dateTime = this.dateTime;
        clone.data = this.data;
        return clone;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Point Ob: ");
        buf.append("\tLocation: ");
        buf.append(this.location.toString());
        buf.append("\n\tDateTime: ");
        buf.append(this.dateTime.toString());
        buf.append("\n\tData: ");
        buf.append(this.data.toString());
        return buf.toString();
    }
}

