/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import java.rmi.RemoteException;
import ucar.unidata.data.point.PointOb;
import visad.Data;
import visad.DateTime;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SingletonSet;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.util.DataUtility;

public class PointObField
extends FieldImpl
implements PointOb {
    private EarthLocation location;
    private DateTime dateTime;
    private Data data;

    public PointObField(EarthLocation location, DateTime dateTime, Data data) throws VisADException, RemoteException {
        super(new FunctionType(RealType.Time, new FunctionType(RealTupleType.LatitudeLongitudeAltitude, data.getType())), new SingletonSet(new RealTuple(new Real[]{dateTime})));
        EarthLocationTuple llDomain = location instanceof EarthLocationTuple ? (EarthLocationTuple)location : new EarthLocationTuple(location.getLatitude(), location.getLongitude(), location.getAltitude());
        FunctionType rangeType = (FunctionType)((FunctionType)this.getType()).getRange();
        FieldImpl llToData = new FieldImpl(rangeType, new SingletonSet(llDomain));
        llToData.setSample(0, data, false);
        this.setSample(0, (Data)llToData, false);
        this.dateTime = dateTime;
    }

    @Override
    public EarthLocation getEarthLocation() {
        EarthLocationTuple elt = null;
        try {
            Set lldomain = ((FieldImpl)this.getSample(0)).getDomainSet();
            RealTuple sample = DataUtility.getSample(lldomain, 0);
            elt = new EarthLocationTuple((Real)sample.getComponent(0), (Real)sample.getComponent(1), (Real)sample.getComponent(2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return elt;
    }

    @Override
    public DateTime getDateTime() {
        return this.dateTime;
    }

    @Override
    public Data getData() {
        Data d = null;
        try {
            d = ((FieldImpl)this.getSample(0)).getSample(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    @Override
    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Assertion failure");
        }
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Point Ob: ");
        buf.append("\tLocation: ");
        buf.append(this.location.toString());
        buf.append("\n\tDateTime: ");
        buf.append(this.dateTime.toString());
        buf.append("\n\tData: ");
        buf.append(this.data.toString());
        return buf.toString();
    }
}

