/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import au.gov.bom.aifs.osa.analysis.Barnes;
import com.google.common.collect.ImmutableList;
import edu.wisc.ssec.mcidas.McIDASUtil;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.PointObsDataset;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.dt.StationObsDatatype;
import ucar.nc2.dt.point.CFPointObWriter;
import ucar.nc2.dt.point.PointObVar;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCC;
import ucar.nc2.ft.PointFeatureCCC;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.standard.StandardStationCollectionImpl;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.IOIterator;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.data.point.PointObField;
import ucar.unidata.data.point.PointObTuple;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.JobManager;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.GeoUtils;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.physics.Speed;
import ucar.visad.quantities.GeopotentialAltitude;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.DoubleStringTuple;
import visad.DoubleTuple;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.LinearLatLonSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Scalar;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.SingletonSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationLite;
import visad.georef.LatLonPoint;
import visad.util.DataUtility;

public class PointObFactory {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(PointObFactory.class.getName());
    public static final float OA_GRID_DEFAULT = 0.0f;

    public static FieldImpl makePointObField(PointOb point) throws VisADException, RemoteException {
        return new PointObField(point.getEarthLocation(), point.getDateTime(), point.getData());
    }

    public static FieldImpl makePointCloud(FieldImpl pointObs, String param) throws VisADException, RemoteException {
        Trace.call1("PointObFactory: makingTimeSequence");
        FieldImpl timeObs = PointObFactory.makeTimeSequenceOfPointObs(pointObs);
        Trace.call2("PointObFactory: makingTimeSequence");
        FieldImpl cloudData = null;
        Set timeSet = timeObs.getDomainSet();
        FunctionType cloudType = null;
        TupleType cloudDataType = null;
        FunctionType timeCloudType = null;
        Trace.call1("PointObFactory: makingCloudFI");
        float[][] timeStepVals = null;
        Object[] dataUnits = null;
        Object[] rangeUnits = null;
        boolean needToConvert = false;
        for (int i = 0; i < timeSet.getLength(); ++i) {
            FieldImpl obs = (FieldImpl)timeObs.getSample(i, false);
            Integer1DSet indexSet = (Integer1DSet)obs.getDomainSet();
            FlatField timeStep = null;
            for (int j = 0; j < indexSet.getLength(); ++j) {
                int k;
                PointOb ob = (PointOb)obs.getSample(j, false);
                if (cloudType == null) {
                    cloudDataType = new TupleType(new MathType[]{ob.getEarthLocation().getType(), ob.getData().getType()});
                    cloudType = new FunctionType(DataUtility.getDomainType(indexSet), cloudDataType);
                }
                double[] elVals = ((RealTuple)((Object)ob.getEarthLocation())).getValues();
                double[] dataVals = ((RealTuple)ob.getData()).getValues();
                if (timeStep == null) {
                    int k2;
                    timeStep = new FlatField(cloudType, indexSet);
                    timeStepVals = new float[elVals.length + dataVals.length][timeStep.getLength()];
                    Unit[] elUnits = ((RealTuple)((Object)ob.getEarthLocation())).getTupleUnits();
                    if (elUnits == null) {
                        elUnits = new Unit[]{CommonUnit.degree, CommonUnit.degree, CommonUnit.meter};
                    }
                    Unit[] valUnits = ((RealTuple)ob.getData()).getTupleUnits();
                    dataUnits = new Unit[elUnits.length + valUnits.length];
                    for (k2 = 0; k2 < elUnits.length; ++k2) {
                        dataUnits[k2] = elUnits[k2];
                    }
                    for (k2 = 0; k2 < valUnits.length; ++k2) {
                        dataUnits[k2 + elUnits.length] = valUnits[k2];
                    }
                    rangeUnits = Util.getDefaultRangeUnits(timeStep);
                    needToConvert = !Arrays.equals(dataUnits, rangeUnits);
                }
                for (k = 0; k < elVals.length; ++k) {
                    timeStepVals[k][j] = (float)elVals[k];
                }
                for (k = 0; k < dataVals.length; ++k) {
                    timeStepVals[k + elVals.length][j] = (float)dataVals[k];
                }
            }
            if (needToConvert) {
                timeStepVals = Unit.convertTuple(timeStepVals, dataUnits, rangeUnits);
            }
            timeStep.setSamples(timeStepVals, false);
            if (timeCloudType == null) {
                timeCloudType = new FunctionType(DataUtility.getDomainType(timeSet), timeStep.getType());
                cloudData = new FieldImpl(timeCloudType, timeSet);
            }
            cloudData.setSample(i, timeStep, false, false);
        }
        Trace.call2("PointObFactory: makingCloudFI");
        return cloudData;
    }

    public static FieldImpl makeTimeSequenceOfPointObs(FieldImpl pointObs) throws VisADException, RemoteException {
        return PointObFactory.makeTimeSequenceOfPointObs(pointObs, -1);
    }

    public static FieldImpl makeTimeSequenceOfPointObs(FieldImpl pointObs, int lumpMinutes) throws VisADException, RemoteException {
        int numObs = pointObs.getDomainSet().getLength();
        ArrayList<Data> obs = new ArrayList<Data>(numObs);
        Trace.call1("makeTimeSequence: get list of obs");
        for (int i = 0; i < numObs; ++i) {
            obs.add(pointObs.getSample(i, false));
        }
        Trace.call2("makeTimeSequence: get list of obs");
        return PointObFactory.makeTimeSequenceOfPointObs(obs, lumpMinutes, -1);
    }

    public static FieldImpl makeTimeSequenceOfPointObs(List pointObs, int lumpMinutes, int componentIndex) throws VisADException, RemoteException {
        Trace.call1("makeTimeSequence");
        ArrayList<DateTime> uniqueTimes = new ArrayList<DateTime>();
        int numObs = pointObs.size();
        MathType obType = null;
        Hashtable<Double, ArrayList<PointObTuple>> timeToObs = new Hashtable<Double, ArrayList<PointObTuple>>();
        Trace.call1("makeTimeSequence-loop1", " " + lumpMinutes + " component " + componentIndex + ", num obs:" + numObs);
        Hashtable<Double, Double> seenTime = new Hashtable<Double, Double>();
        for (int i = 0; i < numObs; ++i) {
            boolean contains;
            DateTime dttm;
            PointObTuple ob = (PointObTuple)pointObs.get(i);
            if (i == 0) {
                obType = componentIndex < 0 ? ob.getType() : ((Tuple)ob.getData()).getComponent(componentIndex).getType();
            }
            if ((dttm = ob.getDateTime()).isMissing()) continue;
            if (lumpMinutes > 0) {
                double seconds = dttm.getValue();
                seconds -= seconds % (double)(lumpMinutes * 60);
                dttm = new DateTime(seconds);
            }
            Double dValue = new Double(dttm.getValue());
            ArrayList<PointObTuple> obs = null;
            boolean bl = contains = seenTime.put(dValue, dValue) != null;
            if (!contains) {
                uniqueTimes.add(dttm);
                obs = new ArrayList<PointObTuple>();
                timeToObs.put(dValue, obs);
            } else {
                obs = (ArrayList<PointObTuple>)timeToObs.get(dValue);
            }
            obs.add(ob);
        }
        Trace.call2("makeTimeSequence-loop1", " #times:" + uniqueTimes.size());
        Object[] times = uniqueTimes.toArray(new DateTime[uniqueTimes.size()]);
        Arrays.sort(times);
        RealType index = RealType.getRealType("index");
        FunctionType sampleType = new FunctionType(index, obType);
        FunctionType timeSequenceType = new FunctionType(RealType.Time, componentIndex < 0 ? sampleType : obType);
        SampledSet timeSet = times.length > 1 ? CalendarDateTime.makeTimeSet((DateTime[])times) : new SingletonSet(new RealTuple(new Real[]{times[0]}));
        FieldImpl timeSequence = new FieldImpl(timeSequenceType, timeSet);
        ArrayList samples = new ArrayList();
        Trace.call1("makeTimeSequence-loop2");
        Data[] timeSamples = new Data[times.length];
        for (int i = 0; i < times.length; ++i) {
            Object dttm = times[i];
            Double dValue = new Double(((Real)dttm).getValue());
            List v = (List)timeToObs.get(dValue);
            Data[] obs = null;
            if (componentIndex >= 0) {
                obs = new Data[v.size()];
                for (int obIdx = 0; obIdx < v.size(); ++obIdx) {
                    obs[obIdx] = ((Tuple)((PointOb)v.get(obIdx)).getData()).getComponent(componentIndex);
                }
            }
            Integer1DSet set = new Integer1DSet((MathType)index, v.size());
            if (componentIndex < 0) {
                FieldImpl sample = new FieldImpl(sampleType, set);
                for (int j = 0; j < v.size(); ++j) {
                    sample.setSample(j, (Data)v.get(j), false, false);
                }
                timeSamples[i] = sample;
                continue;
            }
            timeSamples[i] = obs[0];
        }
        Trace.call2("makeTimeSequence-loop2");
        timeSequence.setSamples(timeSamples, false, false);
        Trace.call2("makeTimeSequence");
        return timeSequence;
    }

    public static FieldImpl subSet(FieldImpl pointObs, LatLonRect bounds) throws VisADException, RemoteException {
        return PointObFactory.subSet(pointObs, GeoUtils.latLonRectToSet(bounds));
    }

    public static FieldImpl subSet(FieldImpl pointObs, LinearLatLonSet bounds) throws VisADException, RemoteException {
        long t1 = System.currentTimeMillis();
        boolean isTimeSequence = GridUtil.isTimeSequence(pointObs);
        FieldImpl subSet = null;
        if (isTimeSequence) {
            Trace.call1("subSet");
            Set timeSet = pointObs.getDomainSet();
            int numTimes = timeSet.getLength();
            subSet = new FieldImpl((FunctionType)pointObs.getType(), timeSet);
            Vector<FieldImpl> samples = new Vector<FieldImpl>();
            for (int i = 0; i < numTimes; ++i) {
                FieldImpl oneTime = (FieldImpl)pointObs.getSample(i);
                FieldImpl subTime = PointObFactory.findIntersection(oneTime, bounds);
                samples.add(subTime);
            }
            subSet.setSamples(samples.toArray(new Data[samples.size()]), false, false);
            Trace.call2("subSet");
        } else {
            subSet = PointObFactory.findIntersection(pointObs, bounds);
        }
        return subSet;
    }

    public static List<PointOb> getPointObs(FieldImpl field) throws VisADException, RemoteException {
        ArrayList<PointOb> obs = new ArrayList<PointOb>();
        boolean isTimeSequence = GridUtil.isTimeSequence(field);
        if (isTimeSequence) {
            Set timeSet = field.getDomainSet();
            int numTimes = timeSet.getLength();
            for (int timeIdx = 0; timeIdx < numTimes; ++timeIdx) {
                FieldImpl oneTime = (FieldImpl)field.getSample(timeIdx);
                int numObs = oneTime.getDomainSet().getLength();
                for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                    obs.add((PointOb)oneTime.getSample(obIdx));
                }
            }
        } else {
            FieldImpl oneTime = field;
            int numObs = oneTime.getDomainSet().getLength();
            for (int obIdx = 0; obIdx < numObs; ++obIdx) {
                obs.add((PointOb)oneTime.getSample(obIdx));
            }
        }
        return obs;
    }

    public static void writeToNetcdf(File file, FieldImpl field) throws VisADException, RemoteException, IOException {
        List<PointOb> obs = PointObFactory.getPointObs(field);
        if (obs.size() == 0) {
            throw new IllegalArgumentException("No point observations to write");
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        ArrayList<PointObVar> dataVars = new ArrayList<PointObVar>();
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));
        CFPointObWriter writer = null;
        int numFloat = 0;
        int numString = 0;
        int[] lengths = null;
        boolean[] isText = null;
        for (PointOb ob : obs) {
            String s;
            int fieldIdx;
            Data[] data;
            EarthLocation el = ob.getEarthLocation();
            Real alt = el.getAltitude();
            LatLonPoint llp = el.getLatLonPoint();
            Tuple tuple = (Tuple)ob.getData();
            TupleType type = (TupleType)tuple.getType();
            MathType[] types = type.getComponents();
            int numFields = types.length;
            if (writer == null) {
                PointObVar pointObVar;
                int fieldIdx2;
                lengths = new int[numFields];
                isText = new boolean[numFields];
                boolean haveText = false;
                for (fieldIdx2 = 0; fieldIdx2 < numFields; ++fieldIdx2) {
                    lengths[fieldIdx2] = 0;
                    if (types[fieldIdx2] instanceof TextType) {
                        haveText = true;
                        isText[fieldIdx2] = true;
                        continue;
                    }
                    isText[fieldIdx2] = false;
                    pointObVar = new PointObVar();
                    pointObVar.setName(Util.cleanTypeName(types[fieldIdx2]));
                    Unit unit = ((RealType)types[fieldIdx2]).getDefaultUnit();
                    if (unit != null) {
                        String unitName = unit.getIdentifier();
                        if (unitName == null || unitName.length() == 0) {
                            unitName = unit.toString();
                        }
                        pointObVar.setUnits(unitName);
                    }
                    pointObVar.setDataType(DataType.DOUBLE);
                    dataVars.add(pointObVar);
                    ++numFloat;
                }
                if (haveText) {
                    for (PointOb ob2 : obs) {
                        Tuple tuple2 = (Tuple)ob2.getData();
                        data = tuple2.getComponents();
                        for (fieldIdx = 0; fieldIdx < lengths.length; ++fieldIdx) {
                            int len;
                            if (!isText[fieldIdx] || (len = (s = ((Text)data[fieldIdx]).getValue()).length()) <= lengths[fieldIdx]) continue;
                            lengths[fieldIdx] = len;
                        }
                    }
                }
                for (fieldIdx2 = 0; fieldIdx2 < lengths.length; ++fieldIdx2) {
                    if (!isText[fieldIdx2]) continue;
                    pointObVar = new PointObVar();
                    lengths[fieldIdx2] = Math.max(lengths[fieldIdx2], 2);
                    pointObVar.setName(Util.cleanTypeName(types[fieldIdx2]));
                    pointObVar.setDataType(DataType.STRING);
                    pointObVar.setLen(lengths[fieldIdx2]);
                    dataVars.add(pointObVar);
                    ++numString;
                }
                writer = new CFPointObWriter(dos, attrs, alt != null ? alt.getUnit().toString() : null, dataVars, obs.size());
            }
            double[] dvals = new double[numFloat];
            String[] svals = new String[numString];
            int dcnt = 0;
            int scnt = 0;
            data = tuple.getComponents();
            for (fieldIdx = 0; fieldIdx < numFields; ++fieldIdx) {
                if (isText[fieldIdx]) {
                    s = ((Text)data[fieldIdx]).getValue();
                    s = StringUtil.padLeft(s, lengths[fieldIdx]);
                    svals[scnt++] = s;
                    continue;
                }
                dvals[dcnt++] = ((Real)data[fieldIdx]).getValue();
            }
            try {
                writer.addPoint(llp.getLatitude().getValue(CommonUnit.degree), llp.getLongitude().getValue(CommonUnit.degree), alt != null ? alt.getValue(CommonUnit.meter) : 0.0, Util.makeDate(ob.getDateTime()), dvals, svals);
            }
            catch (Exception exc) {
                int xxx = 1;
                for (PointObVar pov : dataVars) {
                    System.out.println("var #" + xxx + " " + pov.getName() + " " + (Object)((Object)pov.getDataType()) + " unit:" + pov.getUnits() + " length:" + pov.getLen());
                    ++xxx;
                }
                System.out.println("#dvals:" + dvals.length + " #svals:" + svals.length);
                for (String s2 : svals) {
                    System.err.println("sval=" + s2 + ":");
                }
                throw new RuntimeException(exc);
            }
        }
        writer.finish();
        dos.close();
    }

    public static CFPointObWriter makeWriter(DataOutputStream dos, TupleType type, int[] skipIndices, int defaultStringLength, String altUnit, int cnt, int[] slengths) throws Exception {
        PointObVar pointObVar;
        int fieldIdx;
        MathType[] types = type.getComponents();
        int numFields = types.length;
        int numFloat = 0;
        int numString = 0;
        int[] lengths = new int[numFields];
        boolean[] isText = new boolean[numFields];
        boolean haveText = false;
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        ArrayList<PointObVar> dataVars = new ArrayList<PointObVar>();
        HashSet<Integer> skip = new HashSet<Integer>();
        for (int i = 0; i < skipIndices.length; ++i) {
            skip.add(new Integer(skipIndices[i]));
        }
        for (fieldIdx = 0; fieldIdx < numFields; ++fieldIdx) {
            if (skip.contains(new Integer(fieldIdx))) continue;
            if (types[fieldIdx] instanceof TextType) {
                lengths[fieldIdx] = slengths == null ? defaultStringLength : slengths[fieldIdx];
                haveText = true;
                isText[fieldIdx] = true;
                continue;
            }
            lengths[fieldIdx] = 0;
            isText[fieldIdx] = false;
            pointObVar = new PointObVar();
            pointObVar.setName(Util.cleanTypeName(types[fieldIdx]));
            Unit unit = ((RealType)types[fieldIdx]).getDefaultUnit();
            if (unit != null) {
                String unitName = unit.getIdentifier();
                if (unitName == null || unitName.length() == 0) {
                    unitName = unit.toString();
                }
                pointObVar.setUnits(unitName);
            }
            pointObVar.setDataType(DataType.DOUBLE);
            dataVars.add(pointObVar);
            ++numFloat;
        }
        for (fieldIdx = 0; fieldIdx < lengths.length; ++fieldIdx) {
            if (skip.contains(new Integer(fieldIdx)) || !isText[fieldIdx]) continue;
            pointObVar = new PointObVar();
            lengths[fieldIdx] = Math.max(lengths[fieldIdx], 2);
            pointObVar.setName(Util.cleanTypeName(types[fieldIdx]));
            pointObVar.setDataType(DataType.STRING);
            pointObVar.setLen(lengths[fieldIdx]);
            dataVars.add(pointObVar);
            ++numString;
        }
        return new CFPointObWriter(dos, attrs, altUnit, dataVars, cnt);
    }

    private static FieldImpl findIntersection(FieldImpl pointObs, LinearLatLonSet bounds) throws VisADException, RemoteException {
        if (pointObs == null || pointObs.isMissing()) {
            return pointObs;
        }
        FieldImpl retField = null;
        Set domainSet = pointObs.getDomainSet();
        int numObs = domainSet.getLength();
        Unit[] units = bounds.getSetUnits();
        int latIndex = ((RealType)((SetType)bounds.getType()).getDomain().getComponent(0)).equals(RealType.Latitude) ? 0 : 1;
        Vector<PointOb> v = new Vector<PointOb>();
        float[][] values = new float[2][1];
        for (int i = 0; i < numObs; ++i) {
            PointOb ob = (PointOb)pointObs.getSample(i);
            EarthLocation el = ob.getEarthLocation();
            values[0][0] = (float)el.getLatitude().getValue(units[latIndex]);
            values[1][0] = (float)el.getLongitude().getValue(units[1 - latIndex]);
            float[][] grids = bounds.valueToGrid(values);
            if (grids[0][0] != grids[0][0] || grids[1][0] != grids[1][0]) continue;
            v.add(ob);
        }
        if (v.size() == numObs) {
            retField = pointObs;
        } else if (!v.isEmpty()) {
            retField = new FieldImpl((FunctionType)pointObs.getType(), new Integer1DSet((MathType)((SetType)domainSet.getType()).getDomain(), v.size()));
            retField.setSamples(v.toArray(new PointOb[v.size()]), false, false);
        } else {
            PointOb point = (PointOb)pointObs.getSample(0);
            retField = new FieldImpl((FunctionType)pointObs.getType(), new Integer1DSet((MathType)((SetType)domainSet.getType()).getDomain(), 1));
            retField.setSamples(new PointOb[]{new PointObTuple(new EarthLocationLite(new Real(RealType.Latitude), new Real(RealType.Longitude), new Real(RealType.Altitude)), new DateTime(Double.NaN), point.getData() instanceof RealTuple ? new RealTuple((RealTupleType)point.getData().getType()) : new Tuple((TupleType)point.getData().getType()))}, false);
        }
        return retField;
    }

    public static FieldImpl makePointObsFromField(FieldImpl input) throws VisADException {
        return PointObFactory.makePointObsFromField(input, 0.0, 0.0);
    }

    public static FieldImpl makePointObsFromField(FieldImpl input, double binRoundTo, double binWidth) throws VisADException {
        FieldImpl retField = null;
        try {
            boolean hasDateHMS;
            int timeIndex;
            TupleType type = null;
            Gridded1DSet indexSet = null;
            try {
                type = (TupleType)((FunctionType)input.getType()).getRange();
                indexSet = (Gridded1DSet)input.getDomainSet();
            }
            catch (ClassCastException ce) {
                throw new IllegalArgumentException("don't know how to convert input to a point ob");
            }
            boolean allReals = type instanceof RealTupleType;
            int dayIndex = type.getIndex("DAY");
            if (dayIndex == -1 && (dayIndex = type.getIndex("DAY[unit:]")) == -1) {
                dayIndex = type.getIndex("DAY[unit:null]");
            }
            if ((timeIndex = type.getIndex("TIME")) == -1 && (timeIndex = type.getIndex("TIME[unit:]")) == -1) {
                timeIndex = type.getIndex("TIME[unit:null]");
            }
            int dateIndex = type.getIndex("DATE");
            int hmsIndex = type.getIndex("HMS");
            boolean hasDayTime = dayIndex != -1 && timeIndex != -1;
            boolean bl = hasDateHMS = dateIndex != -1 && hmsIndex != -1;
            if (!hasDayTime && !hasDateHMS) {
                throw new IllegalArgumentException("can't find DateTime components");
            }
            if (hasDateHMS) {
                dayIndex = dateIndex;
                timeIndex = hmsIndex;
            }
            int latIndex = type.getIndex(RealType.Latitude);
            int lonIndex = type.getIndex(RealType.Longitude);
            int altIndex = type.getIndex(RealType.Altitude);
            if (latIndex == -1 || lonIndex == -1) {
                throw new IllegalArgumentException("can't find lat/lon");
            }
            int cc1Index = type.getIndex("CC1");
            int cc2Index = type.getIndex("CC2");
            int cigIndex = type.getIndex("CIGC");
            int caIndex = type.getIndex("CA");
            int tempIndex = type.getIndex("T");
            int dewIndex = type.getIndex("TD");
            int speedIndex = type.getIndex("SPD");
            boolean mergeClouds = cc1Index >= 0 && cc2Index >= 0 && cigIndex >= 0 && caIndex < 0;
            int[] indicies = new int[]{dayIndex, timeIndex, latIndex, lonIndex, altIndex};
            int numVars = type.getDimension();
            int numNotRequired = numVars - (altIndex != -1 ? 5 : 4);
            int[] notReqIndices = new int[numNotRequired];
            int l = 0;
            for (int i = 0; i < numVars; ++i) {
                if (i == dayIndex || i == timeIndex || i == latIndex || i == lonIndex || i == altIndex) continue;
                notReqIndices[l++] = i;
            }
            Data[] obs = new PointObTuple[indexSet.getLength()];
            Trace.call1("loop-1", " Size:" + indexSet.getLength());
            int length = indexSet.getLength();
            List<DateTime> times = new ArrayList();
            boolean hasTimeOnly = false;
            GregorianCalendar cal = null;
            for (int i = 0; i < length; ++i) {
                Tuple ob = (Tuple)input.getSample(i);
                Real realDay = (Real)ob.getComponent(dayIndex);
                hasTimeOnly = CommonUnit.second.equals(realDay.getUnit());
                int day = (int)realDay.getValue();
                double time = ((Real)ob.getComponent(timeIndex)).getValue();
                if (!hasTimeOnly) {
                    if (hasDayTime) {
                        if (cal == null) {
                            cal = McIDASUtil.makeCalendarForDayTimeToSecs();
                        }
                        time = McIDASUtil.mcDayTimeToSecs(day, (int)time, cal);
                    } else {
                        time = McIDASUtil.mcDateHmsToSecs(day, (int)time);
                    }
                }
                times.add(new DateTime(time));
            }
            Trace.call2("loop-1");
            times = PointObFactory.binTimes(times, binRoundTo, binWidth);
            TupleType tupleType = null;
            TupleType finalTupleType = null;
            Trace.call1("loop-2", " num vars: " + numNotRequired);
            boolean cnt = false;
            ArrayList<RealType> realTypes = new ArrayList<RealType>();
            ArrayList<TextType> textTypes = new ArrayList<TextType>();
            for (int j = 0; j < numNotRequired; ++j) {
                ScalarType stype = (ScalarType)type.getComponent(notReqIndices[j]);
                if (stype instanceof TextType) {
                    textTypes.add((TextType)stype);
                    continue;
                }
                realTypes.add((RealType)stype);
            }
            RealType caType = null;
            RealType rhType = null;
            RealType windChillType = null;
            RealType heatIndexType = null;
            if (mergeClouds) {
                caType = DataUtil.makeRealType("CA", DataUtil.parseUnit(""));
                realTypes.add(caType);
            }
            if (tempIndex >= 0 && speedIndex >= 0) {
                rhType = DataUtil.makeRealType("RH", DataUtil.parseUnit("%"));
                windChillType = DataUtil.makeRealType("windChill", DataUtil.parseUnit("Fahrenheit"));
                heatIndexType = DataUtil.makeRealType("heatIndex", DataUtil.parseUnit("Fahrenheit"));
                realTypes.add(rhType);
                realTypes.add(windChillType);
                realTypes.add(heatIndexType);
            }
            if (allReals && realTypes.size() > 0) {
                tupleType = new RealTupleType(realTypes.toArray(new RealType[realTypes.size()]));
            } else if (realTypes.size() > 0) {
                tupleType = DoubleStringTuple.makeTupleType(realTypes, textTypes);
            }
            int numDouble = realTypes.size();
            int numString = textTypes.size();
            Data[] protos = null;
            Unit[] realUnits = null;
            Real caProto = null;
            Real rhProto = null;
            Real windChillProto = null;
            Real heatIndexProto = null;
            double caValue = 0.0;
            if (mergeClouds && rhType != null) {
                caProto = new Real(caType, 0.0);
                rhProto = new Real(rhType, 0.0);
                windChillProto = new Real(windChillType, 0.0);
                heatIndexProto = new Real(heatIndexType, 0.0);
            } else if (mergeClouds) {
                caProto = new Real(caType, 0.0);
            } else if (rhType != null) {
                rhProto = new Real(rhType, 0.0);
                windChillProto = new Real(windChillType, 0.0);
                heatIndexProto = new Real(heatIndexType, 0.0);
            }
            for (int i = 0; i < length; ++i) {
                DateTime dateTime = (DateTime)times.get(i);
                Tuple ob = (Tuple)input.getSample(i);
                EarthLocationLite location = new EarthLocationLite((Real)ob.getComponent(latIndex), (Real)ob.getComponent(lonIndex), altIndex != -1 ? (Real)ob.getComponent(altIndex) : new Real(RealType.Altitude, 0.0));
                Tuple rest = null;
                int wmo = 0;
                if (mergeClouds) {
                    double cc1 = ((Real)ob.getComponent(cc1Index)).getValue();
                    double cc2 = ((Real)ob.getComponent(cc2Index)).getValue();
                    double cig = ((Real)ob.getComponent(cigIndex)).getValue();
                    if (Double.isNaN(cc1)) {
                        cc1 = 0.0;
                    }
                    if (Double.isNaN(cc2)) {
                        cc2 = 0.0;
                    }
                    if (Double.isNaN(cig)) {
                        cig = 0.0;
                    }
                    boolean haveFew = cc1 == 5.0 || cc2 == 5.0;
                    int largest = 0;
                    if (!haveFew) {
                        largest = (int)Math.max(Math.max(cc1, cc2), cig);
                    } else {
                        double val1 = cc1 == 5.0 ? 0.0 : cc1;
                        double val2 = cc2 == 5.0 ? 0.0 : cc2;
                        largest = (int)Math.max(Math.max(val1, val2), cig);
                    }
                    wmo = largest < 2 ? 2 * largest : (largest == 2 ? 6 : 8);
                    if (wmo == 0 && haveFew) {
                        ++wmo;
                    }
                }
                double temp = 0.0;
                double temp1 = 0.0;
                double dew = 0.0;
                double speed = 0.0;
                if (rhType != null) {
                    temp = ((Real)ob.getComponent(tempIndex)).getValue(DataUtil.parseUnit("Celsius"));
                    temp1 = ((Real)ob.getComponent(tempIndex)).getValue(DataUtil.parseUnit("Fahrenheit"));
                    dew = ((Real)ob.getComponent(dewIndex)).getValue(DataUtil.parseUnit("Celsius"));
                    speed = ((Real)ob.getComponent(speedIndex)).getValue(Speed.MILES_PER_HOUR);
                }
                if (allReals && tupleType != null) {
                    int j;
                    double[] obValues = ((RealTuple)ob).getValues();
                    double[] realValues = new double[numDouble];
                    for (j = 0; j < numNotRequired; ++j) {
                        realValues[j] = obValues[notReqIndices[j]];
                    }
                    if (mergeClouds && rhType != null) {
                        realValues[numDouble - 4] = wmo;
                        realValues[numDouble - 3] = PointObFactory.relativeHumidity(temp, dew);
                        realValues[numDouble - 2] = PointObFactory.windChill(speed, temp1);
                        realValues[numDouble - 1] = PointObFactory.heatIndex(temp1, realValues[numDouble - 3]);
                    } else if (mergeClouds) {
                        realValues[numDouble - 1] = wmo;
                    } else if (rhType != null) {
                        realValues[numDouble - 3] = PointObFactory.relativeHumidity(temp, dew);
                        realValues[numDouble - 2] = PointObFactory.windChill(speed, temp1);
                        realValues[numDouble - 1] = PointObFactory.heatIndex(temp1, realValues[numDouble - 3]);
                    }
                    if (protos == null) {
                        protos = new Real[numDouble];
                        realUnits = new Unit[numDouble];
                        for (j = 0; j < numNotRequired; ++j) {
                            protos[j] = (Real)ob.getComponent(notReqIndices[j]);
                            realUnits[j] = ((Real)protos[j]).getUnit();
                        }
                        if (mergeClouds && rhType != null) {
                            protos[numDouble - 4] = caProto;
                            realUnits[numDouble - 4] = caProto.getUnit();
                            protos[numDouble - 3] = rhProto;
                            realUnits[numDouble - 3] = rhProto.getUnit();
                            protos[numDouble - 2] = windChillProto;
                            realUnits[numDouble - 2] = windChillProto.getUnit();
                            protos[numDouble - 1] = heatIndexProto;
                            realUnits[numDouble - 1] = heatIndexProto.getUnit();
                        } else if (mergeClouds) {
                            protos[numDouble - 1] = caProto;
                            realUnits[numDouble - 1] = caProto.getUnit();
                        } else if (rhType != null) {
                            protos[numDouble - 3] = rhProto;
                            realUnits[numDouble - 3] = rhProto.getUnit();
                            protos[numDouble - 2] = windChillProto;
                            realUnits[numDouble - 2] = windChillProto.getUnit();
                            protos[numDouble - 1] = heatIndexProto;
                            realUnits[numDouble - 1] = heatIndexProto.getUnit();
                        }
                    }
                    rest = new DoubleTuple((RealTupleType)tupleType, protos, realValues, realUnits);
                } else {
                    double[] values;
                    String[] strings = numString > 0 ? new String[numString] : null;
                    double[] dArray = values = numDouble > 0 ? new double[numDouble] : null;
                    if (i == 0) {
                        protos = new Real[numDouble];
                        realUnits = new Unit[numDouble];
                        if (mergeClouds && rhType != null) {
                            protos[numDouble - 4] = caProto;
                            realUnits[numDouble - 4] = caProto.getUnit();
                            protos[numDouble - 3] = rhProto;
                            realUnits[numDouble - 3] = rhProto.getUnit();
                            protos[numDouble - 2] = windChillProto;
                            realUnits[numDouble - 2] = windChillProto.getUnit();
                            protos[numDouble - 1] = heatIndexProto;
                            realUnits[numDouble - 1] = heatIndexProto.getUnit();
                        } else if (mergeClouds) {
                            protos[numDouble - 1] = caProto;
                            realUnits[numDouble - 1] = caProto.getUnit();
                        } else if (rhType != null) {
                            protos[numDouble - 3] = rhProto;
                            realUnits[numDouble - 3] = rhProto.getUnit();
                            protos[numDouble - 2] = windChillProto;
                            realUnits[numDouble - 2] = windChillProto.getUnit();
                            protos[numDouble - 1] = heatIndexProto;
                            realUnits[numDouble - 1] = heatIndexProto.getUnit();
                        }
                    }
                    int stringIdx = 0;
                    int valIdx = 0;
                    for (int j = 0; j < numNotRequired; ++j) {
                        Scalar scalar = (Scalar)ob.getComponent(notReqIndices[j]);
                        if (scalar instanceof Text) {
                            strings[stringIdx++] = ((Text)scalar).getValue();
                            continue;
                        }
                        Real real = (Real)scalar;
                        values[valIdx] = real.getValue();
                        if (i == 0) {
                            realUnits[valIdx] = real.getUnit();
                            protos[valIdx] = real;
                        }
                        ++valIdx;
                    }
                    if (mergeClouds && rhType != null) {
                        values[numDouble - 4] = wmo;
                        values[numDouble - 3] = PointObFactory.relativeHumidity(temp, dew);
                        values[numDouble - 2] = PointObFactory.windChill(speed, temp1);
                        values[numDouble - 1] = PointObFactory.heatIndex(temp1, values[numDouble - 3]);
                    } else if (mergeClouds) {
                        values[numDouble - 1] = wmo;
                    } else if (rhType != null) {
                        values[numDouble - 3] = PointObFactory.relativeHumidity(temp, dew);
                        values[numDouble - 2] = PointObFactory.windChill(speed, temp1);
                        values[numDouble - 1] = PointObFactory.heatIndex(temp1, values[numDouble - 3]);
                    }
                    rest = new DoubleStringTuple(tupleType, protos, values, strings, realUnits);
                }
                if (finalTupleType == null) {
                    PointObTuple pot = new PointObTuple(location, dateTime, rest);
                    obs[i] = pot;
                    finalTupleType = Tuple.buildTupleType(pot.getComponents());
                    Data[] comps = rest.getComponents();
                    for (int compIdx = 0; compIdx < comps.length; ++compIdx) {
                        String name = Util.cleanTypeName(comps[compIdx].getType());
                        DataChoice.addCurrentName(new TwoFacedObject((Object)("Point Data>" + name), name));
                    }
                    continue;
                }
                obs[i] = new PointObTuple(location, dateTime, rest, finalTupleType, false);
            }
            Trace.call2("loop-2");
            retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), obs[0].getType()), indexSet);
            retField.setSamples(obs, false, false);
        }
        catch (RemoteException re) {
            throw new VisADException("got RemoteException " + re);
        }
        return retField;
    }

    public static FieldImpl makePointObs(PointObsDataset input) throws Exception {
        return PointObFactory.makePointObs(input, 60.0, 15.0);
    }

    public static List binTimes(List times, double binRoundTo, double binWidth) throws VisADException {
        double baseTime;
        binRoundTo *= 60.0;
        if ((binWidth *= 60.0) <= 0.0) {
            return times;
        }
        double minTime = Double.MAX_VALUE;
        DateTime minDttm = null;
        for (int i = 0; i < times.size(); ++i) {
            DateTime dttm = (DateTime)times.get(i);
            double time = dttm.getValue(CommonUnit.secondsSinceTheEpoch);
            if (!(time < minTime)) continue;
            minTime = time;
            minDttm = dttm;
        }
        ArrayList<DateTime> newTimes = new ArrayList<DateTime>();
        int roundToSeconds = (int)binRoundTo;
        if (roundToSeconds == 0) {
            baseTime = minTime;
        } else {
            baseTime = minTime - minTime % 3600.0;
            baseTime -= 3600.0;
            baseTime += (double)roundToSeconds;
        }
        Hashtable seen = new Hashtable();
        boolean ucnt = false;
        for (int i = 0; i < times.size(); ++i) {
            DateTime dttm = (DateTime)times.get(i);
            double time = dttm.getValue(CommonUnit.secondsSinceTheEpoch);
            double rem = time - baseTime;
            double newTime = baseTime + binWidth * (double)((int)(rem / binWidth));
            DateTime newDttm = new DateTime(newTime);
            newTimes.add(newDttm);
        }
        return newTimes;
    }

    public static FieldImpl makePointObs(PointObsDataset input, double binRoundTo, double binWidth) throws Exception {
        return PointObFactory.makePointObs(input, binRoundTo, binWidth, null);
    }

    public static FieldImpl makePointObs(PointObsDataset input, double binRoundTo, double binWidth, LatLonRect llr) throws Exception {
        return PointObFactory.makePointObs(input, binRoundTo, binWidth, llr, false);
    }

    public static FieldImpl makePointObs(PointObsDataset input, double binRoundTo, double binWidth, LatLonRect llr, boolean sample) throws Exception {
        Object loadId = JobManager.getManager().startLoad("PointObFactory");
        List<VariableSimpleIF> actualVariables = input.getDataVariables();
        int numVars = actualVariables.size();
        boolean needToAddStationId = false;
        String stationFieldName = null;
        if (input instanceof StationObsDataset) {
            needToAddStationId = true;
        }
        int varIdxBase = 0;
        if (needToAddStationId) {
            ++numVars;
            varIdxBase = 1;
        }
        ArrayList<String> shortNamesList = new ArrayList<String>();
        log_.debug("number of data variables = " + numVars);
        boolean[] isVarNumeric = new boolean[numVars];
        boolean allReals = true;
        ScalarType[] types = new ScalarType[numVars];
        Unit[] varUnits = new Unit[numVars];
        ArrayList<ScalarType> numericTypes = new ArrayList<ScalarType>();
        ArrayList<Unit> numericUnits = new ArrayList<Unit>();
        ArrayList<ScalarType> stringTypes = new ArrayList<ScalarType>();
        if (needToAddStationId) {
            isVarNumeric[0] = false;
            if (stationFieldName == null) {
                stationFieldName = "ID";
            }
            shortNamesList.add(stationFieldName);
            types[0] = DataUtil.makeTextType(stationFieldName);
            stringTypes.add(types[0]);
            allReals = false;
        }
        int varIdx = varIdxBase;
        for (VariableSimpleIF var : actualVariables) {
            shortNamesList.add(var.getShortName());
            boolean bl = isVarNumeric[varIdx] = var.getDataType() != DataType.STRING && var.getDataType() != DataType.CHAR;
            if (!isVarNumeric[varIdx]) {
                allReals = false;
            }
            DataChoice.addCurrentName(new TwoFacedObject((Object)("Point Data>" + var.getShortName()), var.getShortName()));
            if (isVarNumeric[varIdx]) {
                Unit unit = DataUtil.parseUnit(var.getUnitsString());
                types[varIdx] = DataUtil.makeRealType(var.getShortName(), unit);
                varUnits[varIdx] = unit;
                numericTypes.add(types[varIdx]);
                numericUnits.add(unit);
            } else {
                types[varIdx] = DataUtil.makeTextType(var.getShortName());
                varUnits[varIdx] = null;
                stringTypes.add(types[varIdx]);
            }
            ++varIdx;
        }
        String[] shortNames = shortNamesList.toArray(new String[shortNamesList.size()]);
        int numReals = numericTypes.size();
        int numStrings = stringTypes.size();
        Object firstTuple = null;
        int total = input.getDataCount();
        int obIdx = 0;
        DataIterator dataIterator = input.getDataIterator(16384);
        int NUM = 500;
        TupleType allTupleType = allReals ? new RealTupleType(numericTypes.toArray(new RealType[numericTypes.size()])) : DoubleStringTuple.makeTupleType(numericTypes, stringTypes);
        Unit[] allUnits = numericUnits.toArray(new Unit[numericUnits.size()]);
        Real lat = new Real(RealType.Latitude, 40.0);
        Real lon = new Real(RealType.Longitude, -100.0);
        Real alt = new Real(RealType.Altitude, 0.0);
        Object dateTime = null;
        TupleType finalTT = null;
        PointObTuple pot = null;
        ArrayList<PointObsDatatype> pos = new ArrayList<PointObsDatatype>(100000);
        List<DateTime> times = new ArrayList(1000000);
        while (dataIterator.hasNext()) {
            PointObsDatatype po = (PointObsDatatype)dataIterator.next();
            ucar.unidata.geoloc.EarthLocation el = po.getLocation();
            if (el == null || llr != null && !llr.contains(el.getLatitude(), el.getLongitude())) continue;
            pos.add(po);
            times.add(new DateTime(po.getNominalTimeAsDate()));
            if (!sample) continue;
            break;
        }
        times = PointObFactory.binTimes(times, binRoundTo, binWidth);
        Data[] obs = new PointOb[pos.size()];
        int size = pos.size();
        Data[] prototype = null;
        for (int i = 0; i < size; ++i) {
            Tuple tuple;
            PointObsDatatype po = (PointObsDatatype)pos.get(i);
            ucar.unidata.geoloc.EarthLocation el = po.getLocation();
            EarthLocationLite elt = new EarthLocationLite(lat.cloneButValue(el.getLatitude()), lon.cloneButValue(el.getLongitude()), alt.cloneButValue(el.getAltitude()));
            double[] realArray = new double[numReals];
            String[] stringArray = numStrings == 0 ? null : new String[numStrings];
            StructureData structure = po.getData();
            int stringCnt = 0;
            int realCnt = 0;
            if (needToAddStationId) {
                StationObsDatatype sod = (StationObsDatatype)po;
                stringArray[stringCnt++] = sod.getStation().getName();
            }
            for (varIdx = varIdxBase; varIdx < numVars; ++varIdx) {
                StructureMembers.Member member = structure.findMember(shortNames[varIdx]);
                if (!isVarNumeric[varIdx]) {
                    stringArray[stringCnt++] = structure.getScalarString(member);
                    continue;
                }
                realArray[realCnt++] = structure.convertScalarFloat(member);
            }
            Tuple tuple2 = tuple = allReals ? new DoubleTuple((RealTupleType)allTupleType, prototype, realArray, allUnits) : new DoubleStringTuple(allTupleType, prototype, realArray, stringArray, allUnits);
            if (prototype == null) {
                prototype = tuple.getComponents();
            }
            if (finalTT == null) {
                pot = new PointObTuple(elt, (DateTime)times.get(i), tuple);
                finalTT = Tuple.buildTupleType(pot.getComponents());
            } else {
                pot = new PointObTuple(elt, (DateTime)times.get(i), tuple, finalTT, false);
            }
            obs[obIdx++] = pot;
            if (obIdx % NUM != 0) continue;
            if (!JobManager.getManager().canContinue(loadId)) {
                LogUtil.message("");
                return null;
            }
            if (llr == null) {
                LogUtil.message("Read " + obIdx + "/" + total + " observations");
                continue;
            }
            LogUtil.message("Read " + obIdx + " observations");
        }
        LogUtil.message("Read " + obIdx + " observations");
        LogUtil.message("Processing point data");
        Integer1DSet indexSet = new Integer1DSet((MathType)RealType.getRealType("index"), obs.length);
        FieldImpl retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), obs[0].getType()), indexSet);
        retField.setSamples(obs, false, false);
        return retField;
    }

    public static FieldImpl makePointObs(FeatureDatasetPoint input, DataChoice dataChoice, double binRoundTo, double binWidth, LatLonRect llr, DateSelection dateSelection, boolean sample) throws Exception {
        EarthLocationLite elt;
        Object loadId = JobManager.getManager().startLoad("PointObFactory");
        List<VariableSimpleIF> actualVariables = input.getDataVariables();
        int numVars = actualVariables.size();
        String _isMissing = "_isMissing";
        boolean needToAddStationId = false;
        String stationFieldName = null;
        List<DsgFeatureCollection> collectionList = input.getPointFeatureCollectionList();
        if (collectionList.size() > 1) {
            throw new IllegalArgumentException("Can't handle point data with multiple collections");
        }
        DsgFeatureCollection fc = collectionList.get(0);
        DsgFeatureCollection collection = null;
        Object collectionSS = null;
        CalendarDateRange dateRange = null;
        if (dateSelection != null) {
            if (dateSelection.getTimes() != null) {
                List range = dateSelection.getTimes();
                Collections.sort(range);
                CalendarDate calStart = CalendarDate.of((Date)range.get(0));
                CalendarDate calEnd = CalendarDate.of((Date)range.get(range.size() - 1));
                dateRange = CalendarDateRange.of(calStart, calEnd);
            } else if (dateSelection.hasInterval()) {
                double interval = dateSelection.getInterval();
                int count = dateSelection.getCount();
                long timespan = (long)interval * (long)count;
                Date now = new Date();
                dateRange = CalendarDateRange.of(new Date(now.getTime() - timespan), now);
            }
        }
        if (fc instanceof PointFeatureCollection) {
            collection = (PointFeatureCollection)fc;
            if (llr != null || dateRange != null) {
                collection = collection.subset(llr, dateRange);
            }
        } else if (fc instanceof StandardStationCollectionImpl) {
            collection = (StandardStationCollectionImpl)fc;
        } else if (fc instanceof PointFeatureCC) {
            PointFeatureCC npfc = (PointFeatureCC)fc;
            IOIterator<PointFeatureCollection> itor = npfc.getCollectionIterator();
            while (itor.hasNext()) {
                PointFeatureCollection pfcc = itor.next();
                pfcc = pfcc.subset(llr, dateRange);
            }
        } else {
            throw new IllegalArgumentException("Can't handle collection of type " + fc.getClass().getName());
        }
        if (input instanceof StationObsDataset) {
            // empty if block
        }
        int varIdxBase = 0;
        if (needToAddStationId) {
            ++numVars;
            varIdxBase = 1;
        }
        ArrayList<String> shortNamesList = new ArrayList<String>();
        log_.debug("number of data variables = " + numVars);
        boolean[] isVarNumeric = new boolean[numVars];
        boolean allReals = true;
        ScalarType[] types = new ScalarType[numVars];
        Unit[] varUnits = new Unit[numVars];
        ArrayList<ScalarType> numericTypes = new ArrayList<ScalarType>();
        ArrayList<Unit> numericUnits = new ArrayList<Unit>();
        ArrayList<ScalarType> stringTypes = new ArrayList<ScalarType>();
        if (needToAddStationId) {
            isVarNumeric[0] = false;
            if (stationFieldName == null) {
                stationFieldName = "ID";
            }
            shortNamesList.add(stationFieldName);
            types[0] = DataUtil.makeTextType(stationFieldName);
            stringTypes.add(types[0]);
            allReals = false;
        }
        Trace.call1("FeatureDatasetPoint: getting variable info");
        int varIdx = varIdxBase;
        for (VariableSimpleIF var : actualVariables) {
            String shortName = var.getShortName();
            if (shortName.equals(_isMissing)) {
                --numVars;
                continue;
            }
            if (!sample && !shortName.equals(dataChoice.getName())) {
                --numVars;
                continue;
            }
            if (var.getDataType() != DataType.BYTE && var.getDataType() != DataType.SHORT && var.getDataType() != DataType.INT && var.getDataType() != DataType.LONG && var.getDataType() != DataType.FLOAT && var.getDataType() != DataType.DOUBLE && var.getDataType() != DataType.STRING && var.getDataType() != DataType.CHAR) {
                --numVars;
                continue;
            }
            shortNamesList.add(shortName);
            boolean bl = isVarNumeric[varIdx] = var.getDataType() != DataType.STRING && var.getDataType() != DataType.CHAR;
            if (!isVarNumeric[varIdx]) {
                allReals = false;
            }
            DataChoice.addCurrentName(new TwoFacedObject((Object)("Point Data>" + var.getShortName()), var.getShortName()));
            if (isVarNumeric[varIdx]) {
                Unit unit = DataUtil.parseUnit(var.getUnitsString());
                types[varIdx] = DataUtil.makeRealType(var.getShortName(), unit);
                varUnits[varIdx] = unit;
                numericTypes.add(types[varIdx]);
                numericUnits.add(unit);
            } else {
                types[varIdx] = DataUtil.makeTextType(Util.cleanName(var.getShortName()));
                varUnits[varIdx] = null;
                stringTypes.add(types[varIdx]);
            }
            ++varIdx;
        }
        Trace.call2("FeatureDatasetPoint: getting variable info");
        String[] shortNames = shortNamesList.toArray(new String[shortNamesList.size()]);
        int numReals = numericTypes.size();
        int numStrings = stringTypes.size();
        int obIdx = 0;
        int NUM = 10000;
        TupleType allTupleType = allReals ? new RealTupleType(numericTypes.toArray(new RealType[numericTypes.size()])) : DoubleStringTuple.makeTupleType(numericTypes, stringTypes);
        Unit[] allUnits = numericUnits.toArray(new Unit[numericUnits.size()]);
        int listSize = sample ? 1 : 200000;
        Real lat = new Real(RealType.Latitude, 40.0);
        Real lon = new Real(RealType.Longitude, -100.0);
        Real alt = new Real(RealType.Altitude, 0.0);
        Object dateTime = null;
        TupleType finalTT = null;
        PointObTuple pot = null;
        ArrayList<DoubleTuple> tuples = new ArrayList<DoubleTuple>(listSize);
        List<DateTime> times = new ArrayList(listSize);
        ArrayList<EarthLocationLite> elts = new ArrayList<EarthLocationLite>(listSize);
        Trace.call1("FeatureDatasetPoint: iterating on PointFeatures", "sample = " + sample);
        int missing = 0;
        int ismissing = 0;
        boolean iammissing = false;
        String svalue = "missing";
        float value = Float.NaN;
        if (sample) {
            ++obIdx;
            elt = new EarthLocationLite(lat, lon, alt);
            double[] realArray = new double[numReals];
            String[] stringArray = numStrings == 0 ? null : new String[numStrings];
            int stringCnt = 0;
            int realCnt = 0;
            for (varIdx = varIdxBase; varIdx < numVars; ++varIdx) {
                if (!isVarNumeric[varIdx]) {
                    stringArray[stringCnt++] = svalue;
                    continue;
                }
                realArray[realCnt++] = value;
            }
            Tuple tuple = allReals ? new DoubleTuple((RealTupleType)allTupleType, realArray, allUnits) : new DoubleStringTuple(allTupleType, realArray, stringArray, allUnits);
            tuples.add((DoubleTuple)tuple);
            times.add(new DateTime(0.0));
            elts.add(elt);
        } else if (collection instanceof PointFeatureCollection) {
            PointFeatureIterator dataIterator = collection.getPointFeatureIterator();
            while (dataIterator.hasNext()) {
                PointFeature po = dataIterator.next();
                iammissing = false;
                ++obIdx;
                ucar.unidata.geoloc.EarthLocation el = po.getLocation();
                elt = new EarthLocationLite(lat.cloneButValue(el.getLatitude()), lon.cloneButValue(el.getLongitude()), alt.cloneButValue(el.getAltitude()));
                double[] realArray = new double[numReals];
                String[] stringArray = numStrings == 0 ? null : new String[numStrings];
                StructureData structure = po.getFeatureData();
                int stringCnt = 0;
                int realCnt = 0;
                if (needToAddStationId) {
                    StationObsDatatype sod = (StationObsDatatype)((Object)po);
                    stringArray[stringCnt++] = sod.getStation().getName();
                }
                boolean allMissing = true;
                StructureMembers.Member member = structure.findMember(_isMissing);
                if (member != null && (value = (float)structure.convertScalarInt(member)) == 1.0f) {
                    iammissing = true;
                    ++ismissing;
                    ++missing;
                    continue;
                }
                for (varIdx = varIdxBase; varIdx < numVars; ++varIdx) {
                    member = structure.findMember(shortNames[varIdx]);
                    if (member == null) continue;
                    if (!isVarNumeric[varIdx]) {
                        svalue = structure.getScalarString(member);
                        if (svalue.length() != 0) {
                            allMissing = false;
                        }
                        stringArray[stringCnt++] = svalue;
                        continue;
                    }
                    value = structure.convertScalarFloat(member);
                    if (value == value) {
                        allMissing = false;
                    }
                    realArray[realCnt++] = value;
                }
                if (allMissing) {
                    ++missing;
                    continue;
                }
                Tuple tuple = allReals ? new DoubleTuple((RealTupleType)allTupleType, realArray, allUnits) : new DoubleStringTuple(allTupleType, realArray, stringArray, allUnits);
                tuples.add((DoubleTuple)tuple);
                times.add(new DateTime(po.getNominalTimeAsCalendarDate().toDate()));
                elts.add(elt);
                if (obIdx % NUM != 0) continue;
                if (!JobManager.getManager().canContinue(loadId)) {
                    LogUtil.message("");
                    return null;
                }
                LogUtil.message("Read " + obIdx + " observations");
            }
            Trace.call2("FeatureDatasetPoint: iterating on PointFeatures", "found " + ismissing + "/" + missing + " missing out of " + obIdx);
            dataIterator.close();
        } else if (collection instanceof StandardStationCollectionImpl || collection instanceof StationTimeSeriesFeatureCollection) {
            DoubleTuple tuple;
            DateTime dtt;
            int j;
            double[] realArray;
            double elt0;
            int i;
            NetcdfDataset dataset = (NetcdfDataset)input.getNetcdfFile();
            String name = dataChoice.getName();
            Variable dataVar = dataset.findVariable(name);
            ArrayFloat.D2 dataValue = (ArrayFloat.D2)dataVar.read();
            boolean is2Dtime = false;
            ArrayDouble.D2 timeValue2D = null;
            ArrayDouble.D1 timeValue1D = null;
            CoordinateAxis timeAxis0 = dataset.findCoordinateAxis(AxisType.Time);
            Array timeArray = timeAxis0.getOriginalVariable().read();
            if (timeArray instanceof ArrayDouble.D2) {
                is2Dtime = true;
                timeValue2D = (ArrayDouble.D2)timeArray;
            } else {
                timeValue1D = (ArrayDouble.D1)timeArray;
            }
            CoordinateAxis1D latAxis = (CoordinateAxis1D)dataset.findCoordinateAxis(AxisType.Lat);
            CoordinateAxis1D lonAxis = (CoordinateAxis1D)dataset.findCoordinateAxis(AxisType.Lon);
            CoordinateAxis1D altAxis = (CoordinateAxis1D)dataset.findCoordinateAxis(AxisType.Height);
            int[] datashape = dataVar.getShape();
            double[] latValue = latAxis.getCoordValues();
            double[] lonValue = lonAxis.getCoordValues();
            double[] altValue = null;
            if (altAxis != null) {
                altValue = altAxis.getCoordValues();
            }
            int timelen = datashape[1];
            int stalen = datashape[0];
            if (is2Dtime) {
                for (i = 0; i < stalen; ++i) {
                    if (llr != null && !llr.contains(latValue[i], lonValue[i])) continue;
                    elt0 = 0.0;
                    if (altAxis != null) {
                        elt0 = altValue[i];
                    }
                    elt = new EarthLocationLite(lat.cloneButValue(latValue[i]), lon.cloneButValue(lonValue[i]), alt.cloneButValue(elt0));
                    realArray = new double[1];
                    for (j = 0; j < timelen; ++j) {
                        dtt = new DateTime(timeValue2D.get(i, j), DataUtil.parseUnit(timeAxis0.getUnitsString()));
                        times.add(dtt);
                        elts.add(elt);
                        realArray[0] = dataValue.get(i, j);
                        tuple = new DoubleTuple((RealTupleType)allTupleType, realArray, allUnits);
                        tuples.add(tuple);
                    }
                    if (++obIdx % NUM != 0) continue;
                    if (!JobManager.getManager().canContinue(loadId)) {
                        LogUtil.message("");
                        return null;
                    }
                    LogUtil.message("Read " + obIdx + " observations");
                }
            } else {
                for (i = 0; i < stalen; ++i) {
                    if (llr != null && !llr.contains(latValue[i], lonValue[i])) continue;
                    elt0 = 0.0;
                    if (altAxis != null) {
                        elt0 = altValue[i];
                    }
                    elt = new EarthLocationLite(lat.cloneButValue(latValue[i]), lon.cloneButValue(lonValue[i]), alt.cloneButValue(elt0));
                    realArray = new double[1];
                    for (j = 0; j < timelen; ++j) {
                        dtt = new DateTime(timeValue1D.get(j), DataUtil.parseUnit(timeAxis0.getUnitsString()));
                        times.add(dtt);
                        elts.add(elt);
                        realArray[0] = dataValue.get(i, j);
                        tuple = new DoubleTuple((RealTupleType)allTupleType, realArray, allUnits);
                        tuples.add(tuple);
                    }
                    if (++obIdx % NUM != 0) continue;
                    if (!JobManager.getManager().canContinue(loadId)) {
                        LogUtil.message("");
                        return null;
                    }
                    LogUtil.message("Read " + obIdx + " observations");
                }
            }
            System.out.println("Total point" + obIdx);
            Trace.call2("FeatureDatasetPoint: iterating on PointFeatures", "found " + ismissing + "/" + missing + " missing out of " + obIdx);
        }
        if (tuples.isEmpty()) {
            return null;
        }
        Trace.call1("FeatureDatasetPoint: binTimes");
        times = PointObFactory.binTimes(times, binRoundTo, binWidth);
        Trace.call2("FeatureDatasetPoint: binTimes");
        Trace.call1("FeatureDatasetPoint: making PointObTuples");
        Data[] obs = new PointOb[tuples.size()];
        int size = tuples.size();
        for (int i = 0; i < size; ++i) {
            if (finalTT == null) {
                pot = new PointObTuple((EarthLocation)elts.get(i), (DateTime)times.get(i), (Data)tuples.get(i));
                finalTT = Tuple.buildTupleType(pot.getComponents());
            } else {
                pot = new PointObTuple((EarthLocation)elts.get(i), (DateTime)times.get(i), (Data)tuples.get(i), finalTT, false);
            }
            obs[i] = pot;
        }
        Trace.call2("FeatureDatasetPoint: making PointObTuples");
        LogUtil.message("Read " + obIdx + " observations");
        LogUtil.message("Processing point data");
        Integer1DSet indexSet = new Integer1DSet((MathType)RealType.getRealType("index"), obs.length);
        FieldImpl retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), obs[0].getType()), indexSet);
        retField.setSamples(obs, false, false);
        return retField;
    }

    public static FieldImpl makePointObs(FeatureDatasetPoint input, double binRoundTo, double binWidth, LatLonRect llr, DateSelection dateSelection, boolean sample) throws Exception {
        EarthLocationLite elt;
        Object loadId = JobManager.getManager().startLoad("PointObFactory");
        List<VariableSimpleIF> actualVariables = input.getDataVariables();
        int numVars = actualVariables.size();
        String _isMissing = "_isMissing";
        boolean needToAddStationId = false;
        String stationFieldName = null;
        List<DsgFeatureCollection> collectionList = input.getPointFeatureCollectionList();
        if (collectionList.size() > 1) {
            throw new IllegalArgumentException("Can't handle point data with multiple collections");
        }
        DsgFeatureCollection fc = collectionList.get(0);
        PointFeatureCollection collection = null;
        CalendarDateRange dateRange = null;
        if (dateSelection != null) {
            if (dateSelection.getTimes() != null) {
                List range = dateSelection.getTimes();
                Collections.sort(range);
                CalendarDate calStart = CalendarDate.of((Date)range.get(0));
                CalendarDate calEnd = CalendarDate.of((Date)range.get(range.size() - 1));
                dateRange = CalendarDateRange.of(calStart, calEnd);
            } else if (dateSelection.hasInterval()) {
                double interval = dateSelection.getInterval();
                int count = dateSelection.getCount();
                long timespan = (long)interval * (long)count;
                Date now = new Date();
                dateRange = CalendarDateRange.of(new Date(now.getTime() - timespan), now);
            }
        }
        if (fc instanceof PointFeatureCollection) {
            collection = (PointFeatureCollection)fc;
            if (llr != null || dateRange != null) {
                collection = collection.subset(llr, dateRange);
            }
        } else if (fc instanceof PointFeatureCC) {
            PointFeatureCC npfc = (PointFeatureCC)fc;
            IOIterator<PointFeatureCollection> itor = npfc.getCollectionIterator();
            while (itor.hasNext()) {
                PointFeatureCollection pfcc = itor.next();
                pfcc = pfcc.subset(llr, dateRange);
            }
        } else {
            throw new IllegalArgumentException("Can't handle collection of type " + fc.getClass().getName());
        }
        if (input instanceof StationObsDataset) {
            // empty if block
        }
        int varIdxBase = 0;
        if (needToAddStationId) {
            ++numVars;
            varIdxBase = 1;
        }
        ArrayList<String> shortNamesList = new ArrayList<String>();
        log_.debug("number of data variables = " + numVars);
        boolean[] isVarNumeric = new boolean[numVars];
        boolean allReals = true;
        ScalarType[] types = new ScalarType[numVars];
        Unit[] varUnits = new Unit[numVars];
        ArrayList<ScalarType> numericTypes = new ArrayList<ScalarType>();
        ArrayList<Unit> numericUnits = new ArrayList<Unit>();
        ArrayList<ScalarType> stringTypes = new ArrayList<ScalarType>();
        if (needToAddStationId) {
            isVarNumeric[0] = false;
            if (stationFieldName == null) {
                stationFieldName = "ID";
            }
            shortNamesList.add(stationFieldName);
            types[0] = DataUtil.makeTextType(stationFieldName);
            stringTypes.add(types[0]);
            allReals = false;
        }
        Trace.call1("FeatureDatasetPoint: getting variable info");
        int varIdx = varIdxBase;
        for (VariableSimpleIF var : actualVariables) {
            String shortName = var.getShortName();
            if (shortName.equals(_isMissing)) {
                --numVars;
                continue;
            }
            if (var.getDataType() != DataType.BYTE && var.getDataType() != DataType.SHORT && var.getDataType() != DataType.INT && var.getDataType() != DataType.LONG && var.getDataType() != DataType.FLOAT && var.getDataType() != DataType.DOUBLE && var.getDataType() != DataType.STRING && var.getDataType() != DataType.CHAR) {
                --numVars;
                continue;
            }
            shortNamesList.add(shortName);
            boolean bl = isVarNumeric[varIdx] = var.getDataType() != DataType.STRING && var.getDataType() != DataType.CHAR;
            if (!isVarNumeric[varIdx]) {
                allReals = false;
            }
            DataChoice.addCurrentName(new TwoFacedObject((Object)("Point Data>" + var.getShortName()), var.getShortName()));
            if (isVarNumeric[varIdx]) {
                Unit unit = DataUtil.parseUnit(var.getUnitsString());
                types[varIdx] = DataUtil.makeRealType(var.getShortName(), unit);
                varUnits[varIdx] = unit;
                numericTypes.add(types[varIdx]);
                numericUnits.add(unit);
            } else {
                types[varIdx] = DataUtil.makeTextType(Util.cleanName(var.getShortName()));
                varUnits[varIdx] = null;
                stringTypes.add(types[varIdx]);
            }
            ++varIdx;
        }
        Trace.call2("FeatureDatasetPoint: getting variable info");
        String[] shortNames = shortNamesList.toArray(new String[shortNamesList.size()]);
        int numReals = numericTypes.size();
        int numStrings = stringTypes.size();
        int obIdx = 0;
        int NUM = 500;
        TupleType allTupleType = allReals ? new RealTupleType(numericTypes.toArray(new RealType[numericTypes.size()])) : DoubleStringTuple.makeTupleType(numericTypes, stringTypes);
        Unit[] allUnits = numericUnits.toArray(new Unit[numericUnits.size()]);
        int listSize = sample ? 1 : 100000;
        Real lat = new Real(RealType.Latitude, 40.0);
        Real lon = new Real(RealType.Longitude, -100.0);
        Real alt = new Real(RealType.Altitude, 0.0);
        Object dateTime = null;
        TupleType finalTT = null;
        PointObTuple pot = null;
        ArrayList<DoubleTuple> tuples = new ArrayList<DoubleTuple>(listSize);
        List<DateTime> times = new ArrayList(listSize);
        ArrayList<EarthLocationLite> elts = new ArrayList<EarthLocationLite>(listSize);
        Trace.call1("FeatureDatasetPoint: iterating on PointFeatures", "sample = " + sample);
        int missing = 0;
        int ismissing = 0;
        boolean iammissing = false;
        String svalue = "missing";
        float value = Float.NaN;
        if (sample) {
            ++obIdx;
            elt = new EarthLocationLite(lat, lon, alt);
            double[] realArray = new double[numReals];
            String[] stringArray = numStrings == 0 ? null : new String[numStrings];
            int stringCnt = 0;
            int realCnt = 0;
            for (varIdx = varIdxBase; varIdx < numVars; ++varIdx) {
                if (!isVarNumeric[varIdx]) {
                    stringArray[stringCnt++] = svalue;
                    continue;
                }
                realArray[realCnt++] = value;
            }
            Tuple tuple = allReals ? new DoubleTuple((RealTupleType)allTupleType, realArray, allUnits) : new DoubleStringTuple(allTupleType, realArray, stringArray, allUnits);
            tuples.add((DoubleTuple)tuple);
            times.add(new DateTime(0.0));
            elts.add(elt);
        } else {
            PointFeatureIterator dataIterator = collection.getPointFeatureIterator();
            while (dataIterator.hasNext()) {
                PointFeature po = dataIterator.next();
                iammissing = false;
                ++obIdx;
                ucar.unidata.geoloc.EarthLocation el = po.getLocation();
                elt = new EarthLocationLite(lat.cloneButValue(el.getLatitude()), lon.cloneButValue(el.getLongitude()), alt.cloneButValue(el.getAltitude()));
                double[] realArray = new double[numReals];
                String[] stringArray = numStrings == 0 ? null : new String[numStrings];
                StructureData structure = po.getFeatureData();
                int stringCnt = 0;
                int realCnt = 0;
                if (needToAddStationId) {
                    StationObsDatatype sod = (StationObsDatatype)((Object)po);
                    stringArray[stringCnt++] = sod.getStation().getName();
                }
                boolean allMissing = true;
                StructureMembers.Member member = structure.findMember(_isMissing);
                if (member != null && (value = (float)structure.convertScalarInt(member)) == 1.0f) {
                    iammissing = true;
                    ++ismissing;
                    ++missing;
                    continue;
                }
                for (varIdx = varIdxBase; varIdx < numVars; ++varIdx) {
                    member = structure.findMember(shortNames[varIdx]);
                    if (member == null) continue;
                    if (!isVarNumeric[varIdx]) {
                        svalue = structure.getScalarString(member);
                        if (svalue.length() != 0) {
                            allMissing = false;
                        }
                        stringArray[stringCnt++] = svalue;
                        continue;
                    }
                    value = structure.convertScalarFloat(member);
                    if (value == value) {
                        allMissing = false;
                    }
                    realArray[realCnt++] = value;
                }
                if (allMissing) {
                    ++missing;
                    continue;
                }
                Tuple tuple = allReals ? new DoubleTuple((RealTupleType)allTupleType, realArray, allUnits) : new DoubleStringTuple(allTupleType, realArray, stringArray, allUnits);
                tuples.add((DoubleTuple)tuple);
                times.add(new DateTime(po.getNominalTimeAsCalendarDate().toDate()));
                elts.add(elt);
                if (obIdx % NUM != 0) continue;
                if (!JobManager.getManager().canContinue(loadId)) {
                    LogUtil.message("");
                    return null;
                }
                LogUtil.message("Read " + obIdx + " observations");
            }
            Trace.call2("FeatureDatasetPoint: iterating on PointFeatures", "found " + ismissing + "/" + missing + " missing out of " + obIdx);
            dataIterator.close();
        }
        if (tuples.isEmpty()) {
            return null;
        }
        Trace.call1("FeatureDatasetPoint: binTimes");
        times = PointObFactory.binTimes(times, binRoundTo, binWidth);
        Trace.call2("FeatureDatasetPoint: binTimes");
        Trace.call1("FeatureDatasetPoint: making PointObTuples");
        Data[] obs = new PointOb[tuples.size()];
        int size = tuples.size();
        for (int i = 0; i < size; ++i) {
            if (finalTT == null) {
                pot = new PointObTuple((EarthLocation)elts.get(i), (DateTime)times.get(i), (Data)tuples.get(i));
                finalTT = Tuple.buildTupleType(pot.getComponents());
            } else {
                pot = new PointObTuple((EarthLocation)elts.get(i), (DateTime)times.get(i), (Data)tuples.get(i), finalTT, false);
            }
            obs[i] = pot;
        }
        Trace.call2("FeatureDatasetPoint: making PointObTuples");
        LogUtil.message("Read " + obIdx + " observations");
        LogUtil.message("Processing point data");
        Integer1DSet indexSet = new Integer1DSet((MathType)RealType.getRealType("index"), obs.length);
        FieldImpl retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), obs[0].getType()), indexSet);
        retField.setSamples(obs, false, false);
        return retField;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FieldImpl makePointObsWRF(FeatureDatasetPoint input, double binRoundTo, double binWidth, LatLonRect llr, DateSelection dateSelection, boolean sample) throws Exception {
        StructureMembers.Member member;
        EarthLocationLite elt;
        Object loadId = JobManager.getManager().startLoad("PointObFactory");
        double defOrder = 0.0;
        List<VariableSimpleIF> actualVariables = input.getDataVariables();
        int numVars = actualVariables.size();
        String _isMissing = "_isMissing";
        boolean needToAddStationId = false;
        String stationFieldName = null;
        List<DsgFeatureCollection> collectionList = input.getPointFeatureCollectionList();
        if (collectionList.size() > 1) {
            throw new IllegalArgumentException("Can't handle point data with multiple collections");
        }
        DsgFeatureCollection fc = collectionList.get(0);
        DsgFeatureCollection collection = null;
        CalendarDateRange dateRange = null;
        if (dateSelection != null) {
            if (dateSelection.getTimes() != null) {
                List range = dateSelection.getTimes();
                Collections.sort(range);
                CalendarDate calStart = CalendarDate.of((Date)range.get(0));
                CalendarDate calEnd = CalendarDate.of((Date)range.get(range.size() - 1));
                dateRange = CalendarDateRange.of(calStart, calEnd);
            } else if (dateSelection.hasInterval()) {
                double interval = dateSelection.getInterval();
                int count = dateSelection.getCount();
                long timespan = (long)interval * (long)count;
                Date now = new Date();
                dateRange = CalendarDateRange.of(new Date(now.getTime() - timespan), now);
            }
        }
        if (fc instanceof PointFeatureCollection) {
            collection = (PointFeatureCollection)fc;
            if (llr != null || dateRange != null) {
                collection = collection.subset(llr, dateRange);
            }
        } else if (fc instanceof StandardStationCollectionImpl) {
            collection = (StandardStationCollectionImpl)fc;
            if (llr != null || dateRange != null) {
                collection = ((StandardStationCollectionImpl)collection).flatten(llr, dateRange);
            }
        } else {
            if (!(fc instanceof PointFeatureCCC)) throw new IllegalArgumentException("Can't handle collection of type " + fc.getClass().getName());
            PointFeatureCCC npfc = (PointFeatureCCC)fc;
            if (llr != null || dateRange != null) {
                // empty if block
            }
        }
        if (input instanceof StationObsDataset) {
            // empty if block
        }
        int varIdxBase = 0;
        if (needToAddStationId) {
            ++numVars;
            varIdxBase = 1;
        }
        ArrayList<String> shortNamesList = new ArrayList<String>();
        log_.debug("number of data variables = " + numVars);
        boolean[] isVarNumeric = new boolean[numVars];
        boolean allReals = true;
        ScalarType[] types = new ScalarType[numVars];
        Unit[] varUnits = new Unit[numVars];
        ArrayList<ScalarType> numericTypes = new ArrayList<ScalarType>();
        ArrayList<Unit> numericUnits = new ArrayList<Unit>();
        ArrayList<ScalarType> stringTypes = new ArrayList<ScalarType>();
        if (needToAddStationId) {
            isVarNumeric[0] = false;
            if (stationFieldName == null) {
                stationFieldName = "ID";
            }
            shortNamesList.add(stationFieldName);
            types[0] = DataUtil.makeTextType(stationFieldName);
            stringTypes.add(types[0]);
            allReals = false;
        }
        Trace.call1("FeatureDatasetPoint: getting variable info");
        int varIdx = varIdxBase;
        for (VariableSimpleIF var : actualVariables) {
            String shortName = var.getShortName();
            if (shortName.equals(_isMissing)) {
                --numVars;
                continue;
            }
            if (!shortName.equals("streamflow") && !shortName.equals("order")) {
                --numVars;
                continue;
            }
            if (shortName.equals("order")) {
                varIdx = 0;
            } else if (shortName.equals("streamflow")) {
                varIdx = 1;
            }
            if (var.getDataType() != DataType.BYTE && var.getDataType() != DataType.SHORT && var.getDataType() != DataType.INT && var.getDataType() != DataType.LONG && var.getDataType() != DataType.FLOAT && var.getDataType() != DataType.DOUBLE && var.getDataType() != DataType.STRING && var.getDataType() != DataType.CHAR) {
                --numVars;
                continue;
            }
            shortNamesList.add(shortName);
            boolean bl = isVarNumeric[varIdx] = var.getDataType() != DataType.STRING && var.getDataType() != DataType.CHAR;
            if (!isVarNumeric[varIdx]) {
                allReals = false;
            }
            DataChoice.addCurrentName(new TwoFacedObject((Object)("Point Data>" + var.getShortName()), var.getShortName()));
            if (isVarNumeric[varIdx]) {
                Unit unit = DataUtil.parseUnit(var.getUnitsString());
                types[varIdx] = DataUtil.makeRealType(var.getShortName(), unit);
                varUnits[varIdx] = unit;
                numericTypes.add(types[varIdx]);
                numericUnits.add(unit);
            } else {
                types[varIdx] = DataUtil.makeTextType(Util.cleanName(var.getShortName()));
                varUnits[varIdx] = null;
                stringTypes.add(types[varIdx]);
            }
            ++varIdx;
        }
        Trace.call2("FeatureDatasetPoint: getting variable info");
        String[] shortNames = shortNamesList.toArray(new String[shortNamesList.size()]);
        int numReals = numericTypes.size();
        int numStrings = stringTypes.size();
        int obIdx = 0;
        int NUM = 5000;
        TupleType tupleType = allReals ? new RealTupleType(numericTypes.toArray(new RealType[numericTypes.size()])) : DoubleStringTuple.makeTupleType(numericTypes, stringTypes);
        Unit[] allUnits = numericUnits.toArray(new Unit[numericUnits.size()]);
        int listSize = sample ? 1 : 100000;
        Real lat = new Real(RealType.Latitude, 40.0);
        Real lon = new Real(RealType.Longitude, -100.0);
        Real alt = new Real(RealType.Altitude, 0.0);
        Object dateTime = null;
        TupleType finalTT = null;
        PointObTuple pot = null;
        ArrayList<DoubleTuple> tuples = new ArrayList<DoubleTuple>(listSize);
        List<DateTime> times = new ArrayList<DateTime>(listSize);
        ArrayList<EarthLocationLite> elts = new ArrayList<EarthLocationLite>(listSize);
        Trace.call1("FeatureDatasetPoint: iterating on PointFeatures", "sample = " + sample);
        int missing = 0;
        int ismissing = 0;
        boolean iammissing = false;
        String svalue = "missing";
        float value = Float.NaN;
        if (sample) {
            ++obIdx;
            elt = new EarthLocationLite(lat, lon, alt);
            double[] realArray = new double[numReals];
            String[] stringArray = numStrings == 0 ? null : new String[numStrings];
            int stringCnt = 0;
            int realCnt = 0;
            for (varIdx = varIdxBase; varIdx < numVars; ++varIdx) {
                if (!isVarNumeric[varIdx]) {
                    stringArray[stringCnt++] = svalue;
                    continue;
                }
                realArray[realCnt++] = value;
            }
            Tuple tuple = allReals ? new DoubleTuple((RealTupleType)tupleType, realArray, allUnits) : new DoubleStringTuple(tupleType, realArray, stringArray, allUnits);
            tuples.add((DoubleTuple)tuple);
            times.add(new DateTime(0.0));
            elts.add(elt);
        } else if (collection instanceof PointFeatureCollection) {
            PointFeatureIterator dataIterator = collection.getPointFeatureIterator();
            while (dataIterator.hasNext()) {
                PointFeature po = dataIterator.next();
                iammissing = false;
                ++obIdx;
                ucar.unidata.geoloc.EarthLocation el = po.getLocation();
                double elt0 = 0.0;
                if (el.getAltitude() == el.getAltitude()) {
                    elt0 = el.getAltitude() + 50.0;
                }
                elt = new EarthLocationLite(lat.cloneButValue(el.getLatitude()), lon.cloneButValue(el.getLongitude()), alt.cloneButValue(elt0));
                double[] realArray = new double[numReals];
                String[] stringArray = numStrings == 0 ? null : new String[numStrings];
                StructureData structure = po.getFeatureData();
                int stringCnt = 0;
                int realCnt = 0;
                if (needToAddStationId) {
                    StationObsDatatype sod = (StationObsDatatype)((Object)po);
                    stringArray[stringCnt++] = sod.getStation().getName();
                }
                boolean allMissing = true;
                member = structure.findMember(_isMissing);
                if (member != null && (value = (float)structure.convertScalarInt(member)) == 1.0f) {
                    iammissing = true;
                    ++ismissing;
                    ++missing;
                    continue;
                }
                for (varIdx = varIdxBase; varIdx < numVars; ++varIdx) {
                    member = structure.findMember(shortNames[varIdx]);
                    if (member == null) continue;
                    if (!isVarNumeric[varIdx]) {
                        svalue = structure.getScalarString(member);
                        if (svalue.length() != 0) {
                            allMissing = false;
                        }
                        stringArray[stringCnt++] = svalue;
                        continue;
                    }
                    value = structure.convertScalarFloat(member);
                    if (value == value) {
                        allMissing = false;
                    }
                    realArray[realCnt++] = value;
                }
                if (allMissing) {
                    ++missing;
                    continue;
                }
                Tuple tuple = allReals ? new DoubleTuple((RealTupleType)tupleType, realArray, allUnits) : new DoubleStringTuple(tupleType, realArray, stringArray, allUnits);
                tuples.add((DoubleTuple)tuple);
                times.add(new DateTime(po.getNominalTimeAsCalendarDate().toDate()));
                elts.add(elt);
                if (obIdx % NUM != 0) continue;
                if (!JobManager.getManager().canContinue(loadId)) {
                    LogUtil.message("");
                    return null;
                }
                LogUtil.message("Read " + obIdx + " observations");
            }
            Trace.call2("FeatureDatasetPoint: iterating on PointFeatures", "found " + ismissing + "/" + missing + " missing out of " + obIdx);
            dataIterator.close();
        } else if (collection instanceof StandardStationCollectionImpl) {
            StandardStationCollectionImpl ssci = (StandardStationCollectionImpl)collection;
            CalendarDate cdate = null;
            while (ssci.hasNext()) {
                StationTimeSeriesFeature po = ssci.next();
                iammissing = false;
                ++obIdx;
                PointFeatureIterator pf = po.getPointFeatureIterator();
                while (pf.hasNext()) {
                    PointFeature pointFeature = pf.next();
                    cdate = pointFeature.getObservationTimeAsCalendarDate();
                    double elt0 = 0.0;
                    if (po.getAltitude() != Double.NaN) {
                        elt0 = po.getAltitude();
                    }
                    elt = new EarthLocationLite(lat.cloneButValue(po.getLatitude()), lon.cloneButValue(po.getLongitude()), alt.cloneButValue(elt0));
                    double[] realArray = new double[numReals];
                    String[] stringArray = numStrings == 0 ? null : new String[numStrings];
                    StructureData structure = pointFeature.getDataAll();
                    int stringCnt = 0;
                    int n = 0;
                    if (needToAddStationId) {
                        StationObsDatatype sod = (StationObsDatatype)((Object)po);
                        stringArray[stringCnt++] = sod.getStation().getName();
                    }
                    boolean allMissing = true;
                    member = structure.findMember(_isMissing);
                    if (member != null && (value = (float)structure.convertScalarInt(member)) == 1.0f) {
                        iammissing = true;
                        ++ismissing;
                        ++missing;
                        continue;
                    }
                    for (varIdx = varIdxBase; varIdx < numVars; ++varIdx) {
                        member = structure.findMember(shortNames[varIdx]);
                        if (member == null) continue;
                        if (!isVarNumeric[varIdx]) {
                            svalue = structure.getScalarString(member);
                            if (svalue.length() != 0) {
                                allMissing = false;
                            }
                            stringArray[stringCnt++] = svalue;
                            continue;
                        }
                        value = structure.convertScalarFloat(member);
                        if (value == value) {
                            allMissing = false;
                        }
                        realArray[n++] = value;
                    }
                    if (allMissing) {
                        ++missing;
                        continue;
                    }
                    Tuple tuple = allReals ? new DoubleTuple((RealTupleType)tupleType, realArray, allUnits) : new DoubleStringTuple(tupleType, realArray, stringArray, allUnits);
                    tuples.add((DoubleTuple)tuple);
                    times.add(new DateTime(cdate.toDate()));
                    elts.add(elt);
                    if (obIdx % NUM != 0) continue;
                    if (!JobManager.getManager().canContinue(loadId)) {
                        LogUtil.message("");
                        return null;
                    }
                    LogUtil.message("Read " + obIdx + " observations");
                }
            }
            Trace.call2("FeatureDatasetPoint: iterating on PointFeatures", "found " + ismissing + "/" + missing + " missing out of " + obIdx);
        } else {
            void var58_73;
            NetcdfDataset netcdfDataset = (NetcdfDataset)input.getNetcdfFile();
            ImmutableList<CoordinateAxis> coords = netcdfDataset.getCoordinateAxes();
            ImmutableList<Variable> vars = netcdfDataset.getVariables();
            VariableDS vds0 = null;
            Object var58_72 = null;
            for (int i = 0; i < vars.size(); ++i) {
                if (!(vars.get(i) instanceof VariableDS)) continue;
                VariableDS vds = (VariableDS)vars.get(i);
                if (vds.getShortName().equals("order")) {
                    vds0 = vds;
                    continue;
                }
                if (!vds.getShortName().equals("streamflow")) continue;
                VariableDS variableDS = vds;
            }
            CoordinateAxis1D lats = null;
            CoordinateAxis1D lons = null;
            CoordinateAxis1D alts = null;
            CoordinateAxis1D ttts = null;
            if (coords.size() == 4) {
                lats = (CoordinateAxis1D)coords.get(0);
                lons = (CoordinateAxis1D)coords.get(1);
                alts = (CoordinateAxis1D)coords.get(2);
                ttts = (CoordinateAxis1D)coords.get(3);
            } else if (coords.size() == 3) {
                lats = (CoordinateAxis1D)coords.get(1);
                lons = (CoordinateAxis1D)coords.get(2);
                ttts = (CoordinateAxis1D)coords.get(0);
            }
            int ssize = (int)lats.getSize();
            double[] dlats = lats.getCoordValues();
            double[] dArray = lons.getCoordValues();
            double[] dalts = new double[ssize];
            if (alts != null) {
                dalts = alts.getCoordValues();
            }
            double[] dArray2 = ttts.getCoordValues();
            int[] sdata0 = (int[])vds0.getOriginalVariable().read().copyTo1DJavaArray();
            float[] sdata1 = (float[])var58_73.getOriginalVariable().read().copyTo1DJavaArray();
            for (int i = 0; i < ssize; ++i) {
                if (alts == null) {
                    dalts[i] = 0.0;
                }
                String ustr = ttts.getUnitsString();
                double hh = dArray2[0];
                DateTime time = new DateTime(hh, Util.parseUnit(ustr));
                elt = new EarthLocationLite(dlats[i], dArray[i], dalts[i]);
                double[] realArray = new double[]{sdata0[i], sdata1[i]};
                DoubleTuple tuple = new DoubleTuple((RealTupleType)tupleType, realArray, allUnits);
                elts.add(elt);
                tuples.add(tuple);
                times.add(time);
                if (++obIdx % NUM != 0) continue;
                if (!JobManager.getManager().canContinue(loadId)) {
                    LogUtil.message("");
                    return null;
                }
                LogUtil.message("Read " + obIdx + " observations");
            }
        }
        if (tuples.isEmpty()) {
            return null;
        }
        Trace.call1("FeatureDatasetPoint: binTimes");
        times = PointObFactory.binTimes(times, binRoundTo, binWidth);
        Trace.call2("FeatureDatasetPoint: binTimes");
        Trace.call1("FeatureDatasetPoint: making PointObTuples");
        Data[] obs = new PointOb[tuples.size()];
        int size = tuples.size();
        for (int i = 0; i < size; ++i) {
            if (finalTT == null) {
                pot = new PointObTuple((EarthLocation)elts.get(i), (DateTime)times.get(i), (Data)tuples.get(i));
                finalTT = Tuple.buildTupleType(pot.getComponents());
            } else {
                pot = new PointObTuple((EarthLocation)elts.get(i), (DateTime)times.get(i), (Data)tuples.get(i), finalTT, false);
            }
            obs[i] = pot;
        }
        Trace.call2("FeatureDatasetPoint: making PointObTuples");
        LogUtil.message("Read " + obIdx + " observations");
        LogUtil.message("Processing point data");
        Integer1DSet indexSet = new Integer1DSet((MathType)RealType.getRealType("index"), obs.length);
        FieldImpl retField = new FieldImpl(new FunctionType(((SetType)indexSet.getType()).getDomain(), obs[0].getType()), indexSet);
        retField.setSamples(obs, false, false);
        return retField;
    }

    public static FieldImpl mergeData(List datas) throws VisADException {
        if (datas.isEmpty()) {
            return null;
        }
        if (datas.size() == 1) {
            return (FieldImpl)datas.get(0);
        }
        FieldImpl retField = null;
        try {
            int numObs = 0;
            for (int i = 0; i < datas.size(); ++i) {
                numObs += ((FieldImpl)datas.get(i)).getDomainSet().getLength();
            }
            int curPos = 0;
            for (int i = 0; i < datas.size(); ++i) {
                FieldImpl data = (FieldImpl)datas.get(i);
                if (i == 0) {
                    FunctionType retType = (FunctionType)data.getType();
                    retField = new FieldImpl(retType, new Integer1DSet((MathType)retType.getDomain(), numObs));
                }
                int length = data.getDomainSet().getLength();
                for (int j = 0; j < length; ++j) {
                    retField.setSample(curPos, data.getSample(j), false, false);
                    ++curPos;
                }
            }
        }
        catch (RemoteException re) {
            throw new VisADException("got RemoteException " + re);
        }
        return retField;
    }

    public static PointOb makePointOb(EarthLocation el) throws VisADException, RemoteException {
        return PointObFactory.makePointOb(el, null);
    }

    public static PointOb makePointOb(EarthLocation el, DateTime dt) throws VisADException, RemoteException {
        return PointObFactory.makePointOb(el, dt, new RealTuple(new Real[]{new Real(0.0)}));
    }

    public static PointOb makePointOb(EarthLocation el, DateTime dt, Tuple tuple) throws VisADException, RemoteException {
        if (dt == null) {
            dt = new DateTime(Double.NaN);
        }
        return new PointObTuple(el, dt, tuple);
    }

    public static FieldImpl makePointObs(EarthLocation el) throws VisADException, RemoteException {
        return PointObFactory.makePointObs(el, null);
    }

    public static FieldImpl makePointObs(EarthLocation el, DateTime dt) throws VisADException, RemoteException {
        PointOb ob = PointObFactory.makePointOb(el, dt);
        return PointObFactory.makePointObs(ob);
    }

    public static FieldImpl makePointObs(PointOb po) throws VisADException, RemoteException {
        RealType index = RealType.getRealType("index");
        FieldImpl stationField = new FieldImpl(new FunctionType(index, po.getType()), new Integer1DSet((MathType)index, 1));
        stationField.setSample(0, (Data)po, false);
        return stationField;
    }

    public static FieldImpl removeTimeDimension(FieldImpl pointObs) throws VisADException, RemoteException {
        if (!GridUtil.isTimeSequence(pointObs)) {
            return pointObs;
        }
        Set timeSet = pointObs.getDomainSet();
        ArrayList<Data> l = new ArrayList<Data>();
        FunctionType ft = null;
        for (int i = 0; i < timeSet.getLength(); ++i) {
            FieldImpl indexField = (FieldImpl)pointObs.getSample(i, false);
            if (ft == null) {
                ft = (FunctionType)indexField.getType();
            }
            for (int j = 0; j < indexField.getLength(); ++j) {
                Data d = indexField.getSample(j, false);
                if (d == null || d.isMissing()) continue;
                l.add(d);
            }
        }
        RealTupleType rt = ft.getDomain();
        Integer1DSet domain = new Integer1DSet((MathType)rt, l.size());
        FieldImpl retField = new FieldImpl(ft, domain);
        for (int i = 0; i < l.size(); ++i) {
            retField.setSample(i, (Data)l.get(i), false, false);
        }
        return retField;
    }

    public static FieldImpl barnes(FieldImpl pointObs, RealType type, float xSpacing, float ySpacing, int numPasses) throws VisADException, RemoteException {
        return PointObFactory.barnes(pointObs, type, xSpacing, ySpacing, numPasses, 10.0f, 1.0f, null, null);
    }

    public static FieldImpl barnes(FieldImpl pointObs, RealType type, float xSpacing, float ySpacing, int numPasses, float gain, float scaleLength, Barnes.AnalysisParameters params, FieldImpl firstGuessField) throws VisADException, RemoteException {
        boolean guessIsTime;
        FieldImpl retFI = null;
        boolean haveGuess = firstGuessField != null;
        boolean bl = guessIsTime = firstGuessField != null && GridUtil.isTimeSequence(firstGuessField);
        if (haveGuess && guessIsTime && GridUtil.isTimeSequence(pointObs)) {
            firstGuessField = (FieldImpl)firstGuessField.resample(pointObs.getDomainSet(), 100, 202);
        }
        FlatField guessField = null;
        if (GridUtil.isTimeSequence(pointObs)) {
            Set timeSet = GridUtil.getTimeSet(pointObs);
            int errorCount = 0;
            for (int i = 0; i < timeSet.getLength(); ++i) {
                if (haveGuess && (guessField = guessIsTime ? (FlatField)firstGuessField.getSample(i, false) : (FlatField)firstGuessField).isMissing()) {
                    if (errorCount == 0) {
                        LogUtil.userMessage(log_, "Unable to find matching time for first guess");
                    }
                    guessField = null;
                    ++errorCount;
                }
                FlatField oneTime = PointObFactory.barnesOneTime((FieldImpl)pointObs.getSample(i), type, xSpacing, ySpacing, numPasses, gain, scaleLength, params, guessField);
                if (retFI == null && oneTime != null) {
                    FunctionType ft = new FunctionType(((SetType)timeSet.getType()).getDomain(), oneTime.getType());
                    retFI = new FieldImpl(ft, timeSet);
                }
                if (oneTime == null) continue;
                ((FieldImpl)retFI).setSample(i, (Data)oneTime, false);
            }
        } else {
            if (haveGuess) {
                guessField = guessIsTime ? (FlatField)firstGuessField.getSample(0, false) : (FlatField)firstGuessField;
            }
            retFI = PointObFactory.barnesOneTime(pointObs, type, xSpacing, ySpacing, numPasses, gain, scaleLength, params, guessField);
        }
        return retFI;
    }

    public static FlatField barnesOneTime(FieldImpl pointObs, RealType type, float xSpacing, float ySpacing, int numPasses) throws VisADException, RemoteException {
        return PointObFactory.barnesOneTime(pointObs, type, xSpacing, ySpacing, numPasses, 10.0f, 1.0f, null);
    }

    public static FlatField barnesOneTime(FieldImpl pointObs, RealType type, float xSpacing, float ySpacing, int numPasses, float gain, float scaleLength, Barnes.AnalysisParameters params) throws VisADException, RemoteException {
        return PointObFactory.barnesOneTime(pointObs, type, xSpacing, ySpacing, numPasses, gain, scaleLength, params, null);
    }

    public static FlatField barnesOneTime(FieldImpl pointObs, RealType type, float xSpacing, float ySpacing, int numPasses, float gain, float scaleLength, Barnes.AnalysisParameters params, FlatField firstGuess) throws VisADException, RemoteException {
        int i;
        int numObs = pointObs.getLength();
        if (numObs < 4) {
            return null;
        }
        float[][] obVals = new float[3][numObs];
        PointOb firstOb = (PointOb)pointObs.getSample(0);
        Tuple data = (Tuple)firstOb.getData();
        TupleType ttype = (TupleType)data.getType();
        int typeIndex = ttype.getIndex(type);
        if (typeIndex == -1) {
            return null;
        }
        float latMin = 90.0f;
        float lonMin = 180.0f;
        float latMax = -90.0f;
        float lonMax = -180.0f;
        int cnt = 0;
        int numMissing = 0;
        Unit outputUnits = type.getDefaultUnit();
        for (i = 0; i < numObs; ++i) {
            float lon;
            PointOb po = (PointOb)pointObs.getSample(i);
            Tuple obData = (Tuple)po.getData();
            Real val = (Real)obData.getComponent(typeIndex);
            double obVal = val.getValue(type.getDefaultUnit());
            if (Double.isNaN(obVal)) {
                ++numMissing;
                continue;
            }
            EarthLocation el = po.getEarthLocation();
            float lat = (float)el.getLatitude().getValue(CommonUnit.degree);
            if (Float.isNaN(lat) || lat < -90.0f || lat > 90.0f) {
                ++numMissing;
                continue;
            }
            if (lat < latMin) {
                latMin = lat;
            }
            if (lat > latMax) {
                latMax = lat;
            }
            if (Float.isNaN(lon = (float)el.getLongitude().getValue(CommonUnit.degree)) || lon < -360.0f || lon > 360.0f) {
                ++numMissing;
                continue;
            }
            if (lon < -180.0f) {
                lon += 360.0f;
            }
            if (lon > 180.0f) {
                lon -= 360.0f;
            }
            if (lon < lonMin) {
                lonMin = lon;
            }
            if (lon > lonMax) {
                lonMax = lon;
            }
            obVals[0][cnt] = lon;
            obVals[1][cnt] = lat;
            obVals[2][cnt] = (float)obVal;
            ++cnt;
        }
        if (cnt <= 3) {
            return null;
        }
        if (cnt != numObs) {
            for (i = 0; i < 3; ++i) {
                float[] temp = new float[cnt];
                System.arraycopy(obVals[i], 0, temp, 0, cnt);
                obVals[i] = temp;
            }
        }
        log_.debug("lat range = " + latMin + " " + latMax + ", lon range = " + lonMin + " " + lonMax);
        float[] faGridX = null;
        float[] faGridY = null;
        if (firstGuess == null) {
            if (xSpacing == 0.0f || ySpacing == 0.0f) {
                Barnes.AnalysisParameters ap = Barnes.getRecommendedParameters((float)lonMin, (float)latMin, (float)lonMax, (float)latMax, (float[][])new float[][]{obVals[0], obVals[1]});
                faGridX = ap.getGridXArray();
                faGridY = ap.getGridYArray();
                if (scaleLength == 0.0f) {
                    scaleLength = (float)ap.getScaleLengthGU();
                }
                log_.debug("random data spacing = " + ap.getRandomDataSpacing());
            } else {
                faGridX = Barnes.getRecommendedGridX((float)lonMin, (float)lonMax, (float)xSpacing);
                faGridY = Barnes.getRecommendedGridY((float)latMin, (float)latMax, (float)ySpacing);
            }
        } else {
            GriddedSet domainSet = (GriddedSet)GridUtil.getSpatialDomain(firstGuess);
            CoordinateSystem refCS = domainSet.getCoordinateSystem();
            float[] his = domainSet.getHi();
            float[] lows = domainSet.getLow();
            int[] sizes = domainSet.getLengths();
            faGridX = Barnes.getRecommendedGridX((float)lows[0], (float)his[0], (float)((his[0] - lows[0]) / (float)(sizes[0] - 1)));
            faGridY = Barnes.getRecommendedGridX((float)lows[1], (float)his[1], (float)((his[1] - lows[1]) / (float)(sizes[1] - 1)));
            if (refCS != null) {
                Object transformedXY = new float[domainSet.getDimension()][];
                if (GridUtil.isLatLonOrder(firstGuess)) {
                    transformedXY[0] = obVals[1];
                    transformedXY[1] = obVals[0];
                } else {
                    transformedXY[0] = obVals[0];
                    transformedXY[1] = obVals[1];
                }
                if (((float[][])transformedXY).length == 3) {
                    transformedXY[2] = new float[obVals[0].length];
                }
                transformedXY = refCS.fromReference((float[][])transformedXY);
                obVals[0] = transformedXY[0];
                obVals[1] = transformedXY[1];
            } else {
                float hi;
                float low;
                if (GridUtil.isLatLonOrder(firstGuess)) {
                    low = lows[1];
                    hi = his[1];
                } else {
                    low = lows[0];
                    hi = his[0];
                }
                if (hi > 180.0f || low < -180.0f) {
                    obVals[0] = GeoUtils.normalizeLongitude360(obVals[0]);
                }
            }
            Unit guessUnits = firstGuess.getDefaultRangeUnits()[0];
            if (guessUnits.equals(GeopotentialAltitude.getGeopotentialMeter()) && Unit.canConvert(type.getDefaultUnit(), CommonUnit.meter)) {
                guessUnits = CommonUnit.meter;
            }
            obVals[2] = guessUnits.toThis(obVals[2], type.getDefaultUnit(), false);
            outputUnits = guessUnits;
        }
        if (params != null) {
            params.setGridXArray(faGridX);
            params.setGridYArray(faGridY);
            params.setScaleLengthGU((double)scaleLength);
        }
        log_.debug("num X pts = " + faGridX.length + "  num Y pts = " + faGridY.length + " scaleLength = " + scaleLength + " gain = " + gain);
        float[][] griddedData = null;
        if (firstGuess != null) {
            float[][] gridVals = GridUtil.makeGrid2D(firstGuess).getvalues()[0];
            griddedData = Barnes.point2grid((float[])faGridX, (float[])faGridY, (float[][])obVals, (float[][])gridVals, (float)scaleLength, (float)gain, (int)numPasses);
        } else {
            griddedData = Barnes.point2grid((float[])faGridX, (float[])faGridY, (float[][])obVals, (float)scaleLength, (float)gain, (int)numPasses);
        }
        float[][] faaGridValues3 = new float[1][faGridX.length * faGridY.length];
        int m = 0;
        for (int j = 0; j < faGridY.length; ++j) {
            for (int i2 = 0; i2 < faGridX.length; ++i2) {
                faaGridValues3[0][m] = griddedData[i2][j];
                ++m;
            }
        }
        GriddedSet gdsSet = null;
        Object gdsType = null;
        if (firstGuess == null) {
            Linear1DSet xSet = new Linear1DSet((MathType)RealType.Longitude, faGridX[0], faGridX[faGridX.length - 1], faGridX.length);
            Linear1DSet ySet = new Linear1DSet((MathType)RealType.Latitude, faGridY[0], faGridY[faGridY.length - 1], faGridY.length);
            gdsSet = new LinearLatLonSet((MathType)RealTupleType.SpatialEarth2DTuple, new Linear1DSet[]{xSet, ySet}, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null, true);
        } else {
            gdsSet = (GriddedSet)GridUtil.getSpatialDomain(firstGuess);
        }
        FunctionType ftLatLon2Param = new FunctionType(((SetType)gdsSet.getType()).getDomain(), new RealTupleType(type));
        FlatField retData = new FlatField(ftLatLon2Param, (Set)gdsSet, (CoordinateSystem)null, (Set[])null, new Unit[]{outputUnits});
        retData.setSamples(faaGridValues3, false);
        return retData;
    }

    public static FieldImpl extractParameter(FieldImpl obs, String paramName) throws VisADException, RemoteException {
        return PointObFactory.extractParameter(obs, RealType.getRealType(paramName));
    }

    public static FieldImpl extractParameter(FieldImpl obs, RealType parameter) throws VisADException, RemoteException {
        boolean isTimeSequence = GridUtil.isTimeSequence(obs);
        FieldImpl subset = null;
        if (isTimeSequence) {
            FieldImpl timeSubset = null;
            Set timeSet = obs.getDomainSet();
            int numTimes = timeSet.getLength();
            for (int i = 0; i < numTimes; ++i) {
                FieldImpl newSample;
                FieldImpl timeStep = (FieldImpl)obs.getSample(i);
                if (timeStep == null || timeStep.isMissing() || (newSample = PointObFactory.extractParameter(timeStep, parameter)) == null) continue;
                if (timeSubset == null) {
                    FunctionType newFieldType = new FunctionType(((SetType)timeSet.getType()).getDomain(), newSample.getType());
                    timeSubset = new FieldImpl(newFieldType, timeSet);
                }
                timeSubset.setSample(i, (Data)newSample, false);
            }
            subset = timeSubset;
        } else {
            Set indexSet = obs.getDomainSet();
            PointOb po = null;
            try {
                po = (PointOb)obs.getSample(0);
            }
            catch (ClassCastException cce) {
                throw new VisADException("not a field of pointObs: " + obs.getSample(0).getClass().getName());
            }
            Tuple ob = (Tuple)po.getData();
            int paramIndex = ((TupleType)ob.getType()).getIndex(parameter);
            if (paramIndex == -1) {
                throw new VisADException("Parameter does not exist in obs");
            }
            for (int i = 0; i < indexSet.getLength(); ++i) {
                PointOb sample = (PointOb)obs.getSample(i);
                Tuple data = (Tuple)sample.getData();
                Real parm = (Real)data.getComponent(paramIndex);
                PointObTuple newPO = new PointObTuple(sample.getEarthLocation(), sample.getDateTime(), new RealTuple(new Real[]{parm}));
                if (subset == null) {
                    FunctionType subsetType = new FunctionType(((SetType)indexSet.getType()).getDomain(), newPO.getType());
                    subset = new FieldImpl(subsetType, indexSet);
                }
                subset.setSample(i, (Data)newPO, false);
            }
        }
        return subset;
    }

    public static double[] getBoundingBox(FieldImpl pointObs) throws VisADException, RemoteException {
        boolean isTimeSequence = GridUtil.isTimeSequence(pointObs);
        if (isTimeSequence) {
            double[] bbox = null;
            Set timeSet = pointObs.getDomainSet();
            int numTimes = timeSet.getLength();
            for (int i = 0; i < numTimes; ++i) {
                FieldImpl oneTime = (FieldImpl)pointObs.getSample(i);
                double[] tmp = PointObFactory.getBoundingBoxOneTime(oneTime);
                if (bbox == null) {
                    bbox = tmp;
                    continue;
                }
                bbox[0] = Math.min(bbox[0], tmp[0]);
                bbox[1] = Math.min(bbox[1], tmp[1]);
                bbox[2] = Math.max(bbox[0], tmp[2]);
                bbox[3] = Math.max(bbox[1], tmp[3]);
            }
            return bbox;
        }
        return PointObFactory.getBoundingBoxOneTime(pointObs);
    }

    public static double[] getBoundingBoxOneTime(FieldImpl pointObs) throws VisADException, RemoteException {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        if (!pointObs.isMissing()) {
            Set domainSet = pointObs.getDomainSet();
            int numObs = domainSet.getLength();
            for (int i = 0; i < numObs; ++i) {
                PointOb ob = (PointOb)pointObs.getSample(i);
                LatLonPoint llp = ob.getEarthLocation().getLatLonPoint();
                double lat = llp.getLatitude().getValue(CommonUnit.degree);
                double lon = llp.getLongitude().getValue(CommonUnit.degree);
                if (lat != lat || lon != lon) continue;
                if (Math.abs(lat) <= 90.0) {
                    minY = Math.min(minY, lat);
                    maxY = Math.max(maxY, lat);
                }
                if (!(Math.abs(lon) <= 180.0)) continue;
                minX = Math.min(minX, lon);
                maxX = Math.max(maxX, lon);
            }
        }
        double[] bbox = new double[]{minY, minX, maxY, maxX};
        return bbox;
    }

    public static double heatIndex(double T, double RH) {
        double heatIndex = 0.0;
        double hidx = 0.5 * (T + 61.0 + (T - 68.0) * 1.2 + RH * 0.094);
        double avg = (hidx + T) * 0.5;
        if (avg > 80.0) {
            double adj = 0.0;
            heatIndex = -42.379 + 2.04901523 * T + 10.14333127 * RH - 0.22475541 * T * RH - 0.00683783 * T * T - 0.05481717 * RH * RH + 0.00122874 * T * T * RH + 8.5282E-4 * T * RH * RH - 1.99E-6 * T * T * RH * RH;
            if (RH < 13.0 && T > 80.0 && T < 112.0) {
                adj = (13.0 - RH) / 4.0 * Math.sqrt((17.0 - Math.abs(T - 95.0)) / 17.0);
            } else if (RH > 85.0 && T > 80.0 && T < 87.0) {
                adj = -((RH - 85.0) / 10.0) * ((87.0 - T) / 5.0);
            }
            heatIndex -= adj;
        } else {
            heatIndex = hidx;
        }
        return heatIndex;
    }

    public static double windChill(double speed, double T) {
        double windChill = 35.74 + 0.6215 * T - 35.75 * Math.pow(speed, 0.16) + 0.4275 * T * Math.pow(speed, 0.16);
        return windChill;
    }

    public static double relativeHumidity(double T, double TD) {
        double rh = 100.0f * (float)(Math.exp(17.625 * TD / (243.04 + TD)) / Math.exp(17.625 * T / (243.04 + T)));
        return rh;
    }
}

