/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import au.gov.bom.aifs.osa.analysis.Barnes;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataAlias;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataOperand;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSelectionComponent;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.idv.ui.PlotModelComponent;
import ucar.unidata.idv.ui.ValueSliderComponent;
import ucar.unidata.ui.TimeLengthField;
import ucar.unidata.ui.symbol.StationModel;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.util.WrapperException;
import ucar.visad.Util;
import visad.Data;
import visad.FieldImpl;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;

public abstract class PointDataSource
extends FilesDataSource {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(PointDataSource.class.getName());
    public static final String PROP_FIRSTGUESS = "prop.firstguess";
    public static final String PROP_GRID_X = "prop.grid.x";
    public static final String PROP_GRID_Y = "prop.grid.y";
    public static final String PROP_GRID_UNIT = "prop.grid.unit";
    public static final String PROP_GRID_NUMPASSES = "prop.grid.numpasses";
    public static final String PROP_GRID_GAIN = "prop.grid.gain";
    public static final String PROP_GRID_SEARCH_RADIUS = "prop.grid.search.radius";
    public static final String PROP_GRID_PARAM = "prop.grid.param";
    public static final String PROP_STATIONMODELNAME = "prop.stationmodelname";
    public static final String PROP_STATIONMODELSCALE = "prop.stationmodelscale";
    public static final String STATION_DATA = "Station Data";
    public static final String POINT_DATA = "Point Data";
    public static final String STATION_PLOT = "PointPlot";
    private List pointCategories = null;
    protected String fieldsDescription;
    private double binRoundTo = 0.0;
    private double binWidth = 0.0;
    private TimeLengthField binWidthField;
    private TimeLengthField binRoundToField;
    private JComboBox roundToCbx;
    private JComboBox widthCbx;
    private static final float GRID_DEFAULT = 2.0f;
    private float gridX = 2.0f;
    private float gridY = 2.0f;
    private static final String SPACING_COMPUTE = "spacing.compute";
    private static final String SPACING_DEGREES = "spacing.degrees";
    private static final String SPACING_POINTS = "spacing.points";
    private static final String[] SPACING_IDS = new String[]{"spacing.compute", "spacing.degrees", "spacing.points"};
    private static final String[] SPACING_NAMES = new String[]{"Automatic", "Degrees", "# Points"};
    private String gridUnit = "spacing.compute";
    private int numGridPasses = 2;
    private float gridGain = 1.0f;
    private static float DEFAULT_RADIUS = 10.0f;
    private float gridSearchRadius = DEFAULT_RADIUS;
    private boolean makeGridFields = true;
    private JCheckBox makeGridFieldsCbx;
    private GridParameters gridProperties;

    public PointDataSource() throws VisADException {
        this.init();
    }

    public PointDataSource(DataSourceDescriptor descriptor, String source, String description, Hashtable properties) throws VisADException {
        this(descriptor, Misc.toList(new String[]{source}), description, properties);
    }

    public PointDataSource(DataSourceDescriptor descriptor, List sources, String name, Hashtable properties) throws VisADException {
        super(descriptor, sources, sources.size() > 1 ? POINT_DATA : (String)sources.get(0), name, properties);
        try {
            this.init();
        }
        catch (VisADException exc) {
            this.setInError(true);
            throw exc;
        }
    }

    protected void init() throws VisADException {
    }

    @Override
    protected void initDataSelectionComponents(List<DataSelectionComponent> components, DataChoice dataChoice) {
        if (dataChoice instanceof CompositeDataChoice || !(dataChoice.getId() instanceof List)) {
            components.add(new PlotModelSelectionComponent(this));
        } else {
            components.add(this.initGridParameters());
        }
    }

    protected GridParameters initGridParameters() {
        return new GridParameters(this);
    }

    @Override
    public boolean canAddCurrentName(DataChoice dataChoice) {
        return false;
    }

    @Override
    public void getPropertiesComponents(List comps) {
        super.getPropertiesComponents(comps);
        this.binWidthField = new TimeLengthField("Bin Width", true);
        this.binRoundToField = new TimeLengthField("Bin Round To", true);
        this.binWidthField.setTime(this.binWidth);
        this.binRoundToField.setTime(this.binRoundTo);
        List roundToItems = Misc.toList(new Object[]{new TwoFacedObject((Object)"Change", new Double(0.0)), new TwoFacedObject((Object)"On the hour", new Double(60.0)), new TwoFacedObject((Object)"5 after", new Double(5.0)), new TwoFacedObject((Object)"10 after", new Double(10.0)), new TwoFacedObject((Object)"15 after", new Double(15.0)), new TwoFacedObject((Object)"20 after", new Double(20.0)), new TwoFacedObject((Object)"30 after", new Double(30.0)), new TwoFacedObject((Object)"45 after", new Double(45.0)), new TwoFacedObject((Object)"10 to", new Double(50.0)), new TwoFacedObject((Object)"5 to", new Double(55.0))});
        this.roundToCbx = GuiUtils.makeComboBox(roundToItems, roundToItems.get(0), false, this, "setRoundToFromComboBox");
        List widthItems = Misc.toList(new Object[]{new TwoFacedObject((Object)"Change", new Double(0.0)), new TwoFacedObject((Object)"5 minutes", new Double(5.0)), new TwoFacedObject((Object)"10 minutes", new Double(10.0)), new TwoFacedObject((Object)"15 minutes", new Double(15.0)), new TwoFacedObject((Object)"20 minutes", new Double(20.0)), new TwoFacedObject((Object)"30 minutes", new Double(30.0)), new TwoFacedObject((Object)"45 minutes", new Double(45.0)), new TwoFacedObject((Object)"1 hour", new Double(60.0)), new TwoFacedObject((Object)"6 hours", new Double(360.0)), new TwoFacedObject((Object)"12 hours", new Double(720.0)), new TwoFacedObject((Object)"1 day", new Double(1440.0))});
        this.widthCbx = GuiUtils.makeComboBox(widthItems, widthItems.get(0), false, this, "setWidthFromComboBox");
        comps.add(GuiUtils.filler());
        comps.add(this.getPropertiesHeader("Time Binning"));
        comps.add(GuiUtils.rLabel("Bin Size:"));
        comps.add(GuiUtils.left(GuiUtils.hbox((Component)this.binWidthField.getContents(), (Component)this.widthCbx, 5)));
        comps.add(GuiUtils.rLabel("Round To:"));
        comps.add(GuiUtils.left(GuiUtils.hbox((Component)this.binRoundToField.getContents(), (Component)this.roundToCbx, 5)));
    }

    @Override
    public void addPropertiesTabs(JTabbedPane tabbedPane) {
        super.addPropertiesTabs(tabbedPane);
        ArrayList<Component> comps = new ArrayList<Component>();
        this.gridProperties = new GridParameters(this);
        this.makeGridFieldsCbx = new JCheckBox("Make Grid Fields", this.makeGridFields);
        comps.add(GuiUtils.filler());
        comps.add(GuiUtils.left(this.makeGridFieldsCbx));
        comps.addAll(this.gridProperties.comps);
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        tabbedPane.addTab("Objective Analysis", GuiUtils.topLeft(GuiUtils.doLayout(comps, 2, GuiUtils.WT_NN, GuiUtils.WT_N)));
    }

    public void setRoundToFromComboBox(TwoFacedObject tfo) {
        double value = (Double)tfo.getId();
        if (value == 0.0) {
            return;
        }
        this.binRoundToField.setTime(value);
        this.roundToCbx.setSelectedIndex(0);
    }

    public void setWidthFromComboBox(TwoFacedObject tfo) {
        double value = (Double)tfo.getId();
        if (value == 0.0) {
            return;
        }
        this.binWidthField.setTime(value);
        this.widthCbx.setSelectedIndex(0);
    }

    @Override
    public boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        boolean changed = false;
        String what = "";
        try {
            what = "Bad bin value";
            changed |= this.binRoundToField.getTime() != this.binRoundTo || this.binWidth != this.binWidthField.getTime();
            this.binRoundTo = this.binRoundToField.getTime();
            this.binWidth = this.binWidthField.getTime();
            what = "Bad grid points X value";
            changed |= this.gridX != this.gridProperties.getGridX();
            what = "Bad grid points Y value";
            changed |= this.gridY != this.gridProperties.getGridY();
            what = "Bad grid passes value";
            changed |= this.numGridPasses != this.gridProperties.getNumGridPasses();
            what = "Bad grid unit value";
            changed |= !this.gridUnit.equals(this.gridProperties.getGridUnit());
            what = "Bad grid search value";
            changed |= this.gridSearchRadius != this.gridProperties.getGridSearchRadius();
            what = "Bad grid gain value";
            changed |= this.gridGain != this.gridProperties.getGridGain();
        }
        catch (NumberFormatException nfe) {
            LogUtil.userErrorMessage(what);
            return false;
        }
        this.gridX = this.gridProperties.getGridX();
        this.gridY = this.gridProperties.getGridY();
        this.gridUnit = this.gridProperties.getGridUnit();
        this.numGridPasses = this.gridProperties.getNumGridPasses();
        this.gridGain = this.gridProperties.getGridGain();
        this.gridSearchRadius = this.gridProperties.getGridSearchRadius();
        if (this.makeGridFields != this.makeGridFieldsCbx.isSelected()) {
            this.makeGridFields = this.makeGridFieldsCbx.isSelected();
            this.dataChoices = null;
            this.getDataChoices();
            this.getDataContext().dataSourceChanged(this);
        }
        if (changed) {
            this.flushCache();
        }
        return true;
    }

    protected boolean canCreateGrid(RealType type) {
        return true;
    }

    protected FieldImpl getSample(DataChoice dataChoice) throws Exception {
        return null;
    }

    @Override
    public void reloadData() {
        this.dataChoices = null;
        this.getDataChoices();
        super.reloadData();
    }

    @Override
    public void doMakeDataChoices() {
        if (this.sources == null) {
            return;
        }
        String stationModelName = (String)this.getProperty(PROP_STATIONMODELNAME);
        String stationModelScale = (String)this.getProperty(PROP_STATIONMODELSCALE);
        Hashtable properties = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/Placemark16.gif");
        if (stationModelName != null) {
            properties.put(PROP_STATIONMODELNAME, stationModelName);
        }
        if (stationModelScale != null) {
            properties.put(PROP_STATIONMODELSCALE, stationModelScale);
        }
        if (!this.getDefaultLevels().isEmpty()) {
            properties.put("default_levels", this.getDefaultLevels());
        }
        CompositeDataChoice uberChoice = null;
        if (this.sources.size() > 1) {
            uberChoice = new CompositeDataChoice((DataSource)this, (Object)this.sources, this.getName(), this.getDataName(), this.getPointCategories(), properties);
            this.addDataChoice(uberChoice);
        }
        for (int i = 0; i < this.sources.size(); ++i) {
            String dataChoiceDesc = this.getDescription();
            String dataChoiceName = this.getDataName();
            if (uberChoice != null) {
                dataChoiceDesc = IOUtil.getFileTail(this.sources.get(i).toString());
                dataChoiceName = IOUtil.getFileTail(this.sources.get(i).toString());
            }
            DirectDataChoice choice = new DirectDataChoice((DataSource)this, (Object)new Integer(i), dataChoiceDesc, dataChoiceName, this.getPointCategories(), properties);
            if (uberChoice != null) {
                uberChoice.addDataChoice(choice);
            } else {
                this.addDataChoice(choice);
            }
            if (i > 0) continue;
            try {
                FieldImpl sample;
                FieldImpl fieldImpl = sample = this.makeGridFields ? this.getSample(choice) : null;
                if (sample == null) continue;
                for (int dataChoiceType = 0; dataChoiceType < 2; ++dataChoiceType) {
                    Hashtable<String, String> seenFields = new Hashtable<String, String>();
                    if (GridUtil.isTimeSequence(sample)) {
                        sample = (FieldImpl)sample.getSample(0);
                    }
                    PointOb ob = (PointOb)sample.getSample(0);
                    Tuple tuple = (Tuple)ob.getData();
                    TupleType tupleType = (TupleType)tuple.getType();
                    MathType[] types = tupleType.getComponents();
                    CompositeDataChoice compositeDataChoice = null;
                    for (int typeIdx = 0; typeIdx < types.length; ++typeIdx) {
                        String name;
                        RealType type;
                        if (!(types[typeIdx] instanceof RealType) || !this.canCreateGrid(type = (RealType)types[typeIdx])) continue;
                        List gridCategories = DataCategory.parseCategories("GRID-2D-TIME;", false);
                        if (compositeDataChoice == null) {
                            compositeDataChoice = new CompositeDataChoice((DataSource)this, (Object)"", "Grid Fields from Objective Analysis", "Gridded Fields " + (dataChoiceType == 0 ? "" : "(with first guess)"), Misc.newList(DataCategory.NONE_CATEGORY), null);
                            this.addDataChoice(compositeDataChoice);
                        }
                        if (seenFields.get(name = Util.cleanTypeName(type.toString())) != null) continue;
                        seenFields.put(name, name);
                        List idList = Misc.newList(new Integer(i), type);
                        if (dataChoiceType == 1) {
                            idList.add(new Boolean(true));
                        }
                        DirectDataChoice gridChoice = new DirectDataChoice((DataSource)this, (Object)idList, name, name, gridCategories, properties);
                        compositeDataChoice.addDataChoice(gridChoice);
                    }
                }
                continue;
            }
            catch (Exception exc) {
                throw new WrapperException("Making grid parameters", exc);
            }
        }
    }

    protected String getSource(DataChoice dataChoice) {
        Object id = dataChoice.getId();
        if (id instanceof String) {
            return (String)id;
        }
        if (id instanceof Integer) {
            int idx = (Integer)id;
            return (String)this.sources.get(idx);
        }
        if (dataChoice instanceof CompositeDataChoice) {
            return (String)this.sources.get(0);
        }
        return null;
    }

    protected List getPointCategories() {
        if (this.pointCategories == null) {
            this.pointCategories = DataCategory.parseCategories("POINT;PointPlot", false);
        }
        return this.pointCategories;
    }

    public String getDataName() {
        return POINT_DATA;
    }

    @Override
    protected boolean shouldCache(DataChoice dataChoice, Data data) {
        List idList;
        Object id = dataChoice.getId();
        if (!(dataChoice instanceof CompositeDataChoice) && id instanceof List && (idList = (List)id).size() > 2) {
            boolean doFirstGuessField = (Boolean)idList.get(2);
            return !doFirstGuessField;
        }
        return super.shouldCache(dataChoice, data);
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        Object id = dataChoice.getId();
        boolean doGriddedData = false;
        if (id instanceof List && ((List)id).get(0) instanceof Integer) {
            doGriddedData = true;
        }
        if (doGriddedData) {
            String theUnit;
            List idList = (List)id;
            RealType type = (RealType)idList.get(1);
            Hashtable<String, RealType> properties = dataChoice.getProperties();
            if (properties == null) {
                properties = new Hashtable<String, RealType>();
            }
            Data firstGuessData = null;
            boolean doFirstGuessField = false;
            if (idList.size() > 2) {
                doFirstGuessField = (Boolean)idList.get(2);
            }
            if (doFirstGuessField) {
                DataChoice firstGuessDataChoice = (DataChoice)dataChoice.getProperty(PROP_FIRSTGUESS);
                if (firstGuessDataChoice == null) {
                    ArrayList<DataOperand> operands = new ArrayList<DataOperand>();
                    List categories = DataCategory.parseCategories("GRID-2D-TIME;GRID-3D-TIME", false);
                    operands.add(new DataOperand("First Guess Field", "First Guess Field", categories, false));
                    List userValues = this.getDataContext().selectDataChoices(operands);
                    if (userValues == null) {
                        return null;
                    }
                    firstGuessDataChoice = (DataChoice)userValues.get(0);
                    dataChoice.setObjectProperty(PROP_FIRSTGUESS, firstGuessDataChoice);
                }
                if (firstGuessDataChoice != null && (firstGuessData = firstGuessDataChoice.getData(null)) == null) {
                    return null;
                }
            }
            properties.put(PROP_GRID_PARAM, type);
            FieldImpl pointObs = null;
            ArrayList<FieldImpl> datas = new ArrayList<FieldImpl>();
            for (int i = 0; i < this.sources.size(); ++i) {
                DirectDataChoice choice = new DirectDataChoice((DataSource)this, (Object)new Integer(i), "", "", dataChoice.getCategories(), properties);
                pointObs = (FieldImpl)this.getDataInner(choice, category, dataSelection, requestProperties);
                if (pointObs == null) continue;
                datas.add(pointObs);
            }
            if (datas.size() == 0) {
                return null;
            }
            pointObs = PointObFactory.mergeData(datas);
            if (pointObs == null) {
                return null;
            }
            float spacingX = this.gridX;
            float spacingY = this.gridY;
            int passes = this.numGridPasses;
            float gain = this.gridGain;
            float searchRadius = this.gridSearchRadius;
            Number tmp = (Float)dataSelection.getProperty(PROP_GRID_X);
            if (tmp != null) {
                spacingX = tmp.floatValue();
            }
            if ((tmp = (Float)dataSelection.getProperty(PROP_GRID_Y)) != null) {
                spacingY = tmp.floatValue();
            }
            if ((tmp = (Integer)dataSelection.getProperty(PROP_GRID_NUMPASSES)) != null) {
                passes = tmp.intValue();
            }
            if ((theUnit = (String)dataSelection.getProperty(PROP_GRID_UNIT)) == null) {
                theUnit = this.gridUnit;
            }
            if ((tmp = (Float)dataSelection.getProperty(PROP_GRID_GAIN)) != null) {
                gain = tmp.floatValue();
            }
            if ((tmp = (Float)dataSelection.getProperty(PROP_GRID_SEARCH_RADIUS)) != null) {
                searchRadius = tmp.floatValue();
            }
            float degreesX = 0.0f;
            float degreesY = 0.0f;
            pointObs = PointObFactory.makeTimeSequenceOfPointObs(pointObs);
            if (theUnit.equals(SPACING_COMPUTE) || spacingX <= 0.0f || spacingY <= 0.0f) {
                degreesX = 0.0f;
                degreesY = 0.0f;
                if (searchRadius == DEFAULT_RADIUS && firstGuessData == null) {
                    searchRadius = 0.0f;
                }
            } else if (theUnit.equals(SPACING_POINTS)) {
                double[] bbox = PointObFactory.getBoundingBox(pointObs);
                float spanX = (float)Math.abs(bbox[1] - bbox[3]);
                float spanY = (float)Math.abs(bbox[0] - bbox[2]);
                degreesX = spanX / (float)((int)spacingX);
                degreesY = spanY / (float)((int)spacingY);
            } else if (theUnit.equals(SPACING_DEGREES)) {
                degreesX = spacingX;
                degreesY = spacingY;
            }
            Barnes.AnalysisParameters ap = new Barnes.AnalysisParameters((double)degreesX, (double)degreesY, (double)searchRadius, 0.0);
            log_.debug("X = " + degreesX + " Y = " + degreesY + " unit = " + theUnit + " gain = " + gain + " search = " + searchRadius);
            LogUtil.message("Doing Barnes Analysis");
            FieldImpl fi = PointObFactory.barnes(pointObs, type, degreesX, degreesY, passes, gain, searchRadius, ap, (FieldImpl)firstGuessData);
            if (ap.getGridXArray() != null) {
                log_.debug("Analysis params: X = " + ap.getGridXArray().length + " Y = " + ap.getGridYArray().length + " search = " + ap.getScaleLengthGU() + " random = " + ap.getRandomDataSpacing());
            }
            return fi;
        }
        GeoSelection geoSelection = dataSelection != null ? dataSelection.getGeoSelection() : null;
        GeoLocationInfo bbox = geoSelection == null ? null : geoSelection.getBoundingBox();
        LatLonRect llr = bbox != null ? bbox.getLatLonRect() : null;
        FieldImpl retField = null;
        try {
            List choices = dataChoice instanceof CompositeDataChoice ? ((CompositeDataChoice)dataChoice).getDataChoices() : Misc.toList(new DataChoice[]{dataChoice});
            ArrayList<FieldImpl> datas = new ArrayList<FieldImpl>(choices.size());
            for (int i = 0; i < choices.size(); ++i) {
                DataChoice subDataChoice = (DataChoice)choices.get(i);
                FieldImpl obs = this.makeObs(subDataChoice, dataSelection, llr);
                if (obs == null) continue;
                datas.add(obs);
                if (this.fieldsDescription != null) continue;
                this.makeFieldDescription(obs);
            }
            if (datas.isEmpty()) {
                return null;
            }
            retField = PointObFactory.mergeData(datas);
        }
        catch (Exception exc) {
            this.logException("Creating obs", exc);
        }
        return retField;
    }

    @Override
    protected void makeDerivedDataChoices(List dataChoices) {
    }

    @Override
    public String getFullDescription() {
        String parentDescription = super.getFullDescription();
        if (this.fieldsDescription == null) {
            try {
                FieldImpl fi = this.getSample(this.getDescriptionDataChoice());
                this.makeFieldDescription(fi);
            }
            catch (Exception exc) {
                this.logException("getting description", exc);
                return "";
            }
        }
        return parentDescription + "<p>" + (this.fieldsDescription != null ? this.fieldsDescription : "");
    }

    protected DataChoice getDescriptionDataChoice() {
        return (DataChoice)this.getDataChoices().get(0);
    }

    protected void makeFieldDescription(FieldImpl fi) {
        if (fi == null) {
            this.fieldsDescription = "Bad data: null";
            return;
        }
        try {
            if (GridUtil.isTimeSequence(fi)) {
                fi = (FieldImpl)fi.getSample(0);
            }
            PointOb ob = (PointOb)fi.getSample(0);
            Tuple tuple = (Tuple)ob.getData();
            MathType[] comps = ((TupleType)tuple.getType()).getComponents();
            Trace.msg("PointDataSource #vars=" + comps.length);
            StringBuffer params = new StringBuffer(comps.length + " Fields:<ul>");
            String dataSourceName = this.getName();
            DataChoice.addCurrentName(new TwoFacedObject((Object)"Point Data>Time", "Time"));
            DataChoice.addCurrentName(new TwoFacedObject((Object)"Point Data>Latitude", "Latitude"));
            DataChoice.addCurrentName(new TwoFacedObject((Object)"Point Data>Altitude", "Altitude"));
            for (int i = 0; i < comps.length; ++i) {
                Unit unit;
                params.append("<li>");
                String paramName = Util.cleanTypeName(comps[i].toString());
                DataAlias alias = DataAlias.findAlias(paramName);
                params.append(paramName);
                if (alias != null) {
                    params.append(" --  " + alias.getLabel());
                    DataChoice.addCurrentName(new TwoFacedObject((Object)(dataSourceName + ">" + alias.getLabel() + " -- " + paramName), paramName));
                } else {
                    DataChoice.addCurrentName(new TwoFacedObject((Object)(dataSourceName + ">" + paramName), paramName));
                }
                Data data = tuple.getComponent(i);
                if (!(data instanceof Real) || (unit = ((Real)data).getUnit()) == null) continue;
                params.append("  [" + unit.toString() + "]");
            }
            this.fieldsDescription = params.toString();
        }
        catch (Exception exc) {
            this.logException("getting description", exc);
        }
    }

    @Override
    public void doRemove() {
        super.doRemove();
        if (this.gridProperties != null) {
            this.gridProperties.doRemove();
        }
    }

    protected abstract FieldImpl makeObs(DataChoice var1, DataSelection var2, LatLonRect var3) throws Exception;

    protected List getDefaultLevels() {
        return new ArrayList();
    }

    @Override
    public void setSource(String value) {
        this.setSources(Misc.toList(new String[]{value}));
    }

    public void setBinWidth(double value) {
        this.binWidth = value;
    }

    public double getBinWidth() {
        return this.binWidth;
    }

    public void setBinRoundTo(double value) {
        this.binRoundTo = value;
    }

    public double getBinRoundTo() {
        return this.binRoundTo;
    }

    public void setGridX(float value) {
        this.gridX = value;
    }

    public float getGridX() {
        return this.gridX;
    }

    public void setGridY(float value) {
        this.gridY = value;
    }

    public float getGridY() {
        return this.gridY;
    }

    public void setGridUnit(String value) {
        this.gridUnit = value;
    }

    public String getGridUnit() {
        return this.gridUnit;
    }

    public void setNumGridPasses(int value) {
        this.numGridPasses = value;
    }

    public int getNumGridPasses() {
        return this.numGridPasses;
    }

    public void setGridGain(float value) {
        this.gridGain = value;
    }

    public float getGridGain() {
        return this.gridGain;
    }

    public void setGridSearchRadius(float value) {
        this.gridSearchRadius = value;
    }

    public float getGridSearchRadius() {
        return this.gridSearchRadius;
    }

    public void setMakeGridFields(boolean value) {
        this.makeGridFields = value;
    }

    public boolean getMakeGridFields() {
        return this.makeGridFields;
    }

    @Override
    public boolean canDoAllLevels() {
        return false;
    }

    private static class GridParameters
    extends DataSelectionComponent {
        PointDataSource pointDataSource;
        private JCheckBox useDefaultCbx = new JCheckBox("Use Default", true);
        private JTextField gridXFld;
        private JTextField gridYFld;
        private JComboBox gridUnitCmbx;
        private JTextField numGridPassesFld;
        private List comps = new ArrayList();
        private JComponent comp;
        private JComponent sizeComp;
        private ValueSliderComponent gainComp;
        private ValueSliderComponent searchComp;
        boolean useCompute = true;
        List tfos;

        public GridParameters(PointDataSource pointDataSource) {
            super("Grid Parameters");
            this.pointDataSource = pointDataSource;
            this.gridXFld = new JTextField("" + pointDataSource.gridX, 4);
            this.gridXFld.setToolTipText("X spacing in spacing units");
            this.gridYFld = new JTextField("" + pointDataSource.gridY, 4);
            this.gridYFld.setToolTipText("Y spacing in spacing units");
            this.gridUnitCmbx = new JComboBox();
            this.gridUnitCmbx.setToolTipText("Set grid spacing option");
            this.tfos = TwoFacedObject.createList(SPACING_IDS, SPACING_NAMES);
            GuiUtils.setListData(this.gridUnitCmbx, this.tfos);
            this.gridUnitCmbx.setSelectedItem(TwoFacedObject.findId(pointDataSource.gridUnit, this.tfos));
            this.gridUnitCmbx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TwoFacedObject tfo = (TwoFacedObject)((JComboBox)ae.getSource()).getSelectedItem();
                    if (tfo != null) {
                        useCompute = tfo.getId().equals(SPACING_IDS[0]);
                        this.enableAutoComps(!useCompute);
                    }
                }
            });
            this.gainComp = new ValueSliderComponent(pointDataSource, 0, 1, "gridGain", "Gain", 10.0f, false, "Factor by which scaleLength is reduced for the second pass");
            this.searchComp = new ValueSliderComponent(pointDataSource, 0, 20, "gridSearchRadius", "Search Radius", 1.0f, false, "Search radius in grid units for weighting");
            this.numGridPassesFld = new JTextField("" + pointDataSource.numGridPasses, 4);
            this.numGridPassesFld.setToolTipText("Set the number of passes for the Barnes analysis");
            this.comps.add(GuiUtils.rLabel("Spacing:"));
            this.comps.add(GuiUtils.left(this.gridUnitCmbx));
            this.comps.add(GuiUtils.rLabel("Grid Size:"));
            this.sizeComp = GuiUtils.left(GuiUtils.hbox((Component)new JLabel("X: "), (Component)this.gridXFld, (Component)new JLabel("  Y: "), this.gridYFld));
            this.comps.add(this.sizeComp);
            this.comps.add(GuiUtils.rLabel("Passes:"));
            this.comps.add(GuiUtils.left(this.numGridPassesFld));
            this.comps.add(GuiUtils.rLabel("Search Radius:"));
            this.comps.add(GuiUtils.left(this.searchComp.getContents(false)));
            this.comps.add(GuiUtils.rLabel("Gain:"));
            this.comps.add(GuiUtils.left(this.gainComp.getContents(false)));
            this.enableAutoComps(!this.useCompute);
            this.useDefaultCbx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    this.checkEnable();
                }
            });
        }

        public void checkEnable() {
            GuiUtils.enableTree(this.comp, !this.useDefaultCbx.isSelected());
            if (!this.useDefaultCbx.isSelected()) {
                this.enableAutoComps(!this.useCompute);
            }
        }

        private void enableAutoComps(boolean enable) {
            GuiUtils.enableTree(this.sizeComp, enable);
        }

        @Override
        protected JComponent doMakeContents() {
            GuiUtils.tmpInsets = GuiUtils.INSETS_5;
            this.comp = GuiUtils.doLayout(this.comps, 2, GuiUtils.WT_N, GuiUtils.WT_N);
            if (this.dataSelection != null) {
                Object prop = this.dataSelection.getProperty(PointDataSource.PROP_GRID_X);
                if (prop != null) {
                    this.gridXFld.setText("" + prop);
                    this.useDefaultCbx.setSelected(false);
                }
                if ((prop = this.dataSelection.getProperty(PointDataSource.PROP_GRID_Y)) != null) {
                    this.gridYFld.setText("" + prop);
                }
                if ((prop = this.dataSelection.getProperty(PointDataSource.PROP_GRID_UNIT)) != null) {
                    this.gridUnitCmbx.setSelectedItem(TwoFacedObject.findId(prop, this.tfos));
                }
                if ((prop = this.dataSelection.getProperty(PointDataSource.PROP_GRID_NUMPASSES)) != null) {
                    this.numGridPassesFld.setText("" + prop);
                }
                if ((prop = this.dataSelection.getProperty(PointDataSource.PROP_GRID_GAIN)) != null) {
                    this.gainComp.setValue(((Number)prop).floatValue());
                }
                if ((prop = this.dataSelection.getProperty(PointDataSource.PROP_GRID_SEARCH_RADIUS)) != null) {
                    this.searchComp.setValue(((Number)prop).floatValue());
                }
            }
            this.checkEnable();
            return GuiUtils.topCenter(GuiUtils.right(this.useDefaultCbx), GuiUtils.topLeft(this.comp));
        }

        @Override
        public void applyToDataSelection(DataSelection dataSelection) {
            if (dataSelection != null) {
                if (!this.useDefaultCbx.isSelected()) {
                    dataSelection.putProperty(PointDataSource.PROP_GRID_X, new Float(this.getGridX()));
                    dataSelection.putProperty(PointDataSource.PROP_GRID_Y, new Float(this.getGridY()));
                    dataSelection.putProperty(PointDataSource.PROP_GRID_UNIT, this.getGridUnit());
                    dataSelection.putProperty(PointDataSource.PROP_GRID_NUMPASSES, new Integer(this.getNumGridPasses()));
                    dataSelection.putProperty(PointDataSource.PROP_GRID_GAIN, new Float(this.getGridGain()));
                    dataSelection.putProperty(PointDataSource.PROP_GRID_SEARCH_RADIUS, new Float(this.getGridSearchRadius()));
                } else {
                    dataSelection.removeProperty(PointDataSource.PROP_GRID_X);
                    dataSelection.removeProperty(PointDataSource.PROP_GRID_Y);
                    dataSelection.removeProperty(PointDataSource.PROP_GRID_UNIT);
                    dataSelection.removeProperty(PointDataSource.PROP_GRID_NUMPASSES);
                    dataSelection.removeProperty(PointDataSource.PROP_GRID_GAIN);
                    dataSelection.removeProperty(PointDataSource.PROP_GRID_SEARCH_RADIUS);
                }
            }
        }

        public float getGridX() {
            return (float)GuiUtils.getValue(this.gridXFld);
        }

        public float getGridY() {
            return (float)GuiUtils.getValue(this.gridYFld);
        }

        public String getGridUnit() {
            return TwoFacedObject.getIdString(this.gridUnitCmbx.getSelectedItem());
        }

        public int getNumGridPasses() {
            return GuiUtils.getInt(this.numGridPassesFld);
        }

        public float getGridGain() {
            return this.gainComp.getValue();
        }

        public float getGridSearchRadius() {
            return this.searchComp.getValue();
        }

        public void doRemove() {
            if (this.gainComp != null) {
                this.gainComp.doRemove();
            }
            if (this.searchComp != null) {
                this.searchComp.doRemove();
            }
        }
    }

    public static class PlotModelSelectionComponent
    extends DataSelectionComponent {
        PointDataSource pointDataSource;
        private JComponent comp;
        private PlotModelComponent pmc;

        public PlotModelSelectionComponent(PointDataSource pointDataSource) {
            super("Layout Model");
            this.pointDataSource = pointDataSource;
            this.pmc = new PlotModelComponent(pointDataSource.getDataContext().getIdv(), this, "setPlotModel", null);
        }

        @Override
        protected JComponent doMakeContents() {
            GuiUtils.tmpInsets = GuiUtils.INSETS_5;
            String prop = (String)this.pointDataSource.getProperty(PointDataSource.PROP_STATIONMODELNAME);
            if (this.dataSelection != null) {
                prop = (String)this.dataSelection.getProperty(PointDataSource.PROP_STATIONMODELNAME);
            }
            if (prop != null) {
                this.pmc.setPlotModelByName(prop);
            }
            return GuiUtils.top(GuiUtils.hflow(Misc.newList(new JLabel("Layout Model: "), this.pmc), 5, 5));
        }

        @Override
        public void applyToDataSelection(DataSelection dataSelection) {
            StationModel plotModel;
            if (dataSelection != null && (plotModel = this.getPlotModel()) != null) {
                dataSelection.putProperty(PointDataSource.PROP_STATIONMODELNAME, plotModel.getName());
            }
        }

        public void setPlotModel(StationModel model) {
            this.pmc.setPlotModel(model);
        }

        public StationModel getPlotModel() {
            return this.pmc.getPlotModel();
        }

        @Override
        public boolean getShowInControlProperties() {
            return false;
        }
    }
}

