/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import java.rmi.RemoteException;
import java.util.Hashtable;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataInstance;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.util.Trace;
import visad.FieldImpl;
import visad.LinearLatLonSet;
import visad.VisADException;

public class PointDataInstance
extends DataInstance {
    public FieldImpl pointObs = null;
    private FieldImpl pointObsSequence = null;

    public PointDataInstance(DataChoice choice, DataSelection selection, Hashtable requestProperties) throws VisADException, RemoteException {
        super(choice, selection, requestProperties);
        this.init();
    }

    @Override
    protected void init() throws VisADException, RemoteException {
        if (this.haveBeenInitialized) {
            return;
        }
        super.init();
        if (this.dataOk()) {
            this.pointObs = (FieldImpl)this.getData();
        }
        this.pointObsSequence = null;
    }

    @Override
    public void reInitialize() throws VisADException, RemoteException {
        this.pointObs = null;
        this.pointObsSequence = null;
        super.reInitialize();
    }

    public FieldImpl getTimeSequence() throws VisADException, RemoteException {
        this.checkInit();
        FieldImpl pointObs = this.getPointObs();
        if (this.pointObsSequence == null) {
            this.pointObsSequence = PointObFactory.makeTimeSequenceOfPointObs(pointObs);
        }
        return this.pointObsSequence;
    }

    public FieldImpl getTimeSequence(LinearLatLonSet bounds) throws VisADException, RemoteException {
        if (bounds == null) {
            return this.getTimeSequence();
        }
        this.checkInit();
        return PointObFactory.subSet(this.getTimeSequence(), bounds);
    }

    public FieldImpl getPointObs() throws VisADException, RemoteException {
        this.checkInit();
        if (this.pointObs == null) {
            this.pointObs = (FieldImpl)this.getData();
        }
        return this.pointObs;
    }

    public FieldImpl getPointObs(LinearLatLonSet bounds) throws VisADException, RemoteException {
        Trace.msg("getPointObs-1");
        if (bounds == null) {
            return this.getPointObs();
        }
        Trace.msg("getPointObs-2");
        this.checkInit();
        Trace.msg("getPointObs-3");
        FieldImpl result = PointObFactory.subSet(this.getPointObs(), bounds);
        Trace.msg("getPointObs-1");
        return result;
    }
}

