/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTextField;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.UtmInfo;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.geoloc.projection.UtmProjection;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.visad.Util;
import visad.CoordinateSystem;
import visad.Data;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.LinearLatLonSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADException;

public class PointCloudDataSource
extends FilesDataSource {
    public static final float GRID_MISSING = -99999.9f;
    public static final int INDEX_ALT = 0;
    public static final int INDEX_LON = 1;
    public static final int INDEX_LAT = 2;
    private int skip = 10;
    private JTextField skipFld;
    private String delimiter = ",";
    private JTextField delimiterFld;
    private JTextField colorByIndexFld;
    private int colorByIndex = 3;
    UtmInfo utmInfo = new UtmInfo();
    private String header;
    protected String fieldName;
    private int gridWidth = 800;
    private int gridHeight = 800;
    private JTextField gridWidthFld;
    private JTextField gridHeightFld;
    private float hillShadeAzimuth = 315.0f;
    private float hillShadeAngle = 45.0f;
    private JTextField hillShadeAzimuthFld;
    private JTextField hillShadeAngleFld;
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(PointCloudDataSource.class.getName());
    private static int typeCnt = 0;

    public PointCloudDataSource() {
    }

    public PointCloudDataSource(DataSourceDescriptor descriptor, String filename, Hashtable properties) {
        super(descriptor, filename, "Point cloud data source", properties);
        String tmp = (String)this.getProperty("delimiter");
        if (tmp != null) {
            this.delimiter = tmp;
        }
    }

    public PointCloudDataSource(DataSourceDescriptor descriptor, List sources, String name, Hashtable properties) throws VisADException {
        super(descriptor, sources, sources.get(0).toString(), properties);
    }

    @Override
    public boolean canDoGeoSelection() {
        String filePath = this.getFilePath();
        return filePath.indexOf("${bbox}") >= 0 || filePath.indexOf("${area.north}") >= 0;
    }

    @Override
    protected boolean canDoGeoSelectionStride() {
        return false;
    }

    @Override
    protected ProjectionImpl getSampleDataProjection() {
        try {
            String filePath = this.getFilePath();
            if (filePath.indexOf("defaultbbox=") < 0) {
                return null;
            }
            String query = new URL(filePath).getQuery();
            for (String pair : StringUtil.split(query, "&", true, true)) {
                if (!pair.startsWith("defaultbbox=")) continue;
                List<String> toks = StringUtil.split(pair.substring("defaultbbox=".length()), ",", true, true);
                if (toks.size() != 4) {
                    return null;
                }
                double west = Double.parseDouble(toks.get(0));
                double south = Double.parseDouble(toks.get(1));
                double east = Double.parseDouble(toks.get(2));
                double north = Double.parseDouble(toks.get(3));
                ProjectionRect rect = new ProjectionRect(west, south, east, north);
                return new LatLonProjection("", rect);
            }
            return null;
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    private boolean canSkip() {
        String filePath = this.getFilePath();
        File f = new File(filePath);
        if (!f.exists()) {
            return filePath.indexOf("${skip}") >= 0;
        }
        return true;
    }

    private boolean serverHandlesSkip() {
        return this.canSkip() && !new File(this.getFilePath()).exists();
    }

    @Override
    public void getPropertiesComponents(List comps) {
        super.getPropertiesComponents(comps);
        String filePath = this.getFilePath();
        File f = new File(filePath);
        this.skipFld = new JTextField("" + this.skip, 5);
        this.gridWidthFld = new JTextField("" + this.gridWidth, 5);
        this.gridHeightFld = new JTextField("" + this.gridHeight, 5);
        this.hillShadeAzimuthFld = new JTextField("" + this.hillShadeAzimuth, 5);
        this.hillShadeAngleFld = new JTextField("" + this.hillShadeAngle, 5);
        this.delimiterFld = new JTextField(this.delimiter, 3);
        this.colorByIndexFld = new JTextField("" + this.colorByIndex, 3);
        if (this.header != null) {
            comps.add(GuiUtils.rLabel("Header:"));
            comps.add(GuiUtils.lLabel(this.header));
        }
        if (this.canSkip()) {
            comps.add(GuiUtils.rLabel("Skip:"));
            comps.add(GuiUtils.left(GuiUtils.hbox(this.skipFld, new JLabel("-1 = default"))));
        }
        comps.add(GuiUtils.rLabel("Delimiter:"));
        comps.add(GuiUtils.left(this.delimiterFld));
        comps.add(GuiUtils.rLabel("Color by index:"));
        comps.add(GuiUtils.left(this.colorByIndexFld));
        this.utmInfo.getPropertiesComponents(comps);
        comps.add(GuiUtils.rLabel("Grid Dimensions:"));
        comps.add(GuiUtils.left(GuiUtils.hbox((Component)this.gridWidthFld, (Component)new JLabel(" X "), this.gridHeightFld)));
        comps.add(GuiUtils.rLabel("Hill Shading:"));
        comps.add(GuiUtils.left(GuiUtils.hbox((Component)GuiUtils.label("Azimuth:", this.hillShadeAzimuthFld), GuiUtils.label("Angle:", this.hillShadeAngleFld))));
    }

    @Override
    public boolean applyProperties() {
        if (!super.applyProperties()) {
            return false;
        }
        this.utmInfo.applyProperties();
        if (this.skipFld == null) {
            return true;
        }
        this.skip = new Integer(this.skipFld.getText().trim());
        this.gridWidth = new Integer(this.gridWidthFld.getText().trim());
        this.gridHeight = new Integer(this.gridHeightFld.getText().trim());
        this.hillShadeAzimuth = Float.parseFloat(this.hillShadeAzimuthFld.getText().trim());
        this.hillShadeAngle = Float.parseFloat(this.hillShadeAngleFld.getText().trim());
        this.colorByIndex = new Integer(this.colorByIndexFld.getText().trim());
        this.delimiter = this.delimiterFld.getText().trim();
        if (this.delimiter.length() == 0) {
            this.delimiter = " ";
        }
        this.flushCache();
        return true;
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        try {
            String filePath = this.getFilePath();
            float[][] pts = this.readPoints(filePath, dataSelection, this.skip);
            RealType rt = null;
            if (pts.length > 3) {
                rt = Util.makeRealType((this.fieldName != null ? this.fieldName : "field") + "_" + typeCnt++, null);
            }
            RealTupleType type = pts.length == 3 ? new RealTupleType(RealType.Altitude, RealType.Longitude, RealType.Latitude) : (pts.length == 6 ? new RealTupleType(new RealType[]{RealType.Altitude, RealType.Longitude, RealType.Latitude, Util.makeRealType("rgb red", null), Util.makeRealType("rgb green", null), Util.makeRealType("rgb blue", null)}) : new RealTupleType(RealType.Altitude, RealType.Longitude, RealType.Latitude, rt));
            if (dataChoice.getId().equals("altitudegrid")) {
                return this.makeGrid(pts, rt, false, false);
            }
            if (dataChoice.getId().equals("hillshadegrid")) {
                return this.makeGrid(pts, rt, true, false);
            }
            if (dataChoice.getId().equals("pointcount")) {
                return this.makeGrid(pts, rt, false, true);
            }
            return PointCloudDataSource.makeField(type, pts);
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    protected float[][] readPoints(String filePath, DataSelection dataSelection, int skipToUse) throws IOException {
        String line;
        BufferedReader reader;
        float[][] pts = null;
        File f = new File(filePath);
        if (this.serverHandlesSkip()) {
            filePath = filePath.replace("${skip}", "" + this.skip);
            skipToUse = 0;
        }
        if (f.exists()) {
            reader = new BufferedReader(new FileReader(f));
        } else {
            GeoLocationInfo gli;
            if (dataSelection.getGeoSelection() != null && (gli = dataSelection.getGeoSelection().getBoundingBox()) != null) {
                String bbox = gli.getMinLon() + "," + gli.getMinLat() + "," + gli.getMaxLon() + "," + gli.getMaxLat();
                filePath = filePath.replace("${bbox}", bbox);
            }
            System.err.println(filePath);
            InputStream inputStream = IOUtil.getInputStream(filePath, this.getClass());
            reader = new BufferedReader(new InputStreamReader(inputStream));
        }
        int pointCnt = 0;
        int numFields = 3;
        boolean latLon = true;
        if (Misc.equals(this.getProperty("latlon"), "false")) {
            latLon = false;
        }
        int skipCnt = 0;
        long t1 = System.currentTimeMillis();
        while ((line = reader.readLine()) != null) {
            if (pointCnt == 0) {
                if (line.toLowerCase().indexOf("latitude") >= 0) {
                    this.header = line;
                    continue;
                }
                if (line.toLowerCase().indexOf("x") >= 0) {
                    this.header = line;
                    continue;
                }
            }
            if (line.startsWith("#")) continue;
            List<String> toks = StringUtil.split(line, this.delimiter, true, true);
            if (toks.size() < 3) {
                System.err.println("Bad line:" + line);
                continue;
            }
            if (skipToUse > 0) {
                if (skipCnt > 0) {
                    --skipCnt;
                    continue;
                }
                skipCnt = skipToUse;
            }
            if (pts == null) {
                numFields = Math.min(4, toks.size());
                numFields = 3;
                pts = new float[numFields][10000];
            } else if (pointCnt >= pts[0].length) {
                pts = Misc.expand(pts);
            }
            float v1 = Float.parseFloat(toks.get(0).toString());
            float v2 = Float.parseFloat(toks.get(1).toString());
            float v3 = Float.parseFloat(toks.get(2).toString());
            float lat = latLon ? v1 : v2;
            float lon = latLon ? v2 : v1;
            float alt = v3;
            if (this.utmInfo.getIsUtm() && this.utmInfo.getIsUtmMeters()) {
                lon /= 1000.0f;
                lat /= 1000.0f;
            }
            pts[0][pointCnt] = alt;
            pts[1][pointCnt] = lon;
            pts[2][pointCnt] = lat;
            if (numFields == 4) {
                pts[3][pointCnt] = Float.parseFloat(toks.get(this.colorByIndex).toString());
            }
            ++pointCnt;
        }
        if (pts == null) {
            throw new BadDataException("No points were read. Bad delimiter?");
        }
        long t2 = System.currentTimeMillis();
        System.err.println("cnt:" + pointCnt + " time:" + (t2 - t1) / 1000L);
        pts = Misc.copy(pts, pointCnt);
        if (this.utmInfo.getIsUtm()) {
            UtmProjection utm = new UtmProjection(this.utmInfo.getUtmZone(), this.utmInfo.getIsUtmNorth());
            float[] lats = pts[2];
            float[] lons = pts[1];
            float[][] result = utm.projToLatLon(new float[][]{lats, lons}, new float[][]{lats, lons});
            pts[2] = lats;
            pts[1] = lons;
        }
        if (this.header != null) {
            List<String> tmpToks = StringUtil.split(this.header, this.delimiter, true, true);
            if (pts.length > 3 && tmpToks.size() > 3) {
                this.fieldName = tmpToks.get(3);
            }
        }
        return pts;
    }

    private float[][] doHillShade(float[][] grid, float azimuth, float angle) {
        float z = 1.0f;
        float nsres = 1.0f;
        float scale = 1.0f;
        float ewres = 1.0f;
        float degreesToRadians = (float)Math.PI / 180;
        float radiansToDegrees = 57.29578f;
        int nYSize = grid.length;
        int nXSize = grid[0].length;
        float[][] angles = new float[nYSize][nXSize];
        float[] win = new float[9];
        Misc.fillArray(angles, Float.NaN);
        for (int i = 0; i < nYSize; ++i) {
            for (int j = 0; j < nXSize; ++j) {
                float slopePct;
                if (i == 0 || j == 0 || i == nYSize - 1 || j == nXSize - 1) continue;
                boolean containsNull = false;
                win[0] = grid[i - 1][j - 1];
                win[1] = grid[i - 1][j];
                win[2] = grid[i - 1][j + 1];
                win[3] = grid[i][j - 1];
                win[4] = grid[i][j];
                win[5] = grid[i][j + 1];
                win[6] = grid[i + 1][j - 1];
                win[7] = grid[i + 1][j];
                win[8] = grid[i + 1][j + 1];
                for (int n = 0; n <= 8; ++n) {
                    if (win[n] == win[n] && win[n] != -99999.9f) continue;
                    containsNull = true;
                    break;
                }
                if (containsNull) continue;
                float x = (float)((double)(z * win[0] + z * win[3] + z * win[3] + z * win[6] - (z * win[2] + z * win[5] + z * win[5] + z * win[8])) / (8.0 * (double)ewres * (double)scale));
                float y = (float)((double)(z * win[6] + z * win[7] + z * win[7] + z * win[8] - (z * win[0] + z * win[1] + z * win[1] + z * win[2])) / (8.0 * (double)nsres * (double)scale));
                float key = (float)Math.sqrt(x * x + y * y);
                float slope = (float)(90.0 - Math.atan(key) * (double)radiansToDegrees);
                float value = slopePct = 100.0f * key;
                float aspect = (float)Math.atan2(x, y);
                float cang = (float)(Math.sin(angle * degreesToRadians) * Math.sin(slope * degreesToRadians) + Math.cos(angle * degreesToRadians) * Math.cos(slope * degreesToRadians) * Math.cos(((double)azimuth - 90.0) * (double)degreesToRadians - (double)aspect));
                cang = (double)cang <= 0.0 ? 1.0f : 1.0f + 254.0f * cang;
                angles[i][j] = value = cang;
            }
        }
        return angles;
    }

    private FieldImpl makeGrid(float[][] pts, RealType type, boolean hillshade, boolean pointCount) throws Exception {
        int x;
        boolean fillMissing = true;
        int numCols = this.gridWidth;
        int numRows = this.gridHeight;
        float west = Float.POSITIVE_INFINITY;
        float south = Float.POSITIVE_INFINITY;
        float east = Float.NEGATIVE_INFINITY;
        float north = Float.NEGATIVE_INFINITY;
        float[][] latLonGrid = new float[numRows][numCols];
        int[][] cntGrid = new int[numRows][numCols];
        for (int x2 = 0; x2 < numCols; ++x2) {
            for (int y = 0; y < numRows; ++y) {
                latLonGrid[y][x2] = Float.NaN;
                cntGrid[y][x2] = 0;
            }
        }
        for (int i = 0; i < pts[0].length; ++i) {
            double lat = pts[2][i];
            double lon = pts[1][i];
            west = (float)Math.min((double)west, lon);
            east = (float)Math.max((double)east, lon);
            north = (float)Math.max((double)north, lat);
            south = (float)Math.min((double)south, lat);
        }
        double gridWidth = east - west;
        double gridHeight = north - south;
        for (int i = 0; i < pts[0].length; ++i) {
            double altitude = pts[0][i];
            double lat = pts[2][i];
            int latIndex = numRows - 1 - (int)((double)(numRows - 1) * (lat - (double)south) / gridHeight);
            double lon = pts[1][i];
            int lonIndex = (int)((double)(numCols - 1) * (lon - (double)west) / gridWidth);
            if (latLonGrid[latIndex][lonIndex] != latLonGrid[latIndex][lonIndex]) {
                latLonGrid[latIndex][lonIndex] = 0.0f;
            }
            float[] fArray = latLonGrid[latIndex];
            int n = lonIndex;
            fArray[n] = fArray[n] + (float)altitude;
            int[] nArray = cntGrid[latIndex];
            int n2 = lonIndex;
            nArray[n2] = nArray[n2] + 1;
        }
        if (pointCount) {
            for (x = 0; x < numCols; ++x) {
                for (int y = 0; y < numRows; ++y) {
                    if (cntGrid[y][x] <= 0) continue;
                    latLonGrid[y][x] = cntGrid[y][x];
                }
            }
        } else {
            for (x = 0; x < numCols; ++x) {
                for (int y = 0; y < numRows; ++y) {
                    if (latLonGrid[y][x] != latLonGrid[y][x]) continue;
                    latLonGrid[y][x] = latLonGrid[y][x] / (float)cntGrid[y][x];
                }
            }
        }
        if (fillMissing && !pointCount) {
            GridUtil.fillMissing(latLonGrid, -99999.9f);
        }
        if (hillshade) {
            type = Util.makeRealType("hillshade" + typeCnt++, null);
            latLonGrid = this.doHillShade(latLonGrid, this.hillShadeAzimuth, this.hillShadeAngle);
        } else {
            type = pointCount ? Util.makeRealType("pointcount" + typeCnt++, null) : RealType.Altitude;
        }
        float[][] gridValues = GridUtil.makeGrid(latLonGrid, numCols, numRows, -99999.9f);
        Linear1DSet xSet = new Linear1DSet((MathType)RealType.Longitude, west, east, numCols);
        Linear1DSet ySet = new Linear1DSet((MathType)RealType.Latitude, north, south, numRows);
        LinearLatLonSet gdsSet = new LinearLatLonSet((MathType)RealTupleType.SpatialEarth2DTuple, new Linear1DSet[]{xSet, ySet}, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null, true);
        FunctionType ftLatLon2Param = new FunctionType(((SetType)gdsSet.getType()).getDomain(), new RealTupleType(type));
        Unit outputUnits = type.getDefaultUnit();
        FlatField retData = new FlatField(ftLatLon2Param, (Set)gdsSet, (CoordinateSystem)null, (Set[])null, new Unit[]{outputUnits});
        retData.setSamples(gridValues, false);
        return retData;
    }

    public static FlatField makeField(MathType rangeType, float[][] pts) throws VisADException, RemoteException {
        RealType index = RealType.getRealType("index");
        Integer1DSet domain = new Integer1DSet((MathType)index, pts[0].length);
        FunctionType ft = new FunctionType(index, rangeType);
        FlatField field = new FlatField(ft, domain);
        field.setSamples(pts, false);
        return field;
    }

    @Override
    public void doMakeDataChoices() {
        this.addDataChoice(new DirectDataChoice((DataSource)this, (Object)"pointcloud", "pointcloud", "Point Cloud Data", DataCategory.parseCategories("pointcloud", false), new Hashtable()));
        this.addDataChoice(new DirectDataChoice((DataSource)this, (Object)"altitudegrid", "altitude", "Altitude Grid", DataCategory.parseCategories("GRID-2D;", false), new Hashtable()));
        this.addDataChoice(new DirectDataChoice((DataSource)this, (Object)"hillshadegrid", "hillshade", "Hill Shade", DataCategory.parseCategories("GRID-2D;", false), new Hashtable()));
        this.addDataChoice(new DirectDataChoice((DataSource)this, (Object)"pointcount", "pointcount", "Point Count", DataCategory.parseCategories("GRID-2D;", false), new Hashtable()));
    }

    public void setUtmInfo(UtmInfo value) {
        this.utmInfo = value;
    }

    public UtmInfo getUtmInfo() {
        return this.utmInfo;
    }

    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            for (int cnt = 0; cnt < 5; ++cnt) {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(arg));
                long t1 = System.currentTimeMillis();
                while ((line = reader.readLine()) != null) {
                    List<String> list = StringUtil.split(line, " ", true, true);
                }
                long t2 = System.currentTimeMillis();
                System.err.println("Time:" + (t2 - t1) / 1000L);
            }
        }
    }

    public void setDelimiter(String value) {
        this.delimiter = value;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setColorByIndex(int value) {
        this.colorByIndex = value;
    }

    public int getColorByIndex() {
        return this.colorByIndex;
    }

    public void setSkip(int value) {
        this.skip = value;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setHeader(String value) {
        this.header = value;
    }

    public String getHeader() {
        return this.header;
    }

    public void setGridWidth(int value) {
        this.gridWidth = value;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridHeight(int value) {
        this.gridHeight = value;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public void setHillShadeAzimuth(float value) {
        this.hillShadeAzimuth = value;
    }

    public float getHillShadeAzimuth() {
        return this.hillShadeAzimuth;
    }

    public void setHillShadeAngle(float value) {
        this.hillShadeAngle = value;
    }

    public float getHillShadeAngle() {
        return this.hillShadeAngle;
    }
}

