/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.Hashtable;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.point.PointDataSource;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import ucar.unidata.util.WrapperException;
import visad.FieldImpl;
import visad.VisADException;

public class NetcdfPointDataSource
extends PointDataSource {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(NetcdfPointDataSource.class.getName());
    protected FeatureDatasetPoint fixedDataset = null;

    public NetcdfPointDataSource() throws VisADException {
        this.init();
    }

    public NetcdfPointDataSource(FeatureDatasetPoint fixedDataset, DataSourceDescriptor descriptor, Hashtable properties) throws VisADException {
        this(descriptor, Misc.toList(new String[]{""}), properties);
        this.fixedDataset = fixedDataset;
    }

    public NetcdfPointDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        this(descriptor, Misc.toList(new String[]{source}), properties);
    }

    public NetcdfPointDataSource(DataSourceDescriptor descriptor, String[] sources, Hashtable properties) throws VisADException {
        this(descriptor, Misc.toList(sources), properties);
    }

    public NetcdfPointDataSource(DataSourceDescriptor descriptor, List sources, Hashtable properties) throws VisADException {
        super(descriptor, sources, "Netcdf Point Data", properties);
    }

    @Override
    public boolean canDoGeoSelection() {
        return true;
    }

    @Override
    protected boolean canDoGeoSelectionStride() {
        return false;
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        return !this.isFileBased();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof NetcdfPointDataSource)) {
            return false;
        }
        NetcdfPointDataSource that = (NetcdfPointDataSource)o;
        return this == that;
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        return hashCode;
    }

    @Override
    public void initAfterCreation() {
        super.initAfterCreation();
        this.getDataset(null);
    }

    protected FeatureDatasetPoint getDataset(String file) {
        if (this.fixedDataset != null) {
            System.err.println("Using fixed dataset");
            return this.fixedDataset;
        }
        FeatureDatasetPoint dataset = null;
        if (file == null && this.sources != null && this.sources.size() > 0) {
            file = (String)this.sources.get(0);
        }
        if (file == null) {
            file = this.getFilePath();
            if (file == null && this.haveBeenUnPersisted) {
                file = this.getName();
            }
            if (file == null) {
                return null;
            }
        }
        if (this.sources == null) {
            this.sources = new ArrayList();
            this.sources.add(file);
        }
        if (dataset == null) {
            Trace.call1("NetcdfPointDataSource.getDataSet", " name = " + this.sources);
            dataset = this.doMakeDataset(file);
            Trace.call2("NetcdfPointDataSource.getDataSet");
        }
        return dataset;
    }

    protected FeatureDatasetPoint doMakeDataset(String file) {
        Formatter buf = new Formatter();
        FeatureDatasetPoint pods = null;
        Exception toThrow = new Exception("Datset is null");
        try {
            file = this.convertSourceFile(file);
            if (pods == null) {
                pods = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.ANY_POINT, file, null, buf);
            }
        }
        catch (Exception exc) {
            pods = null;
        }
        if (pods == null) {
            toThrow = new BadDataException("Unable to make a PointDataset from " + file + "\nError = " + buf.toString());
            this.setInError(true);
            throw new WrapperException("Point obs data source failed making data set: " + file, toThrow);
        }
        return pods;
    }

    @Override
    protected FieldImpl getSample(DataChoice dataChoice) throws Exception {
        return this.makeObs(dataChoice, null, null, true);
    }

    @Override
    protected FieldImpl makeObs(DataChoice dataChoice, DataSelection subset, LatLonRect bbox) throws Exception {
        return this.makeObs(dataChoice, subset, bbox, false);
    }

    protected FieldImpl makeObs(DataChoice dataChoice, DataSelection subset, LatLonRect bbox, boolean sample) throws Exception {
        Object id = dataChoice.getId();
        String source = id instanceof Integer ? (String)this.sources.get((Integer)id) : (id instanceof List && sample ? (String)this.sources.get(0) : id.toString());
        FieldImpl obs = null;
        Trace.call1("NetcdfPointDatasource:makeObs");
        if (obs == null) {
            FeatureDatasetPoint pods = this.getDataset(source);
            if (pods == null) {
                return null;
            }
            DateSelection ds = (DateSelection)this.getProperty("date_selection");
            obs = PointObFactory.makePointObs(pods, this.getBinRoundTo(), this.getBinWidth(), bbox, ds, sample);
            if (this.fixedDataset == null) {
                pods.close();
            }
        }
        Trace.call2("NetcdfPointDatasource:makeObs");
        return obs;
    }

    @Override
    public void doRemove() {
        super.doRemove();
    }

    public static void main(String[] args) {
        try {
            Formatter buf = new Formatter();
            int cnt = args.length > 1 ? new Integer(args[1]) : 1;
            long total = 0L;
            for (int i = 0; i < cnt; ++i) {
                long tt1 = System.currentTimeMillis();
                FeatureDatasetPoint pods = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.POINT, args[0], null, buf);
                long tt2 = System.currentTimeMillis();
                if (pods == null) {
                    throw new BadDataException("Unable to make a PointDataset from " + args[0] + "\nError = " + buf.toString());
                }
                Trace.startTrace();
                long t1 = System.currentTimeMillis();
                FieldImpl field = PointObFactory.makePointObs(pods, 0.0, 0.0, null, null, false);
                PointObFactory.makeTimeSequenceOfPointObs(field, 0);
                long t2 = System.currentTimeMillis();
                if (i == 0) continue;
                System.err.println("FeatureDatasetPoint time:" + (tt2 - tt1) + " makePointObs time:" + (t2 - t1) + " avg:" + (total += t2 - t1) / (long)i);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

