/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.point.NetcdfPointDataSource;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.DateSelection;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import visad.Data;
import visad.FieldImpl;
import visad.VisADException;

public class NetcdfPointCloudDataSource
extends NetcdfPointDataSource {
    List<VariableSimpleIF> varNames = new ArrayList<VariableSimpleIF>();

    public NetcdfPointCloudDataSource() throws VisADException {
        this.init();
    }

    public NetcdfPointCloudDataSource(FeatureDatasetPoint fixedDataset, DataSourceDescriptor descriptor, Hashtable properties) throws VisADException {
        super(descriptor, Misc.toList(new String[]{""}), properties);
    }

    public NetcdfPointCloudDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        super(descriptor, Misc.toList(new String[]{source}), properties);
    }

    public NetcdfPointCloudDataSource(DataSourceDescriptor descriptor, String[] sources, Hashtable properties) throws VisADException {
        super(descriptor, Misc.toList(sources), properties);
    }

    public NetcdfPointCloudDataSource(DataSourceDescriptor descriptor, List sources, Hashtable properties) throws VisADException {
        super(descriptor, sources, properties);
    }

    @Override
    protected FeatureDatasetPoint doMakeDataset(String file) {
        FeatureDatasetPoint pods = null;
        pods = super.doMakeDataset(file);
        this.varNames = new ArrayList<VariableSimpleIF>();
        return pods;
    }

    @Override
    protected FieldImpl makeObs(DataChoice dataChoice, DataSelection subset, LatLonRect bbox, boolean sample) throws Exception {
        Object id = dataChoice.getId();
        String source = id instanceof Integer ? (String)this.sources.get((Integer)id) : (id instanceof List && sample ? (String)this.sources.get(0) : (id instanceof String ? (String)this.sources.get(0) : id.toString()));
        FieldImpl obs = null;
        Trace.call1("NetcdfPointDatasource:makeObs");
        if (obs == null) {
            FeatureDatasetPoint pods = this.getDataset(source);
            if (pods == null) {
                return null;
            }
            DateSelection ds = (DateSelection)this.getProperty("date_selection");
            obs = PointObFactory.makePointObs(pods, dataChoice, this.getBinRoundTo(), this.getBinWidth(), bbox, ds, sample);
            if (this.fixedDataset == null) {
                pods.close();
            }
            this.varNames = pods.getDataVariables();
        }
        Trace.call2("NetcdfPointDatasource:makeObs");
        return obs;
    }

    @Override
    public void doMakeDataChoices() {
        super.doMakeDataChoices();
        try {
            if (this.getDataChoices().size() == 0) {
                return;
            }
            DataChoice dataChoice = (DataChoice)this.getDataChoices().get(0);
            Hashtable props = Misc.newHashtable("doFilter", "true");
            List cloudCats = DataCategory.parseCategories("Point Cloud;pointcloud", true);
            for (VariableSimpleIF var : this.varNames) {
                String varname = var.getShortName();
                DirectDataChoice choice = new DirectDataChoice((DataSource)this, (Object)("pointcloud:" + varname), varname, varname, cloudCats, props);
                this.addDataChoice(choice);
            }
        }
        catch (Exception exc) {
            this.logException("Creating track choices", exc);
        }
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        Object id = dataChoice.getId();
        if (id instanceof String && id.toString().startsWith("pointcloud:")) {
            try {
                Hashtable properties = dataChoice.getProperties();
                if (properties == null) {
                    properties = new Hashtable();
                }
                FieldImpl pointObs = null;
                ArrayList<FieldImpl> datas = new ArrayList<FieldImpl>();
                for (int i = 0; i < this.sources.size(); ++i) {
                    pointObs = (FieldImpl)super.getDataInner(dataChoice, category, dataSelection, requestProperties);
                    if (pointObs == null) continue;
                    datas.add(pointObs);
                }
                if (datas.size() == 0) {
                    return null;
                }
                pointObs = PointObFactory.mergeData(datas);
                if (pointObs == null) {
                    return null;
                }
                FieldImpl cloud = PointObFactory.makePointCloud(pointObs, id.toString().substring(11));
                return cloud;
            }
            catch (Exception exc) {
                this.logException("Creating point cloud", exc);
                return null;
            }
        }
        return (FieldImpl)super.getDataInner(dataChoice, category, dataSelection, requestProperties);
    }
}

