/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.point.TextPointDataSource;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import visad.VisADException;

public class GNOMETextPointDataSource
extends TextPointDataSource {
    public static final String TIME_FILE_SUFFIX = "ms3";
    public static final String LOCATION_FILE_SUFFIX = "ms4";
    public static final String DATA_FILE_SUFFIX = "ms5";
    public static final String VALIDFOR = "VALIDFOR:";
    public static final String HEADER = "(index) -> (Time, Longitude, Latitude, LE, Depth, mass, density, age)\nTime[colspan=\"2\" fmt=\"HH:mm MM/dd/yy\" tz=\"America/Chicago\"], Longitude[unit=\"degrees_east\"], Latitude[unit=\"degrees_north\"], LE, skip, skip, Depth[unit=\"m\" scale=\"-1\"], mass, density[unit=\"kg/m3\"], age[unit=\"hr\"], skip\n";

    public GNOMETextPointDataSource() throws VisADException {
    }

    public GNOMETextPointDataSource(String source) throws VisADException {
        super(source);
    }

    public GNOMETextPointDataSource(DataSourceDescriptor descriptor, List sources, Hashtable properties) throws VisADException {
        super(descriptor, GNOMETextPointDataSource.makeUniqueList(sources), properties);
    }

    @Override
    public String getDescription() {
        return "GNOME Text Point Data";
    }

    public GNOMETextPointDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        this(descriptor, Misc.newList(new Object[]{source}), properties);
    }

    private static List makeUniqueList(List sources) {
        ArrayList<String> newSources = new ArrayList<String>();
        for (int i = 0; i < sources.size(); ++i) {
            String originalSource = (String)sources.get(i);
            String testFile = originalSource.replaceAll("\\.ms.$", ".ms3");
            if (newSources.contains(testFile)) continue;
            newSources.add(testFile);
        }
        return newSources;
    }

    @Override
    protected String getContents(String sourceFile, boolean sampleIt) throws Exception {
        String dateFile = sourceFile.replaceAll("\\.ms.$", ".ms3");
        String locFile = sourceFile.replaceAll("\\.ms.$", ".ms4");
        String dataFile = sourceFile.replaceAll("\\.ms.$", ".ms5");
        if (!this.canFindFile(dateFile)) {
            throw new Exception("unable to find the date file: " + dateFile);
        }
        if (!this.canFindFile(locFile)) {
            throw new Exception("unable to find the location file: " + locFile);
        }
        if (!this.canFindFile(locFile)) {
            throw new Exception("unable to find the data file: " + dataFile);
        }
        String dateContents = IOUtil.readContents(dateFile);
        List<String> dateLines = StringUtil.split(dateContents, "\n", true, true);
        String locContents = IOUtil.readContents(locFile);
        List<String> locLines = StringUtil.split(locContents, "\n", true, true);
        String dataContents = IOUtil.readContents(dataFile);
        List<String> dataLines = StringUtil.split(dataContents, "\n", true, true);
        String dateString = null;
        for (String dateLine : dateLines) {
            if (dateLine.indexOf(VALIDFOR) < 0) continue;
            dateString = dateLine.substring(dateLine.indexOf(": ") + 1).trim();
            break;
        }
        if (dateString == null) {
            throw new Exception("Unable to find the date in " + dateFile);
        }
        StringBuffer buf = new StringBuffer(HEADER);
        for (int i = 0; !(i >= dataLines.size() || i == 1 && sampleIt); ++i) {
            buf.append(dateString);
            buf.append(", ");
            List<String> locStrings = StringUtil.split(locLines.get(2 * i + 1).trim(), " ", true, true);
            for (int j = 0; j < 2; ++j) {
                buf.append(locStrings.get(j));
                buf.append(", ");
            }
            buf.append(dataLines.get(i));
            buf.append("\n");
        }
        return buf.toString();
    }

    private boolean canFindFile(String filename) {
        File f = new File(filename);
        return f.exists();
    }
}

