/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.point.TextPointDataSource;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.StringUtil;
import visad.DateTime;
import visad.VisADException;

public class DiamondPointDataSource
extends TextPointDataSource {
    public static String diamond1 = "(index -> (StationId(Text),Longitude,Latitude,Time,Altitude,CF,CloudTotal,DIR,SPD,PressureSFC,Pressure3Hr,Weather1, Weather2,Preci6Hr,LowCloudShape,LowCloud,LowCloudHigh,TD,Visibility,Weather,T,MidCouldShape,HighCloudShape,ShipDir,ShipSPD))\nStationId(Text),Longitude[unit=\"degree\"],Latitude[unit=\"deg\"],Time[fmt=\"yyyy-MM-dd HH:mm:ss z\"],Altitude[unit=\"m\" miss=\"9999\"],CF[miss=\"9999\"],CloudTotal[miss=\"9999\"],DIR[unit=\"deg\" miss=\"9999\"],SPD[unit=\"m/s\" miss=\"9999\"],PressureSFC[unit=\"hPa\" miss=\"9999\"],Pressure3Hr[unit=\"hPa\" miss=\"9999\"],Weather1[miss=\"9999\"],Weather2[miss=\"9999\"],Preci6Hr[unit=\"mm\" miss=\"9999\"],LowCloudShape[miss=\"9999\"],LowCloud[miss=\"9999\"],LowCloudHigh[miss=\"9999\"],TD[unit=\"celsius\" miss=\"9999\"],Visibility[miss=\"9999\"],Weather[miss=\"9999\"],T[unit=\"celsius\" miss=\"9999\"],MidCouldShape[miss=\"9999\"],HighCloudShape[miss=\"9999\"],ShipDir[miss=\"9999\"],ShipSPD[miss=\"9999\"]\n";
    public static int diamond1Size = 24;
    public static String diamond2 = "(index -> (StationId(Text),Longitude,Latitude,Time,Altitude,CF,High,T,TD,DIR,SPD))\nStationId(Text),Longitude[unit=\"degrees west\"],Latitude[unit=\"deg\"],Time[fmt=\"yyyy-MM-dd HH:mm:ss z\"],Altitude[unit=\"m\" miss=\"9999\"],CF[miss=\"9999\"],High[miss=\"9999\"], T[unit=\"celsius\" miss=\"9999\"],TD[unit=\"celsius\" miss=\"9999\"],DIR[unit=\"deg\" miss=\"9999\"],SPD[unit=\"m/s\" miss=\"9999\"]\n";
    public static int diamond2Size = 11;

    public DiamondPointDataSource(DataSourceDescriptor descriptor, List sources, Hashtable properties) throws VisADException {
        super(descriptor, sources, properties);
    }

    public DiamondPointDataSource() throws VisADException {
    }

    public DiamondPointDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        super(descriptor, source, properties);
    }

    @Override
    protected String getContents(String sourceFile, boolean sampleIt) throws Exception {
        String s = IOUtil.readContents(sourceFile);
        List<String> lines = StringUtil.split(s, "\n", true, true);
        int currentIndex = 0;
        String headerLine1 = lines.get(currentIndex++);
        Pattern pattern1 = Pattern.compile("diamond\\s{1,}1");
        Pattern pattern2 = Pattern.compile("diamond\\s{1,}2");
        Matcher matcher1 = pattern1.matcher(headerLine1);
        Matcher matcher2 = pattern2.matcher(headerLine1);
        if (matcher1.find()) {
            return this.readDiamond1File(lines);
        }
        if (matcher2.find()) {
            return this.readDiamond2File(lines);
        }
        return null;
    }

    protected String readDiamond1File(List<String> lines) throws Exception {
        StringBuffer output = new StringBuffer();
        output.append(diamond1);
        int currentIndex = 1;
        while (currentIndex < lines.size()) {
            String headerLine2 = lines.get(currentIndex++);
            List<String> toks = StringUtil.split(headerLine2, " ", true, true);
            String year = toks.get(0);
            String mon = toks.get(1);
            String day = toks.get(2);
            String hr = toks.get(3);
            int numberPts = Integer.parseInt(toks.get(4));
            int yy = Integer.parseInt(year);
            if (yy < 20) {
                yy = 2000 + yy;
            } else if (yy > 50 && yy < 99) {
                yy = 1900 + yy;
            }
            DateTime dtt = this.getDateTime(yy, Integer.parseInt(mon), Integer.parseInt(day), Integer.parseInt(hr));
            String ts = "Time=" + dtt.formattedString("yyyy-MM-dd HH:mm:ss z", DateUtil.TIMEZONE_GMT);
            output.append(ts);
            output.append("\n");
            int endPtsIndex = currentIndex + numberPts;
            while (currentIndex < endPtsIndex) {
                String line1;
                List<String> toks1;
                StringBuffer outputline = new StringBuffer();
                if ((toks1 = StringUtil.split(line1 = lines.get(currentIndex++), " ", true, true)).size() >= 24) {
                    for (String a : toks1) {
                        outputline.append(a);
                        outputline.append(",");
                    }
                } else {
                    String line2 = lines.get(currentIndex++);
                    List<String> toks2 = StringUtil.split(line2, " ", true, true);
                    for (String a : toks1) {
                        outputline.append(a);
                        outputline.append(",");
                    }
                    for (String a : toks2) {
                        outputline.append(a);
                        outputline.append(",");
                    }
                }
                output.append(outputline);
                output.append("\n");
            }
        }
        return output.toString();
    }

    protected String readDiamond2File(List<String> lines) throws Exception {
        StringBuffer output = new StringBuffer();
        output.append(diamond2);
        int currentIndex = 1;
        while (currentIndex < lines.size()) {
            String headerLine2 = lines.get(currentIndex++);
            List<String> toks = StringUtil.split(headerLine2, " ", true, true);
            String year = toks.get(0);
            String mon = toks.get(1);
            String day = toks.get(2);
            String hr = toks.get(3);
            String levels = toks.get(4);
            int numberPts = Integer.parseInt(toks.get(5));
            int yy = Integer.parseInt(year);
            if (yy < 20) {
                yy = 2000 + yy;
            } else if (yy > 50 && yy < 99) {
                yy = 1900 + yy;
            }
            DateTime dtt = this.getDateTime(yy, Integer.parseInt(mon), Integer.parseInt(day), Integer.parseInt(hr));
            String ts = "Time=" + dtt.formattedString("yyyy-MM-dd HH:mm:ss z", DateUtil.TIMEZONE_GMT);
            output.append(ts);
            output.append("\n");
            int endPtsIndex = currentIndex + numberPts;
            while (currentIndex < endPtsIndex) {
                StringBuffer outputline = new StringBuffer();
                String line = lines.get(currentIndex++);
                toks = StringUtil.split(line, " ", true, true);
                for (String a : toks) {
                    outputline.append(a);
                    outputline.append(",");
                }
                output.append(outputline);
                output.append("\n");
            }
        }
        return output.toString();
    }

    private DateTime getDateTime(int year, int month, int day, int hour) throws Exception {
        GregorianCalendar convertCal = new GregorianCalendar(DateUtil.TIMEZONE_GMT);
        convertCal.clear();
        convertCal.set(1, year);
        convertCal.set(2, month - 1);
        convertCal.set(5, day);
        convertCal.set(11, hour);
        return new DateTime(convertCal.getTime());
    }
}

