/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.point.PointObTuple;
import ucar.unidata.data.point.TextPointDataSource;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.visad.UtcDate;
import ucar.visad.Util;
import visad.DateTime;
import visad.FieldImpl;
import visad.FunctionType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;

public class CDOGTextPointDataSource
extends TextPointDataSource {
    private Unit timeUnit = null;
    private static final String TIME_FILE = "series.dat";

    public CDOGTextPointDataSource() throws VisADException {
    }

    public CDOGTextPointDataSource(String source) throws VisADException {
        super(source);
    }

    public CDOGTextPointDataSource(DataSourceDescriptor descriptor, List sources, Hashtable properties) throws VisADException {
        super(descriptor, sources, properties);
    }

    public CDOGTextPointDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        super(descriptor, source, properties);
    }

    public CDOGTextPointDataSource(DataSourceDescriptor descriptor, String source, String name, Hashtable properties) throws VisADException {
        super(descriptor, source, name, properties);
    }

    @Override
    public FieldImpl makeObs(DataChoice dataChoice, DataSelection subset, LatLonRect bbox, String trackParam, boolean sampleIt, boolean showAttributeGuiIfNeeded) throws Exception {
        String source = this.getSource(dataChoice);
        String controlFile = IOUtil.joinDir(IOUtil.getFileRoot(source), TIME_FILE);
        String timeContents = null;
        try {
            timeContents = this.getContents(controlFile);
        }
        catch (IOException ioe) {
            System.err.println("Unable to read series.dat");
            timeContents = null;
        }
        String startTime = null;
        if (timeContents != null) {
            List<String> lines = StringUtil.split(timeContents, "\n", true, true);
            if (lines.size() >= 3) {
                startTime = this.parseStartTime(lines.get(2));
            } else {
                System.err.println("Unable to read start time from series.dat");
            }
        }
        if (startTime == null) {
            startTime = new DateTime().toString();
        }
        this.timeUnit = Util.parseUnit("hours since " + startTime);
        return super.makeObs(dataChoice, subset, bbox, trackParam, sampleIt, showAttributeGuiIfNeeded);
    }

    private String parseStartTime(String time) {
        List<String> timeParts = StringUtil.split(time, " ", true, true);
        if (timeParts.size() < 4) {
            return null;
        }
        boolean hasStart = timeParts.get(timeParts.size() - 1).equals("start");
        int numTokens = timeParts.size();
        if (hasStart) {
            --numTokens;
        }
        String timePattern = numTokens == 6 ? "HH mm" : "HHmm";
        StringBuilder timeBuilder = new StringBuilder();
        int numTimeToks = numTokens - 1;
        for (int i = 0; i < numTimeToks; ++i) {
            timeBuilder.append(timeParts.get(i));
            timeBuilder.append(" ");
        }
        String timePart = timeBuilder.toString().trim();
        StringBuilder patternBuilder = new StringBuilder("yyyy ");
        String tmp = timeParts.get(1);
        if (tmp.length() < 3) {
            patternBuilder.append("MM ");
        } else if (tmp.length() < 4) {
            patternBuilder.append("MMM ");
        } else {
            patternBuilder.append("MMMMM ");
        }
        patternBuilder.append("dd ");
        patternBuilder.append(timePattern);
        String timeFormat = patternBuilder.toString().trim();
        String timeZone = timeParts.get(numTimeToks);
        if (timeZone.equals("CDT")) {
            timeZone = "America/Chicago";
        }
        DateTime startTime = null;
        try {
            TimeZone zone = TimeZone.getTimeZone(timeZone);
            startTime = UtcDate.createDateTime(timePart, timeFormat, zone);
            String startTimeString = startTime.formattedString("yyyy-MM-dd HH:mm:ss Z", zone);
            return startTimeString;
        }
        catch (VisADException ve) {
            System.err.println("unable to parse start time");
            return null;
        }
    }

    @Override
    public FieldImpl makeObs(String contents, String delimiter, DataSelection subset, LatLonRect bbox, String trackParam, boolean sampleIt, boolean showAttributeGuiIfNeeded) throws Exception {
        String firstLine = contents.substring(0, contents.indexOf("\n")).trim();
        double hours = Misc.parseDouble(firstLine.substring(0, firstLine.indexOf(" ")));
        DateTime time = new DateTime(hours, this.timeUnit);
        FieldImpl myObs = super.makeObs(contents, delimiter, subset, bbox, trackParam, sampleIt, showAttributeGuiIfNeeded);
        FieldImpl obsWithTime = new FieldImpl((FunctionType)myObs.getType(), myObs.getDomainSet());
        for (int i = 0; i < myObs.getLength(); ++i) {
            PointObTuple ob = (PointObTuple)myObs.getSample(i);
            PointObTuple newOb = new PointObTuple(ob.getEarthLocation(), time, ob.getData(), (TupleType)ob.getType(), false);
            obsWithTime.setSample(i, newOb, false, false);
        }
        return obsWithTime;
    }
}

