/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import edu.wisc.ssec.mcidas.adde.AddePointURL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.AddeUtil;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.point.PointDataSource;
import ucar.unidata.data.point.PointObFactory;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.idv.chooser.adde.AddeChooser;
import ucar.unidata.idv.chooser.adde.AddePointDataChooser;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import ucar.unidata.util.TwoFacedObject;
import visad.DataImpl;
import visad.FieldImpl;
import visad.Real;
import visad.RealType;
import visad.Tuple;
import visad.VisADException;
import visad.data.mcidas.PointDataAdapter;

public class AddePointDataSource
extends PointDataSource {
    static LogUtil.LogCategory log_ = LogUtil.getLogInstance(AddePointDataSource.class.getName());
    private boolean hasAltitude = true;
    private DataSelection timeDriverSelection;
    static double increment = 0.0;
    private static final String[] excludes = new String[]{"COL", "ROW", "NREC", "IDN", "MOD", "TYPE", "HMS"};

    public AddePointDataSource() throws VisADException {
        this.init();
    }

    public AddePointDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        super(descriptor, source, AddePointDataSource.makeDatasetName(properties), properties);
        this.setName(this.getDescription());
    }

    private static String makeDatasetName(Hashtable properties) {
        String name = "Adde Point Data";
        if (properties != null) {
            String checkglm;
            String possible = (String)properties.get(AddeChooser.DATASET_NAME_KEY);
            if (possible != null) {
                name = possible;
            }
            if ((checkglm = (String)properties.get("data name")) != null && checkglm.contains("GLM Lightning Data")) {
                Double relT = (Double)properties.get("relative time increment");
                properties.put("prop.stationmodelscale", "0.5");
                if (relT != null) {
                    double reltime;
                    increment = reltime = relT * 60.0;
                }
            }
        }
        return name;
    }

    @Override
    protected boolean canCreateGrid(RealType type) {
        for (int i = 0; i < excludes.length; ++i) {
            if (!type.getName().equals(excludes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDataName() {
        String dataName = this.getProperty("data name", "Station Data");
        if (dataName.equals("")) {
            dataName = super.getDataName();
        }
        return dataName;
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        return !this.isFileBased();
    }

    @Override
    protected List saveDataToLocalDisk(String prefix, Object loadId, boolean changeLinks) throws Exception {
        GeoSelection gs;
        String source = this.sources.get(0).toString();
        LatLonRect bbox = null;
        DataSelection ds = this.getDataSelection();
        if (ds != null && (gs = ds.getGeoSelection()) != null) {
            bbox = gs.getLatLonRect();
        }
        source = this.processUrl(source, null, null, bbox, false);
        List<String> addeUrls = AddeUtil.generateTimeUrls(this, source, this.timeDriverSelection);
        ArrayList<String> urls = new ArrayList<String>();
        for (int i = 0; i < addeUrls.size(); ++i) {
            String sourceUrl = addeUrls.get(i);
            urls.add(sourceUrl + "&rawstream=true");
        }
        List newFiles = IOUtil.writeTo(urls, prefix, "apt", loadId);
        if (newFiles == null) {
            return null;
        }
        if (changeLinks) {
            this.sources = newFiles;
        }
        return newFiles;
    }

    private String processUrl(String source, DataChoice choice, DataSelection subset, LatLonRect bbox, boolean sampleIt) {
        AddePointURL temp = AddePointURL.decodeURL(source);
        if (temp == null) {
            return source;
        }
        source = temp.getSelectClause();
        if (sampleIt) {
            if (source.indexOf("%level%") >= 0) {
                String level = this.makeLevelString(subset);
                if (level.length() > 0) {
                    level = "'" + level + "'";
                }
                temp.setSelectClause(level);
            } else {
                temp.setSelectClause("");
            }
            temp.setMaxNumber(1);
            if (!choice.getDescription().contains("Lightning")) {
                temp.setPosition("0");
            }
        } else {
            if (source.indexOf("%latlonbox%") >= 0) {
                String llb = "";
                if (bbox != null) {
                    double lonMin;
                    double lonMax;
                    LatLonPointImpl ll = bbox.getLowerLeftPoint();
                    LatLonPointImpl ur = bbox.getUpperRightPoint();
                    double latMin = Math.min(ll.getLatitude(), ur.getLatitude());
                    double latMax = Math.max(ll.getLatitude(), ur.getLatitude());
                    if (ll.getLongitude() > 0.0 && ur.getLongitude() < 0.0) {
                        lonMax = -1.0 * ll.getLongitude();
                        lonMin = -1.0 * ur.getLongitude();
                    } else {
                        lonMin = Math.min(-1.0 * ll.getLongitude(), -1.0 * ur.getLongitude());
                        lonMax = Math.max(-1.0 * ll.getLongitude(), -1.0 * ur.getLongitude());
                    }
                    llb = "LAT " + latMin + " " + latMax + ";LON " + lonMin + " " + lonMax;
                }
                log_.debug("lat/lon box = " + llb);
                source = source.replaceAll("%latlonbox%", llb);
            }
            if (source.indexOf("%level%") >= 0) {
                String level = this.makeLevelString(subset);
                source = source.replaceAll("%level%", level);
            }
            if (choice != null && choice.getProperty("prop.grid.param") != null) {
                String param = ((RealType)choice.getProperty("prop.grid.param")).getName();
                if (this.hasAltitude) {
                    temp.setParams("DAY TIME LAT LON ZS " + param);
                } else {
                    temp.setParams("DAY TIME LAT LON " + param);
                }
            }
            temp.setSelectClause(source);
        }
        return temp.getURLString();
    }

    private String makeLevelString(DataSelection subset) {
        String level = "";
        Object selectedLevel = null;
        if (subset != null) {
            selectedLevel = subset.getFromLevel();
        }
        if (selectedLevel == null) {
            List levels = this.getLevels();
            Object defLev = levels == null || levels.isEmpty() ? selectedLevel : levels.get(0);
            selectedLevel = this.getProperty(AddePointDataChooser.SELECTED_LEVEL, defLev);
        }
        if (selectedLevel != null) {
            String levelString = selectedLevel.toString();
            if (selectedLevel instanceof Real) {
                int value = (int)((Real)selectedLevel).getValue();
                switch (value) {
                    case 1001: {
                        levelString = "SFC";
                        break;
                    }
                    case 0: {
                        levelString = "TRO";
                        break;
                    }
                    case 1013: {
                        levelString = "MSL";
                        break;
                    }
                    default: {
                        levelString = "" + value;
                    }
                }
            }
            level = "LEV " + levelString;
        }
        log_.debug("level = " + level);
        return level;
    }

    @Override
    protected FieldImpl getSample(DataChoice dataChoice) throws Exception {
        return this.makeObs(dataChoice, null, null, true);
    }

    @Override
    protected FieldImpl makeObs(DataChoice dataChoice, DataSelection subset, LatLonRect bbox) throws Exception {
        return this.makeObs(dataChoice, subset, bbox, false);
    }

    protected FieldImpl makeObs(DataChoice dataChoice, DataSelection subset, LatLonRect bbox, boolean sampleIt) throws Exception {
        List<Object> realUrls;
        Trace.call1("AddePointDataSource.makeObs");
        String source = this.getSource(dataChoice);
        boolean usingTD = false;
        if (this.canSaveDataToLocalDisk()) {
            source = this.processUrl(source, dataChoice, subset, bbox, sampleIt);
            realUrls = AddeUtil.generateTimeUrls(this, source, subset);
            if (subset != null && subset.getTimeDriverTimes() != null) {
                usingTD = true;
                this.timeDriverSelection = subset;
            } else {
                this.timeDriverSelection = null;
            }
        } else {
            realUrls = new ArrayList();
            for (int i = 0; i < this.sources.size(); ++i) {
                String sourceUrl = (String)this.sources.get(i);
                realUrls.add("file:" + sourceUrl);
            }
        }
        FieldImpl obs = null;
        ArrayList<FieldImpl> datas = new ArrayList<FieldImpl>();
        if (obs == null) {
            for (int i = 0; i < realUrls.size(); ++i) {
                String sourceUrl = (String)realUrls.get(i);
                if (sampleIt && i > 0) break;
                log_.debug("sourceUrl = " + sourceUrl);
                try {
                    Trace.call1("AddePointDataSource.pda ctor");
                    PointDataAdapter pda = new PointDataAdapter(sourceUrl, false, true);
                    Trace.call1("AddePointDataSource.pda ctor");
                    DataImpl data = pda.getData();
                    String message = "size of ll data " + ((FieldImpl)data).getLength();
                    LogUtil.consoleMessage(message);
                    Trace.call2("AddePointDataSource.pda ctor");
                    if (sampleIt) {
                        this.checkForNeededParams((FieldImpl)data);
                    }
                    Trace.call1("AddePointDataSource.makePointObsFromField");
                    if (increment != 0.0 && this.getBinWidth() == 0.0) {
                        this.setBinWidth(increment);
                    }
                    obs = PointObFactory.makePointObsFromField((FieldImpl)data, this.getBinRoundTo(), this.getBinWidth());
                    Trace.call2("AddePointDataSource.makePointObsFromField");
                    if (!this.canSaveDataToLocalDisk() && bbox != null) {
                        obs = PointObFactory.subSet(obs, bbox);
                    }
                    datas.add(obs);
                    continue;
                }
                catch (VisADException ve) {
                    if (usingTD) continue;
                    this.logException("reading point data", ve);
                }
            }
        }
        Trace.call1("AddePointDataSource.mergeData");
        obs = PointObFactory.mergeData(datas);
        Trace.call2("AddePointDataSource.mergeData");
        Trace.call2("AddePointDataSource.makeObs");
        return obs;
    }

    private void checkForNeededParams(FieldImpl rawSample) {
        try {
            Tuple ob = (Tuple)rawSample.getSample(0);
            Real[] reals = ob.getRealComponents();
            if (reals != null) {
                for (int i = 0; i < reals.length; ++i) {
                    RealType rt = (RealType)reals[i].getType();
                    if (!rt.equals(RealType.Altitude)) continue;
                    this.hasAltitude = true;
                    return;
                }
            }
            this.hasAltitude = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean canDoGeoSelection() {
        return true;
    }

    @Override
    protected boolean canDoGeoSelectionStride() {
        return false;
    }

    @Override
    protected boolean canDoGeoSelectionMap() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AddePointDataSource)) {
            return false;
        }
        AddePointDataSource that = (AddePointDataSource)o;
        return this == that;
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        return hashCode;
    }

    public void setUrl(String url) {
        this.setSource(url);
    }

    public static void mainxxx(String[] args) throws Exception {
        if (args.length == 0) {
            args = new String[]{"adde://adde.ucar.edu/pointdata?compress=true&port=112&debug=false&version=1&user=idv&proj=0&group=RTPTSRC&descr=SFCHOURLY&select='day 2006241 2006241;time 12 16;type 0;'&num=all&pos=ALL"};
        }
        boolean newWay = true;
        long oldSum = 0L;
        long newSum = 0L;
        int oldCnt = 0;
        int newCnt = 0;
        for (int j = 0; j < 20; ++j) {
            Misc.gc();
            for (int i = 0; i < args.length; ++i) {
                Trace.call1("AddePointDataSource.pda ctor");
                long t1 = System.currentTimeMillis();
                PointDataAdapter pda = new PointDataAdapter(args[i], false, true);
                Trace.call2("AddePointDataSource.pda ctor", newWay ? " new way" : " old way");
                newWay = !newWay;
                DataImpl data = pda.getData();
                Trace.call1("AddePointDataSource.makePointObsFromField");
                PointObFactory.makePointObsFromField((FieldImpl)data, 0.0, 0.0);
                Trace.call2("AddePointDataSource.makePointObsFromField");
                long t2 = System.currentTimeMillis();
                if (newWay) {
                    ++newCnt;
                    newSum += t2 - t1;
                } else {
                    ++oldCnt;
                    oldSum += t2 - t1;
                }
                if (newCnt == 0 || oldCnt == 0) continue;
                System.err.println("avg old:" + oldSum / (long)oldCnt + " new: " + newSum / (long)newCnt);
            }
        }
        Trace.stopTrace();
    }

    @Override
    public List getAllLevels(DataChoice dataChoice, DataSelection dataSelection) {
        return this.getLevels();
    }

    private List getLevels() {
        return (List)this.getProperty(AddePointDataChooser.LEVELS, new ArrayList());
    }

    @Override
    protected List getDefaultLevels() {
        ArrayList<Object> retList = new ArrayList<Object>();
        Object level = this.getProperty(AddePointDataChooser.SELECTED_LEVEL);
        if (level != null) {
            retList.add(level);
        }
        return retList;
    }

    @Override
    protected List doMakeDateTimes() {
        ArrayList<TwoFacedObject> timesList = new ArrayList<TwoFacedObject>();
        String source = (String)this.sources.get(0);
        if (this.getProperty(AddeUtil.ABSOLUTE_TIMES, (Object)null) != null) {
            timesList.addAll((List)this.getProperty(AddeUtil.ABSOLUTE_TIMES));
        } else if (source.indexOf("%relative%") >= 0) {
            int[] timeIndices;
            Object tmp = this.getProperty(AddeUtil.NUM_RELATIVE_TIMES, new Integer(0));
            if (tmp instanceof Integer) {
                int numTimes = (Integer)tmp;
                timeIndices = new int[numTimes];
                for (int i = 0; i < numTimes; ++i) {
                    timeIndices[i] = i;
                }
            } else {
                timeIndices = (int[])tmp;
            }
            for (int i = 0; i < timeIndices.length; ++i) {
                String name = timeIndices[i] + "th most recent";
                if (i == 0) {
                    name = "Most recent";
                }
                if (i > 0 && i < DataSource.ordinalNames.length) {
                    name = DataSource.ordinalNames[timeIndices[i]] + " most recent";
                }
                timesList.add(new TwoFacedObject((Object)name, i));
            }
        }
        return timesList;
    }
}

