/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.point;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.point.TextPointDataSource;
import ucar.unidata.util.DateUtil;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.StringUtil;
import visad.DateTime;
import visad.VisADException;

public class AMRCTextPointDataSource
extends TextPointDataSource {
    public static String amrc1 = "(index -> (StationId(Text),StationName(Text),ARGOS(Text),Time,Latitude,Longitude,Altitude,Temperature,Pressure,SPD,DIR,RH,DeltaT))\nStationId(Text),StationName(Text),ARGOS(Text),Longitude[unit=\"degree\"],Latitude[unit=\"degree\"],Time[fmt=\"yyyy-MM-dd HH:mm:ss z\"],Altitude[unit=\"m\" miss=\"444.0\"],Temperature[unit=\"celsius\" miss=\"444.0\"],Pressure[unit=\"mb\" miss=\"444.0\"],SPD[unit=\"m/s\" miss=\"444.0\"],DIR[unit=\"deg\" miss=\"444.0\"],RH[unit=\"%\" miss=\"444.0\"],DeltaT[unit=\"celsius\" miss=\"444.0\"]\n";
    public static String amrc2 = "(index -> (StationId(Text),Time,Latitude,Longitude,Altitude,Temperature,Pressure,SPD,DIR,RH,DeltaT))\nStationId(Text),Longitude[unit=\"degree\"],Latitude[unit=\"degree\"],Time[fmt=\"yyyy-MM-dd HH:mm:ss z\"],Altitude[unit=\"m\" miss=\"444.0\"],Temperature[unit=\"celsius\" miss=\"444.0\"],Pressure[unit=\"mb\" miss=\"444.0\"],SPD[unit=\"m/s\" miss=\"444.0\"],DIR[unit=\"deg\" miss=\"444.0\"],RH[unit=\"%\" miss=\"444.0\"],DeltaT[unit=\"celsius\" miss=\"444.0\"]\n";
    public static String amrc3 = "(index -> (StationId(Text),Time,Latitude,Longitude,Altitude,Temperature,Pressure,SPD,DIR,RH,PotentialTemperature))\nStationId(Text),Longitude[unit=\"degrees\"],Latitude[unit=\"degree\"],Time[fmt=\"yyyy-MM-dd HH:mm:ss z\"],Altitude[unit=\"m\" miss=\"444.0\"],Temperature[unit=\"celsius\" miss=\"444.0\"],Pressure[unit=\"mb\" miss=\"444.0\"],SPD[unit=\"m/s\" miss=\"444.0\"],DIR[unit=\"deg\" miss=\"444.0\"],RH[unit=\"%\" miss=\"444.0\"],PotentialTemperature[unit=\"celsius\" miss=\"444.0\"]\n";

    public AMRCTextPointDataSource(DataSourceDescriptor descriptor, List sources, Hashtable properties) throws VisADException {
        super(descriptor, sources, properties);
    }

    public AMRCTextPointDataSource() throws VisADException {
    }

    public AMRCTextPointDataSource(DataSourceDescriptor descriptor, String source, Hashtable properties) throws VisADException {
        super(descriptor, source, properties);
    }

    @Override
    protected String getContents(String sourceFile, boolean sampleIt) throws Exception {
        String s = IOUtil.readContents(sourceFile);
        List<String> lines = StringUtil.split(s, "\n", true, true);
        if (sourceFile.contains(".q10") || sourceFile.contains(".q1h") || sourceFile.contains(".q3h")) {
            return this.readAMRC1File(lines);
        }
        if (sourceFile.endsWith(".dat")) {
            return this.readAMRC2File(lines);
        }
        return this.readAMRC3File(lines);
    }

    protected String readAMRC1File(List<String> lines) throws Exception {
        StringBuffer output = new StringBuffer();
        output.append(amrc1);
        int currentIndex = 0;
        String headerLine0 = lines.get(currentIndex++);
        List<String> toks0 = StringUtil.split(headerLine0, " ", true, true);
        int pos = toks0.lastIndexOf("ID:");
        String id = toks0.get(pos + 1);
        pos = toks0.indexOf("ARGOS:");
        String argo = toks0.get(pos + 1);
        pos = toks0.indexOf("Name:");
        String name = toks0.get(pos + 1);
        String tid = "StationId=" + id;
        String tna = "StationName=" + name;
        String tao = "ARGOS=" + argo;
        output.append(tid);
        output.append("\n");
        output.append(tna);
        output.append("\n");
        output.append(tao);
        output.append("\n");
        String headerLine1 = lines.get(currentIndex++);
        List<String> toks1 = StringUtil.split(headerLine1, " ", true, true);
        pos = toks1.indexOf("Lat:");
        String latStr = toks1.get(pos + 1).trim();
        float latitude = latStr.endsWith("S") ? -1.0f * Float.parseFloat(latStr.substring(0, latStr.length() - 1)) : (latStr.endsWith("N") ? 1.0f * Float.parseFloat(latStr.substring(0, latStr.length() - 1)) : 1.0f * Float.parseFloat(latStr));
        pos = toks1.indexOf("Lon:");
        String lonStr = toks1.get(pos + 1).trim();
        float longitude = lonStr.endsWith("W") ? -1.0f * Float.parseFloat(lonStr.substring(0, lonStr.length() - 1)) : (lonStr.endsWith("E") ? 1.0f * Float.parseFloat(lonStr.substring(0, lonStr.length() - 1)) : 1.0f * Float.parseFloat(lonStr));
        pos = toks1.indexOf("Elev:");
        String elevStr = toks1.get(pos + 1).trim();
        float altitude = elevStr.endsWith("m") ? Float.parseFloat(elevStr.substring(0, elevStr.length() - 1)) : Float.parseFloat(elevStr);
        String lat = "Latitude=" + latitude;
        String lon = "Longitude=" + longitude;
        String ele = "Altitude=" + altitude;
        output.append(lat);
        output.append("\n");
        output.append(lon);
        output.append("\n");
        output.append(ele);
        output.append("\n");
        while (currentIndex < lines.size()) {
            StringBuffer outputline = new StringBuffer();
            String headerLine2 = lines.get(currentIndex++);
            List<String> toks = StringUtil.split(headerLine2, " ", true, true);
            String year = toks.get(0).trim();
            String jday = toks.get(1).trim();
            String mon = toks.get(2).trim();
            String day = toks.get(3).trim();
            String minutes = toks.get(4).trim();
            String temp = toks.get(5).trim();
            String pressure = toks.get(6).trim();
            String wspd = toks.get(7).trim();
            String wdir = toks.get(8).trim();
            String rh = toks.get(9).trim();
            String dt = toks.get(10).trim();
            Date date = new SimpleDateFormat("yyyyD").parse(year + jday);
            long time0 = date.getTime() + (long)(Integer.parseInt(minutes) * 60 * 1000);
            date.setTime(time0);
            DateTime dtt = new DateTime(date);
            String ts = dtt.formattedString("yyyy-MM-dd HH:mm:ss z", DateUtil.TIMEZONE_GMT);
            outputline.append(ts);
            outputline.append(",");
            outputline.append(temp);
            outputline.append(",");
            outputline.append(pressure);
            outputline.append(",");
            outputline.append(wspd);
            outputline.append(",");
            outputline.append(wdir);
            outputline.append(",");
            outputline.append(rh);
            outputline.append(",");
            outputline.append(dt);
            outputline.append(",");
            output.append(outputline);
            output.append("\n");
        }
        return output.toString();
    }

    protected String readAMRC2File(List<String> lines) throws Exception {
        StringBuffer output = new StringBuffer();
        output.append(amrc2);
        int currentIndex = 0;
        String headerLine0 = lines.get(currentIndex++);
        List<String> toks0 = StringUtil.split(headerLine0, " ", true, true);
        String monStr = toks0.get(0);
        String yyStr = toks0.get(1);
        int pos = toks0.lastIndexOf("Station");
        String id0 = toks0.get(pos + 1);
        String id = id0.substring(1, id0.length());
        String tid = "StationId=" + id;
        output.append(tid);
        output.append("\n");
        SimpleDateFormat sdf = new SimpleDateFormat("MMMM yy");
        Date date = sdf.parse(monStr + " " + yyStr);
        String headerLine1 = lines.get(currentIndex++);
        List<String> toks1 = StringUtil.split(headerLine1, " ", true, true);
        pos = toks1.indexOf("Lat");
        String latStr = toks1.get(pos + 2).trim();
        float latitude = latStr.endsWith("S") ? -1.0f * Float.parseFloat(latStr.substring(0, latStr.length() - 1)) : (latStr.endsWith("N") ? 1.0f * Float.parseFloat(latStr.substring(0, latStr.length() - 1)) : 1.0f * Float.parseFloat(latStr));
        pos = toks1.indexOf("Long");
        String lonStr = toks1.get(pos + 2).trim();
        float longitude = lonStr.endsWith("W") ? -1.0f * Float.parseFloat(lonStr.substring(0, lonStr.length() - 1)) : (lonStr.endsWith("E") ? 1.0f * Float.parseFloat(lonStr.substring(0, lonStr.length() - 1)) : 1.0f * Float.parseFloat(lonStr));
        pos = toks1.indexOf("Elev");
        String elevStr = toks1.get(pos + 2).trim();
        float altitude = elevStr.endsWith("m") ? Float.parseFloat(elevStr.substring(0, elevStr.length() - 1)) : Float.parseFloat(elevStr);
        String lat = "Latitude=" + latitude;
        String lon = "Longitude=" + longitude;
        String ele = "Altitude=" + altitude;
        output.append(lat);
        output.append("\n");
        output.append(lon);
        output.append("\n");
        output.append(ele);
        output.append("\n");
        while (currentIndex < lines.size()) {
            StringBuffer outputline = new StringBuffer();
            String headerLine2 = lines.get(currentIndex++);
            List<String> toks = StringUtil.split(headerLine2, " ", true, true);
            String temp = toks.get(0).trim();
            String pressure = toks.get(1).trim();
            String wspd = toks.get(2).trim();
            String wdir = toks.get(3).trim();
            String rh = toks.get(4).trim();
            String dt = toks.get(5).trim();
            long time0 = date.getTime() + (long)((currentIndex - 3) * 3 * 3600 * 1000);
            Date date1 = new Date(time0);
            DateTime dtt = new DateTime(date1);
            String ts = dtt.formattedString("yyyy-MM-dd HH:mm:ss z", DateUtil.TIMEZONE_GMT);
            outputline.append(ts);
            outputline.append(",");
            outputline.append(temp);
            outputline.append(",");
            outputline.append(pressure);
            outputline.append(",");
            outputline.append(wspd);
            outputline.append(",");
            outputline.append(wdir);
            outputline.append(",");
            outputline.append(rh);
            outputline.append(",");
            outputline.append(dt);
            outputline.append(",");
            output.append(outputline);
            output.append("\n");
        }
        return output.toString();
    }

    protected String readAMRC3File(List<String> lines) throws Exception {
        StringBuffer output = new StringBuffer();
        output.append(amrc3);
        int currentIndex = 0;
        String headerLine0 = lines.get(currentIndex++);
        List<String> toks0 = StringUtil.split(headerLine0, " ", true, true);
        String monStr = toks0.get(0);
        String yyStr = toks0.get(1).trim();
        int pos = toks0.lastIndexOf("Station");
        String id = toks0.get(pos + 2);
        String tid = "StationId=" + id;
        output.append(tid);
        output.append("\n");
        String headerLine1 = lines.get(currentIndex++);
        List<String> toks1 = StringUtil.split(headerLine1, " ", true, true);
        pos = toks1.indexOf("Lat");
        String latStr = toks1.get(pos + 2).trim();
        float latitude = latStr.endsWith("S") ? -1.0f * Float.parseFloat(latStr.substring(0, latStr.length() - 1)) : (latStr.endsWith("N") ? 1.0f * Float.parseFloat(latStr.substring(0, latStr.length() - 1)) : 1.0f * Float.parseFloat(latStr));
        pos = toks1.indexOf("Long");
        String lonStr = toks1.get(pos + 2).trim();
        float longitude = lonStr.endsWith("W") ? -1.0f * Float.parseFloat(lonStr.substring(0, lonStr.length() - 1)) : (lonStr.endsWith("E") ? 1.0f * Float.parseFloat(lonStr.substring(0, lonStr.length() - 1)) : 1.0f * Float.parseFloat(lonStr));
        pos = toks1.indexOf("Elev");
        String elevStr = toks1.get(pos + 2).trim();
        float altitude = elevStr.endsWith("m") ? Float.parseFloat(elevStr.substring(0, elevStr.length() - 1)) : Float.parseFloat(elevStr);
        String lat = "Latitude=" + latitude;
        String lon = "Longitude=" + longitude;
        String ele = "Altitude=" + altitude;
        output.append(lat);
        output.append("\n");
        output.append(lon);
        output.append("\n");
        output.append(ele);
        output.append("\n");
        while (currentIndex < lines.size()) {
            StringBuffer outputline = new StringBuffer();
            String headerLine2 = lines.get(currentIndex++);
            List<String> toks = StringUtil.split(headerLine2, " ", true, true);
            String jday = toks.get(0).trim();
            String ii = toks.get(1).trim();
            String temp = toks.get(2).trim();
            String pressure = toks.get(3).trim();
            String wspd = toks.get(4).trim();
            String wdir = toks.get(5).trim();
            String rh = toks.get(6).trim();
            String dt = toks.get(7).trim();
            Date date = new SimpleDateFormat("yyD").parse(yyStr + jday);
            long time0 = date.getTime() + (long)((Integer.parseInt(ii) - 1) * 10 * 60 * 1000);
            Date date1 = new Date(time0);
            DateTime dtt = new DateTime(date1);
            String ts = dtt.formattedString("yyyy-MM-dd HH:mm:ss z", DateUtil.TIMEZONE_GMT);
            outputline.append(ts);
            outputline.append(",");
            outputline.append(temp);
            outputline.append(",");
            outputline.append(pressure);
            outputline.append(",");
            outputline.append(wspd);
            outputline.append(",");
            outputline.append(wdir);
            outputline.append(",");
            outputline.append(rh);
            outputline.append(",");
            outputline.append(dt);
            outputline.append(",");
            output.append(outputline);
            output.append("\n");
        }
        return output.toString();
    }

    private DateTime getDateTime(int year, int month, int day, int hour) throws Exception {
        GregorianCalendar convertCal = new GregorianCalendar(DateUtil.TIMEZONE_GMT);
        convertCal.clear();
        convertCal.set(1, year);
        convertCal.set(2, month - 1);
        convertCal.set(5, day);
        convertCal.set(11, hour);
        return new DateTime(convertCal.getTime());
    }
}

