/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.imagery;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaDirectoryList;
import edu.wisc.ssec.mcidas.AreaFile;
import edu.wisc.ssec.mcidas.AreaFileFactory;
import edu.wisc.ssec.mcidas.Calibrator;
import edu.wisc.ssec.mcidas.CalibratorException;
import edu.wisc.ssec.mcidas.CalibratorFactory;
import edu.wisc.ssec.mcidas.adde.AddeSatBands;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.imagery.AddeImageDataSelection;
import ucar.unidata.data.imagery.AddeImageDescriptor;
import ucar.unidata.data.imagery.AddeImageInfo;
import ucar.unidata.data.imagery.BandInfo;
import ucar.unidata.data.imagery.ImageDataSelectionInfo;
import ucar.unidata.data.imagery.ImageDataSource;
import ucar.unidata.data.imagery.ImageDataset;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.data.AreaImageFlatField;
import visad.Data;
import visad.MathType;
import visad.Unit;
import visad.VisADException;
import visad.data.mcidas.AREACoordinateSystem;
import visad.data.mcidas.AreaAdapter;
import visad.meteorology.SingleBandedImage;

public class McIDASImageDataSource
extends ImageDataSource {
    DataChoice dataChoice;
    AddeImageDescriptor descriptor;
    DataSourceDescriptor dataSourceDescriptor;
    private AreaDirectory[][] currentDirs;
    private Hashtable timeMap = new Hashtable();
    protected Hashtable bandDirs;
    private boolean useSatBandInfo = true;
    private List<BandInfo> bandInfos;
    private AddeSatBands satBandInfo;
    int[] calblc;
    Calibrator cali;
    String[] calUnitDesp = new String[]{" ", "Raw", "Radiance", "Albedo", "Temperature", "Brightness", "Reflectivity"};
    AddeImageInfo imageInfo;
    boolean isPreCalibrated = false;
    AddeImageInfo previewImageInfo;
    private String source;
    AreaAdapter areaAdapter = null;
    AREAnav baseAnav = null;
    private AREACoordinateSystem acs;
    AreaFile af;
    protected AddeImageDataSelection addeImageDataSelection;
    BandInfo bandId;
    Hashtable allBandDirs;
    int elem0 = 0;
    int line0 = 0;
    int elems = 0;
    int lines = 0;
    int eMag = 1;
    int lMag = 1;
    int eMag0 = 1;
    int lMag0 = 1;
    private String choiceName;
    AreaDirectoryList adl1;
    int elFactor = 1;

    public McIDASImageDataSource() {
    }

    public McIDASImageDataSource(DataSourceDescriptor descriptor, String image, Hashtable properties) {
        super(descriptor, new String[]{image}, properties);
        try {
            this.areaAdapter = new AreaAdapter(image, false);
            this.af = this.areaAdapter.getAreaFile();
            this.baseAnav = this.af.getNavigation();
            this.acs = (AREACoordinateSystem)this.areaAdapter.getCoordinateSystem();
            this.af = AreaFileFactory.getAreaFileInstance(image);
            AreaDirectoryList adl = new AreaDirectoryList(image);
            this.currentDirs = adl.getSortedDirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.descriptor = new AddeImageDescriptor(this.af.getAreaDirectory(), image);
        this.dataSourceDescriptor = descriptor;
        this.init();
    }

    public McIDASImageDataSource(DataSourceDescriptor descriptor, ArrayList images, Hashtable properties) {
        super(descriptor, StringUtil.listToStringArray(images), properties);
        String image = (String)images.get(0);
        try {
            this.areaAdapter = new AreaAdapter(image, false);
            this.af = AreaFileFactory.getAreaFileInstance(image);
            this.baseAnav = this.af.getNavigation();
            AreaDirectoryList adl = new AreaDirectoryList(image);
            this.currentDirs = adl.getSortedDirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.descriptor = new AddeImageDescriptor(this.af.getAreaDirectory(), image);
        this.dataSourceDescriptor = descriptor;
        this.init();
    }

    public McIDASImageDataSource(DataSourceDescriptor descriptor, String[] images, Hashtable properties) {
        super(descriptor, images, properties);
    }

    public McIDASImageDataSource(DataSourceDescriptor descriptor, ImageDataset ids, Hashtable properties) {
        super(descriptor, ids, properties);
    }

    public void init() {
        this.bandDirs = new Hashtable(1);
        this.allBandDirs = new Hashtable();
        this.bandInfos = new ArrayList<BandInfo>();
        AreaDirectory dir = this.descriptor.getDirectory();
        int[] bands = dir.getBands();
        dir.getCalibrationType();
        this.calblc = this.af.getCal();
        int lines = dir.getLines();
        int elems = dir.getElements();
        int cline = lines / 2;
        int celem = elems / 2;
        String locateValue = cline + " " + celem;
        this.previewImageInfo = this.getPreviewImageInfo(dir, "LINELE");
        this.imageInfo = new AddeImageInfo("LINELE", locateValue, "CENTER", lines /= this.previewImageInfo.getLineMag(), elems /= this.previewImageInfo.getElementMag(), this.previewImageInfo.getLineMag(), this.previewImageInfo.getElementMag());
        try {
            if (this.calblc == null) {
                this.isPreCalibrated = true;
                this.cali = CalibratorFactory.getCalibrator(dir.getSensorID(), this.calblc);
                this.bandInfos = this.makeBandInfos(dir, bands, this.cali);
                Hashtable pt = this.getProperties();
                pt.put("bandinfo", this.bandInfos);
            } else {
                this.cali = CalibratorFactory.getCalibrator(dir.getSensorID(), this.calblc);
                this.bandInfos = this.makeBandInfos(dir, bands, this.cali);
                Hashtable pt = this.getProperties();
                pt.put("bandinfo", this.bandInfos);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getChoiceName() {
        return this.choiceName;
    }

    public void setChoiceName(String choiceName) {
        this.choiceName = choiceName;
    }

    @Override
    public void initAfterUnpersistence() {
        super.initAfterUnpersistence();
        if (this.getTmpPaths() != null) {
            return;
        }
        if (this.source == null && this.imageList != null && this.imageList.size() > 0) {
            List descriptors = super.getDescriptors(super.findDataChoice(this.choiceName), null);
            AddeImageDescriptor desc1 = (AddeImageDescriptor)descriptors.get(0);
            this.source = desc1.getSource();
            try {
                this.areaAdapter = new AreaAdapter(this.source, false);
                this.af = this.areaAdapter.getAreaFile();
                this.baseAnav = this.af.getNavigation();
                this.acs = (AREACoordinateSystem)this.areaAdapter.getCoordinateSystem();
                this.af = AreaFileFactory.getAreaFileInstance(this.source);
                AreaDirectoryList adl = new AreaDirectoryList(this.source);
                this.currentDirs = adl.getSortedDirs();
            }
            catch (Exception adl) {
                // empty catch block
            }
            this.allBandDirs = (Hashtable)this.getProperties().get("allBands");
            ArrayList oj = (ArrayList)this.getProperties().get("bandinfo");
            if (oj != null) {
                this.bandId = (BandInfo)oj.get(0);
            }
            AreaDirectory thisDir = desc1.getDirectory();
            this.descriptor = new AddeImageDescriptor(thisDir, null);
            this.init();
        }
    }

    private List<BandInfo> makeBandInfos(AreaDirectory ad, int[] bands, Calibrator cb) throws CalibratorException {
        ArrayList<BandInfo> l;
        block4: {
            block3: {
                l = new ArrayList<BandInfo>();
                if (ad == null || cb == null) break block3;
                if (bands == null) break block4;
                for (int i = 0; i < bands.length; ++i) {
                    int band = bands[i];
                    BandInfo bi = new BandInfo(ad.getSensorID(), band);
                    bi.setBandDescription(this.getBandName(ad, band));
                    bi.setCalibrationUnits(this.getAvailableUnits(cb.calibratedList(band, this.isPreCalibrated)));
                    bi.setPreferredUnit("BRIT");
                    l.add(bi);
                }
                break block4;
            }
            if (ad != null && bands != null) {
                for (int i = 0; i < bands.length; ++i) {
                    int band = bands[i];
                    BandInfo bi = new BandInfo(ad.getSensorID(), band);
                    bi.setBandDescription(this.getBandName(ad, band));
                    bi.setCalibrationUnits(null);
                    bi.setPreferredUnit("BRIT");
                    l.add(bi);
                }
            }
        }
        return l;
    }

    private List<TwoFacedObject> getAvailableUnits(int[] ulist) {
        Vector<TwoFacedObject> l = new Vector<TwoFacedObject>();
        if (ulist == null) {
            return new ArrayList<TwoFacedObject>();
        }
        TwoFacedObject tfo = null;
        int preferredUnitIndex = 0;
        String preferredUnit = "BRIT";
        for (int i = 0; i < ulist.length; ++i) {
            String name = AreaFileFactory.calIntToStr(ulist[i]);
            String desc = this.calUnitDesp[ulist[i]];
            tfo = new TwoFacedObject((Object)desc, name);
            l.add(tfo);
            if (!name.equalsIgnoreCase(preferredUnit)) continue;
            preferredUnitIndex = i;
        }
        return l;
    }

    private String getBandName(AreaDirectory ad, int band) {
        if (this.satBandInfo == null) {
            return "Band: " + band;
        }
        String[] descrs = this.satBandInfo.getBandDescr(ad.getSensorID(), ad.getSourceType());
        if (descrs != null && band >= 0 && band < descrs.length) {
            return descrs[band];
        }
        return "Band: " + band;
    }

    @Override
    public String getImageDataSourceName() {
        return "McIDAS Image dataset";
    }

    @Override
    public String getDataName() {
        return "All Images";
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        this.dataChoice = dataChoice;
        this.choiceName = dataChoice.getName();
        GeoSelection geoSelection = dataSelection.getGeoSelection();
        boolean isProgressiveResolution = dataSelection.getProperty("Use_Progressive_Resolution", true);
        String t1 = dataSelection.getProperty("Region_Selection_Option", "Use_Default_Area");
        int dlMag = 0;
        int deMag = 0;
        if (!isProgressiveResolution && this.addeImageDataSelection != null) {
            dlMag = this.addeImageDataSelection.getAdvancedPanel().getLineMagValue();
            deMag = this.addeImageDataSelection.getAdvancedPanel().getElementMagValue();
        }
        if (geoSelection != null) {
            Rectangle2D rect = geoSelection.getScreenBound();
            ImageDataSelectionInfo adSource = (ImageDataSelectionInfo)dataSelection.getProperty("advancedURL");
            if (geoSelection.getBoundingBox() == null && adSource != null) {
                String locationKey = adSource.getLocateKey();
                deMag = adSource.getElementMag();
                dlMag = adSource.getLineMag();
                String placeValue = adSource.getPlaceValue();
                if (locationKey.equals("LATLON")) {
                    String locValue = adSource.getLocateValue();
                    String[] segs = locValue.split(" ");
                    String seg0 = segs[0];
                    String seg1 = segs[1];
                    double[][] ll = new double[2][1];
                    ll[0][0] = Float.parseFloat(seg0);
                    ll[1][0] = Float.parseFloat(seg1);
                    double[][] el = this.baseAnav.toLinEle(ll);
                    this.elem0 = (int)Math.floor(el[0][0] + 0.5) * Math.abs(this.eMag0);
                    this.line0 = (int)Math.floor(el[1][0] + 0.5) * Math.abs(this.lMag0);
                } else {
                    this.elem0 = adSource.getLocationElem();
                    this.line0 = adSource.getLocationLine();
                }
                int lines0 = adSource.getLines() * Math.abs(dlMag);
                int elems0 = adSource.getElements() * Math.abs(deMag);
                if (placeValue.equals("CENTER")) {
                    this.elem0 -= elems0 / 2;
                    this.line0 -= lines0 / 2;
                }
                if (isProgressiveResolution) {
                    this.lMag = this.calculateMagFactor(lines0, (int)rect.getHeight());
                    this.eMag = this.lMag * this.elFactor;
                } else {
                    this.eMag = Math.abs(deMag);
                    this.lMag = Math.abs(dlMag);
                }
                this.lines = (int)Math.floor((double)(lines0 / this.lMag) + 0.5);
                this.elems = elems0 / this.eMag;
                this.lines = this.lMag == 1 ? lines0 : (int)Math.floor((double)(lines0 / this.lMag) + 0.5);
                this.elems = this.eMag == 1 ? elems0 : (int)Math.floor((double)(elems0 / this.eMag) + 0.5);
            } else if (t1.equals("Match_Display_Area") || geoSelection.getBoundingBox() != null || geoSelection.getUseViewBounds()) {
                double maxLat = geoSelection.getBoundingBox().getMaxLat();
                double minLat = geoSelection.getBoundingBox().getMinLat();
                double maxLon = geoSelection.getBoundingBox().getMaxLon();
                double minLon = geoSelection.getBoundingBox().getMinLon();
                maxLat = maxLat > 90.0 ? 90.0 : maxLat;
                minLat = minLat < -90.0 ? -90.0 : minLat;
                maxLon = maxLon >= 180.0 ? 180.0 : maxLon;
                minLon = minLon < -180.0 ? -180.0 : minLon;
                GeoLocationInfo mapInfo = new GeoLocationInfo(maxLat, minLon, minLat, maxLon);
                LatLonPointImpl llp = (LatLonPointImpl)dataSelection.getProperty("centerPosition");
                if (llp != null) {
                    BandInfo id = (BandInfo)dataChoice.getId();
                    int[] dir = null;
                    AreaDirectory thisDir = null;
                    thisDir = this.allBandDirs != null && this.allBandDirs.size() > 0 ? (AreaDirectory)this.allBandDirs.get(id.getBandNumber()) : this.descriptor.getDirectory();
                    dir = thisDir.getDirectoryBlock();
                    GeoLocationInfo ginfo = this.getImageBoundingBox(1, 1, dir[8], dir[9]);
                    if (ginfo.getLatLonRect().containedIn(mapInfo.getLatLonRect())) {
                        this.elem0 = 0;
                        this.line0 = 0;
                        int lines0 = dir[8];
                        int elems0 = dir[9];
                        if (isProgressiveResolution) {
                            this.lMag = this.calculateMagFactor(lines0, (int)rect.getHeight());
                            this.lMag = this.lMag >= 2 ? this.lMag / 2 : 1;
                            this.eMag = this.lMag * this.elFactor;
                        } else {
                            this.eMag = Math.abs(deMag);
                            this.lMag = Math.abs(dlMag);
                        }
                        this.lines = this.lMag == 1 ? lines0 : (int)Math.floor((double)(lines0 / this.lMag) + 0.5);
                        this.elems = this.eMag == 1 ? elems0 : (int)Math.floor((double)(elems0 / this.eMag) + 0.5);
                    } else {
                        LatLonRect bbox = mapInfo.getLatLonRect().intersect(ginfo.getLatLonRect());
                        if (mapInfo.getLatLonRect().containedIn(ginfo.getLatLonRect())) {
                            bbox = mapInfo.getLatLonRect();
                        }
                        if (bbox == null) {
                            bbox = mapInfo.getLatLonRect();
                        } else {
                            boolean con = ginfo.getLatLonRect().contains(llp);
                            if (!con) {
                                llp = new LatLonPointImpl(thisDir.getCenterLatitude(), thisDir.getCenterLongitude());
                            }
                        }
                        maxLat = bbox.getLatMax();
                        minLat = bbox.getLatMin();
                        maxLon = bbox.getLonMax();
                        minLon = bbox.getLonMin();
                        double[][] ll = new double[2][1];
                        ll[0][0] = maxLat;
                        ll[1][0] = minLon;
                        double[][] el = this.baseAnav.toLinEle(ll);
                        this.elem0 = (int)Math.floor(el[0][0] + 0.5) * Math.abs(this.eMag0);
                        this.line0 = (int)Math.floor(el[1][0] + 0.5) * Math.abs(this.lMag0);
                        float[][] latlon = new float[2][1];
                        latlon[1][0] = (float)llp.getLongitude();
                        latlon[0][0] = (float)maxLat;
                        float[][] ulLinEle = this.baseAnav.toLinEle(latlon);
                        if (ulLinEle[1][0] < 0.0f || ulLinEle[1][0] != ulLinEle[1][0]) {
                            ulLinEle[1][0] = 0.0f;
                        }
                        latlon[1][0] = (float)llp.getLongitude();
                        latlon[0][0] = (float)minLat;
                        float[][] lrLinEle = this.baseAnav.toLinEle(latlon);
                        if (lrLinEle[1][0] < 0.0f || lrLinEle[1][0] != lrLinEle[1][0]) {
                            int ln = dir[8];
                            lrLinEle[1][0] = ln / Math.abs(this.lMag0);
                        }
                        int lines0 = (int)(lrLinEle[1][0] - ulLinEle[1][0]) * Math.abs(this.lMag0);
                        latlon[1][0] = (float)minLon;
                        latlon[0][0] = (float)llp.getLatitude();
                        ulLinEle = this.acs.fromReference(latlon);
                        if (ulLinEle[0][0] < 0.0f || ulLinEle[0][0] != ulLinEle[0][0]) {
                            ulLinEle[0][0] = 0.0f;
                        }
                        latlon[1][0] = (float)maxLon;
                        latlon[0][0] = (float)llp.getLatitude();
                        lrLinEle = this.acs.fromReference(latlon);
                        if (lrLinEle[0][0] < 0.0f || lrLinEle[0][0] != lrLinEle[0][0]) {
                            int en = dir[9];
                            lrLinEle[0][0] = en / Math.abs(this.eMag0);
                        }
                        int elems0 = (int)Math.abs(lrLinEle[0][0] - ulLinEle[0][0]) * Math.abs(this.eMag0);
                        if (isProgressiveResolution) {
                            this.lMag = this.calculateMagFactor(lines0, (int)rect.getHeight());
                            this.lMag = this.lMag >= 2 ? this.lMag / 2 : 1;
                            this.eMag = this.lMag * this.elFactor;
                        } else {
                            this.eMag = Math.abs(deMag);
                            this.lMag = Math.abs(dlMag);
                        }
                        this.lines = this.lMag == 1 ? lines0 : (int)Math.floor((double)(lines0 / this.lMag) + 0.5);
                        this.elems = this.eMag == 1 ? elems0 : (int)Math.floor((double)(elems0 / this.eMag) + 0.5);
                        if (this.lines > dir[8]) {
                            this.lines = dir[8];
                        }
                        if (this.elems > dir[9]) {
                            this.elems = dir[9];
                        }
                    }
                }
            }
        }
        Data imageData = super.getDataInner(dataChoice, category, dataSelection, requestProperties);
        return imageData;
    }

    public GeoLocationInfo getImageBoundingBox(int eMag, int lMag, int lines, int elems) {
        double maxLat = 0.0;
        double minLat = 0.0;
        double maxLon = 0.0;
        double minLon = 0.0;
        double[][] el = new double[2][1];
        int eSize = elems / eMag;
        int lSize = lines / lMag;
        try {
            int i = 0;
            int j = 0;
            el[0][0] = i;
            el[1][0] = j;
            double[][] ll = this.baseAnav.toLatLon(el);
            while (ll[0][0] != ll[0][0] && i < eSize && j < lSize) {
                el[0][0] = ++i;
                el[1][0] = ++j;
                ll = this.baseAnav.toLatLon(el);
            }
            minLon = ll[0][0] != ll[0][0] ? -180.0 : ll[1][0];
            i = eSize;
            j = lSize;
            el[0][0] = i;
            el[1][0] = j;
            ll = this.baseAnav.toLatLon(el);
            while (ll[0][0] != ll[0][0] && i > 0 && j > 0) {
                el[0][0] = --i;
                el[1][0] = --j;
                ll = this.baseAnav.toLatLon(el);
            }
            maxLon = ll[0][0] != ll[0][0] ? 180.0 : ll[1][0];
            i = eSize / 2;
            j = 0;
            el[0][0] = i;
            el[1][0] = j;
            ll = this.baseAnav.toLatLon(el);
            while (ll[0][0] != ll[0][0] && j < lSize) {
                el[0][0] = i;
                el[1][0] = ++j;
                ll = this.baseAnav.toLatLon(el);
            }
            maxLat = ll[0][0] != ll[0][0] ? 90.0 : ll[0][0];
            i = eSize / 2;
            j = lSize;
            el[0][0] = i;
            el[1][0] = j;
            ll = this.baseAnav.toLatLon(el);
            while (ll[0][0] != ll[0][0] && j > 0) {
                el[0][0] = i;
                el[1][0] = --j;
                ll = this.baseAnav.toLatLon(el);
            }
            minLat = ll[0][0] != ll[0][0] ? -90.0 : ll[0][0];
        }
        catch (Exception e) {
            System.out.println("convertToLatLon e=" + e);
        }
        return new GeoLocationInfo(maxLat, minLon, minLat, maxLon);
    }

    public int calculateMagFactor(int dataPoints, int displayPoints) {
        if (dataPoints <= displayPoints) {
            return 1;
        }
        int factor = (int)Math.floor(1.0 * (double)dataPoints / (1.0 * (double)displayPoints) + 0.8);
        return factor;
    }

    @Override
    protected SingleBandedImage makeImage(AddeImageDescriptor aid, MathType rangeType, boolean fromSequence, String readLabel) throws VisADException, RemoteException {
        String desc = this.dataChoice.getDescription();
        int calOutType = Arrays.asList(this.calUnitDesp).indexOf(desc);
        Object id = this.dataChoice.getId();
        int band = 0;
        if (this.cali != null) {
            BandInfo binfo = (BandInfo)id;
            band = binfo.getBandNumber();
        }
        if (aid == null) {
            return null;
        }
        String source = aid.getSource() + " band: " + band + " calOutType: " + calOutType + " line0 " + this.line0 + " elem0 " + this.elem0 + " lines " + this.lines + " elems " + this.elems;
        SingleBandedImage result = (SingleBandedImage)this.getCache(source);
        if (result != null) {
            return result;
        }
        try {
            float[] data1;
            float[][] data0;
            AddeImageInfo aii = aid.getImageInfo();
            AreaDirectory areaDir = null;
            if (areaDir == null) {
                areaDir = aid.getDirectory();
            }
            if (!this.getCacheDataToDisk()) {
                areaDir = null;
            }
            if (areaDir != null && this.cali != null) {
                String unitStr = this.cali.calibratedUnit(calOutType);
                Unit unit = null;
                if (unitStr != null) {
                    unit = DataUtil.parseUnit(unitStr);
                }
                if (this.line0 < 0) {
                    this.line0 = 1;
                }
                if (this.elem0 < 0) {
                    this.elem0 = 1;
                }
                int elemTotal = areaDir.getElements();
                int lineTotal = areaDir.getLines();
                while (this.lMag * this.lines + this.line0 > lineTotal) {
                    --this.lines;
                }
                while (this.eMag * this.elems + this.elem0 > elemTotal) {
                    --this.elems;
                }
                result = AreaImageFlatField.createImmediateWithUnit(aid, readLabel, unit, this.line0, this.elem0, this.lines, this.elems, this.lMag, this.eMag, band);
                this.timeMap.put(aid.getSource(), result.getStartTime());
            }
            if (!this.isPreCalibrated && this.cali != null) {
                data0 = result.getFloats();
                data1 = this.cali.calibrate(data0[0], band, calOutType);
                float[][] data2 = new float[1][data1.length];
                data2[0] = data1;
                result.setSamples(data2);
            } else if (this.isPreCalibrated && calOutType == 4) {
                data0 = result.getFloats();
                data1 = this.convertBritToTemp(data0[0]);
                float[][] data2 = new float[1][data1.length];
                data2[0] = data1;
                result.setSamples(data2);
            } else if (areaDir == null || this.cali == null) {
                AreaAdapter aa = new AreaAdapter(aid.getSource(), false);
                this.timeMap.put(aid.getSource(), aa.getImageStartTime());
                result = aa.getImage();
            }
            this.putCache(source, result);
            return result;
        }
        catch (IOException ioe) {
            throw new VisADException("Creating AreaAdapter - " + ioe);
        }
    }

    protected void initDataSelectionComponents(List components, DataChoice dataChoice) {
        try {
            BandInfo id = null;
            if (dataChoice.getId() instanceof BandInfo && this.allBandDirs != null) {
                id = (BandInfo)dataChoice.getId();
                if (this.bandId == null) {
                    this.bandId = id;
                }
            } else {
                return;
            }
            if (this.baseAnav == null || !id.equals(this.bandId)) {
                try {
                    this.areaAdapter = new AreaAdapter(this.source, false);
                    AreaFile areaFile = this.areaAdapter.getAreaFile();
                    this.baseAnav = areaFile.getNavigation();
                    this.acs = new AREACoordinateSystem(areaFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.bandId = id;
            }
            this.addeImageDataSelection = new AddeImageDataSelection(this, dataChoice, this.source, this.baseAnav, this.imageInfo, this.acs, this.areaAdapter, this.cali, this.bandId.getBandNumber());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(LogUtil.getCurrentWindow(), ex.getMessage(), "Error in initDataSelectionComponents 2", 0);
            this.getDataContext().getIdv().showNormalCursor();
            return;
        }
        if (this.areaAdapter != null) {
            components.add(this.addeImageDataSelection.getRegionPanel());
            components.add(this.addeImageDataSelection.getAdvancedPanel());
        }
    }

    public AddeImageInfo getPreviewImageInfo(AreaDirectory aDir, String navType) {
        int[] dir = aDir.getDirectoryBlock();
        int inLine = dir[8];
        int inElem = dir[9];
        int inLineMag = 1;
        int inElemMag = 1;
        if (aDir.getCenterLatitudeResolution() == aDir.getCenterLatitudeResolution()) {
            this.elFactor = (int)Math.ceil(aDir.getCenterLatitudeResolution() / aDir.getCenterLongitudeResolution() - 0.5);
        }
        int lineFactor = 1;
        int elemFactor = 1;
        int outElem = inElem;
        int outLine = inLine;
        if (navType.equals("LALO")) {
            while (outLine > 450) {
                outLine = inLine / ++lineFactor;
            }
            inElemMag = (inLineMag *= lineFactor) / this.elFactor;
            if (inElemMag == 0) {
                inElemMag = 1;
            }
            outElem = inElem / inElemMag;
        } else {
            while (outElem > 450) {
                outElem = inElem / ++elemFactor;
            }
            inLineMag = (inElemMag *= elemFactor) / this.elFactor;
            if (inLineMag == 0) {
                inLineMag = 1;
            }
            outLine = inLine / inLineMag;
        }
        int cline = inLine / 2;
        int celem = inElem / 2;
        int eMag = inElemMag;
        int lMag = inLineMag;
        String locateValue = cline + " " + celem;
        AddeImageInfo adinfo = new AddeImageInfo("LINELE", locateValue, "CENTER", outLine, outElem, lMag, eMag);
        return adinfo;
    }

    public float convertBritToTemp(int inVal) {
        int con1 = 418;
        int con2 = 660;
        int ilim = 176;
        float outVal = inVal > ilim ? (float)(con1 - inVal) : (float)((con2 - inVal) / 2);
        return outVal;
    }

    public float[] convertBritToTemp(float[] inputData) {
        float[] outputData = new float[inputData.length];
        for (int i = 0; i < inputData.length; ++i) {
            outputData[i] = this.convertBritToTemp((int)inputData[i]);
        }
        return outputData;
    }
}

