/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.imagery;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.FilesDataSource;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.gis.KmlDataSource;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.data.imagery.ImageInfo;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.WrapperException;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.ShapefileAdapter;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import visad.CommonUnit;
import visad.Data;
import visad.DataImpl;
import visad.DateTime;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.SingletonSet;
import visad.UnionSet;
import visad.VisADException;
import visad.data.DefaultFamily;
import visad.util.ImageHelper;

public class ImageXmlDataSource
extends FilesDataSource {
    public static final PatternFileFilter FILTER_XIMG = new PatternFileFilter(".+\\.ximg", "Image Xml files (*.ximg)");
    public static final String EXT_XIMG = ".ximg";
    public static final String TAG_COLLECTION = "collection";
    public static final String TAG_GROUP = "group";
    public static final String TAG_IMAGE = "image";
    public static final String TAG_BYTES = "ytes";
    public static final String TAG_SHAPE = "shape";
    public static final String ATTR_BASE = "base";
    public static final String ATTR_ID = "id";
    public static final String ATTR_FORMAT = "format";
    public static final String ATTR_BYTES = "bytes";
    public static final String ATTR_DATE = "date";
    public static final String ATTR_URL = "url";
    public static final String ATTR_NAME = "name";
    private Hashtable imageProps;
    private Hashtable mapProps;
    DefaultFamily family = new DefaultFamily("VisADDataSource");
    Hashtable urlToElement = new Hashtable();
    private List imageCategories;
    private List shapeCategories;
    private boolean haveEmbeddedFiles = false;
    private Hashtable nodeMap = new Hashtable();
    private List relativeFiles = new ArrayList();

    public ImageXmlDataSource() {
    }

    public ImageXmlDataSource(DataSourceDescriptor descriptor, String filename, Hashtable properties) throws VisADException {
        super(descriptor, filename, "Image data source", properties);
    }

    @Override
    public List getDataPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(this.getFilePath());
        paths.addAll(this.relativeFiles);
        return paths;
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        if (this.isFileBased()) {
            return false;
        }
        if (this.haveEmbeddedFiles) {
            return true;
        }
        return true;
    }

    @Override
    protected List saveDataToLocalDisk(String prefix, Object loadId, boolean changeLinks) throws Exception {
        String ximgFile = this.getFilePath();
        File parentDir = new File(prefix).getParentFile();
        List newXimgFiles = IOUtil.writeTo(Misc.newList(ximgFile), prefix, "ximg");
        if (newXimgFiles == null) {
            return null;
        }
        ArrayList filesToMove = new ArrayList(this.relativeFiles);
        ArrayList<String> newFiles = new ArrayList<String>(newXimgFiles);
        for (int i = 0; i < filesToMove.size(); ++i) {
            String file = (String)filesToMove.get(i);
            String newFilePath = IOUtil.joinDir(parentDir.toString(), IOUtil.getFileTail(file));
            if (IOUtil.writeTo(IOUtil.getURL(file, this.getClass()), new File(newFilePath), loadId) <= 0L) continue;
            newFiles.add(newFilePath);
        }
        if (newXimgFiles != null && changeLinks) {
            this.setNewFiles(newXimgFiles);
        }
        return newFiles;
    }

    @Override
    public List getAllDateTimes(DataChoice dataChoice) {
        Object id = dataChoice.getId();
        if (!(id instanceof List)) {
            return super.getAllDateTimes(dataChoice);
        }
        List l = (List)id;
        ArrayList<DateTime> times = new ArrayList<DateTime>();
        for (int i = 0; i < l.size(); ++i) {
            ImageInfo ii = (ImageInfo)l.get(i);
            if (ii.getDate() == null) continue;
            times.add(ii.getDate());
        }
        return times;
    }

    private String getBase(Element node) {
        if (node == null) {
            return IOUtil.getFileRoot(this.getFilePath());
        }
        String base = XmlUtil.getAttribute((Node)node, ATTR_BASE, (String)null);
        if (base != null) {
            return base;
        }
        Node parent = node.getParentNode();
        if (parent != null && parent instanceof Element) {
            return this.getBase((Element)parent);
        }
        return this.getBase(null);
    }

    @Override
    protected void doMakeDataChoices() {
        String xmlFile = this.getFilePath();
        try {
            this.imageCategories = DataCategory.parseCategories("RGBIMAGE", false);
            this.shapeCategories = DataCategory.parseCategories("GIS-SHAPEFILE", false);
            Element root = XmlUtil.getRoot(xmlFile, this.getClass());
            if (root == null) {
                throw new IllegalArgumentException("Could not find image xml file:" + xmlFile);
            }
            String dataSourceName = XmlUtil.getAttribute((Node)root, ATTR_NAME, (String)null);
            if (dataSourceName != null) {
                this.setName(dataSourceName);
            }
            if (root.getTagName().equals(TAG_IMAGE) || root.getTagName().equals(TAG_GROUP)) {
                this.processNode(root, null);
            } else {
                this.recurseXml(root, null);
            }
        }
        catch (Exception exc) {
            this.setInError(true);
            throw new WrapperException("Loading image xml file: " + xmlFile, exc);
        }
    }

    protected void recurseXml(Element root, CompositeDataChoice cdc) throws Exception {
        this.imageProps = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/Earth16.gif");
        this.mapProps = Misc.newHashtable("prop.icon", "/auxdata/ui/icons/Map16.gif");
        NodeList elements = XmlUtil.getElements(root);
        for (int i = 0; i < elements.getLength(); ++i) {
            Element child = (Element)elements.item(i);
            this.processNode(child, cdc);
        }
    }

    private String getUrl(Element child) {
        String base = this.getBase(child);
        String url = XmlUtil.getAttribute((Node)child, ATTR_URL, (String)null);
        if (url != null) {
            File fileUrl = new File(url);
            if (fileUrl.exists() && !fileUrl.isAbsolute()) {
                url = base + "/" + url;
            }
            if (!(fileUrl.exists() || url.startsWith("http") || url.startsWith("/") || base == null)) {
                url = !base.endsWith("/") ? base + "/" + url : base + url;
            }
        }
        return url;
    }

    private void processNode(Element child, CompositeDataChoice cdc) throws Exception {
        if (child.getTagName().equals(TAG_IMAGE) || child.getTagName().equals(TAG_GROUP)) {
            List categories = this.imageCategories;
            Object dataChoiceData = null;
            String name = XmlUtil.getAttribute((Node)child, ATTR_NAME, (String)null);
            if (child.getTagName().equals(TAG_IMAGE)) {
                String id = null;
                if (XmlUtil.hasAttribute(child, ATTR_URL)) {
                    String url = XmlUtil.getAttribute(child, ATTR_URL);
                    if (name == null) {
                        name = url;
                    }
                    id = url;
                    String fullUrl = this.getUrl(child);
                    if (!Misc.equals(fullUrl, url) || new File(url).exists()) {
                        this.relativeFiles.add(fullUrl);
                    }
                } else if (XmlUtil.hasAttribute(child, ATTR_ID)) {
                    this.haveEmbeddedFiles = true;
                    id = XmlUtil.getAttribute(child, ATTR_ID);
                } else {
                    this.haveEmbeddedFiles = true;
                    id = ATTR_ID + this.nodeMap.size();
                }
                this.nodeMap.put(id, child);
                dataChoiceData = new ImageInfo(id, child, null, null);
            } else if (child.getTagName().equals(TAG_GROUP)) {
                String dateFormat = XmlUtil.getAttribute((Node)child, ATTR_FORMAT, "yyyyMMddHH Z");
                ArrayList<ImageInfo> imageInfos = new ArrayList<ImageInfo>();
                NodeList elements = XmlUtil.getElements(child);
                boolean haveDate = false;
                boolean dontHaveDate = false;
                for (int i = 0; i < elements.getLength(); ++i) {
                    Element imageChild = (Element)elements.item(i);
                    String url = this.getUrl(imageChild);
                    if (name == null) {
                        name = url;
                    }
                    String time = XmlUtil.getAttribute((Node)imageChild, ATTR_DATE, (String)null);
                    try {
                        DateTime dttm;
                        DateTime dateTime = dttm = time == null ? null : DateTime.createDateTime(time, dateFormat);
                        if (dttm == null) {
                            dontHaveDate = true;
                        } else {
                            haveDate = true;
                        }
                        if (imageChild.getTagName().equals(TAG_IMAGE)) {
                            imageInfos.add(new ImageInfo(url, imageChild, child, dttm));
                            continue;
                        }
                        if (!imageChild.getTagName().equals(TAG_SHAPE)) continue;
                        imageInfos.add(new ImageInfo(url, dttm, true));
                        categories = this.shapeCategories;
                        continue;
                    }
                    catch (Exception exc) {
                        throw new WrapperException("Processing ximg file", exc);
                    }
                }
                dataChoiceData = imageInfos;
                if (dontHaveDate && haveDate) {
                    throw new IllegalArgumentException("Some of the elements have a date field, some don't");
                }
            } else {
                throw new IllegalArgumentException("Unknown ximg tag:" + child.getTagName());
            }
            DirectDataChoice ddc = new DirectDataChoice((DataSource)this, dataChoiceData, name, name, categories, this.imageProps);
            if (cdc != null) {
                cdc.addDataChoice(ddc);
            } else {
                this.addDataChoice(ddc);
            }
        } else if (child.getTagName().equals(TAG_SHAPE)) {
            String url = XmlUtil.getAttribute(child, ATTR_URL);
            String base = this.getBase(child);
            if (!url.startsWith("http") && base != null) {
                url = base + url;
            }
            String name = XmlUtil.getAttribute((Node)child, ATTR_NAME, url);
            DirectDataChoice ddc = new DirectDataChoice((DataSource)this, (Object)new ImageInfo(url, true), name, name, this.shapeCategories, this.mapProps);
            if (cdc != null) {
                cdc.addDataChoice(ddc);
            } else {
                this.addDataChoice(ddc);
            }
        } else if (child.getTagName().equals(TAG_COLLECTION)) {
            String name = XmlUtil.getAttribute(child, ATTR_NAME);
            CompositeDataChoice newCdc = new CompositeDataChoice(this, (Object)"", name, name, null);
            if (cdc != null) {
                cdc.addDataChoice(newCdc);
            } else {
                this.addDataChoice(newCdc);
            }
            this.recurseXml(child, newCdc);
        }
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        List list;
        List selectedTimes = this.getTimesFromDataSelection(dataSelection, dataChoice);
        Hashtable okTimes = null;
        for (int i = 0; i < selectedTimes.size(); ++i) {
            if (okTimes == null) {
                okTimes = new Hashtable();
            }
            okTimes.put(selectedTimes.get(i), "");
        }
        Object stuff = dataChoice.getId();
        boolean justOne = false;
        if (stuff instanceof ImageInfo) {
            list = Misc.newList(stuff);
            justOne = true;
        } else {
            list = (List)stuff;
        }
        if (list.size() == 0) {
            return null;
        }
        ArrayList<UnionSet> dataList = new ArrayList<UnionSet>();
        ArrayList<DateTime> dateTimesList = new ArrayList<DateTime>();
        boolean usingIndex = false;
        for (int i = 0; i < list.size(); ++i) {
            ImageInfo ii = (ImageInfo)list.get(i);
            DataImpl d = null;
            if (okTimes != null && ii.getDate() != null && okTimes.get(ii.getDate()) == null) continue;
            InputStream is = null;
            String id = ii.getUrl();
            String url = ii.getUrl();
            Element node = (Element)this.nodeMap.get(id);
            try {
                if (node != null) {
                    url = this.getUrl(node);
                }
                if (node == null || XmlUtil.hasAttribute(node, ATTR_URL)) {
                    is = IOUtil.getInputStream(url, this.getClass());
                } else {
                    String byteString = XmlUtil.getChildText(node);
                    if (byteString == null) {
                        throw new IllegalStateException("Unable to read data bytes");
                    }
                    byteString = byteString.trim();
                    is = new ByteArrayInputStream(XmlUtil.decodeBase64(byteString));
                }
            }
            catch (Exception exc) {
                throw new WrapperException("Error reading file: " + ii.getUrl(), exc);
            }
            if (ii.getIsShape()) {
                try {
                    ShapefileAdapter sfa = new ShapefileAdapter(is);
                    d = sfa.getData();
                }
                catch (Exception exc) {
                    throw new WrapperException("Error reading shapefile: " + ii.getUrl(), exc);
                }
            }
            try {
                GriddedSet newDomain;
                byte[] imageContent = IOUtil.readBytes(is);
                Image image = Toolkit.getDefaultToolkit().createImage(imageContent);
                ImageHelper ih = new ImageHelper();
                image.getWidth(ih);
                if (ih.badImage) {
                    throw new IllegalStateException("Bad image: " + ii.getUrl());
                }
                FlatField ff = Util.makeField(image, true);
                Linear2DSet domain = (Linear2DSet)ff.getDomainSet();
                int width = domain.getX().getLength();
                int height = domain.getY().getLength();
                int pixels = width * height;
                double ulLat = ii.getUlLat();
                double ulLon = ii.getUlLon();
                double ulAlt = ii.getUlAlt();
                double urLat = ii.getUrLat();
                double urLon = ii.getUrLon();
                double urAlt = ii.getUrAlt();
                double llLat = ii.getLlLat();
                double llLon = ii.getLlLon();
                double llAlt = ii.getLlAlt();
                double lrLat = ii.getLrLat();
                double lrLon = ii.getLrLon();
                double lrAlt = ii.getLrAlt();
                boolean hasAltitude = ii.hasAltitude();
                if (!hasAltitude && ii.isRectilinear()) {
                    newDomain = new Linear2DSet((MathType)RealTupleType.SpatialEarth2DTuple, ulLon, lrLon, width, ulLat, lrLat, height);
                } else {
                    float[][] values = hasAltitude ? new float[3][pixels] : new float[2][pixels];
                    int pixel = 0;
                    double alt1 = 0.0;
                    double alt2 = 0.0;
                    for (int row = 0; row < height; ++row) {
                        double rowPercent = (double)row / (double)height;
                        double lat1 = ulLat + (llLat - ulLat) * rowPercent;
                        double lat2 = urLat + (lrLat - urLat) * rowPercent;
                        double lon1 = ulLon + (llLon - ulLon) * rowPercent;
                        double lon2 = urLon + (lrLon - urLon) * rowPercent;
                        if (hasAltitude) {
                            alt1 = ulAlt + (llAlt - ulAlt) * rowPercent;
                            alt2 = urAlt + (lrAlt - urAlt) * rowPercent;
                        }
                        for (int col = 0; col < width; ++col) {
                            double colPercent = (double)col / (double)width;
                            double lat = lat1 + (lat2 - lat1) * colPercent;
                            double lon = lon1 + (lon2 - lon1) * colPercent;
                            values[0][pixel] = (float)lat;
                            values[1][pixel] = (float)lon;
                            if (hasAltitude) {
                                values[2][pixel] = (float)(alt1 + (alt2 - alt1) * colPercent);
                            }
                            ++pixel;
                        }
                    }
                    newDomain = hasAltitude ? new Gridded3DSet((MathType)RealTupleType.LatitudeLongitudeAltitude, values, width, height, null, null, null, false) : new Gridded2DSet(RealTupleType.LatitudeLongitudeTuple, values, width, height, null, null, null, false);
                }
                d = GridUtil.setSpatialDomain(ff, newDomain);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                throw new BadDataException("Error reading image file: " + ii.getUrl() + "\n" + exc);
            }
            if (justOne) {
                return d;
            }
            if (ii.getDate() != null) {
                dateTimesList.add(ii.getDate());
            } else {
                usingIndex = true;
            }
            dataList.add((UnionSet)d);
        }
        Data[] dataArray = new Data[dataList.size()];
        for (int i = 0; i < dataArray.length; ++i) {
            dataArray[i] = (Data)dataList.get(i);
        }
        FieldImpl data = null;
        RealType domainType = null;
        int[] timeIndices = null;
        SampledSet domain = null;
        for (int i = 0; i < dataArray.length; ++i) {
            if (data == null) {
                if (usingIndex) {
                    domainType = RealType.getRealType("index");
                    domain = new Integer1DSet((MathType)domainType, dataArray.length);
                } else {
                    DateTime[] timesArray = new DateTime[dateTimesList.size()];
                    double[] timeVals = new double[dateTimesList.size()];
                    for (int timeIdx = 0; timeIdx < timesArray.length; ++timeIdx) {
                        DateTime dt;
                        timesArray[timeIdx] = dt = (DateTime)dateTimesList.get(timeIdx);
                        timeVals[timeIdx] = dt.getValue(CommonUnit.secondsSinceTheEpoch);
                    }
                    domain = timesArray.length == 1 ? new SingletonSet(new RealTuple(new Real[]{timesArray[0]})) : CalendarDateTime.makeTimeSet(timesArray);
                    domainType = RealType.Time;
                    timeIndices = domain.doubleToIndex(new double[][]{timeVals});
                }
                data = new FieldImpl(new FunctionType(domainType, dataArray[i].getType()), domain);
            }
            int index = usingIndex || dataArray.length == 1 ? i : timeIndices[i];
            data.setSample(index, dataArray[i], false);
        }
        return data;
    }

    @Override
    protected List doMakeDateTimes() {
        return new ArrayList();
    }

    public void setXmlFile(String value) {
        this.sources = Misc.newList(value);
    }

    public static void writeToFile(String filename, GeoLocationInfo bounds, byte[] bytes, String format) throws FileNotFoundException, IOException {
        format = StringUtil.replace(format, "image/", "");
        String imageFileName = IOUtil.stripExtension(filename) + "." + format;
        if (KmlDataSource.isKmlFile(filename)) {
            IOUtil.writeBytes(new File(imageFileName), bytes);
            KmlDataSource.writeToFile(filename, bounds, imageFileName);
            return;
        }
        StringBuffer sb = new StringBuffer();
        String nav = XmlUtil.attrs("ullat", "" + bounds.getMaxLat(), "lrlat", "" + bounds.getMinLat());
        nav = nav + XmlUtil.attrs("ullon", "" + bounds.getMinLon(), "lrlon", "" + bounds.getMaxLon());
        IOUtil.writeBytes(new File(imageFileName), bytes);
        sb.append(XmlUtil.openTag(TAG_IMAGE, nav + XmlUtil.attr(ATTR_NAME, IOUtil.stripExtension(IOUtil.getFileTail(filename)))));
        XmlUtil.appendCdataBytes(sb, bytes);
        sb.append(XmlUtil.closeTag(TAG_IMAGE));
        IOUtil.writeFile(filename, sb.toString());
    }

    public static void writeToFile(String filename, GeoLocationInfo bounds, String imageFileName) throws FileNotFoundException, IOException {
        StringBuffer sb = new StringBuffer();
        String nav = XmlUtil.attrs("ullat", "" + bounds.getMaxLat(), "lrlat", "" + bounds.getMinLat());
        nav = nav + XmlUtil.attrs("ullon", "" + bounds.getMinLon(), "lrlon", "" + bounds.getMaxLon());
        sb.append(XmlUtil.tag(TAG_IMAGE, nav + XmlUtil.attrs(ATTR_NAME, IOUtil.stripExtension(IOUtil.getFileTail(filename)), ATTR_URL, imageFileName)));
        IOUtil.writeFile(filename, sb.toString());
    }
}

