/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.imagery;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import visad.CommonUnit;
import visad.DateTime;
import visad.Real;

public class ImageInfo {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ULLAT = "ullat";
    public static final String ATTR_ULLON = "ullon";
    public static final String ATTR_ULALT = "ulalt";
    public static final String ATTR_LRLAT = "lrlat";
    public static final String ATTR_LRLON = "lrlon";
    public static final String ATTR_LRALT = "lralt";
    public static final String ATTR_URLAT = "urlat";
    public static final String ATTR_URLON = "urlon";
    public static final String ATTR_URALT = "uralt";
    public static final String ATTR_LLLAT = "lllat";
    public static final String ATTR_LLLON = "lllon";
    public static final String ATTR_LLALT = "llalt";
    private String url;
    private double ulLat = Double.NaN;
    private double ulLon = Double.NaN;
    private double ulAlt = Double.NaN;
    private double lrLat = Double.NaN;
    private double lrLon = Double.NaN;
    private double lrAlt = Double.NaN;
    private double urLat = Double.NaN;
    private double urLon = Double.NaN;
    private double urAlt = Double.NaN;
    private double llLat = Double.NaN;
    private double llLon = Double.NaN;
    private double llAlt = Double.NaN;
    private boolean isShape = false;
    private DateTime date;

    public ImageInfo() {
    }

    public ImageInfo(String url, Element node, Element parent, DateTime date) throws Exception {
        this.url = url;
        this.date = date;
        this.setPosition(parent);
        this.setPosition(node);
        if (this.defined(this.ulAlt) && !this.defined(this.urAlt)) {
            this.urAlt = this.ulAlt;
        } else if (!this.defined(this.ulAlt) && this.defined(this.urAlt)) {
            this.ulAlt = this.urAlt;
        }
        if (this.defined(this.llAlt) && !this.defined(this.lrAlt)) {
            this.lrAlt = this.llAlt;
        } else if (!this.defined(this.llAlt) && this.defined(this.lrAlt)) {
            this.llAlt = this.lrAlt;
        }
        if (this.hasAltitude()) {
            if (this.defined(this.ulLat) && !this.defined(this.llLat)) {
                this.llLat = this.ulLat;
            } else if (!this.defined(this.ulLat) && this.defined(this.llLat)) {
                this.ulLat = this.llLat;
            }
            if (this.defined(this.ulLon) && !this.defined(this.llLon)) {
                this.llLon = this.ulLon;
            } else if (!this.defined(this.ulLon) && this.defined(this.llLon)) {
                this.ulLon = this.llLon;
            }
            if (this.defined(this.urLat) && !this.defined(this.lrLat)) {
                this.lrLat = this.urLat;
            } else if (!this.defined(this.urLat) && this.defined(this.lrLat)) {
                this.urLat = this.lrLat;
            }
            if (this.defined(this.urLon) && !this.defined(this.lrLon)) {
                this.lrLon = this.urLon;
            } else if (!this.defined(this.urLon) && this.defined(this.lrLon)) {
                this.urLon = this.lrLon;
            }
        } else {
            if (this.defined(this.ulLat) && !this.defined(this.urLat)) {
                this.urLat = this.ulLat;
            } else if (!this.defined(this.ulLat) && this.defined(this.urLat)) {
                this.ulLat = this.urLat;
            }
            if (this.defined(this.llLat) && !this.defined(this.lrLat)) {
                this.lrLat = this.llLat;
            } else if (!this.defined(this.llLat) && this.defined(this.lrLat)) {
                this.llLat = this.lrLat;
            }
            if (this.defined(this.ulLon) && !this.defined(this.llLon)) {
                this.llLon = this.ulLon;
            } else if (!this.defined(this.ulLon) && this.defined(this.llLon)) {
                this.ulLon = this.llLon;
            }
            if (this.defined(this.urLon) && !this.defined(this.lrLon)) {
                this.lrLon = this.urLon;
            } else if (!this.defined(this.urLon) && this.defined(this.lrLon)) {
                this.urLon = this.lrLon;
            }
        }
        if (!this.allDefined()) {
            throw new IllegalArgumentException("Image " + XmlUtil.getAttribute((Node)node, ATTR_NAME, "") + " does not have proper coordinates defined\n" + this.toString());
        }
    }

    private boolean allDefined() {
        if (!(this.defined(this.ulLat) && this.defined(this.ulLon) && this.defined(this.llLat) && this.defined(this.llLon))) {
            return false;
        }
        return this.defined(this.urLat) && this.defined(this.urLon) && this.defined(this.lrLat) && this.defined(this.lrLon);
    }

    private double getAltMeters(Element node, String attr, double dflt) throws Exception {
        String s = XmlUtil.getAttribute((Node)node, attr, (String)null);
        if (s == null) {
            return dflt;
        }
        if ((s = s.trim()).indexOf("[") >= 0) {
            Real r = Util.toReal(s);
            return r.getValue(CommonUnit.meter);
        }
        return new Double(s);
    }

    private boolean defined(double v) {
        return v == v;
    }

    private void setPosition(Element node) throws Exception {
        if (node == null) {
            return;
        }
        this.ulLat = XmlUtil.getAttribute((Node)node, ATTR_ULLAT, this.ulLat);
        this.ulLon = XmlUtil.getAttribute((Node)node, ATTR_ULLON, this.ulLon);
        this.ulAlt = this.getAltMeters(node, ATTR_ULALT, this.ulAlt);
        this.urLat = XmlUtil.getAttribute((Node)node, ATTR_URLAT, this.urLat);
        this.urLon = XmlUtil.getAttribute((Node)node, ATTR_URLON, this.urLon);
        this.urAlt = this.getAltMeters(node, ATTR_URALT, this.urAlt);
        this.lrLat = XmlUtil.getAttribute((Node)node, ATTR_LRLAT, this.lrLat);
        this.lrLon = XmlUtil.getAttribute((Node)node, ATTR_LRLON, this.lrLon);
        this.lrAlt = this.getAltMeters(node, ATTR_LRALT, this.lrAlt);
        this.llLat = XmlUtil.getAttribute((Node)node, ATTR_LLLAT, this.llLat);
        this.llLon = XmlUtil.getAttribute((Node)node, ATTR_LLLON, this.llLon);
        this.llAlt = this.getAltMeters(node, ATTR_LLALT, this.llAlt);
    }

    public boolean isRectilinear() {
        if (!this.allDefined()) {
            return true;
        }
        return this.ulLat == this.urLat && this.llLat == this.lrLat && this.ulLon == this.llLon && this.urLon == this.lrLon;
    }

    public boolean hasAltitude() {
        return this.ulAlt == this.ulAlt;
    }

    public ImageInfo(String url, boolean isShape) {
        this(url, null, isShape);
    }

    public ImageInfo(String url, DateTime date, boolean isShape) {
        this.url = url;
        this.isShape = isShape;
        this.date = date;
    }

    public ImageInfo(String url, double ulLat, double ulLon, double lrLat, double lrLon) {
        this(url, null, ulLat, ulLon, lrLat, lrLon);
    }

    public ImageInfo(String url, DateTime date, double ulLat, double ulLon, double lrLat, double lrLon) {
        this.url = url;
        this.date = date;
        this.ulLat = ulLat;
        this.ulLon = ulLon;
        this.lrLat = lrLat;
        this.lrLon = lrLon;
    }

    public void setUrl(String value) {
        this.url = value;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrLat(double value) {
        this.urLat = value;
    }

    public double getUrLat() {
        return this.urLat;
    }

    public void setUrLon(double value) {
        this.urLon = value;
    }

    public double getUrLon() {
        return this.urLon;
    }

    public void setUrAlt(double value) {
        this.urAlt = value;
    }

    public double getUrAlt() {
        return this.urAlt;
    }

    public void setLrLat(double value) {
        this.lrLat = value;
    }

    public double getLrLat() {
        return this.lrLat;
    }

    public void setLrLon(double value) {
        this.lrLon = value;
    }

    public double getLrLon() {
        return this.lrLon;
    }

    public void setLrAlt(double value) {
        this.lrAlt = value;
    }

    public double getLrAlt() {
        return this.lrAlt;
    }

    public void setLlLat(double value) {
        this.llLat = value;
    }

    public double getLlLat() {
        return this.llLat;
    }

    public void setLlLon(double value) {
        this.llLon = value;
    }

    public double getLlLon() {
        return this.llLon;
    }

    public void setLlAlt(double value) {
        this.llAlt = value;
    }

    public double getLlAlt() {
        return this.llAlt;
    }

    public void setUlLat(double value) {
        this.ulLat = value;
    }

    public double getUlLat() {
        return this.ulLat;
    }

    public void setUlLon(double value) {
        this.ulLon = value;
    }

    public double getUlLon() {
        return this.ulLon;
    }

    public void setUlAlt(double value) {
        this.ulAlt = value;
    }

    public double getUlAlt() {
        return this.ulAlt;
    }

    public void setIsShape(boolean value) {
        this.isShape = value;
    }

    public boolean getIsShape() {
        return this.isShape;
    }

    public void setDate(DateTime value) {
        this.date = value;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String toString() {
        return "ImageInfo:ul: " + this.ulLat + "/" + this.ulLon + "/" + this.ulAlt + " " + "ur: " + this.urLat + "/" + this.urLon + "/" + this.urAlt + " " + "ll: " + this.llLat + "/" + this.llLon + "/" + this.llAlt + " " + "lr: " + this.lrLat + "/" + this.lrLon + "/" + this.lrAlt + " ";
    }
}

