/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.imagery;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaDirectoryList;
import edu.wisc.ssec.mcidas.AreaFileException;
import edu.wisc.ssec.mcidas.adde.AddeURL;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeMap;
import ucar.unidata.data.CompositeDataChoice;
import ucar.unidata.data.DataCategory;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.DataSourceDescriptor;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DerivedDataChoice;
import ucar.unidata.data.DirectDataChoice;
import ucar.unidata.data.imagery.AddeImageDescriptor;
import ucar.unidata.data.imagery.AddeImageInfo;
import ucar.unidata.data.imagery.BandInfo;
import ucar.unidata.data.imagery.ImageDataset;
import ucar.unidata.idv.DisplayControl;
import ucar.unidata.idv.control.ImageControl;
import ucar.unidata.idv.control.ImagePlanViewControl;
import ucar.unidata.util.CacheManager;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PollingInfo;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.unidata.util.WrapperException;
import ucar.visad.UtcDate;
import ucar.visad.Util;
import ucar.visad.data.AreaImageFlatField;
import visad.CommonUnit;
import visad.Data;
import visad.DateTime;
import visad.FunctionType;
import visad.MathType;
import visad.RealType;
import visad.Set;
import visad.VisADException;
import visad.data.DataRange;
import visad.data.mcidas.AreaAdapter;
import visad.meteorology.ImageSequence;
import visad.meteorology.ImageSequenceImpl;
import visad.meteorology.ImageSequenceManager;
import visad.meteorology.SingleBandedImage;
import visad.util.ThreadManager;

public abstract class ImageDataSource
extends DataSourceImpl {
    public static final String PROP_IMAGETYPE = "prop.imagetype";
    public static final String TYPE_RADAR = "radar";
    public static final String TYPE_SATELLITE = "satellite";
    public static final String PROP_BANDINFO = "bandinfo";
    private List twoDCategories;
    private List twoDTimeSeriesCategories;
    private List bandCategories;
    private List bandTimeSeriesCategories;
    protected List imageList;
    protected List imageTimes = new ArrayList();
    private CompositeDataChoice myCompositeDataChoice;
    private List myDataChoices = new ArrayList();
    private AreaDirectory[][] currentDirs;
    private Hashtable timeMap = new Hashtable();
    List descriptorsToUse;
    private boolean isZidv = false;
    private MathType rangeType = null;

    public ImageDataSource() {
    }

    public ImageDataSource(DataSourceDescriptor descriptor, String[] images, Hashtable properties) {
        super(descriptor, "Image data set", "Image data source", properties);
        if (!this.initDataFromPollingInfo()) {
            this.setImageList(ImageDataSource.makeImageDescriptors(images));
        }
        this.setDescription(this.getImageDataSourceName());
    }

    public ImageDataSource(DataSourceDescriptor descriptor, List images, Hashtable properties) {
        this(descriptor, StringUtil.listToStringArray(images), properties);
    }

    public ImageDataSource(DataSourceDescriptor descriptor, ImageDataset ids, Hashtable properties) {
        super(descriptor, ids.getDatasetName(), "Image data source", properties);
        this.setImageList(new ArrayList(ids.getImageDescriptors()));
        this.setDescription(this.getImageDataSourceName());
    }

    @Override
    public void reloadData(Object object, Hashtable properties) {
        if (object instanceof ImageDataset) {
            ImageDataset ids = (ImageDataset)object;
            this.setImageList(new ArrayList(ids.getImageDescriptors()));
        } else if (object instanceof List) {
            String[] images = StringUtil.listToStringArray((List)object);
            this.setImageList(ImageDataSource.makeImageDescriptors(images));
        } else {
            try {
                String[] images = (String[])object;
                this.setImageList(ImageDataSource.makeImageDescriptors(images));
            }
            catch (Exception exc) {
                return;
            }
        }
        this.setDescription(this.getImageDataSourceName());
        this.reloadProperties(properties);
        this.reloadData();
    }

    @Override
    public void setNewFiles(List files) {
        this.setImageList(ImageDataSource.makeImageDescriptors(StringUtil.listToStringArray(files)));
    }

    @Override
    public void updateState(Object newObject, Hashtable newProperties) {
        super.updateState(newObject, newProperties);
        if (newObject instanceof ImageDataset) {
            ImageDataset ids = (ImageDataset)newObject;
            this.setImageList(new ArrayList(ids.getImageDescriptors()));
            this.setDescription(this.getImageDataSourceName());
        } else if (newObject instanceof List) {
            this.setTmpPaths((List)newObject);
        } else if (newObject instanceof String) {
            this.setTmpPaths(Misc.newList(newObject));
        }
    }

    @Override
    public List getDataPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("_yyyy_MM_dd_HH_mm_ss_z");
        try {
            for (int i = 0; i < this.imageList.size(); ++i) {
                AddeImageDescriptor aid = this.getDescriptor(this.imageList.get(i));
                String path = aid.getSource();
                DateTime dttm = (DateTime)this.timeMap.get(path);
                paths.add(path);
            }
        }
        catch (Exception exc) {
            throw new WrapperException(exc);
        }
        return paths;
    }

    @Override
    public void initAfterUnpersistence() {
        super.initAfterUnpersistence();
        List tmp = this.getTmpPaths();
        if (tmp != null) {
            this.isZidv = true;
            this.imageList = new ArrayList();
            for (int i = 0; i < tmp.size(); ++i) {
                this.imageList.add(new AddeImageDescriptor(tmp.get(i).toString()));
            }
        }
        if (this.imageList != null && this.imageList.size() > 0 && this.imageList.get(0) instanceof String) {
            List tmpList = this.imageList;
            this.imageList = new ArrayList();
            for (int i = 0; i < tmpList.size(); ++i) {
                this.imageList.add(new AddeImageDescriptor(tmpList.get(i).toString()));
            }
        }
        this.initDataFromPollingInfo();
    }

    @Override
    public boolean canCacheDataToDisk() {
        return true;
    }

    @Override
    public boolean canSaveDataToLocalDisk() {
        return !this.isFileBased();
    }

    @Override
    protected List saveDataToLocalDisk(String prefix, Object loadId, boolean changeLinks) throws Exception {
        DataChoice dc;
        int dcIdx;
        int j;
        ArrayList<Hashtable> finalOnes;
        List dataChoices;
        DisplayControl dci;
        int i;
        ArrayList<AddeImageDescriptor> descriptorsToSave = new ArrayList<AddeImageDescriptor>();
        List displays = this.getIdv().getDisplayControls();
        for (i = 0; i < displays.size(); ++i) {
            dci = (DisplayControl)displays.get(i);
            if (!(dci instanceof ImagePlanViewControl) || (dataChoices = dci.getDataChoices()) == null) continue;
            finalOnes = new ArrayList<Hashtable>();
            for (j = 0; j < dataChoices.size(); ++j) {
                ((DataChoice)dataChoices.get(j)).getFinalDataChoices(finalOnes);
            }
            for (dcIdx = 0; dcIdx < finalOnes.size(); ++dcIdx) {
                DirectDataChoice ddc;
                List dList;
                dc = (DataChoice)finalOnes.get(dcIdx);
                if (!(dc instanceof DirectDataChoice) || (dList = (List)(ddc = (DirectDataChoice)dc).getProperty("descriptorsToSave")) == null) continue;
                for (AddeImageDescriptor descriptor : dList) {
                    descriptorsToSave.add(descriptor);
                }
            }
        }
        for (i = 0; i < displays.size(); ++i) {
            dci = (DisplayControl)displays.get(i);
            if (!(dci instanceof ImageControl) || (dataChoices = dci.getDataChoices()) == null) continue;
            finalOnes = new ArrayList();
            for (j = 0; j < dataChoices.size(); ++j) {
                dc = (DataChoice)dataChoices.get(j);
                if (!(dc instanceof DerivedDataChoice)) continue;
                Hashtable hdc = ((DerivedDataChoice)dataChoices.get(j)).getUserSelectedChoices();
                finalOnes.add(hdc);
            }
            for (dcIdx = 0; dcIdx < finalOnes.size(); ++dcIdx) {
                Hashtable hd = (Hashtable)finalOnes.get(dcIdx);
                ArrayList aList = new ArrayList(hd.values());
                for (int ii = 0; ii < aList.size(); ++ii) {
                    DirectDataChoice ddc;
                    List dList;
                    DataChoice dc2 = (DataChoice)aList.get(ii);
                    if (!(dc2 instanceof DirectDataChoice) || (dList = (List)(ddc = (DirectDataChoice)dc2).getProperty("descriptorsToSave")) == null) continue;
                    for (AddeImageDescriptor descriptor : dList) {
                        descriptorsToSave.add(descriptor);
                    }
                }
            }
        }
        ArrayList<String> urls = new ArrayList<String>();
        ArrayList<String> suffixes = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("_yyyy_MM_dd_HH_mm_ss_z");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        for (int i2 = 0; i2 < descriptorsToSave.size(); ++i2) {
            AddeImageDescriptor aid = this.getDescriptor(descriptorsToSave.get(i2));
            String url = aid.getSource();
            DateTime dttm = (DateTime)this.timeMap.get(url);
            if (dttm != null) {
                suffixes.add(sdf.format(Util.makeDate(dttm)) + ".area");
            } else {
                suffixes.add(i2 + ".area");
            }
            urls.add(url);
        }
        List newFiles = IOUtil.writeTo(urls, prefix, suffixes, loadId);
        if (newFiles == null) {
            return null;
        }
        if (changeLinks) {
            this.imageList = newFiles;
        }
        return newFiles;
    }

    protected boolean initDataFromPollingInfo() {
        PollingInfo pollingInfo = this.getPollingInfo();
        if (!pollingInfo.getForFiles() || !pollingInfo.doILookForNewFiles()) {
            return false;
        }
        this.imageList = new ArrayList();
        List files = pollingInfo.getFiles();
        for (int i = 0; i < files.size(); ++i) {
            this.imageList.add(new AddeImageDescriptor(files.get(i).toString()));
        }
        return true;
    }

    @Override
    protected void propertiesChanged() {
        List newSources;
        PollingInfo pollingInfo = this.getPollingInfo();
        if (pollingInfo.doILookForNewFiles() && (newSources = pollingInfo.getFiles()).size() != this.imageList.size()) {
            this.initDataFromPollingInfo();
            this.dataChoices = null;
            this.notifyDataChange();
        }
        super.propertiesChanged();
    }

    public static ImageDataset makeImageDataset(String[] addeURLs) {
        AddeImageDescriptor[] aids = new AddeImageDescriptor[addeURLs.length];
        for (int i = 0; i < addeURLs.length; ++i) {
            aids[i] = new AddeImageDescriptor(addeURLs[i]);
        }
        return new ImageDataset("Image data set", Arrays.asList(aids));
    }

    public static List makeImageDescriptors(String[] addeURLs) {
        ArrayList<AddeImageDescriptor> descriptors = new ArrayList<AddeImageDescriptor>();
        for (int i = 0; i < addeURLs.length; ++i) {
            descriptors.add(new AddeImageDescriptor(addeURLs[i]));
        }
        return descriptors;
    }

    @Override
    protected List getLocationsForPolling() {
        if (!this.isFileBased()) {
            return null;
        }
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < this.imageList.size(); ++i) {
            AddeImageDescriptor aid = this.getDescriptor(this.imageList.get(i));
            files.add(aid.getSource());
        }
        return files;
    }

    protected boolean isFileBased() {
        if (this.imageList == null || this.imageList.size() == 0) {
            return false;
        }
        AddeImageDescriptor aid = this.getDescriptor(this.imageList.get(0));
        return aid.isFromFile();
    }

    public AddeImageDescriptor getDescriptor(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DataChoice) {
            object = ((DataChoice)object).getId();
        }
        if (object instanceof ImageDataInfo) {
            DataChoice dc;
            Object tmpObject;
            int index = ((ImageDataInfo)object).getIndex();
            if (index < this.myDataChoices.size() && (tmpObject = (dc = (DataChoice)this.myDataChoices.get(index)).getId()) instanceof ImageDataInfo) {
                return ((ImageDataInfo)tmpObject).getAid();
            }
            return null;
        }
        if (object instanceof AddeImageDescriptor) {
            return (AddeImageDescriptor)object;
        }
        return new AddeImageDescriptor(object.toString());
    }

    @Override
    public List getCompositeDataChoices(CompositeDataChoice compositeDataChoice, List dataChoices) {
        this.getDataChoices();
        return !this.hasBandInfo(compositeDataChoice) ? this.myDataChoices : dataChoices;
    }

    public abstract String getImageDataSourceName();

    public List getImageList() {
        return this.imageList;
    }

    public List getDescriptorsToUse() {
        return this.descriptorsToUse;
    }

    public void setImageList(List l) {
        this.imageList = l;
    }

    @Override
    public List doMakeDateTimes() {
        this.imageTimes = new ArrayList();
        for (Object object : this.imageList) {
            AddeImageDescriptor aid = this.getDescriptor(object);
            if (!aid.getIsRelative()) {
                DateTime imageTime = aid.getImageTime();
                if (imageTime == null) continue;
                this.imageTimes.add(imageTime);
                continue;
            }
            this.imageTimes.add(this.getRelativeTimeObject(aid));
        }
        return this.imageTimes;
    }

    private void makeCategories() {
        this.twoDTimeSeriesCategories = DataCategory.parseCategories("IMAGE-2D-TIME;", false);
        this.twoDCategories = DataCategory.parseCategories("IMAGE-2D;", false);
        this.bandCategories = DataCategory.parseCategories("IMAGE-BAND;", false);
        this.bandTimeSeriesCategories = DataCategory.parseCategories("IMAGE-BAND-TIME;", false);
    }

    public List getTwoDCategories() {
        if (this.twoDCategories == null) {
            this.makeCategories();
        }
        return this.twoDCategories;
    }

    public List getTwoDTimeSeriesCategories() {
        if (this.twoDCategories == null) {
            this.makeCategories();
        }
        return this.twoDTimeSeriesCategories;
    }

    public List getBandCategories() {
        if (this.bandCategories == null) {
            this.makeCategories();
        }
        return this.bandCategories;
    }

    public List getBandTimeSeriesCategories() {
        if (this.bandTimeSeriesCategories == null) {
            this.makeCategories();
        }
        return this.bandTimeSeriesCategories;
    }

    @Override
    public void doMakeDataChoices() {
        String type = this.getProperty(PROP_IMAGETYPE, TYPE_SATELLITE);
        List bandInfos = (List)this.getProperty(PROP_BANDINFO, (Object)null);
        Hashtable props = Misc.newHashtable("prop.icon", type.equals(TYPE_RADAR) ? "/auxdata/ui/icons/Radar.gif" : "/auxdata/ui/icons/Satellite.gif");
        List categories = this.imageList.size() > 1 ? this.getTwoDTimeSeriesCategories() : this.getTwoDCategories();
        this.myCompositeDataChoice = new CompositeDataChoice((DataSource)this, (Object)this.imageList, this.getName(), this.getDataName(), categories, props);
        this.myCompositeDataChoice.setUseDataSourceToFindTimes(true);
        this.doMakeDataChoices(this.myCompositeDataChoice);
        if (bandInfos != null && !bandInfos.isEmpty()) {
            List biCategories = this.imageList.size() > 1 ? this.getBandTimeSeriesCategories() : this.getBandCategories();
            for (BandInfo bi : bandInfos) {
                String name = this.makeBandParam(bi);
                String catName = bi.getBandDescription();
                List biSubCategories = Misc.newList(new DataCategory(catName, true));
                biSubCategories.addAll(biCategories);
                List l = bi.getCalibrationUnits();
                if (l.isEmpty() || l.size() == 1) {
                    DirectDataChoice choice = new DirectDataChoice((DataSource)this, (Object)bi, name, bi.getBandDescription(), biCategories, props);
                    this.addDataChoice(choice);
                    continue;
                }
                for (int j = 0; j < l.size(); ++j) {
                    Object o = l.get(j);
                    BandInfo bi2 = new BandInfo(bi);
                    String calUnit = o.toString();
                    String calibration = TwoFacedObject.getIdString(o);
                    bi2.setPreferredUnit(calibration);
                    name = this.makeBandParam(bi2);
                    DirectDataChoice subChoice = new DirectDataChoice((DataSource)this, (Object)bi2, name, calUnit, biSubCategories, props);
                    this.addDataChoice(subChoice);
                }
            }
        } else {
            this.addDataChoice(this.myCompositeDataChoice);
        }
    }

    private String makeBandParam(BandInfo bi) {
        StringBuffer buf = new StringBuffer();
        buf.append(bi.getSensor());
        buf.append("_Band");
        buf.append(bi.getBandNumber());
        buf.append("_");
        buf.append(bi.getPreferredUnit());
        return buf.toString();
    }

    private void doMakeDataChoices(CompositeDataChoice composite) {
        int cnt = 0;
        this.imageTimes = new ArrayList();
        ArrayList<DirectDataChoice> timeChoices = new ArrayList<DirectDataChoice>();
        this.myDataChoices = new ArrayList();
        String type = this.getProperty(PROP_IMAGETYPE, TYPE_SATELLITE);
        Hashtable props = Misc.newHashtable("prop.icon", type.equals(TYPE_RADAR) ? "/auxdata/ui/icons/clock.gif" : "/auxdata/ui/icons/clock.gif");
        for (Object object : this.imageList) {
            AddeImageDescriptor aid = this.getDescriptor(object);
            String name = aid.toString();
            DataSelection timeSelect = null;
            if (!aid.getIsRelative()) {
                DateTime imageTime = aid.getImageTime();
                if (imageTime != null) {
                    this.imageTimes.add(imageTime);
                    timeSelect = new DataSelection(Misc.newList(new Integer(cnt)));
                }
            } else {
                this.imageTimes.add(this.getRelativeTimeObject(aid));
            }
            timeSelect = null;
            DirectDataChoice choice = new DirectDataChoice(this, new ImageDataInfo(cnt, aid), composite.getName(), name, this.getTwoDCategories(), timeSelect, props);
            this.myDataChoices.add(choice);
            ++cnt;
            timeChoices.add(choice);
        }
        composite.replaceDataChoices(this.sortChoices(timeChoices));
    }

    @Override
    protected Data getDataInner(DataChoice dataChoice, DataCategory category, DataSelection dataSelection, Hashtable requestProperties) throws VisADException, RemoteException {
        if (dataChoice instanceof CompositeDataChoice) {
            return this.makeImageSequence(this.myCompositeDataChoice, dataSelection);
        }
        if (this.hasBandInfo(dataChoice)) {
            return this.makeImageSequence(dataChoice, dataSelection);
        }
        return this.makeImage(dataChoice, dataSelection);
    }

    @Override
    public List getAllDateTimes(DataChoice dataChoice) {
        if (dataChoice instanceof CompositeDataChoice || this.hasBandInfo(dataChoice)) {
            return super.getAllDateTimes(dataChoice);
        }
        Object dttmObject = this.getDateTime(dataChoice);
        if (dttmObject != null) {
            return Misc.newList(dttmObject);
        }
        return new ArrayList();
    }

    @Override
    public List getSelectedDateTimes(DataChoice dataChoice) {
        if (dataChoice instanceof CompositeDataChoice || this.hasBandInfo(dataChoice)) {
            return super.getSelectedDateTimes();
        }
        Object dttmObject = this.getDateTime(dataChoice);
        if (dttmObject != null) {
            return Misc.newList(dttmObject);
        }
        return new ArrayList();
    }

    private Object getDateTime(DataChoice dataChoice) {
        Object id = dataChoice.getId();
        AddeImageDescriptor aid = this.getDescriptor(id);
        if (aid.getIsRelative()) {
            return this.getRelativeTimeObject(aid);
        }
        return aid.getImageTime();
    }

    private Object getRelativeTimeObject(AddeImageDescriptor aid) {
        return new TwoFacedObject((Object)aid.toString(), new Integer(aid.getRelativeIndex()));
    }

    protected final SingleBandedImage makeImage(DataChoice dataChoice, DataSelection subset) throws VisADException, RemoteException {
        List times;
        AddeImageDescriptor aid = this.getDescriptor(dataChoice.getId());
        if (aid == null) {
            return null;
        }
        DateTime dttm = aid.getImageTime();
        if (subset != null && dttm != null && (times = this.getTimesFromDataSelection(subset, dataChoice)) != null && times.indexOf(dttm) == -1) {
            return null;
        }
        return this.makeImage(aid, null, false, "");
    }

    protected SingleBandedImage makeImage(AddeImageDescriptor aid, MathType rangeType, boolean fromSequence, String readLabel) throws VisADException, RemoteException {
        if (aid == null) {
            return null;
        }
        String source = aid.getSource();
        SingleBandedImage result = (SingleBandedImage)this.getCache(source);
        if (result != null) {
            return result;
        }
        try {
            AddeImageInfo aii = aid.getImageInfo();
            AreaDirectory areaDir = null;
            try {
                if (aii != null) {
                    if (this.currentDirs != null) {
                        int pos = Math.abs(aii.getDatasetPosition());
                        int band = 0;
                        String bandString = aii.getBand();
                        if (bandString != null) {
                            if (!bandString.equals("ALL")) {
                                band = new Integer(bandString);
                            }
                        }
                        band = 0;
                        areaDir = this.currentDirs[this.currentDirs.length - pos - 1][band];
                    } else if (aii.getStartDate() != null || aii.getEndDate() != null) {
                        areaDir = aid.getDirectory();
                    }
                }
            }
            catch (Exception exc) {
                LogUtil.printMessage("error looking up area dir");
                exc.printStackTrace();
                return null;
            }
            if (areaDir == null) {
                areaDir = aid.getDirectory();
            }
            if (!this.getCacheDataToDisk()) {
                areaDir = null;
            }
            if (!fromSequence || aid.getIsRelative() && this.currentDirs == null) {
                areaDir = null;
            }
            if (areaDir != null) {
                int hash;
                int n = hash = aii != null ? aii.makeAddeUrl().hashCode() : areaDir.hashCode();
                result = rangeType == null ? AreaImageFlatField.createImmediate(aid, readLabel) : AreaImageFlatField.create(aid, areaDir, rangeType, readLabel);
            } else {
                AreaAdapter aa = new AreaAdapter(aid.getSource(), false);
                this.timeMap.put(aid.getSource(), aa.getImageStartTime());
                result = aa.getImage();
                aa = null;
            }
            this.putCache(source, result);
            return result;
        }
        catch (IOException ioe) {
            throw new VisADException("Creating AreaAdapter - " + ioe);
        }
    }

    @Override
    public void reloadData() {
        this.currentDirs = null;
        super.reloadData();
    }

    @Override
    public boolean getCacheDataToDisk() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ImageSequence makeImageSequence(DataChoice dataChoice, DataSelection subset) throws VisADException, RemoteException {
        try {
            this.descriptorsToUse = new ArrayList();
            if (this.hasBandInfo(dataChoice)) {
                this.descriptorsToUse = this.getDescriptors(dataChoice, subset);
            } else {
                List<DataChoice> choices = dataChoice instanceof CompositeDataChoice ? this.getChoicesFromSubset((CompositeDataChoice)dataChoice, subset) : Arrays.asList(dataChoice);
                for (DataChoice subChoice : choices) {
                    List times;
                    AddeImageDescriptor aid = this.getDescriptor(subChoice.getId());
                    if (aid == null) continue;
                    DateTime dttm = aid.getImageTime();
                    if (subset != null && dttm != null && (times = this.getTimesFromDataSelection(subset, dataChoice)) != null && times.indexOf(dttm) == -1) continue;
                    this.descriptorsToUse.add(aid);
                }
            }
            if (this.descriptorsToUse == null || this.descriptorsToUse.size() == 0) {
                return null;
            }
            AddeURL biggestPosition = null;
            int pos = 0;
            boolean anyRelative = false;
            String biggestSource = null;
            for (AddeImageDescriptor aid : this.descriptorsToUse) {
                AddeImageInfo aii;
                if (aid.getIsRelative()) {
                    anyRelative = true;
                }
                if ((aii = aid.getImageInfo()) == null) break;
                if (aii.getStartDate() != null || aii.getEndDate() != null) {
                    biggestPosition = null;
                    break;
                }
                if (biggestPosition != null && Math.abs(aii.getDatasetPosition()) <= pos) continue;
                pos = Math.abs(aii.getDatasetPosition());
                biggestPosition = aii;
                biggestSource = aid.getSource();
            }
            if (this.getCacheDataToDisk() && anyRelative && biggestPosition != null) {
                biggestPosition.setRequestType("imagedirectory");
                AreaDirectoryList adl = new AreaDirectoryList(((AddeImageInfo)biggestPosition).makeAddeUrl());
                biggestPosition.setRequestType("imagedata");
                this.currentDirs = adl.getSortedDirs();
            } else {
                this.currentDirs = null;
            }
            ThreadManager threadManager = new ThreadManager("image data reading");
            ImageSequenceManager sequenceManager = new ImageSequenceManager();
            int cnt = 1;
            DataChoice parent = dataChoice.getParent();
            ArrayList<SingleBandedImage> images = new ArrayList<SingleBandedImage>();
            this.rangeType = null;
            for (Object aid : this.descriptorsToUse) {
                int idx;
                if (this.currentDirs != null && (idx = Math.abs(((AddeImageDescriptor)aid).getImageInfo().getDatasetPosition())) >= this.currentDirs.length) continue;
                String label = "";
                if (parent != null) {
                    label = label + parent.toString() + " ";
                } else {
                    DataCategory displayCategory = dataChoice.getDisplayCategory();
                    if (displayCategory != null) {
                        label = label + displayCategory + " ";
                    }
                }
                label = label + dataChoice.toString();
                String readLabel = "Time: " + cnt++ + "/" + this.descriptorsToUse.size() + "  " + label;
                if (this.rangeType == null) {
                    try {
                        SingleBandedImage image = this.makeImage((AddeImageDescriptor)aid, this.rangeType, true, readLabel);
                        if (image == null) continue;
                        this.rangeType = ((FunctionType)image.getType()).getRange();
                        ArrayList<SingleBandedImage> arrayList = images;
                        synchronized (arrayList) {
                            images.add(image);
                            continue;
                        }
                    }
                    catch (VisADException ve) {
                        String realError = ve.getMessage();
                        realError = realError.substring(realError.lastIndexOf(":") + 1);
                        LogUtil.printMessage(realError);
                        continue;
                    }
                }
                threadManager.addRunnable(new ThreadManager.MyRunnable((AddeImageDescriptor)aid, readLabel, images){
                    final /* synthetic */ AddeImageDescriptor val$aid;
                    final /* synthetic */ String val$readLabel;
                    final /* synthetic */ List val$images;
                    {
                        this.val$aid = addeImageDescriptor;
                        this.val$readLabel = string;
                        this.val$images = list;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() throws Exception {
                        block5: {
                            try {
                                SingleBandedImage image = ImageDataSource.this.makeImage(this.val$aid, ImageDataSource.this.rangeType, true, this.val$readLabel);
                                if (image == null) break block5;
                                List list = this.val$images;
                                synchronized (list) {
                                    this.val$images.add(image);
                                }
                            }
                            catch (VisADException ve) {
                                String realError = ve.getMessage();
                                realError = realError.substring(realError.lastIndexOf(":") + 1);
                                LogUtil.printMessage(realError);
                            }
                        }
                    }
                });
            }
            try {
                threadManager.runInParallel(this.getDataContext().getIdv().getMaxDataThreadCount());
            }
            catch (VisADException ve) {
                LogUtil.printMessage(ve.toString());
            }
            if (images.isEmpty()) {
                return null;
            }
            TreeMap<DateTime, SingleBandedImage> imageMap = new TreeMap<DateTime, SingleBandedImage>();
            for (SingleBandedImage image : images) {
                imageMap.put(image.getStartTime(), image);
            }
            ArrayList sortedImages = new ArrayList(imageMap.values());
            if (sortedImages.size() > 0 && sortedImages.get(0) instanceof AreaImageFlatField) {
                AreaImageFlatField aiff;
                DataRange[] sampleRanges = null;
                Set domainSet = null;
                for (SingleBandedImage sbi : sortedImages) {
                    aiff = (AreaImageFlatField)sbi;
                    sampleRanges = aiff.getRanges(true);
                    if (domainSet == null) {
                        domainSet = aiff.getDomainSet();
                    }
                    if (sampleRanges != null && sampleRanges.length > 0) {
                        for (int rangeIdx = 0; rangeIdx < sampleRanges.length; ++rangeIdx) {
                            DataRange r = sampleRanges[rangeIdx];
                            if (!Double.isInfinite(r.getMin()) && !Double.isInfinite(r.getMax())) continue;
                            sampleRanges = null;
                            break;
                        }
                    }
                    if (sampleRanges == null) continue;
                    break;
                }
                if (sampleRanges != null) {
                    for (SingleBandedImage sbi : sortedImages) {
                        aiff = (AreaImageFlatField)sbi;
                        aiff.setSampleRanges(sampleRanges);
                        aiff.setDomainIfNeeded(domainSet);
                    }
                }
            }
            SingleBandedImage[] imageArray = sortedImages.toArray(new SingleBandedImage[sortedImages.size()]);
            FunctionType imageFunction = (FunctionType)imageArray[0].getType();
            FunctionType ftype = new FunctionType(RealType.Time, imageFunction);
            return new ImageSequenceImpl(ftype, imageArray);
        }
        catch (Exception exc) {
            throw new WrapperException(exc);
        }
    }

    protected List getDescriptors(DataChoice dataChoice, DataSelection subset) {
        boolean usingTimeDriver;
        List times = this.getTimesFromDataSelection(subset, dataChoice);
        boolean bl = usingTimeDriver = subset != null && subset.getTimeDriverTimes() != null;
        if (usingTimeDriver) {
            times = subset.getTimeDriverTimes();
        }
        if (times == null || times.isEmpty()) {
            times = this.imageTimes;
        }
        ArrayList<AddeImageDescriptor> descriptors = new ArrayList<AddeImageDescriptor>();
        if (usingTimeDriver) {
            if (this.imageList.isEmpty()) {
                return this.imageList;
            }
            AddeImageDescriptor aid = this.getDescriptor(this.imageList.get(0));
            if (aid.getImageInfo() != null) {
                try {
                    AddeImageInfo aii = (AddeImageInfo)aid.getImageInfo().clone();
                    Collections.sort(times);
                    DateTime start = (DateTime)times.get(0);
                    DateTime end = (DateTime)times.get(times.size() - 1);
                    String startDay = UtcDate.getYMD(start);
                    String endDay = UtcDate.getYMD(end);
                    List<Object> days = new ArrayList<String>();
                    if (!startDay.equals(endDay)) {
                        days = this.getUniqueDayStrings(times);
                    } else {
                        days.add(startDay);
                    }
                    HashMap<DateTime, AreaDirectory> dateDir = new HashMap<DateTime, AreaDirectory>();
                    ArrayList<DateTime> dirTimes = new ArrayList<DateTime>();
                    for (String string : days) {
                        AreaDirectoryList ad;
                        startDay = string + " 00:00:00";
                        endDay = string + " 23:59:59";
                        start = DateTime.createDateTime(startDay, "yyyy-MM-dd HH:mm:ss");
                        end = UtcDate.createDateTime(endDay, "yyyy-MM-dd HH:mm:ss");
                        aii.setStartDate(new Date((long)(start.getValue(CommonUnit.secondsSinceTheEpoch) * 1000.0)));
                        aii.setEndDate(new Date((long)(end.getValue(CommonUnit.secondsSinceTheEpoch) * 1000.0)));
                        aii.setRequestType("imagedirectory");
                        try {
                            ad = new AreaDirectoryList(aii.getURLString());
                        }
                        catch (AreaFileException afe) {
                            continue;
                        }
                        AreaDirectory[][] dirs = ad.getSortedDirs();
                        for (int d = 0; d < dirs.length; ++d) {
                            AreaDirectory dir = dirs[d][0];
                            DateTime dirTime = new DateTime(dir.getNominalTime());
                            dateDir.put(dirTime, dir);
                            dirTimes.add(dirTime);
                        }
                    }
                    List<DateTime> matchedTimes = this.selectTimesFromList(subset, dirTimes, times);
                    for (DateTime dirTime : matchedTimes) {
                        AreaDirectory dir = (AreaDirectory)dateDir.get(dirTime);
                        if (dir == null) continue;
                        AddeImageInfo newaii = (AddeImageInfo)aid.getImageInfo().clone();
                        newaii.setRequestType("imagedata");
                        newaii.setStartDate(dir.getNominalTime());
                        newaii.setEndDate(dir.getNominalTime());
                        this.setBandInfo(dataChoice, newaii);
                        AddeImageDescriptor newaid = new AddeImageDescriptor(dir, newaii.getURLString(), newaii);
                        newaid.setIsRelative(false);
                        descriptors.add(newaid);
                    }
                }
                catch (CloneNotSupportedException cnse) {
                    System.out.println("unable to clone aii");
                }
                catch (VisADException vader) {
                    System.out.println("unable to get date values");
                }
                catch (AreaFileException afe) {
                    System.out.println("unable to make request");
                }
                catch (Exception excp) {
                    System.out.println("Got an exception: " + excp.getMessage());
                }
                this.imageList = descriptors;
                return descriptors;
            }
            if (this.imageList != null) {
                return this.imageList;
            }
        }
        BandInfo bandInfo = (BandInfo)dataChoice.getId();
        int bnum = bandInfo.getBandNumber();
        for (Object time : times) {
            AddeImageDescriptor found = null;
            Iterator iter2 = this.imageList.iterator();
            while (iter2.hasNext()) {
                AddeImageDescriptor aid = this.getDescriptor(iter2.next());
                if (aid == null) continue;
                if (aid.getIsRelative()) {
                    Object id = time instanceof TwoFacedObject ? ((TwoFacedObject)time).getId() : time;
                    if (!(id instanceof Integer) || ((Integer)id).intValue() != aid.getRelativeIndex()) continue;
                    found = aid;
                    break;
                }
                int bbnum = aid.getDirectory().getBands()[0];
                if (this.isZidv) {
                    if (!aid.getImageTime().equals(time) || bbnum != bnum) continue;
                    found = aid;
                    break;
                }
                if (!aid.getImageTime().equals(time)) continue;
                found = aid;
                break;
            }
            if (found == null) continue;
            try {
                AddeImageDescriptor desc = new AddeImageDescriptor(found);
                if (desc.getImageInfo() != null) {
                    AddeImageInfo aii = (AddeImageInfo)desc.getImageInfo().clone();
                    this.setBandInfo(dataChoice, aii);
                    desc.setImageInfo(aii);
                    desc.setSource(aii.getURLString());
                }
                descriptors.add(desc);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        return descriptors;
    }

    private List<String> getUniqueDayStrings(List<DateTime> times) {
        ArrayList<String> days = new ArrayList<String>();
        for (DateTime time : times) {
            String dateString = UtcDate.getYMD(time);
            if (days.contains(dateString)) continue;
            days.add(dateString);
        }
        return days;
    }

    private void setBandInfo(DataChoice dataChoice, AddeImageInfo aii) {
        BandInfo bi = (BandInfo)dataChoice.getId();
        List bandInfos = (List)this.getProperty(PROP_BANDINFO, (Object)null);
        boolean hasBand = true;
        if (bandInfos != null) {
            hasBand = bandInfos.contains(bi);
            if (!hasBand) {
                // empty if block
            }
            if (!hasBand && bandInfos.size() > 0) {
                bi = (BandInfo)bandInfos.get(0);
            }
        }
        aii.setBand("" + bi.getBandNumber());
        aii.setUnit(bi.getPreferredUnit());
    }

    private List getChoicesFromSubset(CompositeDataChoice choice, DataSelection subset) {
        List choices = choice.getDataChoices();
        if (subset == null) {
            return choices;
        }
        List times = subset.getTimes();
        if (times == null) {
            return choices;
        }
        times = TwoFacedObject.getIdList(times);
        ArrayList subChoices = new ArrayList();
        Object firstTime = times.get(0);
        if (firstTime instanceof Integer) {
            Iterator iter = times.iterator();
            while (iter.hasNext()) {
                subChoices.add(choices.get((Integer)iter.next()));
            }
        } else {
            subChoices.addAll(choices);
        }
        return subChoices;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ImageDataSource that = (ImageDataSource)o;
        return this == that || Misc.equals(this.imageList, that.imageList);
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        return hashCode ^= this.imageList.hashCode();
    }

    public String getDataName() {
        return "Image Sequence";
    }

    @Override
    public String getFullDescription() {
        StringBuffer buf = new StringBuffer(super.getFullDescription());
        buf.append("<p>");
        List images = this.getImageList();
        if (images != null) {
            for (int i = 0; i < images.size(); ++i) {
                Object o = images.get(i);
                if (o instanceof AddeImageDescriptor) {
                    AreaDirectory ad = ((AddeImageDescriptor)o).getDirectory();
                    if (i == 0) {
                        buf.append("<table border=\"1\" width=\"100%\"><tr valign=\"bottom\"><td><b>Location</b></td><td><b>Date</b></td><td><b>Size (Lines X Elements) </b></td><td><b>Band</b></td></tr>");
                    }
                    buf.append("<tr valign=\"top\"><td width=\"300\">");
                    String path = ((AddeImageDescriptor)o).getSource();
                    if (path.length() > 50) {
                        String tmp = path;
                        path = "";
                        while (tmp.length() > 50) {
                            if (path.length() > 0) {
                                path = path + "<br>";
                            }
                            path = path + tmp.substring(0, 49);
                            tmp = tmp.substring(49);
                        }
                        path = path + "<br>" + tmp;
                    }
                    buf.append(path);
                    buf.append("</td>");
                    buf.append("<td width=\"15%\">");
                    buf.append("" + ad.getNominalTime());
                    buf.append("</td>");
                    buf.append("<td width=\"15%\">");
                    buf.append(ad.getLines());
                    buf.append(" X ");
                    buf.append(ad.getElements());
                    buf.append("</td>");
                    buf.append("<td width=\"15%\">");
                    buf.append("Band ");
                    buf.append(ad.getBands()[0]);
                    buf.append("</td></tr>");
                    continue;
                }
                if (i == 0) {
                    buf.append("<table><tr><td><b>Location</b></td></tr>");
                }
                buf.append("<tr valign=\"top\"><td>");
                buf.append(o.toString());
                buf.append("</td></tr>");
            }
            buf.append("</table>");
        }
        return buf.toString();
    }

    @Override
    public void newFileFromPolling(File file) {
        this.initDataFromPollingInfo();
        this.dataChoices = null;
        this.getDataChoices();
        this.getDataContext().dataSourceChanged(this);
        Hashtable cache = CacheManager.findOrCreate(this.dataCacheKey);
        this.flushCache();
        CompositeDataChoice cdc = this.myCompositeDataChoice;
        cdc.removeAllDataChoices();
        this.doMakeDataChoices(cdc);
        for (int i = 0; i < this.imageList.size(); ++i) {
            AddeImageDescriptor aid = this.getDescriptor(this.imageList.get(i));
            String source = aid.getSource();
            Object cachedData = cache.get(source);
            if (cachedData == null) continue;
            this.putCache(source, cachedData);
        }
        this.notifyDataChange();
    }

    private List sortChoices(List choices) {
        Object[] choicesArray = choices.toArray();
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                AddeImageDescriptor aid1 = ImageDataSource.this.getDescriptor(o1);
                AddeImageDescriptor aid2 = ImageDataSource.this.getDescriptor(o2);
                if (aid1 == null || aid2 == null) {
                    return -1;
                }
                if (aid1.getIsRelative()) {
                    if (aid1.getRelativeIndex() < aid2.getRelativeIndex()) {
                        return 0;
                    }
                    if (aid1.getRelativeIndex() == aid2.getRelativeIndex()) {
                        return 1;
                    }
                    return -1;
                }
                return aid1.getImageTime().compareTo(aid2.getImageTime());
            }
        };
        Arrays.sort(choicesArray, comp);
        return new ArrayList<Object>(Arrays.asList(choicesArray));
    }

    private boolean hasBandInfo(DataChoice dataChoice) {
        return dataChoice.getId() instanceof BandInfo;
    }

    @Override
    public void doRemove() {
        super.doRemove();
        this.myDataChoices = null;
        this.myCompositeDataChoice = null;
        this.imageTimes = null;
        this.currentDirs = null;
    }

    public static class ImageDataInfo {
        private int index;
        private AddeImageDescriptor aid;

        public ImageDataInfo() {
        }

        public ImageDataInfo(int index, AddeImageDescriptor aid) {
            this.index = index;
            this.aid = aid;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int v) {
            this.index = v;
        }

        public AddeImageDescriptor getAid() {
            return this.aid;
        }

        public void setAid(AddeImageDescriptor v) {
            this.aid = v;
        }

        public String toString() {
            return "index:" + this.index + " " + this.aid;
        }
    }
}

