/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.imagery;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;

public class ImageDataSelectionInfo {
    public double locationLat;
    public double locationLon;
    public int locationLine;
    public int locationElem;
    public String host;
    public String requestType;
    public String band;
    public String navType;
    public String unit;
    public String group;
    public String descriptor;
    public int spacing;
    public String placeValue;
    public String locateValue;
    public String locateKey;
    public int line;
    public int elem;
    public int lines;
    public int elememts;
    public int lineMag;
    public int elementMag;
    public int trace;
    public boolean debug;
    public String compress;
    public String user;
    public int port;
    public int project;
    public String version;
    List<String> leftovers = new ArrayList<String>();

    public ImageDataSelectionInfo() {
    }

    public ImageDataSelectionInfo(String sourceURL) {
        URL url = null;
        try {
            url = new URL(sourceURL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.setHost(url.getHost());
        this.setRequestType(url.getPath().substring(1).toLowerCase());
        String query = url.getQuery();
        List<String> tokens = StringUtil.split(query, "&", true, true);
        for (String token : tokens) {
            List<String> lList;
            String[] keyValue = StringUtil.split(token, "=", 2);
            if (keyValue == null) continue;
            String key = keyValue[0].toLowerCase();
            String value = keyValue[1];
            if (key == null || value == null) continue;
            if (key.startsWith("port")) {
                this.setPort(Integer.parseInt(value));
                continue;
            }
            if (key.startsWith("comp")) {
                this.setCompression(value);
                continue;
            }
            if (key.startsWith("user")) {
                this.setUser(value);
                continue;
            }
            if (key.startsWith("proj")) {
                this.setProject(Integer.parseInt(value));
                continue;
            }
            if (key.startsWith("vers")) {
                this.setVersion(value);
                continue;
            }
            if (key.startsWith("debug")) {
                this.setDebug(Boolean.parseBoolean(value));
                continue;
            }
            if (key.startsWith("trace")) {
                this.setTrace(Integer.parseInt(value));
                continue;
            }
            if (key.startsWith("band")) {
                this.setBand(value);
                continue;
            }
            if (key.startsWith("unit")) {
                this.setUnit(value);
                continue;
            }
            if (key.startsWith("group")) {
                this.setGroup(value);
                continue;
            }
            if (key.startsWith("desc")) {
                this.setDescriptor(value);
                continue;
            }
            if (key.startsWith("spac")) {
                this.setSpacing(Integer.parseInt(value));
                continue;
            }
            if (key.startsWith("linele")) {
                this.setLocateKey("LINELE");
                this.setLocate(value);
                lList = StringUtil.split(value, " ");
                this.setLocationLine(Integer.parseInt(lList.get(0)));
                this.setLocationElem(Integer.parseInt(lList.get(1)));
                continue;
            }
            if (key.startsWith("latlon")) {
                this.setLocateKey("LATLON");
                this.setLocate(value);
                lList = StringUtil.split(value, " ");
                this.setLocationLat(Double.parseDouble(lList.get(0)));
                this.setLocationLon(Double.parseDouble(lList.get(1)));
                continue;
            }
            if (key.startsWith("place")) {
                this.setPlaceValue(value);
                continue;
            }
            if (key.startsWith("size")) {
                lList = StringUtil.split(value, " ");
                this.setLines(Integer.parseInt(lList.get(0)));
                this.setElements(Integer.parseInt(lList.get(1)));
                continue;
            }
            if (key.startsWith("mag")) {
                lList = StringUtil.split(value, " ");
                this.setLineMag(Integer.parseInt(lList.get(0)));
                this.setElementMag(Integer.parseInt(lList.get(1)));
                continue;
            }
            if (key.startsWith("nav")) {
                this.setNavType(value);
                continue;
            }
            this.leftovers.add(token);
        }
    }

    public ImageDataSelectionInfo cloneMe() {
        return new ImageDataSelectionInfo(this.getURLString());
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String getCompression() {
        return this.compress;
    }

    public void setCompression(String compress) {
        this.compress = compress;
    }

    public int getProject() {
        return this.project;
    }

    public void setProject(int project) {
        this.project = project;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setBand(String band) {
        this.band = band;
    }

    public String getBand() {
        return this.band;
    }

    public void setNavType(String navType) {
        this.navType = navType;
    }

    public String getNavType() {
        return this.navType;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setPlaceValue(String placeValue) {
        this.placeValue = placeValue;
    }

    public String getPlaceValue() {
        return this.placeValue;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public void setLines(int lines) {
        this.lines = lines;
    }

    public int getLines() {
        return this.lines;
    }

    public void setElement(int elem) {
        this.elem = elem;
    }

    public int getElement() {
        return this.elem;
    }

    public void setElements(int elems) {
        this.elememts = elems;
    }

    public int getElements() {
        return this.elememts;
    }

    public void setLineMag(int lineMag) {
        this.lineMag = lineMag;
    }

    public int getLineMag() {
        return this.lineMag;
    }

    public void setElementMag(int elementMag) {
        this.elementMag = elementMag;
    }

    public int getElementMag() {
        return this.elementMag;
    }

    public void setLocationLat(double lat) {
        this.locationLat = lat;
    }

    public void setLocationLon(double lon) {
        this.locationLon = lon;
    }

    public void setLocationLine(int line) {
        this.locationLine = line;
    }

    public void setLocationElem(int elem) {
        this.locationElem = elem;
    }

    public void setLocate(String value) {
        String locKey = this.getLocateKey();
        List<String> locList = StringUtil.split(value, " ");
        if (locKey != null && locKey.equals("LINELE")) {
            this.locationLine = Integer.parseInt(locList.get(0));
            this.locationElem = Integer.parseInt(locList.get(1));
            this.locateValue = this.locationLine + " " + this.locationElem;
        } else {
            this.locationLat = Double.parseDouble(locList.get(0));
            this.locationLon = Double.parseDouble(locList.get(1));
            this.locateValue = Misc.format(this.locationLat) + " " + Misc.format(this.locationLon);
        }
    }

    public void setLocateValue(String value) {
        this.locateValue = value;
    }

    public String getLocate() {
        String locKey = this.getLocateKey();
        this.locateValue = locKey != null && locKey.equals("LINELE") ? this.locationLine + " " + this.locationElem : Misc.format(this.locationLat) + " " + Misc.format(this.locationLon);
        return this.locateValue;
    }

    public String getLocateValue() {
        return this.locateValue;
    }

    public double getLocationLat() {
        return this.locationLat;
    }

    public double getLocationLon() {
        return this.locationLon;
    }

    public int getLocationLine() {
        return this.locationLine;
    }

    public int getLocationElem() {
        return this.locationElem;
    }

    public void setTrace(int value) {
        this.trace = value;
    }

    public int getTrace() {
        return this.trace;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setUser(String value) {
        this.user = value;
    }

    public String getUser() {
        return this.user;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSizeValue() {
        return this.getLines() + " " + this.getElements();
    }

    public String getMagValue() {
        return this.getLineMag() + " " + this.getElementMag();
    }

    public void setLocateKey(String value) {
        this.locateKey = value;
    }

    public String getLocateKey() {
        return this.locateKey;
    }

    public String getURLString() {
        StringBuffer buf = new StringBuffer("adde");
        buf.append("://");
        buf.append(this.host);
        buf.append("/");
        buf.append(this.requestType);
        buf.append("?");
        this.appendKeyValue(buf, "PORT", "" + this.getPort());
        this.appendKeyValue(buf, "COMPRESS", this.getCompression());
        this.appendKeyValue(buf, "USER", this.getUser());
        this.appendKeyValue(buf, "PROJ", "" + this.getProject());
        this.appendKeyValue(buf, "VERSION", this.getVersion());
        this.appendKeyValue(buf, "DEBUG", Boolean.toString(this.getDebug()));
        this.appendKeyValue(buf, "TRACE", "" + this.getTrace());
        this.appendKeyValue(buf, "GROUP", "" + this.getGroup());
        this.appendKeyValue(buf, "DESCRIPTOR", "" + this.getDescriptor());
        this.appendKeyValue(buf, "BAND", "" + this.getBand());
        if (this.getLocateKey().equals("LINELE")) {
            this.appendKeyValue(buf, "LINELE", "" + this.getLocate());
        } else {
            this.appendKeyValue(buf, "LATLON", "" + this.getLocate());
        }
        this.appendKeyValue(buf, "PLACE", "" + this.getPlaceValue());
        this.appendKeyValue(buf, "SIZE", "" + this.getSizeValue());
        this.appendKeyValue(buf, "UNIT", "" + this.getUnit());
        this.appendKeyValue(buf, "MAG", "" + this.getMagValue());
        this.appendKeyValue(buf, "SPAC", "" + this.getSpacing());
        this.appendKeyValue(buf, "NAV", "" + this.getNavType());
        if (!this.leftovers.isEmpty()) {
            for (String leftover : this.leftovers) {
                buf.append("&");
                buf.append(leftover);
            }
        }
        return buf.toString();
    }

    protected void appendKeyValue(StringBuffer buf, String name, String value) {
        if (buf.length() == 0 || buf.charAt(buf.length() - 1) != '?') {
            buf.append("&");
        }
        buf.append(name);
        buf.append("=");
        buf.append(value);
    }
}

