/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.imagery;

import java.util.List;
import ucar.unidata.util.Misc;

public class BandInfo {
    private int bandNumber;
    private String bandDescription = null;
    private List calibrationUnits;
    private int sensorNumber;
    private String preferredUnit;

    public BandInfo() {
    }

    public BandInfo(int sensor, int band) {
        this(sensor, band, "Band " + band, null);
    }

    public BandInfo(int sensor, int band, String description) {
        this(sensor, band, description, null);
    }

    public BandInfo(int sensor, int band, String description, List units) {
        this.sensorNumber = sensor;
        this.bandNumber = band;
        this.bandDescription = description;
        this.calibrationUnits = units;
    }

    public BandInfo(BandInfo that) {
        this.sensorNumber = that.sensorNumber;
        this.bandNumber = that.bandNumber;
        this.bandDescription = that.bandDescription;
        this.calibrationUnits = that.calibrationUnits;
    }

    public void setBandNumber(int band) {
        this.bandNumber = band;
    }

    public int getBandNumber() {
        return this.bandNumber;
    }

    public void setBandDescription(String description) {
        this.bandDescription = description;
    }

    public String getBandDescription() {
        return this.bandDescription;
    }

    public void setSensor(int sensor) {
        this.sensorNumber = sensor;
    }

    public int getSensor() {
        return this.sensorNumber;
    }

    public void setCalibrationUnits(List units) {
        this.calibrationUnits = units;
    }

    public List getCalibrationUnits() {
        return this.calibrationUnits;
    }

    public void setPreferredUnit(String unit) {
        this.preferredUnit = unit;
    }

    public String getPreferredUnit() {
        return this.preferredUnit;
    }

    public String toString() {
        return this.bandDescription;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BandInfo)) {
            return false;
        }
        BandInfo that = (BandInfo)o;
        if (this == that) {
            return true;
        }
        return this.sensorNumber == that.sensorNumber && this.bandNumber == that.bandNumber && this.bandDescription.equals(that.bandDescription) && Misc.equals(this.calibrationUnits, that.calibrationUnits);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode ^= this.bandNumber;
        hashCode ^= this.sensorNumber;
        hashCode ^= this.bandDescription.hashCode();
        if (this.calibrationUnits != null) {
            hashCode ^= this.calibrationUnits.hashCode();
        }
        return hashCode;
    }

    public static int findIndexByNumber(int band, List<BandInfo> bandinfos) {
        int index = -1;
        for (int i = 0; i < bandinfos.size(); ++i) {
            BandInfo bi = bandinfos.get(i);
            if (bi.getBandNumber() != band) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int findIndexByName(String desc, List<BandInfo> bandinfos) {
        int index = -1;
        for (int i = 0; i < bandinfos.size(); ++i) {
            BandInfo bi = bandinfos.get(i);
            if (!bi.getBandDescription().equals(desc)) continue;
            index = i;
            break;
        }
        return index;
    }
}

