/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.imagery;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.adde.AddeSatBands;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSelectionComponent;
import ucar.unidata.data.imagery.AddeImageDataSource;
import ucar.unidata.data.imagery.AddeImageDescriptor;
import ucar.unidata.data.imagery.AddeImageInfo;
import ucar.unidata.data.imagery.BandInfo;
import ucar.unidata.ui.LatLonWidget;
import ucar.unidata.util.Format;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;

public class AddeImageSelection
extends DataSelectionComponent {
    private static final int MAX_SIZE = 700;
    private static final String[] ADVANCED_LABELS = new String[]{"Data Type:", "Channel:", "Placement:", "Location:", "Image Size:", "Magnification:", "Navigation Type:"};
    protected static final String PROP_LATLON = "LATLON";
    protected static final String PROP_LINELE = "LINELE";
    AreaDirectory prevPropertiesAD;
    protected static final String PROP_USER = "user";
    protected static final String DEFAULT_USER = "idv";
    protected static final String PROP_PROJ = "proj";
    protected static final String DEFAULT_PROJ = "0";
    protected static final String PROP_DESCR = "descr";
    protected static final String PROP_VERSION = "version";
    protected static final String PROP_COMPRESS = "compress";
    protected static final String PROP_PORT = "port";
    protected static final String DEFAULT_DEBUG = "false";
    protected static final String PROP_DEBUG = "debug";
    protected static final String DEFAULT_VERSION = "1";
    protected static final String PROP_SPAC = "SPAC";
    protected static final String LABEL_SELECT = " -- Select -- ";
    public static final String PROP_ADDEPORT = "adde.port";
    protected static final String DEFAULT_PORT = "112";
    private static final String ALL = "ALL";
    private static final TwoFacedObject ALLBANDS = new TwoFacedObject((Object)"All Bands", "ALL");
    private static final TwoFacedObject ALLUNITS = new TwoFacedObject((Object)"All Types", "ALL");
    private static final String PLACE_CENTER = "CENTER";
    private static final String PLACE_LLEFT = "LLEFT";
    private static final String PLACE_LRIGHT = "LRIGHT";
    private static final String PLACE_ULEFT = "ULEFT";
    private static final String PLACE_URIGHT = "URIGHT";
    private static final String PROP_BAND = "BAND";
    private static final String PROP_LOC = "LOC";
    private static final String PROP_MAG = "MAG";
    private static final String PROP_NAV = "NAV";
    private static final String PROP_PLACE = "PLACE";
    private static final String PROP_SIZE = "SIZE";
    private static final String PROP_UNIT = "UNIT";
    private static final int SLIDER_MAX = 29;
    protected static final String PROP_KEY = "key";
    private static final String[] ADVANCED_PROPS = new String[]{"UNIT", "BAND", "PLACE", "LOC", "SIZE", "MAG", "NAV"};
    private static final int DEFAULT_MAG = 0;
    private double baseNumElements = 0.0;
    private double baseNumLines = 0.0;
    private double linesToElements = 1.0;
    private Hashtable propToComps = new Hashtable();
    protected Hashtable descriptorTable;
    private boolean amSettingProperties = false;
    private AddeImageDataSource addeImageDataSource;
    protected JComboBox bandComboBox;
    protected Hashtable bandTable = new Hashtable();
    protected JTextField centerElementFld;
    private JLabel centerElementLbl;
    private JLabel centerLatLbl;
    protected JTextField centerLineFld;
    private JLabel centerLineLbl;
    private JLabel centerLonLbl;
    JLabel elementMagLbl;
    JSlider elementMagSlider;
    private JButton fullResBtn;
    protected LatLonWidget latLonWidget;
    JLabel lineMagLbl;
    JSlider lineMagSlider;
    private GuiUtils.CardLayoutPanel locationPanel;
    private JToggleButton lockBtn;
    protected JComboBox navComboBox;
    JTextField numElementsFld;
    JTextField numLinesFld;
    private String place;
    private JLabel placeLbl;
    private JPanel propPanel;
    AreaDirectory propertiesAD;
    JLabel propertiesLabel;
    JLabel sizeLbl;
    protected JComboBox descriptorComboBox;
    private List<BandInfo> bandInfos;
    protected JComboBox unitComboBox;
    private boolean useSatBandInfo = true;
    private AddeSatBands satBandInfo;
    private Hashtable sensorToBandToName;

    public AddeImageSelection(AddeImageDataSource addeImageDataSource) {
        super("Advanced");
        this.addeImageDataSource = addeImageDataSource;
    }

    @Override
    protected JComponent doMakeContents() {
        block0: {
            ArrayList bottomComps = new ArrayList();
            this.getBottomComponents(bottomComps);
            Iterator iterator = this.addeImageDataSource.getImageList().iterator();
            if (!iterator.hasNext()) break block0;
            Object o = iterator.next();
            AddeImageDescriptor d = (AddeImageDescriptor)o;
            System.out.println("---->" + d.getDirectory());
            this.setPropertiesState(d.getDirectory(), false);
            AddeImageInfo imageInfo = d.getImageInfo();
        }
        return this.propPanel;
    }

    @Override
    public void applyToDataSelection(DataSelection dataSelection) {
        this.addeImageDataSource.getImageList();
        for (Object o : this.addeImageDataSource.getImageList()) {
            AddeImageDescriptor d = (AddeImageDescriptor)o;
            d.getDirectory();
            AddeImageInfo addeImageInfo = d.getImageInfo();
        }
    }

    protected String[] getAdvancedProps() {
        return ADVANCED_PROPS;
    }

    protected String[] getAdvancedLabels() {
        return ADVANCED_LABELS;
    }

    private boolean useLatLon() {
        return this.locationPanel.getVisibleIndex() == 0;
    }

    private String translatePlace(String place) {
        if ((place = place.toUpperCase()).equals(PLACE_ULEFT)) {
            return "Upper left";
        }
        if (place.equals(PLACE_LLEFT)) {
            return "Lower left";
        }
        if (place.equals(PLACE_URIGHT)) {
            return "Upper right";
        }
        if (place.equals(PLACE_LRIGHT)) {
            return "Lower right";
        }
        if (place.equals(PLACE_CENTER)) {
            return "Center";
        }
        return place;
    }

    public void changePlace(String newPlace) {
        this.place = newPlace;
        String s = this.translatePlace(this.place) + "=";
        this.placeLbl.setText(StringUtil.padRight(s, 12));
    }

    protected JComponent addPropComp(String propId, JComponent comp) {
        Object oldComp = this.propToComps.get(propId);
        if (oldComp != null) {
            throw new IllegalStateException("Already have a component defined:" + propId);
        }
        this.propToComps.put(propId, comp);
        return comp;
    }

    private JToggleButton getLockButton() {
        if (this.lockBtn == null) {
            this.lockBtn = GuiUtils.getToggleImageButton("/auxdata/ui/icons/link.png", "/auxdata/ui/icons/link_break.png", 0, 0, true);
            this.lockBtn.setContentAreaFilled(false);
            this.lockBtn.setSelected(true);
            this.lockBtn.setToolTipText("Unlock to automatically change size when changing magnification");
        }
        return this.lockBtn;
    }

    private int getMagValue(JSlider slider) {
        int value = slider.getValue();
        if (value >= 0) {
            return value + 1;
        }
        return value - 1;
    }

    private int getLineMagValue() {
        return this.getMagValue(this.lineMagSlider);
    }

    private int getElementMagValue() {
        return this.getMagValue(this.elementMagSlider);
    }

    private void elementMagSliderChanged(boolean recomputeLineEleRatio) {
        int value = this.getElementMagValue();
        if (Math.abs(value) < 29) {
            int lineMag = this.getLineMagValue();
            this.linesToElements = lineMag > value ? Math.abs((double)lineMag / (double)value) : Math.abs((double)value / (double)lineMag);
        }
        this.elementMagLbl.setText(StringUtil.padLeft("" + value, 3));
        if (!this.getLockButton().isSelected()) {
            if (value > 0) {
                this.numElementsFld.setText("" + (int)(this.baseNumElements * (double)value));
            } else {
                this.numElementsFld.setText("" + (int)(this.baseNumElements / (double)(-value)));
            }
        }
    }

    private void lineMagSliderChanged(boolean autoSetSize) {
        try {
            int value = this.getLineMagValue();
            this.lineMagLbl.setText(StringUtil.padLeft("" + value, 3));
            if (autoSetSize) {
                if (value > 0) {
                    this.numLinesFld.setText("" + (int)(this.baseNumLines * (double)value));
                } else {
                    this.numLinesFld.setText("" + (int)(this.baseNumLines / (double)(-value)));
                }
            }
            value = value == 1 ? (this.linesToElements < 1.0 ? (int)((double)(-value) / this.linesToElements) : (int)((double)value * this.linesToElements)) : (value > 1 ? (int)((double)value * this.linesToElements) : (int)((double)value / this.linesToElements));
            value = value > 0 ? value - 1 : value + 1;
            this.amSettingProperties = true;
            this.elementMagSlider.setValue(value);
            this.amSettingProperties = false;
            this.elementMagSliderChanged(false);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void setMagSliders(int lineValue, int elementValue) {
        if (this.lineMagSlider != null) {
            if (lineValue > 0) {
                --lineValue;
            } else if (lineValue < 0) {
                ++lineValue;
            }
            if (elementValue > 0) {
                --elementValue;
            } else if (elementValue < 0) {
                ++elementValue;
            }
            this.lineMagSlider.setValue(lineValue);
            this.elementMagSlider.setValue(elementValue);
            this.lineMagLbl.setText(StringUtil.padLeft("" + this.getLineMagValue(), 3));
            this.elementMagLbl.setText(StringUtil.padLeft("" + this.getElementMagValue(), 3));
            this.linesToElements = Math.abs((double)lineValue / (double)elementValue);
            if (Double.isNaN(this.linesToElements)) {
                this.linesToElements = 1.0;
            }
        }
    }

    public void cyclePlace() {
        if (this.place.equals(PLACE_CENTER)) {
            this.changePlace(PLACE_ULEFT);
        } else {
            this.changePlace(PLACE_CENTER);
        }
    }

    public void setToFullResolution() {
        if (this.propertiesAD == null) {
            return;
        }
        this.amSettingProperties = true;
        this.numLinesFld.setText("" + this.propertiesAD.getLines());
        this.numElementsFld.setText("" + this.propertiesAD.getElements());
        this.changePlace(PLACE_CENTER);
        if (this.useLatLon()) {
            this.locationPanel.flip();
        }
        this.centerLineFld.setText("" + (this.propertiesAD.getLines() / 2 - 1));
        this.centerElementFld.setText("" + (this.propertiesAD.getElements() / 2 - 1));
        this.setMagSliders(1, 1);
        this.amSettingProperties = false;
    }

    private int getSelectedBand() {
        Object bi;
        Object object = bi = this.bandComboBox == null ? null : this.bandComboBox.getSelectedItem();
        if (bi == null || bi.equals(ALLBANDS)) {
            return 0;
        }
        return ((BandInfo)bi).getBandNumber();
    }

    private List<TwoFacedObject> getAvailableUnits(AreaDirectory ad, int band) {
        int index;
        if (ad == null) {
            return new ArrayList<TwoFacedObject>();
        }
        int[] bands = (int[])this.bandTable.get(ad);
        int n = index = bands == null ? 0 : Arrays.binarySearch(bands, band);
        if (index < 0) {
            index = 0;
        }
        Vector<TwoFacedObject> l = new Vector<TwoFacedObject>();
        Vector v = ad.getCalInfo()[index];
        TwoFacedObject tfo = null;
        int preferredUnitIndex = 0;
        String preferredUnit = this.getDefault(PROP_UNIT, "BRIT");
        if (v != null && v.size() / 2 > 0) {
            for (int i = 0; i < v.size() / 2; ++i) {
                String name = (String)v.get(2 * i);
                String desc = (String)v.get(2 * i + 1);
                desc = desc.substring(0, 1).toUpperCase() + desc.substring(1).toLowerCase();
                tfo = new TwoFacedObject((Object)desc, name);
                l.add(tfo);
                if (!name.equalsIgnoreCase(preferredUnit)) continue;
                preferredUnitIndex = i;
            }
        } else {
            l.add(new TwoFacedObject((Object)"Raw Value", "RAW"));
        }
        return l;
    }

    private void setAvailableUnits(AreaDirectory ad, int band) {
        List<TwoFacedObject> l = this.getAvailableUnits(ad, band);
        l.add(ALLUNITS);
        GuiUtils.setListData(this.unitComboBox, l);
        TwoFacedObject tfo = null;
        if (this.bandComboBox != null && this.getSelectedBand() == 0) {
            tfo = ALLUNITS;
        } else {
            String preferredUnit = "BRIT";
            tfo = TwoFacedObject.findId(preferredUnit, l);
        }
        if (tfo != null) {
            this.unitComboBox.setSelectedItem(tfo);
        }
    }

    public JComponent padLabel(String s) {
        return GuiUtils.inset((Component)new JLabel(s), new Insets(0, 5, 0, 5));
    }

    private boolean checkPropertiesEqual(AreaDirectory ad1, AreaDirectory ad2) {
        if (ad1 == null) {
            return false;
        }
        if (ad2 == null) {
            return false;
        }
        return Misc.equals(ad1, ad2) || ad1.getLines() == ad2.getLines() && ad1.getElements() == ad2.getElements() && Arrays.equals(ad1.getBands(), ad2.getBands());
    }

    private void clearPropertiesWidgets() {
        if (this.latLonWidget != null) {
            this.latLonWidget.getLatField().setText("");
            this.latLonWidget.getLonField().setText("");
        }
        if (this.centerLineFld != null) {
            this.centerLineFld.setText("");
            this.centerElementFld.setText("");
        }
        if (this.numLinesFld != null) {
            if (this.sizeLbl != null) {
                this.sizeLbl.setText("");
            }
            this.numLinesFld.setText("");
            this.numElementsFld.setText("");
        }
        if (this.unitComboBox != null) {
            GuiUtils.setListData(this.unitComboBox, new Vector());
        }
        if (this.bandComboBox != null) {
            GuiUtils.setListData(this.bandComboBox, new Vector());
        }
        this.setMagSliders(0, 0);
        if (this.placeLbl != null) {
            this.changePlace(PLACE_CENTER);
        }
        if (this.navComboBox != null) {
            this.navComboBox.setSelectedIndex(0);
        }
        this.baseNumLines = 0.0;
        this.baseNumElements = 0.0;
    }

    protected int[] getSize(AreaDirectory ad) {
        String elems;
        List<String> toks;
        this.baseNumLines = ad.getLines();
        this.baseNumElements = ad.getElements();
        String sizeDefault = this.getDefault(PROP_SIZE, null);
        List<String> list = toks = sizeDefault != null ? StringUtil.split(sizeDefault, " ", true, true) : null;
        if (toks == null || toks.size() == 0) {
            return new int[]{(int)this.baseNumLines, (int)this.baseNumElements};
        }
        String lines = "" + toks.get(0);
        if (lines.equalsIgnoreCase(ALL)) {
            lines = "" + (int)this.baseNumLines;
        }
        int numLines = new Integer(lines.trim());
        String string = elems = toks.size() > 1 ? "" + toks.get(1) : "" + (int)this.baseNumElements;
        if (elems.equalsIgnoreCase(ALL)) {
            elems = "" + this.baseNumElements;
        }
        int numElements = new Integer(elems.trim());
        return new int[]{(int)Math.min((double)numLines, this.baseNumLines), (int)Math.min((double)numElements, this.baseNumElements)};
    }

    private String getDefault(String propSize, String string) {
        return string;
    }

    private List<BandInfo> makeBandInfos(AreaDirectory ad, int[] bands) {
        ArrayList<BandInfo> l = new ArrayList<BandInfo>();
        if (ad != null && bands != null) {
            for (int i = 0; i < bands.length; ++i) {
                int band = bands[i];
                BandInfo bi = new BandInfo(ad.getSensorID(), band);
                bi.setBandDescription(this.getBandName(ad, band));
                bi.setCalibrationUnits(this.getAvailableUnits(ad, band));
                bi.setPreferredUnit(this.getDefault(PROP_UNIT, "BRIT"));
                l.add(bi);
            }
        }
        return l;
    }

    public String getSelectedDescriptor() {
        String selection = (String)this.descriptorComboBox.getSelectedItem();
        if (selection == null) {
            return null;
        }
        if (selection.equals(LABEL_SELECT)) {
            return null;
        }
        return selection;
    }

    protected String getDescriptor() {
        return this.getDescriptorFromSelection(this.getSelectedDescriptor());
    }

    protected String getDescriptorFromSelection(String selection) {
        if (this.descriptorTable == null) {
            return null;
        }
        if (selection == null) {
            return null;
        }
        return (String)this.descriptorTable.get(selection);
    }

    protected String getSelectedUnit() {
        return this.unitComboBox == null ? null : (String)((TwoFacedObject)this.unitComboBox.getSelectedItem()).getId();
    }

    protected String getPort() {
        String prop = this.addeImageDataSource.getIdv().getProperty(PROP_ADDEPORT, null);
        if (prop != null) {
            return prop;
        }
        return DEFAULT_PORT;
    }

    protected String getDefaultPropValue(String prop, AreaDirectory ad, boolean forDisplay) {
        if (prop.equals(PROP_USER)) {
            return DEFAULT_USER;
        }
        if (prop.equals(PROP_PLACE)) {
            return PLACE_CENTER;
        }
        if (prop.equals(PROP_PROJ)) {
            return DEFAULT_PROJ;
        }
        if (prop.equals(PROP_DESCR)) {
            return this.getDescriptor();
        }
        if (prop.equals(PROP_VERSION)) {
            return DEFAULT_VERSION;
        }
        if (prop.equals(PROP_COMPRESS)) {
            return "gzip";
        }
        if (prop.equals(PROP_PORT)) {
            return this.getPort();
        }
        if (prop.equals(PROP_DEBUG)) {
            return DEFAULT_DEBUG;
        }
        if (prop.equals(PROP_SIZE)) {
            if (ad != null) {
                return ad.getLines() + " " + ad.getElements();
            }
            return "700 700";
        }
        if (prop.equals(PROP_MAG)) {
            return "1 1";
        }
        if (prop.equals(PROP_LINELE)) {
            if (ad == null) {
                return "0 0";
            }
            return ad.getLines() / 2 - 1 + " " + (ad.getElements() / 2 - 1);
        }
        if (prop.equals(PROP_LOC) || prop.equals(PROP_LATLON)) {
            if (ad == null) {
                return "0 0";
            }
            return ad.getCenterLatitude() + " " + ad.getCenterLongitude();
        }
        if (prop.equals(PROP_BAND)) {
            if (forDisplay) {
                return this.getBandName(ad, ((int[])this.bandTable.get(ad))[0]);
            }
            return "" + (this.bandTable.get(ad) == null ? "" : Integer.valueOf(((int[])this.bandTable.get(ad))[0]));
        }
        if (prop.equals(PROP_SPAC)) {
            return this.getSelectedUnit() != null && this.getSelectedUnit().equalsIgnoreCase("BRIT") ? DEFAULT_VERSION : "4";
        }
        if (prop.equals(PROP_UNIT)) {
            return "X";
        }
        if (prop.equals(PROP_NAV)) {
            return "X";
        }
        return "";
    }

    private void setPropertiesState(AreaDirectory ad, boolean force) {
        if (this.amSettingProperties) {
            return;
        }
        this.prevPropertiesAD = this.propertiesAD;
        this.propertiesAD = ad;
        if (!force && this.checkPropertiesEqual(this.prevPropertiesAD, this.propertiesAD)) {
            return;
        }
        this.amSettingProperties = true;
        if (ad == null) {
            this.clearPropertiesWidgets();
            this.amSettingProperties = false;
            return;
        }
        String[] propArray = this.getAdvancedProps();
        String[] labelArray = this.getAdvancedLabels();
        if (this.numLinesFld != null) {
            int[] size = this.getSize(ad);
            this.numLinesFld.setText("" + size[0]);
            this.numElementsFld.setText("" + size[1]);
            if (this.sizeLbl != null) {
                String label = "  Raw size: " + ad.getLines() + " X " + ad.getElements();
                this.sizeLbl.setText(label);
            }
        }
        if (this.latLonWidget != null) {
            this.latLonWidget.getLatField().setText("" + ad.getCenterLatitude());
            this.latLonWidget.getLonField().setText("" + ad.getCenterLongitude());
        }
        if (this.centerLineFld != null) {
            this.centerLineFld.setText("" + ad.getLines() / 2);
            this.centerElementFld.setText("" + ad.getElements() / 2);
        }
        List<BandInfo> bandList = null;
        int[] bands = (int[])this.bandTable.get(ad);
        if (bands != null) {
            bandList = this.makeBandInfos(ad, bands);
        }
        this.bandInfos = bandList;
        if (this.bandComboBox != null) {
            List<BandInfo> comboList = bandList;
            if (bandList != null && bandList.size() > 1) {
                comboList = new ArrayList<BandInfo>();
                comboList.addAll(bandList);
                comboList.add((BandInfo)((Object)ALLBANDS));
            }
            GuiUtils.setListData(this.bandComboBox, comboList);
        }
        this.setAvailableUnits(ad, this.getSelectedBand());
        for (int propIdx = 0; propIdx < propArray.length; ++propIdx) {
            String prop = propArray[propIdx];
            String value = this.getDefault(prop, this.getDefaultPropValue(prop, ad, false));
            if (value == null) {
                value = "";
            }
            value = value.trim();
            if (prop.equals(PROP_LOC)) {
                String key = this.getDefault(PROP_KEY, PROP_LATLON);
                boolean usingLineElement = key.equals(PROP_LINELE);
                if (usingLineElement) {
                    this.locationPanel.show(1);
                } else {
                    this.locationPanel.show(0);
                }
                value = usingLineElement ? this.getDefault(PROP_LOC, this.getDefaultPropValue(PROP_LINELE, ad, false)) : this.getDefault(PROP_LOC, this.getDefaultPropValue(PROP_LATLON, ad, false));
                String[] pair = this.getPair(value);
                if (pair == null) continue;
                if (usingLineElement) {
                    this.centerLineFld.setText(pair[0]);
                    this.centerElementFld.setText(pair[1]);
                    continue;
                }
                this.latLonWidget.setLat(pair[0]);
                this.latLonWidget.setLon(pair[1]);
                continue;
            }
            if (prop.equals(PROP_BAND)) {
                if (value.equalsIgnoreCase((String)ALLBANDS.getId())) {
                    this.bandComboBox.setSelectedItem(ALLBANDS);
                    continue;
                }
                int bandNum = 0;
                try {
                    bandNum = Integer.parseInt(value);
                }
                catch (NumberFormatException usingLineElement) {
                    // empty catch block
                }
                int index = BandInfo.findIndexByNumber(bandNum, bandList);
                if (index == -1) continue;
                this.bandComboBox.setSelectedIndex(index);
                continue;
            }
            if (prop.equals(PROP_PLACE)) {
                this.changePlace(value);
                continue;
            }
            if (prop.equals(PROP_MAG)) {
                String[] pair = this.getPair(value);
                if (pair != null) {
                    this.setMagSliders(new Integer(pair[0]), new Integer(pair[1]));
                    continue;
                }
                this.setMagSliders(0, 0);
                continue;
            }
            if (!prop.equals(PROP_NAV) || this.navComboBox == null) continue;
            this.navComboBox.setSelectedIndex(value.equalsIgnoreCase("LALO") ? 1 : 0);
        }
        this.updatePropertiesLabel();
        this.amSettingProperties = false;
    }

    private String[] getPair(String v) {
        if (v == null) {
            return null;
        }
        List<String> toks = StringUtil.split(v = v.trim(), " ", true, true);
        if (toks == null || toks.size() == 0) {
            return null;
        }
        String tok1 = toks.get(0).toString();
        return new String[]{tok1, toks.size() > 1 ? toks.get(1).toString() : tok1};
    }

    private void updatePropertiesLabel() {
        if (this.propertiesLabel != null) {
            this.propertiesLabel.setText(this.getPropertiesDescription());
        }
    }

    public String getSelectedBandName() {
        return this.getBandName(this.propertiesAD, this.getSelectedBand());
    }

    private String getBandName(AreaDirectory ad, int band) {
        if (this.useSatBandInfo) {
            if (this.satBandInfo == null) {
                return "Band: " + band;
            }
            String[] descrs = this.satBandInfo.getBandDescr(ad.getSensorID(), ad.getSourceType());
            if (descrs != null && band >= 0 && band < descrs.length) {
                return descrs[band];
            }
            return "Band: " + band;
        }
        if (this.sensorToBandToName == null) {
            return "Band: " + band;
        }
        Hashtable bandToName = (Hashtable)this.sensorToBandToName.get(new Integer(ad.getSensorID()));
        String name = null;
        Integer bandInteger = new Integer(band);
        if (bandToName != null) {
            name = (String)bandToName.get(bandInteger);
        }
        if (name == null) {
            name = "Band: " + band;
        }
        return name;
    }

    protected String getPropertiesDescription() {
        StringBuffer buf = new StringBuffer();
        Object[] propArray = this.getAdvancedProps();
        List list = Misc.toList(propArray);
        if (list.contains(PROP_BAND)) {
            buf.append(this.getSelectedBandName());
            buf.append(", ");
        }
        if (list.contains(PROP_SIZE)) {
            buf.append("Size: ");
            String sizeKey = this.getUserPropValue(PROP_SIZE, this.propertiesAD);
            StringTokenizer tok = new StringTokenizer(sizeKey);
            if (tok.hasMoreTokens()) {
                String size = ((String)tok.nextElement()).trim();
                buf.append(size);
                buf.append("x");
                if (!size.equalsIgnoreCase("all")) {
                    if (tok.hasMoreTokens()) {
                        buf.append(((String)tok.nextElement()).trim());
                    } else {
                        buf.append(size);
                    }
                }
            }
        }
        return buf.toString();
    }

    protected String getUserPropValue(String prop, AreaDirectory ad) {
        Object selected;
        if (prop.equals(PROP_LATLON) && this.latLonWidget != null) {
            return Format.dfrac(this.latLonWidget.getLat(), 5) + " " + Format.dfrac(this.latLonWidget.getLon(), 5);
        }
        if (prop.equals(PROP_PLACE) && this.placeLbl != null) {
            return this.place;
        }
        if (prop.equals(PROP_LINELE) && this.centerLineFld != null) {
            return this.centerLineFld.getText().trim() + " " + this.centerElementFld.getText().trim();
        }
        if (prop.equals(PROP_SIZE) && this.numLinesFld != null) {
            return this.numLinesFld.getText().trim() + " " + this.numElementsFld.getText().trim();
        }
        if (prop.equals(PROP_MAG) && this.lineMagSlider != null) {
            return this.getLineMagValue() + " " + this.getElementMagValue();
        }
        if (prop.equals(PROP_BAND) && this.bandComboBox != null && (selected = this.bandComboBox.getSelectedItem()) != null) {
            if (selected.equals(ALLBANDS)) {
                return ALLBANDS.toString();
            }
            return "" + ((BandInfo)selected).getBandNumber();
        }
        if (prop.equals(PROP_UNIT)) {
            return this.getSelectedUnit();
        }
        if (prop.equals(PROP_NAV)) {
            return TwoFacedObject.getIdString(this.navComboBox.getSelectedItem());
        }
        return null;
    }

    protected void getBottomComponents(List bottomComps) {
        Object[] propArray = this.getAdvancedProps();
        String[] labelArray = this.getAdvancedLabels();
        Insets dfltGridSpacing = new Insets(4, 0, 4, 0);
        String dfltLblSpacing = " ";
        boolean haveBand = Misc.toList(propArray).contains(PROP_BAND);
        boolean haveNav = Misc.toList(propArray).contains(PROP_NAV);
        for (int propIdx = 0; propIdx < propArray.length; ++propIdx) {
            JComponent propComp = null;
            Object prop = propArray[propIdx];
            if (((String)prop).equals(PROP_UNIT)) {
                this.unitComboBox = new JComboBox();
                propComp = this.unitComboBox;
                this.addPropComp(PROP_UNIT, propComp);
                GuiUtils.setPreferredWidth(this.unitComboBox, 100);
                if (haveBand) {
                    this.bandComboBox = new JComboBox();
                    this.bandComboBox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AddeImageSelection.this.setAvailableUnits(AddeImageSelection.this.propertiesAD, AddeImageSelection.this.getSelectedBand());
                        }
                    });
                    this.addPropComp(PROP_BAND, this.bandComboBox);
                    propComp = GuiUtils.hbox((Component)propComp, (Component)this.padLabel("Channel:"), (Component)this.bandComboBox, 5);
                }
            } else if (!((String)prop).equals(PROP_BAND) && !((String)prop).equals(PROP_PLACE)) {
                if (((String)prop).equals(PROP_LOC)) {
                    this.placeLbl = GuiUtils.getFixedWidthLabel("");
                    this.changePlace(PLACE_CENTER);
                    this.addPropComp(PROP_PLACE, this.placeLbl);
                    this.latLonWidget = new LatLonWidget();
                    this.centerLineFld = new JTextField("", 3);
                    this.centerElementFld = new JTextField("", 3);
                    this.fullResBtn = GuiUtils.makeImageButton("/auxdata/ui/icons/arrow_out.png", this, "setToFullResolution");
                    this.fullResBtn.setContentAreaFilled(false);
                    this.fullResBtn.setToolTipText("Set to full resolution");
                    final JButton centerPopupBtn = GuiUtils.getImageButton("/auxdata/ui/icons/MapIcon16.png", this.getClass());
                    centerPopupBtn.setToolTipText("Center on current displays");
                    centerPopupBtn.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            AddeImageSelection.this.addeImageDataSource.getIdv().getIdvUIManager().popupCenterMenu(centerPopupBtn, AddeImageSelection.this.latLonWidget);
                        }
                    });
                    JPanel centerPopup = GuiUtils.inset((Component)centerPopupBtn, new Insets(0, 0, 0, 4));
                    GuiUtils.tmpInsets = dfltGridSpacing;
                    Component[] componentArray = new Component[6];
                    this.centerLatLbl = GuiUtils.rLabel(" Lat:" + dfltLblSpacing);
                    componentArray[0] = this.centerLatLbl;
                    componentArray[1] = this.latLonWidget.getLatField();
                    this.centerLonLbl = GuiUtils.rLabel(" Lon:" + dfltLblSpacing);
                    componentArray[2] = this.centerLonLbl;
                    componentArray[3] = this.latLonWidget.getLonField();
                    componentArray[4] = new JLabel(" ");
                    componentArray[5] = centerPopup;
                    JPanel latLonPanel = GuiUtils.hbox(componentArray);
                    Component[] componentArray2 = new Component[4];
                    this.centerLineLbl = GuiUtils.rLabel(" Line:" + dfltLblSpacing);
                    componentArray2[0] = this.centerLineLbl;
                    componentArray2[1] = this.centerLineFld;
                    this.centerElementLbl = GuiUtils.rLabel(" Element:" + dfltLblSpacing);
                    componentArray2[2] = this.centerElementLbl;
                    componentArray2[3] = this.centerElementFld;
                    JPanel lineElementPanel = GuiUtils.hbox(componentArray2);
                    this.locationPanel = new GuiUtils.CardLayoutPanel();
                    this.locationPanel.addCard(latLonPanel);
                    this.locationPanel.addCard(lineElementPanel);
                    JButton locPosButton = GuiUtils.makeImageButton("/auxdata/ui/icons/Refresh16.gif", this, "cyclePlace", null, true);
                    locPosButton.setToolTipText("Change place type");
                    JButton locTypeButton = GuiUtils.makeImageButton("/auxdata/ui/icons/Refresh16.gif", this.locationPanel, "flip", null, true);
                    locTypeButton.setToolTipText("Toggle between Latitude/Longitude and Line/Element");
                    propComp = GuiUtils.hbox(new Component[]{locPosButton, this.placeLbl, locTypeButton, this.locationPanel}, 5);
                    this.addPropComp(PROP_LOC, propComp);
                } else if (((String)prop).equals(PROP_MAG)) {
                    boolean oldAmSettingProperties = this.amSettingProperties;
                    this.amSettingProperties = true;
                    ChangeListener lineListener = new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent evt) {
                            if (AddeImageSelection.this.amSettingProperties) {
                                return;
                            }
                            AddeImageSelection.this.lineMagSliderChanged(!AddeImageSelection.this.getLockButton().isSelected());
                        }
                    };
                    ChangeListener elementListener = new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent evt) {
                            if (AddeImageSelection.this.amSettingProperties) {
                                return;
                            }
                            AddeImageSelection.this.elementMagSliderChanged(true);
                        }
                    };
                    JComponent[] lineMagComps = GuiUtils.makeSliderPopup(-29, 29, 0, lineListener);
                    this.lineMagSlider = (JSlider)lineMagComps[1];
                    this.lineMagSlider.setMajorTickSpacing(1);
                    this.lineMagSlider.setSnapToTicks(true);
                    this.lineMagSlider.setExtent(1);
                    lineMagComps[0].setToolTipText("Change the line magnification");
                    JComponent[] elementMagComps = GuiUtils.makeSliderPopup(-29, 29, 0, elementListener);
                    this.elementMagSlider = (JSlider)elementMagComps[1];
                    this.elementMagSlider.setExtent(1);
                    this.elementMagSlider.setMajorTickSpacing(1);
                    this.elementMagSlider.setSnapToTicks(true);
                    elementMagComps[0].setToolTipText("Change the element magnification");
                    this.lineMagSlider.setToolTipText("Slide to set line magnification factor");
                    this.lineMagLbl = GuiUtils.getFixedWidthLabel(StringUtil.padLeft(DEFAULT_VERSION, 3));
                    this.elementMagSlider.setToolTipText("Slide to set element magnification factor");
                    this.elementMagLbl = GuiUtils.getFixedWidthLabel(StringUtil.padLeft(DEFAULT_VERSION, 3));
                    this.amSettingProperties = oldAmSettingProperties;
                    GuiUtils.tmpInsets = new Insets(0, 0, 0, 0);
                    JPanel magPanel = GuiUtils.doLayout(new Component[]{this.lineMagLbl, GuiUtils.inset((Component)lineMagComps[0], new Insets(0, 4, 0, 0)), new JLabel("    X"), this.elementMagLbl, GuiUtils.inset((Component)elementMagComps[0], new Insets(0, 4, 0, 0)), GuiUtils.inset((Component)this.getLockButton(), new Insets(0, 10, 0, 0))}, 7, GuiUtils.WT_N, GuiUtils.WT_N);
                    propComp = magPanel;
                    this.addPropComp(PROP_MAG, propComp);
                    if (haveNav) {
                        this.navComboBox = new JComboBox();
                        GuiUtils.setListData(this.navComboBox, Misc.newList(new TwoFacedObject((Object)"Default", "X"), new TwoFacedObject((Object)"Lat/Lon", "LALO")));
                        this.addPropComp(PROP_NAV, this.navComboBox);
                        boolean showNav = false;
                        if (showNav) {
                            propComp = GuiUtils.hbox((Component)propComp, (Component)GuiUtils.inset((Component)new JLabel("Navigation Type:"), new Insets(0, 10, 0, 5)), (Component)this.navComboBox, 5);
                        }
                    }
                } else if (((String)prop).equals(PROP_SIZE)) {
                    this.numLinesFld = new JTextField("", 4);
                    this.numElementsFld = new JTextField("", 4);
                    this.numLinesFld.setToolTipText("Number of lines");
                    this.numElementsFld.setToolTipText("Number of elements");
                    GuiUtils.tmpInsets = dfltGridSpacing;
                    this.sizeLbl = GuiUtils.lLabel("");
                    JPanel sizePanel = GuiUtils.left(GuiUtils.doLayout(new Component[]{this.numLinesFld, new JLabel(" X "), this.numElementsFld, GuiUtils.filler(10, 1), this.fullResBtn, this.sizeLbl}, 7, GuiUtils.WT_N, GuiUtils.WT_N));
                    propComp = sizePanel;
                    this.addPropComp(PROP_SIZE, propComp);
                }
            }
            if (propComp == null) continue;
            bottomComps.add(GuiUtils.rLabel(labelArray[propIdx]));
            bottomComps.add(GuiUtils.left(propComp));
        }
        GuiUtils.tmpInsets = new Insets(3, 4, 0, 4);
        this.propPanel = GuiUtils.doLayout(bottomComps, 2, GuiUtils.WT_N, GuiUtils.WT_N);
    }
}

