/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.imagery;

import edu.wisc.ssec.mcidas.AREAnav;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ucar.unidata.data.DataChoice;
import ucar.unidata.data.DataSelection;
import ucar.unidata.data.DataSelectionComponent;
import ucar.unidata.data.GeoLocationInfo;
import ucar.unidata.data.GeoSelection;
import ucar.unidata.data.imagery.AddeImageAdvancedPanel;
import ucar.unidata.data.imagery.AddeImageDataSource;
import ucar.unidata.data.imagery.AddeImageDescriptor;
import ucar.unidata.data.imagery.AddeImagePreview;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.Misc;
import ucar.unidata.view.geoloc.NavigatedMapPanel;
import visad.VisADException;
import visad.data.mcidas.AreaAdapter;

public class AddeImagePreviewPanel
extends DataSelectionComponent {
    protected NavigatedMapPanel display;
    private AddeImagePreview imagePreview;
    GeoSelection geoSelection;
    private JPanel MasterPanel;
    private String source;
    private AreaAdapter aAdapter;
    AddeImageDescriptor descriptor;
    private JCheckBox chkUseFull;
    public String USE_DEFAULTREGION = "Use_Default_Area";
    public String USE_SELECTEDREGION = "Use_Selected_Area";
    public String USE_DISPLAYREGION = "Match_Display_Area";
    private String[] regionSubsetOptionLabels = new String[]{this.USE_DEFAULTREGION, this.USE_SELECTEDREGION, this.USE_DISPLAYREGION};
    private JComponent regionsListInfo;
    private String regionOption = this.USE_DEFAULTREGION;
    AddeImageDataSource imageDataSource;
    JComboBox regionOptionLabelBox;
    AddeImageAdvancedPanel advancedSelection;
    AREAnav baseAnav;
    int eMag;
    int lMag;

    public AddeImagePreviewPanel(AddeImageDataSource imageDataSource, AreaAdapter adapter, String source, AddeImageDescriptor descriptor, AREAnav baseAnav, AddeImageAdvancedPanel advancedSelection) throws IOException, ParseException, VisADException {
        super("Region");
        this.imageDataSource = imageDataSource;
        this.aAdapter = adapter;
        this.source = source;
        this.descriptor = descriptor;
        this.baseAnav = baseAnav;
        this.advancedSelection = advancedSelection;
        this.imagePreview = this.createImagePreview(source);
        this.display = new NavigatedMapPanel(null, true, true, this.imagePreview.getPreviewImage(), this.aAdapter.getAreaFile());
        this.eMag = imageDataSource.getEMag();
        this.lMag = imageDataSource.getLMag();
        this.chkUseFull = new JCheckBox("Use_Default_Area");
        this.chkUseFull.setSelected(true);
        this.getRegionsList();
        JScrollPane jsp = new JScrollPane();
        jsp.getViewport().setView(this.display);
        JPanel labelsPanel = null;
        labelsPanel = new JPanel();
        labelsPanel.setLayout(new BoxLayout(labelsPanel, 1));
        labelsPanel.add(this.regionsListInfo);
        this.MasterPanel = new JPanel(new BorderLayout());
        this.MasterPanel.add((Component)labelsPanel, "North");
        this.MasterPanel.add((Component)jsp, "Center");
        this.display.getNavigatedPanel().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                System.err.println("Gain");
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AddeImagePreviewPanel.this.update();
            }
        });
    }

    public JComponent getRegionsList() {
        return this.getRegionsList(this.USE_DEFAULTREGION);
    }

    public NavigatedMapPanel getNavigatedMapPanel() {
        return this.display;
    }

    public JComponent getRegionsList(String cbxLabel) {
        if (this.regionsListInfo == null) {
            this.regionsListInfo = this.makeRegionsListAndPanel(cbxLabel, null);
        }
        return this.regionsListInfo;
    }

    private JComponent makeRegionsListAndPanel(String cbxLabel, JComponent extra) {
        this.regionOptionLabelBox = new JComboBox();
        this.regionOptionLabelBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String selectedObj = (String)AddeImagePreviewPanel.this.regionOptionLabelBox.getSelectedItem();
                AddeImagePreviewPanel.this.setRegionOptions(selectedObj);
                AddeImagePreviewPanel.this.setAdvancedPanel(selectedObj);
            }
        });
        GuiUtils.enableTree(this.regionOptionLabelBox, true);
        List regionOptionNames = Misc.toList(this.regionSubsetOptionLabels);
        GuiUtils.setListData(this.regionOptionLabelBox, regionOptionNames);
        JPanel top = extra != null ? GuiUtils.leftRight(extra, this.regionOptionLabelBox) : GuiUtils.right(this.regionOptionLabelBox);
        return top;
    }

    public String getRegionOptions() {
        return (String)this.regionOptionLabelBox.getSelectedItem();
    }

    public void setRegionOptions(String selectedObject) {
        this.regionOption = selectedObject.toString();
        if (selectedObject.equals(this.USE_DEFAULTREGION)) {
            this.display.getNavigatedPanel().setSelectedRegion((LatLonRect)null);
            GeoSelection gs = this.imageDataSource.getDataSelection().getGeoSelection();
            if (gs != null) {
                gs.setBoundingBox(null);
            }
            this.display.getNavigatedPanel().setSelectRegionMode(false);
            this.display.getNavigatedPanel().repaint();
        } else if (selectedObject.equals(this.USE_SELECTEDREGION)) {
            this.display.getNavigatedPanel().setSelectRegionMode(true);
        } else if (selectedObject.equals(this.USE_DISPLAYREGION)) {
            this.display.getNavigatedPanel().setSelectedRegion((LatLonRect)null);
            this.display.getNavigatedPanel().setSelectRegionMode(false);
            this.display.getNavigatedPanel().repaint();
        }
    }

    public void setAdvancedPanel(String selectedObject) {
        this.regionOption = selectedObject.toString();
        if (selectedObject.equals(this.USE_SELECTEDREGION)) {
            this.advancedSelection.enablePanelAll(true);
            this.advancedSelection.prograssiveCbx.doClick();
        } else {
            this.advancedSelection.enablePanelAll(false);
        }
    }

    public String getRegionOption() {
        return this.regionOption;
    }

    public void setRegionOption(String option) {
        this.regionOption = option;
    }

    public void setDataChoice(DataChoice dataChoice) {
    }

    private AddeImagePreview createImagePreview(String source) throws IOException {
        int selIndex = -1;
        this.imageDataSource.getIdv().showWaitCursor();
        AddeImagePreview image = new AddeImagePreview(this.aAdapter, this.descriptor, null, 0);
        this.imageDataSource.getDataContext().getIdv().showNormalCursor();
        return image;
    }

    public String getFileName() {
        return this.source;
    }

    public AddeImagePreview getAddeImagePreview() {
        return this.imagePreview;
    }

    @Override
    protected JComponent doMakeContents() {
        return this.MasterPanel;
    }

    @Override
    public void applyToDataSelection(DataSelection dataSelection) {
        boolean hasCorner = false;
        boolean isFull = false;
        this.regionOption = this.getRegionOption();
        GeoLocationInfo gInfo = null;
        if (this.regionOption.equals("Use_Selected_Area")) {
            ProjectionRect rect = this.display.getNavigatedPanel().getSelectedRegion();
            if (rect == null) {
                dataSelection.putProperty("Region_Selection_Option", this.regionOption);
                return;
            }
            ProjectionImpl projectionImpl = this.getNavigatedMapPanel().getProjectionImpl();
            LatLonRect latLonRect = projectionImpl.projToLatLonBB(rect);
            if (latLonRect.getHeight() != latLonRect.getHeight()) {
                hasCorner = true;
                LatLonPoint cImpl = projectionImpl.projToLatLon(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0);
                LatLonPoint urImpl = projectionImpl.projToLatLon(rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight());
                LatLonPoint ulImpl = projectionImpl.projToLatLon(rect.getX(), rect.getY() + rect.getHeight());
                LatLonPoint lrImpl = projectionImpl.projToLatLon(rect.getX() + rect.getWidth(), rect.getY());
                LatLonPoint llImpl = projectionImpl.projToLatLon(rect.getX(), rect.getY());
                double maxLat = Double.NaN;
                double minLat = Double.NaN;
                double maxLon = Double.NaN;
                double minLon = Double.NaN;
                if (cImpl.getLatitude() == cImpl.getLatitude()) {
                    if (ulImpl.getLatitude() != ulImpl.getLatitude() && urImpl.getLatitude() != urImpl.getLatitude() && llImpl.getLatitude() != llImpl.getLatitude() && lrImpl.getLatitude() != lrImpl.getLatitude()) {
                        isFull = true;
                    } else if (ulImpl.getLatitude() != ulImpl.getLatitude()) {
                        maxLat = cImpl.getLatitude() + (cImpl.getLatitude() - lrImpl.getLatitude());
                        minLat = lrImpl.getLatitude();
                        maxLon = lrImpl.getLongitude();
                        minLon = cImpl.getLongitude() - (lrImpl.getLongitude() - cImpl.getLongitude());
                    } else if (urImpl.getLatitude() != urImpl.getLatitude()) {
                        maxLat = cImpl.getLatitude() + (cImpl.getLatitude() - llImpl.getLatitude());
                        minLat = llImpl.getLatitude();
                        maxLon = cImpl.getLongitude() + (cImpl.getLongitude() - lrImpl.getLongitude());
                        minLon = lrImpl.getLongitude();
                    } else if (llImpl.getLatitude() != llImpl.getLatitude()) {
                        maxLat = urImpl.getLatitude();
                        minLat = cImpl.getLatitude() - (urImpl.getLatitude() - cImpl.getLatitude());
                        maxLon = urImpl.getLongitude();
                        minLon = cImpl.getLongitude() - (urImpl.getLongitude() - cImpl.getLongitude());
                    } else if (lrImpl.getLatitude() != lrImpl.getLatitude()) {
                        maxLat = ulImpl.getLatitude();
                        minLat = cImpl.getLatitude() - (ulImpl.getLatitude() - cImpl.getLatitude());
                        maxLon = cImpl.getLongitude() + (cImpl.getLongitude() - ulImpl.getLongitude());
                        minLon = ulImpl.getLongitude();
                    }
                }
                gInfo = new GeoLocationInfo(maxLat, LatLonPointImpl.lonNormal(minLon), minLat, LatLonPointImpl.lonNormal(maxLon));
            } else {
                gInfo = new GeoLocationInfo(latLonRect);
            }
        }
        this.geoSelection = new GeoSelection(gInfo);
        if (isFull) {
            this.geoSelection.setUseFullBounds(true);
        }
        dataSelection.putProperty("Region_Selection_Option", this.regionOption);
        dataSelection.putProperty("Region_Selection_Has_Conner", hasCorner);
        dataSelection.setGeoSelection(this.geoSelection);
    }

    public void update() {
        ProjectionRect rect = this.display.getNavigatedPanel().getSelectedRegion();
        boolean hasCorner = false;
        boolean isFull = false;
        if (rect != null) {
            GeoLocationInfo gInfo;
            ProjectionImpl projectionImpl = this.display.getProjectionImpl();
            ProjectionRect projRect = new ProjectionRect(rect);
            LatLonRect latLonRect = projectionImpl.projToLatLonBB(rect);
            if (latLonRect.getHeight() != latLonRect.getHeight()) {
                LatLonPoint cImpl = projectionImpl.projToLatLon(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0);
                LatLonPoint urImpl = projectionImpl.projToLatLon(rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight());
                LatLonPoint ulImpl = projectionImpl.projToLatLon(rect.getX(), rect.getY() + rect.getHeight());
                LatLonPoint lrImpl = projectionImpl.projToLatLon(rect.getX() + rect.getWidth(), rect.getY());
                LatLonPoint llImpl = projectionImpl.projToLatLon(rect.getX(), rect.getY());
                double maxLat = Double.NaN;
                double minLat = Double.NaN;
                double maxLon = Double.NaN;
                double minLon = Double.NaN;
                if (cImpl.getLatitude() == cImpl.getLatitude()) {
                    if (ulImpl.getLatitude() != ulImpl.getLatitude() && urImpl.getLatitude() != urImpl.getLatitude() && llImpl.getLatitude() != llImpl.getLatitude() && lrImpl.getLatitude() != lrImpl.getLatitude()) {
                        isFull = true;
                    } else if (ulImpl.getLatitude() != ulImpl.getLatitude()) {
                        maxLat = cImpl.getLatitude() + (cImpl.getLatitude() - lrImpl.getLatitude());
                        minLat = lrImpl.getLatitude();
                        maxLon = lrImpl.getLongitude();
                        minLon = cImpl.getLongitude() - (lrImpl.getLongitude() - cImpl.getLongitude());
                    } else if (urImpl.getLatitude() != urImpl.getLatitude()) {
                        maxLat = cImpl.getLatitude() + (cImpl.getLatitude() - llImpl.getLatitude());
                        minLat = llImpl.getLatitude();
                        maxLon = cImpl.getLongitude() + (cImpl.getLongitude() - lrImpl.getLongitude());
                        minLon = lrImpl.getLongitude();
                    } else if (llImpl.getLatitude() != llImpl.getLatitude()) {
                        maxLat = urImpl.getLatitude();
                        minLat = cImpl.getLatitude() - (urImpl.getLatitude() - cImpl.getLatitude());
                        maxLon = urImpl.getLongitude();
                        minLon = cImpl.getLongitude() - (urImpl.getLongitude() - cImpl.getLongitude());
                    } else if (lrImpl.getLatitude() != lrImpl.getLatitude()) {
                        maxLat = ulImpl.getLatitude();
                        minLat = cImpl.getLatitude() - (ulImpl.getLatitude() - cImpl.getLatitude());
                        maxLon = cImpl.getLongitude() + (cImpl.getLongitude() - ulImpl.getLongitude());
                        minLon = ulImpl.getLongitude();
                    }
                }
                hasCorner = true;
                gInfo = new GeoLocationInfo(maxLat, LatLonPointImpl.lonNormal(minLon), minLat, LatLonPointImpl.lonNormal(maxLon));
            } else {
                gInfo = new GeoLocationInfo(latLonRect);
            }
            float[][] latlon = new float[2][1];
            latlon[1][0] = (float)gInfo.getMinLon();
            latlon[0][0] = (float)gInfo.getMaxLat();
            float[][] ulLinEle = this.baseAnav.toLinEle(latlon);
            latlon[1][0] = (float)gInfo.getMaxLon();
            latlon[0][0] = (float)gInfo.getMinLat();
            float[][] lrLinEle = this.baseAnav.toLinEle(latlon);
            int displayNum = (int)rect.getWidth();
            int lines = (int)(lrLinEle[1][0] - ulLinEle[1][0]);
            int elems = (int)(lrLinEle[0][0] - ulLinEle[0][0]);
            this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setIsFromRegionUpdate(true);
            this.imageDataSource.addeImageDataSelection.getAdvancedPanel().coordinateTypeComboBox.setSelectedIndex(0);
            if (isFull) {
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setToFullResolution(new Boolean(false));
            } else if (!hasCorner) {
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setPlace("ULEFT");
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setLatitude(gInfo.getMaxLat());
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setLongitude(gInfo.getMinLon());
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().convertToLineEle();
            } else {
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setPlace("CENTER");
                double centerLat = (gInfo.getMaxLat() + gInfo.getMinLat()) / 2.0;
                double centerLon = (gInfo.getMaxLon() + gInfo.getMinLon()) / 2.0;
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setLatitude(centerLat);
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setLongitude(centerLon);
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().convertToLineEle();
            }
            if (!isFull) {
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setNumLines(lines);
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setNumEles(elems);
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setIsFromRegionUpdate(false);
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setElementMagSlider(-Math.abs(this.eMag));
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setLineMagSlider(-Math.abs(this.lMag));
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setBaseNumElements(elems * Math.abs(this.eMag));
                this.imageDataSource.addeImageDataSelection.getAdvancedPanel().setBaseNumLines(lines * Math.abs(this.lMag));
            }
        }
    }
}

