/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.imagery;

import edu.wisc.ssec.mcidas.AreaFileException;
import edu.wisc.ssec.mcidas.Calibrator;
import java.awt.Point;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import ucar.unidata.data.imagery.AddeImageDescriptor;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.visad.MapProjectionProjection;
import visad.VisADException;
import visad.data.mcidas.AREACoordinateSystem;
import visad.data.mcidas.AreaAdapter;
import visad.meteorology.SingleBandedImageImpl;

public class AddeImagePreview {
    AddeImageDescriptor aid;
    private String[] BandNames;
    private AreaAdapter adapter;
    private int subSampledPixels;
    private int subSampledScans;
    private BufferedImage preview_image;
    private ProjectionImpl proj;
    Calibrator cali;
    int band;

    public AddeImagePreview(AreaAdapter adapter, AddeImageDescriptor aid, Calibrator cali, int band) throws IOException {
        this.adapter = adapter;
        this.aid = aid;
        this.cali = cali;
        this.band = band;
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AddeImagePreview(AreaAdapter adapter, AddeImageDescriptor aid) throws IOException {
        this.adapter = adapter;
        this.aid = aid;
        this.cali = null;
        this.band = 0;
        try {
            this.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createBufferedImage(float[][] image_data) {
        WritableRaster raster = null;
        int num_bands = 0;
        if (null != this.preview_image) {
            this.preview_image.getSampleModel().getNumBands();
        }
        if (null == this.preview_image || image_data.length != num_bands) {
            this.preview_image = image_data.length == 1 ? new BufferedImage(this.subSampledPixels, this.subSampledScans, 10) : new BufferedImage(this.subSampledPixels, this.subSampledScans, 5);
            DataBufferFloat dbuf = new DataBufferFloat(image_data, this.subSampledPixels * this.subSampledScans * image_data.length);
            BandedSampleModel sampleModel = new BandedSampleModel(0, this.subSampledPixels, this.subSampledScans, image_data.length);
            raster = Raster.createWritableRaster(sampleModel, dbuf, new Point(0, 0));
            this.preview_image.setData(raster);
        } else if (1 == num_bands) {
            this.preview_image.getRaster().setDataElements(0, 0, this.preview_image.getWidth(), this.preview_image.getHeight(), image_data[0]);
        } else if (3 == num_bands) {
            this.preview_image.getRaster().setDataElements(0, 0, this.preview_image.getWidth(), this.preview_image.getHeight(), image_data);
        }
    }

    private void init() throws IOException, VisADException, AreaFileException {
        SingleBandedImageImpl ff = (SingleBandedImageImpl)this.adapter.getImage();
        AREACoordinateSystem acs = null;
        acs = new AREACoordinateSystem(this.adapter.getAreaFile());
        this.proj = new MapProjectionProjection(acs);
        int[] ldir = this.adapter.getAreaDirectory().getDirectoryBlock();
        this.subSampledPixels = ldir[9];
        this.subSampledScans = ldir[8];
        float[][] image_data = ff.unpackFloats();
        if (this.cali != null && !this.cali.getIsPreCalibrated()) {
            float[] data1 = this.cali.calibrate(image_data[0], this.band, 5);
            float[][] data2 = new float[1][data1.length];
            data2[0] = data1;
            this.createBufferedImage(data2);
        } else {
            this.createBufferedImage(image_data);
        }
    }

    public ProjectionImpl getSampledProjection() {
        return this.proj;
    }

    public BufferedImage getPreviewImage() {
        return this.preview_image;
    }

    public int getActualScans() {
        return this.subSampledScans;
    }

    public int getActualPixels() {
        return this.subSampledPixels;
    }
}

