/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.imagery;

import edu.wisc.ssec.mcidas.adde.AddeImageURL;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import ucar.unidata.util.StringUtil;

public class AddeImageInfo
extends AddeImageURL {
    private String baseUrl;

    public AddeImageInfo() {
    }

    public AddeImageInfo(String host, String requestType, String group, String descriptor) {
        this(host, requestType, group, descriptor, null);
    }

    public AddeImageInfo(String host, String requestType, String group, String descriptor, String query) {
        super(host, requestType, group, descriptor, query);
    }

    public AddeImageInfo(String baseUrl, String locateKey, String locateValue, String placeValue, int lines, int elements, int lmag, int emag) {
        super(null, null, null, null, locateKey, locateValue, placeValue, lines, elements, lmag, emag, "X", "X", -1);
        this.baseUrl = baseUrl;
        this.decodeBaseURL(baseUrl);
    }

    public AddeImageInfo(String locateKey, String locateValue, String placeValue, int lines, int elements, int lmag, int emag) {
        super(null, null, null, null, locateKey, locateValue, placeValue, lines, elements, lmag, emag, "X", "X", -1);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String value) {
        this.baseUrl = value;
        this.decodeBaseURL(this.baseUrl);
    }

    public String makeAddeUrl() {
        return this.getURLString();
    }

    private void decodeBaseURL(String baseURL) {
        try {
            URL url = new URL(baseURL);
            this.setHost(url.getHost());
            this.setRequestType(url.getPath().substring(1).toLowerCase());
            String query = url.getQuery();
            this.setExtraKeys(query);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public void setExtraKeys(String extraKeys) {
        List<String> tokens = StringUtil.split(extraKeys, "&", true, true);
        ArrayList<String> leftovers = new ArrayList<String>();
        for (String token : tokens) {
            String[] keyValue = StringUtil.split(token, "=", 2);
            if (keyValue == null) continue;
            String key = keyValue[0].toLowerCase();
            String value = keyValue[1];
            if (key == null || value == null) continue;
            if (key.startsWith("comp")) {
                this.setCompressionFromString(value);
                continue;
            }
            if (key.startsWith("por")) {
                this.setPort(Integer.parseInt(value));
                continue;
            }
            if (key.startsWith("use")) {
                this.setUser(value);
                continue;
            }
            if (key.startsWith("proj")) {
                this.setProject(Integer.parseInt(value));
                continue;
            }
            if (key.startsWith("ver")) {
                this.setVersion(value);
                continue;
            }
            if (key.startsWith("deb")) {
                this.setDebug(value.equals("true"));
                continue;
            }
            if (key.startsWith("tra")) {
                this.setTrace(Integer.parseInt(value));
                continue;
            }
            if (key.startsWith("pos")) {
                this.setDatasetPosition(Integer.parseInt(value));
                continue;
            }
            if (key.startsWith("band")) {
                this.setBand(value);
                continue;
            }
            if (key.startsWith("uni")) {
                this.setUnit(value);
                continue;
            }
            if (key.startsWith("gro")) {
                this.setGroup(value);
                continue;
            }
            if (key.startsWith("desc")) {
                this.setDescriptor(value);
                continue;
            }
            if (key.startsWith("spac")) {
                this.setSpacing(Integer.parseInt(value));
                continue;
            }
            leftovers.add(token);
        }
        if (!leftovers.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (String leftover : leftovers) {
                buf.append("&");
                buf.append(leftover);
            }
            super.setExtraKeys(buf.toString());
        }
    }
}

