/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.data.imagery;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaDirectoryList;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import ucar.unidata.data.DataSource;
import ucar.unidata.data.imagery.AddeImageInfo;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.WrapperException;
import ucar.unidata.xml.XmlDelegate;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlPersistable;
import visad.DateTime;
import visad.VisADException;

public class AddeImageDescriptor
implements Comparable,
XmlPersistable,
XmlDelegate {
    AreaDirectory myDirectory;
    AddeImageInfo myInfo = null;
    String mySource;
    DateTime myTime = null;
    int relativeIndex = -1;
    boolean isRelative = false;

    public AddeImageDescriptor() {
    }

    public AddeImageDescriptor(int relativeIndex, AddeImageDescriptor that) {
        this.myDirectory = that.myDirectory;
        this.mySource = that.mySource;
        this.relativeIndex = relativeIndex;
        this.myInfo = that.myInfo;
        this.isRelative = true;
    }

    public AddeImageDescriptor(AddeImageDescriptor that) {
        this.myDirectory = that.myDirectory;
        this.mySource = that.mySource;
        this.isRelative = that.isRelative;
        this.relativeIndex = that.relativeIndex;
        if (that.myTime != null) {
            try {
                this.myTime = new DateTime(that.myTime);
            }
            catch (Exception exc) {
                this.myTime = that.myTime;
            }
        }
        this.myInfo = that.myInfo;
    }

    public AddeImageDescriptor(String imageSource) {
        this.mySource = imageSource;
        Pattern pattern = Pattern.compile("pos=(-?[0-9]+)");
        Matcher matcher = pattern.matcher(imageSource.toLowerCase());
        if (matcher.find()) {
            String pos = matcher.group(1);
            this.relativeIndex = Math.abs(new Integer(pos));
            this.isRelative = true;
        }
        this.processSource();
    }

    public AddeImageDescriptor(AreaDirectory directory, String imageSource) {
        this(directory, imageSource, null);
    }

    public AddeImageDescriptor(AreaDirectory directory, String imageSource, AddeImageInfo info) {
        this.myDirectory = directory;
        this.mySource = imageSource;
        this.myInfo = info;
        this.setTimeFromDirectory();
    }

    private void processSource() {
        this.myDirectory = IOUtil.isHttpProtocol(this.mySource) || this.isFromFile() ? this.processSourceAsFile(this.mySource) : this.processSourceAsAddeUrl(this.mySource);
        this.setTimeFromDirectory();
    }

    protected boolean isFromFile() {
        return new File(this.mySource).exists();
    }

    private void setTimeFromDirectory() {
        if (this.myDirectory != null) {
            try {
                this.myTime = new DateTime(this.myDirectory.getNominalTime());
            }
            catch (VisADException ve) {
                this.myTime = null;
            }
        }
    }

    protected AreaDirectory processSourceAsAddeUrl(String imageSource) {
        int imageDataIndex = imageSource.indexOf("imagedata?");
        int imageDirIndex = imageSource.indexOf("imagedir");
        if (imageDataIndex <= 0 && imageDirIndex <= 0) {
            throw new IllegalArgumentException("invalid ADDE image URL:" + imageSource);
        }
        int questionMark = imageSource.indexOf("?");
        try {
            StringBuffer buf = new StringBuffer();
            if (imageDataIndex > 0) {
                buf.append(imageSource.substring(0, imageDataIndex));
                buf.append("imagedir");
                buf.append(imageSource.substring(questionMark));
                this.mySource = imageSource;
                return (AreaDirectory)new AreaDirectoryList(buf.toString()).getDirs().get(0);
            }
            buf.append(imageSource.substring(0, imageDirIndex));
            buf.append("imagedata");
            buf.append(imageSource.substring(questionMark));
            this.mySource = buf.toString();
            return (AreaDirectory)new AreaDirectoryList(imageSource).getDirs().get(0);
        }
        catch (Exception me) {
            throw new WrapperException("Invalid ADDE URL:" + this.mySource, me);
        }
    }

    private AreaDirectory processSourceAsFile(String imageSource) {
        try {
            AreaDirectoryList adl = new AreaDirectoryList(imageSource);
            return adl.getSortedDirs()[0][0];
        }
        catch (Exception me) {
            throw new WrapperException("Invalid AREA file:" + imageSource, me);
        }
    }

    @Override
    public Element createElement(XmlEncoder encoder) {
        encoder.addDelegateForClass(AreaDirectory.class, this);
        return encoder.createElementDontCheckPersistable(this);
    }

    @Override
    public Object createObject(XmlEncoder encoder, Element element) {
        return encoder.createObjectDontCheckDelegate(element);
    }

    @Override
    public boolean initFromXml(XmlEncoder encoder, Element element) {
        return true;
    }

    @Override
    public Element createElement(XmlEncoder encoder, Object object) {
        AreaDirectory directory = (AreaDirectory)object;
        ArrayList<int[]> arguments = new ArrayList<int[]>();
        arguments.add(directory.getDirectoryBlock());
        Element result = encoder.createObjectElement(object.getClass());
        Element ctorElement = encoder.createConstructorElement(arguments);
        result.appendChild(ctorElement);
        return result;
    }

    public AreaDirectory getDirectory() {
        return this.myDirectory;
    }

    public void setDirectory(AreaDirectory d) {
        this.myDirectory = d;
        this.setTimeFromDirectory();
    }

    public String getSource() {
        return this.mySource;
    }

    public void setSource(String s) {
        this.mySource = s;
    }

    public AddeImageInfo getImageInfo() {
        return this.myInfo;
    }

    public void setImageInfo(AddeImageInfo s) {
        this.myInfo = s;
    }

    public void setIsRelative(boolean value) {
        this.isRelative = value;
    }

    public boolean getIsRelative() {
        return this.isRelative;
    }

    public void setRelativeIndex(int value) {
        this.relativeIndex = value;
    }

    public int getRelativeIndex() {
        return this.relativeIndex;
    }

    public DateTime getImageTime() {
        return this.isRelative ? null : this.myTime;
    }

    public String toString() {
        if (this.isRelative) {
            if (this.relativeIndex == 0) {
                return "Most recent image";
            }
            if (this.relativeIndex >= 0 && this.relativeIndex < DataSource.ordinalNames.length) {
                return DataSource.ordinalNames[this.relativeIndex] + " most recent";
            }
            return this.relativeIndex + 1 + "th most recent";
        }
        return this.myTime != null ? this.myTime.toString() : this.myDirectory.getNominalTime().toString();
    }

    public int compareTo(Object o) {
        AddeImageDescriptor aid = (AddeImageDescriptor)o;
        AreaDirectory ad = aid.getDirectory();
        return this.myDirectory.getNominalTime().compareTo(ad.getNominalTime());
    }

    public boolean equals(Object o) {
        if (!(o instanceof AddeImageDescriptor)) {
            return false;
        }
        AddeImageDescriptor that = (AddeImageDescriptor)o;
        return Misc.equals(that.myDirectory, this.myDirectory) && Misc.equalsIgnoreCase(this.mySource, that.mySource);
    }
}

